/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.svg;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.Writer;

public class SVGLowLevel {
    private Writer writer;
    private StringBuffer currentPath = new StringBuffer();
    private String fillOpacity = null;
    private String foreground = "#000";
    private String background = "#FFF";

    public SVGLowLevel(Writer writer, Dimension2D dimensions) throws IOException {
        this.writer = writer;
        writer.write("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        String[][] attributes = new String[][]{{"xmlns", "http://www.w3.org/2000/svg"}, {"xmlns:xlink", "http://www.w3.org/1999/xlink"}};
        this.generateStartTag("svg", attributes);
    }

    public void drawLine(double x, double y, double x2, double y2) throws IOException {
        this.startPath();
        this.moveTo(x, y);
        this.lineTo(x2, y2);
        this.drawPath();
    }

    public void startPath() {
        this.currentPath.setLength(0);
    }

    public void cubicTo(double x1, double y1, double x2, double y2, double x, double y) {
        this.currentPath.append("C ");
        this.addPathElement(x1, y1);
        this.addPathElement(x2, y2);
        this.addPathElement(x, y);
    }

    private void addPathElement(double x1, double y1) {
        this.currentPath.append(x1);
        this.currentPath.append(" ");
        this.currentPath.append(y1);
        this.currentPath.append(" ");
    }

    public void moveTo(double x, double y) {
        this.currentPath.append("M ");
        this.addPathElement(x, y);
    }

    public void lineTo(double x, double y) {
        this.currentPath.append("L ");
        this.addPathElement(x, y);
    }

    public void quadTo(double x1, double y1, double x, double y) {
        this.currentPath.append("Q ");
        this.addPathElement(x1, y1);
        this.addPathElement(x, y);
    }

    public void drawPath() throws IOException {
        String[][] attributes = new String[][]{{"d", this.currentPath.toString()}, {"style", "fill:none;stroke:" + this.foreground}};
        this.generateClosedTag("path", attributes);
        this.currentPath.setLength(0);
    }

    public void fillPath() throws IOException {
        if (!this.currentPath.toString().endsWith("Z")) {
            this.currentPath.append("Z");
        }
        String[][] attributes = new String[][]{{"d", this.currentPath.toString()}, {"style", this.buildFillStyle()}};
        this.generateClosedTag("path", attributes);
        this.currentPath.setLength(0);
    }

    private String buildFillStyle() {
        String style = "fill:" + this.foreground + ";stroke:none";
        if (this.fillOpacity != null) {
            style = style + ";fill-opacity:" + this.fillOpacity;
        }
        return style;
    }

    public void close() throws IOException {
        this.generateEndTag("svg");
        this.writer.close();
    }

    private void generateStartTag(String name, String[][] attributes) throws IOException {
        this.generateStartTag(name, attributes, false);
    }

    private void generateClosedTag(String name, String[][] attributes) throws IOException {
        this.generateStartTag(name, attributes, true);
    }

    private void generateStartTag(String name, String[][] attributes, boolean closedTag) throws IOException {
        this.writer.write("<" + name);
        if (attributes != null && attributes.length != 0) {
            this.writer.write(" ");
            for (int i = 0; i < attributes.length; ++i) {
                this.writer.write(attributes[i][0]);
                this.writer.write("='");
                this.writer.write(attributes[i][1]);
                this.writer.write("' ");
            }
        }
        if (closedTag) {
            this.writer.write("/");
        }
        this.writer.write(">");
    }

    private void generateEndTag(String name) throws IOException {
        this.writer.write("</" + name + ">");
    }

    public void closePath() {
        this.currentPath.append("Z");
    }

    public void setForeground(int red, int green, int blue, int alpha) {
        this.foreground = this.toColor(red, green, blue);
        this.fillOpacity = alpha == 255 ? null : "" + (double)alpha / 255.0;
    }

    private String toColor(int red, int green, int blue) {
        String color = red == 0 && green == 0 && blue == 0 ? "black cmyk(0, 0, 0, 100)" : (red == 255 && green == 0 && blue == 0 ? "red cmyk(0,100,100,0)" : "#" + this.buildColorComponent(red) + this.buildColorComponent(green) + this.buildColorComponent(blue));
        return color;
    }

    private String buildColorComponent(int component) {
        String s = Integer.toHexString(component);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public void setBackground(int red, int green, int blue, int alpha) {
        this.background = this.toColor(red, green, blue);
    }
}

