/*
 * Decompiled with CFR 0.152.
 */
package addShowRefs;

import addShowRefs.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import lib.database.References;

public class EditAddRefs
extends JFrame {
    private References r = null;
    private boolean finished;
    private String theKey;
    private Dimension windowSize = new Dimension(400, 280);
    private static final String nl = System.getProperty("line.separator");
    private JButton jButtonQuit;
    private JButton jButtonSave;
    private JLabel jLabel0;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelFileName;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane;
    private JTextArea jTextArea;
    private JTextField jTextFieldKey;

    public EditAddRefs(References r0) {
        this.initComponents();
        this.r = r0;
        this.finished = false;
        this.jTextArea.setWrapStyleWord(true);
        KeyStroke ctrlSKeyStroke = KeyStroke.getKeyStroke(83, 2, false);
        this.getRootPane().getInputMap(2).put(ctrlSKeyStroke, "CTRL_S");
        AbstractAction ctrlSAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditAddRefs.this.jButtonSave.doClick();
            }
        };
        this.getRootPane().getActionMap().put("CTRL_S", ctrlSAction);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point frameLocation = new Point(-1000, -1000);
        frameLocation.x = Math.max(0, (screenSize.width - this.getWidth()) / 2);
        frameLocation.y = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        this.setLocation(frameLocation);
        this.setTitle("Save a reference");
        String iconName = "images/Refs.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            String errmsg = "Error: Could not load image = \"" + iconName + "\"";
            System.out.println(errmsg);
            Main.ErrMsgBx mb = new Main.ErrMsgBx(errmsg, "Edit-Add-References");
        }
        this.theKey = "";
    }

    public void start() {
        this.setTitle("Show references");
        this.jTextFieldKey.setText("");
        String t = this.r.referencesFileName();
        if (t == null) {
            JOptionPane.showMessageDialog(this, "No reference file!?", "Add References", 0);
            this.jButtonQuit.doClick();
            return;
        }
        this.jLabelFileName.setText(t);
        this.windowSize = this.getSize();
    }

    public void start(String key, String ref) {
        this.setTitle("Edit reference");
        if (key == null || key.trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "No key!?", "Edit Reference", 0);
            this.jButtonQuit.doClick();
            return;
        }
        if (ref == null || ref.trim().length() <= 0) {
            ref = "";
        }
        this.jTextFieldKey.setText(key);
        this.jTextFieldKey.setEditable(false);
        this.jTextFieldKey.setBackground(Color.LIGHT_GRAY);
        this.jTextArea.setText(ref);
        this.jTextArea.setCaretPosition(0);
        String t = this.r.referencesFileName();
        if (t == null) {
            JOptionPane.showMessageDialog(this, "No reference file!?", "Edit Reference", 0);
            this.jButtonQuit.doClick();
            return;
        }
        this.jLabelFileName.setText(t);
        this.windowSize = this.getSize();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel0 = new JLabel();
        this.jLabelFileName = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldKey = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonQuit = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditAddRefs.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                EditAddRefs.this.formComponentResized(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel0.setFont(new Font("Dialog", 0, 11));
        this.jLabel0.setText("Reference file:");
        this.jPanel1.add((Component)this.jLabel0, "North");
        this.jLabelFileName.setFont(new Font("Dialog", 1, 11));
        this.jLabelFileName.setText("jLabel4");
        this.jPanel1.add((Component)this.jLabelFileName, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 12, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jPanel2.setLayout(new BorderLayout());
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setLabelFor(this.jTextFieldKey);
        this.jLabel1.setText("Reference Key:");
        this.jPanel2.add((Component)this.jLabel1, "North");
        this.jTextFieldKey.setFont(new Font("Dialog", 0, 11));
        this.jPanel2.add((Component)this.jTextFieldKey, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 13, 5);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setFont(new Font("Dialog", 0, 11));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setLabelFor(this.jTextArea);
        this.jLabel2.setText("Reference contents:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane.setFont(new Font("Monospaced", 0, 13));
        this.jTextArea.setColumns(20);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setRows(5);
        this.jScrollPane.setViewportView(this.jTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setFont(new Font("Dialog", 0, 11));
        this.jPanel4.setLayout(new BorderLayout());
        this.jButtonSave.setFont(new Font("Dialog", 0, 11));
        this.jButtonSave.setMnemonic('s');
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditAddRefs.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonSave, "West");
        this.jButtonQuit.setFont(new Font("Dialog", 0, 11));
        this.jButtonQuit.setMnemonic('q');
        this.jButtonQuit.setText("Quit");
        this.jButtonQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditAddRefs.this.jButtonQuitActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonQuit, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 5);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonQuitActionPerformed(ActionEvent evt) {
        this.quitFrame();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.jTextFieldKey.getText() == null || this.jTextFieldKey.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Error:" + nl + "Reference Key may not be empty!", "Save References", 0);
            return;
        }
        String key = this.jTextFieldKey.getText().trim();
        String newRef = this.jTextArea.getText();
        if (!this.r.readRefsFile(this.jLabelFileName.getText(), false)) {
            System.out.println("Properties not loaded from file \"" + this.jLabelFileName.getText() + "\"" + nl + "quitting ...");
            return;
        }
        if (newRef == null || newRef.trim().length() <= 0) {
            String oldRef = this.r.isRefThere(key);
            if (oldRef != null) {
                Object[] opt;
                String msg = "Delete existing reference?" + nl + nl + key + " = " + oldRef + nl + " ";
                int m = JOptionPane.showOptionDialog(this, msg, "Save References", 0, 2, null, opt = new Object[]{"Yes", "Cancel"}, opt[1]);
                if (m != 0) {
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, "No reference text to save", "Save References", 3);
                return;
            }
            newRef = null;
        } else {
            Object[] opt;
            String msg;
            int m;
            newRef = newRef.trim();
            String found = this.r.isRefThere(key);
            if (found != null && found.trim().length() >= 0 && (m = JOptionPane.showOptionDialog(this, msg = "Replace reference?" + nl + nl, "Save References", 0, 2, null, opt = new Object[]{"Yes", "Cancel"}, opt[1])) != 0) {
                return;
            }
        }
        this.r.setRef(key, newRef);
        this.r.saveRefsFile(this, false);
        this.theKey = key;
        this.jTextFieldKey.setText("");
        this.jTextArea.setText("");
        this.jButtonQuit.doClick();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.quitFrame();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void quitFrame() {
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized String waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.theKey;
    }
}

