/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.readWriteDataFiles;

import java.io.PrintStream;
import java.util.Locale;
import lib.common.Util;
import lib.kemi.chem.Chem;
import lib.kemi.readDataLib.ReadDataLib;

public class ReadChemSyst {
    private static Locale engl = Locale.ENGLISH;
    private static String nl = System.getProperty("line.separator");
    private static final String LINE = "-------------------------------------";

    public static Chem readChemSystAndPlotInfo(ReadDataLib rd, boolean dbg, boolean warn, PrintStream out) throws DataLimitsException, ReadDataFileException, PlotDataException, ConcDataException {
        String ideC;
        int found;
        String tmpUC;
        String tmp0;
        double w;
        int solidC;
        int nrSol;
        int nx;
        int na;
        if (out == null) {
            out = System.out;
        }
        if (dbg) {
            out.println("Reading the chemical system...");
        }
        rd.nowReading = "Nbr of components (Na)";
        try {
            na = rd.readI();
        }
        catch (ReadDataLib.DataReadException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        catch (ReadDataLib.DataEofException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        if (na < 1 || na > 1000) {
            throw new DataLimitsException("Error: Number of components is: " + na + nl + "  must be >0 and <1000." + nl + "  Reading data file:" + nl + "  \"" + rd.dataFileName + "\"");
        }
        rd.nowReading = "Nbr of complexes (Nx)";
        try {
            nx = rd.readI();
        }
        catch (ReadDataLib.DataReadException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        catch (ReadDataLib.DataEofException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        if (nx < 0 || nx > 1000000) {
            throw new DataLimitsException("Error: Number of soluble complexes is: " + nx + nl + "  must be >=0 and < 1 000 000." + nl + "  Reading data file:" + nl + "  \"" + rd.dataFileName + "\"");
        }
        rd.nowReading = "Nbr of solid reaction products (nrSol)";
        try {
            nrSol = rd.readI();
        }
        catch (ReadDataLib.DataReadException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        catch (ReadDataLib.DataEofException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        if (nrSol < 0 || nrSol > 100000) {
            throw new DataLimitsException("Error: Number of solid reaction products is: " + nrSol + nl + "  must be >=0 and < 100 000." + nl + "  Reading data file:" + nl + "  \"" + rd.dataFileName + "\"");
        }
        rd.nowReading = "Nbr of solid components (solidC)";
        try {
            solidC = rd.readI();
        }
        catch (ReadDataLib.DataReadException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        catch (ReadDataLib.DataEofException ex) {
            throw new ReadDataFileException("Error: " + ex.getMessage());
        }
        if (solidC < 0 || solidC > na) {
            throw new DataLimitsException("Error: Number of solid components is: " + solidC + nl + "  must be >=0 and <= " + na + " (the nbr of components)." + nl + "  Reading data file:" + nl + "  \"" + rd.dataFileName + "\"");
        }
        int mSol = solidC + nrSol;
        int ms = na + nx + mSol;
        int mg = na + nx;
        Chem ch = null;
        try {
            ch = new Chem(na, ms, mSol);
        }
        catch (Chem.ChemicalParameterException ex) {
            throw new DataLimitsException(ex.getMessage());
        }
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.DiagrConcs dgrC = ch.diagrConcs;
        Chem.Diagr diag = ch.diag;
        cs.solidC = solidC;
        for (int ia = 0; ia < cs.Na; ++ia) {
            rd.nowReading = "Name  of component nbr " + String.valueOf(ia + 1);
            try {
                namn.identC[ia] = rd.readA();
            }
            catch (ReadDataLib.DataReadException ex) {
                throw new ReadDataFileException("Error: " + ex.getMessage());
            }
            catch (ReadDataLib.DataEofException ex) {
                throw new ReadDataFileException("Error: " + ex.getMessage());
            }
            namn.comment[ia] = rd.dataLineComment.toString();
        }
        diag.databaseSpanaFile = rd.DatabaseSpanaFile;
        double[] temp = new double[cs.Na];
        int i = -1;
        int shift = cs.Na;
        do {
            String identTemp;
            if (++i < cs.Na) {
                namn.ident[i] = namn.identC[i];
                continue;
            }
            if (i >= cs.Ms - solidC) {
                int ic = cs.Na - (cs.Ms - i);
                namn.ident[i] = namn.identC[ic];
                continue;
            }
            String species = "solid";
            if (i < mg) {
                species = "soluble";
            }
            rd.nowReading = "Name of " + species + " reaction product " + String.valueOf(i + 1);
            try {
                identTemp = rd.readA();
            }
            catch (ReadDataLib.DataReadException ex) {
                throw new ReadDataFileException("Error: " + ex.getMessage());
            }
            catch (ReadDataLib.DataEofException ex) {
                throw new ReadDataFileException("Error: " + ex.getMessage());
            }
            String comment = rd.dataLineComment.toString();
            rd.nowReading = "Formation Equilibrium Constant for " + species + " complex \"" + identTemp + "\"";
            try {
                w = rd.readD();
            }
            catch (ReadDataLib.DataReadException ex) {
                throw new ReadDataFileException("Error: " + ex.getMessage());
            }
            catch (ReadDataLib.DataEofException ex) {
                throw new ReadDataFileException("Error: " + ex.getMessage());
            }
            for (int ia = 0; ia < cs.Na; ++ia) {
                rd.nowReading = "Stoichiometric coeff. " + String.valueOf(ia + 1) + " for " + species + " complex \"" + identTemp + "\"";
                try {
                    temp[ia] = rd.readD();
                    continue;
                }
                catch (ReadDataLib.DataReadException ex) {
                    throw new ReadDataFileException("Error: " + ex.getMessage());
                }
                catch (ReadDataLib.DataEofException ex) {
                    throw new ReadDataFileException("Error: " + ex.getMessage());
                }
            }
            namn.ident[i] = identTemp;
            if (!Util.stringsEqual(comment, rd.dataLineComment.toString())) {
                comment = comment + rd.dataLineComment.toString();
            } else if (comment == null || comment.length() <= 0) {
                comment = rd.dataLineComment.toString();
            }
            namn.comment[i] = comment;
            int ki = i - shift;
            cs.lBeta[ki] = w;
            System.arraycopy(temp, 0, cs.a[ki], 0, cs.Na);
        } while (i < cs.Ms - 1);
        ReadChemSyst.addFictiveSolids(cs);
        for (i = 0; i < cs.Na; ++i) {
            if (!Util.isWater(namn.identC[i])) continue;
            cs.jWater = i;
        }
        boolean canBePredomFile = false;
        if (dbg) {
            out.println("Reading plot definition...");
        }
        diag.inputYMinMax = false;
        diag.Eh = false;
        diag.plotType = -1;
        diag.yLow = Double.MAX_VALUE;
        diag.yHigh = Double.MIN_VALUE;
        diag.oneArea = -1;
        while (true) {
            rd.nowReading = "Plot information for the Y-axis";
            try {
                tmp0 = rd.readA();
            }
            catch (ReadDataLib.DataReadException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                diag.plotType = -1;
                return ch;
            }
            catch (ReadDataLib.DataEofException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                diag.plotType = -1;
                return ch;
            }
            if (!tmp0.equalsIgnoreCase("EH") && !tmp0.equalsIgnoreCase("ONE AREA")) break;
            if (tmp0.equalsIgnoreCase("EH")) {
                diag.Eh = true;
                continue;
            }
            rd.nowReading = "Species name to be plotted as \"One Area\"";
            try {
                tmp0 = rd.readA();
            }
            catch (ReadDataLib.DataReadException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                diag.plotType = -1;
                return ch;
            }
            catch (ReadDataLib.DataEofException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                diag.plotType = -1;
                return ch;
            }
            tmpUC = tmp0.toUpperCase();
            if (tmpUC.startsWith("*")) {
                tmpUC = tmpUC.substring(1);
            }
            found = -1;
            for (i = 0; i < cs.Ms; ++i) {
                ideC = namn.ident[i];
                if (ideC.startsWith("*")) {
                    ideC = ideC.substring(1);
                }
                if (!tmpUC.equalsIgnoreCase(ideC)) continue;
                found = i;
                break;
            }
            if (found < 0) {
                String errMsg = "Error in data file:" + nl + "  \"" + rd.dataFileName + "\"" + nl + "\"One Area\" given, but \"" + tmp0 + "\" is NOT a species.";
                out.println(LINE + nl + errMsg);
                ReadChemSyst.printDescriptionYaxis(namn.identC, out);
                if (!warn) {
                    throw new PlotDataException(errMsg);
                }
                diag.plotType = -1;
                return ch;
            }
            diag.oneArea = found;
        }
        diag.plotType = -1;
        diag.compX = -1;
        diag.compY = -1;
        diag.compMain = -1;
        found = -1;
        String ide = tmp0;
        if (ide.startsWith("*")) {
            ide = ide.substring(1);
        }
        for (i = 0; i < cs.Na; ++i) {
            ideC = namn.identC[i];
            if (ideC.startsWith("*")) {
                ideC = ideC.substring(1);
            }
            if (!ide.equalsIgnoreCase(ideC)) continue;
            found = i;
            break;
        }
        if (found >= 0) {
            diag.plotType = 1;
            diag.compY = found;
        } else {
            tmpUC = tmp0.toUpperCase();
            if (tmpUC.equals("S")) {
                diag.plotType = 2;
            } else if (tmpUC.equals("LS")) {
                diag.plotType = 2;
                diag.inputYMinMax = true;
            } else if (tmpUC.equals("L")) {
                diag.plotType = 3;
            } else if (tmpUC.equals("LC")) {
                diag.plotType = 3;
                diag.inputYMinMax = true;
            } else if (tmpUC.equals("LAC")) {
                diag.plotType = 7;
                diag.inputYMinMax = true;
            } else if (tmpUC.equals("PE")) {
                diag.plotType = 5;
                diag.inputYMinMax = true;
            } else if (tmpUC.equals("PH")) {
                diag.plotType = 6;
                diag.inputYMinMax = true;
            } else if (tmpUC.equals("R")) {
                diag.plotType = 4;
                diag.inputYMinMax = true;
                rd.nowReading = "Reference species name for a relative activity diagram";
                try {
                    tmp0 = rd.readA();
                }
                catch (ReadDataLib.DataReadException ex) {
                    if (!warn) {
                        throw new PlotDataException("Error: " + ex.getMessage());
                    }
                    diag.plotType = -1;
                    return ch;
                }
                catch (ReadDataLib.DataEofException ex) {
                    if (!warn) {
                        throw new PlotDataException("Error: " + ex.getMessage());
                    }
                    diag.plotType = -1;
                    return ch;
                }
                tmpUC = tmp0.toUpperCase();
                if (tmpUC.startsWith("*")) {
                    tmpUC = tmpUC.substring(1);
                }
                found = -1;
                for (i = 0; i < cs.Ms; ++i) {
                    ideC = namn.ident[i];
                    if (ideC.startsWith("*")) {
                        ideC = ideC.substring(1);
                    }
                    if (!tmpUC.equalsIgnoreCase(ideC)) continue;
                    found = i;
                    break;
                }
                if (found < 0) {
                    String errMsg = "Error in data file:" + nl + "  \"" + rd.dataFileName + "\"" + nl + "Relative diagram, but \"" + tmp0 + "\" is NOT a species.";
                    out.println(LINE + nl + errMsg);
                    ReadChemSyst.printDescriptionYaxis(namn.identC, out);
                    if (!warn) {
                        throw new PlotDataException(errMsg);
                    }
                    diag.plotType = -1;
                    return ch;
                }
                diag.compY = found;
            } else if (tmpUC.equals("PS")) {
                diag.plotType = 8;
                diag.Hplus = -1;
                for (i = 0; i < cs.Na; ++i) {
                    ideC = namn.ident[i];
                    if (ideC.startsWith("*")) {
                        ideC = ideC.substring(1);
                    }
                    if (!Util.isProton(ideC)) continue;
                    diag.Hplus = i;
                    break;
                }
                if (diag.Hplus < 0) {
                    String errMsg = "Error in data file:" + nl + "  \"" + rd.dataFileName + "\"" + nl + "H-affinity diagram but no \"H+\" component found.";
                    out.println(LINE + nl + errMsg);
                    ReadChemSyst.printDescriptionYaxis(namn.identC, out);
                    if (!warn) {
                        throw new PlotDataException(errMsg);
                    }
                    diag.plotType = -1;
                    return ch;
                }
                diag.OHmin = -1;
                for (i = 0; i < cs.Ms; ++i) {
                    if (!namn.ident[i].equalsIgnoreCase("OH-") && !namn.ident[i].equalsIgnoreCase("OH -")) continue;
                    diag.OHmin = i;
                    break;
                }
            }
        }
        if (diag.plotType <= 0) {
            String errMsg = "Error in data file:" + nl + "  \"" + rd.dataFileName + "\"" + nl + "\"" + tmp0 + "\" is NOT a valid description for the variable in Y-axis.";
            out.println(LINE + nl + errMsg);
            ReadChemSyst.printDescriptionYaxis(namn.identC, out);
            if (!warn) {
                throw new PlotDataException(errMsg);
            }
            diag.plotType = -1;
            return ch;
        }
        if (diag.plotType == 1) {
            canBePredomFile = true;
        } else if (diag.plotType > 1) {
            canBePredomFile = false;
        }
        if (diag.inputYMinMax) {
            rd.nowReading = "Minimum value for the Y-axis";
            try {
                diag.yLow = rd.readD();
            }
            catch (ReadDataLib.DataReadException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                out.println(LINE + nl + "Error: " + ex.getMessage());
                diag.plotType = -1;
                return ch;
            }
            catch (ReadDataLib.DataEofException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                out.println(LINE + nl + "Error: " + ex.getMessage());
                diag.plotType = -1;
                return ch;
            }
            rd.nowReading = "Maximum value for the Y-axis";
            try {
                diag.yHigh = rd.readD();
            }
            catch (ReadDataLib.DataReadException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                out.println(LINE + nl + "Error: " + ex.getMessage());
                diag.plotType = -1;
                return ch;
            }
            catch (ReadDataLib.DataEofException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                out.println(LINE + nl + "Error: " + ex.getMessage());
                diag.plotType = -1;
                return ch;
            }
            w = Math.abs(diag.yLow - diag.yHigh);
            double y = Math.max(Math.abs(diag.yHigh), Math.abs(diag.yLow));
            if (y != 0.0 && w / y < 1.0E-6 || w < 1.0E-6) {
                String msg = "Error in data file:" + nl + "  \"" + rd.dataFileName + "\"" + nl + "Min-value = Max-value  in Y-axis !";
                if (!warn) {
                    throw new PlotDataException(msg);
                }
                out.println(LINE + nl + msg);
                diag.plotType = -1;
                return ch;
            }
            if (diag.yLow > diag.yHigh) {
                w = diag.yLow;
                diag.yLow = diag.yHigh;
                diag.yHigh = w;
            }
        }
        while (true) {
            rd.nowReading = "Plot information for the X-axis (a component name)";
            try {
                tmp0 = rd.readA();
            }
            catch (ReadDataLib.DataReadException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                out.println(LINE + nl + "Error: " + ex.getMessage());
                diag.plotType = -1;
                return ch;
            }
            catch (ReadDataLib.DataEofException ex) {
                if (!warn) {
                    throw new PlotDataException("Error: " + ex.getMessage());
                }
                out.println(LINE + nl + "Error: " + ex.getMessage());
                diag.plotType = -1;
                return ch;
            }
            if (!tmp0.equalsIgnoreCase("EH")) break;
            diag.Eh = true;
        }
        found = -1;
        ide = tmp0;
        if (ide.startsWith("*")) {
            ide = ide.substring(1);
        }
        for (i = 0; i < cs.Na; ++i) {
            ideC = namn.identC[i];
            if (ideC.startsWith("*")) {
                ideC = ideC.substring(1);
            }
            if (!ide.equalsIgnoreCase(ideC)) continue;
            found = i;
            break;
        }
        if (found < 0) {
            String errMsg = "Error in data file:" + nl + "  \"" + rd.dataFileName + "\"" + nl + "\"" + tmp0 + "\" is neither a component for the X-axis, nor \"EH\".";
            out.println(LINE + nl + errMsg);
            ReadChemSyst.printDescriptionXaxis(namn.identC, out);
            if (!warn) {
                throw new PlotDataException(errMsg);
            }
            diag.plotType = -1;
            return ch;
        }
        diag.compX = found;
        if (canBePredomFile) {
            while (true) {
                rd.nowReading = "Either the main component name for a Predom diagram, or" + nl + "conc. data for component nbr 1 (" + namn.identC[0] + ")";
                try {
                    tmp0 = rd.readA();
                }
                catch (ReadDataLib.DataReadException ex) {
                    if (!warn) {
                        throw new PlotDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                catch (ReadDataLib.DataEofException ex) {
                    if (!warn) {
                        throw new PlotDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                if (!tmp0.equalsIgnoreCase("EH")) break;
                diag.Eh = true;
            }
            found = -1;
            ide = tmp0;
            if (ide.startsWith("*")) {
                ide = ide.substring(1);
            }
            for (i = 0; i < cs.Na; ++i) {
                ideC = namn.identC[i];
                if (ideC.startsWith("*")) {
                    ideC = ideC.substring(1);
                }
                if (!ide.equalsIgnoreCase(ideC)) continue;
                found = i;
                break;
            }
            if (found >= 0) {
                diag.plotType = 0;
                diag.compMain = found;
                tmp0 = null;
            }
        } else {
            tmp0 = null;
        }
        if (dbg) {
            out.println("Reading the concentrations for each component...");
        }
        dgrC.hur = new int[cs.Na];
        for (int ia = 0; ia < cs.Na; ++ia) {
            String t;
            dgrC.hur[ia] = -1;
            if (tmp0 == null) {
                rd.nowReading = "Concentration type for component nbr " + String.valueOf(ia + 1) + " (" + namn.identC[ia] + ")";
                try {
                    tmp0 = rd.readA();
                }
                catch (ReadDataLib.DataReadException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                catch (ReadDataLib.DataEofException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
            }
            if (tmp0.equalsIgnoreCase("T")) {
                dgrC.hur[ia] = 1;
            }
            if (tmp0.equalsIgnoreCase("TV")) {
                dgrC.hur[ia] = 2;
            }
            if (tmp0.equalsIgnoreCase("LTV")) {
                dgrC.hur[ia] = 3;
            }
            if (tmp0.equalsIgnoreCase("LA")) {
                dgrC.hur[ia] = 4;
            }
            if (tmp0.equalsIgnoreCase("LAV")) {
                dgrC.hur[ia] = 5;
            }
            if (dgrC.hur[ia] <= 0) {
                String msg = "Error in data file:" + nl + "  \"" + rd.dataFileName + "\"" + nl + "\"" + tmp0 + "\" is NOT any of: T,TV,LTV,LA or LAV." + nl + "  Reading concentration data for component nbr " + String.valueOf(ia + 1) + " (" + namn.identC[ia] + ")";
                if (!warn) {
                    throw new ConcDataException(msg);
                }
                out.println(LINE + nl + msg);
                diag.plotType = -1;
                return ch;
            }
            if (dgrC.hur[ia] == 1 || dgrC.hur[ia] == 4) {
                t = dgrC.hur[ia] == 1 ? "total conc." : "log(activity)";
                rd.nowReading = "The value for the " + t + " for component nbr " + String.valueOf(ia + 1) + " (" + namn.identC[ia] + ")";
                try {
                    dgrC.cLow[ia] = rd.readD();
                }
                catch (ReadDataLib.DataReadException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                catch (ReadDataLib.DataEofException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                dgrC.cHigh[ia] = Double.NaN;
            } else {
                t = dgrC.hur[ia] == 2 ? "total conc." : (dgrC.hur[ia] == 3 ? "log(tot.conc.)" : "log(activity)");
                rd.nowReading = "The lowest value for the " + t + " for component nbr " + String.valueOf(ia + 1) + " (" + namn.identC[ia] + ")";
                try {
                    dgrC.cLow[ia] = rd.readD();
                }
                catch (ReadDataLib.DataReadException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                catch (ReadDataLib.DataEofException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                rd.nowReading = "The highest value for the " + t + " for component nbr " + String.valueOf(ia + 1) + " (" + namn.identC[ia] + ")";
                try {
                    dgrC.cHigh[ia] = rd.readD();
                }
                catch (ReadDataLib.DataReadException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
                catch (ReadDataLib.DataEofException ex) {
                    if (!warn) {
                        throw new ConcDataException("Error: " + ex.getMessage());
                    }
                    out.println(LINE + nl + "Error: " + ex.getMessage());
                    diag.plotType = -1;
                    return ch;
                }
            }
            tmp0 = null;
        }
        rd.nowReading = "Diagram title";
        try {
            diag.title = rd.readLine();
        }
        catch (ReadDataLib.DataEofException ex) {
            diag.title = null;
        }
        catch (ReadDataLib.DataReadException ex) {
            diag.title = null;
            ex.printStackTrace();
        }
        StringBuilder t = new StringBuilder();
        rd.nowReading = "Any comment lines after the diagram title";
        try {
            while (true) {
                t.append(rd.readLine());
                t.append(nl);
            }
        }
        catch (ReadDataLib.DataEofException ex) {
        }
        catch (ReadDataLib.DataReadException ex) {
            ex.printStackTrace();
        }
        diag.endLines = t.length() > 0 ? t.toString() : null;
        return ch;
    }

    public static void printChemSystem(PrintStream out, Chem.ChemSystem cs) {
        int j = 0;
        out.println(LINE);
        out.println("Chemical System: Na, Nx, Msol, solidC = " + cs.Na + ", " + cs.nx + ", " + cs.mSol + ", " + cs.solidC);
        if (cs.solidC > 0) {
            out.println("Components (the last " + cs.solidC + " are solids), name and noll:");
        } else {
            out.println("Components, name and noll:");
        }
        int n0 = 0;
        int nM = cs.Na - 1;
        int iPl = 1;
        int nP = nM - n0;
        block0: for (int ijj = 0; ijj <= nP / iPl; ++ijj) {
            for (int jjj = 0; jjj < iPl; ++jjj) {
                int kjj = n0 + (ijj * iPl + jjj);
                out.format(engl, "%3d %20s, %5b", j, cs.namn.identC[kjj], cs.noll[kjj]);
                ++j;
                if (kjj <= nM - 1) continue;
                out.println();
                break block0;
            }
            out.println();
        }
        out.println("reaction products: name, logBeta, noll, a[]=");
        block2: for (int i = 0; i < cs.nx + cs.mSol; ++i) {
            out.format(engl, "%3d %20s, %10.5f %5b ", j, cs.namn.ident[i + cs.Na], cs.lBeta[i], cs.noll[i + cs.Na]);
            ++j;
            n0 = 0;
            nM = cs.Na - 1;
            iPl = 8;
            nP = nM - n0;
            for (int ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (int jjj = 0; jjj < iPl; ++jjj) {
                    int kjj = n0 + (ijj * iPl + jjj);
                    out.format(engl, " %8.3f", cs.a[i][kjj]);
                    if (kjj <= nM - 1) continue;
                    out.println();
                    continue block2;
                }
                out.println();
                out.print("              ");
            }
        }
        out.println(LINE);
        out.flush();
    }

    private static void printDescriptionYaxis(String[] identC, PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        String description = "General format for Y-axis plot-data is:      to obtain:" + nl + "    component-name,                        either fraction diagram, or" + nl + "                                           predominance area diagram" + nl + "    L,                                     log(conc) diagram" + nl + "    LC, max-Y-value, min-Y-value,             -\"-" + nl + "    LAC, max-Y-value, min-Y-value,         log(activity) diagram" + nl + "    S,                                     log(solubility) diagram" + nl + "    LS, max-Y-value, min-Y-value,             -\"-" + nl + "    pe, max-Y-value, min-Y-value,          pe-calc. in Y-axis" + nl + "    pH, max-Y-value, min-Y-value,          pH-calc. in Y-axis" + nl + "    R, species-name, Y-max, Y-min,         log(ai/ar) diagram" + nl + "    PS,                                    H+ affinity diagram" + nl + "You may preceede this with \"Eh,\" in order to use the redox potential" + nl + "instead of \"pe\" in the diagram.  For a predominance area diagram, you" + nl + "may also preceede the Y-axis plot-data with \"ONE AREA, species-name\"," + nl + "to only show the predominance area of the given species.";
        out.println();
        out.println(description);
        ReadChemSyst.listComponents(identC, out);
        out.println("Error in input plot-data for:  Y-axis");
    }

    private static void printDescriptionXaxis(String[] identC, PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        String description = "General format for X-axis plot-data is:" + nl + "A component name, for which the concentration is varied.  You may" + nl + "preceede this with \"Eh,\" in order to use the redox potential" + nl + "instead of \"pe\" in the diagram.";
        out.println();
        out.println(description);
        ReadChemSyst.listComponents(identC, out);
        out.println("Error in input plot-data for:  X-axis");
    }

    private static void listComponents(String[] identC, PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        out.println("The names of the components are:");
        out.print("    ");
        int n0 = 0;
        int nM = identC.length - 1;
        int iPl = 7;
        int nP = nM - n0;
        block0: for (int ijj = 0; ijj <= nP / iPl; ++ijj) {
            for (int jjj = 0; jjj < iPl; ++jjj) {
                int kjj = n0 + (ijj * iPl + jjj);
                out.format(engl, "  \"%s\",", identC[kjj]);
                if (kjj <= nM - 1) continue;
                out.println();
                break block0;
            }
            out.println();
            out.print("    ");
        }
    }

    public static boolean addFictiveSolids(Chem.ChemSystem cs) {
        if (cs == null) {
            return false;
        }
        if (cs.solidC > 0) {
            for (int m = 0; m < cs.solidC; ++m) {
                int j = cs.Ms - cs.Na - cs.solidC + m;
                int k = cs.Na - cs.solidC + m;
                cs.noll[k] = true;
                cs.lBeta[j] = 0.0;
                for (int n = 0; n < cs.Na; ++n) {
                    cs.a[j][n] = 0.0;
                    if (n != k) continue;
                    cs.a[j][n] = 1.0;
                }
                int ji = j + cs.Na;
                cs.namn.ident[ji] = cs.namn.identC[k];
                if (!cs.namn.ident[ji].startsWith("*")) continue;
                cs.namn.ident[ji] = cs.namn.ident[ji].substring(1);
                cs.noll[ji] = true;
            }
        }
        return true;
    }

    public static class ConcDataException
    extends Exception {
        public ConcDataException() {
        }

        public ConcDataException(String txt) {
            super(txt);
        }
    }

    public static class PlotDataException
    extends Exception {
        public PlotDataException() {
        }

        public PlotDataException(String txt) {
            super(txt);
        }
    }

    public static class ReadDataFileException
    extends Exception {
        public ReadDataFileException() {
        }

        public ReadDataFileException(String txt) {
            super(txt);
        }
    }

    public static class DataLimitsException
    extends Exception {
        public DataLimitsException() {
        }

        public DataLimitsException(String txt) {
            super(txt);
        }
    }

    private class ChemSystReadException
    extends Exception {
        public ChemSystReadException() {
        }

        public ChemSystReadException(String txt) {
            super(txt);
        }
    }
}

