/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.Graphics2D;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.qenherkhopeshef.graphics.pict.MacPictGraphics2D;
import org.qenherkhopeshef.graphics.rtfBasicWriter.SimpleRTFWriter;
import org.qenherkhopeshef.graphics.vectorClipboard.PICTTransferable;
import org.qenherkhopeshef.graphics.vectorClipboard.RTFPicture;

public class MACPictPicture
extends RTFPicture {
    private int width;
    private int height;
    private MacPictGraphics2D g2d;

    public MACPictPicture(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.g2d = new MacPictGraphics2D(0.0, 0.0, width, height);
    }

    public Graphics2D getGraphics() {
        return this.g2d;
    }

    public void write(SimpleRTFWriter writer) throws IOException {
        writer.writeMacPictPicture(this.g2d.getAsArrayForRTF(), this.width, this.height);
    }

    public byte[] getAsByteArray() {
        return this.g2d.getAsArray();
    }

    public byte[] getAsArrayForRTF() {
        return this.g2d.getAsArrayForRTF();
    }

    protected Transferable buildStandAloneTransferable() {
        return new PICTTransferable(this);
    }
}

