/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.qenherkhopeshef.graphics.vectorClipboard.EMFPicture;
import org.qenherkhopeshef.graphics.vectorClipboard.MACPictPicture;
import org.qenherkhopeshef.graphics.vectorClipboard.PDFPicture;
import org.qenherkhopeshef.graphics.vectorClipboard.TransferablePicture;
import org.qenherkhopeshef.graphics.vectorClipboard.WMFPicture;

public class SimpleClipGraphics {
    private TransferablePicture currentPicture;
    private int pictureFormat = 3;
    private int width;
    private int height;

    public SimpleClipGraphics(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Graphics2D getGraphics() {
        if (this.currentPicture == null) {
            this.initPicture();
        }
        return this.currentPicture.getGraphics();
    }

    private void initPicture() {
        try {
            switch (this.pictureFormat) {
                case 2: {
                    this.currentPicture = new EMFPicture(this.width, this.height);
                    break;
                }
                case 1: {
                    this.currentPicture = new WMFPicture(this.width, this.height);
                    break;
                }
                case 3: {
                    this.currentPicture = new MACPictPicture(this.width, this.height);
                    break;
                }
                case 4: {
                    EMFPicture emfPicture = new EMFPicture(this.width, this.height);
                    emfPicture.setEmbeddedInRTF(false);
                    this.currentPicture = emfPicture;
                    break;
                }
                case 5: {
                    MACPictPicture macPictPicture = new MACPictPicture(this.width, this.height);
                    macPictPicture.setEmbeddedInRTF(false);
                    this.currentPicture = macPictPicture;
                    break;
                }
                case 6: {
                    this.currentPicture = new PDFPicture(this.width, this.height);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This format is not supported yet " + this.pictureFormat);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPictureFormat() {
        return this.pictureFormat;
    }

    public void setPictureFormat(int pictureFormat) {
        this.pictureFormat = pictureFormat;
    }

    public void copyToClipboard(ClipboardOwner owner) {
        Transferable transferable = this.currentPicture.buildTransferable();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, owner);
    }

    public void copyToClipboard() {
        this.copyToClipboard(null);
    }
}

