/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.readWriteDataFiles;

import lib.common.Util;
import lib.kemi.chem.Chem;

public class DefaultPlotAndConcs {
    public static void setDefaultPlot(Chem.ChemSystem cs, Chem.Diagr diag, Chem.DiagrConcs dgrC) {
        int i;
        diag.plotType = 3;
        diag.yLow = -9.0;
        diag.yHigh = 1.0;
        diag.compY = -1;
        diag.compMain = -1;
        diag.compX = -1;
        for (i = 0; i < cs.Na; ++i) {
            if (!Util.isProton(cs.namn.identC[i])) continue;
            diag.compX = i;
            break;
        }
        if (diag.compX < 0) {
            for (i = 0; i < cs.Na; ++i) {
                if (!Util.isElectron(cs.namn.identC[i])) continue;
                diag.compX = i;
                break;
            }
        }
        if (diag.compX < 0) {
            for (i = 0; i < cs.Na; ++i) {
                if (dgrC.hur[i] != 2 && dgrC.hur[i] != 3 && dgrC.hur[i] != 5) continue;
                diag.compX = i;
                break;
            }
        }
        if (diag.compX < 0) {
            for (i = 0; i < cs.Na; ++i) {
                if (Util.isCation(cs.namn.identC[i])) continue;
                diag.compX = i;
                break;
            }
        }
        if (diag.compX < 0) {
            diag.compX = 0;
        }
    }

    public static void checkConcsInAxesAndMain(Chem.ChemSystem.NamesEtc namn, Chem.Diagr diag, Chem.DiagrConcs dgrC, boolean dbg) {
        if (dbg) {
            System.out.println("checkConcsInAxesAndMain - plotType =" + diag.plotType + ", compMain =" + diag.compMain + ", compX =" + diag.compX + ", compY =" + diag.compY);
        }
        for (int i = 0; i < dgrC.hur.length; ++i) {
            if (i == diag.compX || diag.plotType == 0 && (i == diag.compMain || i == diag.compY) || dgrC.hur[i] > 0 && dgrC.hur[i] <= 5 && !Double.isNaN(dgrC.cLow[i]) && (dgrC.hur[i] == 1 || dgrC.hur[i] == 4 || !Double.isNaN(dgrC.cHigh[i]))) continue;
            DefaultPlotAndConcs.setDefaultConc(i, namn.identC[i], dgrC);
        }
        if (diag.compX >= 0 && dgrC.hur[diag.compX] != 2 && dgrC.hur[diag.compX] != 3 && dgrC.hur[diag.compX] != 5) {
            dgrC.hur[diag.compX] = 5;
            dgrC.cLow[diag.compX] = -10.0;
            dgrC.cHigh[diag.compX] = -1.0;
            if (Util.isProton(namn.identC[diag.compX])) {
                dgrC.cLow[diag.compX] = -12.0;
            }
            if (Util.isElectron(namn.identC[diag.compX])) {
                dgrC.cLow[diag.compX] = -10.0;
                dgrC.cHigh[diag.compX] = 10.0;
            }
        }
        if (diag.compY >= 0 && diag.plotType == 0 && dgrC.hur[diag.compY] != 2 && dgrC.hur[diag.compY] != 3 && dgrC.hur[diag.compY] != 5) {
            dgrC.hur[diag.compY] = 5;
            dgrC.cLow[diag.compY] = -10.0;
            dgrC.cHigh[diag.compY] = -1.0;
            if (Util.isProton(namn.identC[diag.compY])) {
                dgrC.cLow[diag.compY] = -12.0;
            }
            if (Util.isElectron(namn.identC[diag.compY])) {
                dgrC.cLow[diag.compY] = -10.0;
                dgrC.cHigh[diag.compY] = 10.0;
            }
        }
        if (diag.compMain >= 0 && diag.compMain != diag.compY && diag.compMain != diag.compX && (dgrC.hur[diag.compMain] == 2 || dgrC.hur[diag.compMain] == 3 || dgrC.hur[diag.compMain] == 5)) {
            dgrC.hur[diag.compMain] = 1;
            dgrC.cLow[diag.compMain] = 1.0E-6;
            dgrC.cHigh[diag.compMain] = 0.0;
        }
    }

    public static void setDefaultConcs(Chem.ChemSystem cs, Chem.DiagrConcs dgrC) {
        for (int i = 0; i < cs.Na; ++i) {
            DefaultPlotAndConcs.setDefaultConc(i, cs.namn.identC[i], dgrC);
        }
    }

    public static void setDefaultConc(int i, String compName, Chem.DiagrConcs dgrC) {
        dgrC.hur[i] = 1;
        dgrC.cHigh[i] = 0.0;
        dgrC.cLow[i] = 1.0E-5;
        if (Util.isElectron(compName)) {
            dgrC.cLow[i] = -8.5;
            dgrC.hur[i] = 4;
        } else if (Util.isProton(compName)) {
            dgrC.cLow[i] = -7.0;
            dgrC.hur[i] = 4;
        } else {
            if (!Util.isCation(compName)) {
                dgrC.cLow[i] = 0.01;
            }
            if (Util.isGas(compName)) {
                dgrC.cLow[i] = -3.5;
                dgrC.hur[i] = 4;
            } else if (Util.isWater(compName)) {
                dgrC.cLow[i] = 0.0;
                dgrC.hur[i] = 4;
            }
        }
    }
}

