/*
 * Decompiled with CFR 0.152.
 */
package dataMaintenance;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import lib.common.Util;
import lib.database.Complex;
import lib.database.LibDB;
import lib.database.LibSearch;
import lib.database.ProgramDataDB;
import lib.huvud.Div;
import lib.huvud.ProgramConf;
import lib.huvud.SortedListModel;

public class Statistics
extends JFrame {
    private boolean finished = false;
    private final ProgramDataDB pd;
    private final ProgramConf pc;
    private int na;
    private int nx;
    private PrintWriter outputFile;
    private final DefaultListModel modelCompsFnd = new DefaultListModel();
    private final SortedListModel sortedModelCompsFnd = new SortedListModel(this.modelCompsFnd);
    private final DefaultListModel modelNameWoutNumber = new DefaultListModel();
    private final SortedListModel sortedModelNameWoutNumber = new SortedListModel(this.modelNameWoutNumber);
    private final DefaultListModel modelNumberWoutName = new DefaultListModel();
    private final SortedListModel sortedModelNumberWoutName = new SortedListModel(this.modelNumberWoutName);
    private final DefaultListModel modelHConflict = new DefaultListModel();
    private final SortedListModel sortedModelHConflict = new SortedListModel(this.modelHConflict);
    private final DefaultListModel modelChargeError = new DefaultListModel();
    private final SortedListModel sortedModelChargeError = new SortedListModel(this.modelChargeError);
    private final HashMap<String, Integer> itemsCompsFnd = new HashMap();
    private final Border defBorder;
    private final Border highlightedBorder = BorderFactory.createBevelBorder(0, new Color(102, 102, 102), new Color(255, 255, 255), new Color(102, 102, 102), new Color(0, 0, 0));
    private Dimension windowSize = new Dimension(400, 280);
    private static final String nl = System.getProperty("line.separator");
    private static final String SLASH = File.separator;
    private JButton jButtonClose;
    private JCheckBox jCheckBoxDebugFrame;
    private JLabel jLabelChargeError;
    private JLabel jLabelComps;
    private JLabel jLabelErr;
    private JLabel jLabelHConflict;
    private JLabel jLabelN;
    private JLabel jLabelNa;
    private JLabel jLabelNaFiles;
    private JLabel jLabelNameWoutNumb;
    private JLabel jLabelNumbWoutName;
    private JLabel jLabelTot;
    private JLabel jLabelTotCmplx;
    private JLabel jLabelTotComps;
    private JLabel jLabelTotCompsFiles;
    private JList jListChargeError;
    private JList jListComps;
    private JList jListHConflict;
    private JList jListNameWoutNumb;
    private JList jListNumbWoutName;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelCheckBox;
    private JPanel jPanelErrs;
    private JPanel jPanelTot;
    private JScrollPane jScrollChargeError;
    private JScrollPane jScrollHConflict;
    private JScrollPane jScrollNameWoutNumb;
    private JScrollPane jScrollNumbWoutName;
    private JScrollPane jScrollPaneComps;
    private JSeparator jSeparator1;

    public Statistics(ProgramConf pc0, ProgramDataDB pd0) {
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.defBorder = this.jScrollPaneComps.getBorder();
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Statistics.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        this.getRootPane().getActionMap().put("ALT_X", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point frameLocation = new Point(-1000, -1000);
        frameLocation.x = Math.max(0, (screenSize.width - this.getWidth()) / 2);
        frameLocation.y = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        this.setLocation(frameLocation);
        this.setTitle("Database - Statistics");
        this.showJPanelTot(false);
        String iconName = "images/Sigma.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn("Error: Could not load image = \"" + iconName + "\"");
        }
    }

    public void start() {
        this.setCursor(new Cursor(3));
        this.jButtonClose.setEnabled(false);
        this.setVisible(true);
        System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -" + nl + "Starting \"Statistics\"");
        this.windowSize = this.getSize();
        if (this.pd.msgFrame != null) {
            this.pd.msgFrame.setParentFrame(this);
            this.jCheckBoxDebugFrame.setSelected(this.pd.msgFrame.isVisible());
        }
        if (!this.startStatistics()) {
            this.closeWindow();
        }
    }

    private void initComponents() {
        this.jPanelCheckBox = new JPanel();
        this.jCheckBoxDebugFrame = new JCheckBox();
        this.jButtonClose = new JButton();
        this.jLabelComps = new JLabel();
        this.jScrollPaneComps = new JScrollPane();
        this.jListComps = new JList();
        this.jPanelTot = new JPanel();
        this.jLabelTot = new JLabel();
        this.jLabelTotCmplx = new JLabel();
        this.jLabelN = new JLabel();
        this.jLabelTotComps = new JLabel();
        this.jLabelTotCompsFiles = new JLabel();
        this.jLabelNa = new JLabel();
        this.jLabelNaFiles = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanelErrs = new JPanel();
        this.jLabelErr = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabelNameWoutNumb = new JLabel();
        this.jScrollNameWoutNumb = new JScrollPane();
        this.jListNameWoutNumb = new JList();
        this.jPanel2 = new JPanel();
        this.jLabelNumbWoutName = new JLabel();
        this.jScrollNumbWoutName = new JScrollPane();
        this.jListNumbWoutName = new JList();
        this.jPanel3 = new JPanel();
        this.jLabelHConflict = new JLabel();
        this.jScrollHConflict = new JScrollPane();
        this.jListHConflict = new JList();
        this.jPanel4 = new JPanel();
        this.jLabelChargeError = new JLabel();
        this.jScrollChargeError = new JScrollPane();
        this.jListChargeError = new JList();
        this.setDefaultCloseOperation(3);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                Statistics.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Statistics.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Statistics.this.formComponentResized(evt);
            }
        });
        this.jPanelCheckBox.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxDebugFrame.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxDebugFrame.setMnemonic('s');
        this.jCheckBoxDebugFrame.setText("show messages");
        this.jCheckBoxDebugFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Statistics.this.jCheckBoxDebugFrameActionPerformed(evt);
            }
        });
        this.jButtonClose.setFont(new Font("Dialog", 0, 11));
        this.jButtonClose.setMnemonic('c');
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Statistics.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout jPanelCheckBoxLayout = new GroupLayout(this.jPanelCheckBox);
        this.jPanelCheckBox.setLayout(jPanelCheckBoxLayout);
        jPanelCheckBoxLayout.setHorizontalGroup(jPanelCheckBoxLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCheckBoxLayout.createSequentialGroup().addComponent(this.jButtonClose).addGap(52, 52, 52).addComponent(this.jCheckBoxDebugFrame).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelCheckBoxLayout.setVerticalGroup(jPanelCheckBoxLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCheckBoxLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxDebugFrame).addComponent(this.jButtonClose)));
        this.jLabelComps.setFont(new Font("Dialog", 0, 11));
        this.jLabelComps.setLabelFor(this.jListComps);
        this.jLabelComps.setText("Components found:");
        this.jScrollPaneComps.setFont(new Font("Dialog", 0, 11));
        this.jListComps.setFont(new Font("Dialog", 0, 11));
        this.jListComps.setModel(this.sortedModelCompsFnd);
        this.jListComps.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Statistics.this.jListCompsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                Statistics.this.jListCompsFocusLost(evt);
            }
        });
        this.jScrollPaneComps.setViewportView(this.jListComps);
        this.jPanelTot.setFont(new Font("Dialog", 0, 11));
        this.jLabelTot.setFont(new Font("Dialog", 1, 12));
        this.jLabelTot.setText("Totals");
        this.jLabelTotCmplx.setFont(new Font("Dialog", 0, 11));
        this.jLabelTotCmplx.setText("Number of reactions =");
        this.jLabelN.setFont(new Font("Dialog", 0, 11));
        this.jLabelN.setText("0");
        this.jLabelTotComps.setFont(new Font("Dialog", 0, 11));
        this.jLabelTotComps.setText("Number of components =");
        this.jLabelTotCompsFiles.setFont(new Font("Dialog", 0, 11));
        this.jLabelTotCompsFiles.setText("Nbr comps. in files: ");
        this.jLabelNa.setFont(new Font("Dialog", 0, 11));
        this.jLabelNa.setText("0");
        this.jLabelNaFiles.setFont(new Font("Dialog", 0, 11));
        this.jLabelNaFiles.setText("0");
        GroupLayout jPanelTotLayout = new GroupLayout(this.jPanelTot);
        this.jPanelTot.setLayout(jPanelTotLayout);
        jPanelTotLayout.setHorizontalGroup(jPanelTotLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTotLayout.createSequentialGroup().addGroup(jPanelTotLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTot).addGroup(jPanelTotLayout.createSequentialGroup().addContainerGap().addGroup(jPanelTotLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTotLayout.createSequentialGroup().addComponent(this.jLabelTotCmplx).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelN)).addGroup(jPanelTotLayout.createSequentialGroup().addComponent(this.jLabelTotComps).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNa)).addGroup(jPanelTotLayout.createSequentialGroup().addComponent(this.jLabelTotCompsFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNaFiles))))).addContainerGap(39, Short.MAX_VALUE)));
        jPanelTotLayout.setVerticalGroup(jPanelTotLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTotLayout.createSequentialGroup().addComponent(this.jLabelTot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTotLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTotCmplx).addComponent(this.jLabelN)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTotLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTotComps).addComponent(this.jLabelNa)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTotLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTotCompsFiles).addComponent(this.jLabelNaFiles)).addContainerGap(31, Short.MAX_VALUE)));
        this.jSeparator1.setFont(new Font("Dialog", 0, 11));
        this.jPanelErrs.setFont(new Font("Dialog", 1, 14));
        this.jLabelErr.setFont(new Font("Dialog", 1, 14));
        this.jLabelErr.setText("Errors:");
        GroupLayout jPanelErrsLayout = new GroupLayout(this.jPanelErrs);
        this.jPanelErrs.setLayout(jPanelErrsLayout);
        jPanelErrsLayout.setHorizontalGroup(jPanelErrsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelErrsLayout.createSequentialGroup().addComponent(this.jLabelErr).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelErrsLayout.setVerticalGroup(jPanelErrsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelErrsLayout.createSequentialGroup().addComponent(this.jLabelErr).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jLabelNameWoutNumb.setFont(new Font("Dialog", 0, 11));
        this.jLabelNameWoutNumb.setLabelFor(this.jListNameWoutNumb);
        this.jLabelNameWoutNumb.setText("<html>Reactions with a<br>component and<br>no stoich.coef.</html>");
        this.jScrollNameWoutNumb.setFont(new Font("Dialog", 0, 11));
        this.jListNameWoutNumb.setFont(new Font("Dialog", 0, 11));
        this.jListNameWoutNumb.setModel(this.sortedModelNameWoutNumber);
        this.jListNameWoutNumb.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Statistics.this.jListNameWoutNumbFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                Statistics.this.jListNameWoutNumbFocusLost(evt);
            }
        });
        this.jScrollNameWoutNumb.setViewportView(this.jListNameWoutNumb);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollNameWoutNumb, -1, 127, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelNameWoutNumb, -2, 100, -2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelNameWoutNumb, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollNameWoutNumb, -2, 0, Short.MAX_VALUE)));
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jLabelNumbWoutName.setFont(new Font("Dialog", 0, 11));
        this.jLabelNumbWoutName.setLabelFor(this.jListNumbWoutName);
        this.jLabelNumbWoutName.setText("<html>Reactions with a<br>stoich.coef. and<br>no component</html>");
        this.jScrollNumbWoutName.setFont(new Font("Dialog", 0, 11));
        this.jListNumbWoutName.setFont(new Font("Dialog", 0, 11));
        this.jListNumbWoutName.setModel(this.sortedModelNumberWoutName);
        this.jListNumbWoutName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Statistics.this.jListNumbWoutNameFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                Statistics.this.jListNumbWoutNameFocusLost(evt);
            }
        });
        this.jScrollNumbWoutName.setViewportView(this.jListNumbWoutName);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollNumbWoutName, -2, 126, -2).addComponent(this.jLabelNumbWoutName, -2, 103, -2)).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabelNumbWoutName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollNumbWoutName, -1, 116, Short.MAX_VALUE)));
        this.jPanel3.setFont(new Font("Dialog", 0, 11));
        this.jLabelHConflict.setFont(new Font("Dialog", 0, 11));
        this.jLabelHConflict.setLabelFor(this.jListHConflict);
        this.jLabelHConflict.setText("<html>Reactions having<br>proton-nbr. in conflict<br>with H+ stoich.coef.</html>");
        this.jScrollHConflict.setFont(new Font("Dialog", 0, 11));
        this.jListHConflict.setFont(new Font("Dialog", 0, 11));
        this.jListHConflict.setModel(this.sortedModelHConflict);
        this.jListHConflict.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Statistics.this.jListHConflictFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                Statistics.this.jListHConflictFocusLost(evt);
            }
        });
        this.jScrollHConflict.setViewportView(this.jListHConflict);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelHConflict, -2, -1, -2).addComponent(this.jScrollHConflict, -2, 125, -2)).addGap(0, 0, 0)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabelHConflict, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollHConflict, -2, 0, Short.MAX_VALUE)));
        this.jPanel4.setFont(new Font("Dialog", 0, 11));
        this.jLabelChargeError.setFont(new Font("Dialog", 0, 11));
        this.jLabelChargeError.setLabelFor(this.jListChargeError);
        this.jLabelChargeError.setText("<html>Reactions with<br>charge<br>imbalance</html>");
        this.jScrollChargeError.setFont(new Font("Dialog", 0, 11));
        this.jListChargeError.setFont(new Font("Dialog", 0, 11));
        this.jListChargeError.setModel(this.sortedModelChargeError);
        this.jListChargeError.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Statistics.this.jListChargeErrorFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                Statistics.this.jListChargeErrorFocusLost(evt);
            }
        });
        this.jScrollChargeError.setViewportView(this.jListChargeError);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelChargeError, -2, -1, -2).addComponent(this.jScrollChargeError, -2, 127, -2)).addGap(0, 0, 0)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabelChargeError, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollChargeError, -2, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jPanelErrs, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2)).addComponent(this.jPanelCheckBox, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneComps, -2, 101, -2).addComponent(this.jLabelComps)).addGap(18, 18, 18).addComponent(this.jPanelTot, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelComps).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneComps, -2, 86, -2)).addComponent(this.jPanelTot, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelErrs, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jCheckBoxDebugFrameActionPerformed(ActionEvent evt) {
        if (this.pd.msgFrame != null) {
            this.pd.msgFrame.setVisible(this.jCheckBoxDebugFrame.isSelected());
        }
    }

    private void jListCompsFocusGained(FocusEvent evt) {
        this.jScrollPaneComps.setBorder(this.highlightedBorder);
        if (this.modelCompsFnd.getSize() > 0) {
            int i = Math.max(0, this.jListComps.getSelectedIndex());
            this.jListComps.setSelectedIndex(i);
            this.jListComps.ensureIndexIsVisible(i);
        }
    }

    private void jListCompsFocusLost(FocusEvent evt) {
        this.jScrollPaneComps.setBorder(this.defBorder);
    }

    private void jListNameWoutNumbFocusGained(FocusEvent evt) {
        this.jScrollNameWoutNumb.setBorder(this.highlightedBorder);
        if (this.modelNameWoutNumber.getSize() > 0) {
            int i = Math.max(0, this.jListNameWoutNumb.getSelectedIndex());
            this.jListNameWoutNumb.setSelectedIndex(i);
            this.jListNameWoutNumb.ensureIndexIsVisible(i);
        }
    }

    private void jListNameWoutNumbFocusLost(FocusEvent evt) {
        this.jScrollNameWoutNumb.setBorder(this.defBorder);
    }

    private void jListNumbWoutNameFocusGained(FocusEvent evt) {
        this.jScrollNumbWoutName.setBorder(this.highlightedBorder);
        if (this.modelNumberWoutName.getSize() > 0) {
            int i = Math.max(0, this.jListNumbWoutName.getSelectedIndex());
            this.jListNumbWoutName.setSelectedIndex(i);
            this.jListNumbWoutName.ensureIndexIsVisible(i);
        }
    }

    private void jListNumbWoutNameFocusLost(FocusEvent evt) {
        this.jScrollNumbWoutName.setBorder(this.defBorder);
    }

    private void jListHConflictFocusGained(FocusEvent evt) {
        this.jScrollHConflict.setBorder(this.highlightedBorder);
        if (this.modelHConflict.getSize() > 0) {
            int i = Math.max(0, this.jListHConflict.getSelectedIndex());
            this.jListHConflict.setSelectedIndex(i);
            this.jListHConflict.ensureIndexIsVisible(i);
        }
    }

    private void jListHConflictFocusLost(FocusEvent evt) {
        this.jScrollHConflict.setBorder(this.defBorder);
    }

    private void jListChargeErrorFocusGained(FocusEvent evt) {
        this.jScrollChargeError.setBorder(this.highlightedBorder);
        if (this.modelChargeError.getSize() > 0) {
            int i = Math.max(0, this.jListChargeError.getSelectedIndex());
            this.jListChargeError.setSelectedIndex(i);
            this.jListChargeError.ensureIndexIsVisible(i);
        }
    }

    private void jListChargeErrorFocusLost(FocusEvent evt) {
        this.jScrollChargeError.setBorder(this.defBorder);
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        if (this.pd.msgFrame != null) {
            this.jCheckBoxDebugFrame.setSelected(this.pd.msgFrame.isVisible());
        } else {
            this.jCheckBoxDebugFrame.setEnabled(false);
        }
    }

    private void closeWindow() {
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    private static Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    private void showJPanelTot(boolean show) {
        if (show) {
            this.jLabelTot.setText("Totals:");
            this.jLabelTotCmplx.setText("Number of reactions =");
            this.jLabelN.setText("0");
            this.jLabelTotComps.setText("Number of components =");
            this.jLabelNa.setText("0");
            this.jLabelTotCompsFiles.setText("Nbr comps. in files: ");
            this.jLabelNaFiles.setText("0");
            this.jListComps.setEnabled(true);
            this.jListNameWoutNumb.setEnabled(true);
            this.jListNumbWoutName.setEnabled(true);
            this.jListHConflict.setEnabled(true);
            this.jListChargeError.setEnabled(true);
        } else {
            this.jLabelTot.setText(" ");
            this.jLabelTotCmplx.setText(" ");
            this.jLabelN.setText(" ");
            this.jLabelTotComps.setText(" ");
            this.jLabelNa.setText(" ");
            this.jLabelTotCompsFiles.setText(" ");
            this.jLabelNaFiles.setText(" ");
            this.jListComps.setEnabled(false);
            this.jListNameWoutNumb.setEnabled(false);
            this.jListNumbWoutName.setEnabled(false);
            this.jListHConflict.setEnabled(false);
            this.jListChargeError.setEnabled(false);
        }
    }

    private static String reactString(Complex cmplx) {
        Complex c;
        if (cmplx == null) {
            return "";
        }
        if (cmplx.name.startsWith("@")) {
            return "";
        }
        try {
            c = (Complex)cmplx.clone();
        }
        catch (CloneNotSupportedException cex) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        Complex.sortReactants(c);
        for (int ic = 0; ic < 6; ++ic) {
            if (c.component[ic] == null || c.component[ic].length() <= 0 || Math.abs(c.numcomp[ic]) < 0.001) {
                text.append(";;");
                continue;
            }
            text.append(Complex.encloseInQuotes(c.component[ic]));
            text.append(";");
            text.append(Util.formatDbl4(c.numcomp[ic]).trim());
            text.append(";");
        }
        if (Math.abs(c.proton) >= 0.001) {
            text.append(Util.formatDbl4(c.proton).trim());
        }
        text.append(";");
        return text.toString();
    }

    private boolean startStatistics() {
        LibSearch libS;
        File f;
        String name;
        int i;
        String LOGfileName;
        System.out.println("---- startStatistics()" + nl + "default path: " + this.pc.pathDef);
        String dir = this.pc.pathDef.toString();
        if (dir.endsWith(SLASH)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((LOGfileName = Util.getSaveFileName(this, this.pc.progName, "Select an output file:", 7, dir + SLASH + "Statistics.txt", null)) == null || LOGfileName.trim().length() <= 0) {
            System.out.println("---- cancelled by the user");
            return false;
        }
        final File tmpFile = new File(LOGfileName);
        this.pc.setPathDef(tmpFile);
        this.outputFile = null;
        try {
            this.outputFile = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
        }
        catch (IOException ex) {
            String msg = "Error \"" + ex.getMessage() + "\"," + nl + "   while making a PrintWriter for file:" + nl + "   \"" + LOGfileName + "\"";
            Util.exceptn(msg);
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
            if (this.outputFile != null) {
                this.outputFile.close();
            }
            return false;
        }
        this.itemsCompsFnd.clear();
        this.modelCompsFnd.clear();
        this.modelNameWoutNumber.clear();
        this.modelNumberWoutName.clear();
        this.modelHConflict.clear();
        this.modelChargeError.clear();
        this.showJPanelTot(true);
        System.out.println("Output file: " + LOGfileName);
        LibDB.getElements(this, this.pc, this.pd.dataBasesList, this.pd.elemComp);
        this.na = this.pd.elemComp.size() + 1;
        for (int i2 = 0; i2 < this.pd.elemComp.size() - 1; ++i2) {
            for (int j = i2 + 1; j < this.pd.elemComp.size(); ++j) {
                if (!this.pd.elemComp.get(i2)[1].equals(this.pd.elemComp.get(j)[1])) continue;
                --this.na;
            }
        }
        this.jLabelNaFiles.setText(String.valueOf(this.na));
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        Date today = new Date();
        String dateOut = dateFormatter.format(today);
        this.outputFile.println("DataMaintenance (java) - " + dateOut + nl + "Statistics for LogK databases:" + nl + nl + "Databases for reactions:");
        DateFormat df = DateFormat.getDateTimeInstance(2, 3);
        for (i = 0; i < this.pd.dataBasesList.size(); ++i) {
            name = this.pd.dataBasesList.get(i).toString().trim();
            if (name.length() <= 0) continue;
            f = new File(name);
            this.outputFile.println("  " + f.getAbsolutePath() + "   " + df.format(f.lastModified()));
        }
        this.outputFile.println(nl + "Element-reactant files:");
        for (i = 0; i < this.pd.dataBasesList.size(); ++i) {
            name = this.pd.dataBasesList.get(i).toString().trim();
            if (name.length() <= 0) continue;
            f = new File(Div.getFileNameWithoutExtension(name) + ".elt");
            if (!f.exists()) {
                f = new File(Div.getFileNameWithoutExtension(name) + ".elb");
            }
            if (!f.exists()) continue;
            this.outputFile.println("  " + f.getAbsolutePath() + "   " + df.format(f.lastModified()));
        }
        try {
            libS = new LibSearch(this.pd);
        }
        catch (LibSearch.LibSearchException ex) {
            Util.exceptn(ex.toString());
            return false;
        }
        this.setCursor(new Cursor(3));
        this.jButtonClose.setCursor(new Cursor(0));
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                boolean ok;
                boolean fnd;
                int j;
                int i;
                boolean fistComplex = true;
                Statistics.this.nx = 0;
                int noName = 0;
                boolean exception = false;
                HashSet<String[]> productsReactionsSet = new HashSet<String[]>();
                TreeSet<String> duplProductsSet = new TreeSet<String>();
                TreeSet<String> duplReactionsSameProdctSet = new TreeSet<String>();
                TreeSet<String> duplReactionsDifProductSet = new TreeSet<String>();
                TreeSet<String> duplSolidsSet = new TreeSet<String>();
                ArrayList<String> itemsNames = new ArrayList<String>();
                ArrayList<String> itemsRefsNotFnd = null;
                ArrayList<String> itemsRefsFnd = null;
                if (((Statistics)Statistics.this).pd.references != null) {
                    itemsRefsNotFnd = new ArrayList<String>();
                    itemsRefsFnd = new ArrayList<String>();
                }
                int names = 0;
                while (true) {
                    Complex cmplx;
                    if (Statistics.this.finished) {
                        Statistics.this.outputFile.close();
                        tmpFile.delete();
                        System.out.println("---- cancelled");
                        return null;
                    }
                    try {
                        cmplx = libS.getComplex(fistComplex);
                    }
                    catch (LibSearch.LibSearchException ex) {
                        String string = ex.getMessage() + nl + nl + "Canceling the operation.";
                        Util.exceptn(string);
                        JOptionPane.showMessageDialog(Statistics.this, string, ((Statistics)Statistics.this).pc.progName, 0);
                        exception = true;
                        break;
                    }
                    if (cmplx == null) break;
                    fistComplex = false;
                    Statistics.this.nx++;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Statistics.this.jLabelN.setText(String.valueOf(Statistics.this.nx));
                        }
                    });
                    if (cmplx.reference != null && cmplx.reference.trim().length() > 0 && ((Statistics)Statistics.this).pd.references != null && itemsRefsNotFnd != null) {
                        ArrayList<String> rfs = ((Statistics)Statistics.this).pd.references.splitRefs(cmplx.reference);
                        for (String string : rfs) {
                            if (((Statistics)Statistics.this).pd.references.isRefThere(string) == null) {
                                if (itemsRefsNotFnd.contains(string)) continue;
                                itemsRefsNotFnd.add(string);
                                continue;
                            }
                            if (itemsRefsFnd == null || itemsRefsFnd.contains(string)) continue;
                            itemsRefsFnd.add(string);
                        }
                    }
                    if (cmplx.name == null || cmplx.name.trim().length() <= 0) {
                        ++noName;
                        continue;
                    }
                    String product = cmplx.name.startsWith("@") ? cmplx.name.substring(1) : cmplx.name;
                    String reaction = Statistics.reactString(cmplx);
                    boolean isRedoxReaction = Complex.isRedox(cmplx);
                    for (String[] stringArray : productsReactionsSet) {
                        if (stringArray[1].length() <= 0 || !Util.stringsEqual(stringArray[1], reaction) || !Util.nameCompare(product, stringArray[0])) continue;
                        duplReactionsSameProdctSet.add(product);
                    }
                    for (String[] stringArray : productsReactionsSet) {
                        if (stringArray[1].length() <= 0 || !Util.stringsEqual(stringArray[1], reaction)) continue;
                        if (Util.isSolid(product) && Util.isSolid(stringArray[0]) && !Util.bareNameOf(product).equals(Util.bareNameOf(stringArray[0])) || Util.is_cr_or_c_solid(product) && Util.is_cr_or_c_solid(stringArray[0]) && Util.bareNameOf(product).equals(Util.bareNameOf(stringArray[0])) || Util.isGas(product) && Util.isGas(stringArray[0]) && !Util.bareNameOf(product).equals(Util.bareNameOf(stringArray[0])) || !Util.isSolid(product) && !Util.isSolid(stringArray[0]) && !Util.isGas(product) && !Util.isGas(stringArray[0]) && !Util.nameCompare(product, stringArray[0])) {
                            duplReactionsDifProductSet.add(product + "   and:  " + stringArray[0]);
                        }
                        if (!Util.isSolid(product) || !Util.isSolid(stringArray[0]) || !Util.bareNameOf(product).equals(Util.bareNameOf(stringArray[0]))) continue;
                        if (product.endsWith("(am)")) {
                            duplSolidsSet.add(stringArray[0] + "   and:  " + product);
                            continue;
                        }
                        duplSolidsSet.add(product + "   and:  " + stringArray[0]);
                    }
                    for (String[] stringArray : productsReactionsSet) {
                        if (!Util.nameCompare(product, stringArray[0]) || isRedoxReaction || stringArray[1].length() > 0 && Util.stringsEqual(stringArray[1], reaction)) continue;
                        duplProductsSet.add(product);
                    }
                    productsReactionsSet.add(new String[]{cmplx.name, reaction});
                    if (cmplx.name.startsWith("@")) continue;
                    final Object o = Statistics.makeObj(cmplx.name);
                    for (i = 0; i < 6; ++i) {
                        if (cmplx.component[i] == null || cmplx.component[i].trim().length() <= 0 || !(Math.abs(cmplx.numcomp[i]) < 0.001)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Statistics.this.modelNameWoutNumber.addElement(o);
                            }
                        });
                        break;
                    }
                    for (i = 0; i < 6; ++i) {
                        if (!(Math.abs(cmplx.numcomp[i]) >= 0.001) || cmplx.component[i] != null && cmplx.component[i].trim().length() > 0) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Statistics.this.modelNumberWoutName.addElement(o);
                            }
                        });
                        break;
                    }
                    if (!Complex.isChargeBalanced(cmplx)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Statistics.this.modelChargeError.addElement(o);
                            }
                        });
                    }
                    int nH = -1;
                    for (i = 0; i < 6; ++i) {
                        if (cmplx.component[i] == null || cmplx.component[i].trim().length() <= 0) continue;
                        if (Util.isProton(cmplx.component[i])) {
                            nH = i;
                        }
                        if (Statistics.this.itemsCompsFnd.containsKey(cmplx.component[i])) {
                            j = (Integer)Statistics.this.itemsCompsFnd.get(cmplx.component[i]);
                            Statistics.this.itemsCompsFnd.put(cmplx.component[i], j + 1);
                            continue;
                        }
                        Statistics.this.itemsCompsFnd.put(cmplx.component[i], 1);
                        final Object object = Statistics.makeObj(cmplx.component[i]);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Statistics.this.modelCompsFnd.addElement(object);
                                Statistics.this.jLabelNa.setText(String.valueOf(Statistics.this.modelCompsFnd.size()));
                            }
                        });
                    }
                    if (nH >= 0 && !Util.areEqualDoubles(cmplx.proton, cmplx.numcomp[nH])) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Statistics.this.modelHConflict.addElement(o);
                            }
                        });
                    }
                    fnd = true;
                    for (i = 0; i < 6; ++i) {
                        String string = cmplx.component[i];
                        if (string == null || string.length() <= 0 || Util.isElectron(string) || Util.isProton(string) || Util.isWater(string)) continue;
                        String string2 = Util.bareNameOf(string);
                        ok = cmplx.name.contains(string2);
                        if (!ok && string2.equals("Hg2")) {
                            ok = cmplx.name.contains("Hg");
                        }
                        if (!ok && string2.equals("CH3Hg")) {
                            boolean bl = ok = cmplx.name.contains("Hg") && cmplx.name.contains("CH");
                        }
                        if (!ok && string2.equals("NH3")) {
                            ok = cmplx.name.contains("NH");
                        }
                        if (!ok && string2.equals("NH3") && isRedoxReaction) {
                            ok = cmplx.name.contains("N");
                        }
                        if (!ok && (string2.equals("NO2") || string2.equals("NO3"))) {
                            ok = cmplx.name.contains("N");
                        }
                        if (!ok && (string2.equals("CO3") || string2.equals("HCOO"))) {
                            ok = cmplx.name.contains("C");
                        }
                        if (!ok && (string2.equals("MoO4") || string2.equals("Mo2O2") || string2.equals("Mo2O4") || string2.equals("Mo2(OH)2"))) {
                            ok = cmplx.name.contains("Mo");
                        }
                        if (!ok && string2.equals("WO4")) {
                            ok = cmplx.name.contains("W");
                        }
                        if (!ok && string2.equals("CrO4")) {
                            ok = cmplx.name.contains("Cr");
                        }
                        if (!ok && string2.equals("VO2")) {
                            ok = cmplx.name.contains("V");
                        }
                        if (!ok && string2.equals("UO2")) {
                            ok = cmplx.name.contains("U");
                        }
                        if (!ok && string2.equals("AmO2")) {
                            ok = cmplx.name.contains("Am");
                        }
                        if (!ok && string2.equals("NpO2")) {
                            ok = cmplx.name.contains("Np");
                        }
                        if (!ok && string2.equals("PuO2")) {
                            ok = cmplx.name.contains("Pu");
                        }
                        if (!ok && string2.equals("TcO(OH)2")) {
                            ok = cmplx.name.contains("Tc");
                        }
                        if (!ok && (string2.equals("As(OH)3") || string2.equals("AsO4") || string2.equals("H3AsO3"))) {
                            ok = cmplx.name.contains("As");
                        }
                        if (!ok && (string2.equals("Sb(OH)3") || string2.equals("Sb(OH)6"))) {
                            ok = cmplx.name.contains("Sb");
                        }
                        if (!ok && (string2.equals("Ge(OH)4") || string2.equals("Ge(OH)2"))) {
                            ok = cmplx.name.contains("Ge");
                        }
                        if (!ok && (string2.equals("Te(OH)4") || string2.equals("Te(OH)6") || string2.equals("HTe"))) {
                            ok = cmplx.name.contains("Te");
                        }
                        if (!ok && (string2.contains("TeO3") || string2.contains("TeO4") || string2.contains("TeO6"))) {
                            ok = cmplx.name.contains("Te");
                        }
                        if (!ok && string2.equals("Ta(OH)5")) {
                            ok = cmplx.name.contains("Ta");
                        }
                        if (!ok && string2.equals("Nb(OH)5")) {
                            ok = cmplx.name.contains("Nb");
                        }
                        if (!ok && string2.equals("PoO3")) {
                            ok = cmplx.name.contains("Po");
                        }
                        if (!ok && string2.equals("Si(OH)4")) {
                            ok = cmplx.name.contains("Si");
                        }
                        if (!ok && string2.equals("OsO4")) {
                            ok = cmplx.name.contains("Os");
                        }
                        if (!ok && string2.equals("TcO4")) {
                            ok = cmplx.name.contains("Tc");
                        }
                        if (!ok && (string2.equals("ReO4") || string2.equals("Re(OH)4"))) {
                            ok = cmplx.name.contains("Re");
                        }
                        if (!ok && (string2.equals("RuO4") || string2.equals("Ru(OH)2"))) {
                            ok = cmplx.name.contains("Ru");
                        }
                        if (!ok && string2.equals("TiO")) {
                            ok = cmplx.name.contains("Ti");
                        }
                        if (!ok && string2.equals("VO")) {
                            ok = cmplx.name.contains("V");
                        }
                        if (!ok && string2.equals("B(OH)3")) {
                            ok = cmplx.name.contains("B");
                        }
                        if (!ok && (string2.equals("PO4") || string2.equals("H2PO2") || string2.equals("HPO3") || string2.equals("P2O6"))) {
                            ok = cmplx.name.contains("P");
                        }
                        if (!ok && string2.equals("CNO")) {
                            ok = cmplx.name.contains("CN");
                        }
                        if (!ok && (string2.equals("BrO") || string2.equals("BrO3"))) {
                            ok = cmplx.name.contains("Br");
                        }
                        if (!ok && string2.equals("IO3")) {
                            ok = cmplx.name.contains("I");
                        }
                        if (!ok && string2.equals("H2O2")) {
                            ok = cmplx.name.contains("O2");
                        }
                        if (!ok && (string2.equals("H2Se") || string2.equals("HSe") || string2.equals("SeO4") || string2.equals("SeO3") || string2.equals("SeCN"))) {
                            ok = cmplx.name.contains("Se");
                        }
                        if (!ok && string2.equals("HS")) {
                            ok = cmplx.name.contains("S");
                        }
                        if (!ok && (string2.equals("SO4") || string2.equals("SO3") || string2.equals("S2O3"))) {
                            ok = cmplx.name.contains("S");
                        }
                        if (ok) continue;
                        fnd = false;
                        itemsNames.add(cmplx.name + "  does not contain  " + cmplx.component[i]);
                    }
                    if (fnd) continue;
                    ++names;
                }
                if (exception) {
                    Statistics.this.outputFile.flush();
                    Statistics.this.outputFile.close();
                    tmpFile.delete();
                    Statistics.this.finished = true;
                    return null;
                }
                Statistics.this.outputFile.println(nl + "Total nbr reactions = " + Statistics.this.nx);
                Statistics.this.outputFile.println("Total nbr reactants found in reaction databases = " + Statistics.this.modelCompsFnd.size() + nl + "      (nbr reactants in element-reactant files = " + Statistics.this.na + ")" + nl);
                if (Statistics.this.modelCompsFnd.size() > 0) {
                    Statistics.this.outputFile.println("Reactants found in reaction databases:" + nl + "  list  &  Nbr of reactions they participate in");
                    for (i = 0; i < Statistics.this.modelCompsFnd.size(); ++i) {
                        String t = Statistics.this.sortedModelCompsFnd.getElementAt(i).toString();
                        j = (Integer)Statistics.this.itemsCompsFnd.get(t);
                        if (t.length() <= 20) {
                            Statistics.this.outputFile.format("%4d  %-20s   %d", i + 1, t, j);
                            Statistics.this.outputFile.println();
                            continue;
                        }
                        Statistics.this.outputFile.format("%4d  %s   %d", i + 1, t, j);
                        Statistics.this.outputFile.println();
                    }
                }
                boolean needsTitle = true;
                for (j = 0; j < Statistics.this.modelCompsFnd.size(); ++j) {
                    fnd = false;
                    for (i = 0; i < ((Statistics)Statistics.this).pd.elemComp.size(); ++i) {
                        if (!((Statistics)Statistics.this).pd.elemComp.get(i)[1].equals(Statistics.this.modelCompsFnd.get(j).toString())) continue;
                        fnd = true;
                        break;
                    }
                    if (fnd) continue;
                    if (needsTitle) {
                        needsTitle = false;
                        Statistics.this.outputFile.println(nl + "Components in databases for reactions" + nl + "   not present in element-reactant files:");
                    }
                    Statistics.this.outputFile.println("      " + Statistics.this.modelCompsFnd.get(j).toString());
                }
                needsTitle = true;
                for (i = 0; i < ((Statistics)Statistics.this).pd.elemComp.size(); ++i) {
                    fnd = false;
                    for (j = 0; j < Statistics.this.modelCompsFnd.size(); ++j) {
                        if (!((Statistics)Statistics.this).pd.elemComp.get(i)[1].equals(Statistics.this.modelCompsFnd.get(j).toString())) continue;
                        fnd = true;
                        break;
                    }
                    if (fnd) continue;
                    if (needsTitle) {
                        needsTitle = false;
                        Statistics.this.outputFile.println(nl + "Components in element-reactant files" + nl + "   not used in the databases for reactions:");
                    }
                    Statistics.this.outputFile.println("      " + ((Statistics)Statistics.this).pd.elemComp.get(i)[1]);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (j = 0; j < Statistics.this.modelCompsFnd.size() - 1; ++j) {
                    for (i = j + 1; i < Statistics.this.modelCompsFnd.size(); ++i) {
                        if (!Util.nameCompare(Statistics.this.modelCompsFnd.get(j).toString(), Statistics.this.modelCompsFnd.get(i).toString())) continue;
                        arrayList.add(Statistics.this.modelCompsFnd.get(j).toString() + "   and:  " + Statistics.this.modelCompsFnd.get(i).toString());
                    }
                }
                if (arrayList.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Errors in names of reactants in the databases" + nl + "Names that are equivalent but will be treated as different:");
                    for (String string : arrayList) {
                        Statistics.this.outputFile.println("      " + string);
                    }
                }
                arrayList.clear();
                for (j = 0; j < ((Statistics)Statistics.this).pd.elemComp.size() - 1; ++j) {
                    for (i = j + 1; i < ((Statistics)Statistics.this).pd.elemComp.size(); ++i) {
                        if (((Statistics)Statistics.this).pd.elemComp.get(j)[1].equals(((Statistics)Statistics.this).pd.elemComp.get(i)[1]) || !Util.nameCompare(((Statistics)Statistics.this).pd.elemComp.get(j)[1], ((Statistics)Statistics.this).pd.elemComp.get(i)[1])) continue;
                        arrayList.add(((Statistics)Statistics.this).pd.elemComp.get(j)[1] + "   and:  " + ((Statistics)Statistics.this).pd.elemComp.get(i)[1]);
                    }
                }
                if (arrayList.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Errors in names of reactants in the element-reactant files" + nl + "Names that are equivalent but will be treated as different:");
                    for (String string : arrayList) {
                        Statistics.this.outputFile.println("      " + string);
                    }
                }
                if (noName > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of empty names for reaction products = " + noName);
                }
                if (Statistics.this.modelNameWoutNumber.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of reactions having a reactant with name but without its stoich.coeff = " + Statistics.this.modelNameWoutNumber.size());
                    for (i = 0; i < Statistics.this.modelNameWoutNumber.size(); ++i) {
                        Statistics.this.outputFile.println("  " + Statistics.this.sortedModelNameWoutNumber.getElementAt(i).toString());
                    }
                }
                if (Statistics.this.modelNumberWoutName.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of reactions having a stoich.coeff with no reactant = " + Statistics.this.modelNumberWoutName.size());
                    for (i = 0; i < Statistics.this.modelNumberWoutName.size(); ++i) {
                        Statistics.this.outputFile.println("  " + Statistics.this.sortedModelNumberWoutName.getElementAt(i).toString());
                    }
                }
                if (Statistics.this.modelHConflict.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of reactions having a confict between stoich.coeff for H+" + nl + "    and the nbr-protons = " + Statistics.this.modelHConflict.size());
                    for (i = 0; i < Statistics.this.modelHConflict.size(); ++i) {
                        Statistics.this.outputFile.println("  " + Statistics.this.sortedModelHConflict.getElementAt(i).toString());
                    }
                }
                if (Statistics.this.modelChargeError.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of reactions with charge imbalance = " + Statistics.this.modelChargeError.size());
                    for (i = 0; i < Statistics.this.modelChargeError.size(); ++i) {
                        Statistics.this.outputFile.println("  " + Statistics.this.sortedModelChargeError.getElementAt(i).toString());
                    }
                }
                if (duplReactionsSameProdctSet.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of reactions found more than once" + nl + "    (with the same product) = " + duplReactionsSameProdctSet.size());
                    for (String string : duplReactionsSameProdctSet) {
                        Statistics.this.outputFile.println("   " + string);
                    }
                }
                if (duplReactionsDifProductSet.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of reactions found more than once" + nl + "    (with a different product) = " + duplReactionsDifProductSet.size());
                    for (String string : duplReactionsDifProductSet) {
                        Statistics.this.outputFile.println("   " + string);
                    }
                }
                if (duplSolidsSet.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of solids found more than once" + nl + "    (with different phase designator) = " + duplSolidsSet.size());
                    for (String string : duplSolidsSet) {
                        Statistics.this.outputFile.println("   " + string);
                    }
                }
                if (duplProductsSet.size() > 0) {
                    Statistics.this.outputFile.println(nl + "Nbr of reaction products found more than once" + nl + "    (with a different reaction) = " + duplProductsSet.size());
                    for (String string : duplProductsSet) {
                        Statistics.this.outputFile.println("   " + string);
                    }
                }
                if (itemsNames.size() > 0) {
                    Collections.sort(itemsNames, String.CASE_INSENSITIVE_ORDER);
                    Statistics.this.outputFile.println(nl + "Nbr of reaction products where the name" + nl + "    does not contain one or more reactant(s) = " + names);
                    for (String string : itemsNames) {
                        Statistics.this.outputFile.println("   " + string);
                    }
                }
                if (((Statistics)Statistics.this).pd.references != null) {
                    if (itemsRefsNotFnd != null && !itemsRefsNotFnd.isEmpty()) {
                        Collections.sort(itemsRefsNotFnd, String.CASE_INSENSITIVE_ORDER);
                        Statistics.this.outputFile.println(nl + "Nbr of references not found = " + itemsRefsNotFnd.size());
                        for (String string : itemsRefsNotFnd) {
                            Statistics.this.outputFile.println("   " + string);
                        }
                    }
                    if (itemsRefsFnd != null && !itemsRefsFnd.isEmpty()) {
                        Object[] keys;
                        itemsNames.clear();
                        for (Object k : keys = ((Statistics)Statistics.this).pd.references.referenceKeys()) {
                            if (k == null) continue;
                            ok = false;
                            String t = k.toString().trim();
                            for (String string : itemsRefsFnd) {
                                if (string == null || !string.equalsIgnoreCase(t)) continue;
                                ok = true;
                                break;
                            }
                            if (ok) continue;
                            itemsNames.add(t);
                        }
                        if (itemsNames.size() > 0) {
                            Collections.sort(itemsNames, String.CASE_INSENSITIVE_ORDER);
                            Statistics.this.outputFile.println(nl + "References not used:");
                            for (String t : itemsNames) {
                                Statistics.this.outputFile.println("   " + t);
                            }
                        }
                    }
                }
                Statistics.this.outputFile.flush();
                Statistics.this.outputFile.close();
                if (Statistics.this.finished) {
                    tmpFile.delete();
                }
                return null;
            }

            @Override
            protected void done() {
                Statistics.this.setCursor(new Cursor(0));
                if (Statistics.this.finished) {
                    Statistics.this.closeWindow();
                    return;
                }
                String msg = "Written file:" + nl + "   \"" + LOGfileName + "\"";
                System.out.println(msg + nl + "\"Statistics\" finished.");
                JOptionPane.showMessageDialog(Statistics.this, msg, ((Statistics)Statistics.this).pc.progName, 1);
                Statistics.this.jButtonClose.setEnabled(true);
                Statistics.this.jButtonClose.requestFocusInWindow();
            }
        }.execute();
        return true;
    }
}

