/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import lib.common.Util;
import lib.database.AddDataElem;
import lib.database.CSVparser;
import lib.database.Complex;
import lib.huvud.Div;
import lib.huvud.ProgramConf;

public class LibDB {
    public static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    public static final int ELEMENTS = 104;
    public static String[] elementName = new String[113];
    public static String[] elementSymb = new String[113];
    private static String ELEMS_COMPS = "ElemsComps";
    private static final String nl = System.getProperty("line.separator");
    private static final String SLASH = File.separator;

    private static void setElementNames() {
        LibDB.elementSymb[0] = "e-";
        LibDB.elementSymb[1] = "H";
        LibDB.elementSymb[2] = "He";
        LibDB.elementSymb[3] = "Li";
        LibDB.elementSymb[4] = "Be";
        LibDB.elementSymb[5] = "B";
        LibDB.elementSymb[6] = "C";
        LibDB.elementSymb[7] = "N";
        LibDB.elementSymb[8] = "O";
        LibDB.elementSymb[9] = "F";
        LibDB.elementSymb[10] = "Ne";
        LibDB.elementSymb[11] = "Na";
        LibDB.elementSymb[12] = "Mg";
        LibDB.elementSymb[13] = "Al";
        LibDB.elementSymb[14] = "Si";
        LibDB.elementSymb[15] = "P";
        LibDB.elementSymb[16] = "S";
        LibDB.elementSymb[17] = "Cl";
        LibDB.elementSymb[18] = "Ar";
        LibDB.elementSymb[19] = "K";
        LibDB.elementSymb[20] = "Ca";
        LibDB.elementSymb[21] = "Sc";
        LibDB.elementSymb[22] = "Ti";
        LibDB.elementSymb[23] = "V";
        LibDB.elementSymb[24] = "Cr";
        LibDB.elementSymb[25] = "Mn";
        LibDB.elementSymb[26] = "Fe";
        LibDB.elementSymb[27] = "Co";
        LibDB.elementSymb[28] = "Ni";
        LibDB.elementSymb[29] = "Cu";
        LibDB.elementSymb[30] = "Zn";
        LibDB.elementSymb[31] = "Ga";
        LibDB.elementSymb[32] = "Ge";
        LibDB.elementSymb[33] = "As";
        LibDB.elementSymb[34] = "Se";
        LibDB.elementSymb[35] = "Br";
        LibDB.elementSymb[36] = "Kr";
        LibDB.elementSymb[37] = "Rb";
        LibDB.elementSymb[38] = "Sr";
        LibDB.elementSymb[39] = "Y";
        LibDB.elementSymb[40] = "Zr";
        LibDB.elementSymb[41] = "Nb";
        LibDB.elementSymb[42] = "Mo";
        LibDB.elementSymb[43] = "Tc";
        LibDB.elementSymb[44] = "Ru";
        LibDB.elementSymb[45] = "Rh";
        LibDB.elementSymb[46] = "Pd";
        LibDB.elementSymb[47] = "Ag";
        LibDB.elementSymb[48] = "Cd";
        LibDB.elementSymb[49] = "In";
        LibDB.elementSymb[50] = "Sn";
        LibDB.elementSymb[51] = "Sb";
        LibDB.elementSymb[52] = "Te";
        LibDB.elementSymb[53] = "I";
        LibDB.elementSymb[54] = "Xe";
        LibDB.elementSymb[55] = "Cs";
        LibDB.elementSymb[56] = "Ba";
        LibDB.elementSymb[57] = "La";
        LibDB.elementSymb[58] = "Ce";
        LibDB.elementSymb[59] = "Pr";
        LibDB.elementSymb[60] = "Nd";
        LibDB.elementSymb[61] = "Pm";
        LibDB.elementSymb[62] = "Sm";
        LibDB.elementSymb[63] = "Eu";
        LibDB.elementSymb[64] = "Gd";
        LibDB.elementSymb[65] = "Tb";
        LibDB.elementSymb[66] = "Dy";
        LibDB.elementSymb[67] = "Ho";
        LibDB.elementSymb[68] = "Er";
        LibDB.elementSymb[69] = "Tm";
        LibDB.elementSymb[70] = "Yb";
        LibDB.elementSymb[71] = "Lu";
        LibDB.elementSymb[72] = "Hf";
        LibDB.elementSymb[73] = "Ta";
        LibDB.elementSymb[74] = "W";
        LibDB.elementSymb[75] = "Re";
        LibDB.elementSymb[76] = "Os";
        LibDB.elementSymb[77] = "Ir";
        LibDB.elementSymb[78] = "Pt";
        LibDB.elementSymb[79] = "Au";
        LibDB.elementSymb[80] = "Hg";
        LibDB.elementSymb[81] = "Tl";
        LibDB.elementSymb[82] = "Pb";
        LibDB.elementSymb[83] = "Bi";
        LibDB.elementSymb[84] = "Po";
        LibDB.elementSymb[85] = "At";
        LibDB.elementSymb[86] = "Rn";
        LibDB.elementSymb[87] = "Fr";
        LibDB.elementSymb[88] = "Ra";
        LibDB.elementSymb[89] = "Ac";
        LibDB.elementSymb[90] = "Th";
        LibDB.elementSymb[91] = "Pa";
        LibDB.elementSymb[92] = "U";
        LibDB.elementSymb[93] = "Np";
        LibDB.elementSymb[94] = "Pu";
        LibDB.elementSymb[95] = "Am";
        LibDB.elementSymb[96] = "Cm";
        LibDB.elementSymb[97] = "Bk";
        LibDB.elementSymb[98] = "Cf";
        LibDB.elementSymb[99] = "Es";
        LibDB.elementSymb[100] = "Fm";
        LibDB.elementSymb[101] = "Md";
        LibDB.elementSymb[102] = "No";
        LibDB.elementSymb[103] = "Lr";
        LibDB.elementSymb[104] = "Rf";
        LibDB.elementSymb[105] = "Db";
        LibDB.elementSymb[106] = "Sg";
        LibDB.elementSymb[107] = "Bh";
        LibDB.elementSymb[108] = "Hs";
        LibDB.elementSymb[109] = "Mt";
        LibDB.elementSymb[110] = "Ds";
        LibDB.elementSymb[111] = "Rg";
        LibDB.elementSymb[112] = "Cn";
        LibDB.elementName[0] = "Electron";
        LibDB.elementName[1] = "Hydrogen";
        LibDB.elementName[2] = "Helium";
        LibDB.elementName[3] = "Lithium";
        LibDB.elementName[4] = "Beryllium";
        LibDB.elementName[5] = "Boron";
        LibDB.elementName[6] = "Carbon";
        LibDB.elementName[7] = "Nitrogen";
        LibDB.elementName[8] = "Oxygen";
        LibDB.elementName[9] = "Fluorine";
        LibDB.elementName[10] = "Neon";
        LibDB.elementName[11] = "Sodium";
        LibDB.elementName[12] = "Magnesium";
        LibDB.elementName[13] = "Aluminium";
        LibDB.elementName[14] = "Silicon";
        LibDB.elementName[15] = "Phosphorus";
        LibDB.elementName[16] = "Sulfur";
        LibDB.elementName[17] = "Chlorine";
        LibDB.elementName[18] = "Argon";
        LibDB.elementName[19] = "Potassium";
        LibDB.elementName[20] = "Calcium";
        LibDB.elementName[21] = "Scandium";
        LibDB.elementName[22] = "Titanium";
        LibDB.elementName[23] = "Vanadium";
        LibDB.elementName[24] = "Chromium";
        LibDB.elementName[25] = "Manganese";
        LibDB.elementName[26] = "Iron";
        LibDB.elementName[27] = "Cobalt";
        LibDB.elementName[28] = "Nickel";
        LibDB.elementName[29] = "Copper";
        LibDB.elementName[30] = "Zinc";
        LibDB.elementName[31] = "Gallium";
        LibDB.elementName[32] = "Germanium";
        LibDB.elementName[33] = "Arsenic";
        LibDB.elementName[34] = "Selenium";
        LibDB.elementName[35] = "Bromine";
        LibDB.elementName[36] = "Krypton";
        LibDB.elementName[37] = "Rubidium";
        LibDB.elementName[38] = "Strontium";
        LibDB.elementName[39] = "Yttrium";
        LibDB.elementName[40] = "Zirconium";
        LibDB.elementName[41] = "Niobium";
        LibDB.elementName[42] = "Molybdenum";
        LibDB.elementName[43] = "Technetium";
        LibDB.elementName[44] = "Ruthenium";
        LibDB.elementName[45] = "Rhodium";
        LibDB.elementName[46] = "Palladium";
        LibDB.elementName[47] = "Silver";
        LibDB.elementName[48] = "Cadmium";
        LibDB.elementName[49] = "Indium";
        LibDB.elementName[50] = "Tin";
        LibDB.elementName[51] = "Antimony";
        LibDB.elementName[52] = "Tellurium";
        LibDB.elementName[53] = "Iodine";
        LibDB.elementName[54] = "Xenon";
        LibDB.elementName[55] = "Caesium";
        LibDB.elementName[56] = "Barium";
        LibDB.elementName[57] = "Lanthanum";
        LibDB.elementName[58] = "Cerium";
        LibDB.elementName[59] = "Praseodymium";
        LibDB.elementName[60] = "Neodymium";
        LibDB.elementName[61] = "Promethium";
        LibDB.elementName[62] = "Samarium";
        LibDB.elementName[63] = "Europium";
        LibDB.elementName[64] = "Gadolinium";
        LibDB.elementName[65] = "Terbium";
        LibDB.elementName[66] = "Dysprosium";
        LibDB.elementName[67] = "Holmium";
        LibDB.elementName[68] = "Erbium";
        LibDB.elementName[69] = "Thulium";
        LibDB.elementName[70] = "Ytterbium";
        LibDB.elementName[71] = "Lutetium";
        LibDB.elementName[72] = "Hafnium";
        LibDB.elementName[73] = "Tantalum";
        LibDB.elementName[74] = "Tungsten";
        LibDB.elementName[75] = "Rhenium";
        LibDB.elementName[76] = "Osmium";
        LibDB.elementName[77] = "Iridium";
        LibDB.elementName[78] = "Platinum";
        LibDB.elementName[79] = "Gold";
        LibDB.elementName[80] = "Mercury";
        LibDB.elementName[81] = "Thallium";
        LibDB.elementName[82] = "Lead";
        LibDB.elementName[83] = "Bismuth";
        LibDB.elementName[84] = "Polonium";
        LibDB.elementName[85] = "Astatine";
        LibDB.elementName[86] = "Radon";
        LibDB.elementName[87] = "Francium";
        LibDB.elementName[88] = "Radium";
        LibDB.elementName[89] = "Actinium";
        LibDB.elementName[90] = "Thorium";
        LibDB.elementName[91] = "Protactinium";
        LibDB.elementName[92] = "Uranium";
        LibDB.elementName[93] = "Neptunium";
        LibDB.elementName[94] = "Plutonium";
        LibDB.elementName[95] = "Americium";
        LibDB.elementName[96] = "Curium";
        LibDB.elementName[97] = "Berkelium";
        LibDB.elementName[98] = "Californium";
        LibDB.elementName[99] = "Einsteinium";
        LibDB.elementName[100] = "Fermium";
        LibDB.elementName[101] = "Mendelevium";
        LibDB.elementName[102] = "Nobelium";
        LibDB.elementName[103] = "Lawrencium";
        LibDB.elementName[104] = "Rutherfordium";
        LibDB.elementName[105] = "Dubnium";
        LibDB.elementName[106] = "Seaborgium";
        LibDB.elementName[107] = "Bohrium";
        LibDB.elementName[108] = "Hassium";
        LibDB.elementName[109] = "Meitnerium";
        LibDB.elementName[110] = "Darmstadtium";
        LibDB.elementName[111] = "Roentgenium";
        LibDB.elementName[112] = "Copernicium";
    }

    public static boolean getElements(Component parent, ProgramConf pc, ArrayList<String> dataBasesList, ArrayList<String[]> elemCompStringArray) {
        if (pc.dbg) {
            System.out.println("-- getElements(..)");
        }
        if (dataBasesList == null) {
            Util.exceptn((String)"Programming error: dataBasesList = null in \"getElements\"");
            return false;
        }
        if (elemCompStringArray == null) {
            Util.exceptn((String)"Programming error: elemCompStringArray = null in \"getElements\"");
            return false;
        }
        elemCompStringArray.clear();
        elemCompStringArray.add(new String[]{"H", "H+", "hydrogen ion"});
        if (dataBasesList.size() <= 0) {
            System.out.println("---- Warning: dataBasesList.size() = 0 in \"getElements\"");
            return true;
        }
        if (pc.dbg) {
            System.out.println("Reading metals and ligands from " + dataBasesList.size() + " data bases.");
        }
        int db = 0;
        while (db < dataBasesList.size()) {
            String elN;
            File elemFile;
            String dbName = dataBasesList.get(db);
            File dbFile = new File(dbName);
            boolean binaryDB = dbName.toLowerCase().endsWith(".db");
            if (binaryDB) {
                String msg;
                elemFile = new File(Div.getFileNameWithoutExtension((String)dbName) + ".elb");
                elN = elemFile.getName();
                if (dbFile.exists() && !elemFile.exists()) {
                    msg = "Can not find the \"element\"-file" + nl + "for database: \"" + dbFile.getName() + "\"." + nl + nl + "Expected to find file \"" + elN + "\".";
                    Util.exceptn((String)msg);
                    if (parent != null) {
                        if (!parent.isVisible()) {
                            parent.setVisible(true);
                        }
                        JOptionPane.showMessageDialog(parent, msg, pc.progName, 0);
                    }
                    return false;
                }
                if (dbFile.exists() && !elemFile.canRead()) {
                    msg = "Error: can not read the \"element\"-file" + nl + "for database: \"" + dbFile.getName() + "\"." + nl + nl + "You might not have permissions to read file \"" + elN + "\".";
                    Util.exceptn((String)msg);
                    if (parent != null) {
                        if (!parent.isVisible()) {
                            parent.setVisible(true);
                        }
                        JOptionPane.showMessageDialog(parent, msg, pc.progName, 0);
                    }
                    return false;
                }
                if (!dbFile.exists() && !elemFile.canRead()) {
                    if (pc.dbg) {
                        System.out.println("-- Warning: files \"" + dbFile.getName() + "\" and \"" + elN + "\" do not exist.");
                    }
                    ++db;
                    continue;
                }
            } else {
                String elemFileN = AddDataElem.getElemFileName(pc.dbg, parent, dbName);
                if (elemFileN == null || elemFileN.trim().length() <= 0) {
                    return false;
                }
                elemFile = new File(elemFileN);
                elN = elemFile.getName();
                if (dbFile.exists()) {
                    String msg;
                    if (!elemFile.exists()) {
                        msg = "Could not find the \"element\"-file" + nl + "for database: \"" + dbFile.getName() + "\"." + nl + nl + "The file \"" + elN + "\" will be created.";
                        Util.exceptn((String)msg);
                        if (parent != null) {
                            if (!parent.isVisible()) {
                                parent.setVisible(true);
                            }
                            JOptionPane.showMessageDialog(parent, msg, pc.progName, 0);
                        }
                        try {
                            AddDataElem.elemCompAdd_Update(pc.dbg, parent, dbName, elemFileN, elemCompStringArray, new ArrayList<String[]>());
                        }
                        catch (AddDataElem.AddDataException ex) {
                            Util.exceptn((String)ex.toString());
                            if (parent != null) {
                                if (!parent.isVisible()) {
                                    parent.setVisible(true);
                                }
                                JOptionPane.showMessageDialog(parent, ex.getMessage(), pc.progName, 0);
                            }
                            return false;
                        }
                    } else if (!elemFile.canRead()) {
                        msg = "Error: can not rean the \"element\"-file" + nl + "for database: \"" + dbFile.getName() + "\"." + nl + nl + "You might not have permissions to read file \"" + elN + "\".";
                        Util.exceptn((String)msg);
                        if (parent != null) {
                            if (!parent.isVisible()) {
                                parent.setVisible(true);
                            }
                            JOptionPane.showMessageDialog(parent, msg, pc.progName, 0);
                        }
                        return false;
                    }
                } else if (!elemFile.canRead()) {
                    if (pc.dbg) {
                        System.out.println("-- Warning: files \"" + dbFile.getName() + "\" and \"" + elN + "\" do not exist.");
                    }
                    ++db;
                    continue;
                }
            }
            if (pc.dbg) {
                System.out.println("  File \"" + elemFile + "\"");
            }
            try {
                if (binaryDB) {
                    LibDB.readElemFileBinary(pc.dbg, elemFile, elemCompStringArray);
                } else {
                    LibDB.readElemFileText(elemFile, elemCompStringArray);
                }
            }
            catch (ReadElemException ex) {
                Util.exceptn((String)ex.toString());
                if (parent != null) {
                    if (!parent.isVisible()) {
                        parent.setVisible(true);
                    }
                    JOptionPane.showMessageDialog(parent, ex.getMessage(), pc.progName, 0);
                }
                System.err.println("Removing file \"" + dbName + "\"" + nl + "from the database list");
                for (int i = 0; i < dataBasesList.size(); ++i) {
                    if (!dataBasesList.get(i).equals(dbName)) continue;
                    dataBasesList.remove(i);
                    break;
                }
            }
            ++db;
        }
        return true;
    }

    public static void readElemFileText(File elemFile, ArrayList<String[]> elemCompStringArray) throws ReadElemException {
        BufferedReader br;
        if (elemFile == null) {
            throw new ReadElemException("Input file is \"null\"!");
        }
        String elN = elemFile.getName();
        if (elN == null) {
            throw new ReadElemException("Input file is \"null\"!");
        }
        elN = elemFile.getAbsolutePath();
        if (!elemFile.exists()) {
            throw new ReadElemException("Input file does not exist" + nl + "\"" + elN + "\"");
        }
        if (!elemFile.canRead()) {
            throw new ReadElemException("Can not read input file" + nl + "\"" + elN + "\"");
        }
        try {
            br = new BufferedReader(new FileReader(elemFile));
        }
        catch (FileNotFoundException ex) {
            throw new ReadElemException(ex.getMessage());
        }
        String line = null;
        int lineNbr = 0;
        String[] elemCompLocal = null;
        try {
            while ((line = br.readLine()) != null) {
                int n;
                ArrayList<String> aList;
                ++lineNbr;
                if (line.length() <= 0 || line.trim().startsWith("/")) continue;
                try {
                    aList = CSVparser.splitLine(line);
                }
                catch (CSVparser.CSVdataException ex) {
                    throw new ReadTxtElemEx("Error (CSVdataException) " + ex.getMessage() + nl + "while reading line nbr " + lineNbr + ":" + nl + "    " + line + nl + "from file:" + nl + "   \"" + elN + "\"");
                }
                String element = aList.get(0);
                if (element == null || element.length() <= 0) {
                    throw new ReadTxtElemEx("Error: empty element in line" + nl + "   " + line + nl + "in file" + nl + "   \"" + elN + "\"");
                }
                try {
                    n = Integer.parseInt(aList.get(1));
                }
                catch (NumberFormatException ex) {
                    throw new ReadTxtElemEx("Error reading an integer from \"" + aList.get(1) + "\" in line" + nl + "   " + line + nl + "in file" + nl + "   \"" + elN + "\"");
                }
                if (n > 0) {
                    int i;
                    if (aList.size() < 3 || n * 2 > aList.size() - 1) {
                        String msg = "Error: too litle data" + nl + "while reading line" + nl + "    " + line + nl + "from file:" + nl + "   \"" + elN + "\"";
                        throw new ReadTxtElemEx(msg);
                    }
                    boolean found = false;
                    for (i = 0; i < elementSymb.length; ++i) {
                        if (!element.equals(elementSymb[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        element = "XX";
                    }
                    block18: for (i = 0; i < n; ++i) {
                        String t1 = aList.get(i * 2 + 2);
                        if (t1.length() <= 0) {
                            String msg = "Error: empty reactant" + nl + "while reading line" + nl + "    " + line + nl + "from file:" + nl + "   \"" + elN + "\"";
                            throw new ReadTxtElemEx(msg);
                        }
                        int j = i * 2 + 3;
                        String t2 = j < aList.size() ? aList.get(j) : "";
                        if (t1.startsWith("@") && elemCompStringArray.size() > 0) {
                            t1 = t1.substring(1);
                            j = elemCompStringArray.size();
                            while (j > 0) {
                                if (!elemCompStringArray.get(--j)[1].equals(t1)) continue;
                                elemCompStringArray.remove(j);
                                continue block18;
                            }
                            continue;
                        }
                        int jFound = -1;
                        int k = elemCompStringArray.size();
                        for (j = 0; j < k; ++j) {
                            if (!elemCompStringArray.get(j)[0].equals(element) || !elemCompStringArray.get(j)[1].equals(t1)) continue;
                            jFound = j;
                            elemCompLocal = elemCompStringArray.get(jFound);
                            break;
                        }
                        if (jFound > -1) {
                            if (t2.length() <= 0) continue;
                            elemCompLocal[2] = t2;
                            elemCompStringArray.set(jFound, elemCompLocal);
                            continue;
                        }
                        elemCompLocal = new String[]{element, t1, t2};
                        elemCompStringArray.add(elemCompLocal);
                    }
                    continue;
                }
                throw new ReadTxtElemEx("Error reading \"" + aList.get(1) + "\" (must be a number >0)" + nl + "in line" + nl + "   " + line + nl + "in file" + nl + "   \"" + elN + "\"");
            }
        }
        catch (ReadTxtElemEx ex) {
            throw new ReadElemException(ex.getMessage());
        }
        catch (IOException ex) {
            Util.exceptn((String)Util.stack2string((Exception)ex));
            throw new ReadElemException("Error " + ex.getMessage() + nl + "while reading line" + nl + "    " + line + nl + "from file:" + nl + "   \"" + elN + "\"");
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {
                throw new ReadElemException("Error " + ex.getMessage() + nl + "closing file:" + nl + "   \"" + elN + "\"");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readElemFileBinary(boolean dbg, File elemFile, ArrayList<String[]> elemCompStringArray) throws ReadElemException {
        if (elemFile == null) {
            throw new ReadElemException("Input file is \"null\"!");
        }
        elN = elemFile.getName();
        if (elN == null) {
            throw new ReadElemException("Input file is \"null\"!");
        }
        if (!elemFile.exists()) {
            throw new ReadElemException("Input file does not exist" + LibDB.nl + "\"" + elN + "\"");
        }
        if (!elemFile.canRead()) {
            throw new ReadElemException("Can not read input file" + LibDB.nl + "\"" + elN + "\"");
        }
        dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(elemFile));
        }
        catch (FileNotFoundException ex) {
            if (dis == null) throw new ReadElemException("Error " + ex.getMessage() + LibDB.nl + "   in \"readElemFileBinary\"");
            try {
                dis.close();
                throw new ReadElemException("Error " + ex.getMessage() + LibDB.nl + "   in \"readElemFileBinary\"");
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new ReadElemException("Error " + ex.getMessage() + LibDB.nl + "   in \"readElemFileBinary\"");
        }
        if (dbg) {
            System.out.println("  readElemFileBinary(" + elemFile + ")");
        }
        elemCompLocal = null;
        first = true;
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                if ((element = dis.readUTF()) == null || element.length() <= 0) {
                    if (first == false) return;
                    throw new ReadElemException("Error in \"readElemFileBinary\"" + LibDB.nl + "could not read the first element from file:" + LibDB.nl + "   \"" + elN + "\".");
                }
                first = false;
                n = dis.readInt();
                if (n <= 0) continue;
                found = false;
                break;
            }
        }
        catch (EOFException eof) {
            if (first == false) return;
            throw new ReadElemException("Error in \"readElemFileBinary\"" + LibDB.nl + "could not read the first element from file:" + LibDB.nl + "   \"" + elN + "\".");
        }
        catch (IOException ex) {
            throw new ReadElemException(Util.stack2string((Exception)ex));
        }
        catch (ReadElemException ex) {
            throw new ReadElemException(Util.stack2string((Exception)ex));
        }
        for (i = 0; i < LibDB.elementSymb.length; ++i) {
            if (!element.equals(LibDB.elementSymb[i])) continue;
            found = true;
            break;
        }
        if (!found) {
            element = "XX";
        }
        i = 0;
        while (true) {
            if (i < n) ** break;
            ** continue;
            t1 = dis.readUTF();
            t2 = dis.readUTF();
            if (t1.startsWith("@") && elemCompStringArray.size() > 0) {
                t1 = t1.substring(1);
                j = elemCompStringArray.size();
                while (j > 0) {
                    if (!elemCompStringArray.get(--j)[1].equals(t1)) continue;
                    elemCompStringArray.remove(j);
                    break;
                }
            } else {
                jFound = -1;
                k = elemCompStringArray.size();
                for (j = 0; j < k; ++j) {
                    if (!elemCompStringArray.get(j)[0].equals(element) || !elemCompStringArray.get(j)[1].equals(t1)) continue;
                    jFound = j;
                    elemCompLocal = elemCompStringArray.get(jFound);
                    break;
                }
                if (jFound > -1) {
                    if (t2.length() > 0) {
                        elemCompLocal[2] = t2;
                        elemCompStringArray.set(jFound, elemCompLocal);
                    }
                } else {
                    elemCompLocal = new String[]{element, t1, t2};
                    elemCompStringArray.add(elemCompLocal);
                }
            }
            ++i;
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException ex) {}
        }
    }

    public static synchronized void checkDataBasesList(ArrayList<String> dataBasesList, boolean dbg) {
        String dbName;
        if (dataBasesList == null || dataBasesList.size() <= 0) {
            return;
        }
        int nbr = dataBasesList.size();
        int i = 0;
        while (i < nbr) {
            dbName = dataBasesList.get(i);
            if (dbName != null && dbName.length() > 0) {
                if (LibDB.isDBnameOK(dbName, dbg)) {
                    ++i;
                    continue;
                }
            } else if (dbg) {
                System.err.println("Error: found an empty database name in position " + i);
            }
            dataBasesList.remove(i);
            --nbr;
        }
        i = 0;
        if (nbr > 1) {
            while (i < nbr) {
                int j;
                dbName = dataBasesList.get(i);
                boolean found = false;
                for (j = i + 1; j < nbr; ++j) {
                    if (!dbName.equalsIgnoreCase(dataBasesList.get(j))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ++i;
                    continue;
                }
                if (dbg) {
                    System.out.println("Warnng: found duplicated database: \"" + dbName + "\"");
                }
                dataBasesList.remove(j);
                --nbr;
            }
        }
    }

    public static boolean isDBnameOK(String dBname, boolean dbg) {
        boolean ok = true;
        if (dBname != null && dBname.length() > 0) {
            File dbf = new File(dBname);
            if (!dbf.exists()) {
                if (dbg) {
                    System.err.println("Error: database \"" + dBname + "\"" + nl + "   does not exist.");
                }
                ok = false;
            } else if (!dbf.canRead()) {
                if (dbg) {
                    System.err.println("Error: no read permission" + nl + "    for database \"" + dBname + "\".");
                }
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    public static Complex getTxtComplex(BufferedReader br) throws ReadTxtCmplxException, EndOfFileException {
        if (br == null) {
            return null;
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                Complex cmplx;
                if (line.trim().length() <= 0 || line.trim().toUpperCase().startsWith("COMPLEX") || line.trim().startsWith("/")) continue;
                try {
                    cmplx = Complex.fromString(line);
                }
                catch (Complex.ReadComplexException ex) {
                    throw new ReadTxtCmplxException(ex.getMessage());
                }
                if (cmplx == null) continue;
                return cmplx;
            }
        }
        catch (IOException ex) {
            throw new ReadTxtCmplxException(ex.getMessage());
        }
        throw new EndOfFileException();
    }

    public static void writeTxtComplex(PrintWriter pw, Complex cmplx) throws WriteTxtCmplxException {
        if (pw == null) {
            throw new WriteTxtCmplxException(nl + "Error: PrintWriter = null in \"writeTxtComplex\"");
        }
        if (cmplx == null) {
            throw new WriteTxtCmplxException(nl + "Error: cmplx = null in \"writeTxtComplex\"");
        }
        if (cmplx.name == null || cmplx.name.length() <= 0) {
            throw new WriteTxtCmplxException(nl + "Error: empty cmplx name in \"writeTxtComplex\"");
        }
        try {
            pw.print(cmplx.name + ";");
            pw.print(Util.formatDbl3((double)cmplx.constant).trim() + ";");
            if (cmplx.deltH != -999999.9 && Math.abs(cmplx.deltH) >= 1.0E-4) {
                pw.print(Util.formatDbl3((double)cmplx.deltH).trim());
            }
            pw.print(";");
            if (cmplx.deltCp != -999999.9 && Math.abs(cmplx.deltCp) >= 1.0E-4) {
                pw.print(Util.formatDbl3((double)cmplx.deltCp).trim());
            }
            pw.print(";");
            for (int i = 0; i < 6; ++i) {
                pw.print(cmplx.component[i] + ";");
                if (Math.abs(cmplx.numcomp[i]) >= 0.001) {
                    pw.print(Util.formatDbl4((double)cmplx.numcomp[i]).trim());
                }
                pw.print(";");
            }
            pw.print(Util.formatDbl4((double)cmplx.proton).trim());
            pw.print(";");
            pw.print(cmplx.reference);
            if (cmplx.comment.length() > 0) {
                pw.print(" /" + cmplx.comment);
            }
            pw.println();
        }
        catch (Exception ex) {
            throw new WriteTxtCmplxException(nl + "Error: " + ex.getMessage() + nl + " in \"writeTxtComplex\"");
        }
    }

    public static Complex getBinComplex(DataInputStream dis) throws ReadBinCmplxException {
        if (dis == null) {
            return null;
        }
        Complex cmplx = new Complex();
        StringBuilder nowReading = new StringBuilder();
        nowReading.replace(0, nowReading.length(), "Name of complex");
        try {
            cmplx.name = dis.readUTF();
            if (cmplx.name == null) {
                throw new ReadBinCmplxException(nl + "Error: complex name = \"null\".");
            }
            nowReading.replace(0, nowReading.length(), "logK for `" + cmplx.name + "\u00b4");
            cmplx.constant = dis.readDouble();
            nowReading.replace(0, nowReading.length(), "delta-H for `" + cmplx.name + "\u00b4");
            cmplx.deltH = dis.readDouble();
            nowReading.replace(0, nowReading.length(), "delta-Cp for `" + cmplx.name + "\u00b4");
            cmplx.deltCp = dis.readDouble();
            for (int i = 0; i < 6; ++i) {
                nowReading.replace(0, nowReading.length(), "reactant nbr." + (i + 1) + " for `" + cmplx.name + "\u00b4");
                cmplx.component[i] = dis.readUTF();
                nowReading.replace(0, nowReading.length(), "stoichiometric coeff. nbr." + (i + 1) + " for `" + cmplx.name + "\u00b4");
                cmplx.numcomp[i] = dis.readDouble();
            }
            nowReading.replace(0, nowReading.length(), "nbr H+ for `" + cmplx.name + "\u00b4");
            cmplx.proton = dis.readDouble();
            nowReading.replace(0, nowReading.length(), "reference for `" + cmplx.name + "\u00b4");
            cmplx.reference = dis.readUTF();
            cmplx.comment = dis.readUTF();
        }
        catch (EOFException eof) {
            return null;
        }
        catch (IOException ex) {
            throw new ReadBinCmplxException(nl + "Error: " + ex.getMessage() + nl + "while reading \"" + nowReading.toString() + "\"");
        }
        catch (ReadBinCmplxException ex) {
            throw new ReadBinCmplxException(nl + "Error: " + ex.getMessage() + nl + "while reading \"" + nowReading.toString() + "\"");
        }
        if (cmplx.name == null) {
            return null;
        }
        return cmplx;
    }

    public static void writeBinCmplx(DataOutputStream ds, Complex cmplx) throws WriteBinCmplxException {
        if (ds == null) {
            throw new WriteBinCmplxException(nl + "Error: DataOutputStream = null in \"writeBinCmplx\"");
        }
        if (cmplx == null) {
            throw new WriteBinCmplxException(nl + "Error: cmplx = null in \"writeBinCmplx\"");
        }
        if (cmplx.name == null || cmplx.name.length() <= 0) {
            throw new WriteBinCmplxException(nl + "Error: empty cmplx in \"writeBinCmplx\"");
        }
        try {
            ds.writeUTF(cmplx.name);
            ds.writeDouble(cmplx.constant);
            if (cmplx.deltH != -999999.9) {
                ds.writeDouble(cmplx.deltH);
            } else {
                ds.writeDouble(-999999.9);
            }
            if (cmplx.deltCp != -999999.9) {
                ds.writeDouble(cmplx.deltCp);
            } else {
                ds.writeDouble(-999999.9);
            }
            for (int i = 0; i < 6; ++i) {
                ds.writeUTF(cmplx.component[i]);
                ds.writeDouble(cmplx.numcomp[i]);
            }
            ds.writeDouble(cmplx.proton);
            ds.writeUTF(cmplx.reference);
            if (cmplx.comment != null && cmplx.comment.length() >= 0) {
                ds.writeUTF(cmplx.comment);
            } else {
                ds.writeUTF("");
            }
        }
        catch (IOException ex) {
            throw new WriteBinCmplxException(nl + "Error: " + ex.getMessage() + nl + "in \"writeBinCmplx\"");
        }
    }

    public static String getDiagramProgr(String diagramProgr) {
        String progName;
        if (diagramProgr == null || diagramProgr.trim().length() <= 0) {
            return null;
        }
        File f = new File(diagramProgr);
        String os = System.getProperty("os.name").toLowerCase();
        if (f.isDirectory() && !os.startsWith("mac os")) {
            return null;
        }
        String dir = f.getParent();
        if (dir == null || dir.trim().length() <= 0) {
            return null;
        }
        String prog = f.getName();
        if (prog == null || prog.trim().length() <= 0) {
            return null;
        }
        f = new File(dir);
        if (!f.exists() || !f.isDirectory()) {
            return null;
        }
        dir = f.getAbsolutePath();
        if (dir != null && dir.endsWith(SLASH)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (prog.length() == 1) {
            if (prog.equals(".")) {
                return null;
            }
            progName = prog;
        } else {
            int dot = prog.lastIndexOf(".");
            progName = dot <= 0 ? prog : prog.substring(0, dot);
        }
        String name = dir + SLASH + progName + ".jar";
        f = new File(name);
        if (f.exists() && f.isFile()) {
            return name;
        }
        if (os.startsWith("windows") ? (f = new File(name = dir + SLASH + progName + ".exe")).exists() && f.isFile() : os.startsWith("mac os") && (f = new File(name = dir + SLASH + progName + ".app")).exists()) {
            return name;
        }
        return null;
    }

    static {
        LibDB.setElementNames();
    }

    public static class WriteBinCmplxException
    extends Exception {
        public WriteBinCmplxException() {
        }

        public WriteBinCmplxException(String txt) {
            super(txt);
        }
    }

    public static class WriteTxtCmplxException
    extends Exception {
        public WriteTxtCmplxException() {
        }

        public WriteTxtCmplxException(String txt) {
            super(txt);
        }
    }

    public static class ReadBinCmplxException
    extends Exception {
        public ReadBinCmplxException() {
        }

        public ReadBinCmplxException(String txt) {
            super(txt);
        }
    }

    public static class EndOfFileException
    extends Exception {
        public EndOfFileException() {
        }

        public EndOfFileException(String txt) {
            super(txt);
        }
    }

    public static class ReadTxtCmplxException
    extends Exception {
        public ReadTxtCmplxException() {
        }

        public ReadTxtCmplxException(String txt) {
            super(txt);
        }
    }

    private static class ReadTxtElemEx
    extends Exception {
        public ReadTxtElemEx() {
        }

        public ReadTxtElemEx(String txt) {
            super(txt);
        }
    }

    public static class ReadElemException
    extends Exception {
        public ReadElemException() {
        }

        public ReadElemException(String txt) {
            super(txt);
        }
    }
}

