/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import lib.common.Util;
import lib.database.Complex;
import lib.database.References;

public class ShowDetailsDialog
extends JDialog {
    private Dimension windowSize = new Dimension(280, 170);
    private boolean loading = true;
    private final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private final Border defBorder;
    private final Border highlightedBorder = BorderFactory.createBevelBorder(1, Color.gray, Color.black);
    private ButtonGroup buttonGroup1;
    private JButton jButtonOK;
    private JLabel jLabel0;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelComments;
    private JLabel jLabelDeltaCp;
    private JLabel jLabelDeltaH;
    private JLabel jLabelReaction;
    private JLabel jLabelRefs;
    private JLabel jLabellogK;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea;

    public ShowDetailsDialog(Frame parent, boolean modal, Complex species, References references) {
        super(parent, modal);
        int top;
        int left;
        this.initComponents();
        boolean dbg = true;
        if (species == null && dbg) {
            System.out.println("Warning in \"DataDisplayDialog\": null species.");
        }
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowDetailsDialog.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        this.getRootPane().getActionMap().put("ALT_X", escAction);
        if (species != null && species.name.trim().length() > 0) {
            this.setTitle("  Data for \"" + species.name.trim() + "\"");
        } else {
            this.setTitle("  Display Data");
        }
        this.defBorder = this.jScrollPane1.getBorder();
        if (parent != null) {
            left = Math.max(0, parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2);
            top = Math.max(0, parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2);
        } else {
            left = Math.max(0, (this.screenSize.width - this.getWidth()) / 2);
            top = Math.max(0, (this.screenSize.height - this.getHeight()) / 2);
        }
        this.setLocation(Math.min(this.screenSize.width - this.getWidth() - 20, left), Math.min(this.screenSize.height - this.getHeight() - 20, top));
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setColumns(40);
        this.jTextArea.setText("");
        this.jLabelReaction.setText(Complex.reactionText(species));
        if (species == null || Double.isNaN(species.constant) || species.constant == -999999.9) {
            this.jLabellogK.setText(" (empty)");
        } else {
            this.jLabellogK.setText(Util.formatDbl3((double)species.constant));
        }
        if (species == null || Double.isNaN(species.deltH) || species.deltH == -999999.9) {
            this.jLabelDeltaH.setText(" (empty)");
        } else {
            this.jLabelDeltaH.setText(Util.formatDbl3((double)species.deltH));
        }
        if (species == null || Double.isNaN(species.deltCp) || species.deltCp == -999999.9) {
            this.jLabelDeltaCp.setText(" (empty)");
        } else {
            this.jLabelDeltaCp.setText(Util.formatDbl3((double)species.deltCp));
        }
        if (species != null && species.reference != null && species.reference.trim().length() > 0) {
            String refs = species.reference.trim();
            this.jLabelRefs.setText(refs);
            if (references != null && refs.trim().length() > 0) {
                ArrayList<String> refKeys = references.splitRefs(refs);
                this.jTextArea.append(references.refsAsString(refKeys));
            }
        } else {
            this.jLabelRefs.setText(" (none)");
        }
        if (species != null && species.comment != null && species.comment.trim().length() > 0) {
            this.jLabelComments.setText(species.comment);
        } else {
            this.jLabelComments.setText(" (none)");
        }
        this.jTextArea.setCaretPosition(0);
        this.windowSize = this.getSize();
        this.loading = false;
        this.jButtonOK.requestFocusInWindow();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jLabel0 = new JLabel();
        this.jLabelReaction = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabellogK = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabelDeltaH = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabelDeltaCp = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabelComments = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabelRefs = new JLabel();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ShowDetailsDialog.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ShowDetailsDialog.this.formComponentResized(evt);
            }
        });
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('c');
        this.jButtonOK.setText("Close");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowDetailsDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel0.setFont(new Font("Dialog", 1, 13));
        this.jLabel0.setText("Reaction:");
        this.jLabelReaction.setFont(new Font("Dialog", 0, 11));
        this.jLabelReaction.setText("A + B = C");
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setText("<html>Data at 25&deg;C:</html>");
        this.jLabel2.setFont(new Font("Dialog", 1, 11));
        this.jLabel2.setText("<html>log <i>K</i>&deg; =</html>");
        this.jLabellogK.setFont(new Font("Dialog", 0, 11));
        this.jLabellogK.setText("-10.000");
        this.jLabel3.setFont(new Font("Dialog", 1, 11));
        this.jLabel3.setText("<html>&#916;<i>H</i>&deg; =</html>");
        this.jLabelDeltaH.setFont(new Font("Dialog", 0, 11));
        this.jLabelDeltaH.setText("-10.000");
        this.jLabel4.setFont(new Font("Dialog", 1, 11));
        this.jLabel4.setText("<html>&#916;<i>C<sub>p</sub></i>&deg;=</html>");
        this.jLabelDeltaCp.setFont(new Font("Dialog", 0, 11));
        this.jLabelDeltaCp.setText("-10.000");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabellogK)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jLabel4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDeltaCp).addComponent(this.jLabelDeltaH)))).addContainerGap(87, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabellogK)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jLabelDeltaH)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.jLabelDeltaCp))));
        this.jLabel6.setFont(new Font("Dialog", 1, 11));
        this.jLabel6.setText("Comments:");
        this.jLabelComments.setFont(new Font("Dialog", 0, 11));
        this.jLabelComments.setText(" (none)");
        this.jLabel5.setFont(new Font("Dialog", 1, 11));
        this.jLabel5.setText("Reference citations:");
        this.jLabelRefs.setFont(new Font("Dialog", 0, 11));
        this.jLabelRefs.setText("##");
        this.jLabel7.setFont(new Font("Dialog", 1, 11));
        this.jLabel7.setText("References:");
        this.jScrollPane1.setFont(new Font("Dialog", 0, 13));
        this.jTextArea.setEditable(false);
        this.jTextArea.setColumns(40);
        this.jTextArea.setFont(new Font("Dialog", 0, 13));
        this.jTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ShowDetailsDialog.this.jTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ShowDetailsDialog.this.jTextAreaFocusLost(evt);
            }
        });
        this.jTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ShowDetailsDialog.this.jTextAreaKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ShowDetailsDialog.this.jTextAreaKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 384, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelRefs)).addComponent(this.jLabel0).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelReaction)).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelComments))).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelReaction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabelComments)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabelRefs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jButtonOK)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 130, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.loading || this.windowSize == null) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int nw = Math.max(w, Math.round((float)this.windowSize.getWidth()));
        int nh = Math.max(h, Math.round((float)this.windowSize.getHeight()));
        int nx = x;
        int ny = y;
        if (x + nw > this.screenSize.width) {
            nx = this.screenSize.width - nw;
        }
        if (y + nh > this.screenSize.height) {
            ny = this.screenSize.height - nh;
        }
        if (x != nx || y != ny) {
            this.setLocation(nx, ny);
        }
        if (w != nw || h != nh) {
            this.setSize(nw, nh);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void jTextAreaKeyPressed(KeyEvent evt) {
        int ctrl = 128;
        if ((evt.getModifiersEx() & ctrl) == ctrl && (evt.getKeyCode() == 86 || evt.getKeyCode() == 88)) {
            evt.consume();
            return;
        }
        if (evt.getKeyCode() == 10) {
            evt.consume();
            this.closeWindow();
            return;
        }
        if (evt.getKeyCode() == 9) {
            evt.consume();
            return;
        }
        if (evt.getKeyCode() == 127) {
            evt.consume();
            return;
        }
        if (evt.getKeyCode() == 8) {
            evt.consume();
        }
    }

    private void jTextAreaKeyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void jTextAreaFocusGained(FocusEvent evt) {
        if (this.jTextArea.isFocusOwner()) {
            this.jScrollPane1.setBorder(this.highlightedBorder);
        }
    }

    private void jTextAreaFocusLost(FocusEvent evt) {
        if (!this.jTextArea.isFocusOwner()) {
            this.jScrollPane1.setBorder(this.defBorder);
        }
    }

    private void closeWindow() {
        this.dispose();
    }
}

