/*
 * Decompiled with CFR 0.152.
 */
package addShowRefs;

import addShowRefs.EditAddRefs;
import addShowRefs.Main;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lib.common.Util;
import lib.database.References;

public class AddShowRefs
extends JFrame {
    private final String pathApp;
    private static final String progName = "AddRefs";
    private References r = null;
    private Dimension windowSize = new Dimension(400, 280);
    private static final String nl = System.getProperty("line.separator");
    private static final String SLASH = File.separator;
    private JButton jButtonAdd;
    private JButton jButtonEdit;
    private JButton jButtonQuit;
    private JButton jButtonShow;
    private JComboBox jComboBoxKeys;
    private JLabel jLabel0;
    private JLabel jLabel1;
    private JLabel jLabelFileName;
    private JPanel jPanel1;

    public AddShowRefs() {
        this.initComponents();
        this.pathApp = Main.getPathApp();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point frameLocation = new Point(-1000, -1000);
        frameLocation.x = Math.max(0, (screenSize.width - this.getWidth()) / 2);
        frameLocation.y = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        this.setLocation(frameLocation);
        String iconName = "images/Refs.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            Image icon = new ImageIcon(imgURL).getImage();
            this.setIconImage(icon);
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                try {
                    Class<?> c = Class.forName("com.apple.eawt.Application");
                    Method m = c.getDeclaredMethod("setDockIconImage", Image.class);
                    Object i = c.newInstance();
                    Object[] paramsObj = new Object[]{icon};
                    m.invoke(i, paramsObj);
                }
                catch (Exception e) {
                    Util.exceptn("Error: " + e.getMessage());
                }
            }
        } else {
            Util.exceptn("Error: Could not load image = \"" + iconName + "\"");
        }
        this.jComboBoxKeys.removeAllItems();
        this.jComboBoxKeys.setEnabled(false);
        this.jButtonShow.setEnabled(false);
        this.jButtonEdit.setEnabled(false);
        this.jButtonAdd.setEnabled(false);
        this.jLabelFileName.setText("(not selected yet...)");
        this.setTitle("Show references");
    }

    private void start() {
        this.setCursor(new Cursor(3));
        String t = this.getFileName(this);
        if (t == null) {
            this.dispose();
            return;
        }
        this.jLabelFileName.setText(t);
        this.r = new References();
        if (!this.r.readRefsFile(t, false)) {
            String msg = "File:" + nl + "   " + t + nl + "does not exist." + nl + nl + "Create?" + nl + " ";
            Object[] opt = new Object[]{"Yes", "Exit"};
            int m = JOptionPane.showOptionDialog(this, msg, "Save/Show References", 0, 2, null, opt, opt[1]);
            if (m != 0) {
                this.dispose();
                return;
            }
            this.r.saveRefsFile(this, true);
        }
        this.fillComboBox();
        this.windowSize = this.getSize();
        this.setCursor(new Cursor(0));
    }

    private void initComponents() {
        this.jLabel0 = new JLabel();
        this.jLabelFileName = new JLabel();
        this.jButtonAdd = new JButton();
        this.jButtonQuit = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxKeys = new JComboBox();
        this.jButtonShow = new JButton();
        this.jButtonEdit = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AddShowRefs.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                AddShowRefs.this.formComponentResized(evt);
            }
        });
        this.jLabel0.setFont(new Font("Dialog", 0, 11));
        this.jLabel0.setText("Reference file:");
        this.jLabelFileName.setFont(new Font("Dialog", 1, 11));
        this.jLabelFileName.setText("jLabelFileName");
        this.jButtonAdd.setFont(new Font("Dialog", 0, 11));
        this.jButtonAdd.setMnemonic('a');
        this.jButtonAdd.setText("Add new reference");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddShowRefs.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonQuit.setFont(new Font("Dialog", 0, 11));
        this.jButtonQuit.setMnemonic('x');
        this.jButtonQuit.setText("Exit");
        this.jButtonQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddShowRefs.this.jButtonQuitActionPerformed(evt);
            }
        });
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("Keys:");
        this.jComboBoxKeys.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxKeys.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButtonShow.setFont(new Font("Dialog", 0, 11));
        this.jButtonShow.setMnemonic('s');
        this.jButtonShow.setText("Show");
        this.jButtonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddShowRefs.this.jButtonShowActionPerformed(evt);
            }
        });
        this.jButtonEdit.setFont(new Font("Dialog", 0, 11));
        this.jButtonEdit.setMnemonic('e');
        this.jButtonEdit.setText("Edit");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddShowRefs.this.jButtonEditActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonShow).addGap(18, 18, 18).addComponent(this.jButtonEdit)).addComponent(this.jComboBoxKeys, -2, 92, -2)).addGap(0, 10, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxKeys, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonShow).addComponent(this.jButtonEdit))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel0, -1, 313, Short.MAX_VALUE).addGap(33, 33, 33)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonQuit).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jLabelFileName, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jButtonAdd)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel0).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelFileName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonQuit).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.dispose();
    }

    private void jButtonQuitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                EditAddRefs sr = new EditAddRefs(AddShowRefs.this.r);
                sr.setVisible(true);
                sr.start();
                final String k = sr.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddShowRefs.this.setVisible(true);
                        AddShowRefs.this.fillComboBox();
                        AddShowRefs.this.setComboBoxKey(k);
                    }
                });
            }
        };
        t.start();
    }

    private void jButtonShowActionPerformed(ActionEvent evt) {
        if (this.jComboBoxKeys.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "No key is selected?", "Show refs", 3);
            return;
        }
        ArrayList<String> a = new ArrayList<String>();
        a.add(this.jComboBoxKeys.getSelectedItem().toString());
        this.r.displayRefs(this, true, null, a);
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jComboBoxKeys.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "No key is selected?", "Show refs", 3);
            return;
        }
        this.setVisible(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                EditAddRefs sr = new EditAddRefs(AddShowRefs.this.r);
                sr.setVisible(true);
                String key = AddShowRefs.this.jComboBoxKeys.getSelectedItem().toString();
                String reftxt = AddShowRefs.this.r.isRefThere(key);
                sr.start(key, reftxt);
                final String k = sr.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddShowRefs.this.setVisible(true);
                        AddShowRefs.this.fillComboBox();
                        AddShowRefs.this.setComboBoxKey(k);
                    }
                });
            }
        };
        t.start();
    }

    private void fillComboBox() {
        Object[] k = this.r.referenceKeys();
        if (k == null || k.length <= 0) {
            this.jComboBoxKeys.removeAllItems();
            this.jComboBoxKeys.setEnabled(false);
            this.jButtonShow.setEnabled(false);
            this.jButtonEdit.setEnabled(false);
            this.jButtonAdd.setEnabled(false);
            return;
        }
        this.jComboBoxKeys.setEnabled(true);
        this.jButtonShow.setEnabled(true);
        this.jButtonEdit.setEnabled(true);
        this.jButtonAdd.setEnabled(true);
        DefaultComboBoxModel<Object> dcbm = new DefaultComboBoxModel<Object>();
        ArrayList<String> keyList2 = new ArrayList<String>();
        for (Object o : k) {
            keyList2.add(o.toString());
        }
        Collections.sort(keyList2);
        for (Object ex : k = keyList2.toArray()) {
            if (ex.toString().length() <= 0) continue;
            dcbm.addElement(ex);
        }
        this.jComboBoxKeys.setModel(dcbm);
    }

    private void setComboBoxKey(String key) {
        if (key == null || key.trim().length() <= 0 || this.jComboBoxKeys.getItemCount() <= 0) {
            return;
        }
        int fnd = -1;
        for (int j = 0; j < this.jComboBoxKeys.getItemCount(); ++j) {
            if (!this.jComboBoxKeys.getItemAt(j).toString().equalsIgnoreCase(key)) continue;
            fnd = j;
            break;
        }
        if (fnd > -1) {
            this.jComboBoxKeys.setSelectedIndex(fnd);
        }
    }

    private String getFileName(Component frame) {
        frame.setCursor(new Cursor(3));
        boolean mustExist = false;
        String refFileName = Util.getOpenFileName(this, progName, mustExist, "Select a text file with references:", 7, this.pathApp + SLASH + "References.txt", null);
        frame.setCursor(new Cursor(0));
        if (refFileName == null || refFileName.trim().length() <= 0) {
            return null;
        }
        File refFile = new File(refFileName);
        if (!refFile.getName().toLowerCase().endsWith(".txt") && (refFile = new File(refFile.getAbsolutePath() + ".txt")).getName().contains(".")) {
            Object[] opt = new Object[]{"OK", "Cancel"};
            int answer = JOptionPane.showOptionDialog(frame, "Note: file name must end with \".txt\"" + nl + nl + "The file name will be:" + nl + "\"" + refFile.getName() + ".txt\"", progName, 0, 2, null, opt, opt[1]);
            if (answer != 0) {
                return null;
            }
        }
        if (refFile.exists() && !refFile.canWrite()) {
            JOptionPane.showMessageDialog(frame, "Can not overwrite file \"" + refFile.getName() + "\"." + nl + "The file or the directory is perhpas write-protected.", progName, 0);
            return null;
        }
        return refFile.getAbsolutePath();
    }

    public static void main(String[] args) {
        boolean windows = System.getProperty("os.name").startsWith("Windows");
        try {
            if (windows) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(System);");
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(CrossPlatform);");
            }
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        Util.configureOptionPane();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddShowRefs sr = new AddShowRefs();
                sr.setVisible(true);
                sr.start();
            }
        });
    }
}

