/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import spana.WinRegistry;

public class FileAssociation {
    private static final String PROGNAME = "Eq-Diagr";
    private static final String BACKUP = "Backup_by_Eq-Diagr";
    private static final String nl = System.getProperty("line.separator");

    public static void associateFileExtension(String ext, String pathToExecute) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, IOException, URISyntaxException {
        File iconFile;
        String msg = "Error in \"associateFileExtension\"" + nl;
        if (ext == null || ext.length() <= 0) {
            throw new IllegalArgumentException(msg + "\"ext\" is null or empty.");
        }
        if (pathToExecute == null || pathToExecute.length() <= 0) {
            throw new IllegalArgumentException(msg + "\"pathToExecute\" is null or empty.");
        }
        if (ext.contains(".")) {
            throw new IllegalArgumentException(msg + "\"ext\" = " + ext + " (must not contain a \".\")");
        }
        File fileToExecute = new File(pathToExecute);
        if (!fileToExecute.exists()) {
            throw new IllegalArgumentException(msg + "   \"pathToExecute\" = \"" + pathToExecute + "\"" + nl + "   file does not exist.");
        }
        String appName = "Eq-Diagr_" + ext.toUpperCase() + "_File";
        WinRegistry.createKey("Software\\Classes\\" + appName);
        WinRegistry.writeStringValue("Software\\Classes\\" + appName, "", appName);
        WinRegistry.createKey("Software\\Classes\\" + appName + "\\shell\\open\\command");
        WinRegistry.writeStringValue("Software\\Classes\\" + appName + "\\shell\\open\\command", "", pathToExecute + " \"%1\"");
        String path = fileToExecute.getParent();
        File pathF = new File(path);
        try {
            path = pathF.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        String iconFileName = null;
        if (ext.equalsIgnoreCase("dat") || ext.equalsIgnoreCase("plt")) {
            iconFileName = path + File.separator + "Icon_" + ext.toLowerCase().trim() + ".ico";
        }
        if (iconFileName != null && (iconFile = new File(iconFileName)).exists()) {
            WinRegistry.createKey("Software\\Classes\\" + appName + "\\DefaultIcon");
            WinRegistry.writeStringValue("Software\\Classes\\" + appName + "\\DefaultIcon", "", iconFileName);
        }
        String dotExt = "." + ext;
        String value = WinRegistry.readString("Software\\Classes\\" + dotExt, "");
        if (value != null && value.length() > 0 && !value.equals(appName)) {
            WinRegistry.createKey("Software\\Classes\\" + dotExt + "\\" + BACKUP);
            WinRegistry.writeStringValue("Software\\Classes\\" + dotExt + "\\" + BACKUP, "", value);
        } else {
            WinRegistry.createKey("Software\\Classes\\" + dotExt);
        }
        WinRegistry.writeStringValue("Software\\Classes\\" + dotExt, "", appName);
    }

    public static void unAssociateFileExtension(String ext) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, IOException, URISyntaxException {
        List<String> lst;
        String msg = "Error in \"unAssociateFileExtension\"" + nl;
        if (ext == null || ext.length() <= 0) {
            throw new IllegalArgumentException(msg + "\"ext\" is null or empty.");
        }
        if (ext.contains(".")) {
            throw new IllegalArgumentException(msg + "\"ext\" = " + ext + " (must not contain a \".\")");
        }
        String appName = "Eq-Diagr_" + ext.toUpperCase() + "_File";
        String value = WinRegistry.readString("Software\\Classes\\" + appName + "\\DefaultIcon", "");
        if (value != null) {
            WinRegistry.deleteValue("Software\\Classes\\" + appName + "\\DefaultIcon", "");
            lst = WinRegistry.readStringSubKeys("Software\\Classes\\" + appName + "\\DefaultIcon");
            if (lst == null || lst.isEmpty()) {
                WinRegistry.deleteKey("Software\\Classes\\" + appName + "\\DefaultIcon");
            }
        }
        if ((value = WinRegistry.readString("Software\\Classes\\" + appName + "\\shell\\open\\command", "")) != null) {
            WinRegistry.deleteValue("Software\\Classes\\" + appName + "\\shell\\open\\command", "");
            lst = WinRegistry.readStringSubKeys("Software\\Classes\\" + appName + "\\shell\\open\\command");
            if (lst == null || lst.isEmpty()) {
                WinRegistry.deleteKey("Software\\Classes\\" + appName + "\\shell\\open\\command");
                lst = WinRegistry.readStringSubKeys("Software\\Classes\\" + appName + "\\shell\\open");
                if (lst == null || lst.isEmpty()) {
                    WinRegistry.deleteKey("Software\\Classes\\" + appName + "\\shell\\open");
                    lst = WinRegistry.readStringSubKeys("Software\\Classes\\" + appName + "\\shell");
                    if (lst == null || lst.isEmpty()) {
                        WinRegistry.deleteKey("Software\\Classes\\" + appName + "\\shell");
                        lst = WinRegistry.readStringSubKeys("Software\\Classes\\" + appName);
                        if (lst == null || lst.isEmpty()) {
                            WinRegistry.deleteKey("Software\\Classes\\" + appName);
                        }
                    }
                }
            }
        }
        String dotExt = "." + ext;
        value = WinRegistry.readString("Software\\Classes\\" + dotExt, "");
        if (value != null && value.length() > 0 && value.equals(appName)) {
            WinRegistry.deleteValue("Software\\Classes\\" + dotExt, "");
        }
        if ((value = WinRegistry.readString("Software\\Classes\\" + dotExt + "\\" + BACKUP, "")) != null && value.length() > 0) {
            WinRegistry.writeStringValue("Software\\Classes\\" + dotExt, "", value);
            WinRegistry.deleteValue("Software\\Classes\\" + dotExt + "\\" + BACKUP, "");
            lst = WinRegistry.readStringSubKeys("Software\\Classes\\" + dotExt + "\\" + BACKUP);
            if (lst == null || lst.isEmpty()) {
                WinRegistry.deleteKey("Software\\Classes\\" + dotExt + "\\" + BACKUP);
            }
        }
        WinRegistry.deleteValue("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + dotExt + "\\OpenWithProgids", appName);
    }

    public static boolean isAssociated(String ext, String pathToExecute) throws IllegalArgumentException, InvocationTargetException, IllegalAccessException {
        String msg = "Error in \"isAssociated\"" + nl;
        if (ext == null || ext.length() <= 0) {
            throw new IllegalArgumentException(msg + "\"ext\" is null or empty.");
        }
        if (pathToExecute == null || pathToExecute.length() <= 0) {
            throw new IllegalArgumentException(msg + "\"pathToExecute\" is null or empty.");
        }
        if (ext.contains(".")) {
            throw new IllegalArgumentException(msg + "\"ext\" = " + ext + " (must not contain a \".\")");
        }
        String appName = "Eq-Diagr_" + ext.toUpperCase() + "_File";
        String value = WinRegistry.readString("Software\\Classes\\" + appName + "\\shell\\open\\command", "");
        if (value == null || value.length() <= 0) {
            return false;
        }
        if (!value.toLowerCase().startsWith(pathToExecute.toLowerCase())) {
            return false;
        }
        String dotExt = "." + ext;
        value = WinRegistry.readString("Software\\Classes\\" + dotExt, "");
        return value != null && value.length() > 0 && value.equalsIgnoreCase(appName);
    }
}

