/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.readDataLib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import lib.common.Util;

public class ReadDataLib {
    public String nowReading;
    public String dataFileName;
    public StringBuffer dataLineComment;
    public int DatabaseSpanaFile;
    private String temperatureString = null;
    private boolean temperatureUnitsK = false;
    private String temperatureDataLineNextOriginal = null;
    private String pressureString = null;
    private int pressureUnits = 0;
    private String pressureDataLineNextOriginal = null;
    private BufferedReader inputBuffReader;
    private StringBuffer thisDataLine;
    private StringBuffer thisDataLineOriginal;
    private StringBuffer nextDataLine;
    private StringBuffer nextDataLineOriginal;
    private String nextDataLineComment;
    private boolean reading1stLine;
    private static final String nl = System.getProperty("line.separator");

    public ReadDataLib(File inpF) throws DataFileException {
        if (inpF == null) {
            throw new DataFileException("Error in \"ReadDataLib\": input file is \"null\"!");
        }
        this.dataFileName = inpF.getPath();
        if (!inpF.exists()) {
            throw new DataFileException("Error in \"ReadDataLib\": input file does not exist" + nl + "  \"" + this.dataFileName + "\"");
        }
        if (!inpF.canRead()) {
            throw new DataFileException("Error in \"ReadDataLib\": can not read input file" + nl + "  \"" + this.dataFileName + "\"");
        }
        this.inputBuffReader = null;
        try {
            this.inputBuffReader = new BufferedReader(new FileReader(inpF));
        }
        catch (FileNotFoundException ex) {
            throw new DataFileException("Error in \"ReadDataLib\": " + ex.getMessage() + nl + "  with input file:\"" + this.dataFileName + "\"");
        }
        this.temperatureDataLineNextOriginal = null;
        this.temperatureString = null;
        this.temperatureUnitsK = false;
        this.pressureDataLineNextOriginal = null;
        this.pressureString = null;
        this.pressureUnits = 0;
        this.DatabaseSpanaFile = 0;
        this.reading1stLine = true;
        this.nowReading = null;
        this.thisDataLine = null;
        this.thisDataLineOriginal = null;
        this.nextDataLine = new StringBuffer();
        this.nextDataLineOriginal = new StringBuffer();
        this.dataLineComment = new StringBuffer();
    }

    public void close() throws ReadDataLibException {
        try {
            if (this.inputBuffReader != null) {
                this.inputBuffReader.close();
            }
        }
        catch (IOException ex) {
            throw new ReadDataLibException("Error in \"ReadDataLib.close\": " + ex.getMessage());
        }
        finally {
            this.dataFileName = null;
            this.nowReading = null;
            this.thisDataLine = null;
            this.thisDataLineOriginal = null;
            this.dataLineComment = null;
            this.nextDataLine = null;
            this.nextDataLineOriginal = null;
            this.nextDataLineComment = null;
            this.pressureDataLineNextOriginal = null;
            this.pressureString = null;
            this.temperatureDataLineNextOriginal = null;
            this.temperatureString = null;
        }
    }

    public String readA() throws DataReadException, DataEofException {
        if (this.inputBuffReader == null) {
            return null;
        }
        if (this.nowReading == null) {
            this.nowReading = "a text string";
        }
        this.getThisDataLine();
        if (this.thisDataLine.length() <= 0) {
            this.nowReading = null;
            return null;
        }
        int j = this.thisDataLine.indexOf(",");
        int k = this.thisDataLine.length();
        if (j > -1 && j < k) {
            k = j;
        }
        if (k > -1 && k < this.thisDataLine.length()) {
            String txt = this.thisDataLine.substring(0, k).trim();
            this.thisDataLine.delete(0, k);
            if (this.thisDataLine.length() > 0 && this.thisDataLine.charAt(0) == ',') {
                this.thisDataLine.deleteCharAt(0);
            }
            this.thisDataLine = new StringBuffer(this.thisDataLine.toString().trim());
            this.nowReading = null;
            return txt;
        }
        String txt = this.thisDataLine.toString().trim();
        this.thisDataLine.delete(0, this.thisDataLine.length());
        this.nowReading = null;
        return txt;
    }

    public int readI() throws DataReadException, DataEofException {
        String txt;
        if (this.inputBuffReader == null) {
            return Integer.MIN_VALUE;
        }
        if (this.nowReading == null) {
            this.nowReading = "an integer";
        }
        this.getThisDataLine();
        if (this.thisDataLine.length() <= 0) {
            this.nowReading = null;
            return Integer.MIN_VALUE;
        }
        int i = this.thisDataLine.indexOf(" ");
        int j = this.thisDataLine.indexOf(",");
        int k = this.thisDataLine.length();
        if (i > -1 && i < k) {
            k = i;
        }
        if (j > -1 && j < k) {
            k = j;
        }
        if (k > -1 && k < this.thisDataLine.length()) {
            txt = this.thisDataLine.substring(0, k).trim();
            this.thisDataLine.delete(0, k + 1);
            this.thisDataLine = new StringBuffer(this.thisDataLine.toString().trim());
            if (this.thisDataLine.length() > 0 && this.thisDataLine.charAt(0) == ',') {
                this.thisDataLine.deleteCharAt(0);
            }
            this.thisDataLine = new StringBuffer(this.thisDataLine.toString().trim());
        } else {
            txt = this.thisDataLine.toString().trim();
            this.thisDataLine.delete(0, this.thisDataLine.length());
        }
        int value = Integer.MIN_VALUE;
        if (txt.length() == 0) {
            value = 0;
        } else {
            try {
                value = Integer.valueOf(txt);
            }
            catch (NumberFormatException ex) {
                throw new DataReadException("NumberFormatException reading an integer from input string: \"" + txt + "\"" + nl + "when reading: \"" + this.nowReading + "\"" + nl + "in line: \"" + this.thisDataLineOriginal.toString() + "\"" + nl + "in file: \"" + this.dataFileName + "\".");
            }
            catch (NullPointerException ex) {
                throw new DataReadException("NullPointerException reading an integer from input string: \"" + txt + "\"" + nl + "when reading: \"" + this.nowReading + "\"" + nl + "in line: \"" + this.thisDataLineOriginal.toString() + "\"" + nl + "in file: \"" + this.dataFileName + "\".");
            }
        }
        this.nowReading = null;
        return value;
    }

    public float readR() throws DataReadException, DataEofException {
        float f = (float)this.readD();
        if (Math.abs(f) < Float.MIN_VALUE) {
            f = 0.0f;
        }
        return f;
    }

    public double readD() throws DataReadException, DataEofException {
        String txt;
        if (this.inputBuffReader == null) {
            return Double.NaN;
        }
        if (this.nowReading == null) {
            this.nowReading = "a double (floating point value)";
        }
        this.getThisDataLine();
        if (this.thisDataLine.length() <= 0) {
            this.nowReading = null;
            return Double.NaN;
        }
        int i = this.thisDataLine.indexOf(" ");
        int j = this.thisDataLine.indexOf(",");
        int k = this.thisDataLine.length();
        if (i > -1 && i < k) {
            k = i;
        }
        if (j > -1 && j < k) {
            k = j;
        }
        if (k > -1 && k < this.thisDataLine.length()) {
            txt = this.thisDataLine.substring(0, k).trim();
            this.thisDataLine.delete(0, k + 1);
            this.thisDataLine = new StringBuffer(this.thisDataLine.toString().trim());
            if (i == k && this.thisDataLine.length() > 0 && this.thisDataLine.charAt(0) == ',') {
                this.thisDataLine.deleteCharAt(0);
            }
            this.thisDataLine = new StringBuffer(this.thisDataLine.toString().trim());
        } else {
            txt = this.thisDataLine.toString().trim();
            this.thisDataLine.delete(0, this.thisDataLine.length());
        }
        double value = Double.NaN;
        if (txt.length() == 0) {
            value = 0.0;
        } else {
            try {
                value = Double.valueOf(txt);
            }
            catch (NumberFormatException ex) {
                throw new DataReadException("NumberFormatException reading a float value from input string: \"" + txt + "\"" + nl + "when reading: \"" + this.nowReading + "\"" + nl + "in line: \"" + this.thisDataLineOriginal.toString() + "\"" + nl + "in file: \"" + this.dataFileName + "\".");
            }
            catch (NullPointerException ex) {
                throw new DataReadException("NullPointerException reading a float value from input string: \"" + txt + "\"" + nl + "when reading: \"" + this.nowReading + "\"" + nl + "in line: \"" + this.thisDataLineOriginal.toString() + "\"" + nl + "in file: \"" + this.dataFileName + "\".");
            }
        }
        this.nowReading = null;
        if (Math.abs(value) < Double.MIN_VALUE) {
            value = 0.0;
        }
        return value;
    }

    public String readLine() throws DataReadException, DataEofException {
        if (this.inputBuffReader == null) {
            return null;
        }
        this.nextDataLineComment = null;
        if (this.thisDataLineOriginal != null && this.thisDataLineOriginal.length() > 0) {
            this.thisDataLineOriginal.delete(0, this.thisDataLineOriginal.length());
        }
        if (this.thisDataLine != null && this.thisDataLine.length() > 0) {
            this.thisDataLine.delete(0, this.thisDataLine.length());
        }
        if (this.dataLineComment == null) {
            this.dataLineComment = new StringBuffer();
        } else if (this.dataLineComment.length() > 0) {
            this.dataLineComment.delete(0, this.dataLineComment.length());
        }
        if (this.nowReading == null) {
            this.nowReading = "a text line";
        }
        this.getNextDataLine();
        this.nowReading = null;
        if (this.nextDataLineOriginal == null) {
            throw new DataEofException("reached the End-Of-File," + nl + "when reading: \"" + this.nowReading + "\"" + nl + "in file: \"" + this.dataFileName + "\".");
        }
        return this.nextDataLineOriginal.toString();
    }

    public double getTemperature() throws DataReadException {
        Double w;
        int i;
        if (this.temperatureString == null || this.temperatureString.length() <= 0) {
            return Double.NaN;
        }
        for (i = 0; i < this.temperatureString.length() && (Character.isDigit(this.temperatureString.charAt(i)) || this.temperatureString.charAt(i) == 'E' || this.temperatureString.charAt(i) == '.' || this.temperatureString.charAt(i) == '-' || this.temperatureString.charAt(i) == '+'); ++i) {
        }
        if (i <= 0) {
            return Double.NaN;
        }
        if (i < this.temperatureString.length() - 1) {
            this.temperatureString = this.temperatureString.substring(0, i);
        }
        try {
            w = Double.parseDouble(this.temperatureString);
        }
        catch (NumberFormatException ex) {
            throw new DataReadException("Error: " + ex.getMessage() + nl + "   while reading the temperature in line:" + nl + "   \"" + this.temperatureDataLineNextOriginal + "\"" + nl + "   in file \"" + this.dataFileName + "\"");
        }
        if (this.temperatureUnitsK) {
            w = w - 273.15;
        }
        return w;
    }

    public double getPressure() throws DataReadException {
        Double w;
        int i;
        if (this.pressureString == null || this.pressureString.length() <= 0) {
            return Double.NaN;
        }
        for (i = 0; i < this.pressureString.length() && (Character.isDigit(this.pressureString.charAt(i)) || this.pressureString.charAt(i) == 'E' || this.pressureString.charAt(i) == '.' || this.pressureString.charAt(i) == '+'); ++i) {
        }
        if (i <= 0) {
            return Double.NaN;
        }
        if (i < this.pressureString.length() - 1) {
            this.pressureString = this.pressureString.substring(0, i);
        }
        try {
            w = Double.parseDouble(this.pressureString);
        }
        catch (NumberFormatException ex) {
            throw new DataReadException("Error: " + ex.getMessage() + nl + "   while reading the pressure in line:" + nl + "   \"" + this.pressureDataLineNextOriginal + "\"" + nl + "   in file \"" + this.dataFileName + "\"");
        }
        if (this.pressureUnits == 1) {
            w = w * 1.013;
        } else if (this.pressureUnits == 2) {
            w = w / 10.0;
        }
        return w;
    }

    private void getThisDataLine() throws DataReadException, DataEofException {
        if (this.thisDataLine == null) {
            this.thisDataLine = new StringBuffer();
        }
        while (this.thisDataLine.length() <= 0) {
            if (this.thisDataLineOriginal == null) {
                this.thisDataLineOriginal = new StringBuffer();
            } else if (this.thisDataLineOriginal.length() > 0) {
                this.thisDataLineOriginal.delete(0, this.thisDataLineOriginal.length());
            }
            if (this.dataLineComment == null) {
                this.dataLineComment = new StringBuffer();
            } else if (this.dataLineComment.length() > 0) {
                this.dataLineComment.delete(0, this.dataLineComment.length());
            }
            do {
                this.getNextDataLine();
                if (this.nextDataLine != null) continue;
                String t = "reached the End-Of-File," + nl;
                if (this.nowReading != null && this.nowReading.length() > 0) {
                    t = t + "when reading: \"" + this.nowReading + "\"" + nl;
                }
                t = t + "in file: \"" + this.dataFileName + "\".";
                throw new DataEofException(t);
            } while (this.nextDataLine.length() <= 0);
            this.thisDataLine.append(this.nextDataLine);
            this.thisDataLineOriginal.append(this.nextDataLineOriginal);
            if (this.nextDataLineComment != null) {
                this.dataLineComment.append(this.nextDataLineComment);
            }
            this.nextDataLineComment = null;
        }
    }

    private void getNextDataLine() throws DataReadException {
        if (this.nextDataLine == null) {
            return;
        }
        this.nextDataLine.delete(0, this.nextDataLine.length());
        if (this.nextDataLineOriginal == null) {
            this.nextDataLineOriginal = new StringBuffer();
        } else if (this.nextDataLineOriginal.length() > 0) {
            this.nextDataLineOriginal.delete(0, this.nextDataLineOriginal.length());
        }
        String nextLine = null;
        try {
            nextLine = this.inputBuffReader.readLine();
        }
        catch (IOException ex) {
            String t = ex.getMessage() + " in \"getNextDataLine()\"" + nl;
            if (this.nowReading != null && this.nowReading.length() > 0) {
                t = t + "when reading: \"" + this.nowReading + "\"" + nl;
            }
            t = t + "in file: \"" + this.dataFileName + "\".";
            throw new DataReadException(t);
        }
        if (nextLine == null) {
            this.nextDataLineOriginal = null;
            this.nextDataLine = null;
        } else {
            nextLine = Util.rTrim(nextLine);
            this.nextDataLine.append(nextLine);
            this.nextDataLineOriginal.append(nextLine);
            try {
                this.checkNextDataLine();
            }
            catch (Exception ex) {
                String t = ex.getMessage() + " in \"getNextDataLine()\"" + nl;
                if (this.nowReading != null && this.nowReading.length() > 0) {
                    t = t + "when reading: \"" + this.nowReading + "\"" + nl;
                }
                t = t + "in line: \"" + nextLine + "\"" + nl + "in file: \"" + this.dataFileName + "\".";
                throw new DataReadException(t);
            }
        }
    }

    private void checkNextDataLine() {
        int i;
        block31: {
            this.nextDataLineComment = null;
            if (this.nextDataLine.length() <= 0) {
                return;
            }
            i = 0;
            int imax = this.nextDataLine.length();
            while ((i = this.nextDataLine.indexOf("/", i)) > 0) {
                char c = this.nextDataLine.charAt(i - 1);
                if (c == ',' || c == ' ' || c == '\t') {
                    this.nextDataLineComment = this.nextDataLine.substring(i + 1);
                    this.nextDataLine.delete(i, imax);
                } else if (i <= imax) {
                    ++i;
                    continue;
                }
                break block31;
            }
            if (i == 0) {
                this.nextDataLineComment = this.nextDataLine.toString();
                this.nextDataLine.delete(0, this.nextDataLine.length());
            }
        }
        if (this.reading1stLine && this.nextDataLineComment != null) {
            int i5;
            int i4;
            if (this.nextDataLineComment.indexOf("HYDRA") > -1 || this.nextDataLineComment.indexOf("DATABASE") > -1) {
                this.DatabaseSpanaFile = 1;
            } else if (this.nextDataLineComment.indexOf("MEDUSA") > -1 || this.nextDataLineComment.indexOf("SPANA") > -1) {
                this.DatabaseSpanaFile = 2;
            }
            String commentUC = this.nextDataLineComment.toUpperCase();
            int i1 = commentUC.indexOf("T=");
            int i2 = commentUC.indexOf("T =");
            i = i1;
            if (i2 > -1 && (i1 > -1 && i2 < i1 || i1 < 0)) {
                i = i2;
            }
            if (i > -1 && (i = (commentUC = commentUC.substring(i)).indexOf("=")) < commentUC.length() - 1) {
                String s;
                i1 = (commentUC = commentUC.substring(i + 1).trim()).indexOf("C");
                if (i1 > 0 && ((s = commentUC.substring(i1 - 1, i1)).equals("\u00b0") || s.equals("\"") || s.equals("'"))) {
                    --i1;
                }
                i2 = commentUC.indexOf("K");
                i4 = commentUC.indexOf(" ");
                i5 = commentUC.indexOf(",");
                i = i1;
                if (i2 > -1 && (i > -1 && i2 < i || i < 0)) {
                    i = i2;
                }
                if (i4 > -1 && (i > -1 && i4 < i || i < 0)) {
                    i = i4;
                }
                if (i5 > -1 && (i > -1 && i5 < i || i < 0)) {
                    i = i5;
                }
                if (i > -1) {
                    commentUC = commentUC.substring(0, i).trim();
                }
                this.temperatureString = commentUC;
                if (i2 > -1 && (i1 <= -1 || i1 > i2)) {
                    this.temperatureUnitsK = true;
                }
                this.temperatureDataLineNextOriginal = this.nextDataLineOriginal.toString();
            }
            commentUC = this.nextDataLineComment.toUpperCase();
            i1 = commentUC.indexOf("P=");
            i2 = commentUC.indexOf("P =");
            i = i1;
            if (i2 > -1 && (i1 > -1 && i2 < i1 || i1 < 0)) {
                i = i2;
            }
            if (i > -1 && (i = (commentUC = commentUC.substring(i)).indexOf("=")) < commentUC.length() - 1) {
                commentUC = commentUC.substring(i + 1).trim();
                i1 = commentUC.indexOf("BAR");
                i2 = commentUC.indexOf("ATM");
                int i3 = commentUC.indexOf("MPA");
                i4 = commentUC.indexOf(" ");
                i5 = commentUC.indexOf(",");
                i = i1;
                if (i2 > -1 && (i > -1 && i2 < i || i < 0)) {
                    i = i2;
                }
                if (i3 > -1 && (i > -1 && i3 < i || i < 0)) {
                    i = i3;
                }
                if (i4 > -1 && (i > -1 && i4 < i || i < 0)) {
                    i = i4;
                }
                if (i5 > -1 && (i > -1 && i5 < i || i < 0)) {
                    i = i5;
                }
                if (i > -1) {
                    commentUC = commentUC.substring(0, i).trim();
                }
                this.pressureString = commentUC;
                this.pressureUnits = 0;
                if (!(i2 <= -1 || i1 > -1 && i1 <= i2 || i3 > -1 && i3 <= i2)) {
                    this.pressureUnits = 1;
                }
                if (!(i3 <= -1 || i1 > -1 && i1 <= i3 || i2 > -1 && i2 <= i3)) {
                    this.pressureUnits = 2;
                }
                this.pressureDataLineNextOriginal = this.nextDataLineOriginal.toString();
            }
        }
        this.reading1stLine = false;
        this.nextDataLine = new StringBuffer(this.nextDataLine.toString().trim());
        if (this.nextDataLine.length() <= 0) {
            return;
        }
        for (i = 0; i < this.nextDataLine.length(); ++i) {
            if (this.nextDataLine.charAt(i) >= ' ') continue;
            this.nextDataLine.setCharAt(i, ' ');
        }
        String t = Util.rTrim(this.nextDataLine.toString());
        if (t.length() <= 0) {
            return;
        }
        this.nextDataLine.delete(0, this.nextDataLine.length());
        this.nextDataLine.append(t);
        if (this.nextDataLine.charAt(this.nextDataLine.length() - 1) != ',') {
            this.nextDataLine.append(",");
        }
    }

    public class DataEofException
    extends ReadDataLibException {
        private DataEofException() {
        }

        private DataEofException(String txt) {
            super(txt);
        }
    }

    public class DataReadException
    extends ReadDataLibException {
        public DataReadException() {
        }

        public DataReadException(String txt) {
            super(txt);
        }
    }

    public class DataFileException
    extends ReadDataLibException {
        public DataFileException() {
        }

        public DataFileException(String txt) {
            super(txt);
        }
    }

    public class ReadDataLibException
    extends Exception {
        public ReadDataLibException() {
        }

        public ReadDataLibException(String txt) {
            super(txt);
        }
    }
}

