/*
 * Decompiled with CFR 0.152.
 */
package lib.huvud;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Div {
    private static final String SLASH = File.separator;
    private static final String nl = System.getProperty("line.separator");

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return fileName;
        }
        if (fileName.length() == 1) {
            if (fileName.equals(".")) {
                return "";
            }
            return fileName;
        }
        File f = new File(fileName);
        if (f.isDirectory()) {
            return fileName;
        }
        int dot = fileName.lastIndexOf(".");
        if (dot <= 0) {
            return fileName;
        }
        String ext = dot <= fileName.length() ? fileName.substring(dot + 1) : "";
        if (ext.contains(SLASH)) {
            return fileName;
        }
        return fileName.substring(0, dot);
    }

    public static String getFileNameExtension(String fileName) {
        File f = new File(fileName);
        if (f.isDirectory()) {
            return "";
        }
        if (fileName == null) {
            return fileName;
        }
        if (fileName.length() <= 1 || fileName.endsWith(".")) {
            return "";
        }
        int dot = fileName.lastIndexOf(".");
        if (dot <= 0) {
            return "";
        }
        String ext = dot <= fileName.length() ? fileName.substring(dot + 1) : "";
        if (ext.contains(SLASH)) {
            return "";
        }
        return ext;
    }

    public static Logger myLogger(String pattern, String progName) {
        Logger lggr;
        if (pattern == null || pattern.length() <= 0 || progName == null || progName.length() <= 0) {
            return null;
        }
        try {
            int limit = 1000000;
            int numLogFiles = 2;
            FileHandler fh = new FileHandler(pattern, limit, numLogFiles);
            fh.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord rec) {
                    StringBuilder buf = new StringBuilder(1000);
                    buf.append(this.formatMessage(rec));
                    return buf.toString();
                }
            });
            lggr = Logger.getLogger(progName);
            lggr.addHandler(fh);
            Logger rootLogger = Logger.getLogger("");
            Handler[] handlers = rootLogger.getHandlers();
            if (handlers[0] instanceof ConsoleHandler) {
                rootLogger.removeHandler(handlers[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            lggr = null;
        }
        return lggr;
    }

    public static boolean progSEDexists(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        if (Div.progExists(dir, "SED", "jar")) {
            return true;
        }
        return System.getProperty("os.name").toLowerCase().startsWith("windows") && Div.progExists(dir, "SED", "exe");
    }

    public static boolean progPredomExists(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        if (Div.progExists(dir, "Predom", "jar")) {
            return true;
        }
        return System.getProperty("os.name").toLowerCase().startsWith("windows") && (Div.progExists(dir, "Predom", "exe") || Div.progExists(dir, "Predom2", "exe"));
    }

    public static boolean progExists(File dir, String prog, String ext) {
        if (dir == null || prog == null || ext == null) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        if (dir.isDirectory()) {
            String name;
            File f;
            String path = dir.getAbsolutePath();
            if (path.endsWith(SLASH)) {
                path = path.substring(0, path.length() - 1);
            }
            if ((f = new File(name = path + SLASH + prog + ext)).exists() && f.isFile()) {
                return true;
            }
        } else {
            String name = dir.getName();
            if (name.equalsIgnoreCase(prog + ext)) {
                return true;
            }
        }
        return false;
    }
}

