/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.readWriteDataFiles;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import lib.common.Util;
import lib.kemi.chem.Chem;

public class WriteChemSyst {
    private static Locale engl = Locale.ENGLISH;
    private static String nl = System.getProperty("line.separator");

    public static void writeChemSyst(Chem ch, File dataFile) throws DataLimitsException, writeChemSystArgsException {
        int i;
        String dataFileName;
        if (ch == null) {
            throw new writeChemSystArgsException(nl + "Error in \"writeChemSyst\":" + nl + "   empty instance of class \"Chem\"");
        }
        if (dataFile == null || dataFile.getName().length() <= 0) {
            throw new writeChemSystArgsException(nl + "Error in \"writeChemSyst\":" + nl + "   no output data file given");
        }
        try {
            dataFileName = dataFile.getCanonicalPath();
        }
        catch (IOException ex) {
            dataFileName = dataFile.getAbsolutePath();
        }
        if (!dataFileName.toLowerCase().endsWith(".dat")) {
            throw new writeChemSystArgsException("File: \"" + dataFileName + "\"" + nl + "Error: data file name must end with \".dat\"");
        }
        if (dataFile.exists() && !dataFile.canWrite()) {
            throw new writeChemSystArgsException("Error: can not modify file:" + nl + "   \"" + dataFile.getPath() + "\"" + nl + "Is this file write-protected?");
        }
        String tmpFileName = dataFileName.substring(0, dataFileName.length() - 4).concat(".tmp");
        File tmpFile = new File(tmpFileName);
        PrintWriter outputFile = null;
        try {
            outputFile = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
        }
        catch (IOException ex) {
            throw new writeChemSystArgsException(nl + "Error: \"" + ex.toString() + "\"," + nl + "   in \"writeChemSyst\"," + nl + "   while writing the data file" + nl + "   \"" + tmpFileName + "\"");
        }
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.Diagr diag = ch.diag;
        Chem.DiagrConcs dgrC = ch.diagrConcs;
        if (cs.Na < 1 || cs.Na > 1000) {
            throw new DataLimitsException(nl + "Error: Number of components is: " + cs.Na + nl + "Must be >0 and <1000.");
        }
        if (cs.nx < 0 || cs.nx > 1000000) {
            throw new DataLimitsException(nl + "Error: Number of soluble complexes is: " + cs.nx + nl + "Must be >=0 and < 1 000 000.");
        }
        int nrSol = cs.mSol - cs.solidC;
        if (nrSol < 0 || nrSol > 100000) {
            throw new DataLimitsException(nl + "Error: Number of solid reaction products is: " + nrSol + nl + "Must be >=0 and < 100 000.");
        }
        if (cs.solidC < 0 || cs.solidC > cs.Na) {
            throw new DataLimitsException(nl + "Error: Number of solid components is: " + cs.solidC + nl + "Must be >=0 and <= " + cs.Na + " (the nbr of components).");
        }
        String m = ",   /SPANA (MEDUSA)";
        if (!Double.isNaN(diag.temperature)) {
            m = m + ", t=" + Util.formatDbl3(diag.temperature);
        }
        if (!Double.isNaN(diag.pressure)) {
            m = m + ", p=" + Util.formatDbl3(diag.pressure);
        }
        outputFile.println(" " + String.valueOf(cs.Na) + ", " + String.valueOf(cs.nx) + ", " + String.valueOf(nrSol) + ", " + String.valueOf(cs.solidC) + m.trim());
        for (int i2 = 0; i2 < cs.Na; ++i2) {
            outputFile.format("%s", namn.identC[i2]);
            if (namn.comment[i2] != null && namn.comment[i2].length() > 0) {
                outputFile.format(" /%s", namn.comment[i2]);
            }
            outputFile.println();
        }
        outputFile.flush();
        StringBuilder logB = new StringBuilder();
        for (int i3 = cs.Na; i3 < cs.Na + cs.nx + nrSol; ++i3) {
            if (namn.ident[i3].length() <= 20) {
                outputFile.format(engl, "%-20s, ", namn.ident[i3]);
            } else {
                outputFile.format(engl, "%s, ", namn.ident[i3]);
            }
            int ix = i3 - cs.Na;
            if (logB.length() > 0) {
                logB.delete(0, logB.length());
            }
            logB.append(Util.formatDbl3(cs.lBeta[ix]));
            int j = 10 - logB.length();
            if (j > 0) {
                for (int k = 0; k < j; ++k) {
                    logB.append(' ');
                }
            } else {
                logB.append(' ');
            }
            outputFile.print(logB.toString());
            for (j = 0; j < cs.Na - 1; ++j) {
                outputFile.print(Util.formatDbl4(cs.a[ix][j]) + " ");
            }
            outputFile.print(Util.formatDbl4(cs.a[ix][cs.Na - 1]));
            if (namn.comment[i3] != null && namn.comment[i3].length() > 0) {
                outputFile.format(" /%s", namn.comment[i3]);
            }
            outputFile.println();
        }
        boolean ePresent = false;
        for (i = 0; i < cs.Na; ++i) {
            if (!Util.isElectron(namn.identC[i])) continue;
            ePresent = true;
            break;
        }
        if (!ePresent) {
            for (i = cs.Na; i < cs.Na + cs.nx + nrSol; ++i) {
                if (!Util.isElectron(namn.ident[i])) continue;
                ePresent = true;
                break;
            }
        }
        if (diag.plotType == 0) {
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compY] + ", " + namn.identC[diag.compX] + ", " + namn.identC[diag.compMain] + ",");
        } else if (diag.plotType == 1) {
            outputFile.print(namn.identC[diag.compY] + ", ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        } else if (diag.plotType == 2) {
            outputFile.print("LS," + Util.formatDbl4(diag.yLow) + "," + Util.formatDbl4(diag.yHigh) + ", ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        } else if (diag.plotType == 3) {
            outputFile.print("LC," + Util.formatDbl4(diag.yLow) + "," + Util.formatDbl4(diag.yHigh) + ", ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        } else if (diag.plotType == 4) {
            outputFile.print("R, " + namn.identC[diag.compY] + ", ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        } else if (diag.plotType == 5) {
            outputFile.print("pe," + Util.formatDbl4(diag.yLow) + "," + Util.formatDbl4(diag.yHigh) + ", ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        } else if (diag.plotType == 6) {
            outputFile.print("pH," + Util.formatDbl4(diag.yLow) + "," + Util.formatDbl4(diag.yHigh) + ", ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        } else if (diag.plotType == 7) {
            outputFile.print("LAC," + Util.formatDbl4(diag.yLow) + "," + Util.formatDbl4(diag.yHigh) + ", ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        } else if (diag.plotType == 8) {
            outputFile.print("PS, ");
            if (ePresent && diag.Eh) {
                outputFile.print("EH, ");
            }
            outputFile.println(namn.identC[diag.compX] + ",");
        }
        String[] ct = new String[]{" ", "T", "TV", "LTV", "LA", "LAV"};
        for (int i4 = 0; i4 < cs.Na; ++i4) {
            int h = dgrC.hur[i4];
            if (h == 2 || h == 3 || h == 5) {
                outputFile.println(ct[h] + ", " + Util.formatDbl6(dgrC.cLow[i4]) + " " + Util.formatDbl6(dgrC.cHigh[i4]));
                continue;
            }
            if (h != 1 && h != 4) continue;
            outputFile.println(ct[h] + ", " + Util.formatDbl6(dgrC.cLow[i4]));
        }
        if (diag.title != null && diag.title.length() > 0) {
            outputFile.println(diag.title);
        }
        if (diag.endLines != null && diag.endLines.length() > 0) {
            if (diag.title == null || diag.title.length() <= 0) {
                outputFile.println();
            }
            outputFile.print(diag.endLines);
        }
        outputFile.flush();
        outputFile.close();
        dataFile.delete();
        tmpFile.renameTo(dataFile);
    }

    public static class DataLimitsException
    extends Exception {
        public DataLimitsException() {
        }

        public DataLimitsException(String txt) {
            super(txt);
        }
    }

    public static class writeChemSystArgsException
    extends Exception {
        public writeChemSystArgsException() {
        }

        public writeChemSystArgsException(String txt) {
            super(txt);
        }
    }
}

