/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.graph_lib;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Date;
import lib.common.Util;
import lib.kemi.graph_lib.GraphLib;

public class DiagrPaintUtility {
    public static final int MAX_COLOURS = 11;
    public Color[] colours = new Color[]{new Color(0, 0, 0), new Color(255, 35, 35), new Color(149, 67, 0), new Color(47, 47, 255), new Color(0, 151, 0), new Color(200, 140, 0), new Color(255, 0, 255), new Color(0, 0, 128), new Color(181, 181, 181), new Color(0, 166, 255), new Color(128, 0, 255)};
    public int colourType = 0;
    public boolean useBackgrndColour = false;
    public Color backgrnd = Color.WHITE;
    public boolean printColour = true;
    public boolean printHeader = true;
    public int antiAliasing = 1;
    public int antiAliasingText = 0;
    public boolean fixedSize = false;
    public float fixedSizeWidth = 21.0f;
    public float fixedSizeHeight = 15.0f;
    public boolean keepAspectRatio = false;
    public float penThickness = 1.0f;
    public float printPenThickness = 1.0f;
    public int fontSize = 8;
    public int fontFamily = 1;
    public int fontStyle = 0;
    public boolean textWithFonts = true;

    public void paintDiagram(Graphics2D g2D, Dimension compDim, GraphLib.PltData pltD, boolean printing) {
        int i1;
        int yScale0;
        int xScale0;
        int y_max;
        int x_max;
        int y_min;
        int x_min;
        if (compDim.width <= 5 || compDim.height <= 5) {
            return;
        }
        if (pltD == null || this.fixedSize && !this.keepAspectRatio && !printing) {
            x_min = -10;
            y_min = -10;
            x_max = Math.round(this.fixedSizeWidth * 100.0f) + 10;
            y_max = Math.round(this.fixedSizeHeight * 100.0f) + 10;
        } else {
            x_min = pltD.userSpaceMin.x;
            x_max = pltD.userSpaceMax.x;
            y_min = pltD.userSpaceMin.y;
            y_max = pltD.userSpaceMax.y;
        }
        if (this.keepAspectRatio || printing) {
            if (Math.abs((float)compDim.width / (float)(x_max - x_min)) < Math.abs((float)compDim.height / (float)(y_max - y_min))) {
                y_max = 10 + Math.round((float)x_max * (float)compDim.height / (float)compDim.width);
            } else {
                x_max = 10 + Math.round((float)y_max * (float)compDim.width / (float)compDim.height);
            }
        }
        float userWidth = Math.abs(x_max - x_min);
        float userHeight = Math.abs(y_max - y_min);
        float xScale = (float)compDim.width / userWidth;
        float yScale = (float)compDim.height / userHeight;
        if (pltD == null) {
            xScale0 = Math.round(-10.0f * xScale);
            yScale0 = Math.round(-10.0f * yScale);
        } else {
            xScale0 = Math.round((float)pltD.userSpaceMin.x * xScale);
            yScale0 = Math.round((float)pltD.userSpaceMin.y * yScale);
        }
        if (printing) {
            if (this.printColour) {
                g2D.setColor(this.backgrnd);
                g2D.fillRect(0, 0, compDim.width, compDim.height);
                g2D.setColor(Color.BLACK);
            }
        } else {
            switch (this.colourType) {
                case 1: {
                    g2D.setColor(Color.WHITE);
                    g2D.fillRect(0, 0, compDim.width, compDim.height);
                    g2D.setColor(Color.BLACK);
                    break;
                }
                case 2: {
                    g2D.setColor(Color.BLACK);
                    g2D.fillRect(0, 0, compDim.width, compDim.height);
                    g2D.setColor(Color.WHITE);
                    break;
                }
                default: {
                    if (this.useBackgrndColour) {
                        g2D.setColor(this.backgrnd);
                        g2D.fillRect(0, 0, compDim.width, compDim.height);
                    }
                    g2D.setColor(Color.BLACK);
                }
            }
        }
        Font f = new Font("Monospaced", 0, 7);
        g2D.setFont(f);
        if (printing && this.printHeader) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            float H = 1.2f * (float)g2D.getFontMetrics().getStringBounds("H", g2D).getWidth();
            g2D.setColor(Color.BLACK);
            Date today = new Date();
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2);
            if (pltD != null) {
                g2D.drawString("File: \"" + pltD.pltFile_Name + "\"", 0.0f, H);
                g2D.drawString("File last modified: " + formatter.format(pltD.fileLastModified) + ";  Printed: " + formatter.format(today) + ")", 0.0f, 2.0f * H + 0.5f * H);
            }
        }
        if (this.antiAliasing == 1) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else if (this.antiAliasing == 2) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        float pen = !printing ? this.penThickness : this.printPenThickness;
        BasicStroke stroke = new BasicStroke(pen, 2, 2);
        g2D.setStroke(stroke);
        int ix_start = 0;
        int iy_start = 0;
        if (pltD != null) {
            GraphLib.PltData.PlotStep ps;
            if (pltD.pltFileAList.size() > 0) {
                ps = pltD.pltFileAList.get(0);
                ix_start = ps.i1;
                iy_start = ps.i2;
            }
            for (int j = 0; j < pltD.pltFileAList.size(); ++j) {
                ps = pltD.pltFileAList.get(j);
                int i0 = ps.i0;
                if (i0 == 1) {
                    int ix_new = ps.i1;
                    int iy_new = ps.i2;
                    int x0 = Math.round((float)ix_start * xScale) - xScale0;
                    int y0 = compDim.height - (Math.round((float)iy_start * yScale) - yScale0);
                    int x1 = Math.round((float)ix_new * xScale) - xScale0;
                    int y1 = compDim.height - (Math.round((float)iy_new * yScale) - yScale0);
                    g2D.drawLine(x0, y0, x1, y1);
                    ix_start = ix_new;
                    iy_start = iy_new;
                    continue;
                }
                if (i0 == 0) {
                    ix_start = ps.i1;
                    iy_start = ps.i2;
                    continue;
                }
                if (i0 != 5 && i0 != 8 || (this.colourType != 0 || printing) && (!printing || !this.printColour)) continue;
                i1 = ps.i1 - 1;
                if (i1 < 0) {
                    i1 = 0;
                }
                while (i1 >= 11) {
                    i1 -= 11;
                }
                if (i1 < 0) {
                    i1 = 0;
                }
                g2D.setColor(this.colours[i1]);
            }
        }
        if (pltD == null || pltD.pltTextAList.size() <= 0 || !this.textWithFonts) {
            return;
        }
        int oldColour = -1;
        String diagrFontFamily = this.fontFamily == 1 ? "SansSerif" : (this.fontFamily == 2 ? "Monospaced" : (this.fontFamily == 3 ? "Dialog" : (this.fontFamily == 4 ? "DialogInput" : "Serif")));
        int diagrFontStyle = this.fontStyle == 1 ? 1 : (this.fontStyle == 2 ? 2 : 0);
        f = new Font(diagrFontFamily, diagrFontStyle, this.fontSize);
        g2D.setFont(f);
        if (this.antiAliasingText == 1) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (this.antiAliasingText == 2) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        } else {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        FontMetrics fm = g2D.getFontMetrics(f);
        Rectangle2D mBnds = fm.getStringBounds("H", g2D);
        FontInfo fi = new FontInfo(f, fm, 0.0f, 0.35f, mBnds, (float)mBnds.getWidth());
        fi.fontScale = (float)this.fontSize / 35.0f * (2100.0f / userWidth) * ((float)compDim.width / 350.0f);
        double wH = (double)compDim.width / (double)compDim.height;
        double wHuserSpace = (double)userWidth / (double)userHeight;
        double scaleXY = wHuserSpace / wH;
        AffineTransform original = g2D.getTransform();
        g2D.scale(1.0, scaleXY);
        for (int j = 0; j < pltD.pltTextAList.size(); ++j) {
            String txt = pltD.pltTextAList.get((int)j).txtLine;
            if (txt == null || txt.length() <= 0) continue;
            if (!printing && this.colourType == 0 || printing && this.printColour) {
                int iColour = pltD.pltTextAList.get((int)j).color - 1;
                if (iColour < 0) {
                    iColour = 0;
                }
                while (iColour >= 11) {
                    iColour -= 11;
                }
                if (iColour < 0) {
                    iColour = 0;
                }
                if (iColour != oldColour) {
                    g2D.setColor(this.colours[iColour]);
                    oldColour = iColour;
                }
            }
            GraphLib.PltData.PlotText pt = pltD.pltTextAList.get(j);
            boolean isFormula = pt.isFormula;
            int align = pltD.pltTextAList.get((int)j).alignment;
            float textSize = 100.0f * pltD.pltTextAList.get((int)j).txtSize;
            float txtAngleDegr = pltD.pltTextAList.get((int)j).txtAngle;
            float txtAngleRad = (float)Math.toRadians(txtAngleDegr);
            i1 = pt.i1;
            int i2 = pt.i2;
            int ix1 = Math.round((float)i1 * xScale) - xScale0;
            int iy1 = compDim.height - (Math.round((float)i2 * yScale) - yScale0);
            iy1 = (int)Math.round((double)iy1 / scaleXY);
            float scaleAlignX = xScale;
            float scaleAlignY = yScale / (float)scaleXY;
            this.PrintFormula(g2D, txt, ix1, iy1, isFormula, align, textSize, txtAngleRad, fi, scaleAlignX, scaleAlignY);
        }
        g2D.setTransform(original);
    }

    private void PrintFormula(Graphics2D g2D, String textLine, int ix, int iy, boolean isFormula0, int align, float tSize, float txtAngleRad, FontInfo fi, float scaleAlignX, float scaleAlignY) {
        float newSize;
        float shift;
        float q;
        float[] d;
        int i;
        int n0 = textLine.length();
        if (n0 <= 0 || textLine.trim().length() <= 0) {
            return;
        }
        int ix1 = ix;
        int iy1 = iy;
        float normalSize = tSize;
        float subSize = 0.9f * tSize;
        fi.txtSize = tSize;
        if (normalSize != fi.oldTxtSize) {
            this.changeFont(g2D, fi);
            fi.oldTxtSize = normalSize;
        }
        if (isFormula0) {
            if (textLine.indexOf(126) >= 0) {
                textLine = textLine.replace('~', '\u00b0');
            }
            if (textLine.indexOf(36) >= 0) {
                textLine = textLine.replace('$', '\u00b5');
            }
            if (textLine.indexOf(94) >= 0) {
                textLine = textLine.replace('^', '\u0394');
            }
        }
        boolean isFormula = isFormula0;
        if (isFormula0) {
            char j;
            boolean onlyDigits = true;
            for (i = 0; i < n0; ++i) {
                j = textLine.charAt(i);
                if (j <= '9' && j >= '0' || j == '.' || j == '+' || j == '-' || j == '\u2013' || j == '\u2212') continue;
                onlyDigits = false;
            }
            boolean notDigits = true;
            for (i = 0; i < n0; ++i) {
                j = textLine.charAt(i);
                if (j >= '0' && j <= '9') {
                    notDigits = false;
                }
                if (j == '\'' || j == '`') {
                    notDigits = false;
                }
                if (j == '$' || j == '^' || j == '~') {
                    notDigits = false;
                }
                if (j != '+' && j != '-' && j != '\u2013' && j != '\u2212') continue;
                notDigits = false;
            }
            if (onlyDigits || notDigits) {
                isFormula = false;
            }
        }
        int n = n0;
        if (isFormula) {
            ChemFormula cf = new ChemFormula(textLine, new float[1]);
            DiagrPaintUtility.chemF(cf);
            textLine = cf.t.toString();
            n = textLine.length();
            d = new float[n];
            System.arraycopy(cf.d, 0, d, 0, n);
            isFormula = false;
            for (i = 0; i < n; ++i) {
                if (!(Math.abs(d[i]) > 0.01f)) continue;
                isFormula = true;
            }
        } else {
            d = new float[]{0.0f};
        }
        if (align != -1) {
            float w = 1.0f;
            if (align == 0) {
                w = 0.5f;
            }
            fi.rect = fi.fm.getStringBounds(textLine, g2D);
            float startWidth = (float)n * tSize;
            q = startWidth * scaleAlignX;
            float txtWidth = (float)fi.rect.getWidth();
            float shift2 = q - txtWidth;
            if (Math.abs(shift2) > 0.01f) {
                ix1 += Math.round(w * shift2);
            }
        }
        if (Math.abs(shift = (q = tSize * scaleAlignY) - fi.width_H) > 0.01f) {
            iy1 -= Math.round(shift / 2.0f);
        }
        if ((double)Math.abs(txtAngleRad) > 0.001) {
            g2D.rotate(-txtAngleRad, ix, iy);
        }
        if (!isFormula) {
            newSize = normalSize;
            if (newSize != fi.oldTxtSize) {
                fi.txtSize = newSize;
                this.changeFont(g2D, fi);
                fi.oldTxtSize = newSize;
            }
            g2D.drawString(textLine, ix1, iy1);
        } else {
            String txt;
            int iy2;
            float d0 = d[0];
            int i0 = 0;
            int ix2 = ix1;
            for (i = 1; i < n; ++i) {
                if (d[i] == d0) continue;
                newSize = Math.abs(d0) > 0.001f ? subSize : normalSize;
                if (newSize != fi.oldTxtSize) {
                    fi.txtSize = newSize;
                    this.changeFont(g2D, fi);
                    fi.oldTxtSize = newSize;
                }
                iy2 = iy1 - Math.round(d0 * fi.width_H);
                txt = textLine.substring(i0, i);
                g2D.drawString(txt, ix2, iy2);
                fi.fm = g2D.getFontMetrics();
                fi.rect = fi.fm.getStringBounds(txt, g2D);
                int txtW = Math.round((float)fi.rect.getWidth());
                ix2 += txtW;
                i0 = i;
                d0 = d[i];
            }
            newSize = Math.abs(d0) > 0.001f ? subSize : normalSize;
            if (newSize != fi.oldTxtSize) {
                fi.txtSize = newSize;
                this.changeFont(g2D, fi);
                fi.oldTxtSize = newSize;
            }
            iy2 = iy1 - Math.round(d0 * fi.width_H);
            txt = textLine.substring(i0, n);
            g2D.drawString(txt, ix2, iy2);
        }
        if ((double)Math.abs(txtAngleRad) > 0.001) {
            g2D.rotate(txtAngleRad, ix, iy);
        }
    }

    private FontInfo changeFont(Graphics2D g2D, FontInfo fi) {
        float txtSizePts = fi.txtSize * fi.fontScale;
        int pts = Math.round(Math.max(4.0f, Math.min(76.0f, txtSizePts)));
        fi.f = g2D.getFont();
        fi.f = new Font(fi.f.getFontName(), fi.f.getStyle(), pts);
        g2D.setFont(fi.f);
        fi.fm = g2D.getFontMetrics();
        fi.rect = fi.fm.getStringBounds("H", g2D);
        fi.width_H = (float)fi.rect.getWidth();
        return fi;
    }

    /*
     * Unable to fully structure code
     */
    static void chemF(ChemFormula cf) {
        REMOVE_CHAR = false;
        DOWN = true;
        NONE = 2;
        UP = 3;
        CONT = 4;
        END = 6;
        M1 = 8211;
        M2 = 8722;
        t = new StringBuffer();
        t.append(cf.t);
        L = t.toString().trim().length();
        if (L <= 1) {
            return;
        }
        L = t.length();
        if (L > (nchr = Util.rTrim(t.toString()).length())) {
            t.delete(nchr, L);
        }
        d = new float[nchr];
        for (i = 0; i < d.length; ++i) {
            d[i] = 0.0f;
        }
        L = 32;
        nL = 32;
        nnL = 32;
        now = t.charAt(0);
        n = 32;
        if (nchr >= 2) {
            n = t.charAt(1);
        }
        n2 = 32;
        if (nchr >= 3) {
            n2 = t.charAt(2);
        }
        dm = 0.0f;
        df = 0.0f;
        i = 0;
        do {
            block58: {
                block68: {
                    block70: {
                        block69: {
                            block67: {
                                block62: {
                                    block66: {
                                        block65: {
                                            block64: {
                                                block63: {
                                                    block61: {
                                                        block60: {
                                                            block59: {
                                                                block57: {
                                                                    n3 = 32;
                                                                    if (nchr >= i + 4) {
                                                                        n3 = t.charAt(i + 3);
                                                                    }
                                                                    if (df > 0.001f && (now < 43 || now > 57 || now == 44 || now == 46 || now == 47)) {
                                                                        df = 0.0f;
                                                                    }
                                                                    if (now != 64 || L == 64) break block57;
                                                                    act = 0;
                                                                    break block58;
                                                                }
                                                                if (L != 64) break block59;
                                                                act = now == 32 ? 4 : 2;
                                                                break block58;
                                                            }
                                                            if (now != 2) break block60;
                                                            now = n;
                                                            n = n2;
                                                            n2 = n3;
                                                            act = 6;
                                                            break block58;
                                                        }
                                                        if (now != 39 && now != 96) break block61;
                                                        if (now == 39 && dm == 0.0f && (n == 32 && L == 115 || n == 115 && (n2 == 32 || n2 == 46 || n2 == 44 || n2 == 58 || n2 == 59 || n2 == 63 || n2 == 33 || n2 == 41 || n2 == 93))) {
                                                            act = 4;
                                                        } else {
                                                            if (now == 39) {
                                                                dm += 0.5f;
                                                            }
                                                            if (now == 96) {
                                                                dm -= 0.5f;
                                                            }
                                                            act = 0;
                                                        }
                                                        break block58;
                                                    }
                                                    if (now != 32) break block62;
                                                    if ((n >= 49 || n == 43 || n == 45 || n == 8211 || n == 8722) && n <= 57) break block63;
                                                    act = 2;
                                                    break block58;
                                                }
                                                if (n != 43 && n != 45 && n != 8211 && n != 8722 || L != 43 && L != 45 && L != 8211 && L != 8722) break block64;
                                                act = 2;
                                                break block58;
                                            }
                                            if ((n2 < 65 || n2 > 90) && (n2 < 97 || n2 > 122)) break block65;
                                            act = 2;
                                            break block58;
                                        }
                                        if (n < 49 || n > 57) ** GOTO lbl-1000
                                        if (n2 < 48 || n2 > 57) break block66;
                                        if (n3 == 43 || n3 == 45 || n3 == 8211 || n3 == 8722) ** GOTO lbl-1000
                                        act = 2;
                                        break block58;
                                    }
                                    if (n2 != 43 && n2 != 45 && n2 != 8211 && n2 != 8722) {
                                        act = 2;
                                    } else lbl-1000:
                                    // 3 sources

                                    {
                                        act = L == 32 ? 2 : ((L < 48 || L > 122 || L >= 58 && L <= 64 || L >= 91 && L <= 96) && L != 41 && L != 93 && L != 125 && L != 62 && L != 34 && L != 39 ? 2 : 0);
                                    }
                                    break block58;
                                }
                                if (now < 48 || now > 57) break block67;
                                if (L == 40 || L == 91 || L == 123 || L == 45 || L == 8211 || L == 8722 || L == 43) ** GOTO lbl-1000
                                if (L == 106 || L == 74 || L == 113 || L == 81) {
                                    act = 2;
                                } else if (L == 120 || L == 88 || L == 122 || L == 90) {
                                    act = 2;
                                } else if (L >= 65 && L <= 90 || L >= 97 && L <= 122) {
                                    act = 1;
                                } else if (L == 41 || L == 93 || L == 125) {
                                    act = 1;
                                } else if (df > 0.01f && (L >= 48 && L <= 57 || L == 46)) {
                                    act = 4;
                                } else if (df < -0.01f && (L == 46 || L >= 48 && L <= 57)) {
                                    act = 4;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    df = 0.0f;
                                    act = L == 32 && n >= 48 && n <= 57 && (n2 == 43 || n2 == 45 || n2 == 8211 || n2 == 8722) && now != 48 ? (n3 != 32 && n3 != 41 && n3 != 93 && n3 != 125 ? 4 : 3) : (L != 32 || n != 43 && n != 45 && n != 8211 && n != 8722 ? 4 : (n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122 ? 4 : 3));
                                }
                                break block58;
                            }
                            if (now != 43 && now != 45 && now != 8211 && now != 8722) break block68;
                            if (L < 50 || L > 57 || !(df > 0.01f)) break block69;
                            act = 3;
                            break block58;
                        }
                        if (L < 48 || L > 57 || nL < 49 || nL > 57 || !(df > 0.01f)) break block70;
                        act = 3;
                        break block58;
                    }
                    if (n < 49 || n > 57) ** GOTO lbl-1000
                    if ((nL >= 48 && nL <= 57 || nL == 46) && (L == 69 || L == 101)) {
                        act = 2;
                    } else if (L == 32) {
                        act = 2;
                    } else if (L == 106 || L == 74 || L == 113 || L == 81) {
                        act = 2;
                    } else if (L == 120 || L == 88 || L == 122 || L == 90) {
                        act = 2;
                    } else if (dm > 0.01f && L == 39 && nL == 48 && nnL == 49 && n >= 49 && n <= 57 && (n2 == 46 || n2 == 96 || n2 >= 48 && n2 <= 57)) {
                        act = 2;
                    } else if (L < 48 && L != 41 && L != 34 && L != 39 || L > 122 && L != 125 || L >= 58 && L <= 64 && L != 62 || L >= 91 && L <= 96 && L != 93) {
                        act = 2;
                    } else if ((L == 41 || L == 93 || L == 125 || L == 34 || L == 39) && (nL == 32 || nL < 48 || nL > 122 || nL >= 58 && nL <= 64 || nL >= 91 && nL <= 96)) {
                        act = 2;
                    } else if (n2 < 48 && n2 != 41 && n2 != 32 && n2 != 39 || n2 > 57 && n2 != 93 && n2 != 96 && n2 != 125) {
                        act = 2;
                    } else if (n >= 49 && n <= 57 && n2 >= 48 && n2 <= 57) {
                        if (n3 != 32 && n3 != 2 && n3 != 41 && n3 != 93 && n3 != 125 && n3 != 96 && n3 != 39 && n3 != 64 && n3 != 61) {
                            act = 2;
                        } else {
                            t1 = t.charAt(i + 1);
                            t2 = t.charAt(i + 2);
                            t.setCharAt(i + 2, t.charAt(i));
                            t.setCharAt(i + 1, t2);
                            t.setCharAt(i, t1);
                            j1 = n;
                            j2 = n2;
                            n2 = now;
                            n = j2;
                            now = j1;
                            act = 3;
                        }
                    } else if (n >= 50 && n <= 57) {
                        t1 = t.charAt(i + 1);
                        t.setCharAt(i + 1, t.charAt(i));
                        t.setCharAt(i, t1);
                        j = n;
                        n = now;
                        now = j;
                        act = 3;
                    } else lbl-1000:
                    // 2 sources

                    {
                        act = L == 106 || L == 74 || L == 113 || L == 81 ? 2 : (L == 120 || L == 88 || L == 122 || L == 90 ? 2 : (L == 32 || L == 41 || L == 93 || L == 125 ? (nL == 32 || nL < 48 && nL != 41 || nL > 122 || nL >= 58 && nL <= 64 || nL >= 91 && nL <= 96 && nL != 93 ? 2 : 3) : (L < 48 && L != 41 && L != 34 && L != 39 || L > 122 && L != 125 || L >= 58 && L <= 64 || L >= 91 && L <= 96 && L != 93 ? 2 : (n != 32 && n != 41 && n != 93 && n != 125 && n != 61 && n != 39 && n != 96 ? 2 : 3))));
                    }
                    break block58;
                }
                act = now == 46 ? (L >= 48 && L <= 57 && n >= 48 && n <= 57 ? 4 : 2) : 2;
            }
            switch (act) {
                case 0: {
                    if (i < nchr) {
                        t.deleteCharAt(i);
                    }
                    --nchr;
                    nnL = nL;
                    nL = L;
                    L = now;
                    now = n;
                    n = n2;
                    n2 = n3;
                    break;
                }
                case 1: {
                    df = -0.4f;
                    ** GOTO lbl202
                }
                case 2: {
                    df = 0.0f;
                    ** GOTO lbl202
                }
                case 3: {
                    df = 0.4f;
                }
lbl202:
                // 4 sources

                default: {
                    if (act != 6) {
                        nnL = nL;
                        nL = L;
                        L = now;
                        now = n;
                        n = n2;
                        n2 = n3;
                    }
                    d[i] = dm + df;
                    ++i;
                }
            }
        } while (i < nchr);
        if (cf.t.length() > 0) {
            cf.t.delete(0, cf.t.length());
        }
        cf.t.append(t);
        cf.d = new float[nchr];
        System.arraycopy(d, 0, cf.d, 0, nchr);
    }

    private class FontInfo {
        Font f;
        FontMetrics fm;
        float fontScale;
        float txtSize;
        float oldTxtSize = Float.MIN_VALUE;
        Rectangle2D rect;
        float width_H;

        FontInfo(Font fnt, FontMetrics fmtr, float fontScale, float txtSize, Rectangle2D rect, float widthH) {
            this.f = fnt;
            this.fm = fmtr;
            this.fontScale = fontScale;
            this.txtSize = txtSize;
            this.oldTxtSize = Float.MIN_VALUE;
            this.rect = rect;
            this.width_H = widthH;
        }

        FontInfo() {
            this.f = new Font("Monospaced", 0, DiagrPaintUtility.this.fontSize);
            this.fm = null;
            this.fontScale = Float.NaN;
            this.txtSize = 0.35f;
            this.oldTxtSize = Float.MIN_VALUE;
            this.rect = null;
            this.width_H = 12.0f;
        }
    }

    static class ChemFormula {
        StringBuffer t = new StringBuffer();
        float[] d;

        ChemFormula(String txt, float[] d_org) {
            this.t.append(txt);
            int nChar = txt.length();
            this.d = new float[nChar];
            System.arraycopy(d_org, 0, this.d, 0, d_org.length);
        }
    }
}

