/*
 * Decompiled with CFR 0.152.
 */
package simpleEquilibriumDiagrams;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Locale;
import lib.kemi.chem.Chem;
import simpleEquilibriumDiagrams.Plot;
import simpleEquilibriumDiagrams.SED;

public class Table {
    private File tf = null;
    private PrintWriter tPW = null;
    private static final Locale engl = Locale.ENGLISH;
    private SED sed = null;
    private final PrintStream out;
    private static final String nl = System.getProperty("line.separator");
    private String commentLineStart = "\"";
    private String commentLineEnd = "\"";
    private static final String SLASH = File.separator;

    public Table(SED sed0, PrintStream err0, PrintStream out0) {
        this.sed = sed0;
        this.out = out0 != null ? out0 : System.out;
        this.commentLineStart = this.sed.tblCommentStart;
        this.commentLineEnd = this.sed.tblCommentEnd;
    }

    boolean tableHeader(Chem ch, String tblExtension) {
        int i;
        if (this.sed.dbg) {
            this.out.println("--- tableHeader");
        }
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.Diagr diag = ch.diag;
        Chem.DiagrConcs dgrC = ch.diagrConcs;
        String dir = this.sed.pathDef.toString();
        if (dir.endsWith(SLASH)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        StringBuilder tfName = new StringBuilder(dir + SLASH + "SED000");
        if (tblExtension == null) {
            tblExtension = "";
        }
        if (tblExtension.startsWith(".")) {
            tblExtension = tblExtension.substring(1);
        }
        tfName.append(".");
        tfName.append(tblExtension);
        int k = tblExtension.length();
        DecimalFormat decf = new DecimalFormat("000");
        for (i = 999; i > -1; --i) {
            tfName.replace(tfName.length() - (4 + k), tfName.length() - (1 + k), decf.format(i));
            this.tf = new File(tfName.toString());
            if (this.tf.exists()) break;
        }
        if (i >= 999 && this.tf.exists()) {
            String msg = "Table output error: File \"SED999." + tblExtension + "\" already exists." + nl + "Please rename or erase some of the existing files." + nl + "Table output not possible.";
            this.sed.showErrMsgBx(msg, 1);
            return false;
        }
        try {
            tfName.replace(tfName.length() - (4 + k), tfName.length() - (1 + k), decf.format(++i));
            this.tPW = new PrintWriter(new BufferedWriter(new FileWriter(tfName.toString())));
        }
        catch (IOException ex) {
            String msg = "Error: \"" + ex.getMessage() + "\"" + nl + "while opening input file \"" + tfName.toString() + "\"";
            this.sed.showErrMsgBx(msg, 1);
            this.tableClose();
            return false;
        }
        this.tf = new File(tfName.toString());
        String msg = "Writing table file:" + nl + "    \"" + tfName.toString() + "\"";
        this.out.println(msg);
        if (this.sed.consoleOutput) {
            System.out.println(msg);
        }
        this.tPW.println(this.commentLineStart + "TABLE output from program SED         (I.Puigdomenech (1983) TRITA-OOK-3010)" + this.commentLineEnd);
        this.tPW.format(engl, "%sNbr chemical components = %d%s%n%s Concentrations:%s%n", this.commentLineStart, cs.Na, this.commentLineEnd, this.commentLineStart, this.commentLineEnd);
        for (i = 0; i < cs.Na; ++i) {
            if (dgrC.hur[i] == 1) {
                this.tPW.format(engl, "%s  Tot. Conc. constant = %10.3g for %s%s%n", this.commentLineStart, dgrC.cLow[i], namn.identC[i], this.commentLineEnd);
            }
            if (dgrC.hur[i] == 2) {
                this.tPW.format(engl, "%s  Tot. Conc. varied between %10.3g and %10.3g for %s%s%n", this.commentLineStart, dgrC.cLow[i], dgrC.cHigh[i], namn.identC[i], this.commentLineEnd);
            }
            if (dgrC.hur[i] == 3) {
                this.tPW.format(engl, "%s  log10(Tot.Conc.) varied between %10.3g and %10.3g for %s%s%n", this.commentLineStart, dgrC.cLow[i], dgrC.cHigh[i], namn.identC[i], this.commentLineEnd);
            }
            if (dgrC.hur[i] == 4) {
                this.tPW.format(engl, "%s  log10(Activity) constant = %10.3g for %s%s%n", this.commentLineStart, dgrC.cLow[i], namn.identC[i], this.commentLineEnd);
            }
            if (dgrC.hur[i] != 5) continue;
            this.tPW.format(engl, "%s  log10(Activity) varied between %10.3g and %10.3g for %s%s%n", this.commentLineStart, dgrC.cLow[i], dgrC.cHigh[i], namn.identC[i], this.commentLineEnd);
        }
        String t = diag.ionicStrength < 0.0 ? "calculated at each point" : String.format(engl, "%6.2f", diag.ionicStrength);
        if (this.sed.calcActCoeffs) {
            this.tPW.format(engl, "%sActivity coeffs. calculated at t =%5.1f degrees and I = %s M%s%n", this.commentLineStart, this.sed.temperature_InCommandLine, t, this.commentLineEnd);
        }
        t = "(program error)";
        if (diag.plotType == 1) {
            t = "fractions";
        } else if (diag.plotType == 2) {
            t = "solubilities";
        } else if (diag.plotType == 3) {
            t = "log10(concs.)";
        } else if (diag.plotType == 4) {
            t = "log10(ai/ar)";
        } else if (diag.plotType == 5) {
            t = "pe (calc.)";
        } else if (diag.plotType == 6) {
            t = "pH (calc.)";
        } else if (diag.plotType == 7) {
            t = "log10(activities)";
        } else if (diag.plotType == 8) {
            t = "d(H-bound)/d(pH)";
        }
        this.tPW.format("%sComponent in X-axis is: %s;  the Y-axis data are %s.%s%n", this.commentLineStart, namn.identC[diag.compX], t, this.commentLineEnd);
        this.tPW.flush();
        return true;
    }

    void tableBody(Chem ch) {
        int i;
        if (this.sed.dbg) {
            this.out.println("--- tableBody");
        }
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.Diagr diag = ch.diag;
        Chem.DiagrConcs dgrC = ch.diagrConcs;
        String fs = this.sed.tblFieldSeparator != null && this.sed.tblFieldSeparator.length() > 0 ? this.sed.tblFieldSeparator : " ";
        this.tPW.format("%sOutput data (there are %d lines and (1+%d) columns)%s%n", this.commentLineStart, this.sed.nSteps + 1, Plot.nbrSpeciesInPlot, this.commentLineEnd);
        this.tPW.println(this.commentLineStart + "(the first column contains the X-axis values)" + this.commentLineEnd);
        if (diag.plotType != 2) {
            if (diag.plotType == 8) {
                this.tPW.println("\"" + namn.identC[diag.compX] + "\"" + fs + "\"d(H-h)/d(pH)\"" + fs);
            } else {
                this.tPW.print("\"" + namn.identC[diag.compX] + "\"" + fs);
                for (i = 0; i < Plot.nbrSpeciesInPlot; ++i) {
                    this.tPW.print("\"" + namn.ident[Plot.speciesInPlot[i]] + "\"" + fs);
                }
                this.tPW.println();
            }
        } else {
            this.tPW.print("\"" + namn.identC[diag.compX] + "\"" + fs);
            for (i = 0; i < Plot.nbrSpeciesInPlot; ++i) {
                this.tPW.print("\"" + namn.identC[Plot.speciesInPlot[i]] + "\"" + fs);
            }
            this.tPW.println();
        }
        double[] y = new double[cs.Ms];
        for (int np = 0; np < this.sed.nSteps + 1; ++np) {
            int i2;
            int k;
            double xValue = this.sed.bt[diag.compX][np];
            if (dgrC.hur[diag.compX] == 3) {
                xValue = Math.log10(xValue);
            } else if (diag.pInX != 0) {
                xValue = -xValue;
            }
            if (diag.plotType == 1) {
                for (k = 0; k < Plot.nbrSpeciesInPlot; ++k) {
                    i2 = Plot.speciesInPlot[k];
                    if (i2 >= cs.Ms) continue;
                    if (Math.abs(Plot.tot0[diag.compY][np]) > 1.0E-30) {
                        double o = i2 < cs.Na ? (i2 == diag.compY ? 1.0 : 0.0) : cs.a[i2 - cs.Na][diag.compY];
                        y[i2] = o * Plot.c0[i2][np] / Plot.tot0[diag.compY][np];
                    } else {
                        y[i2] = 0.0;
                    }
                    if (!(y[i2] > 1.0) || !(y[i2] < 1.01)) continue;
                    y[i2] = 1.0;
                }
            } else if (diag.plotType == 2) {
                for (k = 0; k < Plot.nbrSpeciesInPlot; ++k) {
                    i2 = Plot.speciesInPlot[k];
                    if (i2 >= cs.Ms) continue;
                    y[i2] = Plot.tot0[i2][np] > 1.0E-35 ? Math.log10(Plot.tot0[i2][np]) : -50.0;
                }
            } else if (diag.plotType == 3) {
                for (k = 0; k < Plot.nbrSpeciesInPlot; ++k) {
                    i2 = Plot.speciesInPlot[k];
                    if (i2 >= cs.Ms) continue;
                    y[i2] = Plot.c0[i2][np] > 1.0E-35 ? Math.log10(Plot.c0[i2][np]) : -99.0;
                }
            } else if (diag.plotType == 4) {
                for (k = 0; k < Plot.nbrSpeciesInPlot; ++k) {
                    i2 = Plot.speciesInPlot[k];
                    if (i2 >= cs.Ms) continue;
                    y[i2] = Plot.c0[i2][np] - Plot.c0[diag.compY][np];
                }
            } else if (diag.plotType == 5 || diag.plotType == 6) {
                for (k = 0; k < Plot.nbrSpeciesInPlot; ++k) {
                    i2 = Plot.speciesInPlot[k];
                    if (i2 >= cs.Ms) continue;
                    y[i2] = -Plot.c0[i2][np];
                }
            } else if (diag.plotType == 7) {
                for (k = 0; k < Plot.nbrSpeciesInPlot; ++k) {
                    i2 = Plot.speciesInPlot[k];
                    if (i2 >= cs.Ms) continue;
                    y[i2] = Plot.c0[i2][np];
                }
            } else if (diag.plotType == 8) {
                double w2;
                double w1;
                if (np == 0) {
                    w1 = Plot.c0[1][np + 1] - Plot.c0[1][np];
                    w2 = Plot.tot0[diag.Hplus][np + 1] - Plot.c0[0][np + 1] + Plot.c0[2][np + 1] - (Plot.tot0[diag.Hplus][np] - Plot.c0[0][np] + Plot.c0[2][np]);
                    y[0] = 0.0;
                    if (Math.abs(w1) >= 1.0E-35) {
                        y[0] = w2 / w1;
                    }
                } else if (np < this.sed.nSteps) {
                    w1 = Plot.c0[1][np] - Plot.c0[1][np - 1];
                    w2 = Plot.tot0[diag.Hplus][np] - Plot.c0[0][np] + Plot.c0[2][np] - (Plot.tot0[diag.Hplus][np - 1] - Plot.c0[0][np - 1] + Plot.c0[2][np - 1]);
                    double y1 = 0.0;
                    if (Math.abs(w1) >= 1.0E-35) {
                        y1 = w2 / w1;
                    }
                    w1 = Plot.c0[1][np] - Plot.c0[1][np + 1];
                    w2 = Plot.tot0[diag.Hplus][np] - Plot.c0[0][np] + Plot.c0[2][np] - (Plot.tot0[diag.Hplus][np + 1] - Plot.c0[0][np + 1] + Plot.c0[2][np + 1]);
                    double y2 = 0.0;
                    if (Math.abs(w1) >= 1.0E-35) {
                        y2 = w2 / w1;
                    }
                    y[0] = (y1 + y2) / 0.5;
                } else {
                    w1 = Plot.c0[1][np] - Plot.c0[1][np - 1];
                    w2 = Plot.tot0[diag.Hplus][np] - Plot.c0[0][np] + Plot.c0[2][np] - (Plot.tot0[diag.Hplus][np - 1] - Plot.c0[0][np - 1] + Plot.c0[2][np - 1]);
                    if (Math.abs(w1) >= 1.0E-35) {
                        y[0] = w2 / w1;
                    }
                }
            } else {
                for (k = 0; k < y.length; ++k) {
                    y[k] = -9999.9999;
                }
            }
            this.tPW.format(engl, "%13.5g", xValue);
            for (k = 0; k < Plot.nbrSpeciesInPlot; ++k) {
                i2 = Plot.speciesInPlot[k];
                if (i2 >= cs.Ms) continue;
                this.tPW.format(engl, fs + "%13.5g", y[i2]);
            }
            this.tPW.println();
        }
        this.tableClose();
        this.out.println("Table output written to file:" + nl + "   \"" + this.tf.getPath() + "\"");
    }

    private void tableClose() {
        if (this.sed.dbg) {
            this.out.println("--- tableClose");
        }
        if (this.tPW != null) {
            this.tPW.flush();
            this.tPW.close();
        }
    }
}

