/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.haltaFall;

import java.io.PrintStream;
import java.util.Locale;
import lib.kemi.chem.Chem;
import lib.kemi.haltaFall.Factor;
import lib.kemi.interpolate.Interpolate;

public class HaltaFall {
    private Chem.ChemSystem cs;
    private Chem.ChemSystem.ChemConcs c;
    private PrintStream out;
    private Factor factor = null;
    private boolean panic = false;
    private static int MXA;
    private static int MXX;
    private static int MXS;
    private static int MXC;
    private static int MXAQ;
    private static final int ITER_MAX = 40;
    private static final int ITERC_MAX = 75;
    private static final int ITER_FASTA_MAX = 100;
    private boolean singFall;
    private int ivar;
    private int iterc;
    private int iterFasta;
    private int indik;
    private int nfall;
    private int nfSpar = 0;
    private int nIon;
    private int nUt;
    private int nva;
    private int nvaf;
    private final double TOL_LNG = 0.0023026;
    private double step0;
    private double x;
    private double y;
    private double y0;
    private boolean[] ber;
    private boolean[] fall;
    private boolean[] fallA;
    private boolean[] mono;
    private boolean[] pos;
    private boolean[] neg;
    private boolean[] noCalc;
    private final double NOCALC_LOGA = -9999.0;
    private boolean[][] ober;
    private int[] catchRoundingErrors;
    private int[] fut;
    private int[] ibe;
    private int[] iber;
    private int[] ifall;
    private int[] ifSpar;
    private int[] iter;
    private int[] ivaf;
    private int[] iva;
    private int[] ivaBra;
    private int[] ivaNov;
    private int[] karl;
    private int[] nober;
    private double[] lnA;
    private double[] lnBA;
    private double[] lnBeta;
    private double[] lnG;
    private double[] lnKf;
    private double[] lnKmi;
    private double[] oldLnG;
    private double[] oldLnA;
    private double[][] pva;
    private double[][] rut1;
    private double[][] ruta;
    private double[] steg;
    private double[] tolY;
    private double[] totBe;
    private double[] totVA;
    private double[] x1;
    private double[] x2;
    private double[] xOld;
    private double[] y1;
    private double[] y2;
    private static final double ln10;
    private Locale e = Locale.ENGLISH;
    private static final String nl;
    private static final int ERR_ONLY_1 = 1;
    private static final int ERR_RESULTS_2 = 2;
    private static final int ERR_RESL_INPUT_3 = 3;
    private static final int ERR_DEBUG_FASTA_4 = 4;
    private static final int ERR_DEBUG_ACT_COEF_5 = 5;
    private static final int ERR_XTRA_DEBUG_6 = 6;

    public HaltaFall(Chem.ChemSystem cs, Factor factor, PrintStream ut) throws Chem.ChemicalParameterException {
        int lj;
        int li;
        int liaf;
        this.out = ut != null ? ut : System.out;
        this.cs = cs;
        this.c = cs.chemConcs;
        this.factor = factor;
        if (this.c.dbg >= 3) {
            this.out.println(nl + "HaltaFall - object Constructor");
        }
        this.step0 = 0.1;
        this.c.errFlags = 0;
        if (cs.Na <= 0 || cs.mSol < 0 || cs.nx < 0 || cs.solidC < 0) {
            throw new Chem.ChemicalParameterException("Error in \"HaltaFall\": Na, nx, mSol, solidC =" + cs.Na + ", " + cs.nx + ", " + cs.mSol + ", " + cs.solidC + nl + "   Na must be >0; nx, mSol and solidC must be >=0.");
        }
        if (cs.nx != cs.Ms - cs.Na - cs.mSol) {
            throw new Chem.ChemicalParameterException("Error in \"HaltaFall\": nx =" + cs.nx + ", must be = " + (cs.Ms - cs.Na - cs.mSol) + " (= Ms-Na-mSol)");
        }
        if (cs.lBeta.length < cs.Ms - cs.Na) {
            throw new Chem.ChemicalParameterException("Error in \"HaltaFall\": lBeta.length =" + cs.lBeta.length + "   must be >= " + (cs.Ms - cs.Na) + " (= Ms-Na)");
        }
        if (cs.noll.length < cs.Ms) {
            throw new Chem.ChemicalParameterException("Error in \"HaltaFall\": noll.length =" + cs.noll.length + "   must be >= " + cs.Ms + " (= Ms)");
        }
        if (this.c.kh.length != cs.Na) {
            throw new Chem.ChemicalParameterException("Error in \"HaltaFall\": kh.length =" + this.c.kh.length + "   must be = " + cs.Na + " (= Na)");
        }
        if (this.c.logA.length < cs.Ms) {
            throw new Chem.ChemicalParameterException("Error in \"HaltaFall\": logA.length =" + this.c.logA.length + "   must be >= " + cs.Ms + " (= Ms)");
        }
        for (int i = 0; i < cs.Na; ++i) {
            if (this.c.kh[i] >= 1 && this.c.kh[i] <= 2) continue;
            throw new Chem.ChemicalParameterException("Error in \"HaltaFall\": kh[" + i + "]=" + this.c.kh[i] + " (must be = 1 or 2). Note: component numbers start at zero.");
        }
        if (this.c.dbg >= 4) {
            this.out.println("Debug output requested from HaltaFall at level " + this.c.dbg + nl + "   Note that arrays start at \"zero\":  numbers for" + nl + "   components, complexes and solids start with 0.");
        }
        MXA = cs.Na;
        MXS = cs.mSol;
        MXX = cs.Ms;
        MXC = cs.Ms - cs.Na - cs.mSol;
        MXAQ = cs.Ms - cs.mSol;
        this.karl = new int[MXA];
        this.iter = new int[MXA];
        this.catchRoundingErrors = new int[MXA];
        this.x1 = new double[MXA];
        this.x2 = new double[MXA];
        this.xOld = new double[MXA];
        this.y1 = new double[MXA];
        this.y2 = new double[MXA];
        this.steg = new double[MXA];
        this.ibe = new int[MXA];
        this.ifall = new int[MXS];
        this.iva = new int[MXA + 1];
        this.ivaf = new int[MXA];
        this.ivaBra = new int[MXA + 1];
        this.ivaNov = new int[MXA + 1];
        this.lnBeta = new double[MXC];
        this.lnA = new double[MXX];
        this.oldLnA = new double[MXA];
        this.lnBA = new double[MXC];
        this.lnG = new double[MXAQ];
        this.tolY = new double[MXA];
        this.totVA = new double[MXA];
        this.mono = new boolean[MXA];
        this.ber = new boolean[MXA];
        this.fallA = new boolean[MXA];
        if (MXS > 0) {
            this.lnKf = new double[MXS];
            this.lnKmi = new double[MXS];
            this.fall = new boolean[MXS];
            this.ruta = new double[MXS][MXS];
            this.rut1 = new double[MXA][MXA];
        }
        this.pos = new boolean[MXA];
        this.neg = new boolean[MXA];
        this.ober = new boolean[MXA][MXA];
        this.nober = new int[MXA];
        this.noCalc = new boolean[MXA];
        this.pva = new double[MXA][MXC];
        this.oldLnG = new double[MXAQ];
        for (int lix = 0; lix < MXAQ; ++lix) {
            this.oldLnG[lix] = 0.0;
        }
        this.fut = new int[MXS];
        this.iber = new int[MXA + 1];
        this.ifSpar = new int[MXS];
        this.totBe = new double[MXA];
        this.nIon = cs.Na + cs.nx;
        for (int lix = 0; lix < cs.nx; ++lix) {
            this.lnBeta[lix] = ln10 * cs.lBeta[lix];
        }
        if (cs.mSol != 0) {
            for (int lif = 0; lif < cs.mSol; ++lif) {
                liaf = cs.nx + lif;
                this.lnKf[lif] = -cs.lBeta[liaf] * ln10;
            }
        }
        for (int lia = 0; lia < cs.Na; ++lia) {
            this.mono[lia] = true;
            this.pos[lia] = false;
            if (!cs.noll[lia]) {
                this.pos[lia] = true;
            }
            this.neg[lia] = false;
            for (int lix = cs.Na; lix < cs.Ms; ++lix) {
                int liax = lix - cs.Na;
                if (cs.noll[lix]) continue;
                if (Math.abs(cs.a[liax][lia]) > 1.0E-5 && Math.abs(cs.a[liax][lia] - 1.0) > 1.0E-5) {
                    this.mono[lia] = false;
                }
                if (cs.a[liax][lia] > 0.0) {
                    this.pos[lia] = true;
                }
                if (!(cs.a[liax][lia] < 0.0)) continue;
                this.neg[lia] = true;
            }
        }
        for (li = 0; li < cs.Na; ++li) {
            for (lj = 0; lj < cs.Na; ++lj) {
                this.ober[li][lj] = li != lj;
                for (int lix = 0; lix < cs.nx; ++lix) {
                    double xm;
                    if (cs.noll[cs.Na + lix] || !(Math.abs(xm = cs.a[lix][li] * cs.a[lix][lj]) > 1.0E-5)) continue;
                    this.ober[li][lj] = false;
                }
                if (cs.mSol == 0) continue;
                for (int lif = 0; lif < cs.mSol; ++lif) {
                    double xm;
                    if (cs.noll[this.nIon + lif] || !(Math.abs(xm = cs.a[liaf = cs.nx + lif][li] * cs.a[liaf][lj]) > 1.0E-5)) continue;
                    this.ober[li][lj] = false;
                }
            }
        }
        for (li = 0; li < cs.Na; ++li) {
            this.nober[li] = 0;
            for (lj = 0; lj < cs.Na; ++lj) {
                if (!this.ober[li][lj]) continue;
                this.nober[li] = this.nober[li] + 1;
            }
        }
        for (int ia = 0; ia < cs.Na; ++ia) {
            if (this.c.kh[ia] == 2) continue;
            this.noCalc[ia] = false;
            if (this.pos[ia] && this.neg[ia] || this.pos[ia] && this.c.tot[ia] > 0.0 || this.neg[ia] && this.c.tot[ia] < 0.0) continue;
            this.noCalc[ia] = true;
            this.c.logA[ia] = -9999.0;
        }
        this.haltaGetIva();
        if (this.c.dbg >= 3) {
            this.printInput();
            this.out.println("HaltaFall object constructor ends");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void haltaCalc() throws Chem.ChemicalParameterException {
        if (this.c.dbg >= 4) {
            this.out.println("haltaCalc(concs): Starting calculation with new concentrations.");
        }
        this.c.errFlags = 0;
        this.panic = false;
        this.haltaInit();
        firstLoop = true;
        this.singFall = false;
        this.iterFasta = 1;
        this.iterc = 0;
        MAXtolSteg = 2;
        tol = Math.min(Math.max(Math.abs(this.c.tol), 1.0E-9), 0.01);
        logTol = Math.log10(tol);
        tolSteg = 0.0;
        if (this.nva > 1) {
            tolSpan = Math.min(2, this.nva - 1);
            tolSteg = (double)tolSpan / (double)(this.nva - 1);
        }
        if (this.c.dbg >= 3) {
            this.out.println("Mass-balance tolerances (relative):");
        }
        for (ia = 0; ia < this.cs.Na; ++ia) {
            if (this.c.kh[ia] == 1) {
                w = logTol;
                if (this.nva > 1) {
                    ivaIndex = 0;
                    this.ivar = 0;
                    while (this.ivar < this.nva) {
                        if (this.iva[this.ivar] == ia) {
                            ivaIndex = this.ivar;
                            break;
                        }
                        ++this.ivar;
                    }
                    ivaIndex = this.nva - 1 - ivaIndex;
                    w = logTol - tolSteg * (double)ivaIndex;
                }
                w = Math.pow(10.0, w);
                if (this.c.dbg >= 3) {
                    this.out.print(" " + (float)w);
                }
                this.tolY[ia] = w * Math.max(Math.abs(this.c.tot[ia]), 1.0E-10);
                this.tolY[ia] = Math.max(this.tolY[ia], 1.0E-15);
            } else {
                if (this.c.dbg >= 3) {
                    this.out.print(" NaN");
                }
                this.tolY[ia] = NaN;
            }
            this.lnA[ia] = HaltaFall.ln10 * this.c.logA[ia];
            this.oldLnA[ia] = this.lnA[ia];
        }
        if (this.c.dbg >= 3) {
            this.out.println(HaltaFall.nl + "Mass-balance tolerances (absolute):");
            for (ia = 0; ia < this.cs.Na; ++ia) {
                this.out.print((float)this.tolY[ia] + " ");
            }
            this.out.println();
        }
        if (this.nva <= 0) {
            if (this.c.dbg >= 4) {
                this.out.println("  nva = 0");
            }
            this.ivar = 0;
            this.iterFasta = 0;
            this.x = this.lnaBas(this.ivar);
            this.indik = 1;
            while (this.indik == 1) {
                this.cBer(this.ivar);
                if (this.c.actCoefCalc && !this.actCoeffs() && !this.c.isErrFlagsSet(6)) continue;
            }
            this.fasta();
            this.nog();
            if (this.c.dbg >= 4) {
                this.out.println("haltaCalc returns; nbr. iterations = " + this.iterFasta + ",  " + this.c.errFlagsToString() + HaltaFall.nl);
            }
            return;
        }
        block4: while (!this.panic) {
            if (this.c.dbg >= 4) {
                this.out.println("--- haltaCalc at Slingor; nva=" + this.nva + ", nfall=" + this.nfall + "; nvaf=" + this.nvaf);
                this.printArrays(true, false);
                if (this.nvaf > 0) {
                    this.printArraysFasta(false, false, false, false, false, true, false, false);
                }
                if (this.nfall > 0) {
                    this.printArraysFasta(false, false, true, false, false, false, false, false);
                }
            }
            for (rva = 0; rva < this.nva; ++rva) {
                ia = this.iva[rva];
                this.karl[ia] = 1;
                this.steg[ia] = this.step0;
            }
            this.ivar = this.iva[0];
            if (this.c.dbg >= 4) {
                this.out.println("    haltaCalc at Slingor; new ivar=" + this.ivar);
            }
            if (this.nfall > 0) {
                this.lnaBer1();
            }
            this.x = this.lnaBas(this.ivar);
            if (this.ber[this.ivar]) {
                if (this.c.dbg >= 4) {
                    this.out.println("    ber[" + this.ivar + "]=true;  x=" + this.x + ";  tjat=false;");
                    this.printArrays(false, true);
                }
                this.cBer(this.ivar);
                if (this.nvaf > 0) {
                    this.lnaBer2();
                }
                tjat = false;
            } else {
                tjat = true;
                if (this.cs.nx == 0 && this.cs.noll[this.ivar]) {
                    this.lnA[this.ivar] = 1.0;
                    tjat = false;
                }
                if (this.c.dbg >= 4) {
                    this.out.println("    ber[" + this.ivar + "]=false;  tjat=" + tjat);
                }
            }
            block6: while (!this.panic) {
                block55: {
                    block54: {
                        if (!tjat) break block54;
                        if (this.c.dbg >= 6) {
                            this.out.println("--- haltaCalc at Tjat; ivar=" + this.ivar);
                        }
                        this.lnA[this.ivar] = this.x;
                        if (this.fallA[this.ivar]) {
                            this.lnaBer1();
                            this.x = this.lnaBas(this.ivar);
                        }
                        if (this.ivar == this.ivaNov[this.ivar]) ** GOTO lbl-1000
                        for (rva = 0; rva < this.nva; ++rva) {
                            if (this.iva[rva] != this.ivar) continue;
                            if (rva == 0) break;
                            for (n = 0; n < rva; ++n) {
                                ia = this.iva[n];
                                if (ia == this.ivar || this.ober[this.ivar][ia]) continue;
                                this.iter[ia] = 0;
                            }
                            break;
                        }
                        this.ivar = this.ivaNov[this.ivar];
                        if (this.c.dbg >= 6) {
                            this.out.println("--- haltaCalc at Tjat; new ivar=" + this.ivar);
                        }
                        this.x = this.lnaBas(this.ivar);
                        if (this.ber[this.ivar]) {
                            this.cBer(this.ivar);
                            if (this.nvaf > 0) {
                                this.lnaBer2();
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.cBer(this.ivar);
                            if (this.nvaf > 0) {
                                this.lnaBer2();
                            }
                            this.totBer();
                            if (this.indik == 1) continue;
                            if (this.indik != 2 && this.indik == 3) {
                                this.kille();
                                continue;
                            }
                        }
                        break block55;
                    }
                    tjat = true;
                }
                while (!this.panic) {
                    this.ivar = this.ivaBra[this.ivar];
                    if (this.ivar == -1) {
                        if (this.c.dbg >= 4) {
                            this.out.println("--- haltaCalc at Prov;  new ivar=" + this.ivar);
                            this.printArrays(false, true);
                        }
                        if (firstLoop && this.c.actCoefCalc && !this.actCoeffs()) {
                            this.singFall = false;
                            continue block4;
                        }
                        firstLoop = false;
                        if (!this.c.isErrFlagsSet(6)) {
                            this.iterc = 0;
                        }
                        for (rva = 0; rva < this.nva; ++rva) {
                            if (this.iter[this.iva[rva]] >= 0) continue;
                            this.c.errFlagsSet(2);
                            break block4;
                        }
                        this.fasta();
                        if (this.panic) break block4;
                        if (this.indik == 1 || this.indik == 3) {
                            if (this.c.dbg >= 4 || this.iterc > 69) {
                                this.out.println("haltaCalc at Prov after fasta();");
                                this.printArrays(false, true);
                            }
                            if (!this.c.actCoefCalc || this.actCoeffs()) break block4;
                            this.singFall = false;
                            continue block4;
                        }
                        if (this.indik == 2) {
                            this.c.errFlagsClear(1);
                            this.c.errFlagsClear(2);
                            this.c.errFlagsClear(5);
                            continue block4;
                        }
                    }
                    if (this.ber[this.ivar]) continue;
                    if (this.c.dbg >= 4) {
                        this.out.println("--- haltaCalc at Prov;  new ivar=" + this.ivar);
                        this.printArrays(false, true);
                    }
                    this.x = this.lnaBas(this.ivar);
                    this.totBer();
                    if (this.indik == 1) continue block6;
                    if (this.indik == 2) continue;
                    if (this.indik != 3) break block4;
                    this.kille();
                    continue block6;
                }
                break block4;
            }
            break block4;
        }
        if (this.panic) {
            this.c.errFlags = 0;
            this.c.errFlagsSet(7);
            this.c.cont = false;
            if (this.c.dbg >= 1) {
                this.out.println("haltaCalc(concs) returns;  Interrupted by the user!");
            }
            return;
        }
        this.nog();
        if (this.c.dbg >= 4) {
            this.out.println("haltaCalc(concs) returns;  solid combinations = " + this.iterFasta + "  " + this.c.errFlagsToString() + HaltaFall.nl);
        }
        this.c.cont = this.c.isErrFlagsSet(2) == false && this.c.isErrFlagsSet(3) == false && this.c.isErrFlagsSet(4) == false && this.c.isErrFlagsSet(6) == false;
    }

    public void haltaCancel() {
        this.panic = true;
    }

    public void printConcs() {
        int kjj;
        int jjj;
        int ijj;
        boolean failed;
        this.out.flush();
        boolean bl = failed = this.c.errFlags > 0 && (this.c.isErrFlagsSet(2) || this.c.isErrFlagsSet(3) || this.c.isErrFlagsSet(4) || this.c.isErrFlagsSet(6));
        if (failed) {
            this.out.println("--- HaltaFall - Output composition (failed calculation):");
        } else {
            this.out.println("--- HaltaFall - Calculated equilibrium composition:");
        }
        this.out.println("Components:");
        int n0 = 0;
        int nM = this.cs.Na - 1;
        int iPl = 4;
        int nP = nM - n0;
        if (nP >= 0) {
            this.out.print(" tot conc =");
            block0: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %13.5g", this.c.tot[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block0;
                }
                this.out.println();
                this.out.print("           ");
            }
        }
        n0 = 0;
        nM = this.cs.Na - 1;
        iPl = 4;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print(" solubilty=");
            block2: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %13.5g", this.c.solub[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block2;
                }
                this.out.println();
                this.out.print("           ");
            }
        }
        n0 = 0;
        nM = this.cs.Na - 1;
        iPl = 4;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("   log Act=");
            block4: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %13.5g", this.c.logA[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block4;
                }
                this.out.println();
                this.out.print("           ");
            }
        }
        this.out.println("Aqu.Species  (all components + aqu.complexes):");
        n0 = 0;
        nM = this.nIon - 1;
        iPl = 4;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("     Conc =");
            block6: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %13.5g", this.c.C[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block6;
                }
                this.out.println();
                this.out.print("           ");
            }
        }
        n0 = 0;
        nM = this.nIon - 1;
        iPl = 4;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("   log f=");
            block8: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %13.5g", this.c.logf[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block8;
                }
                this.out.println();
                this.out.print("         ");
            }
        }
        this.out.println("Solid Phases:");
        n0 = this.nIon;
        nM = this.cs.Ms - 1;
        iPl = 4;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("     Conc =");
            block10: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %13.5g", this.c.C[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block10;
                }
                this.out.println();
                this.out.print("           ");
            }
        }
        n0 = this.nIon;
        nM = this.cs.Ms - 1;
        iPl = 4;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("  log Act =");
            block12: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %13.5g", this.c.logA[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block12;
                }
                this.out.println();
                this.out.print("           ");
            }
        }
        if (failed) {
            this.out.println("--- HaltaFall - End of output composition (failed calculation).");
        } else {
            this.out.println("--- HaltaFall - End of equilibrium composition.");
        }
        this.out.flush();
    }

    private void nog() {
        int liax;
        int lix;
        if (this.c.dbg >= 6) {
            this.out.println("nog() in;");
        }
        for (int lia = 0; lia < this.cs.Na; ++lia) {
            this.c.logf[lia] = this.lnG[lia] / ln10;
            this.c.solub[lia] = 0.0;
            if (!this.cs.noll[lia]) {
                this.c.solub[lia] = this.c.C[lia];
            }
            for (lix = 0; lix < this.cs.nx; ++lix) {
                liax = this.cs.Na + lix;
                if (this.cs.noll[liax]) continue;
                this.c.solub[lia] = this.c.solub[lia] + this.cs.a[lix][lia] * this.c.C[liax];
            }
            if (this.c.kh[lia] == 2) {
                if (lia == this.cs.jWater) {
                    this.c.logA[lia] = this.lnA[lia] / ln10;
                }
                this.c.tot[lia] = this.c.solub[lia];
                if (this.cs.mSol <= 0) continue;
                for (lix = 0; lix < this.cs.mSol; ++lix) {
                    liax = this.nIon + lix;
                    int liaf = this.cs.nx + lix;
                    if (this.cs.noll[liax]) continue;
                    this.c.tot[lia] = this.c.tot[lia] + this.cs.a[liaf][lia] * this.c.C[liax];
                }
                continue;
            }
            this.c.logA[lia] = this.lnA[lia] / ln10;
        }
        for (lix = 0; lix < this.cs.nx; ++lix) {
            liax = this.cs.Na + lix;
            this.c.logf[liax] = this.lnG[liax] / ln10;
            this.c.logA[liax] = this.lnA[liax] / ln10;
        }
        if (this.cs.mSol > 0) {
            for (lix = 0; lix < this.cs.mSol; ++lix) {
                liax = this.nIon + lix;
                this.c.logA[liax] = this.lnA[liax] / ln10;
            }
        }
        if (this.c.dbg >= 2) {
            this.printConcs();
        }
        if (this.c.dbg >= 6) {
            this.out.println("nog() returns;");
        }
    }

    private void haltaInit() {
        if (this.c.dbg >= 6) {
            this.out.println("haltaInit() in");
        }
        boolean ok = this.c.cont;
        this.c.tolLogF = 0.0023026 / ln10;
        for (int ia = 0; ia < this.cs.Na; ++ia) {
            this.iter[ia] = 0;
            this.catchRoundingErrors[ia] = 0;
            if (this.c.kh[ia] == 2 || this.pos[ia] && this.neg[ia]) continue;
            if (this.pos[ia] && this.c.tot[ia] > 0.0 || this.neg[ia] && this.c.tot[ia] < 0.0) {
                if (!this.noCalc[ia]) continue;
                ok = false;
                this.noCalc[ia] = false;
                this.c.logA[ia] = -10.0;
                if (!(this.c.tot[ia] > 0.0)) continue;
                this.c.logA[ia] = Math.log10(this.c.tot[ia]) - 2.0;
                continue;
            }
            if (!this.noCalc[ia]) {
                ok = false;
            }
            this.noCalc[ia] = true;
            this.c.logA[ia] = -9999.0;
        }
        if (this.c.dbg >= 4) {
            this.out.println(" haltaInit():");
            int n0 = 0;
            int nM = this.cs.Na - 1;
            int iPl = 20;
            int nP = nM - n0;
            if (nP >= 0) {
                this.out.print(" noCalc[]=");
                block1: for (int ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (int jjj = 0; jjj < iPl; ++jjj) {
                        int kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %6b", this.noCalc[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block1;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (!ok) {
            this.haltaGetIva();
        }
        for (int lix = 0; lix < this.cs.nx; ++lix) {
            this.lnG[lix] = ln10 * this.c.logf[lix];
        }
        if (this.c.dbg >= 6) {
            this.out.println("haltaInit() returns");
        }
    }

    private void haltaGetIva() {
        int ia;
        if (this.c.dbg >= 6) {
            this.out.println("haltaGetIva() in at NYA");
        }
        this.nfall = 0;
        for (ia = 0; ia < this.cs.Na; ++ia) {
            this.ber[ia] = false;
            this.fallA[ia] = false;
        }
        if (this.cs.mSol > 0) {
            for (int lif = 0; lif < this.cs.mSol; ++lif) {
                this.fall[lif] = false;
            }
        }
        this.nva = 0;
        for (ia = 0; ia < this.cs.Na; ++ia) {
            if (this.c.kh[ia] == 2 || this.noCalc[ia]) continue;
            ++this.nva;
            this.iva[this.nva - 1] = ia;
        }
        if (this.c.dbg >= 6) {
            this.out.println("haltaGetIva() at PLAN;");
        }
        if (this.nva > 1) {
            int m;
            do {
                m = 0;
                for (int li = 0; li < this.nva - 1; ++li) {
                    if (this.nober[this.iva[li + 1]] > this.nober[this.iva[li]]) {
                        m = this.iva[li];
                        this.iva[li] = this.iva[li + 1];
                        this.iva[li + 1] = m;
                        continue;
                    }
                    if (!this.mono[this.iva[li + 1]] || this.mono[this.iva[li]] || this.nober[this.iva[li + 1]] != this.nober[this.iva[li]]) continue;
                    m = this.iva[li];
                    this.iva[li] = this.iva[li + 1];
                    this.iva[li + 1] = m;
                }
            } while (m != 0);
        }
        this.iva[this.nva] = -1;
        this.ivaBra[this.nva] = -1;
        if (this.nva > 0) {
            for (int li = 0; li < this.nva; ++li) {
                this.ivar = this.iva[li];
                this.ivaBra[this.ivar] = this.iva[li + 1];
                int i = -1;
                while (this.ober[this.ivar][this.iva[++i]]) {
                }
                this.ivaNov[this.ivar] = this.iva[i];
            }
        }
        if (this.c.dbg >= 4) {
            int kjj;
            int jjj;
            int ijj;
            this.out.println("After \"Plan\" in haltaGetIva():");
            int n0 = 0;
            int nM = this.cs.Na - 1;
            int iPl = 8;
            int nP = nM - n0;
            if (nP >= 0) {
                this.out.print("mono[]= ");
                block7: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %6b", this.mono[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block7;
                    }
                    this.out.println();
                    this.out.print("       ");
                }
            }
            n0 = 0;
            nM = this.cs.Na - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("nober[]= ");
                block9: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %3d", this.nober[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block9;
                    }
                    this.out.println();
                    this.out.print("       ");
                }
            }
            block11: for (int ia2 = 0; ia2 < this.cs.Na; ++ia2) {
                n0 = 0;
                nM = this.cs.Na - 1;
                iPl = 8;
                nP = nM - n0;
                if (nP < 0) continue;
                this.out.print("ober[" + ia2 + "][]= ");
                for (int ijj2 = 0; ijj2 <= nP / iPl; ++ijj2) {
                    for (int jjj2 = 0; jjj2 < iPl; ++jjj2) {
                        int kjj2 = n0 + (ijj2 * iPl + jjj2);
                        this.out.format(this.e, " %6b", this.ober[ia2][kjj2]);
                        if (kjj2 <= nM - 1) continue;
                        this.out.println();
                        continue block11;
                    }
                    this.out.println();
                    this.out.print("       ");
                }
            }
            this.printArrays(true, false);
            n0 = 0;
            nM = this.cs.Na - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("noCalc[]= ");
                block14: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %6b", this.noCalc[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block14;
                    }
                    this.out.println();
                    this.out.print("       ");
                }
            }
        }
        if (this.c.dbg >= 6) {
            this.out.println("haltaGetIva() returns");
        }
    }

    private void kille() {
        boolean yL;
        if (this.c.dbg >= 6) {
            this.out.println("kille() in, ivar=" + this.ivar + ", karl=" + this.karl[this.ivar] + ", x=" + this.x + ", steg=" + this.steg[this.ivar]);
        }
        double STEGBY = 0.01;
        boolean bl = yL = this.y > this.y0;
        if (yL) {
            this.x2[this.ivar] = this.x;
            this.y2[this.ivar] = this.y;
        } else {
            this.x1[this.ivar] = this.x;
            this.y1[this.ivar] = this.y;
        }
        int lq = this.karl[this.ivar];
        switch (lq) {
            case 1: {
                if (yL) {
                    this.karl[this.ivar] = 3;
                    this.x -= this.steg[this.ivar];
                    break;
                }
                this.karl[this.ivar] = 2;
                this.x += this.steg[this.ivar];
                break;
            }
            case 2: {
                if (yL) {
                    this.karl[this.ivar] = 4;
                    break;
                }
                this.steg[this.ivar] = this.steg[this.ivar] + this.steg[this.ivar];
                this.x += this.steg[this.ivar];
                break;
            }
            case 3: {
                if (!yL) {
                    this.karl[this.ivar] = 4;
                    break;
                }
                this.steg[this.ivar] = this.steg[this.ivar] + this.steg[this.ivar];
                this.x -= this.steg[this.ivar];
                break;
            }
            case 4: {
                if (this.steg[this.ivar] >= 0.01) {
                    this.steg[this.ivar] = 0.5 * this.steg[this.ivar];
                    if (!yL) {
                        this.x += this.steg[this.ivar];
                        break;
                    }
                    this.x -= this.steg[this.ivar];
                    break;
                }
                double w = this.y0 - this.y1[this.ivar];
                double w1 = this.x2[this.ivar] - this.x1[this.ivar];
                this.x = this.x1[this.ivar] + w * w1 / (this.y2[this.ivar] - this.y1[this.ivar]);
                if (!(w1 < 1.0E-6) || !(Math.abs(this.x - this.xOld[this.ivar]) < 1.0E-12)) break;
                if (this.c.dbg >= 6) {
                    this.out.println("y0,y1,y2=" + this.y0 + ", " + this.y1[this.ivar] + ", " + this.y2[this.ivar]);
                }
                if (this.catchRoundingErrors[this.ivar] == 0) {
                    this.catchRoundingErrors[this.ivar] = 1;
                    this.x -= 1.0E-5;
                } else if (this.catchRoundingErrors[this.ivar] == 1) {
                    this.catchRoundingErrors[this.ivar] = 2;
                    this.x += 1.0E-5;
                } else if (this.catchRoundingErrors[this.ivar] == 2) {
                    this.catchRoundingErrors[this.ivar] = 3;
                    this.x = this.x1[this.ivar] + w * w1 / (this.y2[this.ivar] - this.y1[this.ivar]);
                }
                if (this.c.dbg < 6) break;
                this.out.println("   x1,x2=" + this.x1[this.ivar] + ", " + this.x2[this.ivar] + ", new x=" + this.x);
                break;
            }
            default: {
                this.out.println("!? Programming error in \"HaltaFall\"; karl[ivar]=" + lq);
                this.karl[this.ivar] = 1;
            }
        }
        this.xOld[this.ivar] = this.x;
        if (this.c.dbg >= 6) {
            this.out.println("kille() returns, karl=" + this.karl[this.ivar] + "; indik=" + this.indik + "; x=" + this.x);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fasta() {
        BEFALL = 16000;
        UTFALL = 17000;
        HOPPSI = 19000;
        FUTT = 20000;
        HOPPFUT = 21000;
        INFUT = 22000;
        UPPNUT = 23000;
        ANFALL = 24000;
        i = 0;
        if (this.cs.mSol == 0) {
            this.indik = 3;
            if (this.c.dbg >= 4) {
                this.out.println("Fasta(); Msol=0 (no solids in the system)");
            }
            return;
        }
        if (this.c.dbg >= 4) {
            this.out.println("--- Fasta() in at FallProv; nfall=" + this.nfall);
            this.printArraysFasta(true, false, false, false, false, false, false, false);
        }
        bra = true;
        nyfall = 0;
        for (lif = 0; lif < this.cs.mSol; ++lif) {
            liax = this.nIon + lif;
            if (!this.fall[lif]) {
                liaf = this.cs.nx + lif;
                this.c.C[liax] = 0.0;
                w = 0.0;
                for (lia = 0; lia < this.cs.Na; ++lia) {
                    w += this.cs.a[liaf][lia] * this.lnA[lia];
                }
                this.lnA[liax] = w - this.lnKf[lif];
                if (w <= this.lnKf[lif] || this.cs.noll[liax] || this.nva == 0) continue;
                foundOne = false;
                for (lia = 0; lia < this.nva; ++lia) {
                    if (!(Math.abs(this.cs.a[liaf][this.iva[lia]]) > 1.0E-5)) continue;
                    foundOne = true;
                    break;
                }
                if (!foundOne) continue;
                bra = false;
                this.fall[lif] = true;
                ++nyfall;
                if (this.c.dbg >= 4) {
                    this.out.println("Fasta(): nyfall=" + nyfall + ", ifall[" + (this.nfall + nyfall - 1) + "]=" + lif);
                }
                this.ifall[this.nfall + nyfall - 1] = lif;
                continue;
            }
            this.lnA[liax] = 0.0;
        }
        if (this.nfall + nyfall > 0 && this.nfall + nyfall < this.ifall.length) {
            for (lif = this.nfall + nyfall; lif < this.ifall.length; ++lif) {
                this.ifall[lif] = -1;
            }
        }
        if (this.nva == 0) {
            if (this.c.dbg >= 4) {
                this.out.println("Fasta() returns (nva=0)");
            }
            return;
        }
        if (this.nfall > 0) {
            for (li = 0; li < this.nfall; ++li) {
                ia = this.ibe[li];
                w = this.c.tot[ia] - this.c.C[ia];
                for (lix = 0; lix < this.cs.nx; ++lix) {
                    liax = this.cs.Na + lix;
                    w -= this.cs.a[lix][ia] * this.c.C[liax];
                }
                this.totBe[li] = w;
            }
            for (li = 0; li < this.nfall; ++li) {
                w = 0.0;
                for (lj = 0; lj < this.nfall; ++lj) {
                    w += this.ruta[li][lj] * this.totBe[lj];
                }
                lq = this.ifall[li];
                lqa = this.nIon + lq;
                this.c.C[lqa] = w;
                if (this.c.C[lqa] >= 0.0) continue;
                this.fall[lq] = false;
                this.c.C[lqa] = 0.0;
                bra = false;
                if (this.c.dbg < 4) continue;
                this.out.println("Fasta(): for solid " + lq + " the concentration is less than zero");
            }
        }
        if (bra) {
            this.indik = 3;
            if (this.c.dbg >= 4) {
                this.out.println("HaltaFall.fasta() returns OK (to nog()); indik =3; nfall=" + this.nfall);
                this.printArraysFasta(true, true, true, true, true, false, false, false);
            }
            return;
        }
        if (this.iterFasta > 100) {
            this.indik = 3;
            this.c.errFlagsSet(4);
            if (this.c.dbg >= 1) {
                this.out.println("Error in HaltaFall.fasta(): 100 different solid phase combinations" + HaltaFall.nl + "were tested and found NOT satisfactory.");
            }
            if (this.c.dbg >= 4) {
                this.out.println("Fasta() returns; " + this.c.errFlagsToString());
            }
            return;
        }
        ++this.iterFasta;
        this.nfall += nyfall;
        li = -1;
        do {
            if (this.fall[this.ifall[++li]]) continue;
            --this.nfall;
            if (this.nfall != 0) {
                for (lj = li; lj < this.nfall; ++lj) {
                    this.ifall[lj] = this.ifall[lj + 1];
                }
            }
            --li;
        } while (li < this.nfall - 1);
        if (this.c.dbg >= 4) {
            this.out.println("Fasta() at InFall; nfall=" + this.nfall + ", nyfall=" + nyfall + ", nva=" + this.nva + ", singFall=" + this.singFall);
            this.printArraysFasta(true, false, false, false, false, false, false, false);
            if (this.singFall) {
                this.printArraysFasta(false, false, false, false, false, false, true, false);
            }
        }
        goTo = -1;
        if (this.nfall == 0) {
            goTo = 24000;
        } else {
            if (!this.singFall) {
                for (li = 0; li < this.nfall; ++li) {
                    this.ifSpar[li] = this.ifall[li];
                }
                this.nfSpar = this.nfall;
                this.nUt = 0;
                if (this.nfall > this.nva) {
                    this.nUt = this.nfall - this.nva - 1;
                    this.singFall = true;
                    if (this.c.dbg >= 4) {
                        this.out.println("   nfall (=" + this.nfall + ") is > nva (=" + this.nva + ") & !singFall" + HaltaFall.nl + "   nfSpar = " + this.nfSpar + " nUt = " + this.nUt + " setting singFall=true");
                    }
                    goTo = 23000;
                }
            }
            if (goTo == -1 && this.nfall >= this.nva && this.singFall) {
                i = -1;
                if (this.c.dbg >= 4) {
                    this.out.println("   nfall (=" + this.nfall + ") is >= nva (=" + this.nva + ") & singFall = " + this.singFall + HaltaFall.nl + "   nfSpar = " + this.nfSpar + " nUt = " + this.nUt);
                }
                this.nfall = this.nfSpar - this.nUt;
                block21: for (lf = 0; lf < this.cs.mSol; ++lf) {
                    this.fall[lf] = false;
                    for (li = 0; li < this.nfSpar; ++li) {
                        if (this.ifSpar[li] != lf) continue;
                        this.fall[lf] = true;
                        continue block21;
                    }
                }
                goTo = 21000;
            }
        }
        if (goTo == -1) {
            goTo = 16000;
        }
        block23: while (!this.panic) {
            switch (goTo) {
                case 16000: {
                    if (this.c.dbg >= 4) {
                        this.out.println("Fasta() at BeFall, nfall=" + this.nfall);
                    }
                    for (li = 0; li < this.nfall; ++li) {
                        this.iber[li] = li;
                    }
                    this.iber[this.nfall] = -1;
                }
                case 17000: {
                    if (this.c.dbg >= 4) {
                        this.out.println("Fasta() at UtFall, nfall=" + this.nfall);
                        this.printArraysFasta(true, true, false, false, false, false, false, false);
                    }
                    for (li = 0; li < this.nfall; ++li) {
                        ia = this.iva[this.iber[li]];
                        for (lj = 0; lj < this.nfall; ++lj) {
                            lf = this.cs.nx + this.ifall[lj];
                            this.ruta[li][lj] = this.cs.a[lf][ia];
                        }
                    }
                    this.indik = 0;
                    this.invert(this.ruta, this.nfall);
                    if (this.indik == 0) break block23;
                    i = -1;
                    this.singFall = true;
                }
                case 19000: {
                    ++i;
                    if (this.c.dbg >= 4) {
                        this.out.println("Fasta() at HoppSi, i=" + i);
                    }
                    if (this.iber[i] == this.nva - 1) {
                        goTo = 20000;
                    } else if (this.iber[i + 1] == this.iber[i] + 1) {
                        goTo = 19000;
                    } else {
                        this.iber[i] = this.iber[i] + 1;
                        if (i > 0) {
                            for (lj = 0; lj <= i - 1; ++lj) {
                                this.iber[lj] = lj;
                            }
                        }
                        if (this.c.dbg >= 4) {
                            this.printArraysFasta(false, true, false, false, false, false, false, false);
                        }
                        goTo = 17000;
                    }
                    ** GOTO lbl279
                }
                case 20000: {
                    if (this.c.dbg >= 4) {
                        this.out.println("Fasta() at Futt;  nUt=" + this.nUt + ", nfall=" + this.nfall + ", nfspar=" + this.nfSpar);
                        this.printArraysFasta(false, false, false, false, false, false, true, true);
                    }
                    if (this.nUt != 0) ** GOTO lbl194
                    this.fut[this.nUt] = -1;
                    this.fut[this.nUt + 1] = -1;
                    goTo = 23000;
                    ** GOTO lbl279
lbl194:
                    // 1 sources

                    i = -1;
                }
                case 21000: {
                    ++i;
                    if (this.c.dbg >= 4) {
                        this.out.println("Fasta() at HoppFut, i=" + i);
                    }
                    if (this.fut[i] != this.nfSpar - 1) ** GOTO lbl202
                    goTo = 23000;
                    ** GOTO lbl279
lbl202:
                    // 1 sources

                    if (this.fut[i + 1] != this.fut[i] + 1) ** GOTO lbl205
                    goTo = 21000;
                    ** GOTO lbl279
lbl205:
                    // 1 sources

                    this.fut[i] = this.fut[i] + 1;
                    if (i > 0) {
                        for (lj = 0; lj <= i - 1; ++lj) {
                            this.fut[lj] = lj;
                        }
                        if (this.c.dbg >= 4) {
                            this.printArraysFasta(false, false, false, false, false, false, false, true);
                        }
                    }
                }
                case 22000: {
                    if (this.c.dbg >= 4) {
                        this.out.println("Fasta() at InFut; nfall=" + this.nfall + ", nfSpar=" + this.nfSpar + ", nUt=" + this.nUt);
                        this.printArraysFasta(false, false, false, false, false, false, false, true);
                    }
                    for (li = 0; li < this.nfSpar; ++li) {
                        this.fall[this.ifSpar[li]] = true;
                    }
                    if (this.nUt > 0) {
                        for (li = 0; li < this.nUt; ++li) {
                            this.fall[this.ifSpar[this.fut[li]]] = false;
                        }
                    }
                    if (this.nfSpar > 1) {
                        j = -1;
                        for (li = 0; li < this.nfSpar; ++li) {
                            if (!this.fall[this.ifSpar[li]]) continue;
                            this.ifall[++j] = this.ifSpar[li];
                        }
                        this.nfall = j + 1;
                    } else if (this.nfall == 1 && this.nfSpar == 1) {
                        this.ifall[0] = this.ifall[1];
                    }
                    if (this.c.dbg >= 4) {
                        this.out.println("        after InFut: nfall=" + this.nfall);
                        this.printArraysFasta(true, false, false, false, false, false, false, false);
                    }
                    goTo = this.nfall <= 0 ? 24000 : 16000;
                    ** GOTO lbl279
                }
                case 23000: {
                    ++this.nUt;
                    this.nfall = this.nfSpar - this.nUt;
                    if (this.c.dbg >= 4) {
                        this.out.println("Fasta() at UppNut;  nUt=" + this.nUt + ", nfSpar=" + this.nfSpar + ",  nfall=" + this.nfall + "(=nfSpar-nUt)");
                    }
                    if (this.nfall <= 0) ** GOTO lbl252
                    for (li = 0; li < this.nUt; ++li) {
                        this.fut[li] = li;
                    }
                    this.fut[this.nUt] = -1;
                    if (this.c.dbg >= 4) {
                        this.printArraysFasta(false, false, false, false, false, false, false, true);
                    }
                    goTo = 22000;
                    ** GOTO lbl279
lbl252:
                    // 1 sources

                    if (this.nfall != 0 || this.nfSpar != 1) ** GOTO lbl260
                    this.nfall = 1;
                    this.fut[0] = 0;
                    this.fut[1] = -1;
                    if (this.c.dbg >= 4) {
                        this.printArraysFasta(false, false, false, false, false, false, false, true);
                    }
                    goTo = 22000;
                    ** GOTO lbl279
lbl260:
                    // 1 sources

                    this.nfall = 0;
                    this.nvaf = 0;
                    for (lf = 0; lf < this.cs.mSol; ++lf) {
                        this.fall[lf] = false;
                    }
                    for (ia = 0; ia < this.cs.Na; ++ia) {
                        this.ber[ia] = false;
                        this.fallA[ia] = false;
                    }
                    if (this.c.dbg >= 1) {
                        this.out.println("Error in HaltaFall.fasta(): The " + this.nfSpar + " solids found give only zero determinants (\"Tji\")." + HaltaFall.nl + "List of solids (array ifSpar):");
                        this.printArraysFasta(false, false, false, false, false, false, true, false);
                    }
                    this.indik = 1;
                    this.c.errFlagsSet(3);
                    if (this.c.dbg >= 4) {
                        this.out.println("HaltaFall.fasta() returns at \"Tji\", " + this.c.errFlagsToString() + ", nvaf = " + this.nvaf);
                    }
                    return;
                }
                case 24000: {
                    break block23;
                }
lbl279:
                // 10 sources

                default: {
                    continue block23;
                }
            }
        }
        if (this.panic) {
            this.indik = 2;
            return;
        }
        if (this.c.dbg >= 4) {
            this.out.println("Fasta() at Anfall; nfall=" + this.nfall);
        }
        for (lia = 0; lia < this.cs.Na; ++lia) {
            this.fallA[lia] = false;
            this.ber[lia] = false;
        }
        if (this.nfall > 0) {
            for (li = 0; li < this.nfall; ++li) {
                liaf = this.cs.nx + this.ifall[li];
                if (this.fall[this.ifall[li]]) {
                    for (lia = 0; lia < this.cs.Na; ++lia) {
                        if (this.cs.a[liaf][lia] == 0.0) continue;
                        this.fallA[lia] = true;
                    }
                }
                this.ibe[li] = this.iva[this.iber[li]];
                this.ber[this.ibe[li]] = true;
            }
            this.nvaf = 0;
            if (this.nva > 0) {
                for (li = 0; li < this.nva; ++li) {
                    ia = this.iva[li];
                    if (this.ber[ia]) continue;
                    ++this.nvaf;
                    this.ivaf[this.nvaf - 1] = ia;
                }
                if (this.c.dbg >= 4) {
                    this.out.println("  nvaf=" + this.nvaf);
                    this.printArraysFasta(false, false, false, false, true, true, false, false);
                }
                if (this.nvaf > 0) {
                    for (li = 0; li < this.nvaf; ++li) {
                        for (lj = 0; lj < this.nfall; ++lj) {
                            w = 0.0;
                            for (lm = 0; lm < this.nfall; ++lm) {
                                lq = this.ivaf[li];
                                lz = this.cs.nx + this.ifall[lm];
                                w += this.cs.a[lz][lq] * this.ruta[lm][lj];
                            }
                            this.rut1[li][lj] = w;
                        }
                    }
                    for (li = 0; li < this.nvaf; ++li) {
                        for (lix = 0; lix < this.cs.nx; ++lix) {
                            ia = this.ivaf[li];
                            w = this.cs.a[lix][ia];
                            if (this.nfall > 0) {
                                for (lm = 0; lm < this.nfall; ++lm) {
                                    lq = this.ibe[lm];
                                    w -= this.cs.a[lix][lq] * this.rut1[li][lm];
                                }
                            }
                            this.pva[ia][lix] = w;
                        }
                    }
                }
            }
        }
        this.indik = 2;
        if (this.c.dbg >= 4) {
            this.out.println("HaltaFall.fasta() returns at Slingor(In); nfall=" + this.nfall);
            this.printArraysFasta(true, true, true, true, true, false, false, false);
        }
    }

    private void cBer(int ivar) {
        if (this.c.dbg >= 6) {
            this.out.println("cBer(" + ivar + ") in");
        }
        for (int lix = 0; lix < this.cs.nx; ++lix) {
            int liax = this.cs.Na + lix;
            double q = this.noCalc[ivar] ? Math.abs(this.cs.a[lix][ivar]) : this.cs.a[lix][ivar];
            this.lnA[liax] = this.lnBA[lix] + q * this.lnA[ivar];
        }
        for (int lia = 0; lia < this.nIon; ++lia) {
            this.c.C[lia] = 0.0;
            if (this.cs.noll[lia]) continue;
            double lnC = this.lnA[lia] - this.lnG[lia];
            if (lnC > 80.0) {
                lnC = 80.0;
            }
            if (!(lnC > -80.0)) continue;
            this.c.C[lia] = Math.exp(lnC);
        }
        if (this.c.dbg >= 6) {
            this.out.println("cBer() returns");
        }
    }

    private void invert(double[][] a, int n) {
        int j;
        int i;
        int k;
        int[] row = new int[n];
        int[] col = new int[n];
        double[] temp = new double[n];
        if (this.c.dbg >= 4) {
            this.out.println("invert(ruta[][]," + n + ") in");
        }
        for (k = 0; k < n; ++k) {
            row[k] = k;
            col[k] = k;
        }
        for (k = 0; k < n; ++k) {
            int j2;
            double pivot = a[row[k]][col[k]];
            int iPivot = k;
            int jPivot = k;
            for (i = k; i < n; ++i) {
                for (j2 = k; j2 < n; ++j2) {
                    if (!(Math.abs(a[row[i]][col[j2]]) > Math.abs(pivot))) continue;
                    iPivot = i;
                    jPivot = j2;
                    pivot = a[row[i]][col[j2]];
                }
            }
            if (Math.abs(pivot) < 1.0E-10) {
                this.indik = 1;
                if (this.c.dbg >= 4) {
                    this.out.println("invert() returns; indik=1 (matrix singular).");
                }
                return;
            }
            int hold = row[k];
            row[k] = row[iPivot];
            row[iPivot] = hold;
            hold = col[k];
            col[k] = col[jPivot];
            col[jPivot] = hold;
            a[row[k]][col[k]] = 1.0 / pivot;
            for (j = 0; j < n; ++j) {
                if (j == k) continue;
                a[row[k]][col[j]] = a[row[k]][col[j]] * a[row[k]][col[k]];
            }
            for (i = 0; i < n; ++i) {
                if (k == i) continue;
                for (j2 = 0; j2 < n; ++j2) {
                    if (k == j2) continue;
                    a[row[i]][col[j2]] = a[row[i]][col[j2]] - a[row[i]][col[k]] * a[row[k]][col[j2]];
                }
                a[row[i]][col[k]] = -a[row[i]][col[k]] * a[row[k]][col[k]];
            }
        }
        for (int j3 = 0; j3 < n; ++j3) {
            for (i = 0; i < n; ++i) {
                temp[col[i]] = a[row[i]][j3];
            }
            for (i = 0; i < n; ++i) {
                a[i][j3] = temp[i];
            }
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (j = 0; j < n; ++j) {
                temp[row[j]] = a[i2][col[j]];
            }
            System.arraycopy(temp, 0, a[i2], 0, n);
        }
        if (this.c.dbg >= 4) {
            this.out.println("invert() returns; indik=" + this.indik + " (ok)");
        }
    }

    private void lnaBer1() {
        double w;
        int li;
        if (this.c.dbg >= 6) {
            this.out.println("lnaBer1() in,  nfall=" + this.nfall);
        }
        for (li = 0; li < this.nfall; ++li) {
            int iF = this.ifall[li];
            int liaf = this.cs.nx + iF;
            w = this.lnKf[iF];
            for (int lia = 0; lia < this.cs.Na; ++lia) {
                if (this.ber[lia]) continue;
                w -= this.cs.a[liaf][lia] * this.lnA[lia];
            }
            this.lnKmi[li] = w;
        }
        for (li = 0; li < this.nfall; ++li) {
            w = 0.0;
            for (int lj = 0; lj < this.nfall; ++lj) {
                w += this.lnKmi[lj] * this.ruta[lj][li];
            }
            int ia = this.ibe[li];
            this.lnA[ia] = w;
        }
        if (this.c.dbg >= 6) {
            this.out.println("lnaBer1() returns");
        }
    }

    private double lnaBas(int ivar) {
        if (this.c.dbg >= 6) {
            this.out.println("lnaBas(" + ivar + ") in");
        }
        double w = this.lnA[ivar];
        for (int lix = 0; lix < this.cs.nx; ++lix) {
            this.lnBA[lix] = this.lnBeta[lix];
            for (int li = 0; li < this.cs.Na; ++li) {
                if (li == ivar) continue;
                double q = this.noCalc[li] ? Math.abs(this.cs.a[lix][li]) : this.cs.a[lix][li];
                this.lnBA[lix] = this.lnBA[lix] + q * this.lnA[li];
            }
        }
        if (this.c.dbg >= 6) {
            this.out.println("lnaBas() returns");
        }
        return w;
    }

    private void totBer() {
        block25: {
            double w = 0.0;
            if (this.c.dbg >= 6) {
                this.out.println("totBer() in, ivar=" + this.ivar + ", indik=" + this.indik);
            }
            if (this.catchRoundingErrors[this.ivar] == 3) {
                this.catchRoundingErrors[this.ivar] = 0;
                this.c.errFlagsSet(1);
                this.indik = 2;
                this.karl[this.ivar] = 1;
                this.steg[this.ivar] = this.step0;
                this.iter[this.ivar] = 0;
                if (this.c.dbg >= 6) {
                    this.out.println("totBer() returns; indik = 2 (ok), but \"rounding errors\"");
                }
                return;
            }
            try {
                this.y = this.c.C[this.ivar];
                if (this.nfall > 0) {
                    for (int lix = 0; lix < this.cs.nx; ++lix) {
                        int liax = this.cs.Na + lix;
                        this.y += this.pva[this.ivar][lix] * this.c.C[liax];
                    }
                    this.y -= this.totVA[this.ivar];
                    this.y0 = 0.0;
                    w = Math.abs(this.y - this.y0);
                    if (this.c.tol > 0.0 && Math.abs(this.totVA[this.ivar]) > 1.0 && w < Math.abs(this.c.tol * this.totVA[this.ivar])) {
                        w = 0.0;
                    }
                } else {
                    for (int lix = 0; lix < this.cs.nx; ++lix) {
                        int liax = this.cs.Na + lix;
                        this.y += this.cs.a[lix][this.ivar] * this.c.C[liax];
                    }
                    this.y0 = this.c.tot[this.ivar];
                    w = Math.abs(this.y - this.y0);
                }
                if (this.tolY[this.ivar] < w) {
                    if (this.mono[this.ivar] && this.nfall == 0) {
                        if (this.y0 <= 0.0 || this.y <= 0.0) {
                            this.indik = 3;
                            this.iter[this.ivar] = this.iter[this.ivar] + 1;
                            if (this.iter[this.ivar] >= 40) {
                                throw new TooManyIterationsException();
                            }
                            if (this.c.dbg >= 6) {
                                this.prnt();
                                this.out.println("totBer() returns; indik =3; iter[" + this.ivar + "]=" + this.iter[this.ivar]);
                            }
                            return;
                        }
                        this.lnA[this.ivar] = this.lnA[this.ivar] + Math.log(this.y0) - Math.log(this.y);
                        this.x = this.lnA[this.ivar];
                        this.indik = 1;
                        this.iter[this.ivar] = this.iter[this.ivar] + 1;
                        if (this.iter[this.ivar] >= 40) {
                            throw new TooManyIterationsException();
                        }
                        if (this.c.dbg >= 6) {
                            this.prnt();
                            this.out.println("totBer() returns; indik =1, mono[" + this.ivar + "]=true");
                        }
                    } else {
                        this.indik = 3;
                        this.iter[this.ivar] = this.iter[this.ivar] + 1;
                        if (this.iter[this.ivar] >= 40) {
                            throw new TooManyIterationsException();
                        }
                        if (this.c.dbg >= 6) {
                            this.prnt();
                            this.out.println("totBer() returns; indik =3; iter[" + this.ivar + "]=" + this.iter[this.ivar]);
                        }
                    }
                } else {
                    this.indik = 2;
                    this.karl[this.ivar] = 1;
                    this.steg[this.ivar] = this.step0;
                    this.iter[this.ivar] = 0;
                    if (this.c.dbg >= 6) {
                        this.prnt();
                        this.out.println("totBer() returns; indik =2 (ok)");
                    }
                }
            }
            catch (TooManyIterationsException ex) {
                if (this.c.dbg >= 6) {
                    this.out.println("--- Too many iterations for ivar=" + this.ivar);
                }
                if (this.ivaBra[this.ivar] == -1 && this.c.dbg >= 4) {
                    this.printTooManyIterations(w);
                }
                if (this.iter[this.ivar] > 41) {
                    this.indik = 2;
                    this.karl[this.ivar] = 1;
                    this.steg[this.ivar] = this.step0;
                    this.iter[this.ivar] = -1;
                }
                if (this.c.dbg < 6) break block25;
                this.prnt();
                this.out.println("totBer() returns; indik =" + this.indik + "; iter[" + this.ivar + "]=" + this.iter[this.ivar] + ", too many iterations.");
            }
        }
    }

    private void lnaBer2() {
        int ia;
        int li;
        if (this.c.dbg >= 6) {
            this.out.println("lnaBer2() in, nfall=" + this.nfall);
        }
        double[] totMi = new double[MXA];
        for (li = 0; li < this.nfall; ++li) {
            ia = this.ibe[li];
            totMi[li] = this.c.tot[ia] - this.c.C[ia];
        }
        for (li = 0; li < this.nvaf; ++li) {
            ia = this.ivaf[li];
            double w = this.c.tot[ia];
            for (int lj = 0; lj < this.nfall; ++lj) {
                w -= this.rut1[li][lj] * totMi[lj];
            }
            this.totVA[ia] = w;
        }
        if (this.c.dbg >= 6) {
            this.out.println("lnaBer2() return");
        }
    }

    private boolean actCoeffs() {
        boolean ok;
        double absDiff;
        int i;
        boolean debug;
        boolean bl = debug = this.c.dbg >= 5 || this.iterc > 69;
        if (debug) {
            this.out.println("actCoeffs() in");
        }
        boolean factorOK = true;
        try {
            this.factor.factor(this.c.C, this.lnG);
        }
        catch (Factor.SITdataException ex) {
            if (this.c.dbg >= 1) {
                this.out.println(ex.getMessage());
            }
            factorOK = false;
        }
        catch (Interpolate.RationalInterpolationException ex) {
            if (this.c.dbg >= 1) {
                this.out.println(ex.getMessage());
            }
            factorOK = false;
        }
        if (!factorOK) {
            for (int i2 = 0; i2 < this.nIon; ++i2) {
                this.lnG[i2] = 0.0;
            }
            if (this.cs.jWater >= 0) {
                this.lnA[this.cs.jWater] = 0.0;
            }
            this.c.errFlagsSet(6);
            if (debug) {
                this.out.println("actCoeffs() returns.  Error in Factor.");
            }
            return true;
        }
        if (this.cs.jWater >= 0) {
            this.lnA[this.cs.jWater] = this.lnG[this.cs.jWater];
        }
        double tolLnG = 0.0023026;
        for (i = 0; i < this.nIon; ++i) {
            if (this.c.C[i] < 1.0 || this.cs.namn.z[i] == 0 || this.cs.noll[i]) continue;
            tolLnG = Math.max(tolLnG, 0.0023026 * this.c.C[i]);
        }
        this.c.tolLogF = tolLnG / ln10;
        int iMaxDiff = -1;
        for (i = 0; i < this.cs.Na; ++i) {
            absDiff = Math.abs(this.lnA[i] - this.oldLnA[i]);
            this.oldLnA[i] = this.lnA[i];
            if (absDiff < 1.0E-10) continue;
            iMaxDiff = i;
            break;
        }
        boolean bl2 = ok = iMaxDiff == -1;
        if (!ok) {
            if (debug) {
                this.printLnG(0);
            }
            ok = true;
            iMaxDiff = -1;
            double maxAbsDiff = -1.0;
            for (i = 0; i < this.nIon; ++i) {
                if (this.c.C[i] < 1.0E-50) {
                    this.oldLnG[i] = this.lnG[i];
                    continue;
                }
                double diff = this.lnG[i] - this.oldLnG[i];
                absDiff = Math.abs(diff);
                if (absDiff <= tolLnG) continue;
                ok = false;
                if (maxAbsDiff < absDiff) {
                    iMaxDiff = i;
                    maxAbsDiff = absDiff;
                }
                double cMin = 1.0;
                double cMax = 15.0;
                double fatcMin = 1.0;
                double fatcMax = 0.1;
                if (this.iterc > 5 && this.cs.chemConcs.C[i] > 1.0) {
                    double f = Math.max(0.1, Math.min(1.0, 1.0 + (this.cs.chemConcs.C[i] - 1.0) * -0.0642857142857143));
                    double newDiff = diff * f;
                    if (debug) {
                        this.out.println("note, for \"" + this.cs.namn.ident[i] + "\" C[" + i + "] = " + (float)this.cs.chemConcs.C[i] + " diff=" + (float)diff + " f=" + (float)f + " applying lnG-change = " + (float)newDiff);
                    }
                    this.lnG[i] = this.oldLnG[i] + newDiff;
                }
                this.oldLnG[i] = this.lnG[i];
            }
            if (debug) {
                if (this.iterc > 0) {
                    this.printLnG(1);
                }
                if (maxAbsDiff > 0.0) {
                    this.out.println("Max abs(diff) for \"" + this.cs.namn.ident[iMaxDiff] + "\", lnG[" + iMaxDiff + "]=" + (float)maxAbsDiff);
                }
            }
        }
        if (ok) {
            for (i = 0; i < this.nIon; ++i) {
                if (!(this.c.C[i] > 50.0)) continue;
                this.c.errFlagsSet(5);
                break;
            }
        } else {
            ++this.iterc;
            if (this.iterc > 75) {
                ok = true;
                this.c.errFlagsSet(6);
            }
        }
        if (debug || this.c.dbg >= 4) {
            if (ok) {
                if (this.c.isErrFlagsSet(6)) {
                    this.out.print("--- actCoeffs() returns Ok after too many iterations");
                } else {
                    this.out.print("--- actCoeffs() returns OK after " + this.iterc + " iterations");
                }
            } else {
                this.out.print("--- actCoeffs() returns NOT OK. Iter nbr." + this.iterc);
            }
            this.out.println(", tol=" + (float)this.c.tolLogF + ", I=" + (float)this.factor.ionicStrengthCalc + ", el.bal.=" + (float)this.factor.electricBalance);
        }
        return ok;
    }

    private void prnt() {
        this.printArrays(false, true);
        this.out.println("  y=" + this.y + ", y0=" + this.y0);
    }

    private void printTooManyIterations(double w) {
        int kjj;
        int jjj;
        int ijj;
        int nP;
        int iPl;
        int nM;
        int n0;
        this.out.flush();
        if (this.iter[this.ivar] == 40) {
            this.out.println("Error: too many iterations with ivar = " + this.ivar);
            this.out.println("Component nbrs. in the order they are iterated (starting with zero):");
            this.printArrays(true, false);
            n0 = 0;
            nM = this.cs.Na - 1;
            iPl = 5;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("tot[]= ");
                block0: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %15.7g", this.c.tot[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block0;
                    }
                    this.out.println();
                    this.out.print("       ");
                }
            }
            n0 = 0;
            nM = this.nIon + this.cs.mSol - 1;
            iPl = 5;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("C[]= ");
                block2: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %15.7g", this.c.C[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block2;
                    }
                    this.out.println();
                    this.out.print("     ");
                }
            }
            this.out.flush();
        }
        this.out.println("Component: " + this.ivar + ", iteration: " + this.iter[this.ivar]);
        this.printArrays(false, true);
        n0 = 0;
        nM = this.cs.Na - 1;
        iPl = 5;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("  ln f[]=");
            block4: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %15.7g", this.lnG[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block4;
                }
                this.out.println();
                this.out.print("         ");
            }
        }
        if (this.iter[this.ivar] > 40) {
            n0 = 0;
            nM = this.nIon + this.cs.mSol - 1;
            iPl = 5;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("  C[]= ");
                block6: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %15.7g", this.c.C[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block6;
                    }
                    this.out.println();
                    this.out.print("       ");
                }
            }
        }
        if (this.nfall == 0) {
            this.out.format("  Tot(calc) = %17.9g, Tot(input) = %17.9g%n", this.y, this.y0);
            if (!this.mono[this.ivar]) {
                this.out.format(this.e, "  low LnA= %23.16g, high LnA= %23.16g%n  low Tot(calc)= %17.9g, high Tot(calc)= %17.9g%n", this.x1[this.ivar], this.x2[this.ivar], this.y1[this.ivar], this.y2[this.ivar]);
            }
        } else {
            this.out.println("Nbr. solids: " + this.nfall + ",  error in tot.conc. = " + w);
            this.out.format(this.e, "  low LnA= %23.16g, high LnA= %23.16g%n  low Tot(calc)= %17.9g, high Tot(calc)= %17.9g%n", this.x1[this.ivar], this.x2[this.ivar], this.y1[this.ivar], this.y2[this.ivar]);
        }
        this.out.flush();
    }

    private void printLnG(int printDiffs) {
        this.out.flush();
        if (this.cs.jWater >= 0) {
            this.out.format(this.e, "lnA[H2O]= %10.6f%n", this.lnA[this.cs.jWater]);
        }
        int n0 = 0;
        int nM = this.nIon - 1;
        int iPl = 7;
        int nP = nM - n0;
        if (nP >= 0) {
            int kjj;
            int jjj;
            int ijj;
            if (printDiffs == 0) {
                this.out.print("    C[]=");
                block0: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %10.2g", this.c.C[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block0;
                    }
                    this.out.println();
                    this.out.print("        ");
                }
            }
            this.out.print("  lnG[]=");
            block2: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %10.6f", this.lnG[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block2;
                }
                this.out.println();
                this.out.print("        ");
            }
            if (printDiffs == 1) {
                return;
            }
            this.out.print("diffs[]=");
            block4: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %10.6f", Math.abs(this.oldLnG[kjj] - this.lnG[kjj]));
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block4;
                }
                this.out.println();
                this.out.print("        ");
            }
            this.out.println("tolerance = " + (float)this.c.tolLogF + ", I = " + (float)this.factor.ionicStrengthCalc + ", electric balance = " + (float)this.factor.electricBalance);
        }
    }

    private void printArrays(boolean print_iva, boolean print_lnA) {
        int kjj;
        int jjj;
        int ijj;
        int nP;
        int iPl;
        int nM;
        int n0;
        this.out.flush();
        if (print_iva) {
            n0 = 0;
            nM = this.nva - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("  iva[]=");
                block0: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %3d", this.iva[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block0;
                    }
                    this.out.println();
                    this.out.print("        ");
                }
            }
            n0 = 0;
            nM = this.nva - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("ivaBra[]=");
                block2: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %3d", this.ivaBra[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block2;
                    }
                    this.out.println();
                    this.out.print("         ");
                }
            }
            n0 = 0;
            nM = this.nva - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("ivaNov[]=");
                block4: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %3d", this.ivaNov[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block4;
                    }
                    this.out.println();
                    this.out.print("         ");
                }
            }
        }
        if (print_lnA) {
            n0 = 0;
            nM = this.cs.Na - 1;
            iPl = 7;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("  lnA[]=");
                block6: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %10.6f", this.lnA[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block6;
                    }
                    this.out.println();
                    this.out.print("        ");
                }
            }
        }
        this.out.flush();
    }

    private void printInput() {
        int kjj;
        int jjj;
        int ijj;
        this.out.flush();
        this.out.println("--- HaltaFall - input data:");
        this.cs.printChemSystem(this.out);
        this.out.println("components: kh=");
        int n0 = 0;
        int nM = this.cs.Na - 1;
        int iPl = 12;
        int nP = nM - n0;
        if (nP >= 0) {
            this.out.print("    ");
            block0: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %5d", this.c.kh[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block0;
                }
                this.out.println();
                this.out.print("    ");
            }
        }
        this.out.println("components: tot=");
        n0 = 0;
        nM = this.cs.Na - 1;
        iPl = 7;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("    ");
            block2: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %10.2g", this.c.tot[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block2;
                }
                this.out.println();
                this.out.print("    ");
            }
        }
        this.out.println("components: loga=");
        n0 = 0;
        nM = this.cs.Na - 1;
        iPl = 7;
        nP = nM - n0;
        if (nP >= 0) {
            this.out.print("    ");
            block4: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                for (jjj = 0; jjj < iPl; ++jjj) {
                    kjj = n0 + (ijj * iPl + jjj);
                    this.out.format(this.e, " %10.2f", this.c.logA[kjj]);
                    if (kjj <= nM - 1) continue;
                    this.out.println();
                    break block4;
                }
                this.out.println();
                this.out.print("    ");
            }
        }
        this.out.println("components: tol=" + (float)this.c.tol);
        this.out.println("--- HaltaFall - end of input data.");
        this.out.flush();
    }

    private void printArraysFasta(boolean _ifall, boolean _iber, boolean _fall, boolean _fallA, boolean _ber, boolean _ivaf, boolean _ifSpar, boolean _fut) {
        int kjj;
        int jjj;
        int ijj;
        int nP;
        int iPl;
        int nM;
        int n0;
        this.out.flush();
        if (_ifall) {
            n0 = 0;
            nM = this.nfall - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("  ifall[]=");
                block0: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %3d", this.ifall[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block0;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (_iber) {
            n0 = 0;
            nM = this.nfall - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("   iber[]=");
                block2: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %3d", this.iber[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block2;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (_fall) {
            n0 = 0;
            nM = this.cs.mSol - 1;
            iPl = 25;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("   fall[]=");
                block4: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %1b", this.fall[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block4;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (_fallA) {
            n0 = 0;
            nM = this.cs.Na - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("  fallA[]=");
                block6: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, "   %1b", this.fallA[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block6;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (_ber) {
            n0 = 0;
            nM = this.cs.Na - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("    ber[]=");
                block8: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, "   %1b", this.ber[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block8;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (_ivaf) {
            n0 = 0;
            nM = this.nvaf - 1;
            iPl = 20;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("   ivaf[]=");
                block10: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(this.e, " %3d", this.ivaf[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block10;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (_ifSpar) {
            n0 = 0;
            nM = this.nfSpar - 1;
            iPl = 15;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print(" ifSpar[]=");
                block12: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(" %4d", this.ifSpar[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block12;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        if (_fut) {
            n0 = 0;
            nM = this.nUt - 1;
            iPl = 15;
            nP = nM - n0;
            if (nP >= 0) {
                this.out.print("    fut[]=");
                block14: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (jjj = 0; jjj < iPl; ++jjj) {
                        kjj = n0 + (ijj * iPl + jjj);
                        this.out.format(" %4d", this.fut[kjj]);
                        if (kjj <= nM - 1) continue;
                        this.out.println();
                        break block14;
                    }
                    this.out.println();
                    this.out.print("          ");
                }
            }
        }
        this.out.flush();
    }

    static {
        ln10 = Math.log(10.0);
        nl = System.getProperty("line.separator");
    }

    private class TooManyIterationsException
    extends Exception {
        public TooManyIterationsException() {
        }

        public TooManyIterationsException(String txt) {
            super(txt);
        }
    }
}

