/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.haltaFall;

import java.io.File;
import java.io.PrintStream;
import java.util.Locale;
import lib.common.Util;
import lib.kemi.chem.Chem;
import lib.kemi.interpolate.Interpolate;
import lib.kemi.readDataLib.ReadDataLib;

public class Factor {
    public double osmoticCoeff = Double.NaN;
    public double log10aH2O = Double.NaN;
    public double ionicStrengthCalc;
    public double electricBalance = Double.NaN;
    private boolean begin = true;
    private boolean dataNotSupplied = true;
    private PrintStream out;
    private Chem c;
    private Chem.ChemSystem cs;
    private Chem.Diagr diag;
    private Chem.ChemSystem.NamesEtc namn;
    private SITeps eps;
    private String[] pathToSITdataFile = new String[3];
    private final String SIT_FILE = "SIT-coefficients.dta";
    private int nIon = -1;
    private boolean[] gas;
    private float lastTemperature = Float.MAX_VALUE;
    private double ionicStr;
    private double rootI = 0.0;
    private double Agamma = 0.0;
    private double Bgamma = 0.0;
    private double bgi = 0.0;
    private double rB = 0.0;
    private final double DAVIES = 0.2;
    private double sumM;
    private double summPrd;
    private double phiDH;
    private static final double molH2Oin1kg = 55.508435061791985;
    private static final double ln10 = 2.302585092994046;
    private static final String dashLine = "- - - - - - - - - - - - - - - - - - -";
    private static final String nl = System.getProperty("line.separator");
    private static final Locale engl = Locale.ENGLISH;

    public Factor() {
        this.out = System.out;
        this.dataNotSupplied = true;
    }

    public Factor(Chem c) {
        this.out = System.out;
        this.beginFactor(c, null, null, null);
    }

    public Factor(Chem c, String path1, String path2, String path3, PrintStream out0) {
        this.out = out0 != null ? out0 : System.out;
        this.beginFactor(c, path1, path2, path3);
    }

    private void beginFactor(Chem c, String path1, String path2, String path3) {
        this.dataNotSupplied = false;
        if (c != null) {
            this.c = c;
            this.cs = c.chemSystem;
            this.nIon = this.cs.Na + this.cs.nx;
            this.namn = this.cs.namn;
            this.gas = new boolean[this.nIon];
            this.diag = c.diag;
        }
        this.pathToSITdataFile[0] = path1;
        this.pathToSITdataFile[1] = path2;
        this.pathToSITdataFile[2] = path3;
    }

    public void factor(double[] C, double[] lnf) throws SITdataException, Interpolate.RationalInterpolationException {
        boolean tChanged;
        if (this.begin) {
            this.begin = false;
            int nlnf = lnf.length;
            if (nlnf <= 0) {
                throw new SITdataException("Error in \"haltaFall.Factor\": lnf.length must be > 0.");
            }
            if (this.dataNotSupplied || this.diag.activityCoeffsModel < 0) {
                for (int i = 0; i < nlnf; ++i) {
                    lnf[i] = 0.0;
                }
                return;
            }
            if (this.nIon <= 0 || C.length <= 0 || this.namn.z.length <= 0) {
                throw new SITdataException("Error in \"haltaFall.Factor\": nIon=" + this.nIon + " C.length=" + C.length + " z.length=" + this.namn.z.length + nl + ";  all must be >0");
            }
            if (nlnf < this.nIon || C.length < this.nIon) {
                throw new SITdataException("Error in \"haltaFall.Factor\": lnf.length=" + nlnf + ", C.length=" + C.length + ", must be <=" + this.nIon + " = Na + Nx; Na=" + this.cs.Na + ", Nx=" + this.cs.nx);
            }
            if (this.namn.z.length < this.nIon) {
                throw new SITdataException("Error in \"haltaFall.Factor\":  z.length=" + this.namn.z.length + nl + "  must be >=" + this.nIon + " (nIon)");
            }
            for (int i = 0; i < this.nIon; ++i) {
                this.gas[i] = false;
                if (this.cs.noll[i]) {
                    this.gas[i] = true;
                    continue;
                }
                if (this.namn.z[i] != 0 || !Factor.isGasOrLiquid(this.namn.ident[i])) continue;
                this.gas[i] = true;
            }
            this.ionicStr = Double.MAX_VALUE;
            if (this.diag.ionicStrength == Double.MAX_VALUE) {
                this.ionicStr = Double.NEGATIVE_INFINITY;
            }
        }
        if (this.dataNotSupplied || this.diag.activityCoeffsModel < 0) {
            for (int i = 0; i < lnf.length; ++i) {
                lnf[i] = 0.0;
            }
            return;
        }
        if (Double.isNaN(this.diag.temperature) || this.diag.temperature < 0.0 || this.diag.temperature > 350.0) {
            throw new SITdataException("Error in \"haltaFall.Factor\":  diag.temperature=" + (float)this.diag.temperature + nl + "  must be >=0 and <=350 C.");
        }
        boolean iChanged = false;
        if (Double.isNaN(this.diag.ionicStrength) || Math.abs(this.ionicStr - this.diag.ionicStrength) > 1.0E-10) {
            iChanged = true;
        }
        if (iChanged) {
            if (Double.isNaN(this.diag.ionicStrength)) {
                this.ionicStr = 0.0;
            } else {
                this.ionicStr = Math.min(this.diag.ionicStrength, 1000.0);
                if (this.ionicStr < 0.0) {
                    this.ionicStr = -1.0;
                }
            }
        }
        boolean bl = tChanged = (double)Math.abs(this.lastTemperature - (float)this.diag.temperature) > 0.1;
        if (tChanged) {
            this.Agamma = this.Ag((float)this.diag.temperature);
        }
        this.calcIonicStr(C, this.namn.z);
        if (this.ionicStr < 0.0) {
            this.ionicStr = this.ionicStrengthCalc;
        }
        this.rootI = 0.0;
        if (this.ionicStr > 0.0) {
            this.rootI = Math.sqrt(this.ionicStr);
        }
        if (this.diag.activityCoeffsModel == 0 && (tChanged || iChanged)) {
            this.calcDavies(lnf, this.namn.z);
        }
        if (this.diag.activityCoeffsModel == 1) {
            if (tChanged) {
                this.Bgamma = 4.56899 * (double)this.Bg((float)this.diag.temperature);
            }
            this.calcSIT(C, lnf, this.namn.z);
        }
        if (this.diag.activityCoeffsModel == 2 && (tChanged || iChanged)) {
            if (tChanged) {
                this.bgi = this.bgNaCl((float)this.diag.temperature);
                this.rB = (double)this.Bg((float)this.diag.temperature) * (1.81 + (0.97 + (0.94 + (double)this.gT((float)this.diag.temperature))));
            }
            this.calcHKF(lnf, this.namn.z);
        }
        this.lastTemperature = (float)this.diag.temperature;
    }

    private void calcDavies(double[] lnf, int[] z) {
        if (this.ionicStr <= 0.0) {
            return;
        }
        double w = -this.Agamma * (this.rootI / (1.0 + this.rootI) - 0.2 * this.ionicStr);
        for (int i = 0; i < lnf.length; ++i) {
            if (!this.gas[i]) {
                if (z[i] != 0) {
                    int zz = z[i] * z[i];
                    double logf = (double)zz * w;
                    logf = Math.max(-1.9999 * (double)zz, Math.min(logf, 1.9999 * (double)zz));
                    lnf[i] = 2.302585092994046 * logf;
                    continue;
                }
                lnf[i] = 0.0;
                continue;
            }
            lnf[i] = 0.0;
        }
        if (this.cs.jWater < 0) {
            return;
        }
        this.phiDH = 1.5350567286626973 * this.Agamma * this.ionicStr * this.rootI * this.sigma(this.rootI);
        this.osmoticCoeff = 1.0;
        if (this.sumM > 1.0E-15) {
            this.osmoticCoeff = 1.0 - this.phiDH / this.sumM + 2.302585092994046 * this.Agamma * 0.2 * Math.pow(this.ionicStr, 2.0) / this.sumM;
        }
        this.log10aH2O = Math.max(-2.9999, Math.min(1.9999, -this.osmoticCoeff * this.sumM / 127.81289510871025));
        lnf[this.cs.jWater] = 2.302585092994046 * this.log10aH2O;
    }

    private void calcHKF(double[] lnf, int[] z) {
        if (this.ionicStr <= 0.0) {
            return;
        }
        if (!Double.isNaN(this.diag.ionicStrength) && this.diag.ionicStrength > 0.0) {
            this.sumM = this.ionicStr;
        }
        double w = -this.Agamma * (this.rootI / (1.0 + this.rB * this.rootI));
        double gamma = Math.log10(1.0 + 0.0180153 * this.ionicStr);
        for (int i = 0; i < lnf.length; ++i) {
            if (!this.gas[i]) {
                double logf = 0.0;
                if (z[i] != 0) {
                    int zz = z[i] * z[i];
                    logf = (double)zz * w - gamma + this.bgi * this.ionicStr;
                    logf = Math.max(-2.9999 * (double)zz, Math.min(logf, 2.9999 * (double)zz));
                }
                lnf[i] = 2.302585092994046 * logf;
                continue;
            }
            lnf[i] = 0.0;
        }
        if (this.cs.jWater < 0) {
            return;
        }
        this.phiDH = 1.5350567286626973 * this.Agamma * this.ionicStr * this.rootI * this.sigma(this.rB * this.rootI);
        this.osmoticCoeff = 1.0;
        if (this.sumM > 1.0E-15) {
            this.osmoticCoeff = 2.302585092994046 * gamma / (0.0180153 * this.ionicStr) - this.phiDH / this.ionicStr + 2.302585092994046 * this.bgi * 0.5 * this.ionicStr;
        }
        this.log10aH2O = Math.max(-2.9999, Math.min(1.9999, -this.osmoticCoeff * this.ionicStr / 127.81289510871025));
        lnf[this.cs.jWater] = 2.302585092994046 * this.log10aH2O;
    }

    private void calcSIT(double[] C, double[] lnf, int[] z) throws SITdataException {
        int i;
        double Ci;
        float \u03b5;
        try {
            this.readSITdataFiles();
        }
        catch (ReadDataLib.ReadDataLibException ex) {
            throw new SITdataException("ReadDataLib.ReadDataLibException: " + ex.getMessage());
        }
        if (this.ionicStr <= 0.0) {
            return;
        }
        double MAX_CONC = 100.0;
        double elBal = Math.abs(this.electricBalance);
        double DH = -this.Agamma * this.rootI / (1.0 + this.Bgamma * this.rootI);
        for (int i2 = 0; i2 < this.nIon; ++i2) {
            if (this.gas[i2]) {
                lnf[i2] = 0.0;
                continue;
            }
            double sumEpsM = 0.0;
            if (z[i2] == 0) {
                \u03b5 = this.getEpsilon(i2, i2);
                Ci = Math.max(0.0, Math.min(100.0, C[i2]));
                sumEpsM = (double)\u03b5 * Ci;
            } else if (elBal > 1.0E-10) {
                \u03b5 = 0.0f;
                if (this.electricBalance < -1.0E-10) {
                    \u03b5 = this.getEpsilon(this.nIon, i2);
                } else if (this.electricBalance > -1.0E-10) {
                    \u03b5 = this.getEpsilon(this.nIon + 1, i2);
                }
                sumEpsM += (double)\u03b5 * Math.max(0.0, Math.min(50.0, elBal));
            }
            for (int j = 0; j < this.nIon; ++j) {
                if (j == i2 || z[i2] * z[j] > 0) continue;
                \u03b5 = this.getEpsilon(i2, j);
                Ci = Math.max(0.0, Math.min(100.0, C[j]));
                sumEpsM += (double)\u03b5 * Ci;
            }
            int zz = z[i2] * z[i2];
            double logf = (double)zz * DH + sumEpsM;
            logf = Math.max(-1.9999 * (double)zz, Math.min(logf, 1.9999 * (double)zz));
            lnf[i2] = 2.302585092994046 * logf;
        }
        if (this.cs.jWater < 0) {
            return;
        }
        this.osmoticCoeff = 1.0;
        this.phiDH = 1.5350567286626973 * this.Agamma * this.ionicStr * this.rootI * this.sigma(this.Bgamma * this.rootI);
        this.summPrd = 0.0;
        for (i = 0; i < this.nIon; ++i) {
            int j;
            if (this.gas[i]) continue;
            Ci = Math.max(0.0, Math.min(100.0, C[i]));
            double summPrd_i = 0.0;
            if (z[i] < 0) continue;
            if (z[i] == 0) {
                for (j = 0; j < this.nIon; ++j) {
                    double Cj = Math.max(0.0, Math.min(100.0, C[j]));
                    if (z[j] == 0) {
                        \u03b5 = this.getEpsilon(i, i);
                        summPrd_i += (double)\u03b5 * Ci * Cj / 2.0;
                        continue;
                    }
                    \u03b5 = this.getEpsilon(i, j);
                    summPrd_i += (double)\u03b5 * Ci * Cj;
                }
                if (elBal > 1.0E-10) {
                    \u03b5 = this.getEpsilon(i, this.nIon);
                    summPrd_i += (double)\u03b5 * Ci * elBal;
                }
            } else {
                for (j = 0; j < this.nIon; ++j) {
                    if (i == j || z[j] >= 0) continue;
                    double Cj = Math.max(0.0, Math.min(100.0, C[j]));
                    \u03b5 = this.getEpsilon(i, j);
                    summPrd_i += (double)\u03b5 * Ci * Cj;
                }
                if (this.electricBalance > 1.0E-10) {
                    \u03b5 = this.getEpsilon(i, this.nIon + 1);
                    summPrd_i += (double)\u03b5 * Ci * this.electricBalance;
                }
            }
            this.summPrd += summPrd_i;
        }
        if (this.electricBalance < -1.0E-10) {
            for (i = 0; i < this.nIon; ++i) {
                if (z[i] >= 0 || this.gas[i]) continue;
                \u03b5 = this.getEpsilon(i, this.nIon);
                Ci = Math.max(0.0, Math.min(100.0, C[i]));
                this.summPrd -= (double)\u03b5 * this.electricBalance * Ci;
            }
        }
        if (this.sumM > 1.0E-15) {
            this.osmoticCoeff = 1.0 - this.phiDH / this.sumM + 2.302585092994046 * this.summPrd / this.sumM;
        }
        this.log10aH2O = Math.max(-2.9999, Math.min(1.9999, -this.osmoticCoeff * this.sumM / 127.81289510871025));
        lnf[this.cs.jWater] = 2.302585092994046 * this.log10aH2O;
    }

    private double sigma(double x) {
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x < 1.0E-10) {
            return 1.0;
        }
        return 3.0 / Math.pow(x, 3.0) * (1.0 + x - 2.0 * Math.log(1.0 + x) - 1.0 / (1.0 + x));
    }

    private void readSITdataFiles() throws SITdataException, ReadDataLib.ReadDataLibException {
        if (this.eps == null) {
            this.eps = new SITeps(this.nIon);
        }
        if (!Float.isNaN(this.eps.eps0[0][0])) {
            return;
        }
        for (int i = 0; i < this.nIon + 2; ++i) {
            int j;
            for (j = 0; j < i + 1; ++j) {
                this.setEpsilon(i, j, 0.0f, 0.0f, 0.0f);
            }
            if ((i >= this.nIon || this.gas[i]) && i < this.nIon) continue;
            for (j = 0; j < i + 1; ++j) {
                float w;
                int k;
                if (this.namn.z[i] * this.namn.z[j] >= 0) continue;
                if (this.namn.z[i] * this.namn.z[j] < -1 && (this.namn.z[i] == 1 || this.namn.z[j] == 1)) {
                    k = this.namn.z[j] < 0 ? j : i;
                    w = 0.0500001f * (float)this.namn.z[k];
                } else {
                    k = this.namn.z[i] > 0 ? i : j;
                    w = -0.05000001f + 0.1f * (float)this.namn.z[k];
                }
                this.setEpsilon(i, j, w, 0.0f, 0.0f);
            }
        }
        String identClO4 = "ClO4";
        String identCl = "Cl";
        String identNa = "Na";
        for (int i = 0; i < this.nIon + 2; ++i) {
            boolean Na1;
            boolean Cl1;
            boolean ClO41;
            if (i < this.nIon && this.gas[i]) continue;
            if (i < this.nIon) {
                String species1 = Util.nameOf(this.namn.ident[i]);
                if (species1.equals("ClO4") && this.namn.z[i] == -1) {
                    ClO41 = true;
                    Cl1 = false;
                    Na1 = false;
                } else if (species1.equals("Cl") && this.namn.z[i] == -1) {
                    ClO41 = false;
                    Cl1 = true;
                    Na1 = false;
                } else if (species1.equals("Na") && this.namn.z[i] == 1) {
                    ClO41 = false;
                    Cl1 = false;
                    Na1 = true;
                } else {
                    ClO41 = false;
                    Cl1 = false;
                    Na1 = false;
                }
            } else if (i == this.nIon) {
                ClO41 = false;
                Cl1 = false;
                Na1 = true;
            } else if (i == this.nIon + 1) {
                ClO41 = false;
                Cl1 = true;
                Na1 = false;
            } else {
                ClO41 = false;
                Cl1 = false;
                Na1 = false;
            }
            for (int j = 0; j < i + 1; ++j) {
                boolean Na2;
                boolean Cl2;
                boolean ClO42;
                if (this.namn.z[i] * this.namn.z[j] >= 0) continue;
                if (j < this.nIon) {
                    String species2 = Util.nameOf(this.namn.ident[j]);
                    if (species2.equals("ClO4") && this.namn.z[j] == -1) {
                        ClO42 = true;
                        Cl2 = false;
                        Na2 = false;
                    } else if (species2.equals("Cl") && this.namn.z[j] == -1) {
                        ClO42 = false;
                        Cl2 = true;
                        Na2 = false;
                    } else if (species2.equals("Na") && this.namn.z[j] == 1) {
                        ClO42 = false;
                        Cl2 = false;
                        Na2 = true;
                    } else {
                        ClO42 = false;
                        Cl2 = false;
                        Na2 = false;
                    }
                } else if (j == this.nIon) {
                    ClO42 = false;
                    Cl2 = false;
                    Na2 = true;
                } else if (j == this.nIon + 1) {
                    ClO42 = false;
                    Cl2 = true;
                    Na2 = false;
                } else {
                    ClO42 = false;
                    Cl2 = false;
                    Na2 = false;
                }
                if (ClO41) {
                    this.setEpsilon(i, j, 0.2f * (float)this.namn.z[j], 0.0f, 0.0f);
                    continue;
                }
                if (ClO42) {
                    this.setEpsilon(i, j, 0.2f * (float)this.namn.z[i], 0.0f, 0.0f);
                    continue;
                }
                if (Cl1) {
                    this.setEpsilon(i, j, 0.1f * (float)this.namn.z[j] - 0.05f, 0.0f, 0.0f);
                    continue;
                }
                if (Cl2) {
                    this.setEpsilon(i, j, 0.1f * (float)this.namn.z[i] - 0.05f, 0.0f, 0.0f);
                    continue;
                }
                if (Na1) {
                    this.setEpsilon(i, j, 0.05f * (float)this.namn.z[j], 0.0f, 0.0f);
                    continue;
                }
                if (!Na2) continue;
                this.setEpsilon(i, j, 0.05f * (float)this.namn.z[i], 0.0f, 0.0f);
            }
        }
        boolean someFile = false;
        for (String pathToSITdataFile1 : this.pathToSITdataFile) {
            ReadDataLib rd;
            if (pathToSITdataFile1 == null) continue;
            File pathToSITfile = new File(pathToSITdataFile1);
            if (!pathToSITfile.exists() || !pathToSITfile.isDirectory()) {
                this.out.println(nl + "Error in \"haltaFall.Factor.readSITdataFile\":" + nl + "   path = \"" + pathToSITfile.getPath() + "\"" + nl + "   either does not exist or is not a directory.");
                continue;
            }
            File SITdata = new File(pathToSITdataFile1 + File.separator + "SIT-coefficients.dta");
            try {
                rd = new ReadDataLib(SITdata);
            }
            catch (ReadDataLib.DataFileException ex) {
                this.out.println("Note - SIT file NOT found: \"" + SITdata + "\"");
                continue;
            }
            someFile = true;
            this.out.println("Reading SIT data from \"" + SITdata + "\"");
            try {
                this.readSITfileSection(1, rd);
            }
            catch (SITdataException ex) {
                this.out.println(ex.getMessage() + nl + "Skipping the rest of file \"" + "SIT-coefficients.dta" + "\".");
                continue;
            }
            catch (ReadDataLib.DataEofException ex) {
                this.out.println(ex.getMessage() + " in file \"" + "SIT-coefficients.dta" + "\".");
                continue;
            }
            catch (ReadDataLib.DataReadException ex) {
                this.out.println(ex.getMessage() + nl + "Skipping the rest of file \"" + "SIT-coefficients.dta" + "\".");
                continue;
            }
            try {
                this.readSITfileSection(2, rd);
            }
            catch (ReadDataLib.DataEofException ex) {
                this.out.println(ex.getMessage() + " in file \"" + "SIT-coefficients.dta" + "\".");
                continue;
            }
            catch (ReadDataLib.DataReadException ex) {
                this.out.println(ex.getMessage() + nl + "Skipping the rest of file \"" + "SIT-coefficients.dta" + "\".");
                continue;
            }
            try {
                this.readSITfileSection(3, rd);
            }
            catch (ReadDataLib.DataEofException ex) {
                this.out.println(ex.getMessage() + " in file \"" + "SIT-coefficients.dta" + "\".");
                continue;
            }
            catch (ReadDataLib.DataReadException ex) {
                this.out.println(ex.getMessage() + nl + "Skipping the rest of file \"" + "SIT-coefficients.dta" + "\".");
                continue;
            }
            rd.close();
        }
        if (!someFile) {
            this.out.println("No SIT data file found. Default epsilon values are used.");
        } else {
            this.out.println("Finished reading SIT data.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSITfileSection(int section, ReadDataLib rd) throws SITdataException, ReadDataLib.DataReadException, ReadDataLib.DataEofException {
        if (section < 1 || section > 3) {
            throw new SITdataException("Error in \"haltaFall.Factor.readSITfileSection\": section = " + section + " (must be 1,2 or 3).");
        }
        if (rd == null) {
            throw new SITdataException("Error in \"haltaFall.Factor.readSITfileSection\": instance of ReadDataLib is \"null\"");
        }
        zAn = 0;
        identNa = "Na";
        identCl = "Cl";
        anion = "";
        identAnion = "";
        block0: while (true) {
            rd.nowReading = "Cation name";
            if (section > 1) {
                rd.nowReading = "Neutral species name";
            }
            if ((cation = rd.readA()).equalsIgnoreCase("END")) break;
            zCat = Util.chargeOf(cation);
            if (section < 2 && zCat <= 0) {
                throw new SITdataException("Error reading file \"SIT-coefficients.dta\":" + Factor.nl + "   Trying to read a cation name, found: \"" + cation + "\"" + Factor.nl + "   but the charge is: " + zCat + " (must be >0)");
            }
            if (section >= 2 && zCat != 0) {
                throw new SITdataException("Error reading file \"SIT-coefficients.dta\":" + Factor.nl + "   Trying to read a neutral species name, found: \"" + cation + "\"" + Factor.nl + "   but the charge is: " + zCat + " (must be zero)");
            }
            identCation = Util.nameOf(cation);
            if (section == 1) {
                rd.nowReading = "Anion name";
                anion = rd.readA();
                zAn = Util.chargeOf(anion);
                if (zAn >= 0) {
                    throw new SITdataException("Error reading file \"SIT-coefficients.dta\":" + Factor.nl + "   Trying to read an anion name, found: \"" + anion + "\"" + Factor.nl + "   but the charge is: " + zAn + " (must be <0)");
                }
                identAnion = Util.nameOf(anion);
            }
            if (section == 1) {
                rd.nowReading = "SIT interaction coefficient eps0[" + cation + "," + anion + "]";
                w0 = rd.readR();
                if (Math.abs(w0) >= 10.0f) {
                    throw new SITdataException("Error reading file \"SIT-coefficients.dta\":" + Factor.nl + "   Trying to read the SIT coefficient eps0[" + cation + "," + anion + "]" + Factor.nl + "   but the value is: " + w0 + " (must be between <10 and >-10)");
                }
                rd.nowReading = "SIT interaction coefficient eps1[" + cation + "," + anion + "]";
                w1 = rd.readR();
                rd.nowReading = "SIT interaction coefficient eps2[" + cation + "," + anion + "]";
                w2 = rd.readR();
                block1: for (i = 0; i < this.nIon; ++i) {
                    if (this.gas[i]) continue;
                    identI = Util.nameOf(this.namn.ident[i]);
                    if (this.namn.z[i] < 0) {
                        if (!identI.equalsIgnoreCase(identAnion) || this.namn.z[i] != zAn || !identCation.equalsIgnoreCase(identNa) || zCat != 1) continue;
                        this.setEpsilon(this.nIon, i, w0, w1, w2);
                        continue;
                    }
                    if (!identI.equalsIgnoreCase(identCation) || this.namn.z[i] != zCat) continue;
                    if (identAnion.equalsIgnoreCase(identCl) && zAn == -1) {
                        this.setEpsilon(this.nIon + 1, i, w0, w1, w2);
                    }
                    for (i2 = 0; i2 < this.nIon; ++i2) {
                        if (this.gas[i] || !(identI2 = Util.nameOf(this.namn.ident[i2])).equalsIgnoreCase(identAnion) || this.namn.z[i2] != zAn) continue;
                        this.setEpsilon(i, i2, w0, w1, w2);
                        break block1;
                    }
                }
                if (!identCation.equalsIgnoreCase(identNa) || zCat != 1 || !identAnion.equalsIgnoreCase(identCl) || zAn != -1) continue;
                this.setEpsilon(this.nIon, this.nIon + 1, w0, w1, w2);
                continue;
            }
            if (section == 2) {
                rd.nowReading = "SIT interaction coefficient eps0[" + cation + ",MX]";
                w0 = rd.readR();
                if (Math.abs(w0) >= 10.0f) {
                    throw new SITdataException("Error reading file \"SIT-coefficients.dta\":" + Factor.nl + "   Trying to read the SIT coefficient eps[" + cation + ",MX]" + Factor.nl + "   but the value is: " + w0 + " (must be between <10 and >-10)");
                }
                rd.nowReading = "SIT interaction coefficient eps1[" + cation + ",MX]";
                w1 = rd.readR();
                rd.nowReading = "SIT interaction coefficient eps2[" + cation + ",MX]";
                w2 = rd.readR();
                i = 0;
                while (true) {
                    if (i >= this.nIon) continue block0;
                    if (!this.cs.noll[i] && this.namn.z[i] == 0 && (identI = Util.nameOf(this.namn.ident[i])).equalsIgnoreCase(identCation)) {
                        for (i2 = 0; i2 < this.nIon; ++i2) {
                            if (this.cs.noll[i2] || this.namn.z[i2] == 0) continue;
                            this.setEpsilon(i, i2, w0, w1, w2);
                        }
                        this.setEpsilon(i, this.nIon, w0, w1, w2);
                        this.setEpsilon(i, this.nIon + 1, w0, w1, w2);
                    }
                    ++i;
                }
            }
            if (section != 3) continue;
            rd.nowReading = "SIT interaction coefficient eps[" + cation + ",neutral]";
            w0 = rd.readR();
            if (Math.abs(w0) >= 10.0f) {
                throw new SITdataException("Error reading file \"SIT-coefficients.dta\":" + Factor.nl + "   Trying to read the SIT coefficient eps[" + cation + ",neutral]" + Factor.nl + "   but the value is: " + w0 + " (must be between <10 and >-10)");
            }
            rd.nowReading = "SIT interaction coefficient eps1[" + cation + ",MX]";
            w1 = rd.readR();
            rd.nowReading = "SIT interaction coefficient eps2[" + cation + ",MX]";
            w2 = rd.readR();
            i = 0;
            while (true) {
                if (i < this.nIon) ** break;
                continue block0;
                if (!this.cs.noll[i] && this.namn.z[i] == 0 && (identI = Util.nameOf(this.namn.ident[i])).equalsIgnoreCase(identCation)) {
                    this.setEpsilon(i, i, w0, w1, w2);
                }
                ++i;
            }
            break;
        }
    }

    private void printEpsilons(PrintStream out0) {
        int i;
        PrintStream o = out0 != null ? out0 : System.out;
        o.println("List of \"epsilon\" values:");
        o.print("            ");
        for (i = 0; i < this.nIon; ++i) {
            if (this.namn.ident[i].length() <= 10) {
                o.format("%-10s", this.namn.ident[i]);
                continue;
            }
            o.format("%-10s", this.namn.ident[i].substring(0, 10));
        }
        o.format("%-10s%-10s%s", "Na+", "Cl-", nl);
        for (i = 0; i < this.nIon + 2; ++i) {
            if (i < this.nIon) {
                if (this.namn.ident[i].length() <= 10) {
                    o.format("%-10s", this.namn.ident[i]);
                } else {
                    o.format("%-10s", this.namn.ident[i].substring(0, 10));
                }
            } else if (i == this.nIon) {
                o.format("%-10s", "Na+");
            } else if (i == this.nIon + 1) {
                o.format("%-10s", "Cl-");
            }
            for (int j = 0; j <= i; ++j) {
                o.format(engl, " %6.3f   ", Float.valueOf(this.getEpsilon(i, j)));
            }
            o.println();
        }
        o.println("Note that eps[i,j]=eps[j,i], and esp[i,j]=0 if z[i]*z[j]>0 (equal" + nl + "charge sign), and  eps[i,i] is used only if z[i]=0." + nl + "The last two rows/columns, Na+ and Cl-, are used only" + nl + "if the aqueous solution is not electrically neutral.");
    }

    private float getEpsilon(int row, int col) {
        int j;
        int i;
        if (row < 0 || col < 0) {
            return Float.NaN;
        }
        if (row > col) {
            i = row;
            j = col;
        } else {
            i = col;
            j = row;
        }
        float epsilon = this.eps.eps0[i][j];
        float tKelvin = (float)(this.diag.temperature + 273.15);
        if (this.eps.eps1[i][j] != 0.0f) {
            epsilon += this.eps.eps1[i][j] * tKelvin;
        }
        if (this.eps.eps2[i][j] != 0.0f) {
            epsilon += this.eps.eps2[i][j] * tKelvin * tKelvin;
        }
        return epsilon;
    }

    private void setEpsilon(int row, int col, float val0, float val1, float val2) {
        if (row < 0 || col < 0) {
            return;
        }
        if (row > col) {
            this.eps.eps0[row][col] = val0;
            this.eps.eps1[row][col] = val1;
            this.eps.eps2[row][col] = val2;
        } else {
            this.eps.eps0[col][row] = val0;
            this.eps.eps1[col][row] = val1;
            this.eps.eps2[col][row] = val2;
        }
    }

    public void factorPrint(boolean verbose) throws Interpolate.RationalInterpolationException, SITdataException, ReadDataLib.ReadDataLibException {
        if (verbose) {
            this.out.println(dashLine);
        }
        if (this.dataNotSupplied || this.diag.activityCoeffsModel < 0) {
            if (verbose) {
                this.out.println("\"haltaFall.factor\" (activity coefficient calculations):" + nl + "    dataNotSupplied = " + this.dataNotSupplied + ", activityCoeffsModel = " + this.diag.activityCoeffsModel + nl + dashLine);
            } else {
                this.out.println("No activity coefficient calculations.");
            }
            return;
        }
        this.Agamma = this.Ag((float)this.diag.temperature);
        double iStr = 0.0;
        if (!Double.isNaN(this.diag.ionicStrength)) {
            iStr = this.diag.ionicStrength;
        }
        String sigma = "where sigma(x) = (3/x^3) {(1+x) - 1/(1+x) - 2 ln(1+x)}";
        if (this.diag.activityCoeffsModel == 0) {
            if (verbose) {
                String I = iStr < 0.0 ? "varied" : Double.toString(iStr);
                String At = String.format(engl, "%8.4f", this.Agamma).trim();
                String Dt = String.format(engl, "%8.2f", 0.2).trim();
                this.out.println("Calculation of activity coefficients with I = " + I + ";  t = " + this.diag.temperature + "\u00b0C" + nl + "using Davies eqn.:" + nl + "  log f(i) = -" + At + " Zi^2 ( I^0.5 /(1 + I^0.5) - " + Dt + " I)");
                if (this.cs.jWater >= 0) {
                    this.out.println("The activity of water is calculated according to" + nl + "  log(a(H2O)) = - phi Sum[m] /(ln(10) 55.508)" + nl + "the osmotic coefficient \"phi\" is calculated from:" + nl + "  phi = 1 - (2/3) (ln(10)/Sum[m]) " + At + " I^(3/2) sigma(I^0.5)" + nl + "              + (ln(10)/Sum[m]) (" + At + " x " + Dt + ") I^2" + nl + "where sigma(x) = (3/x^3) {(1+x) - 1/(1+x) - 2 ln(1+x)}" + ".");
                }
            } else {
                this.out.println("Davies eqn. for activity coefficient calculations.");
            }
        } else if (this.diag.activityCoeffsModel == 1) {
            String I;
            if (iStr < 0.0) {
                I = "varied";
                String S = "Sum[m]";
            } else {
                I = Double.toString(iStr);
                String S = "I";
            }
            this.Bgamma = 4.56899 * (double)this.Bg((float)this.diag.temperature);
            if (verbose) {
                String At = String.format(engl, "%8.4f", this.Agamma).trim();
                String Bt = String.format(engl, "%5.2f", this.Bgamma).trim();
                this.out.println("Calculation of activity coefficients with I = " + I + ",  and t = " + this.diag.temperature + "\u00b0C." + nl + "using the SIT model:" + nl + "  log f(i) = -(" + At + " Zi^2 I^0.5 / (1 + " + Bt + " I^0.5)) + Sum[ eps(i,j) m(j) ]" + nl + "for all \"j\" with Zj*Zi<=0;  where eps(i,j) is a specific ion interaction" + nl + "parameter (in general independent of I).");
                if (this.cs.jWater >= 0) {
                    this.out.println("The activity of water is calculated according to" + nl + "  log(a(H2O)) = - phi Sum[m] /(ln(10) 55.508)" + nl + "the osmotic coefficient \"phi\" is calculated from:" + nl + "  phi = 1 - (2/3) (ln(10)/Sum[m]) " + At + " I^(3/2) sigma(" + Bt + " I^0.5)" + nl + "          + (ln(10)/Sum[m]) Sum_i[ Sum_j[ eps(i,j) m(i) m(j) ]]" + nl + "where sigma(x) = (3/x^3) {(1+x) - 1/(1+x) - 2 ln(1+x)}" + ";" + nl + "and where \"i\" are cations or neutral species and \"j\" are anions.");
                }
            } else {
                this.out.println("SIT method for activity coefficient calculations.");
            }
            if (this.nIon > 0) {
                if (this.eps == null || Float.isNaN(this.eps.eps0[0][0])) {
                    this.readSITdataFiles();
                }
                if (verbose) {
                    this.printEpsilons(this.out);
                }
            }
        } else if (this.diag.activityCoeffsModel == 2) {
            String S;
            String I;
            if (iStr < 0.0) {
                I = "varied";
                S = "I";
            } else {
                I = Double.toString(iStr);
                S = "I) = " + -((float)Math.log10(1.0 + 0.0180153 * iStr));
            }
            this.bgi = this.bgNaCl((float)this.diag.temperature);
            this.rB = (double)this.Bg((float)this.diag.temperature) * (1.81 + (0.97 + (0.94 + (double)this.gT((float)this.diag.temperature))));
            if (verbose) {
                String At = String.format(engl, "%9.5f", this.Agamma).trim();
                String Bt = String.format(engl, "%6.3f", this.rB).trim();
                String bgit = String.format(engl, "%7.4f", this.bgi).trim();
                this.out.println("Calculation of activity coefficients with I = " + I + ";  t = " + this.diag.temperature + "\u00b0C" + nl + "using simplified Helgeson, Kirkham & Flowers model:" + nl + "  log f(i) = -(" + At + " Zi^2 I^0.5) / (1 + " + Bt + " I^0.5)) + Gamma + (" + bgit + " I)" + nl + "where: Gamma = -log(1+0.0180153 " + S + ")");
                if (this.cs.jWater >= 0) {
                    this.out.println("The activity of water is calculated according to" + nl + "  log(a(H2O)) = - phi Sum[m] /(ln(10) 55.508)" + nl + "the osmotic coefficient \"phi\" is calculated from:" + nl + "  phi = (ln(10) Gamma / (0.0180153 " + S + "))" + nl + "              - (2/3) (ln(10)/Sum[m]) " + At + " I^(3/2) sigma(" + Bt + " I^0.5)" + nl + "              + (ln(10) (1/2) " + bgit + " I)" + nl + "where sigma(x) = (3/x^3) {(1+x) - 1/(1+x) - 2 ln(1+x)}" + ".");
                }
            } else {
                this.out.println("\"HKF\" model for activity coefficient calculations.");
            }
        }
        if (verbose) {
            this.out.println(dashLine);
        }
    }

    public void printActivityCoeffs(PrintStream out0) {
        PrintStream o = out0 != null ? out0 : System.out;
        if (this.diag.activityCoeffsModel < 0 || this.diag.activityCoeffsModel > 2) {
            o.println("No activity coefficient calculations performed (ideal solutions).");
            return;
        }
        String t = "Activity coefficients calculated using ";
        if (this.diag.activityCoeffsModel == 0) {
            o.println(t + "Davies eqn.");
        } else if (this.diag.activityCoeffsModel == 1) {
            o.println(t + "SIT model.");
        } else if (this.diag.activityCoeffsModel == 2) {
            o.println(t + "the simplifyed HKF model.");
        }
        o.print("Calculated Ionic Strength = " + (float)this.ionicStrengthCalc);
        if (this.diag.ionicStrength > 0.0) {
            this.out.print(",  Ionic Strength used = " + (float)this.diag.ionicStrength);
        }
        o.println();
        o.format(engl, "Electrical balance: %-+14.6g%s", this.electricBalance, nl);
        o.println("Tolerance = " + (float)this.cs.chemConcs.tolLogF + " (when calculating log10 f).");
        o.println("List of calculated activity coefficients:" + nl + " nbr  species                  z    log10(f)   Conc.");
        for (int j = 0; j < this.nIon; ++j) {
            if (j == this.cs.jWater) {
                o.format(engl, "%4d   %-20s  a(H2O) =%7.4f  phi =%7.4f%s", j, this.namn.ident[j], Math.pow(10.0, this.cs.chemConcs.logA[j]), this.osmoticCoeff, nl);
                continue;
            }
            o.format(engl, "%4d   %-20s  %3d  %9.4f  %9.2g%s", j, this.namn.ident[j], this.namn.z[j], this.cs.chemConcs.logf[j], this.cs.chemConcs.C[j], nl);
        }
        o.format(engl, "Summ of concentrations, Sum[m] = %-14.6g%s", this.sumM, nl);
    }

    private void calcIonicStr(double[] C, int[] z) {
        this.ionicStrengthCalc = 0.0;
        this.sumM = 0.0;
        this.electricBalance = 0.0;
        for (int i = 0; i < this.nIon; ++i) {
            if (this.gas[i]) continue;
            double Ci = Math.max(0.0, Math.min(1.0E35, C[i]));
            this.sumM += Ci;
            if (z[i] == 0) continue;
            this.electricBalance += (double)z[i] * Ci;
            this.ionicStrengthCalc += (double)(z[i] * z[i]) * Ci;
        }
        this.ionicStrengthCalc = 0.5 * (Math.abs(this.electricBalance) + this.ionicStrengthCalc);
        this.sumM += Math.abs(this.electricBalance);
    }

    public static boolean isGasOrLiquid(String t0) {
        if (t0.length() > 3) {
            return t0.toUpperCase().endsWith("(G)") || t0.toUpperCase().endsWith("(L)");
        }
        return false;
    }

    private float Ag(float t) throws Interpolate.RationalInterpolationException {
        float[] temp = new float[]{0.0f, 5.0f, 10.0f, 15.0f, 20.0f, 25.0f, 30.0f, 35.0f, 40.0f, 45.0f, 50.0f, 55.0f, 60.0f, 65.0f, 70.0f, 75.0f, 80.0f, 85.0f, 90.0f, 95.0f, 100.0f, 105.0f, 110.0f, 115.0f, 120.0f, 125.0f, 130.0f, 135.0f, 140.0f, 145.0f, 150.0f, 155.0f, 160.0f, 165.0f, 170.0f, 175.0f, 180.0f, 185.0f, 190.0f, 195.0f, 200.0f, 210.0f, 220.0f, 225.0f, 230.0f, 240.0f, 250.0f, 260.0f, 270.0f, 275.0f, 280.0f, 290.0f, 300.0f, 325.0f, 350.0f};
        float[] A = new float[]{0.4913f, 0.4943f, 0.4976f, 0.5012f, 0.505f, 0.5092f, 0.5135f, 0.5182f, 0.5251f, 0.5282f, 0.5336f, 0.5392f, 0.545f, 0.5511f, 0.5574f, 0.5639f, 0.5706f, 0.5776f, 0.5848f, 0.5922f, 0.5998f, 0.6077f, 0.6158f, 0.6242f, 0.6328f, 0.6416f, 0.6507f, 0.6601f, 0.6697f, 0.6796f, 0.6898f, 0.7003f, 0.7111f, 0.7222f, 0.7336f, 0.7454f, 0.7575f, 0.77f, 0.7829f, 0.7962f, 0.8099f, 0.8387f, 0.8697f, 0.886f, 0.903f, 0.9391f, 0.9785f, 1.0218f, 1.0699f, 1.096f, 1.1238f, 1.185f, 1.2555f, 1.4943f, 1.9252f};
        if (t < 0.0f || t > 350.0f) {
            return Float.NaN;
        }
        float Ag = Interpolate.rationalInterpolation(temp, A, t);
        return Ag;
    }

    private float Bg(float t) throws Interpolate.RationalInterpolationException {
        float[] temp = new float[]{0.0f, 5.0f, 10.0f, 15.0f, 20.0f, 25.0f, 30.0f, 35.0f, 40.0f, 45.0f, 50.0f, 55.0f, 60.0f, 65.0f, 70.0f, 75.0f, 80.0f, 85.0f, 90.0f, 95.0f, 100.0f, 105.0f, 110.0f, 115.0f, 120.0f, 125.0f, 130.0f, 135.0f, 140.0f, 145.0f, 150.0f, 155.0f, 160.0f, 165.0f, 170.0f, 175.0f, 180.0f, 185.0f, 190.0f, 195.0f, 200.0f, 210.0f, 220.0f, 225.0f, 230.0f, 240.0f, 250.0f, 260.0f, 270.0f, 275.0f, 280.0f, 290.0f, 300.0f, 325.0f, 350.0f};
        float[] B = new float[]{0.3247f, 0.3254f, 0.3261f, 0.3268f, 0.3275f, 0.3283f, 0.3291f, 0.3299f, 0.3307f, 0.3316f, 0.3325f, 0.3334f, 0.3343f, 0.3352f, 0.3362f, 0.3371f, 0.3381f, 0.3391f, 0.3401f, 0.3411f, 0.3422f, 0.3432f, 0.3443f, 0.3454f, 0.3465f, 0.3476f, 0.3487f, 0.3498f, 0.351f, 0.3521f, 0.3533f, 0.3545f, 0.3556f, 0.3568f, 0.358f, 0.3592f, 0.3605f, 0.3617f, 0.3629f, 0.3642f, 0.3655f, 0.3681f, 0.3707f, 0.3721f, 0.3734f, 0.3762f, 0.3792f, 0.3822f, 0.3855f, 0.3871f, 0.3889f, 0.3926f, 0.3965f, 0.4085f, 0.4256f};
        if (t < 0.0f || t > 350.0f) {
            return Float.NaN;
        }
        float Bg = Interpolate.rationalInterpolation(temp, B, t);
        return Bg;
    }

    private float bgNaCl(float t) throws Interpolate.RationalInterpolationException {
        float[] temp = new float[]{0.0f, 25.0f, 50.0f, 75.0f, 100.0f, 125.0f, 150.0f, 175.0f, 200.0f, 225.0f, 250.0f, 275.0f, 300.0f, 325.0f, 350.0f};
        float[] b = new float[]{0.041f, 0.064f, 0.074f, 0.077f, 0.076f, 0.072f, 0.065f, 0.056f, 0.046f, 0.033f, 0.017f, -0.003f, -0.029f, -0.063f, -0.114f};
        if (t < 0.0f || t > 350.0f) {
            return Float.NaN;
        }
        float bg = Interpolate.rationalInterpolation(temp, b, t);
        return bg;
    }

    private float gT(float t) throws Interpolate.RationalInterpolationException {
        float[] temp = new float[]{175.0f, 200.0f, 225.0f, 250.0f, 275.0f, 300.0f, 325.0f, 350.0f};
        float[] g = new float[]{0.0f, -1.45E-4f, -4.72E-4f, -0.001075f, -0.00226f, -0.004651f, -0.009758f, -0.022848f};
        if (t > 350.0f) {
            return Float.NaN;
        }
        float gt = 0.0f;
        if (t <= 175.0f) {
            return gt;
        }
        gt = Interpolate.rationalInterpolation(temp, g, t);
        return gt;
    }

    public static class SITdataException
    extends Exception {
        public SITdataException() {
        }

        public SITdataException(String txt) {
            super(txt);
        }
    }

    public class SITeps {
        public float[][] eps0;
        public float[][] eps1;
        public float[][] eps2;

        public SITeps(int nIons) throws SITdataException {
            if (nIons <= 0) {
                throw new SITdataException("Error in \"SITepsilon\"-constructor: nIons=" + nIons + ". Must be >0.");
            }
            this.eps0 = new float[nIons + 2][];
            this.eps1 = new float[nIons + 2][];
            this.eps2 = new float[nIons + 2][];
            for (int i = 0; i < nIons + 2; ++i) {
                this.eps0[i] = new float[i + 2];
                this.eps1[i] = new float[i + 2];
                this.eps2[i] = new float[i + 2];
            }
            this.eps0[0][0] = Float.NaN;
        }
    }
}

