/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.FrameDBmain;
import java.awt.AWTKeyStroke;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import lib.database.ProgramDataDB;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;

public class AskRedox
extends JDialog {
    boolean askSomething = false;
    private ProgramConf pc;
    private ProgramDataDB pd;
    private FrameDBmain dbF;
    private boolean ok = false;
    private boolean askingBeforeSearch;
    private Dimension windowSize = new Dimension(227, 122);
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxN;
    private JCheckBox jCheckBoxP;
    private JCheckBox jCheckBoxS;
    private JLabel jLabelMessage;
    private JLabel jLabelTop;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButtonAsk;
    private JRadioButton jRadioButtonDoNotAsk;

    public AskRedox(Frame parent, boolean modal, ProgramConf pc0, ProgramDataDB pd0, boolean aBS, DefaultListModel model) {
        super(parent, modal);
        int top;
        int left;
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.dbF = (FrameDBmain)parent;
        this.askingBeforeSearch = aBS;
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskRedox.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskRedox.this.jButtonOK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskRedox.this.jButtonHelp.doClick();
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(39, 0));
        newKeys.add(KeyStroke.getKeyStroke(40, 0));
        this.setFocusTraversalKeys(0, newKeys);
        keys = this.getFocusTraversalKeys(1);
        newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(37, 0));
        newKeys.add(KeyStroke.getKeyStroke(38, 0));
        this.setFocusTraversalKeys(1, newKeys);
        this.setTitle(this.pc.progName + " - Redox options");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (parent != null) {
            left = Math.max(0, parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2);
            top = Math.max(0, parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2);
        } else {
            left = Math.max(0, (screenSize.width - this.getWidth()) / 2);
            top = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        }
        this.setLocation(Math.min(screenSize.width - this.getWidth() - 20, left), Math.min(screenSize.height - this.getHeight() - 20, top));
        if (this.pd.redoxN) {
            this.jCheckBoxN.setSelected(true);
        }
        if (this.pd.redoxP) {
            this.jCheckBoxP.setSelected(true);
        }
        if (this.pd.redoxS) {
            this.jCheckBoxS.setSelected(true);
        }
        if (this.pd.redoxAsk) {
            this.jRadioButtonAsk.setSelected(true);
            this.jCheckBoxN.setEnabled(false);
            this.jCheckBoxP.setEnabled(false);
            this.jCheckBoxS.setEnabled(false);
        } else {
            this.jRadioButtonDoNotAsk.setSelected(true);
            this.jCheckBoxN.setEnabled(true);
            this.jCheckBoxP.setEnabled(true);
            this.jCheckBoxS.setEnabled(true);
        }
        this.jLabelMessage.setVisible(false);
        boolean bl = this.askSomething = !this.askingBeforeSearch;
        if (this.askingBeforeSearch) {
            for (int i = 0; i < model.size(); ++i) {
                String selCompName = model.get(i).toString();
                if (selCompName.equals("SCN-")) continue;
                for (int k0 = 0; k0 < this.pd.elemComp.size(); ++k0) {
                    String[] elemComp = (String[])this.pd.elemComp.get(k0);
                    if (!elemComp[1].equals(selCompName)) continue;
                    String el = elemComp[0];
                    if (el.equals("N")) {
                        this.askSomething = true;
                        this.jCheckBoxN.setEnabled(true);
                    }
                    if (el.equals("S")) {
                        this.askSomething = true;
                        this.jCheckBoxS.setEnabled(true);
                    }
                    if (!el.equals("P")) continue;
                    this.askSomething = true;
                    this.jCheckBoxP.setEnabled(true);
                }
            }
            if (!this.askSomething) {
                this.closeWindow();
                return;
            }
            this.jLabelTop.setText("<html>\"e-\" has been selected:<br>include redox equilibria among ligands?<br>&nbsp;</html>");
            this.jLabelMessage.setVisible(true);
            this.jRadioButtonAsk.setVisible(false);
            this.jRadioButtonDoNotAsk.setVisible(false);
        }
    }

    public void start() {
        this.setVisible(true);
        this.windowSize = this.getSize();
        this.jButtonCancel.requestFocusInWindow();
        this.dbF.setCursorDef();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabelTop = new JLabel();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel4 = new JPanel();
        this.jRadioButtonAsk = new JRadioButton();
        this.jRadioButtonDoNotAsk = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jCheckBoxN = new JCheckBox();
        this.jCheckBoxS = new JCheckBox();
        this.jCheckBoxP = new JCheckBox();
        this.jLabelMessage = new JLabel();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AskRedox.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                AskRedox.this.formComponentResized(evt);
            }
        });
        this.jLabelTop.setFont(new Font("Dialog", 1, 12));
        this.jLabelTop.setText("<html>If \"e-\" is selected:<br>include redox equilibria among ligands?</html>");
        this.jButtonHelp.setFont(new Font("Dialog", 0, 11));
        this.jButtonHelp.setMnemonic('h');
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskRedox.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskRedox.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskRedox.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel4.setFont(new Font("Dialog", 0, 11));
        this.buttonGroup1.add(this.jRadioButtonAsk);
        this.jRadioButtonAsk.setFont(new Font("Dialog", 0, 11));
        this.jRadioButtonAsk.setMnemonic('e');
        this.jRadioButtonAsk.setText("Ask every time \"e-\" is selected");
        this.jRadioButtonAsk.setVerticalTextPosition(1);
        this.jRadioButtonAsk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskRedox.this.jRadioButtonAskActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonDoNotAsk);
        this.jRadioButtonDoNotAsk.setFont(new Font("Dialog", 0, 11));
        this.jRadioButtonDoNotAsk.setMnemonic('d');
        this.jRadioButtonDoNotAsk.setText("Do not ask. Include the following equilibria:");
        this.jRadioButtonDoNotAsk.setVerticalTextPosition(1);
        this.jRadioButtonDoNotAsk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskRedox.this.jRadioButtonDoNotAskActionPerformed(evt);
            }
        });
        this.jPanel3.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxN.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxN.setMnemonic('n');
        this.jCheckBoxN.setText("N (NO3-, NO2-, NH3, etc)");
        this.jCheckBoxS.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxS.setMnemonic('s');
        this.jCheckBoxS.setText("S (SO4-2, SO3-2, HS-, etc)");
        this.jCheckBoxP.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxP.setMnemonic('p');
        this.jCheckBoxP.setText("P (PO4-3, HPO3-2, H2PO2-, etc)");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxN).addComponent(this.jCheckBoxS).addComponent(this.jCheckBoxP)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBoxN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxS)));
        this.jLabelMessage.setFont(new Font("Dialog", 0, 11));
        this.jLabelMessage.setText("<html>Note: some of the selected components might not participate in redox reactions</html>");
        this.jLabelMessage.setVerticalAlignment(1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAsk).addGroup(jPanel4Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jPanel3, -2, -1, -2)).addComponent(this.jRadioButtonDoNotAsk)).addContainerGap(10, Short.MAX_VALUE)).addComponent(this.jLabelMessage, -2, 0, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jRadioButtonAsk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonDoNotAsk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelMessage, -2, 40, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTop, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTop, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(59, 59, 59).addComponent(this.jButtonHelp).addGap(18, 18, 18).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK).addContainerGap()).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE))));
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.pd.redoxAsk = this.jRadioButtonAsk.isSelected();
        this.pd.redoxN = this.jCheckBoxN.isSelected();
        this.pd.redoxP = this.jCheckBoxP.isSelected();
        this.pd.redoxS = this.jCheckBoxS.isSelected();
        this.ok = true;
        this.closeWindow();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        String[] a = new String[]{"DB_0_Main_htm"};
        RunProgr.runProgramInProcess(this, "Chem_Diagr_Help.jar", a, false, this.pc.dbg, this.pc.pathAPP);
        this.setCursor(new Cursor(0));
    }

    private void jRadioButtonAskActionPerformed(ActionEvent evt) {
        this.jCheckBoxN.setEnabled(false);
        this.jCheckBoxP.setEnabled(false);
        this.jCheckBoxS.setEnabled(false);
    }

    private void jRadioButtonDoNotAskActionPerformed(ActionEvent evt) {
        this.jCheckBoxN.setEnabled(true);
        this.jCheckBoxP.setEnabled(true);
        this.jCheckBoxS.setEnabled(true);
    }

    private void closeWindow() {
        this.dbF.exitCancel = !this.ok;
        this.dispose();
        this.dbF.bringToFront();
    }
}

