/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DBSearch;
import database.FrameDBmain;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import lib.common.Util;
import lib.database.Complex;
import lib.database.LibDB;
import lib.database.ProgramDataDB;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;

public class ExitDialog
extends JDialog {
    private ProgramConf pc;
    private final ProgramDataDB pd;
    private final FrameDBmain dbF;
    private final DBSearch hs;
    private final Dimension windowSize = new Dimension(185, 185);
    private static final String nl = System.getProperty("line.separator");
    private static final Locale engl = Locale.ENGLISH;
    private JButton jButtonCancel;
    private JButton jButtonDiagram;
    private JButton jButtonSave;
    private JLabel jLabelDiagram;
    private JLabel jLabelSave;

    public ExitDialog(Frame parent, boolean modal, ProgramConf pc0, ProgramDataDB pd0, DBSearch hs0) {
        super(parent, modal);
        int top;
        int left;
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.dbF = (FrameDBmain)parent;
        this.hs = hs0;
        this.dbF.setCursorDef();
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExitDialog.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        this.getRootPane().getActionMap().put("ALT_X", escAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExitDialog.this.setCursor(new Cursor(3));
                String[] a = new String[]{"DB_0_Main_htm"};
                RunProgr.runProgramInProcess(ExitDialog.this, "Chem_Diagr_Help.jar", a, false, ((ExitDialog)ExitDialog.this).pc.dbg, ((ExitDialog)ExitDialog.this).pc.pathAPP);
                ExitDialog.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(39, 0));
        newKeys.add(KeyStroke.getKeyStroke(40, 0));
        this.setFocusTraversalKeys(0, newKeys);
        keys = this.getFocusTraversalKeys(1);
        newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(37, 0));
        newKeys.add(KeyStroke.getKeyStroke(38, 0));
        this.setFocusTraversalKeys(1, newKeys);
        this.getContentPane().setBackground(Color.BLUE);
        this.setTitle(this.pc.progName + " - Exit and...");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (parent != null) {
            left = Math.max(0, parent.getX() + 20);
            top = Math.max(0, parent.getY() + 20);
        } else {
            left = Math.max(0, (screenSize.width - this.getWidth()) / 2);
            top = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        }
        this.setLocation(Math.min(screenSize.width - this.getWidth() - 20, left), Math.min(screenSize.height - this.getHeight() - 20, top));
        String diagramProg = LibDB.getDiagramProgr((String)this.pd.diagramProgr);
        if (diagramProg == null) {
            this.jButtonDiagram.setEnabled(false);
            this.jLabelDiagram.setForeground(Color.GRAY);
            this.jLabelDiagram.setText("<html>save file and<br>make a Diagram</html>");
            this.jLabelSave.setText("<html><u>S</u>ave<br>to disk file</html>");
        }
        this.jButtonDiagram.setMnemonic(68);
        this.dbF.exitCancel = true;
        this.dbF.send2Diagram = false;
        this.setVisible(true);
    }

    private void initComponents() {
        this.jButtonDiagram = new JButton();
        this.jLabelDiagram = new JLabel();
        this.jButtonSave = new JButton();
        this.jLabelSave = new JLabel();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExitDialog.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ExitDialog.this.formComponentResized(evt);
            }
        });
        this.jButtonDiagram.setFont(new Font("Dialog", 0, 11));
        this.jButtonDiagram.setIcon(new ImageIcon(this.getClass().getResource("/database/images/Diagram_button.gif")));
        this.jButtonDiagram.setMnemonic('d');
        this.jButtonDiagram.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonDiagram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExitDialog.this.jButtonDiagramActionPerformed(evt);
            }
        });
        this.jLabelDiagram.setFont(new Font("Dialog", 1, 12));
        this.jLabelDiagram.setForeground(Color.white);
        this.jLabelDiagram.setLabelFor(this.jButtonDiagram);
        this.jLabelDiagram.setText("<html>save file and<br>make a <u>D</u>iagram</html>");
        this.jButtonSave.setFont(new Font("Dialog", 0, 11));
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/database/images/Save_32x32.gif")));
        this.jButtonSave.setMnemonic('s');
        this.jButtonSave.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExitDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jLabelSave.setFont(new Font("Dialog", 1, 12));
        this.jLabelSave.setForeground(Color.white);
        this.jLabelSave.setLabelFor(this.jButtonSave);
        this.jLabelSave.setText("<html>only <u>S</u>ave<br>file</html>");
        this.jButtonCancel.setFont(new Font("Dialog", 1, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExitDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel, -2, 67, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDiagram, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDiagram, -2, -1, -2).addComponent(this.jLabelSave, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDiagram).addComponent(this.jLabelDiagram, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave).addComponent(this.jLabelSave, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jButtonCancel, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jButtonDiagramActionPerformed(ActionEvent evt) {
        if (this.saveDataFile(this.hs)) {
            this.dbF.send2Diagram = true;
            this.dbF.exitCancel = false;
        } else {
            this.dbF.exitCancel = true;
        }
        this.closeWindow();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.dbF.exitCancel = !this.saveDataFile(this.hs);
        this.closeWindow();
    }

    private void closeWindow() {
        this.dispose();
        this.dbF.bringToFront();
    }

    private boolean saveDataFile(DBSearch srch) {
        PrintWriter outputFile;
        String defaultName;
        String fn;
        if (srch == null) {
            Util.exceptn("Error in \"saveDataFile\": null argument");
            return false;
        }
        boolean fnd = false;
        if (srch.temperature < 24.99 || srch.temperature > 25.01) {
            ArrayList<String> items = new ArrayList<String>();
            long cnt = 0L;
            for (int ix = 0; ix < srch.nx + srch.nf; ++ix) {
                if (srch.dat.get((int)ix).deltH != -999999.9) continue;
                if (!fnd) {
                    System.out.println("--------- Temperature extrapolations");
                    fnd = true;
                }
                System.out.println("species \"" + srch.dat.get((int)ix).name + "\": missing enthalpy.");
                items.add(srch.dat.get((int)ix).name);
                ++cnt;
            }
            if (cnt > 0L) {
                System.out.println("---------");
                DefaultListModel<Object> aModel = new DefaultListModel<Object>();
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    aModel.addElement(ExitDialog.makeObj((String)iter.next()));
                }
                String msg = "<html><b>Error:</b><br>Temperature extrapolations from 25 to " + String.format("%.0f", srch.temperature) + "\u00b0C are required,<br>" + "but enthalpy values are missing for the following species:</html>";
                JLabel aLabel = new JLabel(msg);
                JList aList = new JList(aModel);
                aList.setSelectionMode(0);
                aList.setVisibleRowCount(5);
                JScrollPane aScrollPane = new JScrollPane();
                aScrollPane.setViewportView(aList);
                aList.setFocusable(false);
                JLabel endLabel = new JLabel("Please change the temperature to 25\u00b0C in the menu \"Options\".");
                Object[] o = new Object[]{aLabel, aScrollPane, endLabel};
                JOptionPane.showMessageDialog(this, o, "Temperature extrapolations", 0);
                return false;
            }
        }
        if ((fn = Util.getSaveFileName(this, this.pc.progName, "Save file: Enter data-file name", 5, defaultName = this.dbF.outputDataFile != null ? this.dbF.outputDataFile : "", this.pc.pathDef.toString())) == null) {
            return false;
        }
        this.pc.setPathDef(fn);
        String tmpFileName = fn.substring(0, fn.length() - 4).concat(".tmp");
        File tmpFile = new File(tmpFileName);
        try {
            outputFile = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
        }
        catch (IOException ex) {
            String msg = "Error in \"saveDataFile\"," + nl + "   \"" + ex.toString() + "\"," + nl + "   while making a PrintWriter for data file:" + nl + "   \"" + tmpFileName + "\"";
            Util.exceptn(msg);
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
            return false;
        }
        if (srch.na < 1 || srch.na > 1000) {
            Util.exceptn("Error: Number of components is: " + srch.na + nl + "Must be >0 and <1000.");
        }
        if (srch.nx < 0 || srch.nx > 1000000) {
            Util.exceptn("Error: Number of soluble complexes is: " + srch.nx + nl + "Must be >=0 and < 1 000 000.");
        }
        int nrSol = srch.nf;
        if (srch.nf < 0 || srch.nf > 100000) {
            Util.exceptn("Error: Number of solid reaction products is: " + srch.nf + nl + "Must be >=0 and < 100 000.");
        }
        if (srch.solidC < 0 || srch.solidC > srch.na) {
            Util.exceptn("Error: Number of solid components is: " + srch.solidC + nl + "Must be >=0 and <= " + srch.na + " (the nbr of components).");
        }
        if (this.pc.dbg) {
            System.out.println("---- Saving file \"" + fn + "\".");
        }
        String m = ",   /DATABASE (HYDRA)";
        if (!Double.isNaN(srch.temperature)) {
            m = m + ", t=" + Util.formatDbl3(srch.temperature);
        }
        if (!Double.isNaN(srch.pressure)) {
            m = m + ", p=" + Util.formatDbl3(srch.pressure);
        }
        if (this.pd.includeH2O) {
            this.dbF.modelSelectedComps.add(srch.na - srch.solidC, "H2O");
            ++srch.na;
        }
        outputFile.println(" " + String.valueOf(srch.na) + ", " + String.valueOf(srch.nx) + ", " + String.valueOf(nrSol) + ", " + String.valueOf(srch.solidC) + m.trim());
        for (int i = 0; i < srch.na; ++i) {
            outputFile.format("%s", this.dbF.modelSelectedComps.get(i));
            outputFile.println();
        }
        outputFile.flush();
        StringBuilder logB = new StringBuilder();
        for (int ix = 0; ix < srch.nx + srch.nf; ++ix) {
            if (srch.dat.get((int)ix).name.length() <= 19) {
                outputFile.format(engl, "%-19s,  ", srch.dat.get((int)ix).name);
            } else {
                outputFile.format(engl, "%s,  ", srch.dat.get((int)ix).name);
            }
            if (logB.length() > 0) {
                logB.delete(0, logB.length());
            }
            double lgK = Complex.constCp((double)srch.dat.get((int)ix).constant, (double)srch.dat.get((int)ix).deltH, (double)srch.dat.get((int)ix).deltCp, (double)srch.temperature);
            logB.append(Util.formatDbl3(lgK));
            int j = 9 - logB.length();
            if (j > 0) {
                for (int k = 0; k < j; ++k) {
                    logB.append(' ');
                }
            } else {
                logB.append(' ');
            }
            outputFile.print(logB.toString());
            for (int jc = 0; jc < srch.na; ++jc) {
                fnd = false;
                for (int jdat = 0; jdat < 6; ++jdat) {
                    if (!srch.dat.get((int)ix).component[jdat].equals(this.dbF.modelSelectedComps.get(jc))) continue;
                    outputFile.print(Util.formatDbl4(srch.dat.get((int)ix).numcomp[jdat]));
                    if (jc < srch.na - 1) {
                        outputFile.print(" ");
                    }
                    fnd = true;
                    break;
                }
                if (!fnd && Util.isProton(this.dbF.modelSelectedComps.get(jc).toString()) && Math.abs(srch.dat.get((int)ix).proton) > 0.001) {
                    fnd = true;
                    outputFile.print(Util.formatDbl4(srch.dat.get((int)ix).proton));
                    if (jc < srch.na - 1) {
                        outputFile.print(" ");
                    }
                }
                if (fnd) continue;
                outputFile.print(" 0");
                if (jc >= srch.na - 1) continue;
                outputFile.print(" ");
            }
            if (srch.dat.get((int)ix).comment != null && srch.dat.get((int)ix).comment.length() > 0) {
                outputFile.print(" /" + srch.dat.get((int)ix).comment);
            }
            outputFile.println();
        }
        outputFile.flush();
        outputFile.close();
        File dataFile = new File(fn);
        dataFile.delete();
        if (!tmpFile.renameTo(dataFile)) {
            Util.exceptn("Error in \"saveDataFile\":" + nl + "   can not rename file \"" + tmpFile.getAbsolutePath() + "\"" + nl + "   to \"" + dataFile.getAbsolutePath() + "\"");
            return false;
        }
        this.dbF.outputDataFile = dataFile.getAbsolutePath();
        return true;
    }

    private static Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }
}

