/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.eps;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import org.qenherkhopeshef.graphics.eps.EPSCMYKColor;
import org.qenherkhopeshef.graphics.eps.EPSColor;
import org.qenherkhopeshef.graphics.eps.EPSOutException;

public class EPSLowLevel {
    private Writer writer;
    private double currentX;
    private double currentY;
    private static HashMap colorMap = new HashMap();
    private static EPSColor RED = new EPSColor(255, 0, 0);

    public EPSLowLevel(Writer writer, Dimension2D dimensions) throws EPSOutException {
        this.writer = writer;
        this.writeHeader(dimensions, "");
    }

    public EPSLowLevel(Writer writer, Dimension2D dimensions, String comment) throws EPSOutException {
        this.writer = writer;
        this.writeHeader(dimensions, comment);
    }

    private void writeHeader(Dimension2D dimensions, String comment) throws EPSOutException {
        try {
            int height = (int)Math.ceil(dimensions.getHeight());
            int width = (int)Math.ceil(dimensions.getWidth());
            this.writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
            this.writer.write("%%BoundingBox: ");
            this.writer.write("0 0 " + width + " " + height + "\n");
            this.writer.write("%%Pages: 1\n");
            this.writer.write("%%DocumentCustomColors: (ifao 187)\n");
            this.writer.write("%%CMYKCustomColor: 0 1 0.8 0.2 (ifao 187))");
            this.writer.write("%%EndComments\n");
            if (comment.length() > 0) {
                String[] commentList = comment.split("\\n|\\r\\n?");
                for (int i = 0; i < commentList.length; ++i) {
                    this.writer.write("%JSESH-source: " + commentList[i]);
                    this.writer.write("\n");
                }
            }
            this.writer.write("%%BeginSetup\n");
            this.writer.write("/ifao_187 { [ /Separation (ifao 187)\n");
            this.writer.write("  /DeviceCMYK {0 exch dup exch dup 0.788235 mul exch 0.2 mul}]\n");
            this.writer.write("  setcolorspace setcolor} bind def\n");
            this.writer.write("%%EndSetup\n");
            this.writer.write("%%Page: 1 1\n");
            this.sendCommand("gsave");
            this.sendCommand("1 -1 scale");
            this.sendCommand("0 -" + (int)dimensions.getHeight() + " translate");
        }
        catch (IOException e) {
            throw new EPSOutException(e);
        }
    }

    public void drawLine(double x, double y, double x2, double y2) throws EPSOutException {
        this.startPath();
        this.moveTo(x, y);
        this.lineTo(x2, y2);
        this.strokePath();
    }

    public void startPath() throws EPSOutException {
        this.sendCommand("newpath");
    }

    public void cubicTo(double x1, double y1, double x2, double y2, double x, double y) throws EPSOutException {
        this.addPathElement(x1, y1);
        this.addPathElement(x2, y2);
        this.addPathElement(x, y);
        this.sendCommand("curveto");
    }

    private void addPathElement(double x, double y) throws EPSOutException {
        try {
            this.writeDouble(x);
            this.writer.write(32);
            this.writeDouble(y);
            this.writer.write(32);
            this.setCurrentPosition(x, y);
        }
        catch (IOException e) {
            throw new EPSOutException(e);
        }
    }

    private void writeDouble(double x) throws EPSOutException {
        try {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
            DecimalFormat format = new DecimalFormat("#.####", symbols);
            this.writer.write(format.format(x));
        }
        catch (IOException e) {
            throw new EPSOutException(e);
        }
    }

    public void moveTo(double x, double y) throws EPSOutException {
        this.addPathElement(x, y);
        this.sendCommand("moveto");
    }

    private void setCurrentPosition(double x, double y) {
        this.currentX = x;
        this.currentY = y;
    }

    public void lineTo(double x, double y) throws EPSOutException {
        this.addPathElement(x, y);
        this.sendCommand("lineto");
    }

    public void quadTo(double x1, double y1, double x, double y) throws EPSOutException {
        double x0 = this.currentX;
        double y0 = this.currentY;
        double cp1x = x0 + 0.6666666666666666 * (x1 - x0);
        double cp1y = y0 + 0.6666666666666666 * (y1 - y0);
        double cp2x = x1 + 0.3333333333333333 * (x - x1);
        double cp2y = y1 + 0.3333333333333333 * (y - y1);
        this.addPathElement(cp1x, cp1y);
        this.addPathElement(cp2x, cp2y);
        this.addPathElement(x, y);
        this.sendCommand("curveto");
    }

    public void strokePath() throws EPSOutException {
        this.sendCommand("stroke");
    }

    public void fillPath() throws EPSOutException {
        this.sendCommand("fill");
    }

    public void close() throws EPSOutException {
        try {
            this.writer.write("");
            this.writer.close();
        }
        catch (IOException e) {
            throw new EPSOutException(e);
        }
    }

    public void closePath() throws EPSOutException {
        this.sendCommand("closepath");
    }

    public void setColor(int red, int green, int blue) throws EPSOutException {
        try {
            EPSColor col = new EPSColor(red, green, blue);
            if (col.equals(RED)) {
                this.writer.write("1 ifao_187\n");
            } else if (colorMap.containsKey(col)) {
                EPSCMYKColor simpleCol = (EPSCMYKColor)colorMap.get(col);
                this.writeDouble(EPSLowLevel.scaleCMYKColor(simpleCol.getCyan()));
                this.writer.write(32);
                this.writeDouble(EPSLowLevel.scaleCMYKColor(simpleCol.getMagenta()));
                this.writer.write(32);
                this.writeDouble(EPSLowLevel.scaleCMYKColor(simpleCol.getYellow()));
                this.writer.write(32);
                this.writeDouble(EPSLowLevel.scaleCMYKColor(simpleCol.getBlack()));
                this.writer.write(32);
                this.sendCommand("setcmykcolor");
            } else {
                this.writeDouble(EPSLowLevel.scaleColor(red));
                this.writer.write(32);
                this.writeDouble(EPSLowLevel.scaleColor(green));
                this.writer.write(32);
                this.writeDouble(EPSLowLevel.scaleColor(blue));
                this.writer.write(32);
                this.sendCommand("setrgbcolor");
            }
        }
        catch (IOException e) {
            throw new EPSOutException(e);
        }
    }

    public void setColor(EPSColor color) throws EPSOutException {
        this.setColor(color.getR(), color.getG(), color.getB());
    }

    private void sendCommand(String command) throws EPSOutException {
        try {
            this.writer.write(" " + command + "\n");
        }
        catch (IOException e) {
            throw new EPSOutException(e);
        }
    }

    private static double scaleColor(int component) {
        return (double)component / 255.0;
    }

    private static double scaleCMYKColor(int component) {
        return (double)component / 100.0;
    }

    public void gsave() {
        this.sendCommand("gsave");
    }

    public void grestore() {
        this.sendCommand("grestore");
    }

    static {
        colorMap.put(new EPSColor(0, 0, 0), new EPSCMYKColor(0, 0, 0, 100));
        colorMap.put(new EPSColor(255, 255, 255), new EPSCMYKColor(0, 0, 0, 0));
        for (int i = 1; i < 255; ++i) {
            int grayLevel = (int)(Math.round((255.0 - (double)i) / 256.0) * 100L);
            colorMap.put(new EPSColor(i, i, i), new EPSCMYKColor(0, 0, 0, grayLevel));
        }
    }
}

