/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import org.qenherkhopeshef.graphics.vectorClipboard.PDFTransferable;
import org.qenherkhopeshef.graphics.vectorClipboard.TransferablePicture;

public class PDFPicture
implements TransferablePicture {
    private float width;
    private float height;
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    private Document document;
    private String comment = "";

    public PDFPicture(float width, float height) throws FileNotFoundException {
        Rectangle pageSize = new Rectangle(width, height);
        this.document = new Document(pageSize);
        this.width = width;
        this.height = height;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void close() {
        this.document.close();
    }

    public byte[] getByteArray() {
        return this.out.toByteArray();
    }

    public Graphics2D getGraphics() {
        PdfWriter pdfWriter;
        try {
            pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.out);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        if (this.comment != null && !"".equals(this.comment)) {
            this.document.addSubject(this.comment);
        }
        this.document.open();
        return pdfWriter.getDirectContent().createGraphicsShapes(this.width, this.height);
    }

    public Transferable buildTransferable() {
        this.close();
        return new PDFTransferable(this);
    }
}

