/*
 * Decompiled with CFR 0.152.
 */
package predominanceAreaDiagrams;

import java.io.File;
import java.io.PrintStream;
import java.util.Locale;
import lib.common.Util;
import lib.kemi.chem.Chem;
import lib.kemi.graph_lib.GraphLib;
import lib.kemi.interpolate.Interpolate;
import predominanceAreaDiagrams.Predom;
import predominanceAreaDiagrams.PredomData;

public class Plot_Predom {
    private Predom pred = null;
    private static final Locale engl = Locale.ENGLISH;
    private final PrintStream out;
    private int[] iFL;
    private boolean lineContinued;
    private int[] iOther;
    private int[][] neighb;
    private double[] ax;
    private double[] ay;
    private double[] ix;
    private double[] iy;
    private static final String nl = System.getProperty("line.separator");

    public Plot_Predom(Predom pred0, PrintStream err0, PrintStream out0) {
        this.pred = pred0;
        this.out = out0 != null ? out0 : System.out;
    }

    void minMax(Chem ch, PredomData pd) {
        int j;
        if (this.pred.dbg) {
            this.out.println("--- minMax" + nl + "Calculating the position of the centre of each predominance area");
        }
        Chem.ChemSystem cs = ch.chemSystem;
        this.ax = new double[cs.Ms];
        this.ay = new double[cs.Ms];
        this.ix = new double[cs.Ms];
        this.iy = new double[cs.Ms];
        for (int i = 0; i < cs.Ms; ++i) {
            this.ax[i] = -50000.0;
            this.ay[i] = -50000.0;
            this.ix[i] = 10000.0;
            this.iy[i] = 10000.0;
        }
        for (int i = 0; i < pd.nPoint; ++i) {
            for (int k = 0; k <= 2; ++k) {
                j = pd.pair[i][k];
                if (j < 0) continue;
                if (pd.xPl[i] > this.ax[j]) {
                    this.ax[j] = pd.xPl[i];
                }
                if (pd.xPl[i] < this.ix[j]) {
                    this.ix[j] = pd.xPl[i];
                }
                if (pd.yPl[i] > this.ay[j]) {
                    this.ay[j] = pd.yPl[i];
                }
                if (!(pd.yPl[i] < this.iy[j])) continue;
                this.iy[j] = pd.yPl[i];
            }
        }
        double z2 = 0.001 * Math.abs(pd.stepY);
        double zq = Math.abs(pd.stepX) + 0.001 * Math.abs(pd.stepX);
        double zx5 = Math.abs(pd.xRight - pd.xLeft) / 10.0;
        double zy5 = Math.abs(pd.yTop - pd.yBottom) / 10.0;
        double distS = Math.sqrt(zx5 * zx5 + zy5 * zy5);
        for (int i = 0; i < cs.Ms; ++i) {
            double dist;
            int ip;
            pd.xCentre[i] = (this.ax[i] + this.ix[i]) / 2.0;
            pd.yCentre[i] = (this.ay[i] + this.iy[i]) / 2.0;
            if (pd.xCentre[i] < -1000.0 || pd.yCentre[i] < -1000.0) continue;
            if (this.pred.dbg) {
                this.out.println(" Species " + i + ", \"" + cs.namn.ident[i] + "\", Centre = " + (float)pd.xCentre[i] + ", " + (float)pd.yCentre[i]);
                this.out.println("   X from = " + (float)this.ix[i] + " to " + (float)this.ax[i] + ", Y from = " + (float)this.iy[i] + " to " + (float)this.ay[i]);
            }
            if (this.ay[i] - this.iy[i] <= zy5 || this.ax[i] - this.ix[i] <= zx5) continue;
            int[] nCentr = new int[4];
            double[] yCentr = new double[4];
            int nLines = 0;
            double last = -10000.0;
            double w = pd.xCentre[i] + Math.abs(pd.stepX);
            for (ip = 0; ip < pd.nPoint; ++ip) {
                if (pd.xPl[ip] < pd.xCentre[i] || pd.xPl[ip] >= w || pd.pair[ip][1] != i && pd.pair[ip][0] != i && pd.pair[ip][2] != i) continue;
                double z1 = last + pd.stepY;
                last = pd.yPl[ip];
                double z3 = last;
                if (last == z3 || Math.abs(last - z1) < z2) continue;
                nCentr[++nLines - 1] = ip;
                yCentr[nLines - 1] = pd.yPl[ip];
                if (nLines >= 4) break;
            }
            int i2nd = i + cs.Ms;
            if (this.pred.dbg) {
                this.out.println("   nLines = " + nLines);
                for (j = 0; j < nLines; ++j) {
                    int ij = nCentr[j];
                    this.out.println("   point: " + ij + " species: " + pd.pair[ij][0] + "," + pd.pair[ij][1] + "/" + pd.pair[ij][2] + ",  x,y=" + (float)pd.xPl[ij] + ", " + (float)pd.yPl[ij]);
                }
            }
            if (nLines == 1) continue;
            if (nLines == 2) {
                pd.yCentre[i] = (yCentr[0] + yCentr[1]) / 2.0;
                continue;
            }
            if (nLines == 0 || nLines == 3) {
                double w2;
                double q1 = this.ax[i] - zq;
                double q2 = this.ax[i] + zq;
                double q3 = this.ix[i] - zq;
                double q4 = this.ix[i] + zq;
                double ay1 = -50000.0;
                double iy1 = 10000.0;
                double ay2 = -50000.0;
                double iy2 = 10000.0;
                for (ip = 0; ip <= pd.nPoint; ++ip) {
                    if (pd.pair[ip][0] != i && pd.pair[ip][1] != i && pd.pair[ip][2] != i) continue;
                    if (pd.xPl[ip] >= q1 && pd.xPl[ip] <= q2) {
                        if (pd.yPl[ip] > ay1) {
                            ay1 = pd.yPl[ip];
                        }
                        if (pd.yPl[ip] < iy1) {
                            iy1 = pd.yPl[ip];
                        }
                    }
                    if (!(pd.xPl[ip] >= q3) || !(pd.xPl[ip] <= q4)) continue;
                    if (pd.yPl[ip] > ay2) {
                        ay2 = pd.yPl[ip];
                    }
                    if (!(pd.yPl[ip] < iy2)) continue;
                    iy2 = pd.yPl[ip];
                }
                double yCent1 = (ay1 + iy1) / 2.0;
                double yCent2 = (ay2 + iy2) / 2.0;
                pd.yCentre[i2nd] = pd.yCentre[i];
                if (yCent1 > -1000.0) {
                    pd.yCentre[i] = yCent1;
                }
                if (yCent2 > -1000.0) {
                    pd.yCentre[i2nd] = yCent2;
                }
                pd.xCentre[i] = this.ax[i] - zx5 / 2.0;
                pd.xCentre[i2nd] = this.ix[i] + zx5 / 2.0;
                if (this.pred.dbg) {
                    this.out.println("   q1,q2,q3,q4 = " + (float)q1 + ", " + (float)q2 + ", " + (float)q3 + ", " + (float)q4);
                    this.out.println("   ay1,iy1,ay2,iy2 = " + (float)ay1 + ", " + (float)iy1 + ", " + (float)ay2 + ", " + (float)iy2);
                    this.out.println("   (x/y)Centr[i] = " + (float)pd.xCentre[i] + ", " + (float)pd.yCentre[i] + ",  (x/y)Centr[i2nd] = " + (float)pd.xCentre[i2nd] + ", " + (float)pd.yCentre[i2nd]);
                }
                if ((dist = Math.sqrt((w = Math.pow(pd.xCentre[i] - pd.xCentre[i2nd], 2.0)) + (w2 = Math.pow(pd.yCentre[i] - pd.yCentre[i2nd], 2.0)))) <= distS) {
                    pd.xCentre[i] = (this.ax[i] + this.ix[i]) / 2.0;
                    pd.yCentre[i] = (this.ay[i] + this.iy[i]) / 2.0;
                    pd.xCentre[i2nd] = -30000.0;
                    pd.yCentre[i2nd] = -30000.0;
                }
                if (!this.pred.dbg) continue;
                this.out.println("   -- centres: " + (float)pd.xCentre[i] + ", " + (float)pd.yCentre[i] + "  and " + (float)pd.xCentre[i2nd] + ", " + (float)pd.yCentre[i2nd]);
                continue;
            }
            if (nLines != 4) continue;
            pd.yCentre[i] = (yCentr[0] + yCentr[1]) / 2.0;
            pd.yCentre[i2nd] = (yCentr[2] + yCentr[3]) / 2.0;
            pd.xCentre[i2nd] = pd.xCentre[i];
            dist = pd.yCentre[i] - pd.yCentre[i2nd];
            if (dist <= distS) {
                pd.yCentre[i] = (this.ay[i] + this.iy[i]) / 2.0;
                pd.xCentre[i2nd] = -30000.0;
                pd.yCentre[i2nd] = -30000.0;
            }
            if (!this.pred.dbg) continue;
            this.out.println("   -- centres: " + (float)pd.xCentre[i] + ", " + (float)pd.yCentre[i] + "  and " + (float)pd.xCentre[i2nd] + ", " + (float)pd.yCentre[i2nd]);
        }
    }

    void drawPlot(File plotFile, Chem ch, PredomData diagP) {
        double w1;
        int j;
        String t;
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.ChemConcs csC = cs.chemConcs;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.Diagr diag = ch.diag;
        Chem.DiagrConcs dgrC = ch.diagrConcs;
        this.out.println("--- Drawing the plot...");
        double xLow = dgrC.cLow[diag.compX];
        double xHigh = dgrC.cHigh[diag.compX];
        if (Util.isProton(namn.identC[diag.compX]) || Util.isElectron(namn.identC[diag.compX])) {
            if (dgrC.hur[diag.compX] != 5) {
                diag.pInX = 0;
            } else {
                xLow = -xLow;
                xHigh = -xHigh;
                if (diag.pInX == 3) {
                    xLow = this.pred.peEh * xLow;
                    xHigh = this.pred.peEh * xHigh;
                }
            }
        }
        boolean xMolar = true;
        if (dgrC.hur[diag.compX] <= 2 && Math.abs(xLow) < 0.9 && Math.abs(xHigh) < 0.9) {
            xMolar = false;
            xLow *= 1000.0;
            xHigh *= 1000.0;
        }
        double yLow = dgrC.cLow[diag.compY];
        double yHigh = dgrC.cHigh[diag.compY];
        if (Util.isProton(namn.identC[diag.compY]) || Util.isElectron(namn.identC[diag.compY])) {
            if (dgrC.hur[diag.compY] != 5) {
                diag.pInY = 0;
            } else {
                yLow = -yLow;
                yHigh = -yHigh;
                if (diag.pInY == 3) {
                    yLow = this.pred.peEh * yLow;
                    yHigh = this.pred.peEh * yHigh;
                }
            }
        }
        boolean yMolar = true;
        if (dgrC.hur[diag.compY] <= 2 && Math.abs(yLow) < 0.9 && Math.abs(yHigh) < 0.9) {
            yMolar = false;
            yLow *= 1000.0;
            yHigh *= 1000.0;
        }
        int nTextX = 6 + namn.nameLength[namn.iel[diag.compX]];
        if (diag.pInX == 1 || diag.pInX == 2) {
            nTextX = 2;
        } else if (diag.pInX == 3) {
            nTextX = 8;
        }
        int nTextY = 6 + namn.nameLength[namn.iel[diag.compY]];
        if (diag.pInY == 1 || diag.pInY == 2) {
            nTextY = 2;
        } else if (diag.pInY == 3) {
            nTextY = 8;
        }
        float xAxl = 10.0f;
        float yAxl = 10.0f;
        float heightAx = 0.035f * yAxl;
        if (this.pred.tHeight > 1.0E-4) {
            heightAx = (float)this.pred.tHeight * heightAx;
        }
        float xOr = 4.5f;
        float yOr = 1.6f;
        float xMx = xOr + xAxl;
        float yMx = yOr + yAxl;
        float xL = xAxl / (float)(xHigh - xLow);
        float xI = xL * (float)xLow - xOr;
        float yL = yAxl / (float)(yHigh - yLow);
        float yI = yL * (float)yHigh - yMx;
        if (!xMolar) {
            xL *= 1000.0f;
        }
        if (!yMolar) {
            yL *= 1000.0f;
        }
        if (diag.pInX == 1 || diag.pInX == 2) {
            xL = -xL;
        } else if (diag.pInX == 3) {
            xL = -xL * (float)this.pred.peEh;
        }
        if (diag.pInY == 1 || diag.pInY == 2) {
            yL = -yL;
        } else if (diag.pInY == 3) {
            yL = -yL * (float)this.pred.peEh;
        }
        this.pred.dd = new GraphLib.PltData();
        GraphLib g = new GraphLib();
        boolean textWithFonts = true;
        try {
            g.start(this.pred.dd, plotFile, textWithFonts);
        }
        catch (GraphLib.openPlotFileException ex) {
            this.pred.showErrMsgBx(ex.getMessage(), 1);
            g.end();
            return;
        }
        this.pred.dd.axisInfo = false;
        g.setLabel("-- PREDOM DIAGRAM --");
        g.setIsFormula(true);
        g.setPen(1);
        g.setPen(-1);
        try {
            g.axes((float)xLow, (float)xHigh, (float)yLow, (float)yHigh, xOr, yOr, xAxl, yAxl, heightAx, false, false, true);
        }
        catch (GraphLib.AxesDataException ex) {
            this.pred.showMsg(ex);
            g.end();
            return;
        }
        float yP = yAxl / 2.0f + yOr - (float)nTextY / 2.0f * (1.3f * heightAx);
        float xP = xOr - 6.6f * heightAx;
        if (dgrC.hur[diag.compY] == 5) {
            t = diag.pInY == 0 ? (Util.isGas(namn.identC[diag.compY]) ? "Log P`" + namn.identC[diag.compY] + "'" : "Log {" + namn.identC[diag.compY] + "}") : (diag.pInY == 1 ? "pH" : (diag.pInY == 2 ? "pe" : "E`SHE' / V"));
        } else if (dgrC.hur[diag.compY] == 2) {
            t = "[" + namn.identC[diag.compY] + "]`TOT'";
            t = yMolar ? t + "    M" : t + "    mM";
        } else {
            t = "Log [" + namn.identC[diag.compY] + "]`TOT'";
        }
        if (dgrC.hur[diag.compY] == 2 || dgrC.hur[diag.compY] == 3 || dgrC.hur[diag.compY] == 5) {
            g.setLabel("Y-AXIS TEXT");
            g.moveToDrawTo(0.0f, 0.0f, 0);
            g.sym(xP, yP, heightAx, t, 90.0f, 0, false);
        }
        yP = yOr - 3.6f * heightAx;
        xP = xAxl / 2.0f + xOr - (float)nTextX / 2.0f * (1.1429f * heightAx);
        if (dgrC.hur[diag.compX] == 5) {
            t = diag.pInX == 0 ? (Util.isGas(namn.identC[diag.compX]) ? "Log P`" + namn.identC[diag.compX] + "'" : "Log {" + namn.identC[diag.compX] + "}") : (diag.pInX == 1 ? "pH" : (diag.pInX == 2 ? "pe" : "E`SHE' / V"));
        } else if (dgrC.hur[diag.compX] == 2) {
            t = "[" + namn.identC[diag.compX] + "]`TOT'";
            t = xMolar ? t + "    M" : t + "    mM";
        } else {
            t = "Log [" + namn.identC[diag.compX] + "]`TOT'";
        }
        if (dgrC.hur[diag.compX] == 2 || dgrC.hur[diag.compX] == 3 || dgrC.hur[diag.compX] == 5) {
            g.setLabel("X-AXIS TEXT");
            g.moveToDrawTo(0.0f, 0.0f, 0);
            g.sym(xP, yP, heightAx, t, 0.0f, 0, false);
        }
        g.setLabel("-- PREDOMINANCE AREAS --");
        g.moveToDrawTo(0.0f, 0.0f, 0);
        g.setLabel("-- LINES --");
        g.moveToDrawTo(0.0f, 0.0f, 0);
        g.setPen(1);
        diagP.stepX *= (double)xL;
        diagP.stepY *= (double)yL;
        double xDMin = Math.sqrt(diagP.stepX * diagP.stepX + diagP.stepY * diagP.stepY);
        xDMin = 1.3 * xDMin + xDMin * 0.05;
        this.iOther = new int[cs.Ms];
        this.neighb = new int[cs.Ms][24];
        this.iFL = new int[diagP.nPoint + 1];
        for (int i = 0; i < this.iFL.length; ++i) {
            this.iFL[i] = 0;
        }
        int ipoint = -1;
        for (int i = 0; i <= diagP.nPoint; ++i) {
            int ia;
            double dist;
            double w2;
            int pairI0 = diagP.pair[i][0];
            int pairI1 = diagP.pair[i][1];
            if (pairI0 <= -1 || pairI1 <= -1 || diag.oneArea >= 0 && pairI0 != diag.oneArea && pairI1 != diag.oneArea) continue;
            this.lineContinued = false;
            this.iOther[pairI0] = 0;
            this.iOther[pairI1] = 0;
            int now = -1;
            for (j = i + 1; j <= diagP.nPoint; ++j) {
                int pairJ0 = diagP.pair[j][0];
                int pairJ1 = diagP.pair[j][1];
                w1 = Math.abs(diagP.xPl[i] - diagP.xPl[j]) * (double)xL;
                dist = Math.sqrt(w1 * w1 + (w2 = Math.abs(diagP.yPl[i] - diagP.yPl[j]) * (double)yL) * w2);
                if (dist > xDMin) continue;
                if (!this.lineContinued || this.iFL[i] <= 1) {
                    if (diag.oneArea >= 0 && pairJ0 != diag.oneArea && pairJ1 != diag.oneArea) continue;
                    if (pairJ0 == pairI0 && pairJ1 == pairI1) {
                        if (now != i) {
                            g.moveToDrawTo(diagP.xPl[i] * (double)xL - (double)xI, diagP.yPl[i] * (double)yL - (double)yI, 0);
                        }
                        g.moveToDrawTo(diagP.xPl[j] * (double)xL - (double)xI, diagP.yPl[j] * (double)yL - (double)yI, 1);
                        now = j;
                        int n = j;
                        this.iFL[n] = this.iFL[n] + 1;
                        this.lineContinued = true;
                        continue;
                    }
                }
                int k = -1;
                if (pairJ0 == pairI0 || pairJ1 == pairI0) {
                    k = pairI0;
                }
                if (pairJ0 == pairI1 || pairJ1 == pairI1) {
                    k = pairI1;
                }
                if (k < 0) continue;
                this.neighb[k][this.iOther[k]] = j;
                int n = k;
                this.iOther[n] = this.iOther[n] + 1;
            }
            if (this.lineContinued && this.iFL[i] != 0) continue;
            if (this.iOther[pairI0] > 0) {
                ia = pairI0;
            } else {
                if (this.iOther[pairI1] <= 0) continue;
                ia = pairI1;
            }
            boolean b = false;
            do {
                if (b) {
                    ia = pairI1;
                }
                double dMin = 0.0;
                for (int ip = 0; ip < this.iOther[ia]; ++ip) {
                    j = this.neighb[ia][ip];
                    w1 = Math.abs(diagP.xCentre[ia] - diagP.xPl[j]);
                    dist = Math.sqrt(w1 * w1 + (w2 = Math.abs(diagP.yCentre[ia] - diagP.yPl[j])) * w2);
                    if (dist < dMin) continue;
                    dMin = dist;
                    ipoint = j;
                }
                j = ipoint;
                if (now != i) {
                    g.moveToDrawTo(diagP.xPl[i] * (double)xL - (double)xI, diagP.yPl[i] * (double)yL - (double)yI, 0);
                }
                g.moveToDrawTo(diagP.xPl[j] * (double)xL - (double)xI, diagP.yPl[j] * (double)yL - (double)yI, 1);
                now = j;
                b = true;
            } while (ia == pairI0 && this.iOther[pairI1] > 0);
        }
        g.setLabel("-- AREA LABELS --");
        g.moveToDrawTo(0.0f, 0.0f, 0);
        g.setPen(4);
        g.setPen(-4);
        double size = (double)heightAx * 0.75;
        double incrY = heightAx / 6.0f;
        for (int i = 0; i < cs.Ms + cs.Ms; ++i) {
            if (diagP.xCentre[i] < -1000.0) continue;
            int ii = i;
            if (ii > cs.Ms) {
                ii -= cs.Ms;
            }
            if (diag.oneArea >= 0 && ii != diag.oneArea) continue;
            diagP.xCentre[i] = diagP.xCentre[i] * (double)xL - (double)xI - 0.5 * size * (double)namn.nameLength[ii];
            diagP.yCentre[i] = diagP.yCentre[i] * (double)yL - (double)yI - 0.5 * size;
            if (i > 0) {
                boolean overlp;
                double yCentre0 = diagP.yCentre[i];
                int sign = -1;
                int incr = 1;
                do {
                    overlp = false;
                    for (j = 0; j < i; ++j) {
                        if (diagP.xCentre[j] < -1000.0) continue;
                        int ji = j;
                        if (ji > cs.Ms) {
                            ji -= cs.Ms;
                        }
                        if (diagP.yCentre[i] > diagP.yCentre[j] + 2.0 * size || diagP.yCentre[i] < diagP.yCentre[j] - 2.0 * size || diagP.xCentre[i] > diagP.xCentre[j] + size * (double)namn.nameLength[ji] || diagP.xCentre[i] < diagP.xCentre[j] - size * (double)namn.nameLength[ji]) continue;
                        overlp = true;
                        break;
                    }
                    if (!overlp) continue;
                    diagP.yCentre[i] = yCentre0 + (double)(sign * incr) * incrY;
                    if ((sign = -sign) != -1) continue;
                    ++incr;
                } while (overlp);
            }
            g.sym(diagP.xCentre[i], diagP.yCentre[i], size, namn.ident[ii], 0.0, 0, false);
        }
        if (this.pred.neutral_pH && (diag.pInX == 1 || diag.pInY == 1)) {
            if (Double.isNaN(diag.temperature)) {
                this.pred.showMsg("Error: Neutral pH line requested but temperature NOT available.", 0);
            } else {
                double pHn;
                try {
                    pHn = this.n_pH(diag.temperature);
                }
                catch (Chem.ChemicalParameterException ex) {
                    this.pred.showMsg(ex);
                    pHn = -1.0;
                }
                catch (Interpolate.RationalInterpolationException ex) {
                    this.pred.showMsg(ex);
                    pHn = -1.0;
                }
                if (pHn > 0.0) {
                    g.setLabel("-- DOT LINE: neutral pH --");
                    g.moveToDrawTo(0.0f, 0.0f, 0);
                    g.setPen(3);
                    g.setPen(-3);
                    g.lineType(5);
                    double[] lineX = new double[2];
                    double[] lineY = new double[2];
                    if (diag.pInX == 1) {
                        lineX[0] = pHn;
                        lineX[1] = pHn;
                        lineY[0] = diagP.yTop;
                        lineY[1] = diagP.yBottom;
                    } else {
                        lineX[0] = diagP.xLeft;
                        lineY[1] = diagP.xRight;
                        lineY[0] = pHn;
                        lineY[1] = pHn;
                    }
                    g.line(lineX, lineY);
                    g.lineType(0);
                }
            }
        }
        if (diag.pInX > 0 && diag.pInY > 0) {
            if (Double.isNaN(diag.temperature)) {
                this.pred.showMsg("Error: temperature NOT available in a pH/(pe or Eh) diagram.", 0);
            } else {
                double O2lgK;
                try {
                    O2lgK = this.O2_logK(diag.temperature);
                }
                catch (Chem.ChemicalParameterException ex) {
                    this.pred.showMsg(ex);
                    O2lgK = -1.0;
                }
                catch (Interpolate.RationalInterpolationException ex) {
                    this.pred.showMsg(ex);
                    O2lgK = -1.0;
                }
                if (O2lgK > 0.0) {
                    g.setLabel("-- DASH LINES: O2(g) and H2(g) = 1 atm --");
                    g.moveToDrawTo(0.0f, 0.0f, 0);
                    g.setPen(4);
                    g.setPen(-5);
                    g.lineType(1);
                    double[] line_pH = new double[2];
                    double[] line_O2 = new double[2];
                    double[] line_H2 = new double[2];
                    line_pH[0] = -10.0;
                    line_pH[1] = 20.0;
                    w1 = diag.pInX == 3 || diag.pInY == 3 ? this.pred.peEh : 1.0;
                    line_O2[0] = (0.25 * O2lgK - line_pH[0]) * w1;
                    line_O2[1] = (0.25 * O2lgK - line_pH[1]) * w1;
                    line_H2[0] = -line_pH[0] * w1;
                    line_H2[1] = -line_pH[1] * w1;
                    if (Util.isProton(namn.identC[diag.compX])) {
                        g.line(line_pH, line_O2);
                        g.line(line_pH, line_H2);
                    } else {
                        g.line(line_O2, line_pH);
                        g.line(line_H2, line_pH);
                    }
                    g.lineType(0);
                }
            }
        }
        g.setLabel("-- HEADING --");
        g.setPen(1);
        g.setPen(-1);
        float headColumnX = 0.5f * heightAx;
        int headRow = 0;
        int headRowMax = Math.max(2, (1 + cs.Na) / 2);
        yP = yMx + 0.5f * heightAx;
        float yPMx = yMx;
        for (j = 0; j < cs.Na; ++j) {
            String value;
            double w;
            if (dgrC.hur[j] != 1 && dgrC.hur[j] != 4 || dgrC.hur[j] == 4 && Util.isWater(namn.ident[j])) continue;
            int i = namn.iel[j];
            yP += 2.0f * heightAx;
            if (++headRow == headRowMax) {
                headColumnX += 33.0f * heightAx;
                yP = yMx + 2.5f * heightAx;
            }
            yPMx = Math.max(yPMx, yP);
            if (dgrC.hur[j] == 1) {
                w = csC.tot[j];
                double wa = Math.abs(w);
                String units = "M";
                if (wa < 1.0 && wa >= 9.999E-5) {
                    w *= 1000.0;
                    units = "mM";
                } else if (wa < 9.999E-5 && wa >= 9.999E-8) {
                    w *= 1000000.0;
                    units = "$M";
                } else if (wa < 9.999E-8 && wa >= 9.999E-11) {
                    w *= 1.0E9;
                    units = "nM";
                } else if (wa < 9.999E-11) {
                    units = " ";
                }
                value = wa <= 9999.9 && wa >= 9.999E-11 || wa < 1.0E-99 ? String.format(engl, "=%8.2f ", Float.valueOf((float)w)) + units : String.format(engl, "=%10.2e M", Float.valueOf((float)w));
                t = "[" + namn.ident[i] + "]`TOT' " + value;
            } else {
                String c;
                boolean volt = false;
                if (Util.isElectron(namn.ident[j])) {
                    w = -dgrC.cLow[j];
                    if (diag.Eh) {
                        c = "E`H' = ";
                        w *= this.pred.peEh;
                        volt = true;
                    } else {
                        c = "pe =";
                    }
                } else if (Util.isProton(namn.ident[i])) {
                    w = -dgrC.cLow[j];
                    c = "pH=";
                } else if (Util.isGas(namn.ident[i])) {
                    w = dgrC.cLow[j];
                    c = "Log P`" + namn.ident[i] + "' =";
                } else {
                    w = dgrC.cLow[j];
                    c = "Log {" + namn.ident[i] + "} =";
                }
                value = String.format(engl, "%7.2f", Float.valueOf((float)w));
                t = c + value;
                if (volt) {
                    t = t + " V";
                }
            }
            g.sym(headColumnX, yP, heightAx, t, 0.0f, -1, false);
        }
        if (!Double.isNaN(diag.ionicStrength) && Math.abs(diag.ionicStrength) > 1.0E-10) {
            g.setLabel("-- Ionic Strength --");
            g.setPen(-1);
            yP += 2.0f * heightAx;
            if (++headRow == headRowMax) {
                headColumnX += 33.0f * heightAx;
                yP = yMx + 2.5f * heightAx;
            }
            if (yP > yPMx + 0.1f * heightAx) {
                headColumnX = 0.5f * heightAx;
                yPMx = yP;
            }
            t = diag.ionicStrength > 0.0 ? String.format(engl, "I=%6.3f M", diag.ionicStrength) : "I= varied";
            g.sym(headColumnX, yP, heightAx, t, 0.0f, -1, false);
        }
        if (!Double.isNaN(diag.temperature) && diag.temperature > -1.0E-6) {
            g.setLabel("-- Temperature --");
            g.setPen(-1);
            t = String.format(engl, "t=%3d~C", Math.round((float)diag.temperature));
            double w = 7.0;
            g.sym((float)((double)xMx + w * (double)heightAx), 0.1f * heightAx, heightAx, t, 0.0f, -1, false);
        }
        yP = yPMx;
        headColumnX = (float)(0.5 * (double)heightAx);
        if (this.pred.aqu) {
            g.sym(headColumnX, yP += 2.0f * heightAx, heightAx, "(aqueous species only)", 0.0f, -1, false);
        }
        if (diag.oneArea >= 0) {
            g.sym(headColumnX, yP += 2.0f * heightAx, heightAx, "(one area only)", 0.0f, -1, false);
        }
        if (diag.title != null && diag.title.trim().length() > 0) {
            g.setLabel("-- TITLE --");
            g.setPen(2);
            g.setPen(-2);
            g.sym(0.0f, yPMx + 3.5f * heightAx, heightAx, diag.title, 0.0f, -1, false);
        }
        g.end();
    }

    private double n_pH(double t) throws Chem.ChemicalParameterException, Interpolate.RationalInterpolationException {
        return this.n_pH((float)t);
    }

    private float n_pH(float t) throws Chem.ChemicalParameterException, Interpolate.RationalInterpolationException {
        float[] temp = new float[]{0.0f, 25.0f, 60.0f, 100.0f, 150.0f, 200.0f, 250.0f, 300.0f, 350.0f};
        float[] logK = new float[]{14.949f, 14.0f, 13.038f, 12.271f, 11.658f, 11.325f, 11.216f, 11.39f, 11.93f};
        if (t < 0.0f || t > 350.0f) {
            throw new Chem.ChemicalParameterException(nl + "Error in procedure \"n_pH\":" + "  temperature = " + t + "\u00b0C (min=0, max=350).");
        }
        float npH = Interpolate.rationalInterpolation(temp, logK, t) / 2.0f;
        if (this.pred.dbg) {
            this.out.println("--- n_pH(" + t + ") = " + npH);
        }
        return npH;
    }

    private double O2_logK(double t) throws Chem.ChemicalParameterException, Interpolate.RationalInterpolationException {
        return this.O2_logK((float)t);
    }

    private float O2_logK(float t) throws Chem.ChemicalParameterException, Interpolate.RationalInterpolationException {
        float[] temp = new float[]{0.0f, 25.0f, 60.0f, 100.0f, 150.0f, 200.0f, 250.0f, 300.0f, 350.0f};
        float[] logK = new float[]{92.269f, 83.091f, 72.588f, 63.038f, 53.685f, 46.348f, 40.445f, 35.6f, 31.58f};
        if (t < 0.0f || t > 350.0f) {
            throw new Chem.ChemicalParameterException(nl + "Error in procedure \"O2_line\":" + "  temperature = " + t + "\u00b0C (min=0, max=350).");
        }
        float O2lgK = Interpolate.rationalInterpolation(temp, logK, t);
        if (this.pred.dbg) {
            this.out.println("--- O2_logK(" + t + ") = " + O2lgK);
        }
        return O2lgK;
    }
}

