/*
 * Decompiled with CFR 0.152.
 */
package lib.common;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.ActionMapUIResource;
import lib.common.ClassLocator;

public class Util {
    private static final String nl = System.getProperty("line.separator");
    private static JFileChooser fc;
    private static final NumberFormat nf;
    private static final NumberFormat nfe;
    private static final NumberFormat nfi;
    private static final DecimalFormat myFormatter;
    private static final DecimalFormat myFormatterExp;
    private static final DecimalFormat myFormatterInt;
    private static final String SLASH;

    public static int chargeOf(String speciesName) {
        int len = speciesName.length();
        if (len <= 1) {
            return 0;
        }
        IntPointer signPos = new IntPointer(-1);
        int lastCh = Util.getLastCharExcludingChargeAndSignPosition(speciesName, signPos);
        if (signPos.i < len - 3 || signPos.i <= 0) {
            return 0;
        }
        char sign = speciesName.charAt(signPos.i);
        int charge = sign == '+' ? 1 : -1;
        char ip1 = ' ';
        if (signPos.i < len - 1) {
            ip1 = speciesName.charAt(signPos.i + 1);
        }
        if (Character.isDigit(ip1)) {
            try {
                charge *= Integer.parseInt(speciesName.substring(signPos.i + 1).trim());
            }
            catch (NumberFormatException ex) {
                charge = 0;
            }
        } else if (ip1 == ' ') {
            int iz = 1;
            if (lastCh < signPos.i - 1) {
                try {
                    iz = Integer.parseInt(speciesName.substring(lastCh + 1, signPos.i).trim());
                }
                catch (NumberFormatException ex) {
                    iz = 1;
                }
            }
            charge *= iz;
        } else {
            charge = 0;
        }
        return charge;
    }

    public static boolean nameCompare(String spe1, String spe2) {
        int z2;
        if (spe1 == null) {
            return spe2 == null;
        }
        if (spe2 == null) {
            return false;
        }
        int z1 = Util.chargeOf(spe1);
        if (z1 != (z2 = Util.chargeOf(spe2))) {
            return false;
        }
        return Util.nameOf(spe1).equalsIgnoreCase(Util.nameOf(spe2));
    }

    public static String nameOf(String speciesName) {
        int lastCh;
        int len = speciesName.length();
        if (len <= 1) {
            return speciesName;
        }
        if (len > 4 && speciesName.toUpperCase().endsWith("(AQ)")) {
            return speciesName.substring(0, len - 4);
        }
        if (Character.isLetter(speciesName.charAt(len - 1))) {
            return speciesName;
        }
        IntPointer signPos = new IntPointer();
        for (lastCh = Util.getLastCharExcludingChargeAndSignPosition(speciesName, signPos); lastCh > 0 && Character.isWhitespace(speciesName.charAt(lastCh)); --lastCh) {
        }
        return speciesName.substring(0, lastCh + 1);
    }

    public static String bareNameOf(String speciesName) {
        int lastCh;
        int len = speciesName.length();
        if (len <= 1) {
            return speciesName;
        }
        if (len > 3 && (speciesName.toUpperCase().endsWith("(S)") || speciesName.toUpperCase().endsWith("(C)") || speciesName.toUpperCase().endsWith("(L)") || speciesName.toUpperCase().endsWith("(G)"))) {
            return speciesName.substring(0, len - 3);
        }
        if (len > 4 && (speciesName.toUpperCase().endsWith("(AQ)") || speciesName.toUpperCase().endsWith("(CR)") || speciesName.toUpperCase().endsWith("(AM)"))) {
            return speciesName.substring(0, len - 4);
        }
        if (len > 5 && speciesName.toUpperCase().endsWith("(VIT)")) {
            return speciesName.substring(0, len - 5);
        }
        if (Character.isLetter(speciesName.charAt(len - 1))) {
            return speciesName;
        }
        IntPointer signPos = new IntPointer();
        for (lastCh = Util.getLastCharExcludingChargeAndSignPosition(speciesName, signPos); lastCh > 0 && Character.isWhitespace(speciesName.charAt(lastCh)); --lastCh) {
        }
        return speciesName.substring(0, lastCh + 1);
    }

    public static boolean isProton(String t0) {
        if (t0 == null || t0.length() <= 1) {
            return false;
        }
        return t0.equals("H+") || t0.equals("H +");
    }

    public static boolean isElectron(String t0) {
        if (t0 == null || t0.length() <= 1) {
            return false;
        }
        String tu = t0.toUpperCase();
        return tu.equals("E-") || tu.equals("E -") || tu.equals("E\u2013") || tu.equals("E\u2212") || tu.equals("E \u2013") || tu.equals("E \u2212");
    }

    public static boolean isWater(String t0) {
        if (t0 == null || t0.length() <= 2) {
            return false;
        }
        return t0.equals("H2O") || t0.toUpperCase().equals("H2O(L)");
    }

    public static boolean isGas(String t0) {
        if (t0 == null || t0.length() <= 3) {
            return false;
        }
        return t0.toUpperCase().endsWith("(G)");
    }

    public static boolean isCation(String t0) {
        if (t0 == null || t0.length() <= 1) {
            return false;
        }
        return Util.chargeOf(t0) > 0;
    }

    public static boolean isAnion(String t0) {
        if (t0 == null || t0.length() <= 1) {
            return false;
        }
        return Util.chargeOf(t0) < 0;
    }

    public static boolean isSolid(String t0) {
        if (t0 == null || t0.length() <= 3) {
            return false;
        }
        String tU = t0.toUpperCase();
        if (tU.endsWith("(S)")) {
            return true;
        }
        if (tU.endsWith("(C)")) {
            return true;
        }
        if (tU.endsWith("(L)")) {
            return true;
        }
        if (t0.length() > 4) {
            if (tU.endsWith("(CR)")) {
                return true;
            }
            if (tU.endsWith("(AM)")) {
                return true;
            }
            if (tU.endsWith("(VIT)")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLiquid(String t0) {
        if (t0 == null || t0.length() <= 3) {
            return false;
        }
        return t0.toUpperCase().endsWith("(L)");
    }

    public static boolean isNeutralAqu(String t0) {
        if (t0 == null || t0.length() <= 0) {
            return false;
        }
        if (t0.length() > 4 && t0.toUpperCase().endsWith("(AQ)")) {
            return true;
        }
        if (Util.isWater(t0)) {
            return true;
        }
        if (t0.length() > 1 && Util.chargeOf(t0) != 0) {
            return false;
        }
        return !Util.isGas(t0) && !Util.isSolid(t0);
    }

    public static boolean is_cr_or_c_solid(String t0) {
        if (t0 == null || t0.length() <= 3) {
            return false;
        }
        String tU = t0.toUpperCase();
        if (tU.endsWith("(C)")) {
            return true;
        }
        return t0.length() > 4 && tU.endsWith("(CR)");
    }

    public static boolean is_cr_solid(String t0) {
        if (t0 == null || t0.length() <= 4) {
            return false;
        }
        String tU = t0.toUpperCase();
        return tU.endsWith("(CR)");
    }

    public static boolean is_c_solid(String t0) {
        if (t0 == null || t0.length() <= 3) {
            return false;
        }
        String tU = t0.toUpperCase();
        return tU.endsWith("(C)");
    }

    public static boolean areEqualDoubles(double w1, double w2) {
        if (Double.compare(w1, w2) == 0) {
            return true;
        }
        double CLOSE_TO_ZERO = 4.940656E-318;
        if (Double.isNaN(w1) && !Double.isNaN(w2) || !Double.isNaN(w1) && Double.isNaN(w2)) {
            return false;
        }
        if (Double.isInfinite(w1) && !Double.isInfinite(w2) || !Double.isInfinite(w1) && Double.isInfinite(w2)) {
            return false;
        }
        if (Math.abs(w1) < 4.940656E-318 && Math.abs(w2) > 4.940656E-318 || Math.abs(w2) < 4.940656E-318 && Math.abs(w1) > 4.940656E-318) {
            return false;
        }
        return Math.abs(w2 - w1) < Math.min(Math.abs(w1), Math.abs(w2)) * 1.0E-7;
    }

    public static boolean stringsEqual(String t1, String t2) {
        return t1 != null && t2 != null && t1.trim().equals(t2.trim()) || t1 == null && t2 == null;
    }

    public static void msg(String txt) {
        Util.exception(txt, ClassLocator.getCallerClassName(), Util.getCallingMethod(), false);
    }

    public static void exceptn(String txt) {
        Util.exception(txt, ClassLocator.getCallerClassName(), Util.getCallingMethod(), true);
    }

    public static void showErrMsg(Component parent, String msg, int type) {
        if (msg == null || msg.trim().length() <= 0) {
            return;
        }
        Util.exception(msg, ClassLocator.getCallerClassName(), Util.getCallingMethod(), false);
        msg = Util.wrapString(msg, 50);
        if (parent == null || !parent.isEnabled()) {
            System.out.println("--- showErrMsg: parent is \"null\" or not enabled");
            ErrMsgBx m = new ErrMsgBx(msg, null);
        } else {
            String title = parent instanceof Frame ? ((Frame)parent).getTitle() : (parent instanceof Dialog ? ((Dialog)parent).getTitle() : " Error:");
            int j = type == 2 ? 1 : (type == 3 ? 2 : 0);
            JOptionPane.showMessageDialog(parent, msg, title, j);
            parent.setCursor(new Cursor(0));
        }
    }

    public static String wrapString(String s, int maxLength) {
        String deliminator = "\n";
        StringBuilder result = new StringBuilder();
        for (String line : s.split(deliminator, -1)) {
            if (line.length() / (maxLength + 1) < 1) {
                result.append(line).append(deliminator);
                continue;
            }
            StringBuffer wrapLine = new StringBuffer();
            int lastdelimPos = 0;
            for (String token : line.trim().split("\\s+", -1)) {
                if (wrapLine.length() - lastdelimPos + token.length() > maxLength) {
                    wrapLine.append(deliminator).append("    ").append(token);
                    lastdelimPos = wrapLine.length() + 1;
                    continue;
                }
                if (wrapLine.length() <= 0) {
                    wrapLine.append(token);
                    continue;
                }
                wrapLine.append(" ").append(token);
            }
            result.append(wrapLine).append(deliminator);
            wrapLine = null;
        }
        return result.toString();
    }

    private static void exception(String msg, String callingClass, String callingMethod, boolean error) {
        String ERR_START = "============================";
        PrintStream ps = error ? System.err : System.out;
        ps.println("============================");
        boolean p = false;
        if (callingClass != null && callingClass.length() > 0) {
            ps.print(callingClass);
            p = true;
        }
        if (callingMethod != null && callingMethod.length() > 0) {
            if (p) {
                ps.print("$");
            }
            ps.print(callingMethod);
            p = true;
        }
        if (p) {
            ps.println();
        }
        if (msg == null || msg.length() <= 0) {
            msg = "Unknown error.";
        }
        ps.println(msg + nl + "============================");
        ps.flush();
    }

    private static String getCallingMethod() {
        boolean doNext = false;
        boolean xit = false;
        int n = 2;
        for (StackTraceElement s : Thread.currentThread().getStackTrace()) {
            if (doNext) {
                if (n == 0) {
                    return s.getMethodName();
                }
                --n;
                continue;
            }
            doNext = s.getMethodName().equals("getStackTrace");
        }
        return "unknown";
    }

    public static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String t = sw.toString();
            if (t != null && t.length() > 0) {
                int i = t.indexOf("Unknown Source");
                int j = t.indexOf("\n");
                if (i > 0 && i > j && (j = (t = t.substring(0, i)).lastIndexOf("\n")) > 0) {
                    t = t.substring(0, j) + nl;
                }
            }
            return "- - - - - -" + nl + t + "- - - - - -";
        }
        catch (Exception e2) {
            return "Internal error in \"stack2string(Exception e)\"";
        }
    }

    public static String formatNum(double num) {
        float f;
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            num = 0.0;
        }
        if ((double)(f = (float)Math.max(-3.4028234663852886E38, Math.min(3.4028234663852886E38, num))) == -0.0) {
            f = 0.0f;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(f);
        StringBuffer sb = sw.getBuffer();
        if (sb.charAt(0) != '-') {
            sb.insert(0, " ");
        }
        return sb.toString();
    }

    public static String formatNumAsInt(double num) {
        String textNum = Util.formatNum(num);
        int p = textNum.indexOf(".");
        if (p > -1 && textNum.endsWith("0")) {
            int i = textNum.length() - 1;
            while (textNum.charAt(i) == '0') {
                --i;
            }
            textNum = textNum.substring(0, i + 1);
        }
        if (textNum.endsWith(".")) {
            return textNum.substring(0, textNum.length() - 1);
        }
        return textNum;
    }

    public static String formatDbl3(double num) {
        String textNum;
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            num = 0.0;
        }
        if (num == 0.0) {
            num = 0.0;
        }
        if (Math.abs(num) < 0.01 && num != 0.0 || Math.abs(num) > 9999.0) {
            myFormatterExp.applyPattern("0.0###E0");
            textNum = myFormatterExp.format(num);
        } else {
            myFormatter.applyPattern("####0.###");
            textNum = myFormatter.format(num);
        }
        if (textNum.startsWith("-")) {
            return textNum.trim();
        }
        return " " + textNum.trim();
    }

    public static String formatDbl4(double num) {
        String textNum;
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            num = 0.0;
        }
        if (num == 0.0) {
            num = 0.0;
        }
        if (Math.abs(num) < 0.001 && num != 0.0 || Math.abs(num) > 1000.0) {
            myFormatterExp.applyPattern("0.0###E0");
            textNum = myFormatterExp.format(num);
        } else {
            myFormatter.applyPattern("###0.####");
            textNum = myFormatter.format(num);
        }
        if (textNum.startsWith("-")) {
            return textNum.trim();
        }
        return " " + textNum.trim();
    }

    public static String formatDbl6(double num) {
        String textNum;
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            num = 0.0;
        }
        if (num == 0.0) {
            num = 0.0;
        }
        if (Math.abs(num) < 0.001 && num != 0.0 || Math.abs(num) > 1000.0) {
            myFormatterExp.applyPattern("0.0#####E0");
            textNum = myFormatterExp.format(num);
        } else {
            myFormatter.applyPattern("###0.######");
            textNum = myFormatter.format(num);
        }
        if (textNum.startsWith("-")) {
            return textNum.trim();
        }
        return " " + textNum.trim();
    }

    public static String formatInt(int num) {
        String textNum;
        if (num == 0) {
            num = 0;
        }
        if ((textNum = myFormatterInt.format(num)).startsWith("-")) {
            return textNum.trim();
        }
        return " " + textNum.trim();
    }

    public static void throwErr(Integer n) {
        int a = n * 2;
    }

    public static void configureOptionPane() {
        if (UIManager.getLookAndFeelDefaults().get("OptionPane.actionMap") == null) {
            UIManager.put("OptionPane.windowBindings", new Object[]{"ESCAPE", "close", "LEFT", "left", "KP_LEFT", "left", "RIGHT", "right", "KP_RIGHT", "right"});
            ActionMapUIResource map = new ActionMapUIResource();
            map.put("close", new OptionPaneCloseAction());
            map.put("left", new OptionPaneArrowAction(false));
            map.put("right", new OptionPaneArrowAction(true));
            UIManager.getLookAndFeelDefaults().put("OptionPane.actionMap", map);
        }
    }

    public static String getSaveFileName(Component parent, String progr, String title, int type, String defName, String path) {
        boolean mustExist = false;
        boolean openF = false;
        boolean filesOnly = true;
        return Util.getFileName(parent, progr, openF, mustExist, filesOnly, title, type, defName, path);
    }

    public static String getOpenFileName(Component parent, String progr, boolean mustExist, String title, int type, String defName, String path) {
        boolean openF = true;
        boolean filesOnly = true;
        return Util.getFileName(parent, progr, openF, mustExist, filesOnly, title, type, defName, path);
    }

    public static String getFileName(Component parent, String progr, boolean openF, boolean mustExist, boolean filesOnly, String title, int type, String defName, String path) {
        int answer;
        Object[] opt;
        parent.setCursor(new Cursor(3));
        fc = path != null && path.length() > 0 ? new JFileChooser(path) : new JFileChooser(".");
        fc.setMultiSelectionEnabled(false);
        File currDir = null;
        if (path != null && path.trim().length() > 0) {
            currDir = new File(path);
        }
        if (currDir == null || !currDir.exists()) {
            currDir = new File(".");
        }
        fc.setCurrentDirectory(currDir);
        if (title != null && title.trim().length() > 0) {
            fc.setDialogTitle(title);
        } else {
            fc.setDialogTitle("Enter a file name");
        }
        if (filesOnly) {
            fc.setFileSelectionMode(0);
        } else {
            fc.setFileSelectionMode(2);
        }
        fc.setAcceptAllFileFilterUsed(true);
        if (defName != null && defName.trim().length() > 0) {
            File defFile = new File(defName);
            fc.setSelectedFile(defFile);
        }
        FileNameExtensionFilter filter1 = null;
        FileNameExtensionFilter filter2 = null;
        FileNameExtensionFilter filter3 = null;
        String osName = System.getProperty("os.name");
        String[] ext = null;
        if (type == 1) {
            if (osName.startsWith("Mac OS")) {
                ext = new String[]{"APP", "JAR"};
                filter1 = new FileNameExtensionFilter("Programs (*.app, *.jar)", ext);
            } else if (osName.startsWith("Windows")) {
                ext = new String[]{"EXE", "JAR"};
                filter1 = new FileNameExtensionFilter("Programs (*.exe, *.jar)", ext);
            } else {
                ext = new String[]{"JAR"};
                filter1 = new FileNameExtensionFilter("Programs (*.jar)", ext);
            }
        } else if (type == 2) {
            ext = new String[]{"DB", "TXT", "SKV", "CSV"};
            filter1 = new FileNameExtensionFilter("Data bases (*.db, *.txt, *.skv, *.csv)", ext);
            filter2 = new FileNameExtensionFilter("Text files (*.txt, *.skv, *.csv)", "TXT", "SKV", "CSV");
            filter3 = new FileNameExtensionFilter("Binary files (*.db)", "DB");
        } else if (type == 3) {
            ext = new String[]{"TXT", "SKV", "CSV"};
            filter1 = new FileNameExtensionFilter("Text databases (*.txt, *.skv, *.csv)", ext);
        } else if (type == 4) {
            ext = new String[]{"DB"};
            filter1 = new FileNameExtensionFilter("Binary databases (*.db)", ext);
        } else if (type == 5) {
            ext = new String[]{"DAT"};
            filter1 = new FileNameExtensionFilter("*.dat", ext);
        } else if (type == 6) {
            ext = new String[]{"PLT"};
            filter1 = new FileNameExtensionFilter("*.plt", ext);
        } else if (type == 7) {
            ext = new String[]{"TXT"};
            filter1 = new FileNameExtensionFilter("*.txt", ext);
        } else if (type == 8) {
            ext = new String[]{"PDF"};
            filter1 = new FileNameExtensionFilter("*.pdf", ext);
        } else if (type == 9) {
            ext = new String[]{"PS"};
            filter1 = new FileNameExtensionFilter("*.ps", ext);
        } else if (type == 10) {
            ext = new String[]{"EPS"};
            filter1 = new FileNameExtensionFilter("*.eps", ext);
        } else if (type == 11) {
            ext = new String[]{"INI"};
            filter1 = new FileNameExtensionFilter("*.ini", ext);
        }
        LookAndFeel oldLaF = UIManager.getLookAndFeel();
        boolean resetLaF = false;
        if (!oldLaF.getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(System);");
                fc.updateUI();
                resetLaF = true;
            }
            catch (Exception ex) {
                System.out.println("--- setLookAndFeel: " + ex.getMessage());
            }
        }
        parent.setCursor(new Cursor(0));
        if (filter3 != null) {
            fc.addChoosableFileFilter(filter3);
        }
        if (filter2 != null) {
            fc.addChoosableFileFilter(filter2);
        }
        if (filter1 != null) {
            fc.setFileFilter(filter1);
        }
        int returnVal = openF ? fc.showOpenDialog(parent) : fc.showSaveDialog(parent);
        if (resetLaF) {
            try {
                UIManager.setLookAndFeel(oldLaF);
                System.out.println("--- setLookAndFeel(oldLookAndFeel);");
            }
            catch (UnsupportedLookAndFeelException ex) {
                System.out.println("--- setLookAndFeel: UnsupportedLookAndFeelException!");
            }
            System.out.println("--- configureOptionPane();");
            Util.configureOptionPane();
        }
        if (returnVal != 0) {
            return null;
        }
        File userFile = fc.getSelectedFile();
        if (userFile == null) {
            System.err.println("--- Error: selected file is \"null\"?");
            return null;
        }
        if (osName.startsWith("Mac OS") && userFile.getName().toLowerCase().endsWith(".app")) {
            String n = userFile.getName();
            n = n.substring(0, n.length() - 4) + ".jar";
            File f = new File(userFile.getAbsolutePath() + SLASH + "Contents" + SLASH + "Resources" + SLASH + "Java" + SLASH + n);
            if (f.exists()) {
                userFile = f;
            }
        }
        boolean issueWarning = false;
        if (ext != null && ext.length > 0) {
            String userFNU = userFile.getName().toUpperCase();
            boolean extOk = false;
            String xt = ext[0];
            if (xt != null && xt.length() > 0 && userFNU.endsWith("." + xt)) {
                extOk = true;
            }
            if (!extOk && ext.length > 1) {
                for (int i = 1; i < ext.length; ++i) {
                    xt = ext[i];
                    if (xt == null || xt.length() <= 0 || !userFNU.endsWith("." + xt)) continue;
                    extOk = true;
                    break;
                }
            }
            boolean dot = userFNU.contains(".");
            if (type == 1 && !osName.startsWith("Windows") && !dot) {
                extOk = true;
            }
            if (!extOk) {
                if (userFile.getName().contains(".")) {
                    issueWarning = true;
                }
                for (String x : ext) {
                    File f = new File(userFile.getAbsolutePath() + "." + x.toLowerCase());
                    if (!f.exists()) continue;
                    userFile = f;
                    extOk = true;
                    issueWarning = false;
                    break;
                }
                if (!extOk) {
                    userFile = new File(userFile.getAbsolutePath() + "." + ext[0].toLowerCase());
                    if (openF && mustExist && userFile.exists()) {
                        issueWarning = false;
                    }
                }
            }
        }
        if (progr == null || progr.trim().length() <= 0) {
            progr = "(Enter a file name)";
        }
        if (issueWarning) {
            opt = new Object[]{"OK", "Cancel"};
            answer = JOptionPane.showOptionDialog(parent, "Note: file name must end with \"" + ext[0] + "\"" + nl + nl + "The file name is changed to:" + nl + "\"" + userFile.getName() + "\"", progr, 0, 2, null, opt, opt[1]);
            if (answer != 0) {
                return null;
            }
        }
        if (!openF) {
            if (userFile.exists()) {
                opt = new Object[]{"Yes", "No"};
                answer = JOptionPane.showOptionDialog(parent, "File \"" + userFile.getName() + "\" already exists," + nl + "Overwrite?", progr, 0, 2, null, opt, opt[1]);
                if (answer != 0) {
                    return null;
                }
            }
            if (userFile.exists() && !userFile.canWrite()) {
                JOptionPane.showMessageDialog(parent, "Can not overwrite file \"" + userFile.getName() + "\"." + nl + "The file or the directory is perhpas write-protected.", progr, 0);
                return null;
            }
        } else {
            if (mustExist && !userFile.exists()) {
                JOptionPane.showMessageDialog(parent, "File \"" + userFile.getName() + "\"" + nl + "does Not exist.", progr, 0);
                return null;
            }
            if (userFile.exists() && !userFile.canRead()) {
                JOptionPane.showMessageDialog(parent, "Can not read file \"" + userFile.getName() + "\"." + nl + "The file or the directory is perhpas read-protected.", progr, 0);
                return null;
            }
        }
        String s = userFile.getAbsolutePath();
        s = s.substring(0, s.length() - 3) + s.substring(s.length() - 3).toLowerCase();
        return s;
    }

    public static boolean isKeyPressedOK(KeyEvent evt) {
        if (evt.isControlDown() && (evt.getKeyCode() == 86 || evt.getKeyCode() == 88 || evt.getKeyCode() == 72)) {
            return false;
        }
        if (evt.getKeyCode() == 10) {
            return false;
        }
        if (evt.getKeyCode() == 9) {
            return false;
        }
        if (evt.getKeyCode() == 127) {
            return false;
        }
        return evt.getKeyCode() != 8;
    }

    public static String rTrim(String text) {
        if (text == null) {
            return text;
        }
        int idx = text.length() - 1;
        if (idx >= 0) {
            while (idx >= 0 && Character.isWhitespace(text.charAt(idx))) {
                --idx;
            }
            if (idx < 0) {
                return "";
            }
            return text.substring(0, idx + 1);
        }
        return text;
    }

    private static int getLastCharExcludingChargeAndSignPosition(String speciesName, IntPointer signPos) {
        int len = Util.rTrim(speciesName).length();
        char c = speciesName.charAt(len - 1);
        if (c != '+' && c != '-' && c != '\u2013' && c != '\u2212' && c < '0' | c > '9') {
            signPos.i = -1;
            return len - 1;
        }
        signPos.i = -1;
        for (int ik = len - 1; ik >= 0; --ik) {
            char sign = speciesName.charAt(ik);
            if (sign != '+' && sign != '-' && sign != '\u2013' && sign != '\u2212') continue;
            signPos.i = ik;
            break;
        }
        if (signPos.i < len - 3 || signPos.i <= 0) {
            signPos.i = -1;
            return len - 1;
        }
        int lastCh = signPos.i - 1;
        char ip1 = ' ';
        if (signPos.i < len - 1) {
            ip1 = speciesName.charAt(signPos.i + 1);
        }
        if (ip1 == ' ') {
            if (Character.isDigit(speciesName.charAt(lastCh)) && signPos.i >= 3) {
                char im2 = speciesName.charAt(signPos.i - 2);
                if (im2 == ' ') {
                    lastCh = signPos.i - 3;
                } else if (signPos.i >= 4 && Character.isDigit(im2) && speciesName.charAt(signPos.i - 3) == ' ') {
                    lastCh = signPos.i - 4;
                }
            }
        } else if (Character.isDigit(ip1)) {
            if (!(signPos.i == len - 2 || signPos.i == len - 3 && Character.isDigit(speciesName.charAt(len - 1)))) {
                lastCh = len - 1;
            }
        } else {
            lastCh = len - 1;
        }
        return lastCh;
    }

    static {
        SLASH = File.separator;
        nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nfe = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nfi = NumberFormat.getNumberInstance(Locale.ENGLISH);
        myFormatter = (DecimalFormat)nf;
        myFormatter.setGroupingUsed(false);
        myFormatter.setDecimalSeparatorAlwaysShown(false);
        myFormatter.applyPattern("###0.###");
        myFormatterExp = (DecimalFormat)nfe;
        myFormatterExp.setGroupingUsed(false);
        myFormatterExp.setDecimalSeparatorAlwaysShown(false);
        myFormatterExp.applyPattern("0.0##E0");
        myFormatterInt = (DecimalFormat)nfi;
        myFormatterInt.setGroupingUsed(false);
        myFormatterInt.setDecimalSeparatorAlwaysShown(false);
        myFormatterInt.applyPattern("##########0");
    }

    private static class IntPointer {
        public int i;

        public IntPointer() {
        }

        public IntPointer(int j) {
            this.i = j;
        }
    }

    private static class OptionPaneArrowAction
    extends AbstractAction {
        private boolean myMoveRight;

        OptionPaneArrowAction(boolean moveRight) {
            this.myMoveRight = moveRight;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane optionPane = (JOptionPane)e.getSource();
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eq.postEvent(new KeyEvent(optionPane, 401, e.getWhen(), this.myMoveRight ? 0 : 64, 9, '\uffff', 0));
        }
    }

    private static class OptionPaneCloseAction
    extends AbstractAction {
        private OptionPaneCloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane optionPane = (JOptionPane)e.getSource();
            optionPane.setValue(-1);
        }
    }

    static class ErrMsgBx {
        public ErrMsgBx(String msg, String title) {
            if (msg == null || msg.trim().length() <= 0) {
                System.err.println("--- MsgBox: null or empty \"message\".");
                return;
            }
            if (title == null || title.length() <= 0) {
                title = " Error:";
            }
            Frame frame = new Frame(title);
            String iconName = "images/ErrMsgBx.gif";
            URL imgURL = this.getClass().getResource(iconName);
            if (imgURL != null) {
                frame.setIconImage(new ImageIcon(imgURL).getImage());
            } else {
                System.err.println("--- Error in MsgBox constructor: Could not load image = \"" + iconName + "\"");
            }
            frame.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int left = Math.max(55, (screenSize.width - frame.getWidth()) / 2);
            int top = Math.max(10, (screenSize.height - frame.getHeight()) / 2);
            frame.setLocation(Math.min(screenSize.width - 100, left), Math.min(screenSize.height - 100, top));
            String msgText = msg.trim();
            frame.setVisible(true);
            MsgBoxDialog msgBox = new MsgBoxDialog(frame, msgText, title, true);
            msgBox.setVisible(true);
            msgBox.dispose();
            frame.setVisible(false);
            frame.dispose();
        }

        private static class MsgBoxDialog
        extends Dialog {
            private Button ok;
            private Panel p;
            private final TextArea text;

            public MsgBoxDialog(Frame parent, String msg, String title, boolean modal) {
                super(parent, " " + title, modal);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        MsgBoxDialog.this.setVisible(false);
                    }
                });
                this.setLayout(new BorderLayout());
                this.p = new Panel();
                this.p.setLayout(new FlowLayout(1));
                this.ok = new Button();
                int wMax = 85;
                int hMax = 20;
                int wMin = 5;
                boolean hMin = true;
                int w = 5;
                int h = 1;
                int i = 0;
                int j = 5;
                String eol = "\n";
                String nl = System.getProperty("line.separator");
                do {
                    char c;
                    String s;
                    if ((s = String.valueOf(c = msg.charAt(i))).equals("\n") || s.equals(nl)) {
                        ++h;
                        j = 5;
                        continue;
                    }
                    w = Math.max(++j, w);
                } while (++i < msg.length() - 1);
                int scroll = 3;
                if (w > 85 && h <= 20) {
                    scroll &= 2;
                }
                if (h > 20 && w <= 85) {
                    scroll &= 1;
                }
                if (w > 85 && h > 20) {
                    scroll = 0;
                }
                w = Math.min(Math.max(w, 10), 85);
                h = Math.min(h, 20);
                this.text = new TextArea(msg, h, w, scroll);
                this.text.setEditable(false);
                this.text.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                        if (evt.getKeyCode() == 9) {
                            MsgBoxDialog.this.ok.requestFocusInWindow();
                        }
                    }
                });
                this.text.setBackground(Color.WHITE);
                this.text.setFont(new Font("monospaced", 0, 12));
                this.add((Component)this.text, "Center");
                this.ok.setLabel("OK");
                this.ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MsgBoxDialog.this.closeDialog();
                    }
                });
                this.ok.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                    }
                });
                this.p.add(this.ok);
                this.add((Component)this.p, "South");
                this.pack();
                this.ok.requestFocusInWindow();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int left = Math.max(55, (screenSize.width - this.getWidth()) / 2);
                int top = Math.max(10, (screenSize.height - this.getHeight()) / 2);
                this.setLocation(Math.min(screenSize.width - 100, left), Math.min(screenSize.height - 100, top));
            }

            private void closeDialog() {
                this.setVisible(false);
            }
        }
    }
}

