/*
 * Decompiled with CFR 0.152.
 */
package plotPS;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;

public class PlotPS {
    private static final String progName = "PlotPS";
    private static final String VERS = "2014-Jan-31";
    private static boolean started = false;
    private boolean dbg = false;
    private boolean doNotStop = false;
    private File pltFile;
    private String psFile_name;
    private File psFile;
    private boolean finished = false;
    private BufferedReader bufReader;
    private OutputStreamWriter outputFile;
    private boolean delete = false;
    private static final String nl = System.getProperty("line.separator");
    private static final String SLASH = File.separator;
    private static final String DASH_LINE = "- - - - - -";
    private static final Locale engl = Locale.ENGLISH;
    private String[] colours = new String[11];
    private final double[] WIDTHS = new double[]{2.82, 6.35, 0.07, 1.06};
    private boolean eps = false;
    private BoundingBox boundingBox;
    private int penNow = 0;
    private int colorNow = 0;
    private int penOld = -1;
    private int colorOld = -1;
    private int pathCounter = 0;
    private double scaleX;
    private double scaleY;
    private double zx;
    private double zy;
    private double xNow = -1.7976931348623157E308;
    private double yNow = -1.7976931348623157E308;
    private double x1st = -1.7976931348623157E308;
    private double y1st = -1.7976931348623157E308;
    private int newPath = -1;
    private int fontSize = Integer.MIN_VALUE;
    private int fontSizeOld = -1;
    private boolean oldBold = false;
    private boolean psHeader = true;
    private int psColors = 1;
    private boolean psPortrait = true;
    private int psFont = 2;
    private final String[] FONTS = new String[]{"Vector graphics", "Times-Roman", "Helvetica", "Courier"};
    private int psSizeX = 100;
    private int psSizeY = 100;
    private double psMarginB = 0.0;
    private double psMarginL = 0.0;

    public static void main(String[] args) {
        PlotPS pp;
        boolean h = false;
        boolean doNotS = false;
        boolean debg = false;
        String msg = "GRAPHIC  \"PostScript\"  UTILITY                                   2014-Jan-31" + nl + "==============================" + nl;
        System.out.println(msg);
        if (args.length > 0) {
            for (String arg : args) {
                if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                    debg = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-nostop") || arg.equalsIgnoreCase("/nostop")) {
                    doNotS = true;
                    continue;
                }
                if (!arg.equals("-?") && !arg.equals("/?") && !arg.equals("?")) continue;
                h = true;
                PlotPS.printInstructions(System.out);
            }
            if (h) {
                return;
            }
        } else {
            String t = "This program will convert a plot file (*.plt) into a PS file." + nl + "Usage:   java -jar PlotPS.jar  [plot-file-name]  [-command=value]" + nl + "For a list of possible commands type:  java -jar PlotPS.jar  -?";
            System.out.println(t);
            ErrMsgBx mb = new ErrMsgBx(msg + nl + "Note: This is a console application." + nl + t, progName);
            System.exit(0);
        }
        try {
            pp = new PlotPS(debg, doNotS, args);
        }
        catch (Exception ex) {
            PlotPS.exception(ex, null, doNotS);
            pp = null;
        }
        if (pp != null) {
            final PlotPS p = pp;
            Thread t = new Thread(){

                @Override
                public void run() {
                    p.synchWaitConversion();
                    p.end_program();
                }
            };
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        System.out.println("All done." + nl + DASH_LINE);
        System.exit(0);
    }

    private void end_program() {
        this.finished = true;
        this.notify_All();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    private synchronized void synchWaitConversion() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public PlotPS(boolean debg, boolean doNotS, String[] args) {
        if (debg) {
            this.dbg = true;
        }
        this.doNotStop = doNotS;
        this.pltFile = null;
        this.psFile = null;
        String msg = null;
        boolean argErr = false;
        if (args != null && args.length > 0) {
            if (this.dbg) {
                System.out.println("Reading command-line arguments..." + nl);
            }
            for (int i = 0; i < args.length; ++i) {
                if (this.dbg) {
                    System.out.println("Command-line argument = \"" + args[i] + "\"");
                }
                if (i == 0 && !args[0].toLowerCase().startsWith("-p")) {
                    File f;
                    boolean ok = true;
                    String name = args[0];
                    if (name.startsWith("\"") && name.endsWith("\"")) {
                        name = name.substring(1, name.length() - 1);
                    }
                    if (!name.toLowerCase().endsWith(".plt")) {
                        name = name.concat(".plt");
                    }
                    if (!(f = new File(name)).exists()) {
                        if (this.dbg) {
                            System.out.println("Not a plt-file:  \"" + f.getAbsolutePath() + "\"");
                        }
                        ok = false;
                    }
                    if (ok && f.isDirectory()) {
                        msg = "Error: \"" + f.getAbsolutePath() + "\" is a directory.";
                        ok = false;
                    }
                    if (ok && !f.canRead()) {
                        msg = "Error: can not open file for reading:" + nl + "   \"" + f.getAbsolutePath() + "\"";
                        ok = false;
                    }
                    if (ok) {
                        if (this.dbg) {
                            System.out.println("Plot file: " + f.getPath());
                        }
                        this.pltFile = f;
                        continue;
                    }
                    if (msg != null) {
                        if (this.doNotStop) {
                            System.out.println(msg);
                        } else {
                            ErrMsgBx mb = new ErrMsgBx(msg, progName);
                        }
                    }
                }
                if (this.parseArg(args[i].trim())) continue;
                argErr = true;
                break;
            }
        }
        if (this.dbg) {
            System.out.println(nl + "Command-line arguments ended." + nl);
        }
        if (argErr) {
            this.end_program();
            return;
        }
        if (this.pltFile == null) {
            msg = "No plot file name given in the command-line.";
            if (this.doNotStop) {
                System.out.println(msg);
            } else {
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
            }
            this.end_program();
            return;
        }
        if (this.psFile_name != null && this.psFile_name.trim().length() > 0) {
            if (this.psFile_name.contains(SLASH)) {
                this.psFile = new File(this.psFile_name);
            } else {
                this.psFile = new File(this.pltFile.getParent(), this.psFile_name);
                if (this.dbg) {
                    msg = "PostScript-file: \"" + this.psFile.getAbsolutePath() + "\"" + nl;
                    if (this.eps) {
                        msg = "Encapsulated " + msg;
                    }
                    System.out.println(msg);
                }
            }
        }
        if (this.psFile == null) {
            String name = this.pltFile.getAbsolutePath();
            int n = name.length();
            name = name.substring(0, n - 4) + ".ps";
            this.psFile = new File(name);
            this.eps = false;
        }
        if (this.psFile.exists() && !this.psFile.canWrite()) {
            msg = "Error: can not write to file" + nl + "   \"" + this.psFile.toString() + "\"" + nl + "is the file locked?";
            if (this.doNotStop) {
                System.out.println(msg);
            } else {
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
            }
            this.end_program();
            return;
        }
        if (this.eps) {
            if (!this.psPortrait) {
                System.out.println("Warning: for Encapsulated PostScript the orientation is Portrait!");
                this.psPortrait = true;
            }
            if (Math.abs(this.psMarginB) > 0.001) {
                System.out.println("Warning: for Encapsulated PostScript the bottom margin is zero!");
            }
            if (Math.abs(this.psMarginL) > 0.001) {
                System.out.println("Warning: for Encapsulated PostScript the left margin is zero!");
            }
            this.psMarginB = 0.0;
            this.psMarginL = 0.0;
        }
        String o = "Portrait";
        if (!this.psPortrait) {
            o = "Landscape";
        }
        String c = "black on white";
        if (this.psColors == 1) {
            c = "colours";
        } else if (this.psColors == 2) {
            c = "colours selected in \"Spana\"";
        }
        System.out.println("plot file: " + this.maybeInQuotes(this.pltFile.getName()) + nl + "output file: " + this.maybeInQuotes(this.psFile.getName()) + nl + "options:" + nl + "   size " + this.psSizeX + "/" + this.psSizeY + " %;" + "    left, bottom margins = " + this.psMarginL + ", " + this.psMarginB + " cm" + nl + "   orientation = " + o + ";   font = " + this.FONTS[this.psFont] + nl + "   " + c);
        System.out.print("converting to ");
        if (this.eps) {
            System.out.print("encapsulated ");
        }
        System.out.println("PostScript ...");
        try {
            this.convert2PS();
        }
        catch (Exception ex) {
            PlotPS.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
        try {
            if (this.bufReader != null) {
                this.bufReader.close();
            }
        }
        catch (IOException ex) {
            PlotPS.exception(ex, "while closing file:" + nl + "   \"" + this.pltFile + "\"", this.doNotStop);
        }
        if (this.outputFile != null) {
            try {
                this.outputFile.flush();
                this.outputFile.close();
            }
            catch (IOException ex) {
                PlotPS.exception(ex, "while closing file:" + nl + "   \"" + this.psFile + "\"", this.doNotStop);
            }
        }
        if (this.delete) {
            this.psFile.delete();
        }
        this.end_program();
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseArg(String arg) {
        block60: {
            block66: {
                block65: {
                    block64: {
                        block63: {
                            block58: {
                                block62: {
                                    block61: {
                                        block59: {
                                            if (arg == null) {
                                                return true;
                                            }
                                            if (arg.length() <= 0) {
                                                return true;
                                            }
                                            if (arg.equals("-?") || arg.equals("/?") || arg.equals("?")) {
                                                PlotPS.printInstructions(System.out);
                                                return true;
                                            }
                                            msg = null;
                                            if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                                                this.dbg = true;
                                                System.out.println("Debug printout = true");
                                                return true;
                                            }
                                            if (arg.equalsIgnoreCase("-nostop") || arg.equalsIgnoreCase("/nostop")) {
                                                this.doNotStop = true;
                                                if (this.dbg) {
                                                    System.out.println("Do not show message boxes");
                                                }
                                                return true;
                                            }
                                            if (arg.equalsIgnoreCase("-bw") || arg.equalsIgnoreCase("/bw")) {
                                                if (this.dbg) {
                                                    System.out.println("Black on white");
                                                }
                                                this.psColors = 0;
                                                return true;
                                            }
                                            if (arg.equalsIgnoreCase("-noh") || arg.equalsIgnoreCase("/noh")) {
                                                if (this.dbg) {
                                                    System.out.println("No header");
                                                }
                                                this.psHeader = false;
                                                return true;
                                            }
                                            if (arg.equalsIgnoreCase("-clr") || arg.equalsIgnoreCase("/clr")) {
                                                if (this.dbg) {
                                                    System.out.println("Colours (default palette)");
                                                }
                                                this.psColors = 1;
                                                return true;
                                            }
                                            if (arg.equalsIgnoreCase("-clr2") || arg.equalsIgnoreCase("/clr2")) {
                                                if (this.dbg) {
                                                    System.out.println("Colours (\"Spana\" palette)");
                                                }
                                                this.psColors = 2;
                                                return true;
                                            }
                                            if (arg.length() <= 3) ** GOTO lbl-1000
                                            arg0 = arg.substring(0, 2).toLowerCase();
                                            if (!arg0.startsWith("-p") && !arg0.startsWith("/p")) break block58;
                                            if (arg.charAt(2) != '=' && arg.charAt(2) != ':') ** GOTO lbl-1000
                                            name = arg.substring(3);
                                            if (name.startsWith("\"") && name.endsWith("\"")) {
                                                name = name.substring(1, name.length() - 1);
                                            }
                                            if (!name.toLowerCase().endsWith(".plt")) {
                                                name = name.concat(".plt");
                                            }
                                            f = new File(name);
                                            name = f.getAbsolutePath();
                                            if ((f = new File(name)).exists()) break block59;
                                            msg = "Error: the plot file does not exist:" + PlotPS.nl + "   \"" + f.getAbsolutePath() + "\"";
                                            break block60;
                                        }
                                        if (!f.isDirectory()) break block61;
                                        msg = "Error: \"" + f.getAbsolutePath() + "\" is a directory.";
                                        break block60;
                                    }
                                    if (f.canRead()) break block62;
                                    msg = "Error: can not open file for reading:" + PlotPS.nl + "   \"" + f.getAbsolutePath() + "\"";
                                    break block60;
                                }
                                if (this.dbg) {
                                    System.out.println("Plot file: " + f.getPath());
                                }
                                this.pltFile = f;
                                return true;
                            }
                            if (!arg0.startsWith("-b") && !arg0.startsWith("/b")) break block63;
                            if (arg.charAt(2) != '=' && arg.charAt(2) != ':') ** GOTO lbl-1000
                            t = arg.substring(3);
                            try {
                                this.psMarginB = Double.parseDouble(t);
                                this.psMarginB = Math.min(20.0, Math.max(this.psMarginB, -5.0));
                                if (this.dbg) {
                                    System.out.println("Bottom margin = " + this.psMarginB);
                                }
                                return true;
                            }
                            catch (NumberFormatException nfe) {
                                msg = "Error: Wrong numeric format for bottom margin in text \"" + t + "\"";
                                this.psMarginB = NaN;
                            }
                            break block60;
                        }
                        if (!arg0.startsWith("-l") && !arg0.startsWith("/l")) break block64;
                        if (arg.charAt(2) != '=' && arg.charAt(2) != ':') ** GOTO lbl-1000
                        t = arg.substring(3);
                        try {
                            this.psMarginL = Double.parseDouble(t);
                            this.psMarginL = Math.min(20.0, Math.max(this.psMarginL, -5.0));
                            if (this.dbg) {
                                System.out.println("Left margin = " + this.psMarginL);
                            }
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            msg = "Error: Wrong numeric format for left margin in text \"" + t + "\"";
                            this.psMarginL = NaN;
                        }
                        break block60;
                    }
                    if (!arg0.startsWith("-s") && !arg0.startsWith("/s")) break block65;
                    if (arg.charAt(2) != '=' && arg.charAt(2) != ':') ** GOTO lbl-1000
                    t = arg.substring(3);
                    try {
                        size = Integer.parseInt(t);
                        size = Math.min(300, Math.max(size, 20));
                        if (this.dbg) {
                            System.out.println("Output size = " + size + " %");
                        }
                        this.psSizeX = size;
                        this.psSizeY = size;
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Error: Wrong numeric format for output size in text \"" + t + "\"";
                        this.psSizeX = size = 100;
                        this.psSizeY = size;
                    }
                    break block60;
                }
                if (!arg0.startsWith("-o") && !arg0.startsWith("/o")) break block66;
                if (arg.charAt(2) != '=' && arg.charAt(2) != ':') ** GOTO lbl-1000
                t = arg.substring(3).toLowerCase();
                if (t.equals("p")) {
                    this.psPortrait = true;
                } else if (t.equals("l")) {
                    this.psPortrait = false;
                }
                if (t.equals("p") || t.equals("l")) {
                    if (this.dbg) {
                        t = "Orientation = ";
                        t = this.psPortrait != false ? t + "Portrait" : t + "Landscape";
                        System.out.println(t);
                    }
                    return true;
                }
                msg = "Error: Wrong format for orientation in text \"" + t + "\"";
                break block60;
            }
            if ((arg0.startsWith("-f") || arg0.startsWith("/f")) && (arg.charAt(2) == '=' || arg.charAt(2) == ':')) {
                t = arg.substring(3);
                try {
                    f = Integer.parseInt(t);
                    if (f >= 1 && f <= 4) {
                        this.psFont = f - 1;
                        if (this.dbg) {
                            System.out.println("Output font = " + this.FONTS[this.psFont]);
                        }
                        return true;
                    }
                    msg = "Error: Wrong font type in text \"" + t + "\"";
                    this.psFont = 2;
                }
                catch (NumberFormatException nfe) {
                    msg = "Error: Wrong numeric format for output size in text \"" + t + "\"";
                    this.psFont = 2;
                }
            } else if (arg.length() > 4) {
                arg0 = arg.substring(0, 3).toLowerCase();
                if (arg0.startsWith("-sx") || arg0.startsWith("/sx")) {
                    if (arg.charAt(3) == '=' || arg.charAt(3) == ':') {
                        t = arg.substring(4);
                        try {
                            size = Integer.parseInt(t);
                            size = Math.min(300, Math.max(size, 20));
                            if (this.dbg) {
                                System.out.println("Output X-size = " + size + " %");
                            }
                            this.psSizeX = size;
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            msg = "Error: Wrong numeric format for output X-size in text \"" + t + "\"";
                            this.psSizeX = size = 100;
                        }
                    }
                } else if (arg0.startsWith("-sy") || arg0.startsWith("/sy")) {
                    if (arg.charAt(3) == '=' || arg.charAt(3) == ':') {
                        t = arg.substring(4);
                        try {
                            size = Integer.parseInt(t);
                            size = Math.min(300, Math.max(size, 20));
                            if (this.dbg) {
                                System.out.println("Output Y-size = " + size + " %");
                            }
                            this.psSizeY = size;
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            msg = "Error: Wrong numeric format for output Y-size in text \"" + t + "\"";
                            this.psSizeY = size = 100;
                        }
                    }
                } else if ((arg0.startsWith("-ps") || arg0.startsWith("/ps")) && (arg.charAt(3) == '=' || arg.charAt(3) == ':')) {
                    name = arg.substring(4);
                    if (name.startsWith("\"") && name.endsWith("\"")) {
                        name = name.substring(1, name.length() - 1);
                    }
                    if (!name.toLowerCase().endsWith(".ps") && !name.toLowerCase().endsWith(".eps")) {
                        name = name.concat(".ps");
                    }
                    if (name.toLowerCase().endsWith(".eps")) {
                        this.eps = true;
                    }
                    if (this.dbg) {
                        out = "PostScript file: " + name;
                        if (this.eps) {
                            out = "encapsulated " + out;
                        }
                        System.out.println(out);
                    }
                    this.psFile_name = name;
                    return true;
                }
            }
        }
        msg = msg == null ? "Error: can not understand command-line argument:" + PlotPS.nl + "  \"" + arg + "\"" : "Command-line argument \"" + arg + "\":" + PlotPS.nl + msg;
        if (this.doNotStop) {
            System.out.println(msg);
        } else {
            var3_3 = new ErrMsgBx(msg, "PlotPS");
        }
        System.out.println();
        PlotPS.printInstructions(System.out);
        return false;
    }

    private void convert2PS() {
        this.scaleX = (double)this.psSizeX / 100.0 + 1.0E-10;
        this.scaleY = (double)this.psSizeY / 100.0 + 1.0E-10;
        this.zx = this.psMarginL * 100.0;
        this.zy = this.psMarginB * 100.0;
        this.newPath = -1;
        this.x1st = -1.7976931348623157E308;
        this.y1st = -1.7976931348623157E308;
        try {
            this.outputFile = new OutputStreamWriter((OutputStream)new FileOutputStream(this.psFile), "ISO-8859-1");
        }
        catch (FileNotFoundException ex) {
            String msg = "File not found:" + nl + "   \"" + this.psFile.getAbsolutePath() + "\"";
            PlotPS.exception(ex, msg, this.doNotStop);
            return;
        }
        catch (UnsupportedEncodingException ex) {
            String msg = "while writing the PostScript file:" + nl + "   \"" + this.psFile.getAbsolutePath() + "\"";
            PlotPS.exception(ex, msg, this.doNotStop);
            return;
        }
        this.setPalette();
        if (this.eps) {
            this.boundingBox = this.getBoundingBox();
            if (this.boundingBox == null) {
                return;
            }
        }
        this.bufReader = PlotPS.getBufferedReader(this.pltFile, this.doNotStop);
        if (this.bufReader == null) {
            return;
        }
        this.psInit(this.outputFile);
        boolean readingText = false;
        int align = 0;
        int alignDef = 0;
        while (true) {
            String comment;
            String line;
            try {
                line = this.bufReader.readLine();
            }
            catch (IOException ex) {
                String msg = "while reading the plot file:" + nl + "   \"" + this.pltFile.getAbsolutePath() + "\"";
                PlotPS.exception(ex, msg, this.doNotStop);
                break;
            }
            if (line == null) break;
            String s0 = line.length() > 0 ? line.substring(0, 1).trim() : "";
            String s1 = line.length() > 4 ? line.substring(1, 5).trim() : "";
            String s2 = line.length() > 8 ? line.substring(5, 9).trim() : "";
            int i0 = s0.length() > 0 ? PlotPS.readInt(s0) : -1;
            int i1 = s1.length() > 0 ? PlotPS.readInt(s1) : 0;
            int i2 = s2.length() > 0 ? PlotPS.readInt(s2) : 0;
            if (line.length() > 9) {
                comment = line.substring(9).trim();
                if (comment.equals("TextEnd")) {
                    readingText = false;
                    continue;
                }
            } else {
                comment = "";
            }
            if (readingText) continue;
            if (comment.equals("-- HEADING --")) {
                alignDef = -1;
            }
            if (i0 != 0 && i0 != 1) {
                if (i0 != 5 && i0 != 8) continue;
                this.setPen(i0, i1, this.outputFile);
                continue;
            }
            if (this.psFont == 0 || i0 == 1 || !comment.startsWith("TextBegin")) {
                this.moveOrDraw(i0, i1, i2, this.outputFile);
                continue;
            }
            boolean isFormula = false;
            if (i0 != 0 || comment.length() <= 41 || !comment.startsWith("TextBegin")) continue;
            if (comment.substring(9, 10).equals("C")) {
                isFormula = true;
            }
            double txtSize = PlotPS.readDouble(comment.substring(17, 24));
            double txtAngle = PlotPS.readDouble(comment.substring(35, 42));
            if (comment.length() > 42) {
                String t = comment.substring(55, 56);
                if (t.equalsIgnoreCase("L")) {
                    align = -1;
                } else if (t.equalsIgnoreCase("R")) {
                    align = 1;
                } else if (t.equalsIgnoreCase("C")) {
                    align = 0;
                }
            } else {
                align = alignDef;
            }
            try {
                line = this.bufReader.readLine();
            }
            catch (IOException ex) {
                String msg = "while reading the plot file:" + nl + "   \"" + this.pltFile.getAbsolutePath() + "\"";
                PlotPS.exception(ex, msg, this.doNotStop);
                break;
            }
            if (line != null) {
                if (line.length() > 9) {
                    comment = PlotPS.rTrim(line.substring(9));
                    if (comment.startsWith(" ")) {
                        comment = comment.substring(1);
                    }
                } else {
                    comment = "";
                }
                this.printText(i1, i2, comment, isFormula, align, txtSize, txtAngle, this.outputFile);
            }
            readingText = true;
        }
        this.psEnd(this.outputFile);
    }

    private static BufferedReader getBufferedReader(File f, boolean noStop) {
        BufferedReader bufReader;
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
            bufReader = new BufferedReader(isr);
        }
        catch (FileNotFoundException ex) {
            String msg = "File not found:" + nl + "   \"" + f.getAbsolutePath() + "\"";
            PlotPS.exception(ex, msg, noStop);
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            String msg = "while reading the plot file:" + nl + "   \"" + f.getAbsolutePath() + "\"";
            PlotPS.exception(ex, msg, noStop);
            return null;
        }
        return bufReader;
    }

    private static int readInt(String t) {
        int i;
        try {
            i = Integer.parseInt(t);
        }
        catch (NumberFormatException ex) {
            System.out.println(DASH_LINE + nl + "Error: " + ex.toString() + nl + "   while reading an integer from String: \"" + t + "\"" + nl + DASH_LINE);
            i = 0;
        }
        return i;
    }

    private static double readDouble(String t) {
        double d;
        try {
            d = Double.parseDouble(t);
        }
        catch (NumberFormatException ex) {
            System.out.println(DASH_LINE + nl + "Error: " + ex.toString() + nl + "   while reading an floating-point number from String: \"" + t + "\"" + nl + DASH_LINE);
            d = 0.0;
        }
        return d;
    }

    private BoundingBox getBoundingBox() {
        System.out.println("calculating BoundingBox (for EPS) ...");
        BoundingBox bb = new BoundingBox();
        BufferedReader br = PlotPS.getBufferedReader(this.pltFile, this.doNotStop);
        if (br == null) {
            return null;
        }
        while (true) {
            float txtAngle;
            String line;
            try {
                line = br.readLine();
            }
            catch (IOException ex) {
                String msg = "while reading the plot file:" + nl + "   \"" + this.pltFile.getAbsolutePath() + "\"";
                PlotPS.exception(ex, msg, this.doNotStop);
                bb = null;
                break;
            }
            if (line == null) break;
            String s0 = line.length() > 0 ? line.substring(0, 1).trim() : "";
            String s1 = line.length() > 4 ? line.substring(1, 5).trim() : "";
            String s2 = line.length() > 8 ? line.substring(5, 9).trim() : "";
            int i0 = s0.length() > 0 ? PlotPS.readInt(s0) : -1;
            int i1 = s1.length() > 0 ? PlotPS.readInt(s1) : 0;
            int i2 = s2.length() > 0 ? PlotPS.readInt(s2) : 0;
            if (i0 < 0 || i0 > 1) continue;
            double x = (double)i1 * this.scaleX;
            double y = (double)i2 * this.scaleY;
            if (bb.xMx < x) {
                bb.xMx = x;
            }
            if (bb.yMx < y) {
                bb.yMx = y;
            }
            if (bb.xMn > x) {
                bb.xMn = x;
            }
            if (bb.yMn > y) {
                bb.yMn = y;
            }
            String comment = line.length() > 9 ? line.substring(9).trim() : "";
            if (i0 != 0 || comment.length() <= 41 || !comment.startsWith("TextBegin")) continue;
            float txtSize = PlotPS.readFloat(comment.substring(17, 24));
            for (txtAngle = PlotPS.readFloat(comment.substring(35, 42)); txtAngle > 360.0f; txtAngle -= 360.0f) {
            }
            while (txtAngle < -360.0f) {
                txtAngle += 360.0f;
            }
            if (txtAngle > 180.0f) {
                txtAngle -= 360.0f;
            }
            if (txtAngle < -180.0f) {
                txtAngle += 360.0f;
            }
            try {
                line = br.readLine();
            }
            catch (IOException ex) {
                String msg = "while reading the plot file:" + nl + "   \"" + this.pltFile.getAbsolutePath() + "\"";
                PlotPS.exception(ex, msg, this.doNotStop);
                bb = null;
                break;
            }
            if (line == null) break;
            if (line.length() > 9) {
                comment = PlotPS.rTrim(line.substring(9));
                if (comment.startsWith(" ")) {
                    comment = comment.substring(1);
                }
            } else {
                comment = "";
            }
            PlotPS.textBoxMinMax(i1, i2, txtSize * 100.0f, txtSize * 100.0f * (float)comment.length(), txtAngle, bb);
        }
        try {
            br.close();
        }
        catch (IOException ex) {
            PlotPS.exception(ex, null, this.doNotStop);
        }
        return bb;
    }

    private static float readFloat(String t) {
        float f;
        try {
            f = Float.parseFloat(t);
        }
        catch (NumberFormatException ex) {
            System.out.println(DASH_LINE + nl + "Error: " + ex.toString() + nl + "   while reading a \"float\" from String: \"" + t + "\"" + nl + DASH_LINE);
            f = 0.0f;
        }
        return f;
    }

    private static void textBoxMinMax(int i1, int i2, float height, float width, float angle, BoundingBox bb) {
        double DEG_2_RAD = 0.017453292519943;
        double a0 = (double)angle * 0.017453292519943;
        double a1 = (double)(angle + 90.0f) * 0.017453292519943;
        float h = height * 2.0f;
        float w = width;
        Point p0 = new Point();
        Point p1 = new Point();
        p0.x = i1 - (int)(height * (float)Math.cos(a1));
        p0.y = i2 - (int)(height * (float)Math.sin(a1));
        if ((double)p0.x < bb.xMn) {
            bb.xMn = p0.x;
        }
        if ((double)p0.x > bb.xMx) {
            bb.xMx = p0.x;
        }
        if ((double)p0.y < bb.yMn) {
            bb.yMn = p0.y;
        }
        if ((double)p0.y > bb.yMx) {
            bb.yMx = p0.y;
        }
        p0.x = i1 + (int)(w * (float)Math.cos(a0));
        p0.y = i2 + (int)(w * (float)Math.sin(a0));
        if ((double)p0.x < bb.xMn) {
            bb.xMn = p0.x;
        }
        if ((double)p0.x > bb.xMx) {
            bb.xMx = p0.x;
        }
        if ((double)p0.y < bb.yMn) {
            bb.yMn = p0.y;
        }
        if ((double)p0.y > bb.yMx) {
            bb.yMx = p0.y;
        }
        p1.x = p0.x + (int)(h * (float)Math.cos(a1));
        p1.y = p0.y + (int)(h * (float)Math.sin(a1));
        if ((double)p1.x < bb.xMn) {
            bb.xMn = p1.x;
        }
        if ((double)p1.x > bb.xMx) {
            bb.xMx = p1.x;
        }
        if ((double)p1.y < bb.yMn) {
            bb.yMn = p1.y;
        }
        if ((double)p1.y > bb.yMx) {
            bb.yMx = p1.y;
        }
        p0.x = i1 + (int)(h * (float)Math.cos(a1));
        p0.y = i2 + (int)(h * (float)Math.sin(a1));
        if ((double)p0.x < bb.xMn) {
            bb.xMn = p0.x;
        }
        if ((double)p0.x > bb.xMx) {
            bb.xMx = p0.x;
        }
        if ((double)p0.y < bb.yMn) {
            bb.yMn = p0.y;
        }
        if ((double)p0.y > bb.yMx) {
            bb.yMx = p0.y;
        }
    }

    private void psInit(OutputStreamWriter o) {
        String[] FONTN = new String[]{"Times-Roman", "Helvetica", "Courier"};
        String[] FONTBN = new String[]{"Times-Bold", "Helvetica-Bold", "Courier-Bold"};
        String[] FONTIN = new String[]{"Times-Italic", "Helvetica-Oblique", "Courier-Oblique"};
        try {
            String t = "%%Title: " + this.fixTextSimple(this.maybeInQuotes(this.pltFile.getName())) + "; ";
            if (!this.eps) {
                o.write("%!PS-Adobe-2.0" + nl);
                o.write(t + nl);
            } else {
                o.write("%!PS-Adobe-2.0 EPSF-2.0" + nl);
                o.write(t + nl);
            }
            o.write("%%Creator: PlotPS [java],  version: 2014-Jan-31" + nl);
            o.write("%%CreationDate: " + this.getDateTime() + nl);
            o.write("%%For: " + this.fixTextSimple(System.getProperty("user.name", "anonymous")) + nl);
            String or = "Portrait";
            if (!this.psPortrait) {
                or = "Landscape";
            }
            t = "%%DocumentNeededResources: font ";
            int n = this.psFont - 1;
            if (!this.eps) {
                if (this.psFont <= 2) {
                    t = t + "Courier ";
                }
                if (this.psFont > 0) {
                    o.write(t + FONTN[n] + " " + FONTBN[n] + " " + FONTIN[n] + nl);
                }
                o.write("%%Pages: 1" + nl);
            } else {
                if (this.psFont >= 1 && this.psFont <= 3) {
                    o.write(t + FONTN[n] + " " + FONTBN[n] + " " + FONTIN[n] + nl);
                }
                if (this.boundingBox.xMx <= -10000.0) {
                    this.boundingBox.xMx = 100.0;
                }
                if (this.boundingBox.yMx <= -10000.0) {
                    this.boundingBox.yMx = 100.0;
                }
                if (this.boundingBox.xMn >= this.boundingBox.xMx - 2.0) {
                    this.boundingBox.xMn = this.boundingBox.xMx - 100.0;
                }
                if (this.boundingBox.yMn >= this.boundingBox.yMx - 2.0) {
                    this.boundingBox.yMn = this.boundingBox.yMx - 100.0;
                }
                long ixMn = Math.round(this.boundingBox.xMn * 0.283465);
                long iyMn = Math.round(this.boundingBox.yMn * 0.283465);
                long ixMx = Math.round((this.boundingBox.xMx + 90.0) * 0.283465);
                long iyMx = Math.round((this.boundingBox.yMx + 90.0) * 0.283465);
                t = "%%BoundingBox: " + String.format("%8d", ixMn).trim() + " " + String.format("%8d", iyMn).trim() + " " + String.format("%8d", ixMx).trim() + " " + String.format("%8d", iyMx).trim();
                o.write(t + nl);
            }
            o.write("%%EndComments" + nl);
            if (this.eps) {
                o.write("% to change the \"BoundingBox\" given above: add margins in cm * 28.4" + nl);
            }
            o.write("%%BeginProlog" + nl + "% ------- Prolog:  defining procedures and variables -------" + nl);
            o.write("/ChemEqDict 60 dict def   % create a dictionary" + nl + "ChemEqDict begin          % push dictionary in dictionary stack" + nl + "/Mv {moveto} def" + nl + "/Ln {lineto} def" + nl + "/_sn {stroke newpath} def" + nl + "/_csn {closepath stroke newpath} def" + nl + "/_setWidth {/linWidth exch def linWidth setlinewidth}  def" + nl + "% --- dash-line types:" + nl + "/Lt0 {stroke linWidth setlinewidth [] 0 setdash} def" + nl + "/Lt1 {stroke linWidth setlinewidth [30 10] 0 setdash} def" + nl + "/Lt2 {stroke linWidth setlinewidth [15 15] 0 setdash} def" + nl + "/Lt3 {stroke linWidth setlinewidth [5 10] 0 setdash} def" + nl + "/Lt4 {stroke linWidth setlinewidth [30 10 5 10] 0 setdash } def" + nl + "/Lt5 {stroke linWidth setlinewidth [15 10 5 10] 0 setdash} def" + nl);
            if (this.psFont > 0 && this.psFont <= 3) {
                o.write("%--------------------  Font related stuff:  ---------------------------------" + nl + "/rShow {dup stringwidth pop 0 exch        % right-show" + nl + "        sub 0 rmoveto show} def" + nl + "/lShow {show} def                         % left-show" + nl + "/cShow {dup stringwidth pop -2 div -0.5   % center-show (both" + nl + "        getSize siz mul rmoveto show} def %  vertically & horizontally)" + nl + "/_angle 0 def                 % angle to rotate text" + nl + "/TxtRotate                    % Procedure to rotate text. Usage:" + nl + "    {gsave                    %   /_angle nn def  TxtRotate" + nl + "     currentpoint translate   %   x y moveto (text1) show" + nl + "     _angle rotate} def       %   x y moveto (text2) show  grestore" + nl + "/fontScale  1.40 def" + nl + "/_setSize     % scale current font (parameter: font size in 0.01 cm units)" + nl + "          {fontScale mul /UserFont currentfont def" + nl + "           /UserFont findfont exch scalefont setfont} def" + nl + "/getSize  {gsave newpath 0 0 moveto (X)       % find current font size" + nl + "           true charpath flattenpath pathbbox %   and store result in \"siz\"" + nl + "           /siz exch def pop pop pop grestore} def" + nl + "%----------------------------------------------------------------------------" + nl + "%          -----        additions for PostScript output            -----" + nl + "%          -----  which allow printing math and chemical formulas  -----" + nl + "%----------------------------------------------------------------------------" + nl + "% ---- super/sub-scripts." + nl + "%      Both \"^\" and \"_^\" take two arguments: the string to output and" + nl + "%      the vertical shift (positive or negative as fraction of letter" + nl + "%      size). The difference: \"_^\" does not advance the cursor (allowing" + nl + "%      subs- and super-scripts on the same letter)." + nl + "%      For example, to output UO2(CO3)3-4:" + nl + "%        (UO) show (2) -0.5 ^ (\\(CO) show (3) -0.5 ^" + nl + "%        (\\)) show (3) -0.5 ^ (4-) 0.5 _^" + nl + "%      \"_f\" takes one argument (spacing as fraction of letter size)" + nl + "%      and moves the cursor forward or backward. Useful in math formulas." + nl + "/^  {/regFont currentfont def /ssFont currentfont [.7 0 0 .7 0 0] makefont def" + nl + "    getSize dup 0 exch siz mul rmoveto ssFont setfont" + nl + "    exch show 0 exch siz neg mul rmoveto regFont setfont } def" + nl + "/_^ {/regFont currentfont def /ssFont currentfont [.7 0 0 .7 0 0] makefont def" + nl + "    getSize dup 0 exch siz mul rmoveto ssFont setfont" + nl + "    exch dup stringwidth pop neg exch show " + nl + "    0 rmoveto 0 exch siz neg mul rmoveto regFont setfont } def" + nl + "/_f {getSize siz mul 0 rmoveto} def" + nl + "%" + nl + "% ----- printing symbols and/or change to Bold and Italic." + nl + "%  *1*  bold, italics, etc:  \"_norm\", \"_bold\", \"_em\" and \"_sym\" take" + nl + "%       no arguments and they are used before a \"(text) show\"." + nl + "%       Because the Roman fonts use here the ISOLatin1 encoding," + nl + "%       one can plot some symbols with them.  Examples:" + nl + "%           _norm (normal) show _bold (bold) show _em (italics) show _norm" + nl + "%           _norm (T=25 \\260C, [Cu]=1\\265M) show" + nl + "%  *2*  the Symbol font may be used with octal codes (\\nnn)." + nl + "%       Example formula (- delta-r-Cp0m):" + nl + "%              _sym (-\\104) show _norm (r) -0.4 ^ 0.05 _f _em (C) show" + nl + "%              _sym (\\260) 0.3 _^ _norm (p,m) -0.4 ^" + nl + "%       another example (log_10 pCO2(g)):" + nl + "%              _norm (log) show (10) -0.4 ^ 0.1 _f _em (p) show" + nl + "%              _norm (CO) -0.4 ^ (2) -0.8 ^ (\\(g\\)) -0.4 ^" + nl + "%       Tables with the octal encoding vectors for the Roman and Symbol" + nl + "%       fonts are given in PostScript manuals." + nl + "%" + nl + "/_norm     {/" + FONTN[n] + " findfont dup length dict begin" + nl + "            {1 index /FID ne {def} {pop pop} ifelse} forall" + nl + "            /Encoding ISOLatin1Encoding def currentdict end" + nl + "            /UserFont exch definefont pop" + nl + "            getSize /UserFont findfont 1.43 siz mul scalefont setfont} def" + nl + "/_bold     {/" + FONTBN[n] + " findfont dup length dict begin" + nl + "            {1 index /FID ne {def} {pop pop} ifelse} forall" + nl + "            /Encoding ISOLatin1Encoding def currentdict end" + nl + "            /UserFont exch definefont pop" + nl + "            getSize /UserFont findfont 1.43 siz mul scalefont setfont} def" + nl + "/_em       {/" + FONTIN[n] + " findfont dup length dict begin" + nl + "            {1 index /FID ne {def} {pop pop} ifelse} forall" + nl + "            /Encoding ISOLatin1Encoding def currentdict end" + nl + "            /UserFont exch definefont pop" + nl + "            getSize /UserFont findfont 1.43 siz mul scalefont setfont} def" + nl + "/_sym      {getSize /Symbol findfont 1.43 siz mul scalefont setfont} def" + nl + "%" + nl);
            }
            o.write("end   % pop ChemEqDict from dictionary stack" + nl + "% ------------------------------- end Prolog --------------------------------" + nl + "%%EndProlog" + nl);
            if (!this.eps) {
                o.write("%%Page: 1 1" + nl);
            }
            t = "% size: ";
            t = this.psSizeX == this.psSizeY ? t + String.valueOf(this.psSizeX) : t + String.valueOf(this.psSizeX) + "/" + String.valueOf(this.psSizeY);
            String c = "black on white";
            if (this.psColors == 1) {
                c = "colours";
            } else if (this.psColors == 2) {
                c = "colours selected in \"Spana\"";
            }
            o.write("% ----------------------------- PlotPS options:" + nl + t + "%; left- and bottom-margin: " + this.psMarginL + " " + this.psMarginB + nl + "% " + c + ";   " + or.toLowerCase() + ";   font: " + this.FONTS[this.psFont] + nl);
            o.write("% ---- Initialize the page ----" + nl + "ChemEqDict begin  % push dictionary in dictionary stack" + nl + "gsave" + nl);
            if (!this.eps && this.psHeader) {
                o.write("% ----  print out file name, time and date" + nl + "/Courier findfont dup length dict begin" + nl + "        {1 index /FID ne {def} {pop pop} ifelse} forall" + nl + "        /Encoding ISOLatin1Encoding def currentdict end" + nl + "        /UserFont exch definefont pop" + nl + "        /UserFont findfont 8 scalefont setfont" + nl + "        ");
                o.write("30 770 moveto" + nl);
                t = "(file: " + this.fixTextSimple(this.maybeInQuotes(this.pltFile.getAbsolutePath())) + "   PostScripted: " + this.getDateTime() + ") show";
                o.write(t + nl);
            }
            int angle = 90;
            int x = 12;
            int y = -579;
            if (this.psPortrait) {
                angle = 0;
                x = 16;
                y = 12;
            }
            o.write("% ---- set landscape/portrait orientation" + nl + angle + " rotate " + x + " " + y + " translate" + nl);
            o.write("% ----  re-scale to 100 = 1 cm; (1 inch * 2.54) cm /72 points * 100" + nl + "0.283465 0.283465 scale" + nl + "1 setlinejoin  0 setgray  2.82 _setWidth    % set defaults for line drawing" + nl);
            if (this.psFont > 0) {
                o.write("% ---- set initial font size (0.35 cm). Needed before \"_norm\", \"rShow\", etc" + nl + "%      (which call \"getSize\", and require a font size)" + nl + "/" + FONTN[this.psFont - 1] + " findfont 35 scalefont setfont" + nl + "_norm" + nl);
            }
            o.write("%-------------------------- plot file starts here --------------------------" + nl);
        }
        catch (IOException ex) {
            PlotPS.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
    }

    private String getDateTime() {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        Date now = new Date();
        return df.format(now);
    }

    private void psEnd(OutputStreamWriter o) {
        try {
            o.write("stroke" + nl);
            o.write("%-------------------------- plot file ends here --------------------------" + nl);
            String t = "grestore" + nl + "end  % pop ChemEqDict from dictionary stack" + nl + "showpage" + nl + "%%Trailer" + nl + "%%EOF";
            o.write(t + nl);
            int eof = 4;
            if (!this.eps) {
                o.write((char)eof);
            }
        }
        catch (IOException ex) {
            PlotPS.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
    }

    private void setPalette() {
        if (this.psColors == 2) {
            boolean ok;
            File f;
            FileInputStream fis;
            block19: {
                fis = null;
                f = null;
                ok = false;
                Properties propertiesIni = new Properties();
                f = this.getSpana_Ini();
                if (f == null) {
                    System.out.println("Warning: could not find \"Spana.ini\"" + nl + "default colours will be used.");
                } else {
                    try {
                        fis = new FileInputStream(f);
                        propertiesIni.load(fis);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Warning: file Not found: \"" + f.getPath() + "\"" + nl + "default colours will be used.");
                        break block19;
                    }
                    catch (IOException e) {
                        System.out.println("Error: \"" + e.toString() + "\"" + nl + "   while loading file:" + nl + "   \"" + f.getPath() + "\"" + nl + "default colours will be used.");
                        break block19;
                    }
                    if (this.dbg) {
                        System.out.println("Reading colours from \"" + f.getPath() + "\".");
                    }
                    try {
                        for (int ii = 0; ii < this.colours.length; ++ii) {
                            String[] c = propertiesIni.getProperty("Disp_Colour[" + ii + "]").split(",");
                            int red = c.length > 0 ? Integer.parseInt(c[0]) : 0;
                            int green = c.length > 1 ? Integer.parseInt(c[1]) : 0;
                            int blue = c.length > 2 ? Integer.parseInt(c[2]) : 0;
                            float r = Math.max(0.0f, Math.min(1.0f, (float)Math.max(0, Math.min(255, red)) / 255.0f));
                            float g = Math.max(0.0f, Math.min(1.0f, (float)Math.max(0, Math.min(255, green)) / 255.0f));
                            float b = Math.max(0.0f, Math.min(1.0f, (float)Math.max(0, Math.min(255, blue)) / 255.0f));
                            String rt = (double)r < 1.0E-6 ? "0" : ((double)r > 0.999999 ? "1" : String.valueOf(r));
                            String gt = (double)g < 1.0E-6 ? "0" : ((double)g > 0.999999 ? "1" : String.valueOf(g));
                            String bt = (double)b < 1.0E-6 ? "0" : ((double)b > 0.999999 ? "1" : String.valueOf(b));
                            this.colours[ii] = (rt + " " + gt + " " + bt).trim();
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error: \"" + e.toString() + "\"" + nl + "   while loading file:" + nl + "   \"" + f.getPath() + "\"" + nl + "default colours will be used.");
                        break block19;
                    }
                    ok = true;
                }
            }
            if (!ok) {
                this.psColors = 1;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                String msg = "Error: " + e.toString();
                msg = f != null ? msg + nl + "while closing \"" + f.getPath() + "\"" : msg + nl + "while closing \"null\"";
                System.out.println(msg);
            }
        }
        if (this.psColors <= 0 || this.psColors > 2) {
            for (int i = 0; i < this.colours.length; ++i) {
                this.colours[i] = "0 0 0";
            }
            return;
        }
        if (this.psColors == 1) {
            this.colours[0] = "0 0 0";
            this.colours[1] = "1 0 0";
            this.colours[2] = "0.5843 0.2627 0";
            this.colours[3] = "0 0 1";
            this.colours[4] = "0 0.502 0";
            this.colours[5] = "0.7843 0.549 0";
            this.colours[6] = "1 0 1";
            this.colours[7] = "0 0 0.502";
            this.colours[8] = "0.502 0.502 0.502";
            this.colours[9] = "0 0.651 1";
            this.colours[10] = "0.502 0 1";
        }
        if (this.dbg) {
            System.out.println("Colours in use;");
            for (int ii = 0; ii < this.colours.length; ++ii) {
                System.out.println("  colour[" + ii + "] = \"" + this.colours[ii] + "\"");
            }
        }
    }

    private File getSpana_Ini() {
        String home;
        File p;
        ArrayList<String> dirs = new ArrayList<String>(6);
        String appD = System.getenv("APPDATA");
        if (appD != null && appD.trim().length() > 0 && (p = new File(appD)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        String homeDrv = System.getenv("HOMEDRIVE");
        String homePath = System.getenv("HOMEPATH");
        if (homePath != null && homePath.trim().length() > 0 && !homePath.startsWith(SLASH)) {
            homePath = SLASH + homePath;
        }
        if (homeDrv != null && homeDrv.trim().length() > 0 && homeDrv.endsWith(SLASH)) {
            homeDrv = homeDrv.substring(0, homeDrv.length() - 1);
        }
        if (homeDrv != null && homeDrv.trim().length() > 0 && homePath != null && homePath.trim().length() > 0 && (p = new File(homeDrv + homePath)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        if ((home = System.getenv("HOME")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        if ((home = System.getProperty("user.home")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        if ((home = PlotPS.getPathApp()) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        File f = null;
        for (String t : dirs) {
            if (t.endsWith(SLASH)) {
                t = t.substring(0, t.length() - 1);
            }
            String fileINIname = "Spana.ini";
            p = new File(t + SLASH + "Spana.ini");
            if (!p.exists() || !p.canRead() || f != null && p.lastModified() <= f.lastModified()) continue;
            f = p;
        }
        return f;
    }

    private void setPen(int i, int pen0, OutputStreamWriter o) {
        if (i != 5 && i != 8) {
            return;
        }
        int pen = Math.max(1, pen0);
        --pen;
        if (i == 5) {
            if (this.psColors <= 0) {
                this.colorNow = 0;
                return;
            }
            while (pen >= this.colours.length) {
                pen -= this.colours.length;
            }
            if (pen < 0) {
                pen = this.colours.length - pen;
            }
            this.colorNow = pen;
        }
        if (i == 8) {
            while (pen >= this.WIDTHS.length) {
                pen -= this.WIDTHS.length;
            }
            if (pen < 0) {
                pen = this.WIDTHS.length - pen;
            }
            this.penNow = pen;
        }
        StringBuilder line = new StringBuilder();
        if (this.psColors > 0 && this.colorNow != this.colorOld) {
            line.append(this.colours[this.colorNow]);
            line.append(" setrgbcolor");
            this.colorOld = this.colorNow;
        }
        if (this.penNow != this.penOld) {
            double w = Math.max(0.05, this.WIDTHS[this.penNow] * (this.scaleX + this.scaleY) / 2.0);
            if (line.length() > 0) {
                line.append(" ");
            }
            line.append(PlotPS.toStr(w));
            line.append(" _setWidth");
            this.penOld = this.penNow;
        }
        if (line.length() > 0) {
            try {
                if (this.newPath == 2) {
                    o.write("_sn " + line.toString() + nl);
                    this.newPath = 0;
                } else if (this.newPath < 0) {
                    o.write("newpath " + line.toString() + nl);
                    this.newPath = 0;
                } else {
                    o.write(line.toString() + nl);
                }
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
        }
    }

    private void moveOrDraw(int i0, double x0, double y0, OutputStreamWriter o) {
        if (this.newPath < 0) {
            try {
                o.write("newpath" + nl);
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
            this.pathCounter = 0;
            this.newPath = 0;
        }
        double x = x0 * this.scaleX + this.zx;
        double y = y0 * this.scaleY + this.zy;
        if (i0 <= 0) {
            if (this.newPath == 2) {
                try {
                    if (Math.abs(this.x1st - this.xNow) < 0.01 && Math.abs(this.y1st - this.yNow) < 0.01) {
                        o.write("_csn" + nl);
                    } else {
                        o.write("_sn" + nl);
                    }
                }
                catch (IOException ex) {
                    PlotPS.exception(ex, null, this.doNotStop);
                    this.delete = true;
                }
                this.pathCounter = 0;
                this.newPath = 0;
            }
            this.x1st = -1.7976931348623157E308;
            this.y1st = -1.7976931348623157E308;
        }
        if (i0 < 0) {
            try {
                o.write(PlotPS.toStr(x) + " " + PlotPS.toStr(y) + " Mv" + nl);
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
            this.newPath = 0;
            this.x1st = x;
            this.y1st = y;
        }
        if (i0 == 1) {
            if (this.newPath == 0) {
                try {
                    o.write(PlotPS.toStr(this.xNow) + " " + PlotPS.toStr(this.yNow) + " Mv" + nl);
                }
                catch (IOException ex) {
                    PlotPS.exception(ex, null, this.doNotStop);
                    this.delete = true;
                }
                this.newPath = 1;
                ++this.pathCounter;
                this.x1st = this.xNow;
                this.y1st = this.yNow;
            }
            try {
                o.write(PlotPS.toStr(x) + " " + PlotPS.toStr(y) + " Ln" + nl);
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
            this.newPath = 2;
            ++this.pathCounter;
            if (this.pathCounter > 400) {
                try {
                    o.write("currentpoint stroke moveto" + nl);
                }
                catch (IOException ex) {
                    PlotPS.exception(ex, null, this.doNotStop);
                    this.delete = true;
                }
                this.x1st = -1.7976931348623157E308;
                this.y1st = -1.7976931348623157E308;
                this.pathCounter = 0;
            }
        }
        this.xNow = x;
        this.yNow = y;
    }

    private static String toStr(double d) {
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        String dTxt = Math.abs((d = Math.min(9.999999999999999E14, Math.max(-9.999999999999999E14, d))) - (double)Math.round(d)) > 0.001 ? String.format(engl, "%20.2f", d) : Long.toString(Math.round(d));
        return dTxt.trim();
    }

    private String fixTextSimple(String txt) {
        if (txt == null || txt.trim().length() <= 0) {
            return txt;
        }
        StringBuilder t = new StringBuilder(txt);
        for (int i = 0; i < t.length(); ++i) {
            if (t.charAt(i) == '\\') {
                t.replace(i, i + 1, "\\\\");
                ++i;
                continue;
            }
            if (t.charAt(i) == '(') {
                t.replace(i, i + 1, "\\(");
                ++i;
                continue;
            }
            if (t.charAt(i) == ')') {
                t.replace(i, i + 1, "\\)");
                ++i;
                continue;
            }
            if (t.charAt(i) != '-') continue;
            t.replace(i, i + 1, "\\055");
            i += 3;
        }
        return t.toString();
    }

    private String maybeInQuotes(String t) {
        if (t == null || t.length() <= 0) {
            return t;
        }
        boolean encloseInQuotes = false;
        String[] q = new String[]{"\"", "\""};
        for (int i = 0; i < t.length(); ++i) {
            if (!Character.isWhitespace(t.charAt(i))) continue;
            encloseInQuotes = true;
        }
        if (encloseInQuotes) {
            return q[0] + t + q[1];
        }
        return t;
    }

    private static void printInstructions(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        out.flush();
        out.println("This program will convert a plot file (*.plt) into a PS file." + nl + "Usage:  java -jar PlotPS.jar [plot-file-name] [-command=value]");
        out.println("Possible commands are:" + nl + "  -b=bottom-margin  (in cm)" + nl + "  -bw  (black on white output)" + nl + "  -clr  (colours - standard palette)" + nl + "  -clr2 (colours selected in \"Spana\")" + nl + "  -dbg  (output debug information)" + nl + "  -f=font-nbr  (1:Vector_Graphics, 2:Times-Roman, 3:Helvetica, 4:Courier)" + nl + "  -l=left-margin  (in cm)" + nl + "  -noh   (do not make a header with file name and date)" + nl + "  -nostop  (do not stop for warnings)" + nl + "  -o=P/L  (P: portrait;  L: landscape)" + nl + "  -p=plot-file-name  (input \"plt\"-file in UTF-8 Unicode ecoding)" + nl + "  -ps=output-file-name  (for encapsulated PostScrit set the extention" + nl + "                           to \".eps\"; which also sets:  -o=P -l=0 -b=0)" + nl + "  -s=%  (output size; integer %-value)" + nl + "  -sx=% and -sy=% (different vertical and horizontal scaling)" + nl + "Enclose file-names with double quotes (\"\") it they contain blank space." + nl + "Example:  java -jar PlotPS.jar \"Fe 53\" -PS=\"ps\\Fe 53.ps\"  -s:60 -clr -F:2");
    }

    private void printText(int i1, int i2, String txt, boolean isFormula, int align, double txtSize, double txtAngle, OutputStreamWriter o) {
        double w;
        boolean bold;
        double[] FontScaleWidth = new double[]{0.7, 0.71, 0.88};
        String[] ALIGNMENTS = new String[]{"left", "centre", "right"};
        ChemFormula cf = null;
        if (this.dbg) {
            System.out.println("Print text \"" + txt + "\"" + nl + "   formula:" + isFormula + ", align=" + align + " size=" + txtSize + " angle=" + txtAngle);
        }
        if (txt == null || txt.trim().length() <= 0) {
            return;
        }
        txt = PlotPS.rTrim(txt);
        while (txtAngle > 360.0) {
            txtAngle -= 360.0;
        }
        while (txtAngle < -360.0) {
            txtAngle += 360.0;
        }
        if (txtAngle > 180.0) {
            txtAngle -= 360.0;
        }
        if (txtAngle < -180.0) {
            txtAngle += 360.0;
        }
        double newAngle = txtAngle;
        double rads = Math.toRadians(txtAngle);
        if (Math.abs(txtAngle) > 0.01) {
            double w1 = Math.cos(rads) * (this.scaleX / this.scaleY);
            double w2 = Math.sin(rads);
            newAngle = Math.signum(txtAngle) * Math.toDegrees(Math.acos(w1 / Math.sqrt(w1 * w1 + w2 * w2)));
        }
        this.fontSize = (int)Math.round(100.0 * ((this.scaleX + this.scaleY) / 2.0) * (txtSize + 0.001));
        this.fontSize = Math.min(5000, this.fontSize);
        align = Math.max(-1, Math.min(1, align));
        try {
            String str = "% text at X,Y= " + String.valueOf(i1) + " " + String.valueOf(i2) + ";  size = " + PlotPS.toStr(txtSize) + ";  angle = " + PlotPS.toStr(txtAngle) + ";  is formula: " + isFormula + ";  alignment:" + ALIGNMENTS[align + 1];
            o.write(str + nl + "%     text is: " + txt + nl);
            if (this.fontSize <= 0) {
                o.write(str + nl + "%     (size too small)" + nl);
                return;
            }
            if (this.fontSize != this.fontSizeOld) {
                this.fontSizeOld = this.fontSize;
                String fontSizeTxt = String.valueOf(this.fontSize);
                o.write(fontSizeTxt + " _setSize" + nl);
            }
        }
        catch (IOException ex) {
            PlotPS.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
        boolean bl = bold = this.penNow == 1;
        if (bold != this.oldBold) {
            try {
                if (bold) {
                    o.write("_bold" + nl);
                } else {
                    o.write("_norm" + nl);
                }
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
            this.oldBold = bold;
        }
        boolean containsLetters = false;
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') continue;
            containsLetters = true;
            break;
        }
        if (!containsLetters || txt.length() <= 1) {
            isFormula = false;
        }
        int txtLength = txt.length();
        if (isFormula && txtLength > 1) {
            if (txt.equalsIgnoreCase("log (ai/ar")) {
                txt = "log (a`i'/a`ref'";
            }
            cf = new ChemFormula(txt, new float[1]);
            PlotPS.chemF(cf);
            txtLength = cf.t.length();
        }
        double xpl = i1;
        double ypl = i2;
        if (!isFormula) {
            if (align == 1 || align == 0) {
                w = txtLength;
                if (align == 0) {
                    w /= 2.0;
                }
                w = w * txtSize * 100.0;
                xpl += w * Math.cos(rads);
                ypl += w * Math.sin(rads);
                if (align == 0) {
                    w = txtSize * 100.0 / 2.0;
                    xpl += w * Math.cos(rads + 1.5707963267948966);
                    ypl += w * Math.sin(rads + 1.5707963267948966);
                }
            }
        } else {
            if (!(!(Math.abs(txtAngle) < 0.01) || align != 0 || txt.equals("pH") || txt.equals("pe") || txt.startsWith("Log") || txt.startsWith("E / V") || txt.contains("`TOT'"))) {
                ypl += 0.3 * txtSize * 100.0;
            }
            w = (double)txt.length() * (1.0 - FontScaleWidth[this.psFont - 1]);
            w -= (double)(txt.length() - txtLength);
            if (align == 0) {
                w /= 2.0;
            }
            if (align == 1 || align == 0) {
                w = w * txtSize * 100.0;
                xpl += w * Math.cos(rads);
                ypl += w * Math.sin(rads);
            }
        }
        this.moveOrDraw(-1, xpl, ypl, o);
        if (Math.abs(txtAngle) > 0.01) {
            try {
                o.write("/_angle " + PlotPS.toStr(newAngle) + " def TxtRotate" + nl);
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
        }
        if (isFormula && cf != null) {
            int n1 = 0;
            try {
                String move;
                String l2;
                for (int j = 1; j < cf.t.length(); ++j) {
                    if (cf.d[j] == cf.d[j - 1]) continue;
                    l2 = cf.t.substring(n1, j);
                    n1 = j;
                    move = (double)Math.abs(cf.d[j - 1]) < 0.05 ? "lShow" : PlotPS.toStr(cf.d[j - 1]) + " ^";
                    l2 = "(" + this.fixText(l2, isFormula, move) + ")" + move;
                    o.write(l2 + nl);
                }
                if (n1 <= cf.t.length()) {
                    l2 = cf.t.substring(n1);
                    move = (double)Math.abs(cf.d[n1]) < 0.05 ? "lShow" : PlotPS.toStr(cf.d[n1]) + " ^";
                    l2 = "(" + this.fixText(l2, isFormula, move) + ")" + move;
                    o.write(l2 + nl);
                }
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
        } else {
            try {
                if (align == 1) {
                    o.write("(" + this.fixTextSimple(txt) + ")rShow" + nl);
                } else if (align == 0) {
                    o.write("(" + this.fixTextSimple(txt) + ")cShow" + nl);
                } else if (align == -1) {
                    o.write("(" + this.fixTextSimple(txt) + ")lShow" + nl);
                }
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
        }
        if (Math.abs(txtAngle) > 0.05) {
            try {
                o.write("grestore" + nl);
            }
            catch (IOException ex) {
                PlotPS.exception(ex, null, this.doNotStop);
                this.delete = true;
            }
        }
    }

    private String fixText(String txt, boolean isFormula, String move) {
        if (txt == null || txt.trim().length() <= 0) {
            return txt;
        }
        if (move == null) {
            move = "";
        }
        StringBuilder t = new StringBuilder(this.fixTextSimple(txt));
        String fontSizeTxt = String.valueOf(this.fontSize);
        int i = 0;
        while (i < t.length()) {
            String str;
            if (isFormula) {
                if (t.charAt(i) == '~') {
                    t.replace(i, i + 1, "\\260");
                    i += 4;
                    continue;
                }
                if (t.charAt(i) == '$') {
                    t.replace(i, i + 1, "\\265");
                    i += 4;
                    continue;
                }
            }
            if (t.charAt(i) == '\u007f' || isFormula && t.charAt(i) == '^') {
                str = ") " + move + " " + fontSizeTxt + " _setSize _sym (D) " + move;
                str = this.penNow == 1 ? str + " _bold " : str + " _norm ";
                this.fontSizeOld = this.fontSize;
                str = str + fontSizeTxt + " _setSize (";
                t.replace(i, i + 1, str);
                i += str.length();
                continue;
            }
            if (i <= t.length() - 6 && t.substring(i).startsWith("versus")) {
                str = ") " + move + " _em " + fontSizeTxt + " _setSize (versus) " + move;
                str = this.penNow == 1 ? str + " _bold " : str + " _norm ";
                str = str + fontSizeTxt + " _setSize (";
                t.replace(i, i + 6, str);
                i += str.length();
                continue;
            }
            if (i <= t.length() - 4 && (t.substring(i).startsWith("Log ") || t.substring(i).startsWith("Log[") || t.substring(i).startsWith("Log{"))) {
                t.replace(i, i + 3, "log");
                i += 3;
                continue;
            }
            if (i <= t.length() - 5 && t.substring(i).toLowerCase().startsWith("log p")) {
                str = "log ) " + move + " _em " + fontSizeTxt + " _setSize (p) " + move;
                str = this.penNow == 1 ? str + " _bold " : str + " _norm ";
                str = str + fontSizeTxt + " _setSize (";
                t.replace(i, i + 5, str);
                i += str.length();
                continue;
            }
            ++i;
        }
        return t.toString();
    }

    private static String rTrim(String text) {
        if (text == null) {
            return text;
        }
        int idx = text.length() - 1;
        if (idx >= 0) {
            while (idx >= 0 && Character.isWhitespace(text.charAt(idx))) {
                --idx;
            }
            if (idx < 0) {
                return "";
            }
            return text.substring(0, idx + 1);
        }
        return text;
    }

    /*
     * Unable to fully structure code
     */
    private static void chemF(ChemFormula cf) {
        REMOVE_CHAR = false;
        DOWN = true;
        NONE = 2;
        UP = 3;
        CONT = 4;
        END = 6;
        M1 = 8211;
        M2 = 8722;
        t = new StringBuffer();
        t.append(cf.t);
        L = t.toString().trim().length();
        if (L <= 1) {
            return;
        }
        L = t.length();
        if (L > (nchr = PlotPS.rTrim(t.toString()).length())) {
            t.delete(nchr, L);
        }
        d = new float[nchr];
        for (i = 0; i < d.length; ++i) {
            d[i] = 0.0f;
        }
        L = 32;
        nL = 32;
        nnL = 32;
        now = t.charAt(0);
        n = 32;
        if (nchr >= 2) {
            n = t.charAt(1);
        }
        n2 = 32;
        if (nchr >= 3) {
            n2 = t.charAt(2);
        }
        dm = 0.0f;
        df = 0.0f;
        i = 0;
        do {
            block58: {
                block68: {
                    block70: {
                        block69: {
                            block67: {
                                block62: {
                                    block66: {
                                        block65: {
                                            block64: {
                                                block63: {
                                                    block61: {
                                                        block60: {
                                                            block59: {
                                                                block57: {
                                                                    n3 = 32;
                                                                    if (nchr >= i + 4) {
                                                                        n3 = t.charAt(i + 3);
                                                                    }
                                                                    if (df > 0.001f && (now < 43 || now > 57 || now == 44 || now == 46 || now == 47)) {
                                                                        df = 0.0f;
                                                                    }
                                                                    if (now != 64 || L == 64) break block57;
                                                                    act = 0;
                                                                    break block58;
                                                                }
                                                                if (L != 64) break block59;
                                                                act = now == 32 ? 4 : 2;
                                                                break block58;
                                                            }
                                                            if (now != 2) break block60;
                                                            now = n;
                                                            n = n2;
                                                            n2 = n3;
                                                            act = 6;
                                                            break block58;
                                                        }
                                                        if (now != 39 && now != 96) break block61;
                                                        if (now == 39 && dm == 0.0f && (n == 32 && L == 115 || n == 115 && (n2 == 32 || n2 == 46 || n2 == 44 || n2 == 58 || n2 == 59 || n2 == 63 || n2 == 33 || n2 == 41 || n2 == 93))) {
                                                            act = 4;
                                                        } else {
                                                            if (now == 39) {
                                                                dm += 0.5f;
                                                            }
                                                            if (now == 96) {
                                                                dm -= 0.5f;
                                                            }
                                                            act = 0;
                                                        }
                                                        break block58;
                                                    }
                                                    if (now != 32) break block62;
                                                    if ((n >= 49 || n == 43 || n == 45 || n == 8211 || n == 8722) && n <= 57) break block63;
                                                    act = 2;
                                                    break block58;
                                                }
                                                if (n != 43 && n != 45 && n != 8211 && n != 8722 || L != 43 && L != 45 && L != 8211 && L != 8722) break block64;
                                                act = 2;
                                                break block58;
                                            }
                                            if ((n2 < 65 || n2 > 90) && (n2 < 97 || n2 > 122)) break block65;
                                            act = 2;
                                            break block58;
                                        }
                                        if (n < 49 || n > 57) ** GOTO lbl-1000
                                        if (n2 < 48 || n2 > 57) break block66;
                                        if (n3 == 43 || n3 == 45 || n3 == 8211 || n3 == 8722) ** GOTO lbl-1000
                                        act = 2;
                                        break block58;
                                    }
                                    if (n2 != 43 && n2 != 45 && n2 != 8211 && n2 != 8722) {
                                        act = 2;
                                    } else lbl-1000:
                                    // 3 sources

                                    {
                                        act = L == 32 ? 2 : ((L < 48 || L > 122 || L >= 58 && L <= 64 || L >= 91 && L <= 96) && L != 41 && L != 93 && L != 125 && L != 62 && L != 34 && L != 39 ? 2 : 0);
                                    }
                                    break block58;
                                }
                                if (now < 48 || now > 57) break block67;
                                if (L == 40 || L == 91 || L == 123 || L == 45 || L == 8211 || L == 8722 || L == 43) ** GOTO lbl-1000
                                if (L == 106 || L == 74 || L == 113 || L == 81) {
                                    act = 2;
                                } else if (L == 120 || L == 88 || L == 122 || L == 90) {
                                    act = 2;
                                } else if (L >= 65 && L <= 90 || L >= 97 && L <= 122) {
                                    act = 1;
                                } else if (L == 41 || L == 93 || L == 125) {
                                    act = 1;
                                } else if (df > 0.01f && (L >= 48 && L <= 57 || L == 46)) {
                                    act = 4;
                                } else if (df < -0.01f && (L == 46 || L >= 48 && L <= 57)) {
                                    act = 4;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    df = 0.0f;
                                    act = L == 32 && n >= 48 && n <= 57 && (n2 == 43 || n2 == 45 || n2 == 8211 || n2 == 8722) && now != 48 ? (n3 != 32 && n3 != 41 && n3 != 93 && n3 != 125 ? 4 : 3) : (L != 32 || n != 43 && n != 45 && n != 8211 && n != 8722 ? 4 : (n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122 ? 4 : 3));
                                }
                                break block58;
                            }
                            if (now != 43 && now != 45 && now != 8211 && now != 8722) break block68;
                            if (L < 50 || L > 57 || !(df > 0.01f)) break block69;
                            act = 3;
                            break block58;
                        }
                        if (L < 48 || L > 57 || nL < 49 || nL > 57 || !(df > 0.01f)) break block70;
                        act = 3;
                        break block58;
                    }
                    if (n < 49 || n > 57) ** GOTO lbl-1000
                    if ((nL >= 48 && nL <= 57 || nL == 46) && (L == 69 || L == 101)) {
                        act = 2;
                    } else if (L == 32) {
                        act = 2;
                    } else if (L == 106 || L == 74 || L == 113 || L == 81) {
                        act = 2;
                    } else if (L == 120 || L == 88 || L == 122 || L == 90) {
                        act = 2;
                    } else if (dm > 0.01f && L == 39 && nL == 48 && nnL == 49 && n >= 49 && n <= 57 && (n2 == 46 || n2 == 96 || n2 >= 48 && n2 <= 57)) {
                        act = 2;
                    } else if (L < 48 && L != 41 && L != 34 && L != 39 || L > 122 && L != 125 || L >= 58 && L <= 64 && L != 62 || L >= 91 && L <= 96 && L != 93) {
                        act = 2;
                    } else if ((L == 41 || L == 93 || L == 125 || L == 34 || L == 39) && (nL == 32 || nL < 48 || nL > 122 || nL >= 58 && nL <= 64 || nL >= 91 && nL <= 96)) {
                        act = 2;
                    } else if (n2 < 48 && n2 != 41 && n2 != 32 && n2 != 39 || n2 > 57 && n2 != 93 && n2 != 96 && n2 != 125) {
                        act = 2;
                    } else if (n >= 49 && n <= 57 && n2 >= 48 && n2 <= 57) {
                        if (n3 != 32 && n3 != 2 && n3 != 41 && n3 != 93 && n3 != 125 && n3 != 96 && n3 != 39 && n3 != 64 && n3 != 61) {
                            act = 2;
                        } else {
                            t1 = t.charAt(i + 1);
                            t2 = t.charAt(i + 2);
                            t.setCharAt(i + 2, t.charAt(i));
                            t.setCharAt(i + 1, t2);
                            t.setCharAt(i, t1);
                            j1 = n;
                            j2 = n2;
                            n2 = now;
                            n = j2;
                            now = j1;
                            act = 3;
                        }
                    } else if (n >= 50 && n <= 57) {
                        t1 = t.charAt(i + 1);
                        t.setCharAt(i + 1, t.charAt(i));
                        t.setCharAt(i, t1);
                        j = n;
                        n = now;
                        now = j;
                        act = 3;
                    } else lbl-1000:
                    // 2 sources

                    {
                        act = L == 106 || L == 74 || L == 113 || L == 81 ? 2 : (L == 120 || L == 88 || L == 122 || L == 90 ? 2 : (L == 32 || L == 41 || L == 93 || L == 125 ? (nL == 32 || nL < 48 && nL != 41 || nL > 122 || nL >= 58 && nL <= 64 || nL >= 91 && nL <= 96 && nL != 93 ? 2 : 3) : (L < 48 && L != 41 && L != 34 && L != 39 || L > 122 && L != 125 || L >= 58 && L <= 64 || L >= 91 && L <= 96 && L != 93 ? 2 : (n != 32 && n != 41 && n != 93 && n != 125 && n != 61 && n != 39 && n != 96 ? 2 : 3))));
                    }
                    break block58;
                }
                act = now == 46 ? (L >= 48 && L <= 57 && n >= 48 && n <= 57 ? 4 : 2) : 2;
            }
            switch (act) {
                case 0: {
                    if (i < nchr) {
                        t.deleteCharAt(i);
                    }
                    --nchr;
                    nnL = nL;
                    nL = L;
                    L = now;
                    now = n;
                    n = n2;
                    n2 = n3;
                    break;
                }
                case 1: {
                    df = -0.4f;
                    ** GOTO lbl202
                }
                case 2: {
                    df = 0.0f;
                    ** GOTO lbl202
                }
                case 3: {
                    df = 0.4f;
                }
lbl202:
                // 4 sources

                default: {
                    if (act != 6) {
                        nnL = nL;
                        nL = L;
                        L = now;
                        now = n;
                        n = n2;
                        n2 = n3;
                    }
                    d[i] = dm + df;
                    ++i;
                }
            }
        } while (i < nchr);
        if (cf.t.length() > 0) {
            cf.t.delete(0, cf.t.length());
        }
        cf.t.append(t);
        cf.d = new float[nchr];
        System.arraycopy(d, 0, cf.d, 0, nchr);
    }

    private static void exception(Exception ex, String msg, boolean doNotStop) {
        String ERR_START = "============================";
        String errMsg = "============================";
        String exMsg = ex.toString();
        exMsg = exMsg == null || exMsg.length() <= 0 ? "Unknown error." : "Error: " + exMsg;
        errMsg = errMsg + nl + exMsg;
        if (msg != null && msg.trim().length() > 0) {
            errMsg = errMsg + nl + msg;
        }
        errMsg = errMsg + nl + PlotPS.stack2string(ex) + nl + "============================";
        if (doNotStop) {
            System.out.println(errMsg);
        } else {
            ErrMsgBx mb = new ErrMsgBx(errMsg, progName);
        }
    }

    private static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String t = sw.toString();
            if (t != null && t.length() > 0) {
                int i = t.indexOf("Unknown Source");
                int j = t.indexOf("\n");
                if (i > 0 && i > j && (j = (t = t.substring(0, i)).lastIndexOf("\n")) > 0) {
                    t = t.substring(0, j) + nl;
                }
            }
            return DASH_LINE + nl + t + DASH_LINE;
        }
        catch (Exception e2) {
            return "Internal error in \"stack2string(Exception e)\"";
        }
    }

    public static String getPathApp() {
        String path;
        C c = new C();
        try {
            URI dir = c.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (dir != null) {
                String d = dir.toString();
                if (d.startsWith("jar:") && d.endsWith("!/")) {
                    d = d.substring(4, d.length() - 2);
                    dir = new URI(d);
                }
                path = new File(dir.getPath()).getParent();
            } else {
                path = System.getProperty("user.dir");
            }
        }
        catch (URISyntaxException e) {
            if (!started) {
                ErrMsgBx emb = new ErrMsgBx("Error: " + e.toString() + nl + "   trying to get the application's directory.", progName);
            }
            path = System.getProperty("user.dir");
        }
        started = true;
        return path;
    }

    static class ErrMsgBx {
        public ErrMsgBx(String msg, String title) {
            if (msg == null || msg.trim().length() <= 0) {
                System.err.println("--- MsgBox: null or empty \"message\".");
                return;
            }
            if (title == null || title.length() <= 0) {
                title = " Error:";
            }
            Frame frame = new Frame(title);
            String iconName = "images/ErrMsgBx.gif";
            URL imgURL = this.getClass().getResource(iconName);
            if (imgURL != null) {
                frame.setIconImage(new ImageIcon(imgURL).getImage());
            } else {
                System.err.println("--- Error in MsgBox constructor: Could not load image = \"" + iconName + "\"");
            }
            frame.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int left = Math.max(55, (screenSize.width - frame.getWidth()) / 2);
            int top = Math.max(10, (screenSize.height - frame.getHeight()) / 2);
            frame.setLocation(Math.min(screenSize.width - 100, left), Math.min(screenSize.height - 100, top));
            String msgText = msg.trim();
            System.out.println("--- MsgBox:" + nl + msgText + nl + "---");
            frame.setVisible(true);
            MsgBoxDialog msgBox = new MsgBoxDialog(frame, msgText, title, true);
            msgBox.setVisible(true);
            msgBox.dispose();
            frame.setVisible(false);
            frame.dispose();
        }

        private static class MsgBoxDialog
        extends Dialog {
            private Button ok;
            private Panel p;
            private final TextArea text;

            public MsgBoxDialog(Frame parent, String msg, String title, boolean modal) {
                super(parent, " " + title, modal);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        MsgBoxDialog.this.setVisible(false);
                    }
                });
                this.setLayout(new BorderLayout());
                this.p = new Panel();
                this.p.setLayout(new FlowLayout(1));
                this.ok = new Button();
                int wMax = 85;
                int hMax = 20;
                int wMin = 5;
                boolean hMin = true;
                int w = 5;
                int h = 1;
                int i = 0;
                int j = 5;
                String eol = "\n";
                String nl = System.getProperty("line.separator");
                do {
                    char c;
                    String s;
                    if ((s = String.valueOf(c = msg.charAt(i))).equals("\n") || s.equals(nl)) {
                        ++h;
                        j = 5;
                        continue;
                    }
                    w = Math.max(++j, w);
                } while (++i < msg.length() - 1);
                int scroll = 3;
                if (w > 85 && h <= 20) {
                    scroll &= 2;
                }
                if (h > 20 && w <= 85) {
                    scroll &= 1;
                }
                if (w > 85 && h > 20) {
                    scroll = 0;
                }
                w = Math.min(Math.max(w, 10), 85);
                h = Math.min(h, 20);
                this.text = new TextArea(msg, h, w, scroll);
                this.text.setEditable(false);
                this.text.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                        if (evt.getKeyCode() == 9) {
                            MsgBoxDialog.this.ok.requestFocusInWindow();
                        }
                    }
                });
                this.add((Component)this.text, "Center");
                this.ok.setLabel("OK");
                this.ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MsgBoxDialog.this.closeDialog();
                    }
                });
                this.ok.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                    }
                });
                this.p.add(this.ok);
                this.add((Component)this.p, "South");
                this.pack();
                this.setLocation(parent.getLocation());
                this.ok.requestFocusInWindow();
            }

            private void closeDialog() {
                this.setVisible(false);
            }
        }
    }

    private static class C {
        private C() {
        }

        private static void C() {
        }
    }

    static class ChemFormula {
        StringBuffer t = new StringBuffer();
        float[] d;

        ChemFormula(String txt, float[] d_org) {
            this.t.append(txt);
            int nChar = txt.length();
            this.d = new float[nChar];
            System.arraycopy(d_org, 0, this.d, 0, d_org.length);
        }
    }

    private static class BoundingBox {
        public double xMn = Double.MAX_VALUE;
        public double yMn = Double.MAX_VALUE;
        public double xMx = -1.7976931348623157E308;
        public double yMx = -1.7976931348623157E308;

        public String toString() {
            return "[" + this.xMn + "," + this.yMn + " ; " + this.xMx + "," + this.yMx + "]";
        }
    }
}

