/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.FrameDBmain;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import lib.Version;
import lib.database.ProgramDataDB;
import lib.huvud.LicenseFrame;

public class HelpAboutDB
extends JFrame {
    private boolean finished = false;
    private HelpAboutDB frame = null;
    private LicenseFrame lf = null;
    private Dimension windowSize = null;
    private static final String nl = System.getProperty("line.separator");
    private JButton jButtonLicense;
    private JLabel jLabelIniF;
    private JLabel jLabelIniFU;
    private JLabel jLabelIniFile;
    private JLabel jLabelIniFileUser;
    private JLabel jLabelJava;
    private JLabel jLabelJavaIcon;
    private JLabel jLabelJavaVers;
    private JLabel jLabelLastUpdate;
    private JLabel jLabelLib;
    private JLabel jLabelLib2;
    private JLabel jLabelName;
    private JLabel jLabelNetBeans;
    private JLabel jLabelNetBeans_www;
    private JLabel jLabelNetbeansIcon;
    private JLabel jLabelOS;
    private JLabel jLabelPathA;
    private JLabel jLabelPathApp;
    private JLabel jLabelPathU;
    private JLabel jLabelPathUser;
    private JLabel jLabelVers;
    private JLabel jLabel_www;
    private JLabel jLabel_wwwKTH;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelNetBeans;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;

    public HelpAboutDB(String pathAPP, ProgramDataDB pd) {
        this.initComponents();
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpAboutDB.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        this.getRootPane().getActionMap().put("ALT_X", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        this.getContentPane().setBackground(Color.white);
        this.setTitle("DataBase: About");
        String iconName = "images/Question_16x16.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            System.err.println("Error: Could not load image = \"" + iconName + "\"");
        }
        this.jLabelVers.setText("Program version: 2015-June-05");
        this.jLabelLib.setText("LibChemDiagr: " + Version.version());
        this.jLabelLib2.setText("LibDataBase: " + lib.database.Version.version());
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(2, 3, Locale.getDefault());
        long lm = -1L;
        for (String t : pd.dataBasesList) {
            if (t == null || t.length() <= 0) continue;
            File f = new File(t);
            lm = Math.max(lm, f.lastModified());
        }
        if (lm <= 0L) {
            this.jLabelLastUpdate.setText(" ");
        } else {
            this.jLabelLastUpdate.setText("last database-file updated: " + dateFormatter.format(new Date(lm)));
        }
        if (pathAPP != null) {
            if (pathAPP.trim().length() > 0) {
                this.jLabelPathApp.setText(pathAPP);
            } else {
                this.jLabelPathApp.setText(" \"\"");
            }
        }
        this.jLabelPathUser.setText(System.getProperty("user.home"));
        this.validate();
        int w = this.jLabelPathApp.getWidth() + 40;
        if (w > this.getWidth()) {
            this.setSize(w, this.getHeight());
        }
        if (FrameDBmain.fileIni != null) {
            if (FrameDBmain.fileIniUser != null) {
                this.jLabelIniF.setText("INI-file (read-only):");
            }
            this.jLabelIniFile.setText(FrameDBmain.fileIni.getPath());
        }
        if (FrameDBmain.fileIniUser != null) {
            this.jLabelIniFileUser.setText(FrameDBmain.fileIniUser.getPath());
        } else {
            this.jLabelIniFU.setVisible(false);
            this.jLabelIniFileUser.setVisible(false);
        }
        this.jLabelJavaVers.setText("Java Runtime Environment " + System.getProperty("java.version"));
        this.jLabelOS.setText("<html>Operating system: \"" + System.getProperty("os.name") + "&nbsp;" + System.getProperty("os.version") + "\"<br>" + "architecture: \"" + System.getProperty("os.arch") + "\"</html>");
        this.validate();
        w = this.jLabelIniFile.getWidth() + 40;
        if (w > this.getWidth()) {
            this.setSize(w, this.getHeight());
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int left = Math.max(0, (screenSize.width - this.getWidth()) / 2);
        int top = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        this.setLocation(Math.min(screenSize.width - this.getWidth() - 20, left), Math.min(screenSize.height - this.getHeight() - 20, top));
    }

    public void start() {
        this.setVisible(true);
        this.windowSize = this.getSize();
        this.frame = this;
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jLabelVers = new JLabel();
        this.jLabelLib = new JLabel();
        this.jLabelLib2 = new JLabel();
        this.jLabelLastUpdate = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButtonLicense = new JButton();
        this.jLabel_wwwKTH = new JLabel();
        this.jLabel_www = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabelJavaIcon = new JLabel();
        this.jLabelJava = new JLabel();
        this.jPanelNetBeans = new JPanel();
        this.jLabelNetbeansIcon = new JLabel();
        this.jLabelNetBeans = new JLabel();
        this.jLabelNetBeans_www = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabelJavaVers = new JLabel();
        this.jLabelOS = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jLabelPathA = new JLabel();
        this.jLabelPathApp = new JLabel();
        this.jLabelIniF = new JLabel();
        this.jLabelIniFile = new JLabel();
        this.jLabelIniFU = new JLabel();
        this.jLabelIniFileUser = new JLabel();
        this.jLabelPathU = new JLabel();
        this.jLabelPathUser = new JLabel();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HelpAboutDB.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                HelpAboutDB.this.formComponentResized(evt);
            }
        });
        this.jLabelName.setFont(new Font("Dialog", 0, 11));
        this.jLabelName.setText("<html><font size=+1><b>DataBase</b></font> &nbsp;&nbsp; \u00a9 2015 &nbsp; I.Puigdomenech<br>\nThis program comes with ABSOLUTELY NO<br>\nWARRANTY. This is free software, and<br>\nyou are welcome to redistribute it under<br>\nthe GNU GPL license.</html>");
        this.jLabelName.setVerticalAlignment(1);
        this.jLabelVers.setFont(new Font("Dialog", 0, 11));
        this.jLabelVers.setText("Program version: 201#-March-30");
        this.jLabelLib.setFont(new Font("Dialog", 0, 11));
        this.jLabelLib.setText("LibChemDiagr: 201#-March-30");
        this.jLabelLib2.setFont(new Font("Dialog", 0, 11));
        this.jLabelLib2.setText("LibDataBase: 201#-March-30");
        this.jLabelLastUpdate.setFont(new Font("Dialog", 0, 11));
        this.jLabelLastUpdate.setText("latest database-file update: 2010-06-06");
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jPanel2.setOpaque(false);
        this.jButtonLicense.setFont(new Font("Dialog", 0, 11));
        this.jButtonLicense.setMnemonic('l');
        this.jButtonLicense.setText("License Details");
        this.jButtonLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpAboutDB.this.jButtonLicenseActionPerformed(evt);
            }
        });
        this.jLabel_wwwKTH.setFont(new Font("Dialog", 0, 11));
        this.jLabel_wwwKTH.setForeground(new Color(0, 0, 221));
        this.jLabel_wwwKTH.setText("<html><u>www.kth.se/che/medusa</u></html>");
        this.jLabel_wwwKTH.setCursor(new Cursor(12));
        this.jLabel_wwwKTH.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HelpAboutDB.this.jLabel_wwwKTHMouseClicked(evt);
            }
        });
        this.jLabel_www.setFont(new Font("Dialog", 0, 11));
        this.jLabel_www.setForeground(new Color(0, 0, 221));
        this.jLabel_www.setText("<html><u>sites.google.com/site/chemdiagr/</u></html>");
        this.jLabel_www.setCursor(new Cursor(12));
        this.jLabel_www.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HelpAboutDB.this.jLabel_wwwMouseClicked(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_wwwKTH, -2, -1, -2).addComponent(this.jLabel_www, -2, -1, -2).addComponent(this.jButtonLicense)).addGap(0, 56, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jButtonLicense).addGap(18, 18, 18).addComponent(this.jLabel_wwwKTH, -2, -1, -2).addGap(3, 3, 3).addComponent(this.jLabel_www, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.jSeparator2.setFont(new Font("Dialog", 0, 11));
        this.jLabelJavaIcon.setFont(new Font("Dialog", 0, 11));
        this.jLabelJavaIcon.setIcon(new ImageIcon(this.getClass().getResource("/database/images/Java_24x24.gif")));
        this.jLabelJava.setFont(new Font("Dialog", 0, 11));
        this.jLabelJava.setText("<html>Java Standard Edition<br> Development Kit 6 (JDK 1.6.0)</html>");
        this.jPanelNetBeans.setFont(new Font("Dialog", 0, 11));
        this.jPanelNetBeans.setOpaque(false);
        this.jLabelNetbeansIcon.setFont(new Font("Dialog", 0, 11));
        this.jLabelNetbeansIcon.setIcon(new ImageIcon(this.getClass().getResource("/database/images/Netbeans.gif")));
        this.jLabelNetbeansIcon.setIconTextGap(0);
        this.jLabelNetBeans.setFont(new Font("Dialog", 0, 11));
        this.jLabelNetBeans.setText("NetBeans IDE 7.4 ");
        this.jLabelNetBeans_www.setFont(new Font("Dialog", 0, 11));
        this.jLabelNetBeans_www.setForeground(new Color(0, 0, 221));
        this.jLabelNetBeans_www.setText("<html><u>netbeans.org</u></html>");
        this.jLabelNetBeans_www.setCursor(new Cursor(12));
        this.jLabelNetBeans_www.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HelpAboutDB.this.jLabelNetBeans_wwwMouseClicked(evt);
            }
        });
        GroupLayout jPanelNetBeansLayout = new GroupLayout(this.jPanelNetBeans);
        this.jPanelNetBeans.setLayout(jPanelNetBeansLayout);
        jPanelNetBeansLayout.setHorizontalGroup(jPanelNetBeansLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNetBeansLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabelNetbeansIcon).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelNetBeans).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNetBeans_www, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelNetBeansLayout.setVerticalGroup(jPanelNetBeansLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNetBeansLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanelNetBeansLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelNetbeansIcon).addGroup(jPanelNetBeansLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNetBeans_www, -2, -1, -2).addComponent(this.jLabelNetBeans, -2, 24, -2)))));
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.setOpaque(false);
        this.jLabelJavaVers.setFont(new Font("Dialog", 0, 11));
        this.jLabelJavaVers.setText("jLabelJavaVers");
        this.jLabelOS.setFont(new Font("Dialog", 0, 11));
        this.jLabelOS.setText("<html>Operating system:<br>\"os.name &nbsp;os.version\"<br>\narchitecture: \"os.arch\"</html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelOS, -1, 301, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelJavaVers).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabelJavaVers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabelOS, -2, -1, -2)));
        this.jSeparator3.setFont(new Font("Dialog", 0, 11));
        this.jLabelPathA.setFont(new Font("Dialog", 0, 11));
        this.jLabelPathA.setLabelFor(this.jLabelPathA);
        this.jLabelPathA.setText("Application path:");
        this.jLabelPathApp.setFont(new Font("Dialog", 0, 11));
        this.jLabelPathApp.setText("\"null\"");
        this.jLabelIniF.setFont(new Font("Dialog", 0, 11));
        this.jLabelIniF.setLabelFor(this.jLabelIniFile);
        this.jLabelIniF.setText("INI-file:");
        this.jLabelIniFile.setFont(new Font("Dialog", 0, 11));
        this.jLabelIniFile.setText("\"null\"");
        this.jLabelIniFU.setFont(new Font("Dialog", 0, 11));
        this.jLabelIniFU.setText("User INI-file:");
        this.jLabelIniFileUser.setFont(new Font("Dialog", 0, 11));
        this.jLabelIniFileUser.setText("\"null\"");
        this.jLabelPathU.setFont(new Font("Dialog", 0, 11));
        this.jLabelPathU.setText("User \"home\" directory:");
        this.jLabelPathUser.setFont(new Font("Dialog", 0, 11));
        this.jLabelPathUser.setText("\"null\"");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator3, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelJavaIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelJava, -2, -1, -2)).addComponent(this.jPanelNetBeans, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelVers).addComponent(this.jLabelLib).addComponent(this.jLabelLastUpdate).addComponent(this.jLabelLib2).addComponent(this.jLabelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelPathA).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPathApp)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelIniF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelIniFile)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelIniFU).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelIniFileUser)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelPathU).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPathUser))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabelName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelVers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelLib).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelLib2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelLastUpdate)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelJava, -2, -1, -2).addComponent(this.jLabelJavaIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNetBeans, -2, -1, -2).addGap(8, 8, 8)).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPathA).addComponent(this.jLabelPathApp)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelIniF).addComponent(this.jLabelIniFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelIniFU).addComponent(this.jLabelIniFileUser)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPathU).addComponent(this.jLabelPathUser)).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void jLabel_wwwKTHMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        this.jLabel_wwwKTH.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.kth.se/che/medusa/");
        this.setCursor(new Cursor(0));
        this.jLabel_wwwKTH.setCursor(new Cursor(12));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void jLabelNetBeans_wwwMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        this.jLabelNetBeans_www.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://netbeans.org/");
        this.setCursor(new Cursor(0));
        this.jLabelNetBeans_www.setCursor(new Cursor(12));
    }

    private void jLabel_wwwMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        this.jLabel_www.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://sites.google.com/site/chemdiagr/");
        this.setCursor(new Cursor(0));
        this.jLabel_www.setCursor(new Cursor(12));
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jButtonLicenseActionPerformed(ActionEvent evt) {
        if (this.lf != null) {
            return;
        }
        this.setCursor(new Cursor(3));
        Thread licShow = new Thread(){

            @Override
            public void run() {
                HelpAboutDB.this.jButtonLicense.setEnabled(false);
                HelpAboutDB.this.lf = new LicenseFrame(HelpAboutDB.this);
                HelpAboutDB.this.lf.setVisible(true);
                HelpAboutDB.this.setCursor(new Cursor(0));
                HelpAboutDB.this.lf.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HelpAboutDB.this.jButtonLicense.setEnabled(true);
                        HelpAboutDB.this.lf = null;
                    }
                });
            }
        };
        licShow.start();
    }

    public void closeWindow() {
        if (this.lf != null) {
            this.lf.closeWindow();
        }
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void bringToFront() {
        if (this.frame != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HelpAboutDB.this.frame.setVisible(true);
                    if ((HelpAboutDB.this.frame.getExtendedState() & 1) == 1) {
                        HelpAboutDB.this.frame.setExtendedState(0);
                    }
                    HelpAboutDB.this.frame.setAlwaysOnTop(true);
                    HelpAboutDB.this.frame.toFront();
                    HelpAboutDB.this.frame.requestFocus();
                    HelpAboutDB.this.frame.setAlwaysOnTop(false);
                }
            });
        }
    }

    public static class BareBonesBrowserLaunch {
        static final String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape", "chrome"};

        public static void openURL(String url) {
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url).waitFor();
                } else {
                    boolean found = false;
                    for (String browser : browsers) {
                        if (found) continue;
                        boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                        if (!found) continue;
                        Runtime.getRuntime().exec(new String[]{browser, url});
                    }
                    if (!found) {
                        throw new Exception(Arrays.toString(browsers));
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error attempting to launch web browser" + nl + e.toString());
            }
        }
    }
}

