/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import lib.huvud.SortedProperties;

public class References {
    private final boolean dbg;
    private String referenceFileName;
    private SortedProperties propertiesRefs = null;
    private final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private final String line = "- - - - -";
    private static final String nl = System.getProperty("line.separator");

    public References() {
        this.dbg = false;
    }

    public References(boolean dbg) {
        this.dbg = dbg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readRefsFile(String refFileName, boolean dbg) {
        if (refFileName == null || refFileName.trim().length() <= 0) {
            this.referenceFileName = null;
            this.propertiesRefs = null;
            return false;
        }
        if (this.propertiesRefs == null) {
            this.propertiesRefs = new SortedProperties();
        } else {
            this.propertiesRefs.clear();
        }
        this.referenceFileName = refFileName.trim();
        File rf = new File(this.referenceFileName);
        if (!rf.exists()) {
            System.out.println("- - - - -" + nl + "Warning - file not found:" + nl + "\"" + rf.getAbsolutePath() + "\"" + nl + "- - - - -");
            rf = null;
        } else if (!rf.canRead()) {
            System.out.println("- - - - -" + nl + "Warning - can not read from file:" + nl + "\"" + rf.getAbsolutePath() + "\"" + nl + "- - - - -");
            rf = null;
        }
        if (rf == null) {
            return false;
        }
        FileInputStream fis = null;
        if (dbg) {
            System.out.println("Reading file \"" + rf.getAbsolutePath() + "\"");
        }
        try {
            fis = new FileInputStream(rf);
            this.propertiesRefs.load((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            System.out.println("Warning: file Not found: \"" + rf.getAbsolutePath() + "\"");
            this.propertiesRefs = null;
        }
        catch (IOException e) {
            String msg = "- - - - -" + nl + "Error: \"" + e.toString() + "\"" + nl + "   while loading REF-file:" + nl + "   \"" + rf.getAbsolutePath() + "\"" + nl + "- - - - -";
            System.err.println(msg);
            this.propertiesRefs = null;
            this.referenceFileName = null;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                String msg = "- - - - -" + nl + "Error: \"" + e.toString() + "\"" + nl + "   while closing REF-file:" + nl + "   \"" + rf.getAbsolutePath() + "\"" + nl + "- - - - -";
                System.err.println(msg);
            }
        }
        return this.propertiesRefs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRefsFile(Frame parent, boolean warning) {
        String msg;
        if (this.propertiesRefs == null) {
            this.propertiesRefs = new SortedProperties();
            System.err.println("- - - - -" + nl + "Warning in \"saveRefsFile\" - propertiesRefs is empty." + nl + "- - - - -");
        }
        if (this.referenceFileName == null || this.referenceFileName.trim().length() <= 0) {
            System.err.println("- - - - -" + nl + "Error in \"saveRefsFile\" - empty file name." + nl + "- - - - -");
            return;
        }
        File rf = new File(this.referenceFileName);
        if (rf.exists()) {
            if (warning) {
                Object[] opt = new Object[]{"OK", "Cancel"};
                int m = JOptionPane.showOptionDialog(parent, "Warning - file:" + nl + "    " + rf.getName() + nl + "will be overwritten." + nl + " ", "Save reerences", 0, 2, null, opt, opt[1]);
                if (m != 0) {
                    return;
                }
            }
            if (!rf.canWrite()) {
                JOptionPane.showMessageDialog(parent, "Error - Can not write to file:" + nl + rf.getAbsolutePath() + nl + " ", "Save reerences", 0);
                return;
            }
        }
        FileOutputStream properties_refFileSave = null;
        System.out.println("Saving file \"" + rf.getAbsolutePath() + "\"");
        try {
            properties_refFileSave = new FileOutputStream(rf);
            this.propertiesRefs.store((OutputStream)properties_refFileSave, null);
            System.out.println("Written: \"" + rf.getAbsolutePath() + "\"");
        }
        catch (IOException e) {
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while writing the References file:" + nl + "   \"" + rf.getAbsolutePath() + "\"";
            System.err.println(msg);
            JOptionPane.showMessageDialog(parent, msg, "Save references", 0);
        }
        finally {
            try {
                if (properties_refFileSave != null) {
                    properties_refFileSave.close();
                }
            }
            catch (IOException e) {
                msg = "Error: \"" + e.toString() + "\"" + nl + "   while closing the References file:" + nl + "   \"" + rf.getAbsolutePath() + "\"";
                System.err.println(msg);
                JOptionPane.showMessageDialog(parent, msg, "Save references", 0);
            }
        }
    }

    public String referencesFileName() {
        return this.referenceFileName;
    }

    public ArrayList<String> splitRefs(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<String> rfs = new ArrayList<String>();
        if (text.trim().length() <= 0) {
            rfs.add("");
            return rfs;
        }
        Scanner s = new Scanner(text.trim());
        s.useDelimiter("\\s*\\+\\s*|\\s*,\\s*|\\s*;\\s*");
        s.useLocale(Locale.ENGLISH);
        while (s.hasNext()) {
            String token = s.next();
            if (this.dbg) {
                System.out.println("token = \"" + token + "\"");
            }
            rfs.add(token);
        }
        s.close();
        if (this.dbg) {
            System.out.println(Arrays.toString(rfs.toArray()));
        }
        return rfs;
    }

    public Object[] referenceKeys() {
        if (this.propertiesRefs == null || this.propertiesRefs.size() <= 0) {
            System.out.println("- - - - -" + nl + "Warning in \"referenceKeys()\": there are no reference keys" + nl + "- - - - -");
            return null;
        }
        return this.propertiesRefs.keySet().toArray();
    }

    public String isRefThere(String key) {
        if (key == null || key.trim().length() <= 0) {
            return null;
        }
        if (this.propertiesRefs == null || this.propertiesRefs.size() <= 0) {
            System.out.println("- - - - -" + nl + "Warning in \"isRefThere\": the reference file has not yet been read." + nl + "- - - - -");
            return null;
        }
        String refText = this.propertiesRefs.getProperty(key.trim());
        if (refText == null || refText.length() <= 0) {
            return null;
        }
        return refText.trim();
    }

    public synchronized boolean setRef(String key, String txt) {
        if (this.propertiesRefs == null || this.propertiesRefs.size() <= 0) {
            System.out.println("- - - - -" + nl + "Warning in \"setRef\": there are no references yet." + nl + "- - - - -");
            if (this.propertiesRefs == null) {
                this.propertiesRefs = new SortedProperties();
            }
        }
        if (key == null || key.trim().length() <= 0) {
            return false;
        }
        if (txt == null || txt.trim().length() <= 0) {
            this.propertiesRefs.remove((Object)key.trim());
        } else {
            this.propertiesRefs.setProperty(key.trim(), txt.trim());
        }
        return true;
    }

    public String refsAsString(ArrayList<String> refKeys) {
        if (this.dbg) {
            System.out.println("\"refsAsString\" - References read from file:");
            this.propertiesRefs.list(System.out);
        }
        if (refKeys == null || refKeys.isEmpty()) {
            return "(no references)";
        }
        StringBuilder allReferences = new StringBuilder();
        StringBuilder refKey = new StringBuilder();
        for (int i = 0; i < refKeys.size(); ++i) {
            if (refKeys.get(i) == null || refKeys.get(i).trim().length() <= 0) continue;
            refKey.delete(0, refKey.length());
            refKey.append(refKeys.get(i).trim());
            if (allReferences.length() > 0) {
                allReferences.append("- - - - - - - - - - - - - - -");
                allReferences.append(nl);
            }
            allReferences.append(refKey.toString());
            allReferences.append(":");
            allReferences.append(nl);
            allReferences.append(nl);
            if (this.dbg) {
                System.out.println(" looking for \"" + refKey.toString() + "\"");
            }
            if (refKey.toString().length() <= 0) continue;
            String refText = this.propertiesRefs.getProperty(refKey.toString());
            if (refText == null || refText.length() <= 0) {
                refText = "reference not found in file" + nl + "  \"" + this.referenceFileName + "\"";
            }
            allReferences.append(refText);
            if (allReferences.charAt(allReferences.length() - 1) == '\n' || allReferences.charAt(allReferences.length() - 1) == '\r') continue;
            allReferences.append(nl);
        }
        return allReferences.toString();
    }

    public String refsAsString(String refs) {
        return this.refsAsString(this.splitRefs(refs));
    }

    public void displayRefs(Frame parent, boolean modal, String species, ArrayList<String> refKeys) {
        if (this.propertiesRefs == null || this.propertiesRefs.size() <= 0) {
            System.out.println("- - - - -" + nl + "Error in \"displayRefs\":" + nl + "the reference file has not yet been read." + nl + "- - - - -");
            return;
        }
        if (refKeys == null || refKeys.isEmpty()) {
            String msg = "There are no references ";
            msg = species == null || species.trim().length() <= 0 ? msg + "to show" : msg + "for " + species + ".";
            JOptionPane.showMessageDialog(parent, msg, "No references", 1);
            return;
        }
        ReferenceDisplayDialog dr = new ReferenceDisplayDialog(parent, true, species, refKeys);
        dr.setVisible(true);
    }

    private class ReferenceDisplayDialog
    extends JDialog {
        private JButton jButtonClose;
        private JLabel jLabelRef;
        private JPanel jPanel;
        private JScrollPane jScrollPane;
        private JTextArea jTextArea;
        private Dimension windowSize;
        private boolean loading;

        private ReferenceDisplayDialog(Frame parent, boolean modal, String species, ArrayList<String> refKeys) {
            int top;
            int left;
            super(parent, modal);
            this.windowSize = new Dimension(280, 170);
            this.loading = true;
            this.initComponents();
            if (species == null || species.trim().length() <= 0) {
                if (References.this.dbg) {
                    System.out.println("Warning in \"ReferenceDisplayDialog\": empty species name.");
                }
                species = "";
            }
            this.setDefaultCloseOperation(0);
            KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
            this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
            AbstractAction escAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReferenceDisplayDialog.this.closeWindow();
                }
            };
            this.getRootPane().getActionMap().put("ESCAPE", escAction);
            KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
            this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
            this.getRootPane().getActionMap().put("ALT_Q", escAction);
            KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
            this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
            this.getRootPane().getActionMap().put("ALT_X", escAction);
            if (species.trim().length() > 0) {
                this.setTitle("Reference(s) for \"" + species + "\"");
            } else {
                this.setTitle("Reference(s)");
            }
            if (parent != null) {
                left = Math.max(0, parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2);
                top = Math.max(0, parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2);
            } else {
                left = Math.max(0, (((References)References.this).screenSize.width - this.getWidth()) / 2);
                top = Math.max(0, (((References)References.this).screenSize.height - this.getHeight()) / 2);
            }
            this.setLocation(Math.min(((References)References.this).screenSize.width - this.getWidth() - 20, left), Math.min(((References)References.this).screenSize.height - this.getHeight() - 20, top));
            if (refKeys == null || refKeys.isEmpty()) {
                this.jScrollPane.setVisible(false);
                this.jLabelRef.setText("(No reference(s))");
                return;
            }
            if (References.this.dbg) {
                System.out.println("References read from file:");
                References.this.propertiesRefs.list(System.out);
            }
            this.jTextArea.setText("");
            this.jTextArea.append(References.this.refsAsString(refKeys));
            this.jTextArea.setCaretPosition(0);
            this.jButtonClose.requestFocusInWindow();
            this.windowSize = this.getSize();
            this.loading = false;
        }

        private void initComponents() {
            this.jPanel = new JPanel();
            this.jLabelRef = new JLabel();
            this.jButtonClose = new JButton();
            this.jScrollPane = new JScrollPane();
            this.jTextArea = new JTextArea();
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ReferenceDisplayDialog.this.formWindowClosing(evt);
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    ReferenceDisplayDialog.this.formComponentResized(evt);
                }
            });
            this.jPanel.setLayout(new BorderLayout());
            this.jLabelRef.setText("Reference(s):");
            this.jPanel.add((Component)this.jLabelRef, "West");
            this.jButtonClose.setMnemonic('c');
            this.jButtonClose.setText("Close");
            this.jButtonClose.setMargin(new Insets(1, 2, 1, 2));
            this.jButtonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ReferenceDisplayDialog.this.jButtonCloseActionPerformed(evt);
                }
            });
            this.jPanel.add((Component)this.jButtonClose, "East");
            this.getContentPane().add((Component)this.jPanel, "First");
            this.jTextArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    ReferenceDisplayDialog.this.jTextAreaKeyPressed(evt);
                }

                @Override
                public void keyTyped(KeyEvent evt) {
                    ReferenceDisplayDialog.this.jTextAreaKeyTyped(evt);
                }
            });
            this.jTextArea.setLineWrap(true);
            this.jTextArea.setWrapStyleWord(true);
            this.jTextArea.setColumns(40);
            this.jTextArea.setRows(9);
            this.jScrollPane.setViewportView(this.jTextArea);
            this.getContentPane().add((Component)this.jScrollPane, "Center");
            this.pack();
        }

        private void jTextAreaKeyPressed(KeyEvent evt) {
            int ctrl = 128;
            if ((evt.getModifiersEx() & ctrl) == ctrl && (evt.getKeyCode() == 86 || evt.getKeyCode() == 88)) {
                evt.consume();
                return;
            }
            if (evt.getKeyCode() == 10) {
                this.closeWindow();
                evt.consume();
                return;
            }
            if (evt.getKeyCode() == 9) {
                evt.consume();
                return;
            }
            if (evt.getKeyCode() == 127) {
                evt.consume();
                return;
            }
            if (evt.getKeyCode() == 8) {
                evt.consume();
            }
        }

        private void jTextAreaKeyTyped(KeyEvent evt) {
            evt.consume();
        }

        private void formWindowClosing(WindowEvent evt) {
            this.closeWindow();
        }

        private void formComponentResized(ComponentEvent evt) {
            if (this.loading || this.windowSize == null) {
                return;
            }
            int x = this.getX();
            int y = this.getY();
            int w = this.getWidth();
            int h = this.getHeight();
            int nw = Math.max(w, Math.round((float)this.windowSize.getWidth()));
            int nh = Math.max(h, Math.round((float)this.windowSize.getHeight()));
            int nx = x;
            int ny = y;
            if (x + nw > ((References)References.this).screenSize.width) {
                nx = ((References)References.this).screenSize.width - nw;
            }
            if (y + nh > ((References)References.this).screenSize.height) {
                ny = ((References)References.this).screenSize.height - nh;
            }
            if (x != nx || y != ny) {
                this.setLocation(nx, ny);
            }
            if (w != nw || h != nh) {
                this.setSize(nw, nh);
            }
        }

        private void jButtonCloseActionPerformed(ActionEvent evt) {
            this.closeWindow();
        }

        private void closeWindow() {
            this.dispose();
        }
    }
}

