/*
 * Decompiled with CFR 0.152.
 */
package chemicalDiagramsHelp;

import chemicalDiagramsHelp.ClassLocator;
import chemicalDiagramsHelp.OneInstance;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.SwingHelpUtilities;
import javax.help.UnsupportedOperationException;
import javax.help.WindowPresentation;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class HelpWindow {
    private static final String VERS = "2015-May-18";
    private static boolean dbg = false;
    private static boolean started = false;
    private static HelpWindow helpWindow;
    private static String jarName;
    public JFrame hFrame = null;
    private HelpSet hs = null;
    HelpBroker hb;
    private JPanel jPanel_font_size;
    private JComboBox jComboBox_font;
    private JComboBox jComboBox_size;
    private JLabel jLabel_status;
    private boolean isSlave = false;
    private String helpSetFileNameWithPath;
    private static String progName;
    private File fileINI = null;
    private static final String fileINI_name = "Chem_Diagr_Help.ini";
    private int left;
    private int top;
    private int width;
    private int height;
    private String hbFont;
    private int hbSize;
    private int windowState;
    private static final String nl;
    private static final String SLASH;

    private HelpWindow(boolean isSlave0) {
        int i;
        ErrMsgBx mb;
        String msg;
        this.isSlave = isSlave0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                helpWindow = HelpWindow.this;
            }
        });
        SwingHelpUtilities.setContentViewerUI("chemicalDiagramsHelp.ExternalLinkContentViewerUI");
        this.readIni();
        ClassLoader cl = HelpWindow.class.getClassLoader();
        String def_HelpSetFileName = "helpset.hs";
        String helpSetFileName = null;
        if (jarName == null) {
            helpSetFileName = "javahelp/helpset.hs";
        } else {
            try {
                URL url;
                Enumeration<URL> e = cl.getResources("META-INF/MANIFEST.MF");
                while (e.hasMoreElements() && (helpSetFileName = new Manifest((url = e.nextElement()).openStream()).getMainAttributes().getValue("Helpset")) == null) {
                }
            }
            catch (IOException ex) {
                msg = "Error \"" + ex.toString() + "\"";
                mb = new ErrMsgBx(msg, progName);
            }
        }
        if (helpSetFileName == null) {
            if (dbg && jarName != null) {
                System.out.println(progName + "- Warning: value \"Helpset\" not found in jar-file manifest: \"" + jarName + SLASH + "META-INF/MANIFEST.MF" + "\"");
            }
            helpSetFileName = "javahelp/helpset.hs";
        }
        if (!this.getHelpSet(cl, helpSetFileName)) {
            this.end_program();
            return;
        }
        if (this.hs != null) {
            // empty if block
        }
        if (this.hs != null) {
            this.helpSetFileNameWithPath = jarName != null ? jarName + "$" + helpSetFileName : this.hs.getHelpSetURL().getFile();
            if (dbg) {
                System.out.println(progName + "- Found helpset URL=\"" + this.helpSetFileNameWithPath + "\"");
            }
        } else {
            String msg2 = "Error: HelpSet \"helpset.hs\" not found!";
            if (jarName != null) {
                msg2 = msg2 + nl + "in jar-file: " + jarName;
            }
            ErrMsgBx mb2 = new ErrMsgBx(msg2, progName);
            this.end_program();
            return;
        }
        String msgEx = null;
        try {
            if (this.hb == null) {
                if (dbg) {
                    System.out.println(progName + "- creating helpBroker");
                }
                this.hb = this.hs.createHelpBroker();
            }
        }
        catch (Exception e) {
            this.hb = null;
            msgEx = e.toString();
        }
        if (this.hb == null) {
            msg = msgEx == null ? "Error: Could not create HelpBroker for HelpSet:" + nl + "\"" + this.helpSetFileNameWithPath + "\"." : "Error: " + msgEx + nl + "Can not create HelpBroker for HelpSet:" + nl + "\"" + this.helpSetFileNameWithPath + "\".";
            mb = new ErrMsgBx(msg, progName);
            this.end_program();
            return;
        }
        DefaultHelpBroker dhb = (DefaultHelpBroker)this.hb;
        try {
            if (this.hb.getCurrentView() == null) {
                if (dbg) {
                    System.out.println(progName + "- initPresentation();");
                }
                this.hb.initPresentation();
            }
        }
        catch (UnsupportedOperationException ex) {
            ErrMsgBx mb3 = new ErrMsgBx(ex.toString(), progName);
        }
        WindowPresentation wp = ((DefaultHelpBroker)this.hb).getWindowPresentation();
        if (wp == null) {
            if (dbg) {
                System.out.println(progName + "- initPresentation()");
            }
            this.hb.initPresentation();
            wp = ((DefaultHelpBroker)this.hb).getWindowPresentation();
        }
        this.hFrame = (JFrame)wp.getHelpWindow();
        this.hFrame.setDefaultCloseOperation(0);
        this.hFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HelpWindow.this.end_program();
            }
        });
        String iconName = "images/help_16x16.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            Image icon = new ImageIcon(imgURL).getImage();
            this.hFrame.setIconImage(icon);
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                try {
                    Class<?> c = Class.forName("com.apple.eawt.Application");
                    Method m = c.getDeclaredMethod("setDockIconImage", Image.class);
                    Object i2 = c.newInstance();
                    URL iconURL = this.getClass().getResource("images/help_48x48.gif");
                    if (iconURL != null) {
                        icon = new ImageIcon(iconURL).getImage();
                    }
                    Object[] paramsObj = new Object[]{icon};
                    m.invoke(i2, paramsObj);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e.getMessage());
                }
            }
        } else {
            System.err.println(progName + "- Error: Could not load image = \"" + iconName + "\"");
        }
        this.jPanel_font_size = new JPanel();
        this.jComboBox_font = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.jComboBox_size = new JComboBox();
        this.jComboBox_size.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"}));
        FlowLayout jPanel_Layout = new FlowLayout(3);
        this.jPanel_font_size.setLayout(jPanel_Layout);
        this.jPanel_font_size.add(this.jComboBox_font);
        this.jPanel_font_size.add(this.jComboBox_size);
        this.jPanel_font_size.add(Box.createHorizontalGlue());
        this.hFrame.getContentPane().add((Component)this.jPanel_font_size, "First");
        this.jComboBox_font.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpWindow.this.hbFont = HelpWindow.this.jComboBox_font.getSelectedItem().toString();
                Font f = HelpWindow.this.hb.getFont();
                HelpWindow.this.hb.setFont(new Font(HelpWindow.this.hbFont, 0, f.getSize()));
            }
        });
        this.jComboBox_size.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpWindow.this.hbSize = Integer.parseInt(HelpWindow.this.jComboBox_size.getSelectedItem().toString());
                float fSize = new Float(HelpWindow.this.hbSize).floatValue();
                HelpWindow.this.hb.setFont(HelpWindow.this.hb.getFont().deriveFont(fSize - 0.5f));
                HelpWindow.this.hb.setFont(HelpWindow.this.hb.getFont().deriveFont(fSize));
            }
        });
        this.jLabel_status = new JLabel(" ");
        this.jLabel_status.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        this.hFrame.getContentPane().add((Component)this.jLabel_status, "Last");
        this.jLabel_status.setText("Helpset: " + this.helpSetFileNameWithPath);
        this.hb.setDisplayed(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.hFrame.setLocation(Math.min(screenSize.width - 100, Math.max(0, this.left)), Math.min(screenSize.height - 100, Math.max(0, this.top)));
        this.hFrame.setSize(Math.max(325, this.width), Math.max(215, this.height));
        this.hFrame.validate();
        this.hFrame.setExtendedState(this.windowState);
        int found = -1;
        for (i = 0; i < this.jComboBox_font.getItemCount(); ++i) {
            if (!this.jComboBox_font.getItemAt(i).toString().toLowerCase().startsWith(this.hbFont.toLowerCase())) continue;
            this.jComboBox_font.setSelectedIndex(i);
            found = i;
            break;
        }
        if (found < 0) {
            this.hbFont = "Times";
            for (i = 0; i < this.jComboBox_font.getItemCount(); ++i) {
                if (!this.jComboBox_font.getItemAt(i).toString().toLowerCase().startsWith(this.hbFont.toLowerCase())) continue;
                this.jComboBox_font.setSelectedIndex(i);
                break;
            }
        }
        found = -1;
        for (i = 0; i < this.jComboBox_size.getItemCount(); ++i) {
            if (Float.parseFloat(this.jComboBox_size.getItemAt(i).toString()) != (float)this.hbSize) continue;
            this.jComboBox_size.setSelectedIndex(i);
            found = i;
            break;
        }
        if (found < 0) {
            this.hbSize = 14;
            for (i = 0; i < this.jComboBox_size.getItemCount(); ++i) {
                if (Float.parseFloat(this.jComboBox_size.getItemAt(i).toString()) != (float)this.hbSize) continue;
                this.jComboBox_size.setSelectedIndex(i);
                break;
            }
        }
    }

    public static HelpWindow getInstance() {
        return helpWindow;
    }

    public void setHelpID(String startHelpID) {
        block10: {
            if (startHelpID == null || startHelpID.length() <= 0) {
                return;
            }
            this.bringToFront();
            if (helpWindow != null && HelpWindow.helpWindow.hb != null) {
                if (dbg) {
                    System.out.println(progName + "- setHelpID using \"" + startHelpID + "\"");
                }
                try {
                    HelpWindow.helpWindow.hb.setCurrentID(startHelpID);
                }
                catch (BadIDException ex) {
                    String msg = "Error: can not set help ID to: \"" + startHelpID + "\"";
                    System.out.println(progName + "- " + msg);
                    if (this.hFrame != null) {
                        JOptionPane.showMessageDialog(this.hFrame, msg, progName, 0);
                        break block10;
                    }
                    ErrMsgBx mb = new ErrMsgBx(msg, progName);
                }
            } else {
                String msg = progName + "- Warning: in setHelpID ";
                if (helpWindow == null) {
                    msg = msg + "helpWindow = \"null\".";
                } else if (HelpWindow.helpWindow.hb == null) {
                    msg = msg + "HelpBroker = \"null\".";
                }
                System.out.println(msg);
            }
        }
    }

    public void bringToFront() {
        if (helpWindow != null && HelpWindow.helpWindow.hFrame != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    helpWindow.hFrame.setVisible(true);
                    if ((helpWindow.hFrame.getExtendedState() & 1) == 1) {
                        helpWindow.hFrame.setExtendedState(0);
                    }
                    helpWindow.hFrame.setAlwaysOnTop(true);
                    helpWindow.hFrame.toFront();
                    helpWindow.hFrame.requestFocus();
                    helpWindow.hFrame.setAlwaysOnTop(false);
                }
            });
        }
    }

    private void end_program() {
        if (this.isSlave) {
            if (this.hFrame == null) {
                return;
            }
            if (dbg) {
                System.out.println(progName + " - - - - setVisible(false) - - - -");
            }
            this.hFrame.setVisible(false);
            return;
        }
        if (this.fileINI != null) {
            this.saveIni(this.fileINI);
        }
        if (dbg) {
            System.out.println(progName + " - - - - end_program - - - -");
        }
        if (this.hFrame != null) {
            this.hFrame.dispose();
        }
        this.hFrame = null;
        helpWindow = null;
        OneInstance.endCheckOtherInstances();
    }

    public static void main(String[] args) {
        String msg;
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("-dbg") || args[0].equalsIgnoreCase("/dbg")) {
                dbg = true;
                args[0] = "";
                if (args.length > 1) {
                    args[0] = args[1];
                    args[1] = "";
                }
            }
            if (args.length > 1 && (args[1].equalsIgnoreCase("-dbg") || args[1].equalsIgnoreCase("/dbg"))) {
                dbg = true;
                args[1] = "";
            }
        }
        if (dbg) {
            System.out.println(progName + "- (version " + VERS + ") - Starting...");
        }
        try {
            Class<?> c = Class.forName("javax.help.HelpSet");
        }
        catch (ClassNotFoundException ex) {
            String t = "Error - file \"jh.jar\" not found. Can Not show help.";
            System.out.println(progName + "- " + t);
            ErrMsgBx mb = new ErrMsgBx(t, progName);
            return;
        }
        if (new OneInstance().findOtherInstance(args, 56100, progName, dbg)) {
            System.out.println("---- Already running.");
            return;
        }
        JarFile jarFile = HelpWindow.getRunningJarFile();
        if (jarFile != null) {
            jarName = HelpWindow.getRunningJarFile().getName();
            File jf = new File(jarName);
            jarName = jf.getName();
        }
        if (jarName != null) {
            progName = jarName.toLowerCase().endsWith(".jar") ? jarName.substring(0, jarName.lastIndexOf(".")) : jarName;
        }
        try {
            System.out.println(progName + "- setting look-and-feel: \"System\"");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println(progName + "- " + e.getMessage());
        }
        final String helpID = args.length > 0 ? (args[0].trim().length() > 1 ? args[0] : null) : null;
        if (helpWindow != null && HelpWindow.helpWindow.hb != null) {
            if (dbg) {
                msg = progName + "- helpWindow not null";
                if (helpID != null) {
                    msg = msg + ";  helpID=\"" + helpID + "\"";
                }
                System.out.println(msg);
            }
            if (helpID != null && helpID.length() > 0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (dbg) {
                            System.out.println(progName + "- helpWindow.setHelpID(" + helpID + ")");
                        }
                        helpWindow.setHelpID(helpID);
                    }
                });
            }
        }
        if (dbg) {
            msg = progName + "- Starting HelpWindow - (version " + VERS + ")";
            if (helpID != null) {
                msg = msg + ";  helpID=\"" + helpID + "\"";
            }
            System.out.println(msg);
        }
        String callingClass = ClassLocator.getCallerClassName();
        if (dbg) {
            System.out.println(progName + "- Has been called from:  " + callingClass);
        }
        boolean standAlone = true;
        if (!callingClass.contains("HelpWindow")) {
            if (dbg) {
                System.out.println(progName + "- Stand alone = false");
            }
            standAlone = false;
        } else if (dbg) {
            System.out.println(progName + "- Stand alone = true");
        }
        final boolean isSlave0 = !standAlone;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpWindow hw = HelpWindow.getInstance();
                if (hw == null) {
                    if (dbg) {
                        System.out.println(progName + "- No previous instance found. Constructing.");
                    }
                    HelpWindow helpWindow = new HelpWindow(isSlave0);
                } else {
                    if (dbg) {
                        System.out.println(progName + "- Previous instance found. bringToFront();");
                    }
                    hw.bringToFront();
                }
                if (helpID != null && helpID.length() > 0) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HelpWindow hw = HelpWindow.getInstance();
                            if (hw != null && hw.hb != null) {
                                if (dbg) {
                                    System.out.println(progName + "- HelpWindow.main: setHelpID(" + helpID + ")");
                                }
                                hw.setHelpID(helpID);
                            } else if (dbg) {
                                System.out.println(progName + "- HelpWindow.main: getInstance() is null");
                            }
                        }
                    });
                }
            }
        });
    }

    private boolean getHelpSet(ClassLoader cl, String HelpSetFileName) {
        URL hs_Url;
        try {
            hs_Url = HelpSet.findHelpSet(cl, HelpSetFileName);
        }
        catch (NoClassDefFoundError ex) {
            String msg = "Serious Error: \"" + ex.toString() + "\"" + nl + "Library \"lib" + File.separator + "jh.jar\" not found!";
            ErrMsgBx mb = new ErrMsgBx(msg, progName);
            return false;
        }
        if (hs_Url != null) {
            try {
                this.hs = new HelpSet(cl, hs_Url);
            }
            catch (HelpSetException ex) {
                String msg = "HelpSet error: \"" + ex.toString() + "\"" + nl + "for HelpSet URL = \"" + hs_Url.getPath() + "\"";
                System.out.println(progName + "- " + msg);
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
                this.hs = null;
                return true;
            }
        }
        if (this.hs == null && dbg) {
            System.out.println(progName + "- Note: HelpSet \"" + HelpSetFileName + "\" not found in class loader.");
        }
        return true;
    }

    private void readIni() {
        boolean ok;
        File fileINInotRO;
        File fileRead;
        block23: {
            String home;
            boolean readOk;
            File p;
            block21: {
                block22: {
                    this.iniDefaults();
                    fileRead = null;
                    this.fileINI = null;
                    String pathApp = HelpWindow.getPathApp();
                    fileINInotRO = null;
                    if (pathApp == null || pathApp.trim().length() <= 0) break block21;
                    String dir = pathApp;
                    if (dir.endsWith(SLASH)) {
                        dir = dir.substring(0, dir.length() - 1);
                    }
                    this.fileINI = new File(dir + SLASH + fileINI_name);
                    p = new File(pathApp);
                    if (!p.exists()) break block21;
                    if (!this.fileINI.exists()) break block22;
                    readOk = this.readIni2(this.fileINI);
                    if (readOk) {
                        fileRead = this.fileINI;
                    }
                    if (!this.fileINI.canWrite()) break block21;
                    fileINInotRO = this.fileINI;
                    if (!readOk) break block21;
                    break block23;
                }
                try {
                    File tmp = File.createTempFile("cdHelp", ".tmp", p);
                    ok = tmp.exists();
                    if (ok) {
                        tmp.delete();
                    }
                }
                catch (IOException ex) {
                    ok = false;
                }
                if (ok && fileINInotRO == null) {
                    fileINInotRO = this.fileINI;
                }
            }
            ArrayList<String> dirs = new ArrayList<String>(5);
            String appD = System.getenv("APPDATA");
            if (appD != null && appD.trim().length() > 0 && (p = new File(appD)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            String homeDrv = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homePath != null && homePath.trim().length() > 0 && !homePath.startsWith(SLASH)) {
                homePath = SLASH + homePath;
            }
            if (homeDrv != null && homeDrv.trim().length() > 0 && homeDrv.endsWith(SLASH)) {
                homeDrv = homeDrv.substring(0, homeDrv.length() - 1);
            }
            if (homeDrv != null && homeDrv.trim().length() > 0 && homePath != null && homePath.trim().length() > 0 && (p = new File(homeDrv + homePath)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            if ((home = System.getenv("HOME")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            if ((home = System.getProperty("user.home")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            for (String t : dirs) {
                if (t.endsWith(SLASH)) {
                    t = t.substring(0, t.length() - 1);
                }
                this.fileINI = new File(t + SLASH + fileINI_name);
                if (this.fileINI.exists()) {
                    readOk = this.readIni2(this.fileINI);
                    if (readOk) {
                        fileRead = this.fileINI;
                    }
                    if (!this.fileINI.canWrite()) continue;
                    if (fileINInotRO == null) {
                        fileINInotRO = this.fileINI;
                    }
                    if (!readOk) continue;
                    break;
                }
                try {
                    p = new File(t);
                    File tmp = File.createTempFile("cdHelp", ".tmp", p);
                    ok = tmp.exists();
                    if (ok) {
                        tmp.delete();
                    }
                }
                catch (IOException ex) {
                    ok = false;
                }
                if (!ok || fileINInotRO != null) continue;
                fileINInotRO = this.fileINI;
            }
        }
        if (fileINInotRO != null && fileINInotRO != fileRead) {
            ok = this.saveIni(fileINInotRO);
            this.fileINI = ok ? fileINInotRO : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readIni2(File f) {
        ErrMsgBx mb;
        String msg;
        System.out.flush();
        System.out.println(progName + "- Reading ini-file: \"" + f.getPath() + "\"");
        Properties ini = new Properties();
        FileInputStream properties_iniFile = null;
        boolean ok = true;
        try {
            properties_iniFile = new FileInputStream(f);
            ini.load(properties_iniFile);
        }
        catch (FileNotFoundException e) {
            System.out.println(progName + "- Warning: file Not found: \"" + f.getPath() + "\"" + nl + "    using default parameter values.");
            ok = false;
        }
        catch (IOException e) {
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while loading INI-file:" + nl + "   \"" + f.getPath() + "\"";
            mb = new ErrMsgBx(msg, progName);
            ok = false;
        }
        try {
            if (properties_iniFile != null) {
                properties_iniFile.close();
            }
        }
        catch (IOException e) {
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while closing INI-file:" + nl + "   \"" + f.getPath() + "\"";
            mb = new ErrMsgBx(msg, progName);
            ok = false;
        }
        finally {
            try {
                if (properties_iniFile != null) {
                    properties_iniFile.close();
                }
            }
            catch (IOException e) {
                msg = "Error: \"" + e.toString() + "\"" + nl + "   while closing INI-file:" + nl + "   \"" + f.getPath() + "\"";
                mb = new ErrMsgBx(msg, progName);
            }
        }
        if (!ok) {
            return ok;
        }
        try {
            this.left = Integer.parseInt(ini.getProperty("left"));
            this.top = Integer.parseInt(ini.getProperty("top"));
            this.width = Integer.parseInt(ini.getProperty("width"));
            this.height = Integer.parseInt(ini.getProperty("height"));
            this.hbFont = ini.getProperty("font");
            this.hbSize = Integer.parseInt(ini.getProperty("font_size"));
            this.windowState = Integer.parseInt(ini.getProperty("window_state"));
        }
        catch (NumberFormatException e) {
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while reading INI-file:" + nl + "   \"" + f.getPath() + "\"" + nl + nl + "Setting default program parameters.";
            mb = new ErrMsgBx(msg, progName);
            ok = false;
        }
        if (dbg) {
            System.out.println(progName + "- Finished reading ini-file");
        }
        System.out.flush();
        this.checkIniValues();
        return ok;
    }

    private void checkIniValues() {
        this.left = Math.max(0, this.left);
        this.top = Math.max(0, this.top);
        this.width = Math.max(325, this.width);
        this.height = Math.max(215, this.height);
        this.hbSize = Math.max(8, Math.min(this.hbSize, 72));
        if (this.windowState != 0 && this.windowState != 6) {
            this.windowState = 0;
        }
    }

    private void iniDefaults() {
        this.left = 55;
        this.top = 0;
        this.width = 600;
        this.height = 550;
        this.hbFont = "Times";
        this.hbSize = 14;
        this.windowState = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveIni(File f) {
        if (f == null) {
            String msg = "Programming error in \"Save_ini()\".";
            System.out.println(progName + "- " + msg);
            ErrMsgBx mb = new ErrMsgBx(msg, progName);
            return false;
        }
        if (dbg) {
            System.out.println(progName + "- Writing ini-file " + f);
        }
        boolean ok = true;
        if (helpWindow != null && HelpWindow.helpWindow.hFrame != null) {
            if ((HelpWindow.helpWindow.hFrame.getExtendedState() & 6) != 6) {
                this.left = HelpWindow.helpWindow.hFrame.getX();
                this.top = HelpWindow.helpWindow.hFrame.getY();
                this.width = HelpWindow.helpWindow.hFrame.getWidth();
                this.height = HelpWindow.helpWindow.hFrame.getHeight();
            }
            this.windowState = HelpWindow.helpWindow.hFrame.getExtendedState();
        }
        Properties ini = new Properties();
        ini.setProperty("width", String.valueOf(this.width));
        ini.setProperty("height", String.valueOf(this.height));
        ini.setProperty("left", String.valueOf(this.left));
        ini.setProperty("top", String.valueOf(this.top));
        ini.setProperty("font", this.hbFont);
        ini.setProperty("font_size", String.valueOf(this.hbSize));
        ini.setProperty("window_state", String.valueOf(this.windowState));
        FileOutputStream iniFile = null;
        try {
            iniFile = new FileOutputStream(f);
            ini.store(iniFile, null);
        }
        catch (IOException ex) {
            String msg = "Error \"" + ex.toString() + "\"" + nl + "while writing INI-file: \"" + f.toString() + "\"";
            System.out.println(progName + "- " + msg);
            ErrMsgBx mb = new ErrMsgBx(msg, progName);
            ok = false;
        }
        finally {
            try {
                if (iniFile != null) {
                    iniFile.close();
                }
            }
            catch (IOException e) {
                ok = false;
            }
        }
        return ok;
    }

    private static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "- - - - - -" + System.getProperty("line.separator") + sw.toString() + "- - - - - -";
        }
        catch (Exception e2) {
            return "Internal error in \"stack2string(Exception e)\"";
        }
    }

    public static String getPathApp() {
        String path;
        C c = new C();
        try {
            URI dir = c.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (dir != null) {
                String d = dir.toString();
                if (d.startsWith("jar:") && d.endsWith("!/")) {
                    d = d.substring(4, d.length() - 2);
                    dir = new URI(d);
                }
                path = new File(dir.getPath()).getParent();
            } else {
                path = System.getProperty("user.dir");
            }
        }
        catch (URISyntaxException e) {
            if (!started) {
                ErrMsgBx emb = new ErrMsgBx("Error: " + e.toString() + nl + "   trying to get the application's directory.", progName);
            }
            path = System.getProperty("user.dir");
        }
        started = true;
        return path;
    }

    public static JarFile getRunningJarFile() {
        C c = new C();
        String className = c.getClass().getName().replace('.', '/');
        URL url = c.getClass().getResource("/" + className + ".class");
        if (url.toString().startsWith("jar:")) {
            try {
                JarURLConnection jUrlC = (JarURLConnection)url.openConnection();
                return jUrlC.getJarFile();
            }
            catch (IOException ex) {
                ErrMsgBx mb = new ErrMsgBx("Error " + ex.toString(), progName);
                return null;
            }
        }
        return null;
    }

    static {
        jarName = null;
        progName = HelpWindow.class.getPackage().getName();
        nl = System.getProperty("line.separator");
        SLASH = File.separator;
    }

    static class ErrMsgBx {
        public ErrMsgBx(String msg, String title) {
            if (msg == null || msg.trim().length() <= 0) {
                System.err.println("--- MsgBox: null or empty \"message\".");
                return;
            }
            if (title == null || title.length() <= 0) {
                title = " Error:";
            }
            Frame frame = new Frame(title);
            String iconName = "images/ErrMsgBx.gif";
            URL imgURL = this.getClass().getResource(iconName);
            if (imgURL != null) {
                frame.setIconImage(new ImageIcon(imgURL).getImage());
            } else {
                System.err.println("--- Error in MsgBox constructor: Could not load image = \"" + iconName + "\"");
            }
            frame.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int left = Math.max(55, (screenSize.width - frame.getWidth()) / 2);
            int top = Math.max(10, (screenSize.height - frame.getHeight()) / 2);
            frame.setLocation(Math.min(screenSize.width - 100, left), Math.min(screenSize.height - 100, top));
            String msgText = msg.trim();
            System.out.println("--- MsgBox:" + nl + msgText + nl + "---");
            frame.setVisible(true);
            MsgBoxDialog msgBox = new MsgBoxDialog(frame, msgText, title, true);
            msgBox.setVisible(true);
            msgBox.dispose();
            frame.setVisible(false);
            frame.dispose();
        }

        private static class MsgBoxDialog
        extends Dialog {
            private Button ok;
            private Panel p;
            private final TextArea text;

            public MsgBoxDialog(Frame parent, String msg, String title, boolean modal) {
                super(parent, " " + title, modal);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        MsgBoxDialog.this.setVisible(false);
                    }
                });
                this.setLayout(new BorderLayout());
                this.p = new Panel();
                this.p.setLayout(new FlowLayout(1));
                this.ok = new Button();
                int wMax = 85;
                int hMax = 20;
                int wMin = 5;
                boolean hMin = true;
                int w = 5;
                int h = 1;
                int i = 0;
                int j = 5;
                String eol = "\n";
                String nl = System.getProperty("line.separator");
                do {
                    char c;
                    String s;
                    if ((s = String.valueOf(c = msg.charAt(i))).equals("\n") || s.equals(nl)) {
                        ++h;
                        j = 5;
                        continue;
                    }
                    w = Math.max(++j, w);
                } while (++i < msg.length() - 1);
                int scroll = 3;
                if (w > 85 && h <= 20) {
                    scroll &= 2;
                }
                if (h > 20 && w <= 85) {
                    scroll &= 1;
                }
                if (w > 85 && h > 20) {
                    scroll = 0;
                }
                w = Math.min(Math.max(w, 10), 85);
                h = Math.min(h, 20);
                this.text = new TextArea(msg, h, w, scroll);
                this.text.setEditable(false);
                this.text.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                        if (evt.getKeyCode() == 9) {
                            MsgBoxDialog.this.ok.requestFocusInWindow();
                        }
                    }
                });
                this.add((Component)this.text, "Center");
                this.ok.setLabel("OK");
                this.ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MsgBoxDialog.this.closeDialog();
                    }
                });
                this.ok.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                    }
                });
                this.p.add(this.ok);
                this.add((Component)this.p, "South");
                this.pack();
                this.setLocation(parent.getLocation());
                this.ok.requestFocusInWindow();
            }

            private void closeDialog() {
                this.setVisible(false);
            }
        }
    }

    private static class C {
        private C() {
        }

        private static void C() {
        }
    }
}

