/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.pict;

import java.io.IOException;
import java.io.OutputStream;
import org.qenherkhopeshef.graphics.pict.MacPictOpcodes;
import org.qenherkhopeshef.graphics.pict.SimpleByteBuffer;

public class MacPictDeviceContext
implements MacPictOpcodes {
    public static final int DEFAULT_RESOLUTION = 2048;
    private SimpleByteBuffer buffer = new SimpleByteBuffer();
    private boolean boundingBoxComputed = true;
    private MPRectangle boundingBox = new MPRectangle();
    private MPRectangle innerBoundingBox = null;
    private MPRectangle clipBox = null;
    private int dpi = 2048;
    private int innerBBPos;
    private int clipPos;
    private int resolutionPos;

    public MacPictDeviceContext() {
        this.writeHeader();
    }

    public MacPictDeviceContext(short minx, short miny, short maxx, short maxy) {
        this();
        this.setBoundingBox(minx, miny, maxx, maxy);
    }

    public void closePicture() {
        this.buffer.writeShortBigEndian(255);
        this.buffer.seek(512);
        this.buffer.writeShortBigEndian(this.buffer.getSize() - 512);
        this.buffer.writeShortBigEndian(this.boundingBox.getMinY());
        this.buffer.writeShortBigEndian(this.boundingBox.getMinX());
        this.buffer.writeShortBigEndian(this.boundingBox.getMaxY());
        this.buffer.writeShortBigEndian(this.boundingBox.getMaxX());
        if (this.innerBoundingBox == null) {
            this.setInnerBoundingBox(this.boundingBox.getMinX(), this.boundingBox.getMinY(), this.boundingBox.getMaxX(), this.boundingBox.getMaxY());
        }
        if (this.clipBox == null) {
            this.setClipBox(this.boundingBox.getMinX(), this.boundingBox.getMinY(), this.boundingBox.getMaxX(), this.boundingBox.getMaxY());
        }
    }

    public void fillPoly(MPPoint[] points) {
        int polyCommand = 116;
        this.processPoly(points, polyCommand);
    }

    public void framePoly(MPPoint[] points) {
        int polyCommand = 112;
        this.processPoly(points, polyCommand);
    }

    public byte[] getAsArray() {
        return this.buffer.getAsArray();
    }

    public byte[] getAsArrayForRTF() {
        return this.buffer.getAsArray(512);
    }

    public int getDpi() {
        return this.dpi;
    }

    public void line(MPPoint p1, MPPoint p2) {
        this.buffer.writeShortBigEndian(32);
        this.writePoint(p1);
        this.writePoint(p2);
    }

    public void lineFrom(MPPoint p) {
        this.buffer.writeShortBigEndian(33);
        this.writePoint(p);
    }

    public void paintPoly(MPPoint[] points) {
        int polyCommand = 116;
        this.processPoly(points, polyCommand);
    }

    public void paintRectangle(MPPoint minp, MPPoint maxp) {
        this.buffer.writeShortBigEndian(49);
        this.buffer.writeShortBigEndian(minp.y);
        this.buffer.writeShortBigEndian(minp.x);
        this.buffer.writeShortBigEndian(maxp.y);
        this.buffer.writeShortBigEndian(maxp.x);
    }

    public void paintRectangle(short minx, short miny, short maxx, short maxy) {
        this.buffer.writeShortBigEndian(49);
        this.buffer.writeShortBigEndian(miny);
        this.buffer.writeShortBigEndian(minx);
        this.buffer.writeShortBigEndian(maxy);
        this.buffer.writeShortBigEndian(maxx);
    }

    public void setBackgroundColor(int red, int green, int blue) {
        this.buffer.writeShortBigEndian(27);
        this.buffer.writeShortBigEndian(red);
        this.buffer.writeShortBigEndian(green);
        this.buffer.writeShortBigEndian(blue);
    }

    public void setBackgroundColor(MPColor color) {
        this.setBackgroundColor(color.red, color.green, color.blue);
    }

    public void setBoundingBox(short minx, short miny, short maxx, short maxy) {
        this.boundingBox = new MPRectangle(minx, miny, maxx, maxy);
        this.boundingBoxComputed = false;
    }

    public void setClipBox(short minX, short minY, short maxX, short maxY) {
        this.clipBox = new MPRectangle(minX, minY, maxX, maxY);
        int oldPos = this.buffer.getPos();
        this.buffer.seek(this.clipPos);
        this.buffer.writeShortBigEndian(minY);
        this.buffer.writeShortBigEndian(minX);
        this.buffer.writeShortBigEndian(maxY);
        this.buffer.writeShortBigEndian(maxX);
        this.buffer.seek(oldPos);
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
        int currentPos = this.buffer.getPos();
        this.buffer.seek(this.resolutionPos);
        this.buffer.writeIntBigEndian(this.getDpi() << 16);
        this.buffer.writeIntBigEndian(this.getDpi() << 16);
        this.buffer.seek(currentPos);
    }

    public void setForegroundColor(int red, int green, int blue) {
        this.buffer.writeShortBigEndian(26);
        this.buffer.writeShortBigEndian(red);
        this.buffer.writeShortBigEndian(green);
        this.buffer.writeShortBigEndian(blue);
    }

    public void setForegroundColor(MPColor color) {
        this.setForegroundColor(color.red, color.green, color.blue);
    }

    public void setHilightColor(int red, int green, int blue) {
        this.buffer.writeShortBigEndian(29);
        this.buffer.writeShortBigEndian(red);
        this.buffer.writeShortBigEndian(green);
        this.buffer.writeShortBigEndian(blue);
    }

    public void setInnerBoundingBox(short minX, short minY, short maxX, short maxY) {
        this.innerBoundingBox = new MPRectangle(minX, minY, maxX, maxY);
        int oldPos = this.buffer.getPos();
        this.buffer.seek(this.innerBBPos);
        this.buffer.writeShortBigEndian(minY);
        this.buffer.writeShortBigEndian(minX);
        this.buffer.writeShortBigEndian(maxY);
        this.buffer.writeShortBigEndian(maxX);
        this.buffer.seek(oldPos);
    }

    public void setPenMode(short mode) {
        this.buffer.writeShortBigEndian(8);
        this.buffer.writeShortBigEndian(mode);
    }

    public void setPenPattern(byte[] pattern) {
        this.buffer.writeShortBigEndian(9);
        for (int i = 0; i < pattern.length; ++i) {
            this.buffer.writeByte(pattern[i]);
        }
    }

    public void setPenSize(short xsize, short ysize) {
        this.buffer.writeShortBigEndian(7);
        this.buffer.writeShortBigEndian(ysize);
        this.buffer.writeShortBigEndian(xsize);
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        this.buffer.writeToStream(outputStream);
        outputStream.close();
    }

    private void addToBoundingBox(MPPoint p) {
        this.addToBoundingBox(p.x, p.y);
    }

    private void addToBoundingBox(short x, short y) {
        if (this.boundingBoxComputed) {
            if (this.boundingBox == null) {
                this.boundingBox = new MPRectangle(x, y, x, y);
            } else {
                this.boundingBox.add(x, y);
            }
        }
    }

    private void processPoly(MPPoint[] points, int polyCommand) {
        this.buffer.writeShortBigEndian(polyCommand);
        this.buffer.writeShortBigEndian(2 * (5 + 2 * points.length));
        if (points.length > 0) {
            int i;
            short minx = points[0].x;
            short miny = points[0].y;
            short maxx = points[0].x;
            short maxy = points[0].y;
            for (i = 1; i < points.length; ++i) {
                short x = points[i].x;
                short y = points[i].y;
                if (minx > x) {
                    minx = x;
                }
                if (maxx < x) {
                    maxx = x;
                }
                if (miny > y) {
                    miny = y;
                }
                if (maxy >= y) continue;
                maxy = y;
            }
            this.buffer.writeShortBigEndian(miny);
            this.buffer.writeShortBigEndian(minx);
            this.buffer.writeShortBigEndian(maxy);
            this.buffer.writeShortBigEndian(maxx);
            for (i = 0; i < points.length; ++i) {
                this.writePoint(points[i]);
                this.addToBoundingBox(points[i]);
            }
        } else {
            this.buffer.writeShortBigEndian(0);
            this.buffer.writeShortBigEndian(0);
            this.buffer.writeShortBigEndian(0);
            this.buffer.writeShortBigEndian(0);
        }
    }

    private void writeHeader() {
        this.buffer.seek(0);
        this.buffer.fill((byte)0, 0, 512);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(17);
        this.buffer.writeShortBigEndian(767);
        this.buffer.writeShortBigEndian(3072);
        this.buffer.writeShortBigEndian(-2);
        this.buffer.writeShortBigEndian(0);
        this.resolutionPos = this.buffer.getPos();
        this.buffer.writeIntBigEndian(this.getDpi() << 16);
        this.buffer.writeIntBigEndian(this.getDpi() << 16);
        this.innerBBPos = this.buffer.getPos();
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(1);
        this.buffer.writeShortBigEndian(10);
        this.clipPos = this.buffer.getPos();
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
        this.buffer.writeShortBigEndian(0);
    }

    private void writePoint(MPPoint p) {
        this.buffer.writeShortBigEndian(p.y);
        this.buffer.writeShortBigEndian(p.x);
    }

    public static class MPRectangle {
        private short minX;
        private short minY;
        private short maxX;
        private short maxY;

        public MPRectangle() {
        }

        public MPRectangle(short minx, short miny, short maxx, short maxy) {
            this.minX = minx;
            this.minY = miny;
            this.maxX = maxx;
            this.maxY = maxy;
        }

        public void add(short x, short y) {
            if (this.minX > x) {
                this.minX = x;
            }
            if (this.minY > y) {
                this.minY = y;
            }
            if (this.maxX < x) {
                this.maxX = x;
            }
            if (this.maxY < y) {
                this.maxY = y;
            }
        }

        public short getMaxX() {
            return this.maxX;
        }

        public short getMaxY() {
            return this.maxY;
        }

        public short getMinX() {
            return this.minX;
        }

        public short getMinY() {
            return this.minY;
        }

        public void setMaxX(short maxX) {
            this.maxX = maxX;
        }

        public void setMaxY(short maxY) {
            this.maxY = maxY;
        }

        public void setMinX(short minX) {
            this.minX = minX;
        }

        public void setMinY(short minY) {
            this.minY = minY;
        }
    }

    public static class MPPoint {
        public short x;
        public short y;

        public MPPoint(short x, short y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class MPColor {
        public int red;
        public int green;
        public int blue;

        public MPColor(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }
    }
}

