/*
 * Decompiled with CFR 0.152.
 */
package lib.huvud;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Properties;
import lib.common.Util;

public class ProgramConf {
    public String progName = null;
    public String pathAPP;
    public boolean dbg = false;
    public boolean iniFileToApplicationPath = false;
    public StringBuffer pathDef = new StringBuffer();
    public static final String HELP_JAR = "Chem_Diagr_Help.jar";
    private static final String SLASH = File.separator;
    private static final String nl = System.getProperty("line.separator");

    public ProgramConf() {
        this.dbg = false;
        this.iniFileToApplicationPath = false;
    }

    public ProgramConf(String pgName) {
        this.progName = pgName;
        this.dbg = false;
        this.iniFileToApplicationPath = false;
    }

    public void setPathDef() {
        String t = System.getProperty("user.home");
        this.setPathDef(t);
    }

    public void setPathDef(String fName) {
        File f = new File(fName);
        this.setPathDef(f);
    }

    public void setPathDef(File f) {
        URI uri;
        if (this.pathDef == null) {
            this.pathDef = new StringBuffer();
        }
        if (f != null) {
            if (!f.getPath().contains(SLASH) && this.pathDef.length() > 0) {
                return;
            }
            try {
                uri = f.toURI();
            }
            catch (Exception ex) {
                uri = null;
            }
        } else {
            uri = null;
        }
        if (this.pathDef.length() > 0) {
            this.pathDef.delete(0, this.pathDef.length());
        }
        if (uri != null) {
            if (f != null && f.isDirectory()) {
                this.pathDef.append(new File(uri.getPath()).toString());
            } else {
                this.pathDef.append(new File(uri.getPath()).getParent().toString());
            }
        } else {
            File currDir = new File("");
            try {
                this.pathDef.append(currDir.getCanonicalPath());
            }
            catch (IOException e) {
                try {
                    this.pathDef.append(System.getProperty("user.dir"));
                }
                catch (Exception e1) {
                    this.pathDef.append(".");
                }
            }
        }
    }

    public static void read_cfgFile(File fileNameCfg, ProgramConf pc) {
        boolean loadedOK;
        if (fileNameCfg == null) {
            System.err.println("Error: fileNameCfg =null in routine \"read_cfgFile\"");
            return;
        }
        if (pc == null) {
            System.err.println("Error: pc =null in routine \"read_cfgFile\"");
            return;
        }
        Properties cfg = new Properties();
        FileInputStream cfgFile = null;
        try {
            cfgFile = new FileInputStream(fileNameCfg);
            cfg.load(cfgFile);
            loadedOK = true;
        }
        catch (FileNotFoundException e) {
            System.out.println("Warning: file Not found: \"" + fileNameCfg.getPath() + "\"" + nl + "using default program options.");
            ProgramConf.write_cfgFile(fileNameCfg, pc);
            return;
        }
        catch (IOException e) {
            Util.exceptn("Error: \"" + e.toString() + "\"" + nl + "   while loading config.-file:" + nl + "   \"" + fileNameCfg.getPath() + "\"");
            loadedOK = false;
        }
        try {
            if (cfgFile != null) {
                cfgFile.close();
            }
        }
        catch (IOException e) {
            Util.exceptn("Error: \"" + e.toString() + "\"" + nl + "   while closing config.-file:" + nl + "   \"" + fileNameCfg.getPath() + "\"");
        }
        if (loadedOK) {
            try {
                System.out.println("Reading file: \"" + fileNameCfg.getPath() + "\"");
                if (cfg.getProperty("Debug") != null && cfg.getProperty("Debug").equalsIgnoreCase("true")) {
                    pc.dbg = true;
                }
                pc.iniFileToApplicationPath = cfg.getProperty("SaveIniFileToApplicationPath") != null && cfg.getProperty("SaveIniFileToApplicationPath").equalsIgnoreCase("true");
            }
            catch (Exception ex) {
                System.err.println("Error: \"" + ex.toString() + "\"" + nl + "   while reading file: \"" + fileNameCfg.getPath() + "\"");
                ProgramConf.write_cfgFile(fileNameCfg, pc);
            }
        }
    }

    private static void write_cfgFile(File fileNameCfg, ProgramConf pc) {
        PrintWriter cfgFile = null;
        try {
            cfgFile = new PrintWriter(new BufferedWriter(new FileWriter(fileNameCfg)));
        }
        catch (IOException e) {
            Util.exceptn("Error: \"" + e.toString() + "\"" + nl + "   trying to write config.-file: \"" + fileNameCfg.toString() + "\"");
            try {
                if (cfgFile != null) {
                    cfgFile.flush();
                    cfgFile.close();
                }
            }
            catch (Exception e1) {
                Util.exceptn("Error: \"" + e1.toString() + "\"" + nl + "   trying to close config.-file: \"" + fileNameCfg.toString() + "\"");
            }
            return;
        }
        cfgFile.println("# Next parameter should be \"true\" if running from a USB-memory" + nl + "#  (or a portable drive); then the ini-file will _only_ be saved" + nl + "#  in the application directory.  If the application directory" + nl + "#  is write-protected, then no ini-file will be written." + nl + "#  If not \"true\" then the ini-file is saved in one of the" + nl + "#  following paths (depending on which environment variables" + nl + "#  are defined and if the paths are not write-protected):" + nl + "#     The installation directory" + nl + "#     %APPDATA%" + nl + "#     %HOMEDRIVE%%HOMEPATH%" + nl + "#     %HOME%" + nl + "#     the user's home directory (system dependent)." + nl + "SaveIniFileToApplicationPath=false");
        pc.iniFileToApplicationPath = false;
        cfgFile.println("# Change next to \"true\" to output debugging information" + nl + "#   to the messages window.");
        if (pc.dbg) {
            cfgFile.println("Debug=true");
        } else {
            cfgFile.println("Debug=false");
        }
        cfgFile.flush();
        cfgFile.close();
        if (pc.dbg) {
            System.out.println("Written: \"" + fileNameCfg.toString() + "\"");
        }
    }
}

