/*
 * Decompiled with CFR 0.152.
 */
package plotPDF;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;

public class PlotPDF {
    private static final String progName = "PlotPDF";
    private static final String VERS = "2014-Jan-31";
    private static boolean started = false;
    private boolean dbg = false;
    private boolean doNotStop = false;
    private File pltFile;
    private String pdfFile_name;
    private File pdfFile;
    private boolean finished = false;
    private BufferedReader bufReader;
    private OutputStreamWriter outputFile;
    private boolean delete = false;
    private static final String nl = System.getProperty("line.separator");
    private static final String SLASH = File.separator;
    private static final String DASH_LINE = "- - - - - -";
    private static final Locale engl = Locale.ENGLISH;
    private String[] colours = new String[11];
    private final double[] WIDTHS = new double[]{2.82, 6.35, 0.07, 1.06};
    private final double SCALE_USER_SPACE = 0.283464566929;
    private static final double MediaBox_X = 593.0;
    private static final double MediaBox_Y = 792.0;
    private static final double MARGIN_X = 20.0;
    private static final double MARGIN_Y = 15.0;
    private int[] objBytesNoNewLine = new int[]{37, 40, 47, 85, 90, 93, 97, 87, 92, 95, 100, 70, 90, 90, 92, 96, 77, 60, 186, 98, 76, 50};
    private int[] objNbrNewLines = new int[]{2, 6, 7, 9, 9, 9, 9, 9, 9, 9, 9, 8, 9, 9, 9, 9, 8, 7, 22, 8, 8, 5};
    private static final int nlL = System.getProperty("line.separator").length();
    private final int NBR_PDF_OBJECTS = this.objBytesNoNewLine.length;
    private boolean startedPrintingText = false;
    private String changeFontString;
    private String fontSizeTxt;
    private int penNow = 0;
    private int colorNow = 0;
    private double scaleX;
    private double scaleY;
    private double zx;
    private double zy;
    private double xNow = -1.7976931348623157E308;
    private double yNow = -1.7976931348623157E308;
    private double x1st = -1.7976931348623157E308;
    private double y1st = -1.7976931348623157E308;
    private int newPath = -1;
    private boolean pdfHeader = true;
    private int pdfColors = 1;
    private boolean pdfPortrait = true;
    private int pdfFont = 2;
    private final String[] FONTS = new String[]{"Vector graphics", "Times-Roman", "Helvetica", "Courier"};
    private int pdfSizeX = 100;
    private int pdfSizeY = 100;
    private double pdfMarginB = 0.0;
    private double pdfMarginL = 0.0;
    private StringBuffer pdfStream = new StringBuffer();
    private long pdfStreanSize = 0L;
    private int pdfStreamSizeTxtLength;

    public static void main(String[] args) {
        PlotPDF pp;
        boolean h = false;
        boolean doNotS = false;
        boolean debg = false;
        System.out.println("GRAPHIC  \"Portable Document Format (PDF)\"  UTILITY               2014-Jan-31" + nl + "==================================================" + nl);
        if (args.length > 0) {
            for (String arg : args) {
                if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                    debg = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-nostop") || arg.equalsIgnoreCase("/nostop")) {
                    doNotS = true;
                    continue;
                }
                if (!arg.equals("-?") && !arg.equals("/?") && !arg.equals("?")) continue;
                h = true;
                PlotPDF.printInstructions(System.out);
            }
            if (h) {
                return;
            }
        } else {
            System.out.println("This program will convert a plot file (*.plt) into a PDF file." + nl + "Usage:   java -jar PlotPDF.jar  [plot-file-name]  [-command=value]" + nl + "For a list of possible commands type:  java -jar PlotPDF.jar  -?");
            System.exit(0);
        }
        try {
            pp = new PlotPDF(debg, doNotS, args);
        }
        catch (Exception ex) {
            PlotPDF.exception(ex, null, doNotS);
            pp = null;
        }
        if (pp != null) {
            final PlotPDF p = pp;
            Thread t = new Thread(){

                @Override
                public void run() {
                    p.synchWaitConversion();
                    p.end_program();
                }
            };
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        System.out.println("All done." + nl + DASH_LINE);
        System.exit(0);
    }

    private void end_program() {
        this.finished = true;
        this.notify_All();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    private synchronized void synchWaitConversion() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public PlotPDF(boolean debg, boolean doNotS, String[] args) {
        if (debg) {
            this.dbg = true;
        }
        this.doNotStop = doNotS;
        this.pltFile = null;
        this.pdfFile = null;
        String msg = null;
        boolean argErr = false;
        if (args != null && args.length > 0) {
            if (this.dbg) {
                System.out.println("Reading command-line arguments..." + nl);
            }
            for (int i = 0; i < args.length; ++i) {
                if (this.dbg) {
                    System.out.println("Command-line argument = \"" + args[i] + "\"");
                }
                if (i == 0 && !args[0].toLowerCase().startsWith("-p")) {
                    File f;
                    boolean ok = true;
                    String name = args[0];
                    if (name.startsWith("\"") && name.endsWith("\"")) {
                        name = name.substring(1, name.length() - 1);
                    }
                    if (!name.toLowerCase().endsWith(".plt")) {
                        name = name.concat(".plt");
                    }
                    if (!(f = new File(name)).exists()) {
                        if (this.dbg) {
                            System.out.println("Not a plt-file:  \"" + f.getAbsolutePath() + "\"");
                        }
                        ok = false;
                    }
                    if (ok && f.isDirectory()) {
                        msg = "Error: \"" + f.getAbsolutePath() + "\" is a directory.";
                        ok = false;
                    }
                    if (ok && !f.canRead()) {
                        msg = "Error: can not open file for reading:" + nl + "   \"" + f.getAbsolutePath() + "\"";
                        ok = false;
                    }
                    if (ok) {
                        if (this.dbg) {
                            System.out.println("Plot file: " + f.getPath());
                        }
                        this.pltFile = f;
                        continue;
                    }
                    if (msg != null) {
                        if (this.doNotStop) {
                            System.out.println(msg);
                        } else {
                            ErrMsgBx mb = new ErrMsgBx(msg, progName);
                        }
                    }
                }
                if (this.parseArg(args[i].trim())) continue;
                argErr = true;
                break;
            }
        }
        if (this.dbg) {
            System.out.println(nl + "Command-line arguments ended." + nl);
        }
        if (argErr) {
            this.end_program();
            return;
        }
        if (this.pltFile == null) {
            msg = "No plot file name given in the command-line.";
            if (this.doNotStop) {
                System.out.println(msg);
            } else {
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
            }
            this.end_program();
            return;
        }
        if (this.pdfFile_name != null && this.pdfFile_name.trim().length() > 0) {
            if (this.pdfFile_name.contains(SLASH)) {
                this.pdfFile = new File(this.pdfFile_name);
            } else {
                this.pdfFile = new File(this.pltFile.getParent(), this.pdfFile_name);
                if (this.dbg) {
                    System.out.println("PDF-file: \"" + this.pdfFile.getAbsolutePath() + "\"" + nl);
                }
            }
        }
        if (this.pdfFile == null) {
            String name = this.pltFile.getAbsolutePath();
            int n = name.length();
            name = name.substring(0, n - 4) + ".pdf";
            this.pdfFile = new File(name);
        }
        if (this.pdfFile.exists() && !this.pdfFile.canWrite()) {
            msg = "Error: can not write to file" + nl + "   \"" + this.pdfFile.toString() + "\"" + nl + "is the file locked?";
            if (this.doNotStop) {
                System.out.println(msg);
            } else {
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
            }
            this.end_program();
            return;
        }
        String o = "Portrait";
        if (!this.pdfPortrait) {
            o = "Landscape";
        }
        String c = "black on white";
        if (this.pdfColors == 1) {
            c = "colours";
        } else if (this.pdfColors == 2) {
            c = "colours selected in \"Spana\"";
        }
        System.out.println("plot file: " + this.maybeInQuotes(this.pltFile.getName()) + nl + "output file: " + this.maybeInQuotes(this.pdfFile.getName()) + nl + "options:" + nl + "   size " + this.pdfSizeX + "/" + this.pdfSizeY + " %;" + "    left, bottom margins = " + this.pdfMarginL + ", " + this.pdfMarginB + " cm" + nl + "   orientation = " + o + ";   font = " + this.FONTS[this.pdfFont] + nl + "   " + c);
        System.out.print("converting to ");
        System.out.println("PDF ...");
        try {
            this.convert2PDF();
        }
        catch (Exception ex) {
            PlotPDF.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
        try {
            if (this.bufReader != null) {
                this.bufReader.close();
            }
        }
        catch (IOException ex) {
            PlotPDF.exception(ex, "while closing file:" + nl + "   \"" + this.pltFile + "\"", this.doNotStop);
        }
        if (this.outputFile != null) {
            try {
                this.outputFile.flush();
                this.outputFile.close();
            }
            catch (IOException ex) {
                PlotPDF.exception(ex, "while closing file:" + nl + "   \"" + this.pdfFile + "\"", this.doNotStop);
            }
        }
        if (this.delete) {
            this.pdfFile.delete();
        }
        this.end_program();
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseArg(String arg) {
        block52: {
            block59: {
                block49: {
                    block58: {
                        block57: {
                            block56: {
                                block55: {
                                    block50: {
                                        block54: {
                                            block53: {
                                                block51: {
                                                    if (arg == null) {
                                                        return true;
                                                    }
                                                    if (arg.length() <= 0) {
                                                        return true;
                                                    }
                                                    if (arg.equals("-?") || arg.equals("/?") || arg.equals("?")) {
                                                        PlotPDF.printInstructions(System.out);
                                                        return true;
                                                    }
                                                    msg = null;
                                                    if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                                                        this.dbg = true;
                                                        System.out.println("Debug printout = true");
                                                        return true;
                                                    }
                                                    if (arg.equalsIgnoreCase("-nostop") || arg.equalsIgnoreCase("/nostop")) {
                                                        this.doNotStop = true;
                                                        if (this.dbg) {
                                                            System.out.println("Do not show message boxes");
                                                        }
                                                        return true;
                                                    }
                                                    if (arg.equalsIgnoreCase("-bw") || arg.equalsIgnoreCase("/bw")) {
                                                        if (this.dbg) {
                                                            System.out.println("Black on white");
                                                        }
                                                        this.pdfColors = 0;
                                                        return true;
                                                    }
                                                    if (arg.equalsIgnoreCase("-noh") || arg.equalsIgnoreCase("/noh")) {
                                                        if (this.dbg) {
                                                            System.out.println("No header");
                                                        }
                                                        this.pdfHeader = false;
                                                        return true;
                                                    }
                                                    if (arg.equalsIgnoreCase("-clr") || arg.equalsIgnoreCase("/clr")) {
                                                        if (this.dbg) {
                                                            System.out.println("Colours (default palette)");
                                                        }
                                                        this.pdfColors = 1;
                                                        return true;
                                                    }
                                                    if (arg.equalsIgnoreCase("-clr2") || arg.equalsIgnoreCase("/clr2")) {
                                                        if (this.dbg) {
                                                            System.out.println("Colours (\"Spana\" palette)");
                                                        }
                                                        this.pdfColors = 2;
                                                        return true;
                                                    }
                                                    if (arg.length() <= 3) break block49;
                                                    arg0 = arg.substring(0, 2).toLowerCase();
                                                    if (!arg0.startsWith("-p") && !arg0.startsWith("/p")) break block50;
                                                    if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block49;
                                                    name = arg.substring(3);
                                                    if (name.startsWith("\"") && name.endsWith("\"")) {
                                                        name = name.substring(1, name.length() - 1);
                                                    }
                                                    if (!name.toLowerCase().endsWith(".plt")) {
                                                        name = name.concat(".plt");
                                                    }
                                                    f = new File(name);
                                                    name = f.getAbsolutePath();
                                                    if ((f = new File(name)).exists()) break block51;
                                                    msg = "Error: the plot file does not exist:" + PlotPDF.nl + "   \"" + f.getAbsolutePath() + "\"";
                                                    break block52;
                                                }
                                                if (!f.isDirectory()) break block53;
                                                msg = "Error: \"" + f.getAbsolutePath() + "\" is a directory.";
                                                break block52;
                                            }
                                            if (f.canRead()) break block54;
                                            msg = "Error: can not open file for reading:" + PlotPDF.nl + "   \"" + f.getAbsolutePath() + "\"";
                                            break block52;
                                        }
                                        if (this.dbg) {
                                            System.out.println("Plot file: " + f.getPath());
                                        }
                                        this.pltFile = f;
                                        return true;
                                    }
                                    if (!arg0.startsWith("-b") && !arg0.startsWith("/b")) break block55;
                                    if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block49;
                                    t = arg.substring(3);
                                    try {
                                        this.pdfMarginB = Double.parseDouble(t);
                                        this.pdfMarginB = Math.min(20.0, Math.max(this.pdfMarginB, -5.0));
                                        if (this.dbg) {
                                            System.out.println("Bottom margin = " + this.pdfMarginB);
                                        }
                                        return true;
                                    }
                                    catch (NumberFormatException nfe) {
                                        msg = "Error: Wrong numeric format for bottom margin in text \"" + t + "\"";
                                        this.pdfMarginB = NaN;
                                    }
                                    break block52;
                                }
                                if (!arg0.startsWith("-l") && !arg0.startsWith("/l")) break block56;
                                if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block49;
                                t = arg.substring(3);
                                try {
                                    this.pdfMarginL = Double.parseDouble(t);
                                    this.pdfMarginL = Math.min(20.0, Math.max(this.pdfMarginL, -5.0));
                                    if (this.dbg) {
                                        System.out.println("Left margin = " + this.pdfMarginL);
                                    }
                                    return true;
                                }
                                catch (NumberFormatException nfe) {
                                    msg = "Error: Wrong numeric format for left margin in text \"" + t + "\"";
                                    this.pdfMarginL = NaN;
                                }
                                break block52;
                            }
                            if (!arg0.startsWith("-s") && !arg0.startsWith("/s")) break block57;
                            if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block49;
                            t = arg.substring(3);
                            try {
                                size = Integer.parseInt(t);
                                size = Math.min(300, Math.max(size, 20));
                                if (this.dbg) {
                                    System.out.println("Output size = " + size + " %");
                                }
                                this.pdfSizeX = size;
                                this.pdfSizeY = size;
                                return true;
                            }
                            catch (NumberFormatException nfe) {
                                msg = "Error: Wrong numeric format for output size in text \"" + t + "\"";
                                this.pdfSizeX = size = 100;
                                this.pdfSizeY = size;
                            }
                            break block52;
                        }
                        if (!arg0.startsWith("-o") && !arg0.startsWith("/o")) break block58;
                        if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block49;
                        t = arg.substring(3).toLowerCase();
                        if (t.equals("p")) {
                            this.pdfPortrait = true;
                        } else if (t.equals("l")) {
                            this.pdfPortrait = false;
                        }
                        if (t.equals("p") || t.equals("l")) {
                            if (this.dbg) {
                                t = "Orientation = ";
                                t = this.pdfPortrait != false ? t + "Portrait" : t + "Landscape";
                                System.out.println(t);
                            }
                            return true;
                        }
                        msg = "Error: Wrong format for orientation in text \"" + t + "\"";
                        break block52;
                    }
                    if (!arg0.startsWith("-f") && !arg0.startsWith("/f") || arg.charAt(2) != '=' && arg.charAt(2) != ':') break block49;
                    t = arg.substring(3);
                    try {
                        f = Integer.parseInt(t);
                        if (f >= 1 && f <= 4) {
                            this.pdfFont = f - 1;
                            if (this.dbg) {
                                System.out.println("Output font = " + this.FONTS[this.pdfFont]);
                            }
                            return true;
                        }
                        msg = "Error: Wrong font type in text \"" + t + "\"";
                        this.pdfFont = 2;
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Error: Wrong numeric format for output size in text \"" + t + "\"";
                        this.pdfFont = 2;
                    }
                    break block52;
                }
                if (arg.length() <= 4) ** GOTO lbl-1000
                arg0 = arg.substring(0, 3).toLowerCase();
                if (!arg0.startsWith("-sx") && !arg0.startsWith("/sx")) break block59;
                if (arg.charAt(3) != '=' && arg.charAt(3) != ':') ** GOTO lbl-1000
                t = arg.substring(4);
                try {
                    size = Integer.parseInt(t);
                    size = Math.min(300, Math.max(size, 20));
                    if (this.dbg) {
                        System.out.println("Output X-size = " + size + " %");
                    }
                    this.pdfSizeX = size;
                    return true;
                }
                catch (NumberFormatException nfe) {
                    msg = "Error: Wrong numeric format for output X-size in text \"" + t + "\"";
                    this.pdfSizeX = size = 100;
                }
                break block52;
            }
            if ((arg0.startsWith("-sy") || arg0.startsWith("/sy")) && (arg.charAt(3) == '=' || arg.charAt(3) == ':')) {
                t = arg.substring(4);
                try {
                    size = Integer.parseInt(t);
                    size = Math.min(300, Math.max(size, 20));
                    if (this.dbg) {
                        System.out.println("Output Y-size = " + size + " %");
                    }
                    this.pdfSizeY = size;
                    return true;
                }
                catch (NumberFormatException nfe) {
                    msg = "Error: Wrong numeric format for output Y-size in text \"" + t + "\"";
                    this.pdfSizeY = size = 100;
                }
            } else if (arg.length() > 5 && ((arg0 = arg.substring(0, 4).toLowerCase()).startsWith("-pdf") || arg0.startsWith("/pdf")) && (arg.charAt(4) == '=' || arg.charAt(4) == ':')) {
                name = arg.substring(5);
                if (name.startsWith("\"") && name.endsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                if (!name.toLowerCase().endsWith(".pdf")) {
                    name = name.concat(".pdf");
                }
                if (this.dbg) {
                    System.out.println("PDF file: " + name);
                }
                this.pdfFile_name = name;
                return true;
            }
        }
        msg = msg == null ? "Error: can not understand command-line argument:" + PlotPDF.nl + "  \"" + arg + "\"" : "Command-line argument \"" + arg + "\":" + PlotPDF.nl + msg;
        if (this.doNotStop) {
            System.out.println(msg);
        } else {
            var3_3 = new ErrMsgBx(msg, "PlotPDF");
        }
        System.out.println();
        PlotPDF.printInstructions(System.out);
        return false;
    }

    private void convert2PDF() {
        this.scaleX = (double)this.pdfSizeX / 100.0 + 1.0E-10;
        this.scaleY = (double)this.pdfSizeY / 100.0 + 1.0E-10;
        this.zx = this.pdfMarginL * 100.0;
        this.zy = this.pdfMarginB * 100.0;
        this.newPath = -1;
        this.x1st = -1.7976931348623157E308;
        this.y1st = -1.7976931348623157E308;
        try {
            this.outputFile = new OutputStreamWriter((OutputStream)new FileOutputStream(this.pdfFile), "ISO-8859-1");
        }
        catch (FileNotFoundException ex) {
            String msg = "Error:" + nl + ex.getMessage() + nl + "****************************************" + nl + "**   Is the output PDF-file locked?   **" + nl + "****************************************";
            if (this.doNotStop) {
                System.out.println(msg);
            } else {
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
            }
            return;
        }
        catch (UnsupportedEncodingException ex) {
            String msg = "while writing the PDF file:" + nl + "   \"" + this.pdfFile.getAbsolutePath() + "\"";
            PlotPDF.exception(ex, msg, this.doNotStop);
            return;
        }
        this.setPalette();
        this.bufReader = PlotPDF.getBufferedReader(this.pltFile, this.doNotStop);
        if (this.bufReader == null) {
            return;
        }
        this.pdf_Init(this.outputFile);
        this.pdfStreamStart();
        if (this.pdfHeader) {
            this.pdfStreamAppendTo("BT" + nl + "/F0 8 Tf" + nl + "1 0 0 1 30 770 Tm" + nl + "0 0 0 rg");
            this.pdfStreamAppendTo("0 0 (File: " + this.fixTextSimple(this.maybeInQuotes(this.pltFile.getAbsolutePath())) + ") \"" + nl + "1 0 0 1 30 760 Tm");
            this.pdfStreamAppendTo("0 0 (Converted to pdf: " + this.getDateTime() + ") \"" + nl + "ET");
        }
        this.pdfStreamAppendTo("% - - - PlotPDF options:");
        String or = "portrait";
        if (!this.pdfPortrait) {
            or = "landscape";
        }
        String c = "black on white";
        if (this.pdfColors == 1) {
            c = "colours";
        } else if (this.pdfColors == 2) {
            c = "colours selected in \"Spana\"";
        }
        this.pdfStreamAppendTo("% size " + this.pdfSizeX + "/" + this.pdfSizeY + " %;    left, bottom margins = " + this.pdfMarginL + ", " + this.pdfMarginB + " cm" + nl + "% " + c + ";   " + or + ";   font = " + this.FONTS[this.pdfFont] + nl + "% - - - -  Plot file Start  - - - -");
        boolean readingText = false;
        int align = 0;
        int alignDef = 0;
        while (true) {
            String comment;
            String line;
            try {
                line = this.bufReader.readLine();
            }
            catch (IOException ex) {
                String msg = "while reading the plot file:" + nl + "   \"" + this.pltFile.getAbsolutePath() + "\"";
                PlotPDF.exception(ex, msg, this.doNotStop);
                break;
            }
            if (line == null) break;
            String s0 = line.length() > 0 ? line.substring(0, 1).trim() : "";
            String s1 = line.length() > 4 ? line.substring(1, 5).trim() : "";
            String s2 = line.length() > 8 ? line.substring(5, 9).trim() : "";
            int i0 = s0.length() > 0 ? PlotPDF.readInt(s0) : -1;
            int i1 = s1.length() > 0 ? PlotPDF.readInt(s1) : 0;
            int i2 = s2.length() > 0 ? PlotPDF.readInt(s2) : 0;
            if (line.length() > 9) {
                comment = line.substring(9).trim();
                if (i0 != 0 || !comment.startsWith("TextBegin") && !readingText) {
                    this.pdfStreamAppendTo("% " + comment);
                }
                if (comment.equals("TextEnd")) {
                    readingText = false;
                    continue;
                }
            } else {
                comment = "";
            }
            if (readingText) continue;
            if (comment.equals("-- HEADING --")) {
                alignDef = -1;
            }
            if (i0 != 0 && i0 != 1) {
                if (i0 != 5 && i0 != 8) continue;
                this.setPen(i0, i1);
                continue;
            }
            if (this.pdfFont == 0 || i0 == 1 || !comment.startsWith("TextBegin")) {
                this.moveOrDraw(i0, i1, i2);
                continue;
            }
            boolean isFormula = false;
            if (i0 != 0 || comment.length() <= 41 || !comment.startsWith("TextBegin")) continue;
            if (comment.substring(9, 10).equals("C")) {
                isFormula = true;
            }
            double txtSize = PlotPDF.readDouble(comment.substring(17, 24));
            double txtAngle = PlotPDF.readDouble(comment.substring(35, 42));
            if (comment.length() > 42) {
                String t = comment.substring(55, 56);
                if (t.equalsIgnoreCase("L")) {
                    align = -1;
                } else if (t.equalsIgnoreCase("R")) {
                    align = 1;
                } else if (t.equalsIgnoreCase("C")) {
                    align = 0;
                }
            } else {
                align = alignDef;
            }
            try {
                line = this.bufReader.readLine();
            }
            catch (IOException ex) {
                String msg = "while reading the plot file:" + nl + "   \"" + this.pltFile.getAbsolutePath() + "\"";
                PlotPDF.exception(ex, msg, this.doNotStop);
                break;
            }
            if (line != null) {
                if (line.length() > 9) {
                    comment = PlotPDF.rTrim(line.substring(9));
                    if (comment.startsWith(" ")) {
                        comment = comment.substring(1);
                    }
                } else {
                    comment = "";
                }
                this.printText(i1, i2, comment, isFormula, align, txtSize, txtAngle);
            }
            readingText = true;
        }
        this.writeObject22(this.outputFile);
        this.writeXref(this.outputFile);
    }

    private static BufferedReader getBufferedReader(File f, boolean noStop) {
        BufferedReader bufReader;
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
            bufReader = new BufferedReader(isr);
        }
        catch (FileNotFoundException ex) {
            String msg = "File not found:" + nl + "   \"" + f.getAbsolutePath() + "\"";
            PlotPDF.exception(ex, msg, noStop);
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            String msg = "while reading the plot file:" + nl + "   \"" + f.getAbsolutePath() + "\"";
            PlotPDF.exception(ex, msg, noStop);
            return null;
        }
        return bufReader;
    }

    private static int readInt(String t) {
        int i;
        try {
            i = Integer.parseInt(t);
        }
        catch (NumberFormatException ex) {
            System.out.println(DASH_LINE + nl + "Error: " + ex.toString() + nl + "   while reading an integer from String: \"" + t + "\"" + nl + DASH_LINE);
            i = 0;
        }
        return i;
    }

    private static double readDouble(String t) {
        double d;
        try {
            d = Double.parseDouble(t);
        }
        catch (NullPointerException ex) {
            System.out.println(DASH_LINE + nl + "Error: " + ex.toString() + nl + "   while reading an floating-point number from String: \"" + t + "\"" + nl + DASH_LINE);
            d = 0.0;
        }
        return d;
    }

    private void pdf_Init(OutputStreamWriter o) {
        try {
            o.write("%PDF-1.1" + nl + "% see objects 21 and 22 below" + nl);
            o.write("1 0 obj" + nl + "<<" + nl + "/Type /Outlines" + nl + "/Count 0" + nl + ">>" + nl + "endobj" + nl);
            o.write("2 0 obj" + nl + "<<" + nl + "/Type /Encoding" + nl + "/Differences [" + nl);
            this.pdfStreamStart();
            this.pdfStreamAppendTo("128 /euro");
            this.pdfStreamAppendTo("130 /quotesinglbase");
            this.pdfStreamAppendTo("131 /florin");
            this.pdfStreamAppendTo("132 /quotedblbase");
            this.pdfStreamAppendTo("133 /ellipsis");
            this.pdfStreamAppendTo("134 /dagger");
            this.pdfStreamAppendTo("135 /daggerdbl");
            this.pdfStreamAppendTo("136 /circumflex");
            this.pdfStreamAppendTo("137 /perthousand");
            this.pdfStreamAppendTo("138 /Scaron");
            this.pdfStreamAppendTo("139 /guilsinglleft");
            this.pdfStreamAppendTo("140 /OE");
            this.pdfStreamAppendTo("142 /Zcaron");
            this.pdfStreamAppendTo("145 /quoteleft");
            this.pdfStreamAppendTo("146 /quoteright");
            this.pdfStreamAppendTo("147 /quotedblleft");
            this.pdfStreamAppendTo("148 /quotedblright");
            this.pdfStreamAppendTo("149 /bullet");
            this.pdfStreamAppendTo("150 /endash");
            this.pdfStreamAppendTo("151 /emdash");
            this.pdfStreamAppendTo("152 /tilde");
            this.pdfStreamAppendTo("153 /trademark");
            this.pdfStreamAppendTo("154 /scaron");
            this.pdfStreamAppendTo("155 /guilsinglright");
            this.pdfStreamAppendTo("156 /oe");
            this.pdfStreamAppendTo("158 /zcaron");
            this.pdfStreamAppendTo("159 /Ydieresis");
            this.pdfStreamAppendTo("160 /space");
            this.pdfStreamAppendTo("164 /currency");
            this.pdfStreamAppendTo("166 /brokenbar");
            this.pdfStreamAppendTo("168 /dieresis");
            this.pdfStreamAppendTo("169 /copyright");
            this.pdfStreamAppendTo("170 /ordfeminine");
            this.pdfStreamAppendTo("172 /logicalnot");
            this.pdfStreamAppendTo("173 /hyphen");
            this.pdfStreamAppendTo("174 /registered");
            this.pdfStreamAppendTo("175 /macron");
            this.pdfStreamAppendTo("176 /degree");
            this.pdfStreamAppendTo("177 /plusminus");
            this.pdfStreamAppendTo("178 /twosuperior");
            this.pdfStreamAppendTo("179 /threesuperior");
            this.pdfStreamAppendTo("180 /acute");
            this.pdfStreamAppendTo("181 /mu");
            this.pdfStreamAppendTo("183 /periodcentered");
            this.pdfStreamAppendTo("184 /cedilla");
            this.pdfStreamAppendTo("185 /onesuperior");
            this.pdfStreamAppendTo("186 /ordmasculine");
            this.pdfStreamAppendTo("188 /onequarter");
            this.pdfStreamAppendTo("189 /onehalf");
            this.pdfStreamAppendTo("190 /threequarters");
            this.pdfStreamAppendTo("192 /Agrave");
            this.pdfStreamAppendTo("193 /Aacute");
            this.pdfStreamAppendTo("194 /Acircumflex");
            this.pdfStreamAppendTo("195 /Atilde");
            this.pdfStreamAppendTo("196 /Adieresis");
            this.pdfStreamAppendTo("197 /Aring");
            this.pdfStreamAppendTo("198 /AE");
            this.pdfStreamAppendTo("199 /Ccedilla");
            this.pdfStreamAppendTo("200 /Egrave");
            this.pdfStreamAppendTo("201 /Eacute");
            this.pdfStreamAppendTo("202 /Ecircumflex");
            this.pdfStreamAppendTo("203 /Edieresis");
            this.pdfStreamAppendTo("204 /Igrave");
            this.pdfStreamAppendTo("205 /Iacute");
            this.pdfStreamAppendTo("206 /Icircumflex");
            this.pdfStreamAppendTo("207 /Idieresis");
            this.pdfStreamAppendTo("208 /Eth");
            this.pdfStreamAppendTo("209 /Ntilde");
            this.pdfStreamAppendTo("210 /Ograve");
            this.pdfStreamAppendTo("211 /Oacute");
            this.pdfStreamAppendTo("212 /Ocircumflex");
            this.pdfStreamAppendTo("213 /Otilde");
            this.pdfStreamAppendTo("214 /Odieresis");
            this.pdfStreamAppendTo("215 /multiply");
            this.pdfStreamAppendTo("216 /Oslash");
            this.pdfStreamAppendTo("217 /Ugrave");
            this.pdfStreamAppendTo("218 /Uacute");
            this.pdfStreamAppendTo("219 /Ucircumflex");
            this.pdfStreamAppendTo("220 /Udieresis");
            this.pdfStreamAppendTo("221 /Yacute");
            this.pdfStreamAppendTo("222 /Thorn");
            this.pdfStreamAppendTo("223 /germandbls");
            this.pdfStreamAppendTo("224 /agrave");
            this.pdfStreamAppendTo("225 /aacute");
            this.pdfStreamAppendTo("226 /acircumflex");
            this.pdfStreamAppendTo("227 /atilde");
            this.pdfStreamAppendTo("228 /adieresis");
            this.pdfStreamAppendTo("229 /aring");
            this.pdfStreamAppendTo("230 /ae");
            this.pdfStreamAppendTo("231 /ccedilla");
            this.pdfStreamAppendTo("232 /egrave");
            this.pdfStreamAppendTo("233 /eacute");
            this.pdfStreamAppendTo("234 /ecircumflex");
            this.pdfStreamAppendTo("235 /edieresis");
            this.pdfStreamAppendTo("236 /igrave");
            this.pdfStreamAppendTo("237 /iacute");
            this.pdfStreamAppendTo("238 /icircumflex");
            this.pdfStreamAppendTo("239 /idieresis");
            this.pdfStreamAppendTo("240 /eth");
            this.pdfStreamAppendTo("241 /ntilde");
            this.pdfStreamAppendTo("242 /ograve");
            this.pdfStreamAppendTo("243 /oacute");
            this.pdfStreamAppendTo("244 /ocircumflex");
            this.pdfStreamAppendTo("245 /otilde");
            this.pdfStreamAppendTo("246 /odieresis");
            this.pdfStreamAppendTo("247 /divide");
            this.pdfStreamAppendTo("248 /oslash");
            this.pdfStreamAppendTo("249 /ugrave");
            this.pdfStreamAppendTo("250 /uacute");
            this.pdfStreamAppendTo("251 /ucircumflex");
            this.pdfStreamAppendTo("252 /udieresis");
            this.pdfStreamAppendTo("253 /yacute");
            this.pdfStreamAppendTo("254 /thorn");
            this.pdfStreamAppendTo("255 /ydieresis");
            this.pdfStreamPrint(o);
            this.objBytesNoNewLine[2] = this.objBytesNoNewLine[2] + (int)this.pdfStreanSize;
            o.write("]" + nl + ">>" + nl + "endobj" + nl);
            o.write("3 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F0" + nl + "/BaseFont /Courier" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("4 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F1" + nl + "/BaseFont /Courier-Bold" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("5 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F2" + nl + "/BaseFont /Courier-Oblique" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("6 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F3" + nl + "/BaseFont /Courier-BoldOblique" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("7 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F4" + nl + "/BaseFont /Helvetica" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("8 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F5" + nl + "/BaseFont /Helvetica-Bold" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("9 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F6" + nl + "/BaseFont /Helvetica-Oblique" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("10 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F7" + nl + "/BaseFont /Helvetica-BoldOblique" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("11 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F8" + nl + "/BaseFont /Symbol" + nl + ">>" + nl + "endobj" + nl);
            o.write("12 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F9" + nl + "/BaseFont /Times-Roman" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("13 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F10" + nl + "/BaseFont /Times-Bold" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("14 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F11" + nl + "/BaseFont /Times-Italic" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("15 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F12" + nl + "/BaseFont /Times-BoldItalic" + nl + "/Encoding 2 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("16 0 obj" + nl + "<<" + nl + "/Type /Font" + nl + "/Subtype /Type1" + nl + "/Name /F13" + nl + "/BaseFont /ZapfDingbats" + nl + ">>" + nl + "endobj" + nl);
            o.write("17 0 obj" + nl + "<<" + nl + "/Type /Catalog" + nl + "/Pages 19 0 R" + nl + "/Outlines 1 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("18 0 obj" + nl + "<<" + nl + "/ProcSet [ /PDF /Text ]" + nl + "/Font <<" + nl + "/F0 3 0 R" + nl + "/F1 4 0 R" + nl + "/F2 5 0 R" + nl + "/F3 6 0 R" + nl + "/F4 7 0 R" + nl + "/F5 8 0 R" + nl + "/F6 9 0 R" + nl + "/F7 10 0 R" + nl + "/F8 11 0 R" + nl + "/F9 12 0 R" + nl + "/F10 13 0 R" + nl + "/F11 14 0 R" + nl + "/F12 15 0 R" + nl + "/F13 16 0 R" + nl + ">>" + nl + ">>" + nl + "endobj" + nl);
            o.write("19 0 obj" + nl + "<<" + nl + "/Type /Pages" + nl + "/Count 1" + nl + "/Kids [ 20 0 R  ] " + nl + "/MediaBox [0 0 " + 593 + " " + 792 + "]" + nl + "/Resources 18 0 R" + nl + ">>" + nl + "endobj" + nl);
            o.write("20 0 obj" + nl + "<<" + nl + "/Type /Page" + nl + "/Parent 19 0 R" + nl + "/Contents 22 0 R" + nl + "/Resources 18 0 R" + nl + ">>" + nl + "endobj" + nl);
            this.pdfStreamStart();
            o.write("21 0 obj" + nl + "<<" + nl + "/CreationDate (D:" + this.pdfDate() + ")" + nl);
            this.pdfStreamAppendTo("/Producer (Plot-pdf [java]  by I.Puigdomenech 2014-Jan-31)" + nl + "/Author (" + this.fixTextSimple(System.getProperty("user.name", "anonymous")) + ")" + nl + "/Title (" + this.fixTextSimple(this.maybeInQuotes(this.pltFile.getName())) + ")");
            this.pdfStreamPrint(o);
            this.objBytesNoNewLine[21] = this.objBytesNoNewLine[21] + (int)this.pdfStreanSize;
            o.write(">>" + nl + "endobj" + nl);
            o.flush();
        }
        catch (IOException ex) {
            PlotPDF.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
    }

    private String pdfDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date now = new Date();
        return df.format(now);
    }

    private String getDateTime() {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        Date now = new Date();
        return df.format(now);
    }

    private void writeObject22(OutputStreamWriter o) {
        if (this.startedPrintingText) {
            this.pdfStreamAppendTo("ET");
            this.startedPrintingText = false;
        }
        if (this.newPath == 2) {
            if (Math.abs(this.x1st - this.xNow) < 0.01 && Math.abs(this.y1st - this.yNow) < 0.01) {
                this.pdfStreamAppendTo("s");
            } else {
                this.pdfStreamAppendTo("S");
            }
            this.newPath = 0;
            this.x1st = -1.7976931348623157E308;
            this.y1st = -1.7976931348623157E308;
        }
        this.pdfStreamAppendTo("% - - - -  Plot file End  - - - -");
        String pdfStreamSizeTxt = Long.toString(this.pdfStreanSize).trim();
        this.pdfStreamSizeTxtLength = pdfStreamSizeTxt.length();
        try {
            o.flush();
            o.write("22 0 obj" + nl + "<<" + nl + "/Length " + pdfStreamSizeTxt + nl + ">>" + nl + "% If you make changes in the \"stream\" you must also change:" + nl + "% - In the the trailer, the line below the keyword \"startxref\":" + nl + "%   update the byte offset from the beginning of the file to the" + nl + "%   beginning of the \"xref\" keyword." + nl + "% - Update above the byte length of the \"stream\", including ends-of-line" + nl + "stream" + nl);
            o.write(this.pdfStream.toString());
            o.write("endstream" + nl + "endobj" + nl);
        }
        catch (IOException ex) {
            PlotPDF.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
    }

    private void writeXref(OutputStreamWriter o) {
        if (this.pdfStreanSize <= 0L) {
            String msg = "Programming error in \"writeXref\": pdfStreanSize <= 0.";
            if (this.doNotStop) {
                System.out.println(msg);
            } else {
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
            }
            return;
        }
        long[] objStart = new long[22];
        long lng = 0L;
        for (int i = 0; i < this.NBR_PDF_OBJECTS; ++i) {
            objStart[i] = lng += (long)(this.objBytesNoNewLine[i] + this.objNbrNewLines[i] * nlL);
        }
        try {
            o.flush();
            o.write("xref" + nl + "0 23" + nl + "0000000000 65535 f" + nl);
            for (int i = 0; i < this.NBR_PDF_OBJECTS; ++i) {
                String objStartTxt = String.format("%010d", objStart[i]);
                o.write(objStartTxt + " 00000 n");
                if (nlL == 1) {
                    o.write(" ");
                }
                o.write(nl);
            }
            long xrefStart = objStart[this.NBR_PDF_OBJECTS - 1] + 18L + (long)(2 * nlL) + (long)this.pdfStreamSizeTxtLength + (long)nlL + 302L + (long)(7 * nlL) + this.pdfStreanSize + 15L + (long)(2 * nlL);
            o.write("trailer" + nl + "<<" + nl + "/Size 23" + nl + "/Info 21 0 R" + nl + "/Root 17 0 R" + nl + ">>" + nl + "startxref" + nl + xrefStart + nl + "%%EOF" + nl);
            o.flush();
        }
        catch (IOException ex) {
            PlotPDF.exception(ex, null, this.doNotStop);
            this.delete = true;
        }
    }

    private synchronized void pdfStreamStart() {
        this.pdfStream.delete(0, this.pdfStream.length());
        this.pdfStreanSize = 0L;
    }

    private synchronized void pdfStreamAppendTo(String t) {
        if (t == null || t.length() <= 0) {
            return;
        }
        try {
            byte[] encodedBytes = t.getBytes("ISO-8859-1");
            this.pdfStreanSize += (long)encodedBytes.length;
            this.pdfStream.append(t);
        }
        catch (UnsupportedEncodingException ex) {
            PlotPDF.exception(ex, "while encoding to ISO-Latin-1 the text \"" + t + "\"", this.doNotStop);
            this.delete = true;
        }
        this.pdfStreanSize += (long)nlL;
        this.pdfStream.append(nl);
    }

    private void pdfStreamPrint(OutputStreamWriter o) {
        try {
            o.write(this.pdfStream.toString());
            o.flush();
        }
        catch (IOException ex) {
            PlotPDF.exception(ex, "while writing \"" + this.pdfStream.toString() + "\"", this.doNotStop);
            this.delete = true;
        }
    }

    private void setPalette() {
        if (this.pdfColors == 2) {
            boolean ok;
            File f;
            FileInputStream fis;
            block19: {
                fis = null;
                f = null;
                ok = false;
                Properties propertiesIni = new Properties();
                f = this.getSpana_Ini();
                if (f == null) {
                    System.out.println("Warning: could not find \"Spana.ini\"" + nl + "default colours will be used.");
                } else {
                    try {
                        fis = new FileInputStream(f);
                        propertiesIni.load(fis);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Warning: file Not found: \"" + f.getPath() + "\"" + nl + "default colours will be used.");
                        break block19;
                    }
                    catch (IOException e) {
                        System.out.println("Error: \"" + e.toString() + "\"" + nl + "   while loading file:" + nl + "   \"" + f.getPath() + "\"" + nl + "default colours will be used.");
                        break block19;
                    }
                    if (this.dbg) {
                        System.out.println("Reading colours from \"" + f.getPath() + "\".");
                    }
                    try {
                        for (int ii = 0; ii < this.colours.length; ++ii) {
                            String[] c = propertiesIni.getProperty("Disp_Colour[" + ii + "]").split(",");
                            int red = c.length > 0 ? Integer.parseInt(c[0]) : 0;
                            int green = c.length > 1 ? Integer.parseInt(c[1]) : 0;
                            int blue = c.length > 2 ? Integer.parseInt(c[2]) : 0;
                            float r = Math.max(0.0f, Math.min(1.0f, (float)Math.max(0, Math.min(255, red)) / 255.0f));
                            float g = Math.max(0.0f, Math.min(1.0f, (float)Math.max(0, Math.min(255, green)) / 255.0f));
                            float b = Math.max(0.0f, Math.min(1.0f, (float)Math.max(0, Math.min(255, blue)) / 255.0f));
                            String rt = (double)r < 1.0E-6 ? "0" : ((double)r > 0.999999 ? "1" : String.valueOf(r));
                            String gt = (double)g < 1.0E-6 ? "0" : ((double)g > 0.999999 ? "1" : String.valueOf(g));
                            String bt = (double)b < 1.0E-6 ? "0" : ((double)b > 0.999999 ? "1" : String.valueOf(b));
                            this.colours[ii] = (rt + " " + gt + " " + bt).trim();
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error: \"" + e.toString() + "\"" + nl + "   while loading file:" + nl + "   \"" + f.getPath() + "\"" + nl + "default colours will be used.");
                        break block19;
                    }
                    ok = true;
                }
            }
            if (!ok) {
                this.pdfColors = 1;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                String msg = "Error: " + e.toString();
                msg = f != null ? msg + nl + "while closing \"" + f.getPath() + "\"" : msg + nl + "while closing \"null\"";
                System.out.println(msg);
            }
        }
        if (this.pdfColors <= 0 || this.pdfColors > 2) {
            for (int i = 0; i < this.colours.length; ++i) {
                this.colours[i] = "0 0 0";
            }
            return;
        }
        if (this.pdfColors == 1) {
            this.colours[0] = "0 0 0";
            this.colours[1] = "1 0 0";
            this.colours[2] = "0.5843 0.2627 0";
            this.colours[3] = "0 0 1";
            this.colours[4] = "0 0.502 0";
            this.colours[5] = "0.7843 0.549 0";
            this.colours[6] = "1 0 1";
            this.colours[7] = "0 0 0.502";
            this.colours[8] = "0.502 0.502 0.502";
            this.colours[9] = "0 0.651 1";
            this.colours[10] = "0.502 0 1";
        }
        if (this.dbg) {
            System.out.println("Colours in use;");
            for (int ii = 0; ii < this.colours.length; ++ii) {
                System.out.println("  colour[" + ii + "] = \"" + this.colours[ii] + "\"");
            }
        }
    }

    private File getSpana_Ini() {
        String home;
        File p;
        ArrayList<String> dirs = new ArrayList<String>(6);
        String appD = System.getenv("APPDATA");
        if (appD != null && appD.trim().length() > 0 && (p = new File(appD)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        String homeDrv = System.getenv("HOMEDRIVE");
        String homePath = System.getenv("HOMEPATH");
        if (homePath != null && homePath.trim().length() > 0 && !homePath.startsWith(SLASH)) {
            homePath = SLASH + homePath;
        }
        if (homeDrv != null && homeDrv.trim().length() > 0 && homeDrv.endsWith(SLASH)) {
            homeDrv = homeDrv.substring(0, homeDrv.length() - 1);
        }
        if (homeDrv != null && homeDrv.trim().length() > 0 && homePath != null && homePath.trim().length() > 0 && (p = new File(homeDrv + homePath)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        if ((home = System.getenv("HOME")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        if ((home = System.getProperty("user.home")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        if ((home = PlotPDF.getPathApp()) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
            dirs.add(p.getAbsolutePath());
        }
        File f = null;
        for (String t : dirs) {
            if (t.endsWith(SLASH)) {
                t = t.substring(0, t.length() - 1);
            }
            String fileINIname = "Spana.ini";
            p = new File(t + SLASH + "Spana.ini");
            if (!p.exists() || !p.canRead() || f == null || p.lastModified() <= f.lastModified()) continue;
            f = p;
        }
        return f;
    }

    private void setPen(int i, int pen0) {
        if (i != 5 && i != 8) {
            return;
        }
        int pen = Math.max(1, pen0);
        --pen;
        if (i == 5) {
            if (this.pdfColors <= 0) {
                this.colorNow = 0;
                return;
            }
            while (pen >= this.colours.length) {
                pen -= this.colours.length;
            }
            if (pen < 0) {
                pen = this.colours.length - pen;
            }
            this.colorNow = pen;
        }
        if (i == 8) {
            while (pen >= this.WIDTHS.length) {
                pen -= this.WIDTHS.length;
            }
            if (pen < 0) {
                pen = this.WIDTHS.length - pen;
            }
            this.penNow = pen;
        }
    }

    private void moveOrDraw(int i0, double x0, double y0) {
        if (this.startedPrintingText) {
            this.pdfStreamAppendTo("ET");
            this.startedPrintingText = false;
        }
        if (this.newPath < 0) {
            this.newPath = 0;
        }
        double x = (x0 * this.scaleX + this.zx) * 0.283464566929;
        double y = (y0 * this.scaleY + this.zy) * 0.283464566929;
        if (i0 == 0) {
            if (this.newPath == 2) {
                if (Math.abs(this.x1st - this.xNow) < 0.01 && Math.abs(this.y1st - this.yNow) < 0.01) {
                    this.pdfStreamAppendTo("s");
                } else {
                    this.pdfStreamAppendTo("S");
                }
                this.newPath = 0;
            }
            this.x1st = -1.7976931348623157E308;
            this.y1st = -1.7976931348623157E308;
        } else if (i0 == 1) {
            double yPdf;
            double xPdf;
            if (this.newPath == 0) {
                this.pdfStreamAppendTo(this.colours[this.colorNow] + " RG");
                double w = this.WIDTHS[this.penNow] * (this.scaleX + this.scaleY) / 2.0;
                w = Math.min(100.0, Math.max(0.05, w)) * 0.283464566929;
                this.pdfStreamAppendTo(String.format(engl, "%20.5f", w).trim() + " w");
                this.pdfStreamAppendTo("0 J 1 j [ ] 0 d");
                xPdf = this.xNow;
                yPdf = this.yNow;
                if (this.pdfPortrait) {
                    xPdf += 20.0;
                } else {
                    xPdf = 593.0 - this.yNow;
                    yPdf = this.xNow;
                    xPdf -= 20.0;
                }
                this.pdfStreamAppendTo(PlotPDF.toStr(xPdf) + " " + PlotPDF.toStr(yPdf += 15.0) + " m");
                this.newPath = 1;
                this.x1st = this.xNow;
                this.y1st = this.yNow;
            }
            xPdf = x;
            yPdf = y;
            if (this.pdfPortrait) {
                xPdf += 20.0;
            } else {
                xPdf = 593.0 - y;
                yPdf = x;
                xPdf -= 20.0;
            }
            this.pdfStreamAppendTo(PlotPDF.toStr(xPdf) + " " + PlotPDF.toStr(yPdf += 15.0) + " l");
            this.newPath = 2;
        }
        this.xNow = x;
        this.yNow = y;
    }

    private static String toStr(double d) {
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        String dTxt = Math.abs((d = Math.min(9.999999999999999E14, Math.max(-9.999999999999999E14, d))) - (double)Math.round(d)) > 0.001 ? String.format(engl, "%20.3f", d) : Long.toString(Math.round(d));
        return dTxt.trim();
    }

    private String fixTextSimple(String txt) {
        if (txt == null || txt.trim().length() <= 0) {
            return txt;
        }
        StringBuilder t = new StringBuilder(txt);
        for (int i = 0; i < t.length(); ++i) {
            if (t.charAt(i) == '\\') {
                t.replace(i, i + 1, "\\\\");
                ++i;
                continue;
            }
            if (t.charAt(i) == '(') {
                t.replace(i, i + 1, "\\(");
                ++i;
                continue;
            }
            if (t.charAt(i) == ')') {
                t.replace(i, i + 1, "\\)");
                ++i;
                continue;
            }
            if (t.charAt(i) != '-') continue;
            t.replace(i, i + 1, "\\226");
            i += 3;
        }
        return t.toString();
    }

    private String maybeInQuotes(String t) {
        if (t == null || t.length() <= 0) {
            return t;
        }
        boolean encloseInQuotes = false;
        String[] q = new String[]{"\"", "\""};
        for (int i = 0; i < t.length(); ++i) {
            if (!Character.isWhitespace(t.charAt(i))) continue;
            encloseInQuotes = true;
        }
        if (encloseInQuotes) {
            return q[0] + t + q[1];
        }
        return t;
    }

    private static void printInstructions(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        out.flush();
        out.println("This program will convert a plot file (*.plt) into a PDF file." + nl + "Usage:  java -jar PlotPDF.jar [plot-file-name] [-command=value]");
        out.println("Possible commands are:" + nl + "  -b=bottom-margin  (in cm)" + nl + "  -bw  (black on white output)" + nl + "  -clr  (colours - standard palette)" + nl + "  -clr2 (colours selected in \"Spana\")" + nl + "  -dbg  (output debug information)" + nl + "  -f=font-nbr  (1:Vector_Graphics, 2:Times-Roman, 3:Helvetica, 4:Courier)" + nl + "  -l=left-margin  (in cm)" + nl + "  -noh   (do not make a header with file name and date)" + nl + "  -nostop  (do not stop for warnings)" + nl + "  -o=P/L  (P: portrait;  L: landscape)" + nl + "  -p=plot-file-name  (input \"plt\"-file in UTF-8 Unicode ecoding)" + nl + "  -pdf=output-file-name" + nl + "  -s=%  (output size; integer %-value)" + nl + "  -sx=% and -sy=% (different vertical and horizontal scaling)" + nl + "Enclose file-names with double quotes (\"\") it they contain blank space." + nl + "Example:  java -jar PlotPDF.jar \"Fe 53\" -PDF=\"pdf\\Fe 53.pdf\"  -s:60 -clr -F:2");
    }

    private void printText(int i1, int i2, String txt, boolean isFormula, int align, double txtSize, double txtAngle) {
        double w;
        double[] FontScaleHeight = new double[]{1.45, 1.35, 1.6};
        double[] FontScaleWidth = new double[]{0.7, 0.71, 0.88};
        String[] ALIGNMENTS = new String[]{"left", "centre", "right"};
        ChemFormula cf = null;
        if (this.newPath == 2) {
            if (Math.abs(this.x1st - this.xNow) < 0.01 && Math.abs(this.y1st - this.yNow) < 0.01) {
                this.pdfStreamAppendTo("s");
            } else {
                this.pdfStreamAppendTo("S");
            }
            this.newPath = 0;
            this.x1st = -1.7976931348623157E308;
            this.y1st = -1.7976931348623157E308;
        }
        if (this.dbg) {
            System.out.println("Print text \"" + txt + "\"" + nl + "   formula:" + isFormula + ", align=" + align + " size=" + txtSize + " angle=" + txtAngle);
        }
        if (txt == null || txt.trim().length() <= 0) {
            return;
        }
        txt = PlotPDF.rTrim(txt);
        while (txtAngle > 360.0) {
            txtAngle -= 360.0;
        }
        while (txtAngle < -360.0) {
            txtAngle += 360.0;
        }
        if (txtAngle > 180.0) {
            txtAngle -= 360.0;
        }
        if (txtAngle < -180.0) {
            txtAngle += 360.0;
        }
        double fontSize = 100.0 * ((this.scaleX + this.scaleY) / 2.0) * (txtSize * FontScaleHeight[this.pdfFont - 1] + 0.001) * 0.283464566929;
        fontSize = Math.min(5000.0, fontSize);
        this.fontSizeTxt = String.format(engl, "%15.2f", fontSize).trim();
        align = Math.max(-1, Math.min(1, align));
        String str = "% text at X,Y= " + String.valueOf(i1) + " " + String.valueOf(i2) + ";  size = " + PlotPDF.toStr(txtSize) + ";  angle = " + PlotPDF.toStr(txtAngle) + ";  is formula: " + isFormula + ";  alignment:" + ALIGNMENTS[align + 1];
        this.pdfStreamAppendTo(str);
        str = "%     text is: " + txt;
        this.pdfStreamAppendTo(str.trim());
        if (fontSize <= 0.01) {
            this.pdfStreamAppendTo(str + nl + "%     (size too small)");
            return;
        }
        if (!this.startedPrintingText) {
            this.pdfStreamAppendTo("BT");
            this.startedPrintingText = true;
        }
        this.changeFontString = this.penNow == 1 ? this.setFontString(1) : this.setFontString(0);
        this.pdfStreamAppendTo(this.changeFontString);
        this.pdfStreamAppendTo(this.colours[this.colorNow] + " rg");
        boolean containsLetters = false;
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') continue;
            containsLetters = true;
            break;
        }
        if (!containsLetters || txt.length() <= 1) {
            isFormula = false;
        }
        int txtLength = txt.length();
        if (isFormula && txtLength > 1) {
            if (txt.equalsIgnoreCase("log (ai/ar")) {
                txt = "log (a`i'/a`ref'";
            }
            cf = new ChemFormula(txt, new float[1]);
            PlotPDF.chemF(cf);
            txtLength = cf.t.length();
        }
        double xpl = i1;
        double ypl = i2;
        double rads = Math.toRadians(txtAngle);
        if (!isFormula) {
            if (align == 1 || align == 0) {
                if (align == 1) {
                    w = txtLength;
                } else {
                    w = (double)txtLength * (1.0 - FontScaleWidth[this.pdfFont - 1]);
                    w /= 2.0;
                }
                w = w * txtSize * 100.0;
                xpl += w * Math.cos(rads);
                ypl += w * Math.sin(rads);
            }
        } else {
            if (!(!(Math.abs(txtAngle) < 0.01) || align != 0 || txt.equals("pH") || txt.equals("pe") || txt.startsWith("Log") || txt.startsWith("E / V") || txt.contains("`TOT'"))) {
                ypl += 0.3 * txtSize * 100.0;
            }
            w = (double)txt.length() * (1.0 - FontScaleWidth[this.pdfFont - 1]);
            w -= (double)(txt.length() - txtLength);
            if (align == 0) {
                w /= 2.0;
            }
            if (align == 1 || align == 0) {
                w = w * txtSize * 100.0;
                xpl += w * Math.cos(rads);
                ypl += w * Math.sin(rads);
            }
        }
        xpl = (xpl * this.scaleX + this.zx) * 0.283464566929;
        ypl = (ypl * this.scaleY + this.zy) * 0.283464566929;
        if (this.pdfPortrait) {
            xpl += 20.0;
        } else {
            double x = xpl;
            double y = ypl;
            xpl = 593.0 - y;
            ypl = x;
            xpl -= 20.0;
            rads = Math.toRadians(txtAngle += 90.0);
        }
        str = PlotPDF.toStr(xpl) + " " + PlotPDF.toStr(ypl += 15.0) + " Tm";
        if (Math.abs(txtAngle) <= 0.05) {
            this.pdfStreamAppendTo("1 0 0 1 " + str);
        } else {
            double cosine = Math.cos(rads);
            double sine = Math.sin(rads);
            String a1 = PlotPDF.toStr(cosine);
            String a2 = PlotPDF.toStr(sine);
            String a3 = PlotPDF.toStr(-sine);
            this.pdfStreamAppendTo(a1 + " " + a2 + " " + a3 + " " + a1 + " " + str);
        }
        if (isFormula && cf != null) {
            String l2;
            int j;
            int n1 = 0;
            for (j = 1; j < cf.t.length(); ++j) {
                if (cf.d[j] == cf.d[j - 1]) continue;
                l2 = cf.t.substring(n1, j);
                n1 = j;
                String move = PlotPDF.toStr(cf.d[j - 1] * 10.0f) + " Ts ";
                l2 = "(" + this.fixText(l2, isFormula) + ") Tj";
                if (move.length() > 0) {
                    this.pdfStreamAppendTo(move + l2);
                    continue;
                }
                this.pdfStreamAppendTo(l2);
            }
            if (n1 <= cf.t.length()) {
                l2 = cf.t.substring(n1);
                String move = PlotPDF.toStr(cf.d[j - 1] * 10.0f) + " Ts ";
                l2 = "(" + this.fixText(l2, isFormula) + ") Tj 0 Ts";
                if (move.length() > 0) {
                    this.pdfStreamAppendTo(move + l2);
                } else {
                    this.pdfStreamAppendTo(l2);
                }
            }
        } else if (align > 0) {
            this.pdfStreamAppendTo("-100 Tz 3 Tr (" + this.fixText(txt, isFormula) + ") Tj");
            this.pdfStreamAppendTo("100 Tz 0 Tr (" + this.fixText(txt, isFormula) + ") Tj");
        } else {
            this.pdfStreamAppendTo("0 Ts (" + this.fixText(txt, isFormula) + ") Tj");
        }
    }

    private String setFontString(int type) {
        String[] FONTN = new String[]{"/F9", "/F4", "/F0"};
        String[] FONTBN = new String[]{"/F10", "/F5", "/F1"};
        String[] FONTIN = new String[]{"/F11", "/F6", "/F2"};
        String msg = null;
        if (type < 0 || type > 3) {
            msg = "type = " + type + " shoud be 0 to 3.";
        }
        if (this.pdfFont < 0 || this.pdfFont > 3) {
            msg = "diagrConvertFont = " + this.pdfFont + " shoud be 0 to 3.";
        }
        if (this.fontSizeTxt == null || this.fontSizeTxt.length() <= 0) {
            msg = "fontSizeTxt is empty.";
        }
        if (msg != null) {
            msg = "Programming error in \"setFontString\":" + nl + msg;
            if (this.doNotStop) {
                System.out.println(msg);
            } else {
                ErrMsgBx mb = new ErrMsgBx(msg, progName);
            }
            return "";
        }
        String changeFontTxt = type == 1 ? FONTBN[this.pdfFont - 1] : (type == 2 ? FONTIN[this.pdfFont - 1] : (type == 3 ? "/F8" : FONTN[this.pdfFont - 1]));
        changeFontTxt = changeFontTxt + " " + this.fontSizeTxt + " Tf";
        return changeFontTxt;
    }

    private String fixText(String txt, boolean isFormula) {
        if (txt == null || txt.trim().length() <= 0) {
            return txt;
        }
        StringBuilder t = new StringBuilder(this.fixTextSimple(txt));
        int i = 0;
        while (i < t.length()) {
            String str;
            if (isFormula) {
                if (t.charAt(i) == '~') {
                    t.replace(i, i + 1, "\\260");
                    i += 4;
                    continue;
                }
                if (t.charAt(i) == '$') {
                    t.replace(i, i + 1, "\\265");
                    i += 4;
                    continue;
                }
            }
            if (t.charAt(i) == '\u007f' || isFormula && t.charAt(i) == '^') {
                str = ") Tj /F8 " + this.fontSizeTxt + " Tf (D) Tj " + this.changeFontString + " (";
                t.replace(i, i + 1, str);
                i += str.length();
                continue;
            }
            if (i <= t.length() - 6 && t.substring(i).startsWith("versus")) {
                this.changeFontString = this.setFontString(2);
                str = ") Tj " + this.changeFontString + " (versus) Tj ";
                this.changeFontString = this.penNow != 2 ? this.setFontString(0) : this.setFontString(1);
                str = str + this.changeFontString + " (";
                t.replace(i, i + 6, str);
                i += str.length();
                continue;
            }
            if (i <= t.length() - 4 && (t.substring(i).startsWith("Log ") || t.substring(i).startsWith("Log[") || t.substring(i).startsWith("Log{"))) {
                t.replace(i, i + 3, "log");
                i += 3;
                continue;
            }
            if (i <= t.length() - 5 && t.substring(i).toLowerCase().startsWith("log p")) {
                this.changeFontString = this.setFontString(2);
                str = "log ) Tj " + this.changeFontString + " (p) Tj ";
                this.changeFontString = this.penNow != 2 ? this.setFontString(0) : this.setFontString(1);
                str = str + this.changeFontString + " (";
                t.replace(i, i + 5, str);
                i += str.length();
                continue;
            }
            ++i;
        }
        return t.toString();
    }

    private static String rTrim(String text) {
        if (text == null) {
            return text;
        }
        int idx = text.length() - 1;
        if (idx >= 0) {
            while (idx >= 0 && Character.isWhitespace(text.charAt(idx))) {
                --idx;
            }
            if (idx < 0) {
                return "";
            }
            return text.substring(0, idx + 1);
        }
        return text;
    }

    /*
     * Unable to fully structure code
     */
    private static void chemF(ChemFormula cf) {
        REMOVE_CHAR = false;
        DOWN = true;
        NONE = 2;
        UP = 3;
        CONT = 4;
        END = 6;
        M1 = 8211;
        M2 = 8722;
        t = new StringBuffer();
        t.append(cf.t);
        L = t.toString().trim().length();
        if (L <= 1) {
            return;
        }
        L = t.length();
        if (L > (nchr = PlotPDF.rTrim(t.toString()).length())) {
            t.delete(nchr, L);
        }
        d = new float[nchr];
        for (i = 0; i < d.length; ++i) {
            d[i] = 0.0f;
        }
        L = 32;
        nL = 32;
        nnL = 32;
        now = t.charAt(0);
        n = 32;
        if (nchr >= 2) {
            n = t.charAt(1);
        }
        n2 = 32;
        if (nchr >= 3) {
            n2 = t.charAt(2);
        }
        dm = 0.0f;
        df = 0.0f;
        i = 0;
        do {
            block58: {
                block68: {
                    block70: {
                        block69: {
                            block67: {
                                block62: {
                                    block66: {
                                        block65: {
                                            block64: {
                                                block63: {
                                                    block61: {
                                                        block60: {
                                                            block59: {
                                                                block57: {
                                                                    n3 = 32;
                                                                    if (nchr >= i + 4) {
                                                                        n3 = t.charAt(i + 3);
                                                                    }
                                                                    if (df > 0.001f && (now < 43 || now > 57 || now == 44 || now == 46 || now == 47)) {
                                                                        df = 0.0f;
                                                                    }
                                                                    if (now != 64 || L == 64) break block57;
                                                                    act = 0;
                                                                    break block58;
                                                                }
                                                                if (L != 64) break block59;
                                                                act = now == 32 ? 4 : 2;
                                                                break block58;
                                                            }
                                                            if (now != 2) break block60;
                                                            now = n;
                                                            n = n2;
                                                            n2 = n3;
                                                            act = 6;
                                                            break block58;
                                                        }
                                                        if (now != 39 && now != 96) break block61;
                                                        if (now == 39 && dm == 0.0f && (n == 32 && L == 115 || n == 115 && (n2 == 32 || n2 == 46 || n2 == 44 || n2 == 58 || n2 == 59 || n2 == 63 || n2 == 33 || n2 == 41 || n2 == 93))) {
                                                            act = 4;
                                                        } else {
                                                            if (now == 39) {
                                                                dm += 0.5f;
                                                            }
                                                            if (now == 96) {
                                                                dm -= 0.5f;
                                                            }
                                                            act = 0;
                                                        }
                                                        break block58;
                                                    }
                                                    if (now != 32) break block62;
                                                    if ((n >= 49 || n == 43 || n == 45 || n == 8211 || n == 8722) && n <= 57) break block63;
                                                    act = 2;
                                                    break block58;
                                                }
                                                if (n != 43 && n != 45 && n != 8211 && n != 8722 || L != 43 && L != 45 && L != 8211 && L != 8722) break block64;
                                                act = 2;
                                                break block58;
                                            }
                                            if ((n2 < 65 || n2 > 90) && (n2 < 97 || n2 > 122)) break block65;
                                            act = 2;
                                            break block58;
                                        }
                                        if (n < 49 || n > 57) ** GOTO lbl-1000
                                        if (n2 < 48 || n2 > 57) break block66;
                                        if (n3 == 43 || n3 == 45 || n3 == 8211 || n3 == 8722) ** GOTO lbl-1000
                                        act = 2;
                                        break block58;
                                    }
                                    if (n2 != 43 && n2 != 45 && n2 != 8211 && n2 != 8722) {
                                        act = 2;
                                    } else lbl-1000:
                                    // 3 sources

                                    {
                                        act = L == 32 ? 2 : ((L < 48 || L > 122 || L >= 58 && L <= 64 || L >= 91 && L <= 96) && L != 41 && L != 93 && L != 125 && L != 62 && L != 34 && L != 39 ? 2 : 0);
                                    }
                                    break block58;
                                }
                                if (now < 48 || now > 57) break block67;
                                if (L == 40 || L == 91 || L == 123 || L == 45 || L == 8211 || L == 8722 || L == 43) ** GOTO lbl-1000
                                if (L == 106 || L == 74 || L == 113 || L == 81) {
                                    act = 2;
                                } else if (L == 120 || L == 88 || L == 122 || L == 90) {
                                    act = 2;
                                } else if (L >= 65 && L <= 90 || L >= 97 && L <= 122) {
                                    act = 1;
                                } else if (L == 41 || L == 93 || L == 125) {
                                    act = 1;
                                } else if (df > 0.01f && (L >= 48 && L <= 57 || L == 46)) {
                                    act = 4;
                                } else if (df < -0.01f && (L == 46 || L >= 48 && L <= 57)) {
                                    act = 4;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    df = 0.0f;
                                    act = L == 32 && n >= 48 && n <= 57 && (n2 == 43 || n2 == 45 || n2 == 8211 || n2 == 8722) && now != 48 ? (n3 != 32 && n3 != 41 && n3 != 93 && n3 != 125 ? 4 : 3) : (L != 32 || n != 43 && n != 45 && n != 8211 && n != 8722 ? 4 : (n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122 ? 4 : 3));
                                }
                                break block58;
                            }
                            if (now != 43 && now != 45 && now != 8211 && now != 8722) break block68;
                            if (L < 50 || L > 57 || !(df > 0.01f)) break block69;
                            act = 3;
                            break block58;
                        }
                        if (L < 48 || L > 57 || nL < 49 || nL > 57 || !(df > 0.01f)) break block70;
                        act = 3;
                        break block58;
                    }
                    if (n < 49 || n > 57) ** GOTO lbl-1000
                    if ((nL >= 48 && nL <= 57 || nL == 46) && (L == 69 || L == 101)) {
                        act = 2;
                    } else if (L == 32) {
                        act = 2;
                    } else if (L == 106 || L == 74 || L == 113 || L == 81) {
                        act = 2;
                    } else if (L == 120 || L == 88 || L == 122 || L == 90) {
                        act = 2;
                    } else if (dm > 0.01f && L == 39 && nL == 48 && nnL == 49 && n >= 49 && n <= 57 && (n2 == 46 || n2 == 96 || n2 >= 48 && n2 <= 57)) {
                        act = 2;
                    } else if (L < 48 && L != 41 && L != 34 && L != 39 || L > 122 && L != 125 || L >= 58 && L <= 64 && L != 62 || L >= 91 && L <= 96 && L != 93) {
                        act = 2;
                    } else if ((L == 41 || L == 93 || L == 125 || L == 34 || L == 39) && (nL == 32 || nL < 48 || nL > 122 || nL >= 58 && nL <= 64 || nL >= 91 && nL <= 96)) {
                        act = 2;
                    } else if (n2 < 48 && n2 != 41 && n2 != 32 && n2 != 39 || n2 > 57 && n2 != 93 && n2 != 96 && n2 != 125) {
                        act = 2;
                    } else if (n >= 49 && n <= 57 && n2 >= 48 && n2 <= 57) {
                        if (n3 != 32 && n3 != 2 && n3 != 41 && n3 != 93 && n3 != 125 && n3 != 96 && n3 != 39 && n3 != 64 && n3 != 61) {
                            act = 2;
                        } else {
                            t1 = t.charAt(i + 1);
                            t2 = t.charAt(i + 2);
                            t.setCharAt(i + 2, t.charAt(i));
                            t.setCharAt(i + 1, t2);
                            t.setCharAt(i, t1);
                            j1 = n;
                            j2 = n2;
                            n2 = now;
                            n = j2;
                            now = j1;
                            act = 3;
                        }
                    } else if (n >= 50 && n <= 57) {
                        t1 = t.charAt(i + 1);
                        t.setCharAt(i + 1, t.charAt(i));
                        t.setCharAt(i, t1);
                        j = n;
                        n = now;
                        now = j;
                        act = 3;
                    } else lbl-1000:
                    // 2 sources

                    {
                        act = L == 106 || L == 74 || L == 113 || L == 81 ? 2 : (L == 120 || L == 88 || L == 122 || L == 90 ? 2 : (L == 32 || L == 41 || L == 93 || L == 125 ? (nL == 32 || nL < 48 && nL != 41 || nL > 122 || nL >= 58 && nL <= 64 || nL >= 91 && nL <= 96 && nL != 93 ? 2 : 3) : (L < 48 && L != 41 && L != 34 && L != 39 || L > 122 && L != 125 || L >= 58 && L <= 64 || L >= 91 && L <= 96 && L != 93 ? 2 : (n != 32 && n != 41 && n != 93 && n != 125 && n != 61 && n != 39 && n != 96 ? 2 : 3))));
                    }
                    break block58;
                }
                act = now == 46 ? (L >= 48 && L <= 57 && n >= 48 && n <= 57 ? 4 : 2) : 2;
            }
            switch (act) {
                case 0: {
                    if (i < nchr) {
                        t.deleteCharAt(i);
                    }
                    --nchr;
                    nnL = nL;
                    nL = L;
                    L = now;
                    now = n;
                    n = n2;
                    n2 = n3;
                    break;
                }
                case 1: {
                    df = -0.4f;
                    ** GOTO lbl202
                }
                case 2: {
                    df = 0.0f;
                    ** GOTO lbl202
                }
                case 3: {
                    df = 0.4f;
                }
lbl202:
                // 4 sources

                default: {
                    if (act != 6) {
                        nnL = nL;
                        nL = L;
                        L = now;
                        now = n;
                        n = n2;
                        n2 = n3;
                    }
                    d[i] = dm + df;
                    ++i;
                }
            }
        } while (i < nchr);
        if (cf.t.length() > 0) {
            cf.t.delete(0, cf.t.length());
        }
        cf.t.append(t);
        cf.d = new float[nchr];
        System.arraycopy(d, 0, cf.d, 0, nchr);
    }

    private static void exception(Exception ex, String msg, boolean doNotStop) {
        String ERR_START = "============================";
        String errMsg = "============================";
        String exMsg = ex.toString();
        exMsg = exMsg == null || exMsg.length() <= 0 ? "Unknown error." : "Error: " + exMsg;
        errMsg = errMsg + nl + exMsg;
        if (msg != null && msg.trim().length() > 0) {
            errMsg = errMsg + nl + msg;
        }
        errMsg = errMsg + nl + PlotPDF.stack2string(ex) + nl + "============================";
        if (doNotStop) {
            System.out.println(errMsg);
        } else {
            ErrMsgBx mb = new ErrMsgBx(errMsg, progName);
        }
    }

    private static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String t = sw.toString();
            if (t != null && t.length() > 0) {
                int i = t.indexOf("Unknown Source");
                int j = t.indexOf("\n");
                if (i > 0 && i > j && (j = (t = t.substring(0, i)).lastIndexOf("\n")) > 0) {
                    t = t.substring(0, j) + nl;
                }
            }
            return DASH_LINE + nl + t + DASH_LINE;
        }
        catch (Exception e2) {
            return "Internal error in \"stack2string(Exception e)\"";
        }
    }

    public static String getPathApp() {
        String path;
        C c = new C();
        try {
            URI dir = c.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (dir != null) {
                String d = dir.toString();
                if (d.startsWith("jar:") && d.endsWith("!/")) {
                    d = d.substring(4, d.length() - 2);
                    dir = new URI(d);
                }
                path = new File(dir.getPath()).getParent();
            } else {
                path = System.getProperty("user.dir");
            }
        }
        catch (URISyntaxException e) {
            if (!started) {
                ErrMsgBx emb = new ErrMsgBx("Error: " + e.toString() + nl + "   trying to get the application's directory.", progName);
            }
            path = System.getProperty("user.dir");
        }
        started = true;
        return path;
    }

    static class ErrMsgBx {
        public ErrMsgBx(String msg, String title) {
            if (msg == null || msg.trim().length() <= 0) {
                System.err.println("--- MsgBox: null or empty \"message\".");
                return;
            }
            if (title == null || title.length() <= 0) {
                title = " Error:";
            }
            Frame frame = new Frame(title);
            String iconName = "images/ErrMsgBx.gif";
            URL imgURL = this.getClass().getResource(iconName);
            if (imgURL != null) {
                frame.setIconImage(new ImageIcon(imgURL).getImage());
            } else {
                System.err.println("--- Error in MsgBox constructor: Could not load image = \"" + iconName + "\"");
            }
            frame.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int left = Math.max(55, (screenSize.width - frame.getWidth()) / 2);
            int top = Math.max(10, (screenSize.height - frame.getHeight()) / 2);
            frame.setLocation(Math.min(screenSize.width - 100, left), Math.min(screenSize.height - 100, top));
            String msgText = msg.trim();
            System.out.println("--- MsgBox:" + nl + msgText + nl + "---");
            frame.setVisible(true);
            MsgBoxDialog msgBox = new MsgBoxDialog(frame, msgText, title, true);
            msgBox.setVisible(true);
            msgBox.dispose();
            frame.setVisible(false);
            frame.dispose();
        }

        private static class MsgBoxDialog
        extends Dialog {
            private Button ok;
            private Panel p;
            private final TextArea text;

            public MsgBoxDialog(Frame parent, String msg, String title, boolean modal) {
                super(parent, " " + title, modal);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        MsgBoxDialog.this.setVisible(false);
                    }
                });
                this.setLayout(new BorderLayout());
                this.p = new Panel();
                this.p.setLayout(new FlowLayout(1));
                this.ok = new Button();
                int wMax = 85;
                int hMax = 20;
                int wMin = 5;
                boolean hMin = true;
                int w = 5;
                int h = 1;
                int i = 0;
                int j = 5;
                String eol = "\n";
                String nl = System.getProperty("line.separator");
                do {
                    char c;
                    String s;
                    if ((s = String.valueOf(c = msg.charAt(i))).equals("\n") || s.equals(nl)) {
                        ++h;
                        j = 5;
                        continue;
                    }
                    w = Math.max(++j, w);
                } while (++i < msg.length() - 1);
                int scroll = 3;
                if (w > 85 && h <= 20) {
                    scroll &= 2;
                }
                if (h > 20 && w <= 85) {
                    scroll &= 1;
                }
                if (w > 85 && h > 20) {
                    scroll = 0;
                }
                w = Math.min(Math.max(w, 10), 85);
                h = Math.min(h, 20);
                this.text = new TextArea(msg, h, w, scroll);
                this.text.setEditable(false);
                this.text.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                        if (evt.getKeyCode() == 9) {
                            MsgBoxDialog.this.ok.requestFocusInWindow();
                        }
                    }
                });
                this.add((Component)this.text, "Center");
                this.ok.setLabel("OK");
                this.ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MsgBoxDialog.this.closeDialog();
                    }
                });
                this.ok.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                    }
                });
                this.p.add(this.ok);
                this.add((Component)this.p, "South");
                this.pack();
                this.setLocation(parent.getLocation());
                this.ok.requestFocusInWindow();
            }

            private void closeDialog() {
                this.setVisible(false);
            }
        }
    }

    private static class C {
        private C() {
        }

        private static void C() {
        }
    }

    static class ChemFormula {
        StringBuffer t = new StringBuffer();
        float[] d;

        ChemFormula(String txt, float[] d_org) {
            this.t.append(txt);
            int nChar = txt.length();
            this.d = new float[nChar];
            System.arraycopy(d_org, 0, this.d, 0, d_org.length);
        }
    }
}

