/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import lib.common.Util;
import lib.kemi.graph_lib.DiagrPaintUtility;
import lib.kemi.graph_lib.GraphLib;

public class ClipboardCopy_Image {
    public static void setClipboard_Image(double heightToWidth, GraphLib.PltData dD, DiagrPaintUtility diagrPU) {
        ImageSelection imageSelection = new ImageSelection(heightToWidth, dD, diagrPU);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    private static class ImageSelection
    implements Transferable {
        private final int width;
        private final int height;
        private final GraphLib.PltData dd;
        private final DiagrPaintUtility diagrPaintUtil;
        private static final DataFlavor[] supportedFlavors = new DataFlavor[]{DataFlavor.imageFlavor};

        public ImageSelection(double height2width, GraphLib.PltData dD, DiagrPaintUtility diagrPU) {
            this.width = 4 * Toolkit.getDefaultToolkit().getScreenSize().width / 5;
            this.height = (int)((double)this.width * height2width);
            this.dd = dD;
            this.diagrPaintUtil = diagrPU;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor f : supportedFlavors) {
                if (!f.equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (DataFlavor.imageFlavor.equals(flavor)) {
                try {
                    BufferedImage buff_image = new BufferedImage(this.width, this.height, 1);
                    Graphics2D g2D = buff_image.createGraphics();
                    if (this.diagrPaintUtil.useBackgrndColour) {
                        g2D.setColor(this.diagrPaintUtil.backgrnd);
                    } else {
                        g2D.setColor(Color.WHITE);
                    }
                    g2D.fillRect(0, 0, this.width, this.height);
                    this.diagrPaintUtil.paintDiagram(g2D, new Dimension(this.width, this.height), this.dd, false);
                    return buff_image;
                }
                catch (Exception ex) {
                    Util.exceptn((String)("getTransferData - Error: " + ex.toString()));
                    return null;
                }
            }
            Util.exceptn((String)("UnsupportedFlavorException; flavor = " + flavor.toString()));
            return null;
        }
    }
}

