/*
 * Decompiled with CFR 0.152.
 */
package predominanceAreaDiagrams;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import predominanceAreaDiagrams.Predom;

public class Main {
    private static final String progName = "Program PREDOM";
    private static final String nl = System.getProperty("line.separator");
    private static boolean started = false;
    private static final String SLASH = File.separator;

    public static void main(String[] args) {
        if (!Main.doJarFilesExist()) {
            return;
        }
        Predom.main(args);
    }

    public static boolean doJarFilesExist() {
        JarFile runningJar = Main.getRunningJarFile();
        if (runningJar != null) {
            String[] jars;
            String classPath;
            Manifest manifest;
            try {
                manifest = runningJar.getManifest();
            }
            catch (IOException ex) {
                manifest = null;
                String msg = "Warning: no manifest found in the application's jar file:" + nl + "\"" + runningJar.getName() + "\"";
                ErrMsgBx emb = new ErrMsgBx(msg, progName);
            }
            if (manifest != null && (classPath = manifest.getMainAttributes().getValue("Class-Path")) != null && classPath.length() > 0 && (jars = classPath.split("\\s+")).length > 0) {
                File[] rootNames = File.listRoots();
                for (String jar : jars) {
                    File libJarFile;
                    boolean isPathAbsolute = false;
                    for (File f : rootNames) {
                        if (!jar.toLowerCase().startsWith(f.getAbsolutePath().toLowerCase())) continue;
                        isPathAbsolute = true;
                        break;
                    }
                    if (!isPathAbsolute) {
                        String p = Main.getPathApp();
                        if (!p.endsWith(SLASH) && !jar.startsWith(SLASH)) {
                            p = p + SLASH;
                        }
                        jar = p + jar;
                    }
                    if ((libJarFile = new File(jar)).exists()) continue;
                    libJarFile = new File(libJarFile.getAbsolutePath());
                    ErrMsgBx emb = new ErrMsgBx("Program PREDOM - Error:" + nl + "   File: \"" + libJarFile.getName() + "\"  not found in:" + nl + "   \"" + libJarFile.getParent() + "\"", progName);
                    return false;
                }
            }
        }
        return true;
    }

    public static JarFile getRunningJarFile() {
        C c = new C();
        String className = c.getClass().getName().replace('.', '/');
        URL url = c.getClass().getResource("/" + className + ".class");
        if (url.toString().startsWith("jar:")) {
            try {
                JarURLConnection jUrlC = (JarURLConnection)url.openConnection();
                return jUrlC.getJarFile();
            }
            catch (IOException ex) {
                ErrMsgBx emb = new ErrMsgBx("Error " + ex.toString(), progName);
                return null;
            }
        }
        return null;
    }

    public static String getPathApp() {
        String path;
        C c = new C();
        try {
            URI dir = c.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (dir != null) {
                String d = dir.toString();
                if (d.startsWith("jar:") && d.endsWith("!/")) {
                    d = d.substring(4, d.length() - 2);
                    dir = new URI(d);
                }
                path = new File(dir.getPath()).getParent();
            } else {
                path = System.getProperty("user.dir");
            }
        }
        catch (URISyntaxException e) {
            if (!started) {
                ErrMsgBx emb = new ErrMsgBx("Error: " + e.toString() + nl + "   trying to get the application's directory.", progName);
            }
            path = System.getProperty("user.dir");
        }
        started = true;
        return path;
    }

    static class ErrMsgBx {
        public ErrMsgBx(String msg, String title) {
            if (msg == null || msg.trim().length() <= 0) {
                System.err.println("--- MsgBox: null or empty \"message\".");
                return;
            }
            if (title == null || title.length() <= 0) {
                title = " Error:";
            }
            Frame frame = new Frame(title);
            String iconName = "images/ErrMsgBx.gif";
            URL imgURL = this.getClass().getResource(iconName);
            if (imgURL != null) {
                frame.setIconImage(new ImageIcon(imgURL).getImage());
            } else {
                System.err.println("--- Error in MsgBox constructor: Could not load image = \"" + iconName + "\"");
            }
            frame.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int left = Math.max(55, (screenSize.width - frame.getWidth()) / 2);
            int top = Math.max(10, (screenSize.height - frame.getHeight()) / 2);
            frame.setLocation(Math.min(screenSize.width - 100, left), Math.min(screenSize.height - 100, top));
            String msgText = msg.trim();
            System.out.println("--- MsgBox:" + nl + msgText + nl + "---");
            frame.setVisible(true);
            MsgBoxDialog msgBox = new MsgBoxDialog(frame, msgText, title, true);
            msgBox.setVisible(true);
            msgBox.dispose();
            frame.setVisible(false);
            frame.dispose();
        }

        private static class MsgBoxDialog
        extends Dialog {
            private Button ok;
            private Panel p;
            private final TextArea text;

            public MsgBoxDialog(Frame parent, String msg, String title, boolean modal) {
                super(parent, " " + title, modal);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        MsgBoxDialog.this.setVisible(false);
                    }
                });
                this.setLayout(new BorderLayout());
                this.p = new Panel();
                this.p.setLayout(new FlowLayout(1));
                this.ok = new Button();
                int wMax = 85;
                int hMax = 20;
                int wMin = 5;
                boolean hMin = true;
                int w = 5;
                int h = 1;
                int i = 0;
                int j = 5;
                String eol = "\n";
                String nl = System.getProperty("line.separator");
                do {
                    char c;
                    String s;
                    if ((s = String.valueOf(c = msg.charAt(i))).equals("\n") || s.equals(nl)) {
                        ++h;
                        j = 5;
                        continue;
                    }
                    w = Math.max(++j, w);
                } while (++i < msg.length() - 1);
                int scroll = 3;
                if (w > 85 && h <= 20) {
                    scroll &= 2;
                }
                if (h > 20 && w <= 85) {
                    scroll &= 1;
                }
                if (w > 85 && h > 20) {
                    scroll = 0;
                }
                w = Math.min(Math.max(w, 10), 85);
                h = Math.min(h, 20);
                this.text = new TextArea(msg, h, w, scroll);
                this.text.setEditable(false);
                this.text.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                        if (evt.getKeyCode() == 9) {
                            MsgBoxDialog.this.ok.requestFocusInWindow();
                        }
                    }
                });
                this.add((Component)this.text, "Center");
                this.ok.setLabel("OK");
                this.ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MsgBoxDialog.this.closeDialog();
                    }
                });
                this.ok.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27) {
                            MsgBoxDialog.this.closeDialog();
                        }
                    }
                });
                this.p.add(this.ok);
                this.add((Component)this.p, "South");
                this.pack();
                this.setLocation(parent.getLocation());
                this.ok.requestFocusInWindow();
            }

            private void closeDialog() {
                this.setVisible(false);
            }
        }
    }

    private static class C {
        private C() {
        }

        private static void C() {
        }
    }
}

