/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.eps;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.qenherkhopeshef.graphics.eps.EPSLowLevel;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2D;
import org.qenherkhopeshef.graphics.generic.StreamGraphicsConfiguration;

public class EncapsulatedPostscriptGraphics2D
extends BaseGraphics2D {
    EPSLowLevel epsOut;
    private Dimension dimensions;
    private double precision = 0.05;
    private boolean closeOnDispose;

    public EncapsulatedPostscriptGraphics2D(File f, Dimension2D dims) throws IOException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"), dims, "");
    }

    public EncapsulatedPostscriptGraphics2D(File f, Dimension2D dims, String comment) throws IOException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"), dims, comment);
    }

    public EncapsulatedPostscriptGraphics2D(String fname, Dimension2D dims) throws IOException {
        this(new File(fname), dims);
    }

    public EncapsulatedPostscriptGraphics2D(Writer writer, Dimension2D dims, String comment) throws IOException {
        this.closeOnDispose = true;
        this.epsOut = new EPSLowLevel(writer, dims, comment);
        this.setFont(new Font("SansSerif", 0, 12));
    }

    private EncapsulatedPostscriptGraphics2D(EncapsulatedPostscriptGraphics2D g) {
        super(g);
        this.dimensions = g.dimensions;
        this.epsOut = g.epsOut;
        this.closeOnDispose = false;
    }

    public void draw(Shape shape) {
        if (shape instanceof Line2D) {
            Line2D l = (Line2D)shape;
            Point2D a = this.deviceCoords(l.getP1());
            Point2D b = this.deviceCoords(l.getP2());
            this.epsOut.drawLine(a.getX(), a.getY(), b.getX(), b.getY());
        } else {
            this.epsOut.gsave();
            this.addPath(shape);
            this.epsOut.setColor(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue());
            this.epsOut.strokePath();
            this.epsOut.grestore();
        }
    }

    private void addPath(Shape shape) {
        this.epsOut.startPath();
        PathIterator iter = shape.getPathIterator(null);
        Point2D first = null;
        while (!iter.isDone()) {
            double[] coords = new double[6];
            int type = iter.currentSegment(coords);
            Point2D[] points = this.getPointsInDeviceSpace(coords);
            switch (type) {
                case 4: {
                    this.epsOut.closePath();
                    break;
                }
                case 3: {
                    this.epsOut.cubicTo(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY());
                    break;
                }
                case 1: {
                    this.epsOut.lineTo(points[0].getX(), points[0].getY());
                    break;
                }
                case 0: {
                    first = points[0];
                    this.epsOut.moveTo(first.getX(), first.getY());
                    break;
                }
                case 2: {
                    this.epsOut.quadTo(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY());
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected constant in path iterator");
                }
            }
            iter.next();
        }
    }

    public void fill(Shape shape) {
        this.epsOut.gsave();
        this.addPath(shape);
        this.epsOut.setColor(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue());
        this.epsOut.fillPath();
        this.epsOut.grestore();
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public void setStroke(Stroke stroke) {
        super.setStroke(stroke);
        if (stroke instanceof BasicStroke) {
            // empty if block
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Graphics create() {
        return new EncapsulatedPostscriptGraphics2D(this);
    }

    public void dispose() {
        if (this.closeOnDispose && this.epsOut != null) {
            this.epsOut.close();
            this.epsOut = null;
        } else {
            this.epsOut = null;
        }
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new StreamGraphicsConfiguration(new Rectangle(0, 0, 10000, 10000), new AffineTransform());
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.getTransform(), false, true);
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public void setProperties(Properties properties) {
    }

    private Point2D deviceCoords(Point2D p) {
        Point2D.Double res = new Point2D.Double();
        this.getTransform().transform(p, res);
        return res;
    }

    private Point2D[] getPointsInDeviceSpace(double[] coords) {
        Point2D[] points = new Point2D[coords.length / 2];
        for (int i = 0; i < points.length; ++i) {
            Point2D.Double p = new Point2D.Double(coords[i * 2], coords[i * 2 + 1]);
            points[i] = this.deviceCoords(p);
        }
        return points;
    }
}

