/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.pict;

import java.io.IOException;
import java.io.OutputStream;

public class SimpleByteBuffer {
    private byte[] t = new byte[1024];
    private int size = 0;
    private int pos = 0;

    private void ensureExists(int i) {
        while (i >= this.t.length) {
            byte[] newT = new byte[this.t.length * 2];
            System.arraycopy(this.t, 0, newT, 0, this.size);
            this.t = newT;
        }
    }

    public void seek(int i) {
        this.pos = i;
    }

    public int getPos() {
        return this.pos;
    }

    public int getSize() {
        return this.size;
    }

    public void writeByte(int b) {
        this.ensureExists(this.pos);
        this.t[this.pos++] = (byte)b;
        if (this.size < this.pos) {
            this.size = this.pos;
        }
    }

    public void writeShortBigEndian(int a) {
        int lsb = a & 0xFF;
        int msb = (a & 0xFF00) >>> 8;
        this.writeByte(msb);
        this.writeByte(lsb);
    }

    public void writeIntBigEndian(int k) {
        int a = k & 0xFF;
        int b = (k & 0xFF00) >>> 8;
        int c = (k & 0xFF0000) >>> 16;
        int d = (k & 0xFF000000) >>> 24;
        this.writeByte(d);
        this.writeByte(c);
        this.writeByte(b);
        this.writeByte(a);
    }

    public void writeShortLittleEndian(int a) {
        int lsb = a & 0xFF;
        int msb = (a & 0xFF00) >>> 8;
        this.writeByte(lsb);
        this.writeByte(msb);
    }

    public void writeToStream(OutputStream out) throws IOException {
        out.write(this.t, 0, this.getSize());
    }

    public byte[] getAsArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.t, 0, result, 0, this.size);
        return result;
    }

    public byte[] getAsArray(int start) {
        byte[] result = new byte[this.size - start];
        System.arraycopy(this.t, start, result, 0, this.size - start);
        return result;
    }

    public void fill(byte b, int pos, int length) {
        this.ensureExists(pos + length - 1);
        for (int i = pos; i < pos + length; ++i) {
            this.t[i] = b;
        }
        this.pos = pos + length;
        if (this.size < pos) {
            this.size = pos;
        }
    }
}

