/*
 * Decompiled with CFR 0.152.
 */
package simpleEquilibriumDiagrams;

import java.io.File;
import java.io.PrintStream;
import java.util.Locale;
import lib.common.Util;
import lib.kemi.chem.Chem;
import lib.kemi.graph_lib.GraphLib;
import simpleEquilibriumDiagrams.SED;

public class Plot {
    private SED sed = null;
    static int nbrSpeciesInPlot;
    static int[] speciesInPlot;
    private static final int L2 = 20;
    private static double[] yMax;
    static double[][] c0;
    static double[][] tot0;
    private static boolean xMolar;
    private static final Locale engl;
    private final PrintStream err;
    private final PrintStream out;

    public Plot(SED sed0, PrintStream err0, PrintStream out0) {
        this.sed = sed0;
        this.err = err0 != null ? err0 : System.err;
        this.out = out0 != null ? out0 : System.out;
    }

    void preparePlot(Chem ch) {
        if (this.sed.dbg) {
            this.out.println("--- preparePlot(ch)");
        }
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.ChemConcs csC = cs.chemConcs;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.Diagr diag = ch.diag;
        yMax = new double[cs.Ms + 20];
        for (int i = 0; i < yMax.length; ++i) {
            Plot.yMax[i] = 0.0;
        }
        c0 = new double[cs.Ms][this.sed.nSteps + 1];
        tot0 = new double[cs.Na][this.sed.nSteps + 1];
        if (diag.Eh && diag.pInX != 3 && diag.plotType != 5) {
            boolean peGiven = false;
            for (int i = 0; i < cs.Na; ++i) {
                if (!Util.isElectron(namn.identC[i]) || csC.kh[i] != 2) continue;
                peGiven = true;
                break;
            }
            if (!peGiven) {
                diag.Eh = false;
            }
        }
    }

    void storePlotData(int nP, Chem ch) {
        double w;
        if (this.sed.dbg) {
            this.out.println("--- storePlotData(" + nP + ", ch)");
        }
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.ChemConcs csC = cs.chemConcs;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.Diagr diag = ch.diag;
        for (int i = 0; i < cs.Ms; ++i) {
            Plot.c0[i][nP] = 0.0;
            if (diag.plotType == 4 || diag.plotType == 7) {
                Plot.c0[i][nP] = -9999.0;
            }
            if (diag.plotType == 5 || diag.plotType == 6) {
                Plot.c0[i][nP] = 9999.0;
            }
            if (csC.isErrFlagsSet(2) || csC.isErrFlagsSet(3) || csC.isErrFlagsSet(4) || csC.isErrFlagsSet(6)) continue;
            if (diag.plotType < 4) {
                if (csC.C[i] > 1.0E35) {
                    Plot.c0[i][nP] = 1.0E35;
                    continue;
                }
                if (!(Math.abs(csC.C[i]) <= 1.0E35)) continue;
                Plot.c0[i][nP] = csC.C[i];
                continue;
            }
            if (diag.plotType == 8) continue;
            if (csC.logA[i] > 1.0E35) {
                Plot.c0[i][nP] = 1.0E35;
            }
            if ((w = Math.abs(csC.logA[i])) <= 1.0E35 && (w > 0.0 || Math.abs(csC.C[i]) > 0.0)) {
                Plot.c0[i][nP] = csC.logA[i];
            }
            if (!cs.noll[i] || !(w > 0.0) || !(w <= 1.0E35)) continue;
            Plot.c0[i][nP] = csC.logA[i];
        }
        for (int j = 0; j < cs.Na; ++j) {
            Plot.tot0[j][nP] = 0.0;
            if (csC.errFlags < -1) continue;
            if (diag.plotType == 2) {
                if (!(Math.abs(csC.solub[j]) < 1.0E35)) continue;
                Plot.tot0[j][nP] = csC.solub[j];
                continue;
            }
            if (!(Math.abs(csC.tot[j]) < 1.0E35)) continue;
            Plot.tot0[j][nP] = csC.tot[j];
        }
        if (diag.plotType == 8 && diag.Hplus >= 0 && diag.Hplus < cs.Ms) {
            if (Math.abs(csC.C[diag.Hplus]) <= 1.0E35) {
                Plot.c0[0][nP] = csC.C[diag.Hplus];
            }
            if ((w = Math.abs(csC.logA[diag.Hplus])) <= 1.0E35 && (w >= 1.0E-35 || Math.abs(csC.C[diag.Hplus]) >= 1.0E-35)) {
                Plot.c0[1][nP] = csC.logA[diag.Hplus];
            }
            if (diag.OHmin > -1 && Math.abs(csC.C[diag.OHmin]) <= 1.0E35) {
                Plot.c0[2][nP] = csC.C[diag.OHmin];
            }
            if (nP > 0) {
                w = c0[1][nP] - c0[1][nP - 1];
                double y = tot0[diag.Hplus][nP] - c0[0][nP] + c0[2][nP] - (tot0[diag.Hplus][nP - 1] - c0[0][nP - 1] + c0[2][nP - 1]);
                double z = 0.0;
                if (Math.abs(w) >= 1.0E-30) {
                    z = y / w;
                }
                if (z < diag.yLow) {
                    diag.yLow = z;
                }
                if (z > diag.yHigh) {
                    diag.yHigh = z;
                }
            }
        }
    }

    void drawPlot(File plotFile, Chem ch) {
        double w;
        int j;
        int i;
        String t;
        int n;
        Chem.ChemSystem cs = ch.chemSystem;
        Chem.ChemSystem.ChemConcs csC = cs.chemConcs;
        Chem.ChemSystem.NamesEtc namn = cs.namn;
        Chem.Diagr diag = ch.diag;
        Chem.DiagrConcs dgrC = ch.diagrConcs;
        if (this.sed.dbg) {
            this.out.println("--- drawPlot(" + plotFile.toString() + ", ch)" + System.getProperty("line.separator") + "Drawing the plot...");
        }
        nbrSpeciesInPlot = cs.Ms;
        speciesInPlot = new int[cs.Ms + 20];
        if (diag.plotType == 2) {
            nbrSpeciesInPlot = 0;
            for (n = 0; n < cs.Na; ++n) {
                t = namn.identC[n];
                if (Util.isElectron(t) || Util.isProton(t) || Util.isWater(t)) continue;
                Plot.speciesInPlot[++Plot.nbrSpeciesInPlot - 1] = n;
            }
        } else if (diag.plotType == 5 || diag.plotType == 6) {
            for (n = 0; n < cs.Ms; ++n) {
                t = namn.ident[n];
                if (diag.plotType == 5) {
                    if (!Util.isElectron(t)) continue;
                    Plot.speciesInPlot[0] = n;
                    break;
                }
                if (!Util.isProton(t)) continue;
                Plot.speciesInPlot[0] = n;
                break;
            }
            nbrSpeciesInPlot = 1;
        } else if (diag.plotType == 8) {
            nbrSpeciesInPlot = 1;
            Plot.speciesInPlot[0] = diag.Hplus;
        } else {
            nbrSpeciesInPlot = 0;
            for (n = 0; n < cs.Ms; ++n) {
                t = namn.ident[n].toUpperCase();
                if (diag.plotType != 7 && Util.isElectron(t)) continue;
                if (diag.plotType == 4) {
                    if (n == diag.compY) {
                        Plot.speciesInPlot[++Plot.nbrSpeciesInPlot - 1] = n;
                        continue;
                    }
                    if (diag.compY >= cs.Na) {
                        if (n < cs.Na && Math.abs(cs.a[diag.compY][n]) <= 1.0E-10) continue;
                        Plot.speciesInPlot[++Plot.nbrSpeciesInPlot - 1] = n;
                        continue;
                    }
                    if (n < cs.Na || !(Math.abs(cs.a[n - cs.Na][diag.compY]) > 1.0E-10)) continue;
                    Plot.speciesInPlot[++Plot.nbrSpeciesInPlot - 1] = n;
                    continue;
                }
                Plot.speciesInPlot[++Plot.nbrSpeciesInPlot - 1] = n;
            }
        }
        double xLow = this.sed.bt[diag.compX][0];
        double xHigh = this.sed.bt[diag.compX][this.sed.bt[0].length - 1];
        if (dgrC.hur[diag.compX] == 3) {
            xLow = Math.log10(xLow);
            xHigh = Math.log10(xHigh);
        }
        if (Util.isProton(namn.identC[diag.compX]) || Util.isElectron(namn.identC[diag.compX])) {
            if (dgrC.hur[diag.compX] != 5) {
                diag.pInX = 0;
            } else {
                xLow = -xLow;
                xHigh = -xHigh;
                if (diag.pInX == 3) {
                    xLow = this.sed.peEh * xLow;
                    xHigh = this.sed.peEh * xHigh;
                }
            }
        }
        xMolar = true;
        if (dgrC.hur[diag.compX] <= 2 && Math.abs(xLow) < 0.9 && Math.abs(xHigh) < 0.9) {
            xMolar = false;
            xLow *= 1000.0;
            xHigh *= 1000.0;
        }
        double yLow = diag.yLow;
        double yHigh = diag.yHigh;
        if (diag.plotType <= 3 && !diag.inputYMinMax) {
            yLow = diag.plotType == 2 ? -16.0 : (diag.plotType == 3 ? -9.0 : 0.0);
            yHigh = diag.plotType == 2 ? 2.0 : 1.0;
        }
        double yMin = yLow + 0.005 * (yHigh - yLow);
        if (diag.plotType == 1) {
            yMin = yLow + (double)diag.fractionThreshold * (yHigh - yLow);
        }
        int nTextX = 6 + namn.nameLength[namn.iel[diag.compX]];
        if (diag.pInX == 1 || diag.pInX == 2) {
            nTextX = 2;
        } else if (diag.pInX == 3) {
            nTextX = 8;
        }
        int nTextY = 8;
        if (diag.plotType == 3) {
            nTextY = 9;
        } else if (diag.plotType == 2) {
            nTextY = 10;
        } else if (diag.plotType == 4) {
            nTextY = 12;
        } else if (diag.plotType == 5 || diag.plotType == 6) {
            nTextY = 2;
        }
        float xAxl = 15.0f;
        float yAxl = 10.0f;
        float heightAx = 0.035f * yAxl;
        if (this.sed.tHeight > 1.0E-4) {
            heightAx = (float)this.sed.tHeight * heightAx;
        }
        float xOr = 7.5f * heightAx;
        float yOr = 4.0f * heightAx;
        float xMx = xOr + xAxl;
        float yMx = yOr + yAxl;
        float xL = xAxl / (float)(xHigh - xLow);
        float xI = xL * (float)xLow - xOr;
        float yL = yAxl / (float)(yHigh - yLow);
        float yI = yL * (float)yHigh - yMx;
        if (!xMolar) {
            xL *= 1000.0f;
        }
        if (diag.pInX == 1 || diag.pInX == 2) {
            xL = -xL;
        } else if (diag.pInX == 3) {
            xL = -xL * (float)this.sed.peEh;
        }
        this.sed.dd = new GraphLib.PltData();
        GraphLib g = new GraphLib();
        boolean textWithFonts = true;
        try {
            g.start(this.sed.dd, plotFile, textWithFonts);
        }
        catch (GraphLib.openPlotFileException ex) {
            this.sed.showErrMsgBx(ex.getMessage(), 1);
            g.end();
            return;
        }
        this.sed.dd.axisInfo = false;
        g.setLabel("-- SED DIAGRAM --");
        g.setIsFormula(true);
        g.setPen(1);
        g.setPen(-1);
        try {
            g.axes((float)xLow, (float)xHigh, (float)yLow, (float)yHigh, xOr, yOr, xAxl, yAxl, heightAx, false, false, false);
        }
        catch (GraphLib.AxesDataException ex) {
            this.sed.showMsg(ex);
            g.end();
            return;
        }
        float yP = yAxl / 2.0f + yOr - (float)nTextY / 2.0f * (1.3f * heightAx);
        float xP = xOr - 6.6f * heightAx;
        String t2 = "Fraction";
        if (diag.plotType == 2) {
            t2 = "Log Solubl.";
        } else if (diag.plotType == 3) {
            t2 = "Log Conc.";
        } else if (diag.plotType == 4) {
            t2 = "Log (a`i'/a`ref')";
        } else if (diag.plotType == 5) {
            t2 = "pe";
            if (diag.Eh) {
                t2 = "E`H'";
            }
        } else if (diag.plotType == 6) {
            t2 = "pH";
        } else if (diag.plotType == 7) {
            t2 = "Log Activity";
        } else if (diag.plotType == 8) {
            t2 = "d([H+]`bound')/d(-pH)";
        }
        g.setLabel("Y-AXIS TEXT");
        g.moveToDrawTo(0.0f, 0.0f, 0);
        g.sym(xP, yP, heightAx, t2, 90.0f, 0, false);
        yP = yOr - 3.6f * heightAx;
        xP = xAxl / 2.0f + xOr - (float)nTextX / 2.0f * (1.1429f * heightAx);
        if (dgrC.hur[diag.compX] == 5) {
            t2 = diag.pInX == 0 ? (Util.isGas(namn.identC[diag.compX]) ? "Log P`" + namn.identC[diag.compX] + "'" : "Log {" + namn.identC[diag.compX] + "}") : (diag.pInX == 1 ? "pH" : (diag.pInX == 2 ? "pe" : "E`SHE' / V"));
        } else if (dgrC.hur[diag.compX] == 2) {
            t2 = "[" + namn.identC[diag.compX] + "]`TOT'";
            t2 = xMolar ? t2 + "    M" : t2 + "    mM";
        } else {
            t2 = "Log [" + namn.identC[diag.compX] + "]`TOT'";
        }
        if (dgrC.hur[diag.compX] == 2 || dgrC.hur[diag.compX] == 3 || dgrC.hur[diag.compX] == 5) {
            g.setLabel("X-AXIS TEXT");
            g.moveToDrawTo(0.0f, 0.0f, 0);
            g.sym(xP, yP, heightAx, t2, 0.0f, 0, false);
        }
        g.setLabel("-- CURVES --");
        g.setPen(1);
        float[] xax = new float[this.sed.nSteps + 1];
        for (int i2 = 0; i2 < this.sed.nSteps + 1; ++i2) {
            xax[i2] = dgrC.hur[diag.compX] == 3 ? (float)((double)xL * Math.log10(this.sed.bt[diag.compX][i2]) - (double)xI) : (float)((double)xL * this.sed.bt[diag.compX][i2] - (double)xI);
        }
        float[] yax = new float[this.sed.nSteps + 1];
        for (i = 0; i < yax.length; ++i) {
            yax[i] = 0.0f;
        }
        int xtraLabel = 0;
        double yLow1 = yLow;
        if (diag.plotType == 1) {
            yLow1 = 0.005;
        }
        int[] maxPoint = new int[cs.Ms + 20];
        int k = 0;
        do {
            i = speciesInPlot[k];
            if (diag.plotType == 1) {
                if (i > cs.Ms) continue;
                for (j = 0; j < this.sed.nSteps + 1; ++j) {
                    if (Math.abs(tot0[diag.compY][j]) > 1.0E-30) {
                        double o = i < cs.Na ? (i == diag.compY ? 1.0 : 0.0) : cs.a[i - cs.Na][diag.compY];
                        yax[j] = (float)(o * c0[i][j] / tot0[diag.compY][j]);
                        if (!(yax[j] >= 1.0f) || !(yax[j] <= 1.05f)) continue;
                        yax[j] = 0.99999f;
                        continue;
                    }
                    yax[j] = 0.0f;
                }
            } else if (diag.plotType == 2) {
                for (j = 0; j < this.sed.nSteps + 1; ++j) {
                    yax[j] = -50.0f;
                    if (!(tot0[i][j] > (double)1.0E-35f)) continue;
                    yax[j] = (float)Math.log10(tot0[i][j]);
                }
            } else if (diag.plotType == 3) {
                for (j = 0; j < this.sed.nSteps + 1; ++j) {
                    yax[j] = -99.0f;
                    if (!(c0[i][j] > (double)1.0E-35f)) continue;
                    yax[j] = (float)Math.log10(c0[i][j]);
                }
            } else if (diag.plotType == 4) {
                for (j = 0; j < this.sed.nSteps + 1; ++j) {
                    yax[j] = (float)(c0[i][j] - c0[diag.compY][j]);
                }
            } else if (diag.plotType == 5) {
                for (j = 0; j < this.sed.nSteps + 1; ++j) {
                    yax[j] = !diag.Eh ? (float)(-c0[i][j]) : (float)(-c0[i][j] * this.sed.peEh);
                }
            } else if (diag.plotType == 6) {
                for (j = 0; j < this.sed.nSteps + 1; ++j) {
                    yax[j] = (float)(-c0[i][j]);
                }
            } else if (diag.plotType == 7) {
                for (j = 0; j < this.sed.nSteps + 1; ++j) {
                    yax[j] = (float)c0[i][j];
                }
            } else if (diag.plotType == 8) {
                if (diag.Hplus >= 0 || diag.Hplus <= cs.Ms) {
                    double y2 = 0.0;
                    double w1 = c0[1][1] - c0[1][0];
                    double w2 = tot0[diag.Hplus][1] - c0[0][1] + c0[2][1] - (tot0[diag.Hplus][0] - c0[0][0] + c0[2][0]);
                    yax[0] = 0.0f;
                    if (Math.abs(w1) >= 1.0E-35) {
                        yax[0] = (float)(w2 / w1);
                    }
                    for (j = 1; j < this.sed.nSteps; ++j) {
                        w1 = c0[1][j] - c0[1][j - 1];
                        w2 = tot0[diag.Hplus][j] - c0[0][j] + c0[2][j] - (tot0[diag.Hplus][j - 1] - c0[0][j - 1] + c0[2][j - 1]);
                        double y1 = 0.0;
                        if (Math.abs(w1) >= 1.0E-35) {
                            y1 = (float)(w2 / w1);
                        }
                        w1 = c0[1][j + 1] - c0[1][j];
                        w2 = tot0[diag.Hplus][j + 1] - c0[0][j + 1] + c0[2][j + 1] - (tot0[diag.Hplus][j] - c0[0][j] + c0[2][j]);
                        y2 = 0.0;
                        if (Math.abs(w1) >= 1.0E-35) {
                            y2 = (float)(w2 / w1);
                        }
                        yax[j] = (float)((y1 + y2) / 2.0);
                    }
                    yax[this.sed.nSteps] = (float)y2;
                }
            } else {
                this.err.println("Programming error in \"drawPlot\";  plotType = " + diag.plotType);
                g.end();
                return;
            }
            maxPoint[k] = -1;
            Plot.yMax[k] = yMin;
            Plot.yMax[Plot.nbrSpeciesInPlot + xtraLabel] = yMin;
            boolean aPointIsShown = false;
            boolean aPointIsShownNextNot = false;
            boolean secondLabel = false;
            for (j = 0; j < this.sed.nSteps + 1; ++j) {
                if (aPointIsShown && (double)yax[j] < yMin) {
                    aPointIsShownNextNot = true;
                }
                if (aPointIsShownNextNot && (double)yax[j] > yMin) {
                    if (xtraLabel >= 20 || !((double)yax[j] >= yMax[nbrSpeciesInPlot + xtraLabel]) || !((double)yax[j] <= yHigh)) continue;
                    secondLabel = true;
                    maxPoint[Plot.nbrSpeciesInPlot + xtraLabel] = j;
                    Plot.yMax[Plot.nbrSpeciesInPlot + xtraLabel] = yax[j];
                    continue;
                }
                if ((double)yax[j] < yMax[k] || (double)yax[j] > yHigh) continue;
                aPointIsShown = true;
                maxPoint[k] = j;
                Plot.yMax[k] = yax[j];
            }
            if (secondLabel) {
                Plot.speciesInPlot[Plot.nbrSpeciesInPlot + xtraLabel] = speciesInPlot[k];
                ++xtraLabel;
            }
            if (maxPoint[k] < 0) continue;
            if (diag.plotType == 2) {
                g.setLabel(namn.identC[i]);
            } else {
                g.setLabel(namn.ident[i]);
            }
            g.setPen(-(speciesInPlot[k] + 1));
            boolean curveStarted = false;
            int curvePoint = 0;
            if ((double)yax[curvePoint] > yLow1 && (double)yax[curvePoint] < yHigh) {
                g.moveToDrawTo(xax[curvePoint], yL * yax[curvePoint] - yI, 0);
                curveStarted = true;
            }
            for (curvePoint = 1; curvePoint < this.sed.nSteps + 1; ++curvePoint) {
                double w2;
                if ((double)yax[curvePoint] > yLow1 && (double)yax[curvePoint] < yHigh) {
                    if (!curveStarted) {
                        j = curvePoint - 1;
                        if ((double)yax[j] > yLow1) {
                            w2 = xax[j] + (xax[curvePoint] - xax[j]) * ((float)yHigh - yax[j]) / (yax[curvePoint] - yax[j]);
                            Plot.yMax[k] = yHigh;
                            g.moveToDrawTo(w2, (double)yMx, 0);
                        } else if ((double)yax[j] == yLow1) {
                            g.moveToDrawTo(xax[j], yOr, 0);
                        } else {
                            xP = xax[j] + (xax[curvePoint] - xax[j]) * ((float)yLow - yax[j]) / (yax[curvePoint] - yax[j]);
                            xP = Math.min(xMx, Math.max(xOr, xP));
                            g.moveToDrawTo(xP, yOr, 0);
                        }
                        curveStarted = true;
                    }
                    g.moveToDrawTo(xax[curvePoint], yL * yax[curvePoint] - yI, 1);
                    continue;
                }
                if (!curveStarted) continue;
                j = curvePoint - 1;
                if ((double)yax[curvePoint] > yLow1) {
                    w2 = xax[j] + (xax[curvePoint] - xax[j]) * ((float)yHigh - yax[j]) / (yax[curvePoint] - yax[j]);
                    Plot.yMax[k] = yHigh;
                    g.moveToDrawTo(w2, (double)yMx, 1);
                } else if ((double)yax[curvePoint] == yLow1) {
                    g.moveToDrawTo(xax[curvePoint], yOr, 1);
                } else {
                    xP = xax[j] + (xax[curvePoint] - xax[j]) * ((float)yLow - yax[j]) / (yax[curvePoint] - yax[j]);
                    xP = Math.min(xMx, Math.max(xOr, xP));
                    g.moveToDrawTo(xP, yOr, 1);
                }
                curveStarted = false;
            }
        } while (++k < nbrSpeciesInPlot);
        float[] xPl = new float[cs.Ms + 20];
        float[] yPl = new float[cs.Ms + 20];
        if (diag.plotType != 5 && diag.plotType != 6 && diag.plotType != 8) {
            g.setLabel("-- LABELS ON CURVES --");
            g.setPen(1);
            for (k = 0; k < nbrSpeciesInPlot + xtraLabel; ++k) {
                if (maxPoint[k] < 0) continue;
                i = speciesInPlot[k];
                float xP1 = 0.5f * (float)namn.nameLength[i] * heightAx;
                xP = xax[maxPoint[k]] - xP1;
                xPl[k] = xP = Math.min(xMx - xP1, Math.max(xP, xOr + 0.4f * heightAx));
                yPl[k] = (float)((double)yL * yMax[k] + 0.5 * (double)heightAx - (double)yI);
            }
            for (k = 0; k < nbrSpeciesInPlot + xtraLabel; ++k) {
                if (maxPoint[k] < 0) continue;
                if (k > 0) {
                    boolean overlap;
                    float yPl0 = yPl[k];
                    int iSign = -1;
                    int inkr = 1;
                    do {
                        overlap = false;
                        for (int ij = 0; ij < k; ++ij) {
                            if (maxPoint[ij] < 0 || (double)yPl[k] > (double)yPl[ij] + 1.5 * (double)heightAx || (double)yPl[k] < (double)yPl[ij] - 1.5 * (double)heightAx || xPl[k] > xPl[ij] + heightAx * (float)namn.nameLength[speciesInPlot[ij]] || xPl[ij] > xPl[k] + heightAx * (float)namn.nameLength[speciesInPlot[k]]) continue;
                            overlap = true;
                            break;
                        }
                        if (!overlap) continue;
                        yPl[k] = yPl0 + (float)(iSign * inkr) * heightAx / 6.0f;
                        if ((iSign = -iSign) != -1) continue;
                        ++inkr;
                    } while (overlap);
                }
                t2 = diag.plotType == 2 ? namn.identC[speciesInPlot[k]] : namn.ident[speciesInPlot[k]];
                g.setPen(-(speciesInPlot[k] + 1));
                g.sym(xPl[k], yPl[k], heightAx, t2, 0.0f, -1, false);
            }
        }
        g.setLabel("-- HEADING --");
        g.setPen(1);
        g.setPen(-1);
        float headColumnX = 0.5f * heightAx;
        int headRow = 0;
        int headRowMax = Math.max(2, (2 + cs.Na) / 2);
        yP = yMx + heightAx;
        float yPMx = yMx;
        for (j = 0; j < cs.Na; ++j) {
            String value;
            if (dgrC.hur[j] != 1 && dgrC.hur[j] != 4 || dgrC.hur[j] == 4 && Util.isWater(namn.ident[j])) continue;
            i = namn.iel[j];
            yP += 2.0f * heightAx;
            if (++headRow == headRowMax) {
                headColumnX += 33.0f * heightAx;
                yP = yMx + 3.0f * heightAx;
            }
            yPMx = Math.max(yPMx, yP);
            if (dgrC.hur[j] == 1) {
                w = csC.tot[j];
                double wa = Math.abs(w);
                String units = "M";
                if (wa < 1.0 && wa >= 9.999E-5) {
                    w *= 1000.0;
                    units = "mM";
                } else if (wa < 9.999E-5 && wa >= 9.999E-8) {
                    w *= 1000000.0;
                    units = "$M";
                } else if (wa < 9.999E-8 && wa >= 9.999E-11) {
                    w *= 1.0E9;
                    units = "nM";
                } else if (wa < 9.999E-11) {
                    units = " ";
                }
                value = wa <= 9999.9 && wa >= 9.999E-11 || wa < 1.0E-99 ? String.format(engl, "=%8.2f ", Float.valueOf((float)w)) + units : String.format(engl, "=%10.2e M", Float.valueOf((float)w));
                t2 = "[" + namn.ident[i] + "]`TOT' " + value;
            } else {
                String c;
                boolean volt = false;
                if (Util.isElectron(namn.ident[j])) {
                    w = -dgrC.cLow[j];
                    if (diag.Eh) {
                        c = "E`H' = ";
                        w *= this.sed.peEh;
                        volt = true;
                    } else {
                        c = "pe =";
                    }
                } else if (Util.isProton(namn.ident[i])) {
                    w = -dgrC.cLow[j];
                    c = "pH=";
                } else if (Util.isGas(namn.ident[i])) {
                    w = dgrC.cLow[j];
                    c = "Log P`" + namn.ident[i] + "' =";
                } else {
                    w = dgrC.cLow[j];
                    c = "Log {" + namn.ident[i] + "} =";
                }
                if (Math.abs(w) < Double.MIN_VALUE) {
                    w = 0.0;
                }
                value = String.format(engl, "%7.2f", Float.valueOf((float)w));
                t2 = c + value;
                if (volt) {
                    t2 = t2 + " V";
                }
            }
            g.sym(headColumnX, yP, heightAx, t2, 0.0f, -1, false);
        }
        if (!Double.isNaN(diag.ionicStrength) && Math.abs(diag.ionicStrength) > 1.0E-10) {
            g.setLabel("-- Ionic Strength --");
            g.setPen(-1);
            yP += 2.0f * heightAx;
            if (++headRow == headRowMax) {
                headColumnX += 33.0f * heightAx;
                yP = yMx + 3.0f * heightAx;
            }
            if (yP > yPMx + 0.1f * heightAx) {
                headColumnX = 0.5f * heightAx;
                yPMx = yP;
            }
            t2 = diag.ionicStrength > 0.0 ? String.format(engl, "I=%6.3f M", diag.ionicStrength) : "I= varied";
            g.sym(headColumnX, yP, heightAx, t2, 0.0f, -1, false);
        }
        if (!Double.isNaN(diag.temperature) && diag.temperature > -1.0E-6) {
            g.setLabel("-- Temperature --");
            g.setPen(-1);
            t2 = String.format(engl, "t=%3d~C", Math.round((float)diag.temperature));
            w = 2.7;
            g.sym((float)((double)xMx + w * (double)heightAx), 0.1f * heightAx, heightAx, t2, 0.0f, -1, false);
        }
        if (diag.title != null && diag.title.trim().length() > 0) {
            g.setLabel("-- TITLE --");
            g.setPen(2);
            g.setPen(-2);
            g.sym(0.0f, yPMx + 3.5f * heightAx, heightAx, diag.title, 0.0f, -1, false);
        }
        g.end();
    }

    static {
        xMolar = true;
        engl = Locale.ENGLISH;
    }
}

