/*
 * Decompiled with CFR 0.152.
 */
package lib.huvud;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import lib.common.Util;
import lib.huvud.ProgramConf;

public class RedirectedFrame
extends JFrame {
    private final ProgramConf pc;
    private JFrame parentFrame;
    private RedirectedFrame f;
    private boolean loading;
    private boolean popupOnErr = true;
    private final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private static final String nl = System.getProperty("line.separator");
    PrintStream errPrintStream = new PrintStream(new errFilteredStream(new ByteArrayOutputStream()));
    PrintStream outPrintStream = new PrintStream(new outFilteredStream(new ByteArrayOutputStream()));
    private JTextArea aTextArea;
    private JButton jButtonClose;
    private JScrollPane jScrollPane1;

    public RedirectedFrame(int width, int height, ProgramConf pc0) {
        this.initComponents();
        this.pc = pc0;
        this.parentFrame = null;
        this.loading = true;
        this.setTitle(this.pc.progName + " - Error and Debug output:");
        this.setSize(width, height);
        this.setLocation(80, 28);
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RedirectedFrame.this.parentFrame != null && RedirectedFrame.this.parentFrame.isVisible()) {
                    if ((RedirectedFrame.this.parentFrame.getExtendedState() & 1) == 1) {
                        RedirectedFrame.this.parentFrame.setExtendedState(0);
                    }
                    RedirectedFrame.this.parentFrame.toFront();
                    RedirectedFrame.this.parentFrame.requestFocus();
                }
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altSKeyStroke = KeyStroke.getKeyStroke(83, 8, false);
        this.getRootPane().getInputMap(2).put(altSKeyStroke, "ALT_S");
        AbstractAction altSAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RedirectedFrame.this.jButtonClose.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_S", altSAction);
        String iconName = this.pc.progName.equalsIgnoreCase("spana") ? "images/Warn_RedTriangl_Blue.gif" : (this.pc.progName.equalsIgnoreCase("database") ? "images/Warn_RedTriangl_Yellow.gif" : "images/Warn_RedTriangl.gif");
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn("Could not load image: \"" + iconName + "\"");
        }
        if (this.pc.progName.equalsIgnoreCase("spana")) {
            this.aTextArea.setBackground(new Color(220, 220, 255));
            this.aTextArea.setForeground(new Color(0, 0, 102));
        } else if (this.pc.progName.equalsIgnoreCase("database")) {
            this.aTextArea.setBackground(new Color(255, 255, 204));
            this.aTextArea.setForeground(Color.black);
        } else {
            this.aTextArea.setBackground(Color.black);
            this.aTextArea.setForeground(new Color(102, 255, 0));
        }
        this.aTextArea.selectAll();
        this.aTextArea.replaceRange("", 0, this.aTextArea.getSelectionEnd());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RedirectedFrame.this.f = RedirectedFrame.this;
                RedirectedFrame.this.loading = false;
            }
        });
        System.setOut(this.outPrintStream);
        System.setErr(this.errPrintStream);
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.aTextArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                RedirectedFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RedirectedFrame.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                RedirectedFrame.this.formComponentMoved(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                RedirectedFrame.this.formComponentResized(evt);
            }
        });
        this.jButtonClose.setFont(new Font("Dialog", 0, 11));
        this.jButtonClose.setMnemonic('S');
        this.jButtonClose.setText("do not Show");
        this.jButtonClose.setToolTipText("hide frame (alt-S)");
        this.jButtonClose.setIconTextGap(2);
        this.jButtonClose.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RedirectedFrame.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jScrollPane1.setFont(new Font("Monospaced", 0, 13));
        this.aTextArea.setBackground(new Color(227, 227, 254));
        this.aTextArea.setColumns(20);
        this.aTextArea.setForeground(new Color(0, 0, 102));
        this.aTextArea.setRows(5);
        this.aTextArea.setText("This is a test");
        this.aTextArea.setToolTipText("");
        this.aTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RedirectedFrame.this.aTextAreaKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                RedirectedFrame.this.aTextAreaKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.aTextArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonClose)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonClose).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 279, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        Object[] opt1;
        Object[] opt0 = new Object[]{"Hide window", "Terminate!", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Hide this window?" + nl + nl + "\"Terminate\" will stop the program without" + nl + "closing connections or closing files, etc." + nl + "Terminate only if the program is not responding!" + nl, this.pc.progName, 1, 2, null, opt0, null);
        if (n == 0) {
            this.setVisible(false);
        } else if (n == 1 && (n = JOptionPane.showOptionDialog(this, "Are you really sure?", this.pc.progName, 0, 0, null, opt1 = new Object[]{"Cancel", "Yes"}, null)) == 1) {
            System.out.println("Program Terminated by the User.");
            System.exit(1);
        }
    }

    private void aTextAreaKeyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void aTextAreaKeyPressed(KeyEvent evt) {
        if (!Util.isKeyPressedOK(evt)) {
            evt.consume();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.loading || this.getExtendedState() == 1) {
            return;
        }
        if (this.getExtendedState() != 6) {
            if (this.getHeight() < 100) {
                this.setSize(this.getWidth(), 100);
            }
            if (this.getWidth() < 280) {
                this.setSize(280, this.getHeight());
            }
        }
    }

    private void formComponentMoved(ComponentEvent evt) {
        if (this.loading || this.getExtendedState() == 1) {
            return;
        }
        if (this.getExtendedState() != 6) {
            if (this.getX() < 0) {
                this.setLocation(2, this.getY());
            }
            if (this.getX() > this.screenSize.width - 100) {
                this.setLocation(this.screenSize.width - 100, this.getY());
            }
            if (this.getY() < 0) {
                this.setLocation(this.getX(), 2);
            }
            if (this.getY() > this.screenSize.height - 30) {
                this.setLocation(this.getX(), this.screenSize.height - 30);
            }
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.aTextArea.requestFocusInWindow();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.parentFrame != null && this.parentFrame.isVisible()) {
            this.setVisible(false);
            if ((this.parentFrame.getExtendedState() & 1) == 1) {
                this.parentFrame.setExtendedState(0);
            }
            this.parentFrame.toFront();
            this.parentFrame.requestFocus();
        }
    }

    public void setParentFrame(JFrame parent) {
        this.parentFrame = parent;
    }

    public void setCursorWait() {
        this.setCursor(new Cursor(3));
        this.aTextArea.setCursor(new Cursor(3));
    }

    public void setCursorDef() {
        this.setCursor(new Cursor(0));
        this.aTextArea.setCursor(new Cursor(0));
    }

    public boolean isPopupOnErr() {
        return this.popupOnErr;
    }

    public void setPopupOnErr(boolean popOnErr) {
        this.popupOnErr = popOnErr;
    }

    class outFilteredStream
    extends FilterOutputStream {
        public outFilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            String aString = new String(b);
            RedirectedFrame.this.aTextArea.append(aString);
            RedirectedFrame.this.aTextArea.setSelectionStart(Integer.MAX_VALUE);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            RedirectedFrame.this.aTextArea.append(aString);
            RedirectedFrame.this.aTextArea.setSelectionStart(Integer.MAX_VALUE);
        }
    }

    class errFilteredStream
    extends FilterOutputStream {
        public errFilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            String aString = new String(b);
            if (RedirectedFrame.this.popupOnErr) {
                RedirectedFrame.this.f.setVisible(true);
            }
            RedirectedFrame.this.aTextArea.append(aString);
            RedirectedFrame.this.aTextArea.setSelectionStart(Integer.MAX_VALUE);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            if (RedirectedFrame.this.popupOnErr) {
                RedirectedFrame.this.f.setVisible(true);
            }
            RedirectedFrame.this.aTextArea.append(aString);
            RedirectedFrame.this.aTextArea.setSelectionStart(Integer.MAX_VALUE);
        }
    }
}

