/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.rtfBasicWriter;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.qenherkhopeshef.graphics.rtfBasicWriter.RTFFontFamily;

public class SimpleRTFWriter {
    private HashMap fontNamesToFontData = new HashMap();
    private ArrayList fontIdToFontData = new ArrayList();
    private BufferedWriter writer;
    private int maxFontNum = -1;

    public SimpleRTFWriter(OutputStream outputStream) {
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeMacPictPicture(byte[] data, double width, double height) throws IOException {
        this.writer.write("{{\\pict");
        int integerWidth = (int)Math.ceil(width);
        int integerHeight = (int)Math.ceil(height);
        this.writer.write("\\picw" + integerWidth);
        this.writer.write("\\pich" + integerHeight);
        int widthInTwips = (int)Math.ceil(20.0 * width);
        int heightInTwips = (int)Math.ceil(20.0 * height);
        this.writer.write("\\picwgoal" + widthInTwips);
        this.writer.write("\\pichgoal" + heightInTwips);
        this.writer.write("\\macpict");
        this.writer.newLine();
        for (int i = 0; i < data.length; ++i) {
            int v;
            String hex;
            if (i % 64 == 0) {
                this.writer.newLine();
            }
            if ((hex = Integer.toHexString(v = (data[i] + 256) % 256)).length() == 1) {
                hex = "0" + hex;
            }
            this.writer.write(hex);
        }
        this.writer.write("}}");
        this.writer.newLine();
    }

    public void writeHeader() throws IOException {
        StringBuffer header = new StringBuffer();
        header.append("{\\rtf1\\ansi");
        header.append("{\\fonttbl");
        for (int i = 0; i <= this.maxFontNum; ++i) {
            RTFFontData data = (RTFFontData)this.fontIdToFontData.get(i);
            header.append("\\f" + i + "\\fnil" + "\\fcharset77 " + data.fontName);
            header.append(";");
        }
        header.append("}");
        this.writer.write(header.toString());
    }

    public void writeTail() throws IOException {
        this.writer.write("}");
        this.writer.close();
    }

    public void setItalic(boolean italic) throws IOException {
        this.writer.write("\\i");
        if (!italic) {
            this.writer.write("0");
        }
        this.writer.write(" ");
    }

    public void setBold(boolean bold) throws IOException {
        this.writer.write("\\b");
        if (!bold) {
            this.writer.write("0");
        }
        this.writer.write(" ");
    }

    public void writeString(String text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c < '\u0080') {
                this.writer.write(c);
                continue;
            }
            this.writer.write("\\u");
            this.writer.write(Integer.toString(c));
            this.writer.write(" ?");
        }
    }

    public void newParagraph() throws IOException {
        this.writer.write("\\par ");
    }

    public void startBlock() throws IOException {
        this.writer.write("{");
    }

    public void endBlock() throws IOException {
        this.writer.write("}");
    }

    public void declareFont(String fontName, RTFFontFamily fontFamily) {
        RTFFontData fontData = new RTFFontData(++this.maxFontNum, fontName, fontFamily);
        this.fontNamesToFontData.put(fontName, fontData);
        this.fontIdToFontData.add(null);
        this.fontIdToFontData.set(this.maxFontNum, fontData);
    }

    public void useFont(String fontName) throws IOException {
        RTFFontData data = (RTFFontData)this.fontNamesToFontData.get(fontName);
        this.writer.write("\\f" + data.fontNum + " ");
    }

    public void newPage() throws IOException {
        this.writer.write("");
    }

    public void writeEmfPicture(byte[] data, double width, double height) throws IOException {
        double picScale = 35.27777777777777;
        int scaleWidth = (int)Math.ceil(width * picScale);
        int scaledHeight = (int)Math.ceil(height * picScale);
        this.writer.write("{{\\pict");
        this.writer.write("\\emfblip");
        this.writer.write("\\picw" + scaleWidth);
        this.writer.write("\\pich" + scaledHeight);
        this.writer.write("\\picscalex100");
        this.writer.write("\\picscaley100");
        for (int i = 0; i < data.length; ++i) {
            int v;
            String hex;
            if (i % 20 == 0) {
                this.writer.newLine();
            }
            if ((hex = Integer.toHexString(v = (data[i] + 256) % 256)).length() == 1) {
                hex = "0" + hex;
            }
            this.writer.write(hex);
        }
        this.writer.write("}}");
    }

    public void writeWmfPicture(byte[] data, double width, double height) throws IOException {
        double picScale = 35.27777777777777;
        int scaleWidth = (int)Math.ceil(width * picScale);
        int scaledHeight = (int)Math.ceil(height * picScale);
        this.writer.write("{\\*\\shppict{\\pict");
        this.writer.write("\\wmetafile8");
        this.writer.write("\\picw" + scaleWidth);
        this.writer.write("\\pich" + scaledHeight);
        this.writer.write("\\picscalex100");
        this.writer.write("\\picscaley100");
        for (int i = 0; i < data.length; ++i) {
            int v;
            String hex;
            if (i % 64 == 0) {
                this.writer.newLine();
            }
            if ((hex = Integer.toHexString(v = (data[i] + 256) % 256)).length() == 1) {
                hex = "0" + hex;
            }
            this.writer.write(hex);
        }
        this.writer.write("}}");
    }

    private static class RTFFontData {
        int fontNum;
        String fontName;
        RTFFontFamily fontFamily;

        public RTFFontData(int fontNum, String fontName, RTFFontFamily fontFamily) {
            this.fontNum = fontNum;
            this.fontName = fontName;
            this.fontFamily = fontFamily;
        }
    }
}

