/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lib.common.Util;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;
import lib.kemi.chem.Chem;
import lib.kemi.readWriteDataFiles.ReadChemSyst;

public class ModifyConfirm
extends JFrame {
    private Dimension windowSize;
    private boolean finished = false;
    private boolean cancel = true;
    private boolean dbg = true;
    private Chem ch = null;
    private Chem.ChemSystem cs = null;
    private Chem.ChemSystem.NamesEtc namn = null;
    private DefaultListModel listSolubleCmplxModel = new DefaultListModel();
    private DefaultListModel listSolidCmplxModel = new DefaultListModel();
    private int compToDelOrExch;
    private boolean delete;
    private static final String nl = System.getProperty("line.separator");
    private JButton jButtonOK;
    private JButton jButtonQuit;
    private JLabel jLabel0;
    private JLabel jLabelName;
    private JLabel jLabelSolidCmplx;
    private JLabel jLabelSolubleCmplx;
    private JLabel jLabelWarning;
    private JList jListSolidCmplx;
    private JList jListSolubCmplx;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelButtons;
    private JPanel jPanelLists;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public ModifyConfirm(Point parentPosition, Chem chem, int compToDelOrExch, int complxToExchange, final ProgramConf pc) {
        if (chem == null) {
            System.err.println("Programming error in ModifyConfirm:  \"ch\" is null.");
            return;
        }
        this.ch = chem;
        this.cs = this.ch.chemSystem;
        this.namn = this.cs.namn;
        if (this.cs == null || this.namn == null) {
            System.err.println("Programming error in ModifyConfirm: either \"cs\" or \"namn\" are null.");
            return;
        }
        if (compToDelOrExch < 0 || compToDelOrExch >= this.cs.Na) {
            System.err.println("Programming error in ModifyConfirm: \"compToDelOrExch\" = " + compToDelOrExch);
            return;
        }
        this.compToDelOrExch = compToDelOrExch;
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.setLocation(parentPosition);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyConfirm.this.quitFrame();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyConfirm.this.setCursor(new Cursor(3));
                String[] a = new String[]{"S_Modify_Chem_System_htm"};
                RunProgr.runProgramInProcess((Component)ModifyConfirm.this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)pc.dbg, (String)pc.pathAPP);
                ModifyConfirm.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyConfirm.this.jButtonOK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        String iconName = "images/Modify_32x32.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn((String)("Error: Could not load image = \"" + iconName + "\""));
        }
        if (complxToExchange >= -1) {
            this.jLabelSolubleCmplx.setText("Soluble complexes:");
            this.jLabelSolidCmplx.setText("Solid products:");
        }
        int complxs = 0;
        for (int i = 0; i < this.cs.nx; ++i) {
            if (!(Math.abs(this.cs.a[i][compToDelOrExch]) > 1.0E-7)) continue;
            this.listSolubleCmplxModel.addElement(this.namn.ident[i + this.cs.Na]);
            ++complxs;
        }
        if (complxs <= 0) {
            this.jLabelSolubleCmplx.setText("No soluble complexes");
            this.jListSolubCmplx.setBackground(Color.lightGray);
        }
        int complexesS = 0;
        for (int is = 0; is < this.cs.mSol - this.cs.solidC; ++is) {
            int i = is + this.cs.nx;
            if (!(Math.abs(this.cs.a[i][compToDelOrExch]) > 1.0E-7)) continue;
            this.listSolidCmplxModel.addElement(this.namn.ident[i + this.cs.Na]);
            ++complexesS;
        }
        if (complexesS <= 0) {
            this.jLabelSolidCmplx.setText("No solid products");
            this.jListSolidCmplx.setBackground(Color.lightGray);
        }
        String comp = this.namn.identC[compToDelOrExch];
        this.jLabelName.setText(comp);
        if (complxToExchange < -1) {
            this.delete = true;
            this.setTitle("Delete \"" + comp + "\"");
            if (this.dbg) {
                System.out.println(" ---- Confirm delete component: \"" + comp + "\"");
            }
            if (complxs <= 0) {
                this.jLabelSolubleCmplx.setText("No soluble complexes removed");
            }
            if (complexesS <= 0) {
                this.jLabelSolidCmplx.setText("No solid products removed");
            }
            if (complxs <= 0 && complexesS <= 0) {
                this.jLabelWarning.setText(" ");
                this.jButtonOK.setText("OK");
            }
            this.jListSolubCmplx.setFocusable(false);
            this.jListSolidCmplx.setFocusable(false);
        } else {
            this.delete = false;
            this.setTitle("Exchange \"" + comp + "\" with a reaction");
            if (this.dbg) {
                System.out.println(" ---- Confirm exchange component \"" + comp + "\" with a reaction");
            }
            this.jLabel0.setText("Exchange chemical component");
            this.jLabelWarning.setText("<html>Select the reaction product to become the<br>component:</html>");
            if (complxToExchange >= 0) {
                int ix;
                String cmplx = this.namn.ident[complxToExchange + this.cs.Na];
                boolean found = false;
                for (ix = 0; ix < this.listSolubleCmplxModel.getSize(); ++ix) {
                    if (!cmplx.equals(this.listSolubleCmplxModel.elementAt(ix).toString())) continue;
                    found = true;
                    this.jListSolubCmplx.setSelectedIndex(ix);
                    this.jListSolubCmplx.ensureIndexIsVisible(ix);
                    break;
                }
                if (!found) {
                    for (ix = 0; ix < this.listSolidCmplxModel.getSize(); ++ix) {
                        if (!cmplx.equals(this.listSolidCmplxModel.elementAt(ix).toString())) continue;
                        this.jListSolidCmplx.setSelectedIndex(ix);
                        this.jListSolidCmplx.ensureIndexIsVisible(ix);
                        break;
                    }
                }
            }
            if (this.listSolubleCmplxModel.getSize() + this.listSolidCmplxModel.getSize() == 1) {
                if (this.listSolubleCmplxModel.getSize() == 1) {
                    this.jListSolubCmplx.setSelectedIndex(0);
                    this.jListSolubCmplx.ensureIndexIsVisible(0);
                } else {
                    this.jListSolidCmplx.setSelectedIndex(0);
                    this.jListSolidCmplx.ensureIndexIsVisible(0);
                }
            }
            this.jButtonOK.setText("OK  do it!");
            iconName = "images/Exchange_32x32.gif";
            imgURL = this.getClass().getResource(iconName);
            if (imgURL != null) {
                this.jButtonOK.setIcon(new ImageIcon(imgURL));
            } else {
                Util.exceptn((String)("Error: Could not load image = \"" + iconName + "\""));
            }
        }
        this.setCursor(new Cursor(0));
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel0 = new JLabel();
        this.jLabelName = new JLabel();
        this.jLabelWarning = new JLabel();
        this.jPanelLists = new JPanel();
        this.jLabelSolubleCmplx = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListSolubCmplx = new JList();
        this.jLabelSolidCmplx = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListSolidCmplx = new JList();
        this.jPanel2 = new JPanel();
        this.jPanelButtons = new JPanel();
        this.jButtonQuit = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(3);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ModifyConfirm.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ModifyConfirm.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel0.setFont(new Font("Dialog", 1, 14));
        this.jLabel0.setForeground(new Color(0, 0, 204));
        this.jLabel0.setText("Delete chemical component:");
        this.jLabelName.setFont(new Font("Dialog", 1, 18));
        this.jLabelName.setText("SO4-2");
        this.jLabelWarning.setFont(new Font("Dialog", 1, 14));
        this.jLabelWarning.setForeground(new Color(0, 0, 204));
        this.jLabelWarning.setText("<html>Will delete the following species<br>as well!</html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel0).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelName))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jLabelWarning)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelWarning, -2, -1, -2)));
        this.jPanelLists.setFont(new Font("Dialog", 0, 11));
        this.jLabelSolubleCmplx.setFont(new Font("Dialog", 1, 12));
        this.jLabelSolubleCmplx.setForeground(new Color(0, 0, 204));
        this.jLabelSolubleCmplx.setText("Soluble complexes removed:");
        this.jScrollPane1.setFont(new Font("Dialog", 0, 11));
        this.jListSolubCmplx.setFont(new Font("Dialog", 0, 11));
        this.jListSolubCmplx.setModel(this.listSolubleCmplxModel);
        this.jListSolubCmplx.setSelectionMode(0);
        this.jListSolubCmplx.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ModifyConfirm.this.jListSolubCmplxValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSolubCmplx);
        this.jLabelSolidCmplx.setFont(new Font("Dialog", 1, 12));
        this.jLabelSolidCmplx.setForeground(new Color(0, 0, 204));
        this.jLabelSolidCmplx.setText("Solid products removed:");
        this.jScrollPane2.setFont(new Font("Dialog", 0, 11));
        this.jListSolidCmplx.setFont(new Font("Dialog", 0, 11));
        this.jListSolidCmplx.setModel(this.listSolidCmplxModel);
        this.jListSolidCmplx.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ModifyConfirm.this.jListSolidCmplxValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListSolidCmplx);
        GroupLayout jPanelListsLayout = new GroupLayout(this.jPanelLists);
        this.jPanelLists.setLayout(jPanelListsLayout);
        jPanelListsLayout.setHorizontalGroup(jPanelListsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelListsLayout.createSequentialGroup().addGroup(jPanelListsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSolubleCmplx).addComponent(this.jLabelSolidCmplx, -1, -1, Short.MAX_VALUE).addGroup(jPanelListsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelListsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 199, -2).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)))).addContainerGap()));
        jPanelListsLayout.setVerticalGroup(jPanelListsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelListsLayout.createSequentialGroup().addComponent(this.jLabelSolubleCmplx).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelSolidCmplx).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 85, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 137, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 82, Short.MAX_VALUE));
        this.jPanelButtons.setFont(new Font("Dialog", 0, 11));
        this.jButtonQuit.setFont(new Font("Dialog", 1, 11));
        this.jButtonQuit.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Quit_32x32.gif")));
        this.jButtonQuit.setMnemonic('Q');
        this.jButtonQuit.setText("<html><u>Q</u>uit</html>");
        this.jButtonQuit.setHorizontalAlignment(10);
        this.jButtonQuit.setIconTextGap(8);
        this.jButtonQuit.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyConfirm.this.jButtonQuitActionPerformed(evt);
            }
        });
        this.jButtonOK.setFont(new Font("Tahoma", 1, 11));
        this.jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Delete_32x32.gif")));
        this.jButtonOK.setMnemonic('O');
        this.jButtonOK.setText("<html><u>O</u>K <br>get rid of them!</html>");
        this.jButtonOK.setHorizontalAlignment(10);
        this.jButtonOK.setIconTextGap(8);
        this.jButtonOK.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyConfirm.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout jPanelButtonsLayout = new GroupLayout(this.jPanelButtons);
        this.jPanelButtons.setLayout(jPanelButtonsLayout);
        jPanelButtonsLayout.setHorizontalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addComponent(this.jButtonQuit, -2, -1, -2).addContainerGap(108, Short.MAX_VALUE)).addComponent(this.jButtonOK, -1, 181, Short.MAX_VALUE));
        jPanelButtonsLayout.setVerticalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addComponent(this.jButtonQuit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonOK, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jPanelLists, -2, 209, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelButtons, -2, -1, -2).addComponent(this.jPanel2, -2, -1, -2)).addGap(10, 10, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelLists, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelButtons, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void jListSolubCmplxValueChanged(ListSelectionEvent evt) {
        this.jListSolidCmplx.clearSelection();
        if (this.delete) {
            this.jListSolubCmplx.clearSelection();
        }
    }

    private void jListSolidCmplxValueChanged(ListSelectionEvent evt) {
        this.jListSolubCmplx.clearSelection();
        if (this.delete) {
            this.jListSolidCmplx.clearSelection();
        }
    }

    private void jButtonQuitActionPerformed(ActionEvent evt) {
        this.quitFrame();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.cancel = false;
        if (this.delete) {
            this.deleteComponent(this.cs, this.compToDelOrExch);
        } else {
            this.exchangeComponent(this.cs, this.compToDelOrExch);
        }
        if (!this.cancel) {
            this.quitFrame();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel = true;
        this.quitFrame();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void quitFrame() {
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized boolean waitForModifyConfirm() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.cancel;
    }

    private void deleteComponent(Chem.ChemSystem cs, int compToDel) {
        int i;
        cs.printChemSystem(null);
        int nxOut = cs.nx;
        for (int i2 = 0; i2 < cs.nx; ++i2) {
            if (!(Math.abs(cs.a[i2][compToDel]) > 1.0E-7)) continue;
            --nxOut;
        }
        int mSolOut = cs.mSol;
        for (int i3 = cs.nx; i3 < cs.Ms - cs.Na - cs.solidC; ++i3) {
            if (!(Math.abs(cs.a[i3][compToDel]) > 1.0E-7)) continue;
            --mSolOut;
        }
        int naOut = cs.Na - 1;
        int solidCout = cs.solidC;
        if (compToDel >= cs.Na - cs.solidC) {
            --solidCout;
            --mSolOut;
        }
        for (i = compToDel; i < naOut; ++i) {
            cs.namn.identC[i] = cs.namn.identC[i + 1];
            cs.namn.ident[i] = cs.namn.ident[i + 1];
        }
        for (i = naOut; i < cs.Ms - 1; ++i) {
            cs.namn.ident[i] = cs.namn.ident[i + 1];
        }
        int count = 0;
        for (int ix = 0; ix < cs.Ms - cs.Na - cs.solidC; ++ix) {
            if (Math.abs(cs.a[ix][compToDel]) > 1.0E-7) {
                ++count;
                continue;
            }
            int ix1 = ix - count;
            cs.namn.ident[ix1 + naOut] = cs.namn.ident[ix + naOut];
            cs.lBeta[ix1] = cs.lBeta[ix];
            for (int ic = 0; ic < naOut; ++ic) {
                cs.a[ix1][ic] = cs.a[ix][ic];
                if (ic < compToDel) continue;
                cs.a[ix1][ic] = cs.a[ix][ic + 1];
            }
        }
        cs.Ms = cs.Ms - (count + (cs.solidC - solidCout)) - 1;
        cs.mSol = mSolOut;
        cs.Na = naOut;
        cs.nx = nxOut;
        cs.solidC = solidCout;
        if (this.dbg) {
            System.out.println(" ---- Component deleted.");
        }
    }

    private void exchangeComponent(Chem.ChemSystem cs, int compToExch) {
        int ic;
        int i_cplx_new;
        int i_comp_new;
        int i;
        int ic2;
        int ix;
        int solidC0 = cs.solidC;
        if (this.jListSolubCmplx.getSelectedIndex() < 0 && this.jListSolidCmplx.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Please, select a species" + nl + "from the list of reaction products", this.getTitle(), 2);
            this.cancel = true;
            return;
        }
        int Ms = cs.Ms;
        int mSol = cs.mSol;
        if (cs.solidC > 0) {
            Ms = cs.Ms - cs.solidC;
            mSol = cs.mSol - cs.solidC;
        }
        int nxOut = cs.nx;
        int mSol_Out = mSol;
        int solidC_out = cs.solidC;
        if (compToExch >= cs.Na - cs.solidC) {
            --solidC_out;
            ++mSol_Out;
        } else {
            ++nxOut;
        }
        String complexExchName = this.jListSolubCmplx.getSelectedIndex() > -1 ? this.jListSolubCmplx.getSelectedValue().toString() : this.jListSolidCmplx.getSelectedValue().toString();
        int complexToExch = -1;
        for (ix = 0; ix < Ms - cs.Na; ++ix) {
            if (!complexExchName.equals(cs.namn.ident[ix + cs.Na])) continue;
            complexToExch = ix;
            break;
        }
        if (complexToExch < 0) {
            System.err.println("Error exchanging \"" + complexExchName + "\"; complexToExch = " + complexToExch);
            this.cancel = true;
            return;
        }
        if (this.dbg) {
            System.out.println("  exchanging component with reaction: \"" + complexExchName + "\"");
        }
        if (complexToExch >= cs.nx) {
            ++solidC_out;
            --mSol_Out;
        } else {
            --nxOut;
        }
        String newCompName = complexExchName;
        String newCmplxName = cs.namn.identC[compToExch];
        double oldLogK = cs.lBeta[complexToExch];
        double a1 = cs.a[complexToExch][compToExch];
        double[] old_a = new double[cs.Na];
        System.arraycopy(cs.a[complexToExch], 0, old_a, 0, cs.Na);
        for (ic2 = compToExch; ic2 < cs.Na - 1; ++ic2) {
            cs.namn.identC[ic2] = cs.namn.identC[ic2 + 1];
            cs.namn.ident[ic2] = cs.namn.ident[ic2 + 1];
        }
        cs.namn.identC[cs.Na - 1] = "** no name **";
        cs.namn.ident[cs.Na - 1] = "** no name **";
        for (ix = complexToExch; ix < cs.nx + mSol - 1; ++ix) {
            cs.namn.ident[ix + cs.Na] = cs.namn.ident[ix + 1 + cs.Na];
            cs.lBeta[ix] = cs.lBeta[ix + 1];
            System.arraycopy(cs.a[ix + 1], 0, cs.a[ix], 0, cs.Na);
        }
        ix = cs.nx + mSol - 1;
        cs.namn.ident[ix + cs.Na] = "** no name **";
        cs.lBeta[ix] = 9999999.0;
        for (ic2 = 0; ic2 < cs.Na; ++ic2) {
            cs.a[ix][ic2] = 0.0;
        }
        if (complexToExch < cs.nx) {
            for (int ic3 = 0; ic3 < cs.Na; ++ic3) {
                i = cs.Na - 1 - ic3;
                if (i <= cs.Na - solidC_out - 1) continue;
                cs.namn.identC[i] = cs.namn.identC[i - 1];
                cs.namn.ident[i] = cs.namn.ident[i - 1];
            }
            i_comp_new = cs.Na - solidC_out - 1;
            cs.namn.identC[i_comp_new] = newCompName;
            cs.namn.ident[i_comp_new] = newCompName;
        } else {
            i_comp_new = cs.Na - 1;
            cs.namn.identC[i_comp_new] = newCompName;
            cs.namn.ident[i_comp_new] = newCompName;
        }
        if (compToExch < cs.Na - cs.solidC) {
            for (ix = 0; ix < cs.nx + mSol; ++ix) {
                i = cs.nx + mSol - 1 - ix;
                if (i <= nxOut - 1) continue;
                cs.namn.ident[i + cs.Na] = cs.namn.ident[i + cs.Na - 1];
                cs.lBeta[i] = cs.lBeta[i - 1];
                System.arraycopy(cs.a[i - 1], 0, cs.a[i], 0, cs.Na);
            }
            i_cplx_new = nxOut - 1;
        } else {
            i_cplx_new = nxOut + mSol_Out - 1;
        }
        cs.namn.ident[i_cplx_new + cs.Na] = newCmplxName;
        cs.lBeta[i_cplx_new] = -oldLogK / a1;
        System.arraycopy(old_a, 0, cs.a[i_cplx_new], 0, cs.Na);
        for (ix = 0; ix < cs.nx + mSol; ++ix) {
            double old_a_x = cs.a[ix][compToExch];
            for (ic = 0; ic < cs.Na - 1; ++ic) {
                if (ic < compToExch) continue;
                cs.a[ix][ic] = cs.a[ix][ic + 1];
            }
            if (complexToExch < cs.nx) {
                for (ic = 0; ic < cs.Na - 1; ++ic) {
                    i = cs.Na - 1 - ic;
                    if (i <= cs.Na - solidC_out - 1) continue;
                    cs.a[ix][i] = cs.a[ix][i - 1];
                }
                cs.a[ix][cs.Na - solidC_out - 1] = old_a_x;
                continue;
            }
            cs.a[ix][cs.Na - 1] = old_a_x;
        }
        for (ic = 0; ic < cs.Na; ++ic) {
            old_a[ic] = cs.a[i_cplx_new][ic];
            cs.a[i_cplx_new][ic] = this.round4(-old_a[ic] / a1);
        }
        cs.a[i_cplx_new][i_comp_new] = this.round4(1.0 / a1);
        for (ix = 0; ix < cs.nx + mSol; ++ix) {
            if (ix == i_cplx_new) continue;
            double a1p = this.round4(-cs.a[ix][i_comp_new] / a1);
            cs.lBeta[ix] = cs.lBeta[ix] + a1p * oldLogK;
            for (int ic4 = 0; ic4 < cs.Na; ++ic4) {
                if (ic4 != i_comp_new) {
                    cs.a[ix][ic4] = this.round4(cs.a[ix][ic4] + a1p * old_a[ic4]);
                    continue;
                }
                cs.a[ix][i_comp_new] = this.round4(-a1p);
            }
        }
        cs.nx = nxOut;
        mSol = mSol_Out;
        cs.solidC = solidC_out;
        if (solidC0 < cs.solidC) {
            Chem.ChemSystem.NamesEtc namnNew;
            Chem.ChemSystem csNew;
            try {
                Chem chem = this.ch;
                chem.getClass();
                csNew = new Chem.ChemSystem(chem, cs.Na, Ms + cs.solidC, mSol + cs.solidC);
            }
            catch (Chem.ChemicalParameterException ex) {
                System.err.println(ex.getMessage());
                return;
            }
            try {
                Chem.ChemSystem chemSystem = csNew;
                chemSystem.getClass();
                namnNew = new Chem.ChemSystem.NamesEtc(chemSystem, cs.Na, Ms + cs.solidC, mSol + cs.solidC);
            }
            catch (Chem.ChemicalParameterException ex) {
                System.err.println(ex.getMessage());
                return;
            }
            csNew.jWater = cs.jWater;
            csNew.chemConcs = cs.chemConcs;
            for (ix = 0; ix < cs.Ms - cs.Na; ++ix) {
                csNew.noll[ix] = cs.noll[ix];
                csNew.lBeta[ix] = cs.lBeta[ix];
                System.arraycopy(cs.a[ix], 0, csNew.a[ix], 0, cs.Na);
            }
            csNew.nx = cs.nx;
            csNew.solidC = cs.solidC;
            System.arraycopy(cs.namn.identC, 0, namnNew.identC, 0, cs.Na);
            for (ix = 0; ix < cs.Ms; ++ix) {
                namnNew.ident[ix] = cs.namn.ident[ix];
                namnNew.nameLength[ix] = cs.namn.nameLength[ix];
            }
            for (ix = 0; ix < cs.namn.iel.length; ++ix) {
                namnNew.iel[ix] = cs.namn.iel[ix];
            }
            for (ix = 0; ix < cs.namn.z.length; ++ix) {
                namnNew.z[ix] = cs.namn.z[ix];
            }
            this.ch.chemSystem = csNew;
            cs.namn = namnNew;
            this.cs = csNew;
            this.namn = namnNew;
            cs = csNew;
            cs.namn = namnNew;
        } else {
            cs.mSol = mSol + cs.solidC;
            cs.Ms = Ms + cs.solidC;
        }
        ReadChemSyst.addFictiveSolids((Chem.ChemSystem)cs);
        if (this.dbg) {
            System.out.println(" ---- Exchange successful.");
        }
    }

    private double round4(double x) {
        if (Double.isNaN(x) || Math.abs(x) > 327.6) {
            return x;
        }
        if (Math.abs(x) < 1.9999999E-4) {
            return 0.0;
        }
        double x100 = x * 100.0;
        double diff = Math.abs(x100 - Math.rint(x100));
        double result = x;
        if (diff < 0.0199999999) {
            result = Math.rint(x100) / 100.0;
        }
        if (Math.abs(x100 / 100.0 - result) > 2.1E-4) {
            System.err.println("Error in \"round4(x)\": x=" + x + " x100=" + x100 + " diff=" + diff + ", result=" + result + "(!?)");
        }
        return result;
    }
}

