/*
 * Decompiled with CFR 0.152.
 */
package lib.huvud;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LicenseFrame
extends JFrame {
    private boolean finished = false;
    private static final String nl = System.getProperty("line.separator");
    private JEditorPane jEditorPane;
    private JScrollPane jScrollPane;

    public LicenseFrame(final JFrame parentFrame) {
        int top;
        int left;
        this.initComponents();
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (parentFrame != null && parentFrame.isVisible()) {
                    parentFrame.requestFocus();
                }
                LicenseFrame.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        this.getRootPane().getActionMap().put("ALT_X", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        this.setTitle(" GNU General Public License");
        String iconName = "images/GNU_32x32.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            System.err.println("Error: Could not load image = \"" + iconName + "\"");
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (parentFrame != null) {
            left = Math.max(0, parentFrame.getX() + parentFrame.getWidth() / 2 - this.getWidth() / 2);
            top = Math.max(0, parentFrame.getY() + parentFrame.getHeight() / 2 - this.getHeight() / 2);
        } else {
            left = Math.max(0, (screenSize.width - this.getWidth()) / 2);
            top = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        }
        this.setLocation(Math.min(screenSize.width - this.getWidth() - 20, left), Math.min(screenSize.height - this.getHeight() - 20, top));
        URL licenseURL = LicenseFrame.class.getResource("GPL.html");
        if (licenseURL != null) {
            try {
                this.jEditorPane.setPage(licenseURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + licenseURL);
            }
        } else {
            System.err.println("Couldn't find file: GPL.html");
            if (parentFrame != null && parentFrame.isVisible()) {
                parentFrame.requestFocus();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LicenseFrame.this.closeWindow();
                }
            });
        }
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LicenseFrame.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane.setFont(new Font("Dialog", 0, 11));
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setFont(new Font("Dialog", 0, 11));
        this.jEditorPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LicenseFrame.this.jEditorPaneKeyPressed(evt);
            }
        });
        this.jScrollPane.setViewportView(this.jEditorPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, -1, 544, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void jEditorPaneKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            evt.consume();
            this.closeWindow();
        }
    }

    public void closeWindow() {
        this.setVisible(false);
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }
}

