/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.qenherkhopeshef.graphics.vectorClipboard.PDFPicture;

public class PDFTransferable
implements Transferable {
    public static final DataFlavor PDF_FLAVOR = new DataFlavor("application/pdf", null);
    private static final DataFlavor[] flavors = new DataFlavor[]{PDF_FLAVOR};
    private PDFPicture pdfPicture;

    public PDFTransferable(PDFPicture pdfPicture) {
        this.pdfPicture = pdfPicture;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (PDF_FLAVOR.equals(flavor)) {
            return new ByteArrayInputStream(this.pdfPicture.getByteArray());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

