/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.FrameDBmain;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lib.common.Util;
import lib.database.Complex;
import lib.database.LibDB;
import lib.database.ProgramDataDB;
import lib.huvud.ProgramConf;

public class DBSearch {
    ArrayList<Complex> dat = new ArrayList();
    double temperature = 25.0;
    double pressure = 1.0;
    int na;
    int nx;
    int nf;
    int solidC;
    private ProgramConf pc;
    private ProgramDataDB pd;
    private FrameDBmain dbF;
    private int db;
    private String complxFileName;
    private long complxFileNameSize;
    private long cmplxNbr = 0L;
    private final double SIZE_FACTOR_TXT = 54.675;
    private final double SIZE_FACTOR_BIN = 124.929;
    private DataInputStream dis;
    private BufferedReader br;
    private boolean redox;
    private int nLoops;
    private int binaryOrText = 0;
    private ArrayList<String> selectedComps = new ArrayList();
    private ArrayList<String> comps_X = new ArrayList();
    private ArrayList<String> comps = new ArrayList();
    private ArrayList<Complex> rRedox = new ArrayList();
    private boolean openNextFile = true;
    private boolean noFilesFound = true;
    private static final String nl = System.getProperty("line.separator");

    public DBSearch(ProgramConf programConf, ProgramDataDB programData) throws SearchException {
        if (programConf == null) {
            throw new SearchException("Error: programConf = null in \"DBSearch\" constructor");
        }
        this.pc = programConf;
        if (programData == null) {
            throw new SearchException("Error: programDataDB = null in \"DBSearch\" constructor");
        }
        this.pd = programData;
        this.temperature = this.pd.temperature;
    }

    void searchComplexes(FrameDBmain mainFrame) throws SearchException {
        boolean found;
        if (mainFrame == null) {
            Util.exceptn("Error: mainFrame = null in \"searchComplexes\"");
            throw new SearchException();
        }
        this.dbF = mainFrame;
        if (this.dbF.modelSelectedComps.size() <= 0) {
            Util.exceptn("Error: modelSelectedComps.size() <=0 in \"searchComplexes\"");
            throw new SearchException();
        }
        if (this.pd.dataBasesList.size() <= 0) {
            Util.exceptn("Error: dataBasesList.size() <=0 in \"searchComplexes\"");
            throw new SearchException();
        }
        if (this.pc.dbg) {
            System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -" + nl + "--- Searching reactions");
        }
        try {
            int i;
            this.nx = 0;
            this.nf = 0;
            this.binaryOrText = 0;
            this.nLoops = 1;
            for (i = 0; i < this.dbF.modelSelectedComps.size(); ++i) {
                this.selectedComps.add(this.dbF.modelSelectedComps.get(i).toString());
            }
            this.redox = this.isComponentSelected("e-");
            this.na = this.selectedComps.size();
            this.solidC = 0;
            for (i = 0; i < this.na; ++i) {
                if (!Util.isSolid(this.selectedComps.get(i))) continue;
                ++this.solidC;
            }
            if (this.dbF.solidSelectedComps != this.solidC) {
                Util.exceptn("Error in \"searchComplexes\":" + nl + "the number of solid components does not match!");
            }
            this.redoxChecks();
            if (this.redox) {
                for (int i2 = 0; i2 < this.selectedComps.size(); ++i2) {
                    String selCompName = this.selectedComps.get(i2).toString();
                    for (int k0 = 0; k0 < this.pd.elemComp.size(); ++k0) {
                        String[] elemComp = (String[])this.pd.elemComp.get(k0);
                        if (!Util.nameCompare(elemComp[1], selCompName)) continue;
                        String el = elemComp[0];
                        for (int k1 = 0; k1 < this.pd.elemComp.size(); ++k1) {
                            int j;
                            elemComp = (String[])this.pd.elemComp.get(k1);
                            if (!elemComp[0].equals(el) || k1 == k0) continue;
                            boolean excluded = false;
                            if (el.equals("N") && !this.pd.redoxN || el.equals("S") && !this.pd.redoxS || el.equals("P") && !this.pd.redoxP) {
                                excluded = true;
                            }
                            if (!excluded) {
                                found = false;
                                if (this.comps.size() > 0) {
                                    for (j = 0; j < this.comps.size(); ++j) {
                                        if (!Util.nameCompare(elemComp[1], this.comps.get(j))) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                if (found) continue;
                                this.comps.add(elemComp[1]);
                                continue;
                            }
                            found = false;
                            if (this.comps_X.size() > 0) {
                                for (j = 0; j < this.comps_X.size(); ++j) {
                                    if (!Util.nameCompare(elemComp[1], this.comps_X.get(j))) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            this.comps_X.add(elemComp[1]);
                        }
                    }
                }
                if (this.pc.dbg) {
                    int j;
                    int n = this.comps.size();
                    System.out.println("--- Possible new redox components:" + nl + "  comps[] size:" + n);
                    for (j = 0; j < n; ++j) {
                        System.out.println("    " + this.comps.get(j));
                    }
                    n = this.comps_X.size();
                    System.out.println("  comps_X[] size:" + n);
                    for (j = 0; j < n; ++j) {
                        System.out.println("    " + this.comps_X.get(j));
                    }
                    if (this.comps.size() > 0 || n > 0) {
                        System.out.println("---");
                    }
                }
            }
        }
        catch (SearchInternalException ex) {
            String msg = "Error in \"searchComplexes\":" + nl + Util.stack2string(ex);
            if (!(ex instanceof SearchInternalException)) {
                Util.showErrMsg(this.dbF, msg, 1);
            }
            throw new SearchException(msg);
        }
        while (true) {
            try {
                this.scanDataBases();
            }
            catch (SearchInternalException ex) {
                if (!(ex instanceof SearchInternalException)) {
                    String msg = "Error in \"searchComplexes\":" + nl + Util.stack2string(ex);
                    throw new SearchException(msg);
                }
                throw new SearchException(ex.getMessage());
            }
            if (!this.redox) {
                if (this.pc.dbg) {
                    System.out.println("--- Search reactions ended.");
                }
                return;
            }
            int n_selectedComps_0 = this.selectedComps.size();
            for (int i = 0; i < this.dat.size(); ++i) {
                if (!Complex.isRedox((Complex)this.dat.get(i))) continue;
                found = false;
                String t1 = this.dat.get((int)i).name;
                block15: for (int j = 0; j < this.comps.size(); ++j) {
                    if (!Util.nameCompare(t1, this.comps.get(j))) continue;
                    found = true;
                    for (int k = 0; k < this.selectedComps.size(); ++k) {
                        if (!Util.nameCompare(t1, this.selectedComps.get(k))) continue;
                        found = false;
                        break block15;
                    }
                    break;
                }
                if (!found) continue;
                this.selectedComps.add(t1);
                this.rRedox.add(this.dat.get(i));
            }
            if (n_selectedComps_0 == this.selectedComps.size()) break;
            ++this.nLoops;
        }
        if (this.rRedox.size() > 0) {
            for (int i = 0; i < this.dat.size(); ++i) {
                boolean needsMore;
                Complex cplx = this.dat.get(i);
                do {
                    needsMore = false;
                    block19: for (int ic = 0; ic < 6; ++ic) {
                        int ic2;
                        int fnd;
                        double n2;
                        String lComp2;
                        String lComp = cplx.component[ic];
                        if (lComp == null || lComp.length() <= 0) continue;
                        double n1 = cplx.numcomp[ic];
                        double np = cplx.proton;
                        int rdxC = -1;
                        for (int ir = 0; ir < this.rRedox.size(); ++ir) {
                            if (!Util.nameCompare(this.rRedox.get((int)ir).name, lComp)) continue;
                            rdxC = ir;
                            break;
                        }
                        if (rdxC <= -1) continue;
                        needsMore = true;
                        cplx.constant += n1 * this.rRedox.get((int)rdxC).constant;
                        cplx.deltH += n1 * this.rRedox.get((int)rdxC).deltH;
                        cplx.component[ic] = "";
                        cplx.numcomp[ic] = 0.0;
                        boolean hPresent = false;
                        for (int irr = 0; irr < 6; ++irr) {
                            int ic22;
                            lComp2 = this.rRedox.get((int)rdxC).component[irr];
                            if (lComp2 == null || lComp2.length() <= 0) continue;
                            n2 = this.rRedox.get((int)rdxC).numcomp[irr];
                            fnd = -1;
                            for (ic22 = 0; ic22 < 6; ++ic22) {
                                if (!Util.nameCompare(cplx.component[ic22], lComp2)) continue;
                                fnd = ic22;
                                cplx.numcomp[ic22] = cplx.numcomp[ic22] + n1 * n2;
                                break;
                            }
                            if (fnd < 0) {
                                for (ic22 = 0; ic22 < 6; ++ic22) {
                                    if (cplx.component[ic22].length() > 0) continue;
                                    fnd = ic22;
                                    cplx.component[ic22] = lComp2;
                                    if (Util.isProton(lComp2)) {
                                        cplx.numcomp[ic22] = np + n1 * n2;
                                        break;
                                    }
                                    cplx.numcomp[ic22] = n1 * n2;
                                    break;
                                }
                            }
                            if (Util.isProton(lComp2)) {
                                hPresent = true;
                                cplx.proton = np + n1 * n2;
                                continue;
                            }
                            if (fnd >= 0) continue;
                            String msg = "Internal program error." + nl + nl + "Species \"" + cplx.name + "\", component \"" + lComp + "\"" + nl + "correcting for \"" + lComp2 + "\"" + nl + nl + "Please report this to the author of this software.";
                            throw new SearchException(msg);
                        }
                        n2 = this.rRedox.get((int)rdxC).proton;
                        if (hPresent || !(Math.abs(n2) > 0.001)) continue;
                        lComp2 = "H+";
                        fnd = -1;
                        for (ic2 = 0; ic2 < 6; ++ic2) {
                            if (!cplx.component[ic2].equals(lComp2)) continue;
                            fnd = ic2;
                            cplx.numcomp[ic2] = cplx.numcomp[ic2] + n1 * n2;
                            break;
                        }
                        cplx.proton += n1 * n2;
                        if (fnd >= 0) continue;
                        for (ic2 = 0; ic2 < 6; ++ic2) {
                            if (cplx.component[ic2].length() > 0) continue;
                            cplx.component[ic2] = lComp2;
                            cplx.numcomp[ic2] = cplx.proton;
                            continue block19;
                        }
                    }
                } while (needsMore);
            }
        }
        if (this.pc.dbg) {
            System.out.println("--- Search reactions ended.");
        }
    }

    private void scanDataBases() throws SearchInternalException {
        Complex rr;
        if (this.pc.dbg) {
            System.out.println("--- \"scanDataBases\", nLoops = " + this.nLoops + ",  Selected components:");
            for (int i = 0; i < this.selectedComps.size(); ++i) {
                System.out.println("    " + this.selectedComps.get(i));
            }
            System.out.println("---");
        }
        boolean firstComplex = true;
        this.complxFileName = "";
        int nSelectedComps = this.selectedComps.size();
        while ((rr = this.getOneComplex(firstComplex)) != null) {
            if (rr.name.length() > 0) {
                int j;
                boolean found;
                int i;
                if (this.binaryOrText == 1 && this.nLoops == 1) {
                    String msg = Complex.checkComplex((Complex)rr);
                    for (i = 0; i < 6; ++i) {
                        if (rr.component[i] == null || rr.component[i].length() <= 0) continue;
                        found = false;
                        for (j = 0; j < this.pd.elemComp.size(); ++j) {
                            String[] elemComp = (String[])this.pd.elemComp.get(j);
                            if (!Util.nameCompare(rr.component[i], elemComp[1])) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        String t = "Component \"" + rr.component[i] + "\" in complex \"" + rr.name + "\"" + nl + "not found in the element-files.";
                        msg = msg.length() > 0 ? msg + nl + t : t;
                    }
                    if (msg != null) {
                        System.out.println("---- Error \"" + msg + "\"" + nl + "      for complex \"" + rr.name + "\", logK=" + rr.constant + ", ref.=\"" + rr.reference + "\"");
                        for (i = 0; i < 6; ++i) {
                            System.out.print(" " + rr.component[i] + " " + rr.numcomp[i] + ";");
                        }
                        System.out.println();
                        Object[] opt = new Object[]{"OK", "Cancel"};
                        int answer = JOptionPane.showOptionDialog(this.dbF, "Error in file \"" + this.complxFileName + "\"" + nl + "\"" + msg + "\"", this.pc.progName, 0, 2, null, opt, opt[1]);
                        if (answer != 0) {
                            try {
                                if (this.binaryOrText == 2 && this.dis != null) {
                                    this.dis.close();
                                } else if (this.binaryOrText == 1 && this.br != null) {
                                    this.br.close();
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            throw new SearchInternalException();
                        }
                    }
                }
                if (!rr.name.startsWith("@")) {
                    boolean include = true;
                    if (this.redox) {
                        boolean ePresent = false;
                        for (int ic = 0; ic < 6; ++ic) {
                            if (!Util.isElectron(rr.component[ic])) continue;
                            ePresent = true;
                            break;
                        }
                        if (ePresent) {
                            for (j = 0; j < this.comps_X.size(); ++j) {
                                if (!Util.nameCompare(rr.name, this.comps_X.get(j))) continue;
                                include = false;
                                break;
                            }
                            if (include) {
                                found = false;
                                for (int k = 0; k < this.selectedComps.size(); ++k) {
                                    if (!Util.nameCompare(rr.name, this.selectedComps.get(k).toString())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) {
                                    if (this.pc.dbg) {
                                        System.out.println("Complex already there (it was one of the components): " + rr.name);
                                    }
                                    include = false;
                                    for (i = 0; i < this.rRedox.size(); ++i) {
                                        if (!Complex.sameNameAndStoichiometry((Complex)rr, (Complex)this.rRedox.get(i))) continue;
                                        if (this.pc.dbg) {
                                            System.out.println("Complex already there and same stoichiometry: " + rr.name);
                                        }
                                        this.rRedox.set(i, rr);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (include) {
                        found = false;
                        for (i = 0; i < this.dat.size(); ++i) {
                            if (!Util.nameCompare(rr.name, this.dat.get((int)i).name)) continue;
                            this.dat.set(i, rr);
                            found = true;
                            break;
                        }
                        if (!found) {
                            boolean excludeSolid = true;
                            if (!Util.is_cr_or_c_solid(rr.name) || this.pd.allSolids == 0 || Util.is_cr_solid(rr.name) && this.pd.allSolids != 1 && this.pd.allSolids != 3 || Util.is_c_solid(rr.name) && this.pd.allSolids < 2) {
                                excludeSolid = false;
                            }
                            if (excludeSolid) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((DBSearch)DBSearch.this).dbF.jLabel_cr_solids.setText("(cr) solids excluded!");
                                    }
                                });
                            } else if (Util.isSolid(rr.name)) {
                                this.dat.add(rr);
                                ++this.nf;
                            } else {
                                this.dat.add(this.nx, rr);
                                ++this.nx;
                            }
                        }
                    }
                } else {
                    rr.name = rr.name.substring(1);
                    if (this.nx + this.nf > 0) {
                        i = 0;
                        do {
                            if (Util.nameCompare(this.dat.get((int)i).name, rr.name)) {
                                this.dat.remove(i);
                                if (i < this.nx) {
                                    --this.nx;
                                    continue;
                                }
                                --this.nf;
                                continue;
                            }
                            ++i;
                        } while (i < this.nx + this.nf);
                    }
                    if (this.redox) {
                        int fnd = -1;
                        for (j = this.dbF.modelSelectedComps.size(); j < nSelectedComps; ++j) {
                            if (!Util.nameCompare(rr.name, this.selectedComps.get(j))) continue;
                            fnd = j;
                            break;
                        }
                        if (fnd > -1) {
                            this.selectedComps.remove(fnd);
                            --nSelectedComps;
                            for (j = 0; j < this.rRedox.size(); ++j) {
                                if (!Util.nameCompare(rr.name, this.rRedox.get(j).toString())) continue;
                                this.rRedox.remove(j);
                                break;
                            }
                            if (this.nx + this.nf > 0) {
                                i = 0;
                                do {
                                    found = false;
                                    for (int ic = 0; ic < 6; ++ic) {
                                        if (!Util.nameCompare(this.dat.get((int)i).component[ic], rr.name)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) {
                                        this.dat.remove(i);
                                        if (i < this.nx) {
                                            --this.nx;
                                            continue;
                                        }
                                        --this.nf;
                                        continue;
                                    }
                                    ++i;
                                } while (i < this.nx + this.nf);
                            }
                        }
                    }
                }
            }
            if (this.binaryOrText == 0) break;
            firstComplex = false;
        }
        try {
            if (this.binaryOrText == 2 && this.dis != null) {
                this.dis.close();
            } else if (this.binaryOrText == 1 && this.br != null) {
                this.br.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.dbF.updateProgressBarLabel(" ", 0);
        this.dbF.updateProgressBar(0);
    }

    private Complex getOneComplex(boolean firstComplex) throws SearchInternalException {
        if (firstComplex) {
            this.openNextFile = true;
            this.db = 0;
        }
        while (this.db < this.pd.dataBasesList.size()) {
            block42: {
                if (this.openNextFile) {
                    try {
                        if (this.dis != null) {
                            this.dis.close();
                        } else if (this.br != null) {
                            this.br.close();
                        }
                    }
                    catch (IOException ioe) {
                        Util.msg(ioe.getMessage());
                    }
                    this.complxFileName = (String)this.pd.dataBasesList.get(this.db);
                    if (this.complxFileName == null || this.complxFileName.length() <= 0) continue;
                    File dbf = new File(this.complxFileName);
                    if (!dbf.exists() || !dbf.canRead()) {
                        String msg = "Error: can not open file" + nl + "    \"" + this.complxFileName + "\".";
                        if (!dbf.exists()) {
                            msg = msg + nl + "(the file does not exist)." + nl + "Search terminated";
                        }
                        throw new SearchInternalException(msg);
                    }
                    this.complxFileNameSize = dbf.length();
                    this.cmplxNbr = 0L;
                    this.dbF.updateProgressBarLabel("Searching \"" + this.complxFileName + "\"", this.nLoops);
                    this.dbF.updateProgressBar(0);
                    try {
                        if (this.binaryOrText == 2 && this.dis != null) {
                            this.dis.close();
                        } else if (this.binaryOrText == 1 && this.br != null) {
                            this.br.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        if (this.complxFileName.toLowerCase().endsWith("db")) {
                            this.binaryOrText = 2;
                            this.dis = new DataInputStream(new FileInputStream(dbf));
                        } else {
                            this.binaryOrText = 1;
                            this.br = new BufferedReader(new FileReader(dbf));
                        }
                    }
                    catch (FileNotFoundException ex) {
                        try {
                            if (this.dis != null) {
                                this.dis.close();
                            } else if (this.br != null) {
                                this.br.close();
                            }
                        }
                        catch (IOException ioe) {
                            Util.msg(ioe.getMessage());
                        }
                        String msg = "Error: " + ex.toString() + nl + "while trying to open file: \"" + this.complxFileName + "\"." + nl + "search terminated";
                        throw new SearchInternalException(msg);
                    }
                    this.noFilesFound = false;
                    this.openNextFile = false;
                    if (this.pc.dbg) {
                        System.out.println("Scanning database \"" + this.complxFileName + "\"");
                    }
                }
                Complex complex = null;
                block17: while (true) {
                    ++this.cmplxNbr;
                    if (this.binaryOrText == 2) {
                        try {
                            complex = LibDB.getBinComplex((DataInputStream)this.dis);
                            this.dbF.updateProgressBar((int)(100.0 * (double)this.cmplxNbr * 124.929 / (double)this.complxFileNameSize));
                        }
                        catch (LibDB.ReadBinCmplxException ex) {
                            String msg = "Error: in \"getOneComplex\", cmplxNbr = " + this.cmplxNbr + nl + "ReadBinCmplxException: " + ex.getMessage() + nl + "in file: \"" + this.complxFileName + "\"";
                            throw new SearchInternalException(msg);
                        }
                    }
                    if (this.binaryOrText == 1) {
                        try {
                            try {
                                complex = LibDB.getTxtComplex((BufferedReader)this.br);
                                this.dbF.updateProgressBar((int)(100.0 * (double)this.cmplxNbr * 54.675 / (double)this.complxFileNameSize));
                            }
                            catch (LibDB.EndOfFileException ex) {
                                complex = null;
                            }
                        }
                        catch (LibDB.ReadTxtCmplxException ex) {
                            String msg = "Error: in \"getOneComplex\", cmplxNbr = " + this.cmplxNbr + nl + ex.getMessage() + nl + "in file: \"" + this.complxFileName + "\"";
                            throw new SearchInternalException(msg);
                        }
                    }
                    if (complex == null || complex.name == null) break block42;
                    if (complex.name.startsWith("@")) {
                        return complex;
                    }
                    boolean protonPresent = false;
                    for (int i = 0; i < 6; ++i) {
                        if (complex.component[i].length() <= 0 || Util.isWater(complex.component[i])) continue;
                        if (!this.isComponentSelected(complex.component[i]) && Math.abs(complex.numcomp[i]) > 0.001) continue block17;
                        if (!Util.isProton(complex.component[i])) continue;
                        protonPresent = true;
                    }
                    if (protonPresent || !(Math.abs(complex.proton) > 0.001) || this.isComponentSelected("H+") || this.isComponentSelected("H +")) break;
                }
                return complex;
            }
            ++this.db;
            this.openNextFile = true;
        }
        if (this.noFilesFound) {
            Util.exceptn("Error: none of the databases could be found.");
            throw new SearchInternalException();
        }
        try {
            if (this.dis != null) {
                this.dis.close();
            } else if (this.br != null) {
                this.br.close();
            }
        }
        catch (IOException ioe) {
            Util.msg(ioe.getMessage());
        }
        this.binaryOrText = 0;
        return null;
    }

    private boolean isComponentSelected(String component) {
        for (int i = 0; i < this.selectedComps.size(); ++i) {
            if (!Util.nameCompare(component, this.selectedComps.get(i))) continue;
            return true;
        }
        return false;
    }

    static boolean isRedox(String element, String component) {
        String end;
        StringBuilder comp = new StringBuilder(component);
        int i = component.indexOf(element);
        if (i < 0) {
            return false;
        }
        if (comp.length() >= 2 && (comp.charAt(0) == '*' || comp.charAt(0) == '@')) {
            comp.delete(0, 1);
        }
        if (comp.length() >= 4 && ((end = comp.substring(comp.length() - 3, comp.length())).equalsIgnoreCase("(c)") || end.equalsIgnoreCase("(s)") || end.equalsIgnoreCase("(l)") || end.equalsIgnoreCase("(g)"))) {
            comp.delete(comp.length() - 3, comp.length());
        }
        if (comp.length() >= 5 && ((end = comp.substring(comp.length() - 4, comp.length())).equalsIgnoreCase("(cr)") || end.equalsIgnoreCase("(am)") || end.equalsIgnoreCase("(aq)"))) {
            comp.delete(comp.length() - 3, comp.length());
        }
        if (comp.length() >= 6 && (end = comp.substring(comp.length() - 5, comp.length())).equalsIgnoreCase("(vit)")) {
            comp.delete(comp.length() - 3, comp.length());
        }
        i = 0;
        while (i < comp.length()) {
            if (comp.charAt(i) >= '0' && comp.charAt(i) <= '9' || comp.charAt(i) == '+' || comp.charAt(i) == '-' || comp.charAt(i) == '\u2013' || comp.charAt(i) == '\u2212' || comp.charAt(i) == '.' || comp.charAt(i) == ';' || comp.charAt(i) == ',' || comp.charAt(i) == '(' || comp.charAt(i) == ')' || comp.charAt(i) == '[' || comp.charAt(i) == ']' || comp.charAt(i) == '{' || comp.charAt(i) == '}') {
                comp.delete(i, i + 1);
                continue;
            }
            ++i;
        }
        while ((i = comp.indexOf(element)) >= 0) {
            comp.delete(i, i + element.length());
        }
        while ((i = comp.indexOf("O")) >= 0) {
            comp.delete(i, i + 1);
        }
        while ((i = comp.indexOf("H")) >= 0) {
            comp.delete(i, i + 1);
        }
        i = 0;
        while (i < comp.length()) {
            if (Character.isWhitespace(comp.charAt(i))) {
                comp.delete(i, i + 1);
                continue;
            }
            ++i;
        }
        return comp.length() <= 0;
    }

    private void redoxChecks() throws SearchInternalException {
        if (this.pc.dbg) {
            System.out.println("--- \"redoxChecks\".  redox = " + this.redox);
        }
        block0: for (int i = 0; i < this.selectedComps.size(); ++i) {
            String selCompName = this.selectedComps.get(i).toString();
            for (int k0 = 0; k0 < this.pd.elemComp.size(); ++k0) {
                String[] elemComp = (String[])this.pd.elemComp.get(k0);
                if (!Util.nameCompare(elemComp[1], selCompName)) continue;
                String el = elemComp[0];
                if (!DBSearch.isRedox(el, selCompName) || (!this.pd.redoxAsk || this.redox) && (el.equals("N") && !this.pd.redoxN || el.equals("P") && !this.pd.redoxP || el.equals("S") && !this.pd.redoxS)) continue block0;
                for (int k1 = 0; k1 < this.pd.elemComp.size(); ++k1) {
                    elemComp = (String[])this.pd.elemComp.get(k1);
                    if (!elemComp[0].equals(el) || Util.nameCompare(elemComp[1], selCompName) || !DBSearch.isRedox(el, elemComp[1])) continue;
                    for (int k2 = i; k2 < this.selectedComps.size(); ++k2) {
                        Object[] opt;
                        if (!Util.nameCompare(elemComp[1], this.selectedComps.get(k2).toString())) continue;
                        String msg = "Warning!" + nl + "You selected two components for the same element:" + "  \"" + selCompName + "\" and \"" + elemComp[1] + "\"" + nl + "They are probably related by redox reactions." + nl;
                        msg = this.redox ? msg + "You should remove one of these components." : msg + "You should instead select \"e-\" as a component and remove either " + "\"" + selCompName + "\" or \"" + elemComp[1] + "\".";
                        int answer = JOptionPane.showOptionDialog(this.dbF, msg = msg + nl + "The calculations will then determine their respective concentrations." + nl + nl + "Are you sure that you want to continue ?", this.pc.progName, 0, 2, null, opt = new Object[]{"Continue", "Cancel"}, opt[1]);
                        if (answer == 0) continue;
                        throw new SearchInternalException();
                    }
                }
            }
        }
        if (this.pc.dbg) {
            System.out.println("Checks ok.");
        }
    }

    private class SearchInternalException
    extends Exception {
        public SearchInternalException() {
        }

        public SearchInternalException(String txt) {
            super(txt);
        }
    }

    class SearchException
    extends Exception {
        public SearchException() {
        }

        public SearchException(String txt) {
            super(txt);
        }
    }
}

