/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.interpolate;

public class Interpolate {
    private static final String nl = System.getProperty("line.separator");

    public static float rationalInterpolation(float[] xTable, float[] yTable, float x) throws RationalInterpolationException {
        int nTable = xTable.length;
        if (nTable < 2) {
            throw new RationalInterpolationException("Error in \"rationalInterpolation\"; length of array < 2.");
        }
        if (yTable.length != nTable) {
            throw new RationalInterpolationException("Error in \"rationalInterpolation\"; length of arrays are not equal.");
        }
        boolean unsorted = false;
        for (int i = 1; i < nTable; ++i) {
            if (!(xTable[i] < xTable[i - 1])) continue;
            unsorted = true;
            break;
        }
        if (unsorted) {
            throw new RationalInterpolationException("Error in \"rationalInterpolation\"; x-values not in ascending order.");
        }
        if (x > xTable[nTable - 1] || x < xTable[0]) {
            throw new RationalInterpolationException("Error in \"rationalInterpolation\"; x = " + x + nl + "   is outside interpolation range.");
        }
        int nClose = 0;
        float delta = Math.abs(x - xTable[0]);
        for (int i = 0; i < nTable; ++i) {
            float dist = Math.abs(x - xTable[i]);
            if (dist <= 0.0f) {
                float y = yTable[i];
                return y;
            }
            if (!(dist < delta)) continue;
            nClose = i;
            delta = dist;
        }
        int n = Math.min(7, nTable);
        int nStart = 0;
        if (nTable > 7) {
            int nEnd;
            nStart = nClose - 3;
            if (nStart < 0) {
                nStart = 0;
            }
            if ((nEnd = nStart + 6) >= nTable) {
                nStart = nTable - 7;
            }
        }
        float[] xRatInt = new float[n];
        float[] yRatInt = new float[n];
        System.arraycopy(xTable, nStart, xRatInt, 0, n);
        System.arraycopy(yTable, nStart, yRatInt, 0, n);
        float y = Interpolate.ratInt(xRatInt, yRatInt, x);
        return y;
    }

    private static float ratInt(float[] xTable, float[] yTable, float x) throws RationalInterpolationException {
        float dist;
        int nTable = xTable.length;
        if (nTable <= 0) {
            throw new RationalInterpolationException("Error in \"Interpolate.ratInt\": length of x-array <=0.");
        }
        if (yTable.length != nTable) {
            throw new RationalInterpolationException("Error in \"Interpolate.ratInt\": length of arrays unequal.");
        }
        float tiny = 1.0E-25f;
        float[] c = new float[nTable];
        float[] d = new float[nTable];
        float delta = Math.abs(x - xTable[0]);
        int nClose = 0;
        for (int i = 0; i < nTable; ++i) {
            dist = Math.abs(x - xTable[i]);
            if (dist <= 0.0f) {
                float y = yTable[i];
                return y;
            }
            if (dist < delta) {
                nClose = i;
                delta = dist;
            }
            c[i] = yTable[i];
            d[i] = yTable[i] + tiny;
        }
        float y = yTable[nClose];
        --nClose;
        for (int m = 1; m < nTable; ++m) {
            float yErr;
            for (int i = 0; i < nTable - m; ++i) {
                dist = xTable[i + m] - x;
                float t = (xTable[i] - x) * d[i] / dist;
                delta = t - c[i + 1];
                if (delta == 0.0f) {
                    throw new RationalInterpolationException("Error in \"Interpolate.ratInt\":" + nl + "   Pole at the requested value of x=" + x);
                }
                delta = (c[i + 1] - d[i]) / delta;
                d[i] = c[i + 1] * delta;
                c[i] = t * delta;
            }
            if (2 * nClose < nTable - m) {
                yErr = c[nClose + 1];
            } else {
                yErr = d[nClose];
                --nClose;
            }
            y += yErr;
        }
        return y;
    }

    public static class RationalInterpolationException
    extends Exception {
        public RationalInterpolationException() {
        }

        public RationalInterpolationException(String txt) {
            super(txt);
        }
    }
}

