/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.wmf;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.qenherkhopeshef.graphics.generic.RandomAccessFileAdapter;
import org.qenherkhopeshef.graphics.generic.RandomAccessStream;
import org.qenherkhopeshef.graphics.generic.RandomAccessStreamUtils;
import org.qenherkhopeshef.graphics.wmf.WMFConstants;
import org.qenherkhopeshef.graphics.wmf.WMFFunctionCodes;
import org.qenherkhopeshef.graphics.wmf.WMFPen;
import org.qenherkhopeshef.graphics.wmf.WMFPoint;

public class WMFDeviceContext
implements WMFFunctionCodes,
WMFConstants {
    private WindowsMetaHeader head;
    private PlaceableMetaHeader meta;
    private ArrayList objects;
    private RandomAccessStream out;

    public WMFDeviceContext(RandomAccessStream stream, Dimension2D dims) throws IOException {
        this(stream, dims.getWidth(), dims.getHeight());
    }

    public WMFDeviceContext(RandomAccessStream stream, double width, double height) throws IOException {
        this.initLowLevelGraphics(stream, (int)Math.ceil(width), (int)Math.ceil(height));
    }

    private void addCommand(short func) throws IOException {
        this.addRecord(func, 0);
    }

    private void addCommandABCD(short func, short a, short b, short c, short d) throws IOException {
        this.addRecord(func, 4);
        RandomAccessStreamUtils.writeS16(this.out, d);
        RandomAccessStreamUtils.writeS16(this.out, c);
        RandomAccessStreamUtils.writeS16(this.out, b);
        RandomAccessStreamUtils.writeS16(this.out, a);
    }

    private void addCommandL(short func, long x) throws IOException {
        this.addRecord(func, 2);
        RandomAccessStreamUtils.writeS32(this.out, x);
    }

    private void addCommandLINES(short func, WMFPoint[] p, short nbr) throws IOException {
        this.addRecord(func, 2 * nbr + 1);
        RandomAccessStreamUtils.writeS16(this.out, (short)nbr);
        for (int i = 0; i < nbr; ++i) {
            RandomAccessStreamUtils.writeS16(this.out, p[i].x);
            RandomAccessStreamUtils.writeS16(this.out, p[i].y);
        }
    }

    private void addCommandX(short func, short x) throws IOException {
        this.addRecord(func, 1);
        RandomAccessStreamUtils.writeS16(this.out, x);
    }

    private void addCommandXY(short func, short x, short y) throws IOException {
        this.addRecord(func, 2);
        RandomAccessStreamUtils.writeS16(this.out, y);
        RandomAccessStreamUtils.writeS16(this.out, x);
    }

    private void addCommandXYL(short func, short a, short b, long c) throws IOException {
        this.addRecord(func, 4);
        RandomAccessStreamUtils.writeS32(this.out, c);
        RandomAccessStreamUtils.writeS16(this.out, b);
        RandomAccessStreamUtils.writeS16(this.out, a);
    }

    private void addRecord(short function, int nbrshorts) throws IOException {
        int size = 3 + nbrshorts;
        this.head.NumOfObjects = (short)(this.head.NumOfObjects + 1);
        if (this.head.MaxRecordSize < (long)size) {
            this.head.MaxRecordSize = size;
        }
        this.head.FileSize += (long)size;
        RandomAccessStreamUtils.writeS32(this.out, size);
        RandomAccessStreamUtils.writeS16(this.out, function);
    }

    private short allocObject() {
        short result;
        int i;
        for (i = 0; i < this.objects.size() && ((Boolean)this.objects.get(i)).booleanValue(); ++i) {
        }
        if (i == this.objects.size()) {
            result = (short)i;
            this.objects.add(Boolean.TRUE);
        } else {
            result = (short)i;
            this.objects.set(i, Boolean.TRUE);
        }
        return result;
    }

    public void arc(short left, short top, short right, short bottom, short xstart, short ystart, short xend, short yend) throws IOException {
        this.addRecord((short)2071, 8);
        RandomAccessStreamUtils.writeS16(this.out, yend);
        RandomAccessStreamUtils.writeS16(this.out, xend);
        RandomAccessStreamUtils.writeS16(this.out, ystart);
        RandomAccessStreamUtils.writeS16(this.out, xstart);
        RandomAccessStreamUtils.writeS16(this.out, bottom);
        RandomAccessStreamUtils.writeS16(this.out, right);
        RandomAccessStreamUtils.writeS16(this.out, top);
        RandomAccessStreamUtils.writeS16(this.out, left);
    }

    public void close() throws IOException {
        this.addCommand((short)0);
        this.out.seek(0);
        this.writeHEADER();
        this.out.close();
    }

    public WMFPen createPenBrush(int penStyle, short width, long penColour, short fillhatch, long fillColour, int fillStyle) throws IOException {
        short p = this.createPenIndirect(penStyle, width, penColour);
        short b = this.createBrushIndirect(fillhatch, fillColour, fillStyle);
        return new WMFPen(p, b);
    }

    public WMFPen createDrawPen(int penStyle, short width, long colour) throws IOException {
        return this.createPenBrush(penStyle, width, colour, (short)1, colour, 1);
    }

    public WMFPen createDrawPen(short width, long colour) throws IOException {
        return this.createPenBrush(0, width, colour, (short)1, colour, 1);
    }

    public WMFPen createFillPen(short fillHatch, long colour, int fillStyle) throws IOException {
        return this.createPenBrush(5, (short)0, colour, fillHatch, colour, fillStyle);
    }

    public WMFPen createFillPen(long colour) throws IOException {
        return this.createPenBrush(5, (short)0, colour, (short)1, colour, 0);
    }

    public void selectPen(WMFPen pen) throws IOException {
        this.SelectObject(pen.getPenNum());
        this.SelectObject(pen.getBrushNum());
    }

    public void freePen(WMFPen pen) throws IOException {
        this.deleteObject(pen.getPenNum());
        this.deleteObject(pen.getBrushNum());
    }

    public short createPenIndirect(int style, short width, long colour) throws IOException {
        this.addRecord((short)762, 5);
        RandomAccessStreamUtils.writeU16(this.out, style);
        RandomAccessStreamUtils.writeS16(this.out, width);
        RandomAccessStreamUtils.writeS16(this.out, (short)0);
        RandomAccessStreamUtils.writeS32(this.out, colour);
        return this.allocObject();
    }

    public short createBrushIndirect(short hatch, long colour, int style) throws IOException {
        this.addRecord((short)764, 4);
        RandomAccessStreamUtils.writeU16(this.out, style);
        RandomAccessStreamUtils.writeS32(this.out, colour);
        RandomAccessStreamUtils.writeS16(this.out, hatch);
        return this.allocObject();
    }

    public int createFontIndirect(short height, int width, int escapement, int orientation, int weight, char italic, char underlined, char striked, char charset, char outPrecision, char clipPrecision, char quality, char pitch, char[] name) throws IOException {
        this.addRecord((short)763, 25);
        RandomAccessStreamUtils.writeS16(this.out, height);
        RandomAccessStreamUtils.writeU16(this.out, width);
        RandomAccessStreamUtils.writeU16(this.out, escapement);
        RandomAccessStreamUtils.writeU16(this.out, orientation);
        RandomAccessStreamUtils.writeU16(this.out, weight);
        RandomAccessStreamUtils.writeU8(this.out, italic);
        RandomAccessStreamUtils.writeU8(this.out, underlined);
        RandomAccessStreamUtils.writeU8(this.out, striked);
        RandomAccessStreamUtils.writeU8(this.out, charset);
        RandomAccessStreamUtils.writeU8(this.out, outPrecision);
        RandomAccessStreamUtils.writeU8(this.out, clipPrecision);
        RandomAccessStreamUtils.writeU8(this.out, quality);
        RandomAccessStreamUtils.writeU8(this.out, pitch);
        for (int i = 0; i < 32; ++i) {
            RandomAccessStreamUtils.writeU8(this.out, name[i]);
        }
        return this.allocObject();
    }

    public int createRegion(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1791, left, top, right, bottom);
        return this.allocObject();
    }

    public void deleteObject(short nobj) throws IOException {
        this.FreeObject(nobj);
        this.addCommandX((short)496, nobj);
    }

    public void ellipse(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1048, left, top, right, bottom);
    }

    public void ExcludeClipRect(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1045, left, top, right, bottom);
    }

    public void FillRgn(short nbrush, short nregion) throws IOException {
        this.addCommandXY((short)552, nbrush, nregion);
    }

    public void FloodFill(short x, short y, long colour) throws IOException {
        this.addCommandXYL((short)1049, x, y, colour);
    }

    private void FreeObject(int nobj) {
        this.objects.set(nobj, Boolean.FALSE);
    }

    private void initLowLevelGraphics(RandomAccessStream out, int width, int height) throws IOException {
        out.setLength(0);
        this.objects = new ArrayList();
        this.meta = new PlaceableMetaHeader();
        this.head = new WindowsMetaHeader();
        this.meta.Key = -1698247209L;
        this.meta.Handle = 0;
        this.meta.Left = 0;
        this.meta.Top = 0;
        this.meta.Right = width;
        this.meta.Bottom = height;
        this.meta.Inch = (short)1440;
        this.meta.Reserved = 0L;
        this.meta.Checksum = 0;
        this.head.FileType = 1;
        this.head.HeaderSize = (short)9;
        this.head.Version = (short)768;
        this.head.FileSize = 9L;
        this.head.NumOfObjects = 0;
        this.head.MaxRecordSize = 0L;
        this.head.NumOfParams = 0;
        this.out = out;
        this.writeHEADER();
    }

    public void IntersectClipRetc(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1046, left, top, right, bottom);
    }

    public void InvertRgn(short nregion) throws IOException {
        this.addCommandX((short)298, nregion);
    }

    public void LineTo(short x, short y) throws IOException {
        this.addCommandXY((short)531, x, y);
    }

    public void LineTo(WMFPoint p) throws IOException {
        this.LineTo(p.x, p.y);
    }

    public void MoveTo(short x, short y) throws IOException {
        this.addCommandXY((short)532, x, y);
    }

    public void MoveTo(WMFPoint p) throws IOException {
        this.MoveTo(p.x, p.y);
    }

    public void OffsetViewportOrg(short x, short y) throws IOException {
        this.addCommandXY((short)529, x, y);
    }

    public void OffsetWindowOrg(short x, short y) throws IOException {
        this.addCommandXY((short)527, x, y);
    }

    public void PaintRgn(short nregion) throws IOException {
        this.addCommandX((short)299, nregion);
    }

    public void PatBlt(short left, short top, short right, short bottom, long rop) throws IOException {
        this.addRecord((short)1565, 6);
        RandomAccessStreamUtils.writeS32(this.out, rop);
        RandomAccessStreamUtils.writeS16(this.out, bottom);
        RandomAccessStreamUtils.writeS16(this.out, right);
        RandomAccessStreamUtils.writeS16(this.out, top);
        RandomAccessStreamUtils.writeS16(this.out, left);
    }

    public void Polygon(WMFPoint[] p, short nbr) throws IOException {
        this.addCommandLINES((short)804, p, nbr);
    }

    public void PolyLine(WMFPoint[] p, short nbr) throws IOException {
        this.addCommandLINES((short)805, p, nbr);
    }

    public void rectangle(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1051, left, top, right, bottom);
    }

    public void RestoreDC(short lev) throws IOException {
        this.addCommandX((short)295, lev);
    }

    public void RoundRectangle(short left, short top, short right, short bottom, short wi, short h) throws IOException {
        this.addRecord((short)1564, 6);
        RandomAccessStreamUtils.writeS16(this.out, h);
        RandomAccessStreamUtils.writeS16(this.out, wi);
        RandomAccessStreamUtils.writeS16(this.out, bottom);
        RandomAccessStreamUtils.writeS16(this.out, right);
        RandomAccessStreamUtils.writeS16(this.out, top);
        RandomAccessStreamUtils.writeS16(this.out, left);
    }

    public void SaveDC() throws IOException {
        this.addCommand((short)30);
    }

    public void ScaleViewportExt(short xnum, short xdenom, short ynum, short ydenom) throws IOException {
        this.addRecord((short)1042, 4);
        RandomAccessStreamUtils.writeS16(this.out, ydenom);
        RandomAccessStreamUtils.writeS16(this.out, ynum);
        RandomAccessStreamUtils.writeS16(this.out, xdenom);
        RandomAccessStreamUtils.writeS16(this.out, xnum);
    }

    public void ScaleWindowExt(short xnum, short xdenom, short ynum, short ydenom) throws IOException {
        this.addRecord((short)1040, 4);
        RandomAccessStreamUtils.writeS16(this.out, ydenom);
        RandomAccessStreamUtils.writeS16(this.out, ynum);
        RandomAccessStreamUtils.writeS16(this.out, xdenom);
        RandomAccessStreamUtils.writeS16(this.out, xnum);
    }

    public void SelectClipRgn(short nregion) throws IOException {
        this.addCommandX((short)300, nregion);
    }

    public void SelectObject(short nobj) throws IOException {
        this.addCommandX((short)301, nobj);
    }

    public void SetBKColor(long color) throws IOException {
        this.addCommandL((short)513, color);
    }

    public void SetBKMode(short mode) throws IOException {
        this.addCommandX((short)258, mode);
    }

    public void SetMapMode(short map) throws IOException {
        this.addCommandX((short)259, map);
    }

    public void SetPixel(short x, short y, long colour) throws IOException {
        this.addCommandXYL((short)1055, x, y, colour);
    }

    public void SetPixel(WMFPoint p, long colour) throws IOException {
        this.SetPixel(p.x, p.y, colour);
    }

    public void SetPolyFillMode(short fillmode) throws IOException {
        this.addCommandX((short)262, fillmode);
    }

    public void SetROP2(long rop) throws IOException {
        this.addCommandL((short)260, rop);
    }

    public void SetTextCharacterExtra(short extra) throws IOException {
        this.addCommandX((short)521, extra);
    }

    public void SetTextColor(long color) throws IOException {
        this.addCommandL((short)521, color);
    }

    public void setViewportExt(short x, short y) throws IOException {
        this.addCommandXY((short)526, x, y);
    }

    public void setViewportExt(WMFPoint p) throws IOException {
        this.setViewportExt(p.x, p.y);
    }

    public void setViewportOrg(short x, short y) throws IOException {
        this.addCommandXY((short)525, x, y);
    }

    public void setWindowExt(short x, short y) throws IOException {
        this.addCommandXY((short)524, x, y);
    }

    public void setWindowExt(WMFPoint p) throws IOException {
        this.setWindowExt(p.x, p.y);
    }

    public void setWindowOrg(short x, short y) throws IOException {
        this.addCommandXY((short)523, x, y);
    }

    public void textOut(short x, short y, char[] s) throws IOException {
        int length = s.length;
        this.addRecord((short)1313, (length + 1) / 2 + 3);
        RandomAccessStreamUtils.writeS16(this.out, (short)length);
        for (int i = 0; i < length; ++i) {
            RandomAccessStreamUtils.writeU8(this.out, s[i]);
        }
        if (length % 2 != 0) {
            RandomAccessStreamUtils.writeU8(this.out, 0);
        }
        RandomAccessStreamUtils.writeS16(this.out, y);
        RandomAccessStreamUtils.writeS16(this.out, x);
    }

    public void textOut(short x, short y, String txt) throws IOException {
        char[] t = txt.toCharArray();
        this.textOut(x, y, t);
    }

    public void textOut(WMFPoint p, char[] s) throws IOException {
        this.textOut(p.x, p.y, s);
    }

    public void textOut(WMFPoint p, String txt) throws IOException {
        this.textOut(p.x, p.y, txt);
    }

    private void writeHEADER() throws IOException {
        this.meta.compute_checksum();
        this.meta.write();
        this.head.write();
    }

    private void writeClipboardHeader(PlaceableMetaHeader meta2) throws IOException {
        RandomAccessStreamUtils.writeS32(this.out, 6L);
        RandomAccessStreamUtils.writeS32(this.out, meta2.Right);
        RandomAccessStreamUtils.writeS32(this.out, meta2.Bottom);
        RandomAccessStreamUtils.writeS32(this.out, 0L);
    }

    public static long buildColor(int r, int g, int b) {
        return r | g << 8 | b << 16;
    }

    public static long buildColor(Color col) {
        return WMFDeviceContext.buildColor(col.getRed(), col.getGreen(), col.getBlue());
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile o = new RandomAccessFile("test.wmf", "rw");
        WMFDeviceContext wmf = new WMFDeviceContext(new RandomAccessFileAdapter(o), 200.0, 200.0);
        WMFPoint[] pol = new WMFPoint[]{new WMFPoint(20, 20), new WMFPoint(40, 20), new WMFPoint(100, 110), new WMFPoint(200, 40), new WMFPoint(405, 200)};
        wmf.setWindowOrg((short)0, (short)0);
        wmf.setWindowExt((short)200, (short)200);
        wmf.MoveTo((short)10, (short)10);
        wmf.LineTo((short)50, (short)100);
        wmf.LineTo((short)100, (short)50);
        wmf.LineTo((short)10, (short)10);
        wmf.Polygon(pol, (short)4);
    }

    class WindowsMetaHeader {
        long FileSize;
        short FileType;
        short HeaderSize;
        long MaxRecordSize;
        short NumOfObjects;
        short NumOfParams;
        short Version;

        WindowsMetaHeader() {
        }

        public void write() throws IOException {
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.FileType);
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.HeaderSize);
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.Version);
            RandomAccessStreamUtils.writeS32(WMFDeviceContext.this.out, this.FileSize);
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.NumOfObjects);
            RandomAccessStreamUtils.writeS32(WMFDeviceContext.this.out, this.MaxRecordSize);
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.NumOfParams);
        }
    }

    class PlaceableMetaHeader {
        int Bottom;
        short Checksum;
        short Handle;
        short Inch;
        long Key;
        int Left;
        long Reserved;
        int Right;
        int Top;

        PlaceableMetaHeader() {
        }

        void compute_checksum() {
            this.Checksum = 0;
            short[] b = new short[]{(short)(this.Key & 0xFFL), (short)((this.Key & 0xFF00L) >>> 16), (short)this.Left, (short)this.Top, (short)this.Right, (short)this.Bottom, this.Inch, (short)(this.Reserved & 0xFFL), (short)((this.Reserved & 0xFF00L) >>> 16)};
            for (int i = 0; i < b.length; ++i) {
                this.Checksum = (short)(this.Checksum ^ b[i]);
            }
        }

        public void write() throws IOException {
            RandomAccessStreamUtils.writeS32(WMFDeviceContext.this.out, this.Key);
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.Handle);
            RandomAccessStreamUtils.writeU16(WMFDeviceContext.this.out, this.Left);
            RandomAccessStreamUtils.writeU16(WMFDeviceContext.this.out, this.Top);
            RandomAccessStreamUtils.writeU16(WMFDeviceContext.this.out, this.Right);
            RandomAccessStreamUtils.writeU16(WMFDeviceContext.this.out, this.Bottom);
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.Inch);
            RandomAccessStreamUtils.writeS32(WMFDeviceContext.this.out, this.Reserved);
            RandomAccessStreamUtils.writeS16(WMFDeviceContext.this.out, this.Checksum);
        }
    }
}

