/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import lib.common.Util;
import lib.kemi.graph_lib.DiagrPaintUtility;
import lib.kemi.graph_lib.GraphLib;

public class DiagrPrintUtility
implements Printable {
    private final Component componentToBePrinted;
    private final GraphLib.PltData dd;
    private final DiagrPaintUtility diagrPaintUtil;
    private boolean defaultPrinter = false;
    private final String prgName;
    private static final String nl = System.getProperty("line.separator");

    private DiagrPrintUtility(Component componentToBePrinted, GraphLib.PltData dD, boolean defaultPrinter, DiagrPaintUtility dPaintUtil, String progName) {
        this.componentToBePrinted = componentToBePrinted;
        this.dd = dD;
        this.defaultPrinter = defaultPrinter;
        this.diagrPaintUtil = dPaintUtil;
        this.prgName = progName;
    }

    public static void printComponent(Component c, GraphLib.PltData dD, boolean defaultPrinter, DiagrPaintUtility dPaintUtil, String progName) {
        new DiagrPrintUtility(c, dD, defaultPrinter, dPaintUtil, progName).print();
    }

    private void print() {
        this.componentToBePrinted.setCursor(new Cursor(3));
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (printJob.getPrintService() == null) {
            JOptionPane.showMessageDialog(this.componentToBePrinted, "Error: No printers found." + nl, this.prgName, 0);
            return;
        }
        printJob.setPrintable(this);
        HashPrintRequestAttributeSet attrSet = new HashPrintRequestAttributeSet();
        MediaSizeName mediaSizeName = MediaSize.findMedia(210.0f, 279.0f, 1000);
        if (mediaSizeName != null) {
            attrSet.add(mediaSizeName);
        }
        MediaPrintableArea mediaPrintableArea = new MediaPrintableArea(15.0f, 5.0f, 190.0f, 269.0f, 1000);
        attrSet.add(mediaPrintableArea);
        boolean ok = this.defaultPrinter ? true : printJob.printDialog();
        if (ok) {
            try {
                printJob.print(attrSet);
            }
            catch (PrinterException ex) {
                String t = "Error: " + ex.toString() + nl + "While printing plot file:" + nl + this.dd.pltFile_Name;
                Util.exceptn((String)t);
                JOptionPane.showMessageDialog(this.componentToBePrinted, t, this.prgName, 0);
            }
        }
        this.componentToBePrinted.setCursor(new Cursor(0));
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        int x0 = Math.round((float)pf.getImageableX());
        int y0 = Math.round((float)pf.getImageableY());
        g2d.translate(x0, y0);
        DiagrPrintUtility.disableDoubleBuffering(this.componentToBePrinted);
        int w = Math.round((float)pf.getImageableWidth());
        int h = Math.round((float)pf.getImageableHeight());
        Dimension pageDim = new Dimension(w, h);
        boolean printing = true;
        this.diagrPaintUtil.paintDiagram(g2d, pageDim, this.dd, printing);
        DiagrPrintUtility.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    private static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    private static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

