/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import lib.common.Util;
import lib.huvud.Div;
import lib.huvud.ProgramConf;
import lib.huvud.RedirectedFrame;
import lib.huvud.RunProgr;
import lib.huvud.SortedProperties;
import lib.kemi.graph_lib.DiagrPaintUtility;
import spana.DiagrConvert;
import spana.Disp;
import spana.HelpAbout;
import spana.Main;
import spana.ModifyChemSyst;
import spana.OneInstance;
import spana.OptionsCalcs;
import spana.OptionsDiagram;
import spana.OptionsGeneral;
import spana.ProgramDataSpana;
import spana.Select_Diagram;

public class SpanaFrame
extends JFrame {
    static final String VERS = "2015-June-05";
    private static RedirectedFrame msgFrame = null;
    private static SpanaFrame spf = null;
    private final ProgramDataSpana pd = new ProgramDataSpana();
    private final ProgramConf pc;
    private DiagrPaintUtility diagrPaintUtil = null;
    private HelpAbout helpAboutFrame = null;
    static boolean windows = false;
    private static String windir = null;
    private static Dimension msgFrameSize = new Dimension(500, 400);
    private static Point locationMsgFrame = new Point(80, 30);
    private static Point locationFrame = new Point(-1000, -1000);
    static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private final Dimension WINDOWsize = new Dimension(325, 186);
    static Dimension dispSize = new Dimension(400, 350);
    static Point dispLocation = new Point(60, 30);
    static String txtEditor;
    static String pathSedPredom;
    static String createDataFileProg;
    private final ArrayList<String> dataFileArrList = new ArrayList();
    private final ArrayList<Disp> diagrArrList = new ArrayList();
    private boolean jComboBox_Plt_doNothing = false;
    static File fileIni;
    private static final String FileINI_NAME = "Spana.ini";
    private int laf = 0;
    private ModifyChemSyst modifyDiagramWindow = null;
    private boolean doNotExit = false;
    private boolean waitingForPrinter = false;
    public static final double Faraday = 96485.309;
    public static final double Rgas = 8.31451;
    static final int MXSTP = 1000;
    static final int MNSTP = 4;
    static final int NSTEPS_DEF = 50;
    private static final String nl;
    private static final String SLASH;
    public static final String[] FORMAT_NAMES;
    public static final String LINE = "- - - - - - - - - - - - - - - - - - - - - - - - - - -";
    public static TransferHandler tHandler;
    public JCheckBoxMenuItem jCheckBoxMenuDebug;
    private JComboBox jComboBox_Dat;
    private JComboBox jComboBox_Plt;
    private JLabel jLabelBackgrd;
    private JLabel jLabel_Dat;
    private JLabel jLabel_Plt;
    private JMenuBar jMenuBar;
    private JMenuItem jMenu_Data_AddToList;
    private JMenuItem jMenu_Data_Edit;
    private JMenuItem jMenu_Data_MakeDiag;
    private JMenuItem jMenu_Data_Modif;
    private JMenuItem jMenu_Data_New;
    private JMenu jMenu_File;
    private JMenu jMenu_File_Data;
    private JMenuItem jMenu_File_Exit;
    private JMenuItem jMenu_File_PlotFile;
    private JMenu jMenu_Help;
    private JMenuItem jMenu_Help_About;
    private JMenuItem jMenu_Help_Contents;
    private JMenu jMenu_Prefs;
    private JMenuItem jMenu_Prefs_Calcs;
    private JMenuItem jMenu_Prefs_Diagr;
    private JMenuItem jMenu_Prefs_General;
    private JMenu jMenu_Run;
    private JMenuItem jMenu_Run_Cmd;
    private JMenuItem jMenu_Run_Database;
    private JMenuItem jMenu_Run_MakeDiagr;
    private JMenuItem jMenu_Run_Modif;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparatorCmd;
    private JPopupMenu.Separator jSeparatorMake;

    public SpanaFrame(ProgramConf pc0, RedirectedFrame msgFrame0) {
        this.initComponents();
        this.pc = pc0;
        msgFrame = msgFrame0;
        this.setDefaultCloseOperation(0);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        AbstractAction altQAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpanaFrame.this.end_program();
            }
        };
        this.getRootPane().getActionMap().put("ALT_Q", altQAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpanaFrame.this.jMenu_Help_Contents.doClick();
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        String iconName = "images/Spana_icon_32x32.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            Image icon = new ImageIcon(imgURL).getImage();
            this.setIconImage(icon);
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                try {
                    Class<?> c = Class.forName("com.apple.eawt.Application");
                    Method m = c.getDeclaredMethod("setDockIconImage", Image.class);
                    Object i = c.newInstance();
                    URL iconURL = this.getClass().getResource("images/Spana_icon_48x48.gif");
                    if (iconURL != null) {
                        icon = new ImageIcon(iconURL).getImage();
                    }
                    Object[] paramsObj = new Object[]{icon};
                    m.invoke(i, paramsObj);
                }
                catch (Exception e) {
                    Util.exceptn((String)("Error: " + e.getMessage()));
                }
            }
        } else {
            Util.exceptn((String)("Error: Could not load image = \"" + iconName + "\""));
        }
        this.jPanel1.setTransferHandler(tHandler);
        this.jMenuBar.setTransferHandler(tHandler);
        this.jLabelBackgrd.setTransferHandler(tHandler);
        this.setTitle(this.pc.progName + " diagram");
        this.getContentPane().setBackground(Color.white);
        this.jPanel1.setBackground(Color.white);
        this.jMenuBar.add(Box.createHorizontalGlue(), 3);
        this.setPreferredSize(this.WINDOWsize);
        this.jPanel2.setPreferredSize(this.jPanel2.getPreferredSize());
        this.jLabel_Dat.setVisible(false);
        this.jComboBox_Dat.setVisible(false);
        this.jPanel3.setPreferredSize(this.jPanel3.getPreferredSize());
        this.jLabel_Plt.setVisible(false);
        this.jComboBox_Plt.setVisible(false);
        CardLayout cl = (CardLayout)this.getContentPane().getLayout();
        cl.show(this.getContentPane(), "cardIcon");
        SpanaFrame.locationFrame.x = Math.max(0, (SpanaFrame.screenSize.width - this.getWidth()) / 2);
        SpanaFrame.locationFrame.y = Math.max(0, (SpanaFrame.screenSize.height - this.getHeight()) / 2);
        this.setLocation(locationFrame);
    }

    private void start(final String[] args) {
        File f;
        this.diagrPaintUtil = new DiagrPaintUtility();
        this.readIni();
        SpanaFrame.locationFrame.x = Math.min(SpanaFrame.screenSize.width - this.getWidth() - 5, Math.max(5, SpanaFrame.locationFrame.x));
        SpanaFrame.locationFrame.y = Math.min(SpanaFrame.screenSize.height - this.getHeight() - 35, Math.max(5, SpanaFrame.locationFrame.y));
        this.setLocation(locationFrame);
        this.pack();
        this.setVisible(true);
        spf = this;
        if (this.pc.dbg) {
            System.out.flush();
            StringBuffer msg = new StringBuffer();
            msg.append(LINE);
            msg.append(nl);
            msg.append("After reading cfg- and INI-files");
            msg.append(nl);
            msg.append("   and after checking for another instance:");
            msg.append(nl);
            msg.append("App_Path = ");
            if (this.pc.pathAPP == null) {
                msg.append("\"null\"");
            } else if (this.pc.pathAPP.trim().length() <= 0) {
                msg.append("\"\"");
            } else {
                msg.append(this.pc.pathAPP);
            }
            msg.append(nl);
            msg.append("Def_path = ");
            msg.append(this.pc.pathDef.toString());
            msg.append(nl);
            try {
                msg.append("User.dir = ");
                msg.append(System.getProperty("user.dir"));
                msg.append(nl);
                msg.append("User.home = ");
                msg.append(System.getProperty("user.home"));
                msg.append(nl);
            }
            catch (Exception e) {
                // empty catch block
            }
            msg.append("CLASSPATH = ");
            msg.append(System.getProperty("java.class.path"));
            msg.append(nl);
            msg.append(LINE);
            System.out.println(msg);
            System.out.flush();
        }
        try {
            if (this.laf == 2) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(CrossPlatform);");
            } else if (this.laf == 1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(System);");
            }
        }
        catch (ClassNotFoundException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        catch (InstantiationException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        catch (UnsupportedLookAndFeelException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        SwingUtilities.updateComponentTreeUI(spf);
        spf.invalidate();
        spf.validate();
        spf.repaint();
        SwingUtilities.updateComponentTreeUI((Component)msgFrame);
        msgFrame.invalidate();
        msgFrame.validate();
        msgFrame.repaint();
        System.out.println("--- configureOptionPane();");
        Util.configureOptionPane();
        if (txtEditor == null || txtEditor.trim().length() <= 0) {
            this.jMenu_Data_Edit.setVisible(false);
        }
        if (msgFrame != null) {
            msgFrame.setLocation(locationMsgFrame);
            msgFrame.setSize(msgFrameSize);
            msgFrame.setParentFrame((JFrame)spf);
            this.jCheckBoxMenuDebug.setSelected(msgFrame.isVisible());
        } else {
            this.jCheckBoxMenuDebug.setVisible(false);
        }
        SpanaFrame.dispLocation.x -= 20;
        SpanaFrame.dispLocation.y -= 20;
        if (!this.pd.advancedVersion) {
            this.jMenu_Run_Cmd.setVisible(false);
            this.jSeparatorCmd.setVisible(false);
        }
        if (!this.pd.advancedVersion) {
            this.jMenu_Prefs_Calcs.setVisible(false);
        } else {
            this.jMenu_Prefs_Calcs.setVisible(true);
        }
        if (createDataFileProg != null && createDataFileProg.trim().length() > 0) {
            f = new File(createDataFileProg);
            if (!f.exists()) {
                this.jMenu_Run_Database.setEnabled(false);
            }
        } else {
            this.jMenu_Run_Database.setEnabled(false);
        }
        if (pathSedPredom != null) {
            f = new File(pathSedPredom);
            if (!Div.progSEDexists((File)f) && !Div.progPredomExists((File)f)) {
                this.jMenu_Run_MakeDiagr.setEnabled(false);
                this.jMenu_Data_MakeDiag.setEnabled(false);
            }
        } else {
            this.jMenu_Run_MakeDiagr.setEnabled(false);
            this.jMenu_Data_MakeDiag.setEnabled(false);
        }
        if (args != null && args.length > 0) {
            Thread dArg = new Thread(){

                @Override
                public void run() {
                    for (String arg : args) {
                        SpanaFrame.this.dispatchArg(arg);
                    }
                    if (!(msgFrame != null && msgFrame.isVisible() || SpanaFrame.this.doNotExit)) {
                        SpanaFrame.this.end_program();
                    }
                }
            };
            dArg.start();
        }
    }

    private void initComponents() {
        this.jLabelBackgrd = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel_Dat = new JLabel();
        this.jComboBox_Dat = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jLabel_Plt = new JLabel();
        this.jComboBox_Plt = new JComboBox();
        this.jMenuBar = new JMenuBar();
        this.jMenu_File = new JMenu();
        this.jMenu_File_Data = new JMenu();
        this.jMenu_Data_MakeDiag = new JMenuItem();
        this.jMenu_Data_New = new JMenuItem();
        this.jMenu_Data_Modif = new JMenuItem();
        this.jMenu_Data_Edit = new JMenuItem();
        this.jMenu_Data_AddToList = new JMenuItem();
        this.jMenu_File_PlotFile = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenu_File_Exit = new JMenuItem();
        this.jMenu_Run = new JMenu();
        this.jMenu_Run_Cmd = new JMenuItem();
        this.jSeparatorCmd = new JPopupMenu.Separator();
        this.jMenu_Run_Modif = new JMenuItem();
        this.jMenu_Run_MakeDiagr = new JMenuItem();
        this.jSeparatorMake = new JPopupMenu.Separator();
        this.jMenu_Run_Database = new JMenuItem();
        this.jMenu_Prefs = new JMenu();
        this.jMenu_Prefs_General = new JMenuItem();
        this.jMenu_Prefs_Diagr = new JMenuItem();
        this.jMenu_Prefs_Calcs = new JMenuItem();
        this.jCheckBoxMenuDebug = new JCheckBoxMenuItem();
        this.jMenu_Help = new JMenu();
        this.jMenu_Help_Contents = new JMenuItem();
        this.jMenu_Help_About = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                SpanaFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                SpanaFrame.this.formWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                SpanaFrame.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SpanaFrame.this.formComponentResized(evt);
            }
        });
        this.getContentPane().setLayout(new CardLayout());
        this.jLabelBackgrd.setFont(new Font("Dialog", 0, 11));
        this.jLabelBackgrd.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Spana_diagram.gif")));
        this.jLabelBackgrd.setVerticalAlignment(1);
        this.jLabelBackgrd.setPreferredSize(new Dimension(325, 150));
        this.getContentPane().add((Component)this.jLabelBackgrd, "cardIcon");
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jPanel2.setOpaque(false);
        this.jLabel_Dat.setFont(new Font("Dialog", 0, 11));
        this.jLabel_Dat.setLabelFor(this.jComboBox_Dat);
        this.jLabel_Dat.setText("Data files:");
        this.jComboBox_Dat.setFont(new Font("Dialog", 0, 11));
        this.jComboBox_Dat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jComboBox_DatActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_Dat).addComponent(this.jComboBox_Dat, GroupLayout.Alignment.TRAILING, 0, 305, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel_Dat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Dat, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setFont(new Font("Dialog", 0, 11));
        this.jPanel3.setOpaque(false);
        this.jLabel_Plt.setFont(new Font("Dialog", 0, 11));
        this.jLabel_Plt.setText("Plot files:");
        this.jComboBox_Plt.setFont(new Font("Dialog", 0, 11));
        this.jComboBox_Plt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jComboBox_PltActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_Plt).addComponent(this.jComboBox_Plt, 0, 305, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel_Plt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Plt, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(37, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel1, "cardPanel");
        this.jMenu_File.setMnemonic('F');
        this.jMenu_File.setText("File");
        this.jMenu_File_Data.setMnemonic('D');
        this.jMenu_File_Data.setText("Data file");
        this.jMenu_Data_MakeDiag.setMnemonic('O');
        this.jMenu_Data_MakeDiag.setText("Open (make a diagram)");
        this.jMenu_Data_MakeDiag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Data_MakeDiagActionPerformed(evt);
            }
        });
        this.jMenu_File_Data.add(this.jMenu_Data_MakeDiag);
        this.jMenu_Data_New.setMnemonic('N');
        this.jMenu_Data_New.setText("New (create)");
        this.jMenu_Data_New.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Data_NewActionPerformed(evt);
            }
        });
        this.jMenu_File_Data.add(this.jMenu_Data_New);
        this.jMenu_Data_Modif.setMnemonic('M');
        this.jMenu_Data_Modif.setText("Modify");
        this.jMenu_Data_Modif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Data_ModifActionPerformed(evt);
            }
        });
        this.jMenu_File_Data.add(this.jMenu_Data_Modif);
        this.jMenu_Data_Edit.setMnemonic('E');
        this.jMenu_Data_Edit.setText("Edit");
        this.jMenu_Data_Edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Data_EditActionPerformed(evt);
            }
        });
        this.jMenu_File_Data.add(this.jMenu_Data_Edit);
        this.jMenu_Data_AddToList.setMnemonic('A');
        this.jMenu_Data_AddToList.setText("Add name to list");
        this.jMenu_Data_AddToList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Data_AddToListActionPerformed(evt);
            }
        });
        this.jMenu_File_Data.add(this.jMenu_Data_AddToList);
        this.jMenu_File.add(this.jMenu_File_Data);
        this.jMenu_File_PlotFile.setMnemonic('P');
        this.jMenu_File_PlotFile.setText("Plot file (display)");
        this.jMenu_File_PlotFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_File_PlotFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenu_File_PlotFile);
        this.jMenu_File.add(this.jSeparator1);
        this.jMenu_File_Exit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.jMenu_File_Exit.setMnemonic('X');
        this.jMenu_File_Exit.setText("Exit");
        this.jMenu_File_Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_File_ExitActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenu_File_Exit);
        this.jMenuBar.add(this.jMenu_File);
        this.jMenu_Run.setMnemonic('R');
        this.jMenu_Run.setText("Run");
        this.jMenu_Run_Cmd.setMnemonic('P');
        this.jMenu_Run_Cmd.setText("command Prompt");
        this.jMenu_Run_Cmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Run_CmdActionPerformed(evt);
            }
        });
        this.jMenu_Run.add(this.jMenu_Run_Cmd);
        this.jMenu_Run.add(this.jSeparatorCmd);
        this.jMenu_Run_Modif.setMnemonic('M');
        this.jMenu_Run_Modif.setText("Modify chemical system");
        this.jMenu_Run_Modif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Run_ModifActionPerformed(evt);
            }
        });
        this.jMenu_Run.add(this.jMenu_Run_Modif);
        this.jMenu_Run_MakeDiagr.setMnemonic('D');
        this.jMenu_Run_MakeDiagr.setText("make a Diagram");
        this.jMenu_Run_MakeDiagr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Run_MakeDiagrActionPerformed(evt);
            }
        });
        this.jMenu_Run.add(this.jMenu_Run_MakeDiagr);
        this.jMenu_Run.add(this.jSeparatorMake);
        this.jMenu_Run_Database.setMnemonic('L');
        this.jMenu_Run_Database.setText("LogK Database");
        this.jMenu_Run_Database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Run_DatabaseActionPerformed(evt);
            }
        });
        this.jMenu_Run.add(this.jMenu_Run_Database);
        this.jMenuBar.add(this.jMenu_Run);
        this.jMenu_Prefs.setMnemonic('P');
        this.jMenu_Prefs.setText("Preferences");
        this.jMenu_Prefs_General.setMnemonic('G');
        this.jMenu_Prefs_General.setText("General options");
        this.jMenu_Prefs_General.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Prefs_GeneralActionPerformed(evt);
            }
        });
        this.jMenu_Prefs.add(this.jMenu_Prefs_General);
        this.jMenu_Prefs_Diagr.setMnemonic('D');
        this.jMenu_Prefs_Diagr.setText("Diagram windows");
        this.jMenu_Prefs_Diagr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Prefs_DiagrActionPerformed(evt);
            }
        });
        this.jMenu_Prefs.add(this.jMenu_Prefs_Diagr);
        this.jMenu_Prefs_Calcs.setMnemonic('C');
        this.jMenu_Prefs_Calcs.setText("Calculation options");
        this.jMenu_Prefs_Calcs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Prefs_CalcsActionPerformed(evt);
            }
        });
        this.jMenu_Prefs.add(this.jMenu_Prefs_Calcs);
        this.jCheckBoxMenuDebug.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.jCheckBoxMenuDebug.setMnemonic('S');
        this.jCheckBoxMenuDebug.setText("Show messages and errors");
        this.jCheckBoxMenuDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jCheckBoxMenuDebugActionPerformed(evt);
            }
        });
        this.jMenu_Prefs.add(this.jCheckBoxMenuDebug);
        this.jMenuBar.add(this.jMenu_Prefs);
        this.jMenu_Help.setMnemonic('H');
        this.jMenu_Help.setText("Help");
        this.jMenu_Help_Contents.setMnemonic('C');
        this.jMenu_Help_Contents.setText("help Contents");
        this.jMenu_Help_Contents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Help_ContentsActionPerformed(evt);
            }
        });
        this.jMenu_Help.add(this.jMenu_Help_Contents);
        this.jMenu_Help_About.setMnemonic('A');
        this.jMenu_Help_About.setText("About");
        this.jMenu_Help_About.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpanaFrame.this.jMenu_Help_AboutActionPerformed(evt);
            }
        });
        this.jMenu_Help.add(this.jMenu_Help_About);
        this.jMenuBar.add(this.jMenu_Help);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void jMenu_File_PlotFileActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        String pltFileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter Plot file name", (int)6, null, (String)this.pc.pathDef.toString());
        if (pltFileName == null) {
            this.setCursorDef();
            return;
        }
        this.setCursorWait();
        File pltFile = new File(pltFileName);
        try {
            pltFileName = pltFile.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                pltFileName = pltFile.getAbsolutePath();
            }
            catch (Exception e) {
                pltFileName = pltFile.getPath();
            }
        }
        this.displayPlotFile(pltFileName, null);
        this.setCursorDef();
    }

    private void jMenu_Help_AboutActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.jMenu_Help_About.setEnabled(false);
        Thread hlp = new Thread(){

            @Override
            public void run() {
                spf.helpAboutFrame = new HelpAbout(((SpanaFrame)SpanaFrame.this).pc.pathAPP);
                spf.helpAboutFrame.start();
                spf.setCursorDef();
                spf.helpAboutFrame.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        spf.helpAboutFrame = null;
                        SpanaFrame.this.jMenu_Help_About.setEnabled(true);
                        SpanaFrame.this.bringToFront();
                    }
                });
            }
        };
        hlp.start();
    }

    private void jMenu_Prefs_DiagrActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        final boolean oldTextWithFonts = this.diagrPaintUtil.textWithFonts;
        this.jMenu_Prefs_Diagr.setEnabled(false);
        Thread diagPrefs = new Thread(){

            @Override
            public void run() {
                OptionsDiagram optionsWindow = new OptionsDiagram(SpanaFrame.this.diagrPaintUtil, SpanaFrame.this.pc);
                optionsWindow.setVisible(true);
                spf.setCursorDef();
                optionsWindow.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpanaFrame.this.jMenu_Prefs_Diagr.setEnabled(true);
                        Frame[] f = Disp.getFrames();
                        if (SpanaFrame.this.diagrArrList.size() > 0 && f.length > 0) {
                            for (int k = 0; k < SpanaFrame.this.diagrArrList.size(); ++k) {
                                Disp gotDisp = (Disp)SpanaFrame.this.diagrArrList.get(k);
                                for (Frame f1 : f) {
                                    if (!f1.equals(gotDisp)) continue;
                                    if (oldTextWithFonts != ((SpanaFrame)SpanaFrame.this).diagrPaintUtil.textWithFonts) {
                                        gotDisp.reloadPlotFile();
                                    }
                                    if (gotDisp.getExtendedState() == 1) continue;
                                    gotDisp.repaint();
                                }
                            }
                        }
                    }
                });
            }
        };
        diagPrefs.start();
    }

    private void jComboBox_PltActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Plt_doNothing) {
            return;
        }
        int k = this.jComboBox_Plt.getSelectedIndex();
        if (k < 0) {
            return;
        }
        String name = this.jComboBox_Plt.getItemAt(k).toString();
        File pltF = new File(name);
        if (!pltF.exists()) {
            this.removePltFile(name);
            return;
        }
        this.displayPlotFile(name, null);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.end_program();
    }

    private void jMenu_File_ExitActionPerformed(ActionEvent evt) {
        this.end_program();
    }

    private void jMenu_Help_ContentsActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        String[] a = new String[]{"S_0_Main_htm"};
        RunProgr.runProgramInProcess((Component)this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)this.pc.dbg, (String)this.pc.pathAPP);
        this.setCursorDef();
    }

    private void jMenu_Data_EditActionPerformed(ActionEvent evt) {
        String[] args;
        String fileName;
        if (txtEditor == null) {
            return;
        }
        this.setCursorWait();
        if (this.dataFileArrList.size() <= 0) {
            fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter Data file name", (int)5, null, (String)this.pc.pathDef.toString());
            if (fileName == null) {
                this.setCursorDef();
                return;
            }
        } else {
            String defFile = this.jComboBox_Dat.getSelectedItem().toString();
            fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter Data file name", (int)5, (String)defFile, (String)this.pc.pathDef.toString());
            if (fileName == null) {
                this.setCursorDef();
                return;
            }
        }
        this.setCursorWait();
        File datFile = new File(fileName);
        try {
            fileName = datFile.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                fileName = datFile.getAbsolutePath();
            }
            catch (Exception e) {
                fileName = datFile.getPath();
            }
        }
        this.addDatFile(fileName);
        String editor = txtEditor;
        if (System.getProperty("os.name").startsWith("Mac OS") && txtEditor.equalsIgnoreCase("/usr/bin/open -t")) {
            editor = "/usr/bin/open";
            args = new String[]{"-t", fileName};
        } else {
            args = new String[]{fileName};
        }
        boolean waitForCompletion = false;
        RunProgr.runProgramInProcess((Component)this, (String)editor, (String[])args, (boolean)waitForCompletion, (boolean)this.pc.dbg, (String)this.pc.pathDef.toString());
        this.setCursorDef();
    }

    private void formComponentResized(ComponentEvent evt) {
        int w = Math.round((float)this.WINDOWsize.getWidth());
        int h = Math.round((float)this.WINDOWsize.getHeight());
        if (this.getHeight() < h) {
            this.setSize(this.getWidth(), h);
        }
        if (this.getWidth() < w) {
            this.setSize(w, this.getHeight());
        }
    }

    private void jMenu_Prefs_GeneralActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.jMenu_Prefs_General.setEnabled(false);
        this.jMenu_Prefs_Calcs.setEnabled(false);
        this.jMenu_Run_MakeDiagr.setEnabled(false);
        this.jMenu_Run_Modif.setEnabled(false);
        this.jMenu_Data_Modif.setEnabled(false);
        this.jMenu_Data_MakeDiag.setEnabled(false);
        Thread genO = new Thread(){

            @Override
            public void run() {
                OptionsGeneral genOptionsFrame = new OptionsGeneral(SpanaFrame.this.pc, SpanaFrame.this.pd, msgFrame);
                genOptionsFrame.setVisible(true);
                spf.setCursorDef();
                genOptionsFrame.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        File file;
                        SpanaFrame.this.jMenu_Prefs_General.setEnabled(true);
                        SpanaFrame.this.jMenu_Prefs_Calcs.setEnabled(true);
                        SpanaFrame.this.jMenu_Run_MakeDiagr.setEnabled(true);
                        SpanaFrame.this.jMenu_Run_Modif.setEnabled(true);
                        SpanaFrame.this.jMenu_Data_Modif.setEnabled(true);
                        SpanaFrame.this.jMenu_Data_MakeDiag.setEnabled(true);
                        if (!((SpanaFrame)SpanaFrame.this).pd.advancedVersion) {
                            SpanaFrame.this.jMenu_Run_Cmd.setVisible(false);
                            SpanaFrame.this.jSeparatorCmd.setVisible(false);
                            SpanaFrame.this.jMenu_Prefs_Calcs.setVisible(false);
                        } else {
                            SpanaFrame.this.jMenu_Run_Cmd.setVisible(true);
                            SpanaFrame.this.jSeparatorCmd.setVisible(true);
                            SpanaFrame.this.jMenu_Prefs_Calcs.setVisible(false);
                        }
                        if (!((SpanaFrame)SpanaFrame.this).pd.advancedVersion) {
                            SpanaFrame.this.jMenu_Prefs_Calcs.setVisible(false);
                        } else {
                            SpanaFrame.this.jMenu_Prefs_Calcs.setVisible(true);
                        }
                        if (createDataFileProg != null && createDataFileProg.trim().length() > 0) {
                            file = new File(createDataFileProg);
                            if (!file.exists()) {
                                System.out.println("Note: file does NOT exist: " + createDataFileProg);
                                SpanaFrame.this.jMenu_Run_Database.setEnabled(false);
                            } else {
                                SpanaFrame.this.jMenu_Run_Database.setEnabled(true);
                            }
                        } else {
                            SpanaFrame.this.jMenu_Run_Database.setEnabled(false);
                        }
                        if (pathSedPredom != null) {
                            file = new File(pathSedPredom);
                            if (!Div.progSEDexists((File)file) && !Div.progPredomExists((File)file)) {
                                SpanaFrame.this.jMenu_Run_MakeDiagr.setEnabled(false);
                                SpanaFrame.this.jMenu_Data_MakeDiag.setEnabled(false);
                            }
                        } else {
                            SpanaFrame.this.jMenu_Run_MakeDiagr.setEnabled(false);
                            SpanaFrame.this.jMenu_Data_MakeDiag.setEnabled(false);
                        }
                        Frame[] f = Disp.getFrames();
                        if (SpanaFrame.this.diagrArrList.size() > 0 && f.length > 0) {
                            for (int k = 0; k < SpanaFrame.this.diagrArrList.size(); ++k) {
                                Disp gotDisp = (Disp)SpanaFrame.this.diagrArrList.get(k);
                                for (Frame f1 : f) {
                                    if (!f1.equals(gotDisp) || gotDisp.getExtendedState() == 1) continue;
                                    gotDisp.setAdvancedFeatures(((SpanaFrame)SpanaFrame.this).pd.advancedVersion);
                                    gotDisp.repaint();
                                }
                            }
                        }
                    }
                });
            }
        };
        genO.start();
    }

    private void jMenu_Run_CmdActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        String OS = System.getProperty("os.name").toLowerCase();
        Runtime r = Runtime.getRuntime();
        try {
            if (OS.indexOf("windows 9") > -1) {
                if (this.pc.dbg) {
                    System.out.println("---- Exec \"command.com  /e:1024\"");
                }
                r.exec("command.com  /e:1024");
            } else if (OS.startsWith("windows") && OS.indexOf("nt") > -1 || OS.indexOf("windows 20") > -1 || OS.indexOf("windows xp") > -1) {
                String[] a = new String[]{"cmd.exe", "/k start cmd.exe"};
                File d = new File(this.pc.pathDef.toString());
                if (this.pc.dbg) {
                    System.out.println("---- Exec \"" + a + "\"" + nl + "     working dir: " + d);
                }
                r.exec(a, null, d);
            } else if (OS.startsWith("mac os")) {
                File term = new File("/Applications/Utilities/Terminal.app");
                if (!term.exists()) {
                    System.err.println("---- Error - file:" + term.getAbsolutePath() + nl + "     does NOT exist");
                } else {
                    String[] args = new String[]{"-n", term.getAbsolutePath()};
                    boolean waitForCompletion = false;
                    RunProgr.runProgramInProcess((Component)this, (String)"/usr/bin/open", (String[])args, (boolean)waitForCompletion, (boolean)this.pc.dbg, (String)this.pc.pathDef.toString());
                }
            } else {
                if (this.pc.dbg) {
                    System.out.println("---- Exec \"/usr/bin/xterm\"");
                }
                r.exec("/usr/bin/xterm");
            }
        }
        catch (IOException ex) {
            Util.exceptn((String)("Error: " + ex.toString()));
        }
        this.setCursorDef();
    }

    private void jMenu_Run_ModifActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.modifyDataFile();
    }

    private void jMenu_Run_MakeDiagrActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        if (this.dataFileArrList.size() <= 0) {
            String fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter data file name", (int)5, null, (String)this.pc.pathDef.toString());
            if (fileName == null) {
                this.setCursorDef();
                return;
            }
            if (!this.addDatFile(fileName)) {
                this.setCursorDef();
                return;
            }
        } else {
            String name = this.jComboBox_Dat.getSelectedItem().toString();
            File datF = new File(name);
            if (!datF.exists()) {
                this.removeDatFile(name);
                String fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter data file name", (int)5, null, (String)this.pc.pathDef.toString());
                if (fileName == null) {
                    this.setCursorDef();
                    return;
                }
                if (!this.addDatFile(fileName)) {
                    this.setCursorDef();
                    return;
                }
            }
        }
        this.setCursorWait();
        final File datFile = new File(this.jComboBox_Dat.getSelectedItem().toString());
        this.jMenu_Run_MakeDiagr.setCursor(new Cursor(3));
        this.jMenu_Prefs_General.setEnabled(false);
        this.jMenu_Run_MakeDiagr.setEnabled(false);
        this.jMenu_Data_MakeDiag.setEnabled(false);
        this.jMenu_Run_Modif.setEnabled(false);
        this.jMenu_Data_Modif.setEnabled(false);
        this.jMenu_Data_Edit.setEnabled(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Select_Diagram selectDiagramWindow = new Select_Diagram(datFile, SpanaFrame.this.pc, SpanaFrame.this.pd);
                selectDiagramWindow.start();
                spf.setCursorDef();
                SpanaFrame.this.jMenu_Run_MakeDiagr.setCursor(new Cursor(0));
                selectDiagramWindow.waitForSelectDiagram();
                return null;
            }

            @Override
            protected void done() {
                SpanaFrame.this.jMenu_Prefs_General.setEnabled(true);
                SpanaFrame.this.jMenu_Run_MakeDiagr.setEnabled(true);
                SpanaFrame.this.jMenu_Data_MakeDiag.setEnabled(true);
                SpanaFrame.this.jMenu_Run_Modif.setEnabled(true);
                SpanaFrame.this.jMenu_Data_Modif.setEnabled(true);
                SpanaFrame.this.jMenu_Data_Edit.setEnabled(true);
            }
        }.execute();
    }

    private void jMenu_Run_DatabaseActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.run_Database();
    }

    private void jMenu_Data_MakeDiagActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        String fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter Data file name", (int)5, null, (String)this.pc.pathDef.toString());
        if (fileName != null) {
            this.setCursorWait();
            this.addDatFile(fileName);
            if (this.jMenu_Run_MakeDiagr.isEnabled()) {
                this.jMenu_Run_MakeDiagr.doClick();
            }
        }
    }

    private void jMenu_Data_NewActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.run_Database();
    }

    private void jMenu_Data_ModifActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.modifyDataFile();
    }

    private void jMenu_Data_AddToListActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        String fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter Data file name", (int)5, null, (String)this.pc.pathDef.toString());
        if (fileName != null) {
            this.setCursorWait();
            this.addDatFile(fileName);
        }
        this.setCursorDef();
    }

    private void jCheckBoxMenuDebugActionPerformed(ActionEvent evt) {
        if (msgFrame != null) {
            msgFrame.setVisible(this.jCheckBoxMenuDebug.isSelected());
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        if (this.helpAboutFrame != null) {
            this.helpAboutFrame.bringToFront();
        }
        if (msgFrame != null) {
            this.jCheckBoxMenuDebug.setSelected(msgFrame.isVisible());
        } else {
            this.jCheckBoxMenuDebug.setVisible(false);
        }
    }

    private void jMenu_Prefs_CalcsActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.jMenu_Prefs_General.setEnabled(false);
        this.jMenu_Prefs_Calcs.setEnabled(false);
        this.jMenu_Run_MakeDiagr.setEnabled(false);
        this.jMenu_Data_MakeDiag.setEnabled(false);
        Thread calcO = new Thread(){

            @Override
            public void run() {
                OptionsCalcs calcsOptionsFrame = new OptionsCalcs(SpanaFrame.this.pc, SpanaFrame.this.pd);
                calcsOptionsFrame.setVisible(true);
                spf.setCursorDef();
                calcsOptionsFrame.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpanaFrame.this.jMenu_Prefs_General.setEnabled(true);
                        SpanaFrame.this.jMenu_Prefs_Calcs.setEnabled(true);
                        SpanaFrame.this.jMenu_Run_MakeDiagr.setEnabled(true);
                        SpanaFrame.this.jMenu_Data_MakeDiag.setEnabled(true);
                    }
                });
            }
        };
        calcO.start();
    }

    private void formWindowActivated(WindowEvent evt) {
        if (msgFrame != null && msgFrame.isVisible()) {
            this.jCheckBoxMenuDebug.setSelected(true);
        }
    }

    private void jComboBox_DatActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Dat.getSelectedIndex() < 0) {
            return;
        }
        String name = this.jComboBox_Dat.getSelectedItem().toString();
        File datF = new File(name);
        if (!datF.exists()) {
            this.removeDatFile(name);
        }
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    private synchronized void synchWaitPrinted() {
        if (this.pc.dbg) {
            System.out.println("---- synchWaitPrinted()");
        }
        while (!this.waitingForPrinter) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    private void end_program() {
        if (this.pc.dbg) {
            System.out.println(this.pc.progName + "---- end_program()");
        }
        if (this.modifyDiagramWindow != null && this.modifyDiagramWindow.isModified()) {
            this.modifyDiagramWindow.quitFrame();
            if (this.modifyDiagramWindow != null && this.modifyDiagramWindow.isModified()) {
                return;
            }
        }
        if (this.helpAboutFrame != null) {
            this.helpAboutFrame.closeWindow();
        }
        if (fileIni != null) {
            this.saveIni(fileIni);
        }
        this.dispose();
        spf = null;
        OneInstance.endCheckOtherInstances();
        if (this.pc.dbg) {
            System.out.println("System.exit(0);");
        }
        System.exit(0);
    }

    public void bringToFront() {
        if (this.pc.dbg) {
            System.out.println("---- bringToFront()");
        }
        if (spf == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!spf.isVisible()) {
                    spf.setVisible(true);
                }
                if (spf.getExtendedState() == 1 || spf.getExtendedState() == 6) {
                    spf.setExtendedState(0);
                }
                spf.setEnabled(true);
                spf.setAlwaysOnTop(true);
                spf.toFront();
                spf.requestFocus();
                spf.setAlwaysOnTop(false);
            }
        });
    }

    private void minimize() {
        if (this.pc.dbg) {
            System.out.println("---- minimize()");
        }
        if (spf != null && spf.isVisible()) {
            this.setExtendedState(1);
        }
    }

    void setCursorWait() {
        if (spf != null) {
            this.setCursor(new Cursor(3));
        }
        if (msgFrame != null && msgFrame.isShowing()) {
            msgFrame.setCursorWait();
        }
        if (this.modifyDiagramWindow != null && this.modifyDiagramWindow.isShowing()) {
            this.modifyDiagramWindow.setCursor(new Cursor(3));
        }
    }

    void setCursorDef() {
        if (spf != null) {
            this.setCursor(new Cursor(0));
        }
        if (msgFrame != null && msgFrame.isShowing()) {
            msgFrame.setCursorDef();
        }
        if (this.modifyDiagramWindow != null && this.modifyDiagramWindow.isShowing()) {
            this.modifyDiagramWindow.setCursor(new Cursor(0));
        }
    }

    protected boolean addDatFile(String datFileN) {
        String datFileNameFull;
        if (datFileN == null) {
            return false;
        }
        if (this.pc.dbg) {
            System.out.println("---- addDatFile(" + datFileN + ")");
        }
        if (!datFileN.toLowerCase().endsWith(".dat")) {
            Util.exceptn((String)("Data file name = \"" + datFileN.toLowerCase() + "\"" + nl + "Error: data file name must end with \".dat\""));
            return false;
        }
        File datFile = new File(datFileN);
        if (datFile.getName().length() <= 4) {
            Util.exceptn((String)"Error: file name must have at least one character");
            return false;
        }
        if (!datFile.exists()) {
            String msg = datFileN.startsWith("-") || datFileN.startsWith("/") ? "Error: \"" + datFileN + "\"" + nl + "   is neither a data file" + nl + "   nor a command-line switch." + nl + nl + "Enter: \"java -jar Spana.jar -?\"" + nl + "for a list of command-line options." : "Error: \"" + datFileN + "\"" + nl + "    is not an existing data file.";
            Util.showErrMsg((Component)this, (String)msg, (int)1);
            return false;
        }
        if (!datFile.canRead()) {
            String msg = "Error - can not read from file:" + nl + "   \"" + datFileN + "\"";
            System.out.println(msg);
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
            return false;
        }
        this.bringToFront();
        try {
            datFileNameFull = datFile.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                datFileNameFull = datFile.getAbsolutePath();
            }
            catch (Exception e) {
                datFileNameFull = datFile.getPath();
            }
        }
        datFile = new File(datFileNameFull);
        this.pc.setPathDef(datFile);
        datFileNameFull = datFileNameFull.substring(0, datFileNameFull.length() - 3) + "dat";
        if (this.dataFileArrList.size() > 0) {
            int i;
            int datFile_found = -1;
            for (i = 0; i < this.dataFileArrList.size(); ++i) {
                if (!this.dataFileArrList.get(i).equalsIgnoreCase(datFileNameFull)) continue;
                datFile_found = i;
                break;
            }
            if (datFile_found > -1) {
                i = datFile_found;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpanaFrame.this.jComboBox_Dat.setSelectedIndex(i);
                    }
                });
                return true;
            }
        }
        String fileName = datFileNameFull;
        this.dataFileArrList.add(fileName);
        this.jComboBox_Dat.addItem(this.makeObj(fileName));
        CardLayout cl = (CardLayout)this.getContentPane().getLayout();
        cl.show(this.getContentPane(), "cardPanel");
        this.jLabel_Dat.setVisible(true);
        this.jComboBox_Dat.setVisible(true);
        this.jComboBox_Dat.setSelectedIndex(this.jComboBox_Dat.getItemCount() - 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeDatFile(String datFileN) {
        int datFile_found;
        if (datFileN == null || datFileN.trim().length() <= 0) {
            return false;
        }
        if (this.pc.dbg) {
            System.out.println("---- removeDatFile(" + datFileN + ")");
        }
        if (this.dataFileArrList.size() > 0) {
            datFile_found = -1;
            for (int i = 0; i < this.dataFileArrList.size(); ++i) {
                if (!this.dataFileArrList.get(i).equalsIgnoreCase(datFileN)) continue;
                datFile_found = i;
                break;
            }
            if (datFile_found == -1) {
                return false;
            }
            SpanaFrame spanaFrame = this;
            synchronized (spanaFrame) {
                this.dataFileArrList.remove(datFile_found);
                this.jComboBox_Dat.removeItemAt(datFile_found);
                if (this.jComboBox_Dat.getItemCount() <= 0) {
                    this.jComboBox_Dat.setVisible(false);
                    this.jLabel_Dat.setVisible(false);
                }
            }
            System.out.println("Warning: file \"" + datFileN + "\"" + nl + "   does not exist any more. Name removed from list.");
        }
        if ((datFile_found = this.jComboBox_Dat.getItemCount()) > 0) {
            this.jComboBox_Dat.setSelectedIndex(datFile_found - 1);
        } else {
            this.jComboBox_Dat.setSelectedIndex(-1);
        }
        return true;
    }

    public void dispatchArg(String arg) {
        String pltFileName;
        String arg0;
        if (arg == null || arg.length() <= 0) {
            return;
        }
        System.out.println("Command-line argument = " + arg);
        if (arg.equals("-dbg") || arg.equals("/dbg")) {
            this.doNotExit = true;
            return;
        }
        if (arg.equals("-?") || arg.equals("/?") || arg.equals("?")) {
            SpanaFrame.printInstructions();
            this.doNotExit = true;
            return;
        }
        if (arg.length() > 3 && ((arg0 = arg.substring(0, 2).toLowerCase()).startsWith("-p") || arg0.startsWith("/p")) && (arg.charAt(2) == '=' || arg.charAt(2) == ':')) {
            pltFileName = arg.substring(3);
            if (pltFileName.length() > 2 && pltFileName.startsWith("\"") && pltFileName.endsWith("\"")) {
                pltFileName = pltFileName.substring(1, arg.length() - 1);
            }
            if (pltFileName.length() > 4 && pltFileName.toLowerCase().endsWith(".plt")) {
                if (this.pc.dbg) {
                    System.out.println("Print: " + pltFileName);
                }
                this.displayPlotFile(pltFileName, "print");
                return;
            }
        }
        if (arg.length() > 4 && ((arg0 = arg.substring(0, 3).toLowerCase()).startsWith("-ps") || arg0.startsWith("/ps")) && (arg.charAt(3) == '=' || arg.charAt(3) == ':')) {
            pltFileName = arg.substring(4);
            if (pltFileName.length() > 2 && pltFileName.startsWith("\"") && pltFileName.endsWith("\"")) {
                pltFileName = pltFileName.substring(1, arg.length() - 1);
            }
            if (pltFileName.length() > 4 && pltFileName.toLowerCase().endsWith(".plt")) {
                if (this.pc.dbg) {
                    System.out.println("Convert to PS: " + pltFileName);
                }
                DiagrConvert.doIt(null, 2, pltFileName, this.pd, this.pc);
                return;
            }
        }
        if (arg.length() > 5) {
            arg0 = arg.substring(0, 4).toLowerCase();
            pltFileName = arg.substring(5);
            if (arg.charAt(0) == '-' || arg.charAt(0) == '/') {
                String argType = arg0.substring(1, 4);
                boolean ok = false;
                for (String ext : FORMAT_NAMES) {
                    if (!argType.equalsIgnoreCase(ext)) continue;
                    ok = true;
                    break;
                }
                if ((argType.equals("eps") || argType.equals("pdf") || ok) && (arg.charAt(4) == '=' || arg.charAt(4) == ':')) {
                    if (pltFileName.length() > 2 && pltFileName.startsWith("\"") && pltFileName.endsWith("\"")) {
                        pltFileName = pltFileName.substring(1, arg.length() - 1);
                    }
                    if (pltFileName.length() > 4 && pltFileName.toLowerCase().endsWith(".plt")) {
                        if (this.pc.dbg) {
                            System.out.println("Convert to " + arg0.substring(1, 4).toUpperCase() + ": " + pltFileName);
                        }
                        if (argType.equals("pdf") || argType.equals("eps")) {
                            int typ = -1;
                            if (argType.equals("pdf")) {
                                typ = 1;
                            } else if (argType.equals("eps")) {
                                typ = 3;
                            }
                            DiagrConvert.doIt(null, typ, pltFileName, this.pd, this.pc);
                        } else {
                            this.displayPlotFile(pltFileName, argType);
                        }
                        return;
                    }
                }
            }
        }
        if (arg.length() > 2 && arg.startsWith("\"") && arg.endsWith("\"")) {
            arg = arg.substring(1, arg.length() - 1);
        }
        if (arg.toLowerCase().endsWith(".plt")) {
            this.minimize();
            if (!this.displayPlotFile(arg, null)) {
                this.bringToFront();
            }
            this.doNotExit = true;
            return;
        }
        if (arg.toLowerCase().endsWith(".dat")) {
            this.addDatFile(arg);
            this.doNotExit = true;
            return;
        }
        String msg = "Error: bad format for" + nl + "   command-line argument: \"" + arg + "\"";
        System.out.println(msg);
        SpanaFrame.printInstructions();
        JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
        String[] a = new String[]{"SP_Batch_Mode_htm"};
        RunProgr.runProgramInProcess((Component)this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)this.pc.dbg, (String)this.pc.pathAPP);
        this.doNotExit = true;
    }

    boolean displayPlotFile(final String pltFileN, String action) {
        String pltFileNameFull;
        File pltFile;
        if (pltFileN == null || pltFileN.trim().length() <= 0) {
            this.setExtendedState(0);
            Util.exceptn((String)"Error: pltFileN empty in method \"displayPlotFile\"");
            return false;
        }
        if (!pltFileN.toLowerCase().endsWith(".plt")) {
            this.setExtendedState(0);
            Util.exceptn((String)("Error: plot file name \"" + pltFileN + "\"" + nl + "   does not end with \".plt\"!"));
            return false;
        }
        if (this.pc.dbg) {
            System.out.println("diaplayPlotFile(" + pltFileN + ", " + action + ")");
        }
        if (!(pltFile = new File(pltFileN)).exists()) {
            this.bringToFront();
            String msg = pltFileN.startsWith("-") || pltFileN.startsWith("/") ? "Error: \"" + pltFileN + "\"" + nl + "   is neither a plot file" + nl + "   nor a command-line switch." + nl + nl + "Enter: \"java -jar Spana.jar -?\"" + nl + "for a list of command-line options." : "Error: \"" + pltFileN + "\"" + nl + "   is not an existing plot file.";
            Util.showErrMsg((Component)this, (String)msg, (int)1);
            return false;
        }
        if (!pltFile.canRead()) {
            this.setExtendedState(0);
            String msg = "Error - can not read file:" + nl + "  \"" + pltFile.getPath() + "\"";
            Util.showErrMsg((Component)this, (String)msg, (int)1);
            return false;
        }
        boolean printFile = false;
        boolean export = false;
        String actionLC = action != null && action.trim().length() > 0 ? action.toLowerCase() : null;
        if (actionLC != null) {
            if (actionLC.equals("print")) {
                printFile = true;
            } else {
                export = true;
            }
        }
        this.setCursorWait();
        try {
            pltFileNameFull = pltFile.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                pltFileNameFull = pltFile.getAbsolutePath();
            }
            catch (Exception e) {
                pltFileNameFull = pltFile.getPath();
            }
        }
        pltFileNameFull = pltFileNameFull.substring(0, pltFileNameFull.length() - 3) + "plt";
        pltFile = new File(pltFileNameFull);
        this.pc.setPathDef(pltFile);
        Window disp = null;
        if (this.diagrArrList.size() > 0) {
            int i;
            if (this.pc.dbg) {
                System.out.println("    diagrArrList not empty.");
            }
            int plt_found = -1;
            for (i = 0; i < this.diagrArrList.size(); ++i) {
                if (!this.diagrArrList.get((int)i).diagrFullName.equalsIgnoreCase(pltFileNameFull)) continue;
                plt_found = i;
                break;
            }
            if (plt_found > -1) {
                if (this.pc.dbg) {
                    System.out.println("    plot file found in the list.");
                }
                if ((disp = this.showDiagr(plt_found, printFile)) != null) {
                    i = plt_found;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpanaFrame.this.jComboBox_Plt_doNothing = true;
                            SpanaFrame.this.jComboBox_Plt.setSelectedIndex(i);
                            SpanaFrame.this.jComboBox_Plt_doNothing = false;
                        }
                    });
                }
            }
        }
        if (disp == null) {
            if (this.pc.dbg) {
                System.out.println("    plot file not found in the list. Adding.");
            }
            SpanaFrame.dispLocation.x += 20;
            SpanaFrame.dispLocation.y += 20;
            if (SpanaFrame.dispLocation.x > SpanaFrame.screenSize.width - SpanaFrame.dispSize.width) {
                SpanaFrame.dispLocation.x = 60;
            }
            if (SpanaFrame.dispLocation.y > SpanaFrame.screenSize.height - SpanaFrame.dispSize.height - 20) {
                SpanaFrame.dispLocation.y = 10;
            }
            disp = new Disp(this.diagrPaintUtil, this.pc, this.pd);
            ((Disp)disp).startPlotFile(pltFile);
            if (((Disp)disp).diagrName == null || ((Disp)disp).diagrName.trim().length() <= 0) {
                this.setCursorDef();
                return false;
            }
            this.jComboBox_Plt_doNothing = true;
            this.jComboBox_Plt.addItem(this.makeObj(pltFileNameFull));
            this.jComboBox_Plt_doNothing = false;
            this.diagrArrList.add((Disp)disp);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CardLayout cl = (CardLayout)SpanaFrame.this.getContentPane().getLayout();
                    cl.show(SpanaFrame.this.getContentPane(), "cardPanel");
                    SpanaFrame.this.jLabel_Plt.setVisible(true);
                    SpanaFrame.this.jComboBox_Plt.setVisible(true);
                    int i = SpanaFrame.this.jComboBox_Plt.getItemCount() - 1;
                    SpanaFrame.this.jComboBox_Plt_doNothing = true;
                    SpanaFrame.this.jComboBox_Plt.setSelectedIndex(i);
                    SpanaFrame.this.jComboBox_Plt_doNothing = false;
                }
            });
        }
        if (printFile) {
            Window fDisp = disp;
            this.setCursorWait();
            disp.setCursor(new Cursor(3));
            Thread printF = new Thread((Disp)fDisp){
                final /* synthetic */ Disp val$fDisp;
                {
                    this.val$fDisp = disp;
                }

                @Override
                public void run() {
                    if (((SpanaFrame)SpanaFrame.this).pc.dbg) {
                        System.out.println("Printing file: " + pltFileN);
                    }
                    this.val$fDisp.printDiagram(true);
                    SpanaFrame.this.waitingForPrinter = true;
                    SpanaFrame.this.notify_All();
                }
            };
            printF.start();
            this.synchWaitPrinted();
            this.waitingForPrinter = false;
        } else if (export) {
            this.setCursorWait();
            disp.setCursor(new Cursor(3));
            ((Disp)disp).export(actionLC, false);
        }
        this.setCursorDef();
        disp.setCursor(new Cursor(0));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removePltFile(String pltFileN) {
        int plt_found;
        if (pltFileN == null || pltFileN.trim().length() <= 0) {
            return false;
        }
        if (this.pc.dbg) {
            System.out.println("---- removePltFile(" + pltFileN + ")");
        }
        if (this.diagrArrList.size() > 0) {
            plt_found = -1;
            for (int i = 0; i < this.diagrArrList.size(); ++i) {
                if (!this.diagrArrList.get((int)i).diagrFullName.equalsIgnoreCase(pltFileN)) continue;
                plt_found = i;
                break;
            }
            if (plt_found == -1) {
                return false;
            }
            Disp gotDisp = this.diagrArrList.get(plt_found);
            Frame[] f = Disp.getFrames();
            int foundFrame = -1;
            for (int i = 0; i < f.length; ++i) {
                if (!f[i].equals(gotDisp)) continue;
                foundFrame = i;
                break;
            }
            if (foundFrame > 0) {
                spf.bringToFront();
                this.jPanel1.requestFocusInWindow();
                if (gotDisp.isVisible()) {
                    int n = JOptionPane.showConfirmDialog(spf, "Plot file \"" + gotDisp.diagrFullName + "\"" + nl + "does NOT EXIST anymore!" + nl + nl + "The diagram window will be closed" + nl + "and the name removed from the list.", this.pc.progName, 2, 0);
                    if (n != 0) {
                        return false;
                    }
                    if ((gotDisp.getExtendedState() & 1) == 1) {
                        gotDisp.setExtendedState(0);
                    }
                    gotDisp.setVisible(false);
                }
                gotDisp.dispose();
            }
            SpanaFrame spanaFrame = this;
            synchronized (spanaFrame) {
                this.diagrArrList.remove(plt_found);
                this.jComboBox_Plt_doNothing = true;
                this.jComboBox_Plt.removeItemAt(plt_found);
                if (this.jComboBox_Plt.getItemCount() <= 0) {
                    this.jComboBox_Plt.setVisible(false);
                    this.jLabel_Plt.setVisible(false);
                }
                this.jComboBox_Plt_doNothing = false;
            }
            System.out.println("Warning: file \"" + pltFileN + "\"" + nl + "   does not exist any more. Name removed from list.");
        }
        if ((plt_found = this.jComboBox_Plt.getItemCount()) > 0) {
            this.jComboBox_Plt.setSelectedIndex(plt_found - 1);
        } else {
            this.jComboBox_Plt.setSelectedIndex(-1);
        }
        return true;
    }

    private void modifyDataFile() {
        this.setCursorWait();
        if (this.pc.dbg) {
            System.out.println("---- modifyDataFile()");
        }
        if (this.dataFileArrList.size() <= 0) {
            String fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Open data file", (int)5, null, (String)this.pc.pathDef.toString());
            if (fileName == null) {
                this.setCursorDef();
                return;
            }
            if (!this.addDatFile(fileName)) {
                this.setCursorDef();
                return;
            }
        }
        this.setCursorWait();
        final File datFile = new File(this.jComboBox_Dat.getSelectedItem().toString());
        this.jMenu_Prefs_General.setEnabled(false);
        this.jMenu_Run_Modif.setEnabled(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                SpanaFrame.this.modifyDiagramWindow = new ModifyChemSyst(SpanaFrame.this.pc, SpanaFrame.this.pd);
                SpanaFrame.this.modifyDiagramWindow.startDataFile(datFile);
                SpanaFrame.this.setCursorDef();
                SpanaFrame.this.modifyDiagramWindow.waitForModifyChemSyst();
                return null;
            }

            @Override
            protected void done() {
                SpanaFrame.this.jMenu_Run_Modif.setEnabled(true);
                SpanaFrame.this.jMenu_Prefs_General.setEnabled(true);
                SpanaFrame.this.modifyDiagramWindow = null;
            }
        }.execute();
    }

    private void run_Database() {
        if (this.pc.dbg) {
            System.out.println("---- run_Database()");
        }
        String msg = null;
        if (createDataFileProg != null && createDataFileProg.trim().length() > 0) {
            File f = new File(createDataFileProg);
            if (!f.exists()) {
                msg = "Error: the program to create input data files:" + nl + "  \"" + createDataFileProg + "\"" + nl + "  does not exist.";
            }
        } else {
            msg = "Error:" + nl + "no name given for the program" + nl + "to create input data files.";
        }
        if (msg != null) {
            Util.exceptn((String)msg);
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
            this.setCursorDef();
            return;
        }
        this.jMenu_Run_Database.setEnabled(false);
        this.jMenu_Data_New.setEnabled(false);
        Thread runDatabase = new Thread(){

            @Override
            public void run() {
                String d = ((SpanaFrame)SpanaFrame.this).pc.pathDef.toString();
                if (d.endsWith("\\")) {
                    d = d + " ";
                }
                Object[] argsDatabase = new String[]{d};
                boolean waitForCompletion = false;
                if (((SpanaFrame)SpanaFrame.this).pc.dbg) {
                    System.out.println("---- runProgramInProcess:" + nl + "     " + createDataFileProg + nl + "     " + Arrays.toString(argsDatabase) + nl + "     wait = " + waitForCompletion + ", dbg = " + ((SpanaFrame)SpanaFrame.this).pc.dbg + nl + "     path = " + ((SpanaFrame)SpanaFrame.this).pc.pathAPP);
                }
                RunProgr.runProgramInProcess((Component)SpanaFrame.this, (String)createDataFileProg, (String[])argsDatabase, (boolean)waitForCompletion, (boolean)((SpanaFrame)SpanaFrame.this).pc.dbg, (String)((SpanaFrame)SpanaFrame.this).pc.pathAPP);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpanaFrame.this.jMenu_Run_Database.setEnabled(true);
                        SpanaFrame.this.jMenu_Data_New.setEnabled(true);
                        spf.setCursorDef();
                    }
                });
            }
        };
        runDatabase.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Disp showDiagr(int k, boolean printFile) {
        if (k < 0 || this.diagrArrList.size() <= 0 || this.jComboBox_Plt.getItemCount() <= 0) {
            return null;
        }
        if (this.pc.dbg) {
            System.out.println("---- showDiagr(" + k + ")");
        }
        Disp gotDisp = this.diagrArrList.get(k);
        Frame[] f = Disp.getFrames();
        int foundFrame = -1;
        for (int i = 0; i < f.length; ++i) {
            if (!f[i].equals(gotDisp)) continue;
            foundFrame = i;
            break;
        }
        if (foundFrame > 0) {
            if ((gotDisp.getExtendedState() & 1) == 1) {
                gotDisp.setExtendedState(0);
            }
            gotDisp.setVisible(true);
            gotDisp.toFront();
            gotDisp.requestFocus();
            gotDisp.reloadPlotFile();
            gotDisp.repaint();
            if (printFile) {
                gotDisp.printDiagram(true);
            }
            return gotDisp;
        }
        SpanaFrame spanaFrame = this;
        synchronized (spanaFrame) {
            this.diagrArrList.remove(k);
            this.jComboBox_Plt_doNothing = true;
            this.jComboBox_Plt.removeItemAt(k);
            if (this.jComboBox_Plt.getItemCount() <= 0) {
                this.jComboBox_Plt.setVisible(false);
                this.jLabel_Plt.setVisible(false);
            }
            this.jComboBox_Plt_doNothing = false;
        }
        return null;
    }

    private void readIni() {
        boolean ok;
        File fileINInotRO;
        boolean readOk;
        File fileRead;
        block29: {
            String home;
            File p;
            block28: {
                block32: {
                    block31: {
                        block30: {
                            block27: {
                                this.iniDefaults();
                                fileRead = null;
                                readOk = false;
                                fileIni = null;
                                fileINInotRO = null;
                                if (this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0) break block27;
                                if (!this.pc.iniFileToApplicationPath) break block28;
                                String name = "\"null\"" + SLASH + FileINI_NAME;
                                Util.exceptn((String)("Can not read ini file" + nl + "    \"" + name + "\""));
                                break block29;
                            }
                            String dir = this.pc.pathAPP;
                            if (dir != null) {
                                if (dir.endsWith(SLASH)) {
                                    dir = dir.substring(0, dir.length() - 1);
                                }
                                fileIni = new File(dir + SLASH + FileINI_NAME);
                                p = new File(this.pc.pathAPP);
                            } else {
                                fileIni = new File(FileINI_NAME);
                                p = new File("");
                            }
                            if (p.exists()) break block30;
                            if (!this.pc.iniFileToApplicationPath) break block28;
                            Util.exceptn((String)("Can not read ini file:" + nl + "    \"" + fileIni.getPath() + "\""));
                            fileIni = null;
                            break block29;
                        }
                        if (!this.pc.iniFileToApplicationPath) break block31;
                        if (fileIni.exists()) {
                            readOk = this.readIni2(fileIni);
                        }
                        if (readOk) {
                            fileRead = fileIni;
                        }
                        fileINInotRO = fileIni;
                        break block29;
                    }
                    if (!fileIni.exists()) break block32;
                    readOk = this.readIni2(fileIni);
                    if (readOk) {
                        fileRead = fileIni;
                    }
                    if (!fileIni.canWrite()) break block28;
                    fileINInotRO = fileIni;
                    if (!readOk) break block28;
                    break block29;
                }
                try {
                    File tmp = File.createTempFile("spana", ".tmp", p);
                    ok = tmp.exists();
                    if (ok) {
                        tmp.delete();
                    }
                }
                catch (IOException ex) {
                    ok = false;
                }
                if (ok && fileINInotRO == null) {
                    fileINInotRO = fileIni;
                }
            }
            ArrayList<String> dirs = new ArrayList<String>(5);
            String appD = System.getenv("APPDATA");
            if (appD != null && appD.trim().length() > 0 && (p = new File(appD)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            String homeDrv = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homePath != null && homePath.trim().length() > 0 && !homePath.startsWith(SLASH)) {
                homePath = SLASH + homePath;
            }
            if (homeDrv != null && homeDrv.trim().length() > 0 && homeDrv.endsWith(SLASH)) {
                homeDrv = homeDrv.substring(0, homeDrv.length() - 1);
            }
            if (homeDrv != null && homeDrv.trim().length() > 0 && homePath != null && homePath.trim().length() > 0 && (p = new File(homeDrv + homePath)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            if ((home = System.getenv("HOME")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            if ((home = System.getProperty("user.home")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            for (String t : dirs) {
                if (t.endsWith(SLASH)) {
                    t = t.substring(0, t.length() - 1);
                }
                if ((fileIni = new File(t + SLASH + FileINI_NAME)).exists()) {
                    readOk = this.readIni2(fileIni);
                    if (readOk) {
                        fileRead = fileIni;
                    }
                    if (!fileIni.canWrite()) continue;
                    if (fileINInotRO == null) {
                        fileINInotRO = fileIni;
                    }
                    if (!readOk) continue;
                    break;
                }
                try {
                    p = new File(t);
                    File tmp = File.createTempFile("spana", ".tmp", p);
                    ok = tmp.exists();
                    if (ok) {
                        tmp.delete();
                    }
                }
                catch (IOException ex) {
                    ok = false;
                }
                if (!ok || fileINInotRO != null) continue;
                fileINInotRO = fileIni;
            }
        }
        if (!readOk) {
            String t = "Failed to read any INI-file." + nl + "Default program settings will be used.";
            System.out.println(t);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            JOptionPane.showMessageDialog(spf, t, this.pc.progName, 1);
        }
        if (fileINInotRO != null && fileINInotRO != fileRead) {
            ok = this.saveIni(fileINInotRO);
            fileIni = ok ? fileINInotRO : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readIni2(File f) {
        String msg;
        System.out.flush();
        System.out.println("Reading ini-file: \"" + f.getPath() + "\"");
        Properties propertiesIni = new Properties();
        FileInputStream properties_iniFile = null;
        boolean ok = true;
        try {
            properties_iniFile = new FileInputStream(f);
            propertiesIni.load(properties_iniFile);
        }
        catch (FileNotFoundException e) {
            String t = "Warning: file Not found: \"" + f.getPath() + "\"" + nl + "using default parameter values.";
            System.out.println(t);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            JOptionPane.showMessageDialog(spf, t, this.pc.progName, 1);
            ok = false;
        }
        catch (IOException e) {
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while loading INI-file:" + nl + "   \"" + f.getPath() + "\"";
            System.out.println(msg);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            JOptionPane.showMessageDialog(spf, msg, this.pc.progName, 0);
            ok = false;
        }
        try {
            if (properties_iniFile != null) {
                properties_iniFile.close();
            }
        }
        catch (IOException e) {
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while closing INI-file:" + nl + "   \"" + f.getPath() + "\"";
            System.out.println(msg);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            JOptionPane.showMessageDialog(spf, msg, this.pc.progName, 0);
            ok = false;
        }
        finally {
            try {
                if (properties_iniFile != null) {
                    properties_iniFile.close();
                }
            }
            catch (IOException e) {
                msg = "Error: \"" + e.toString() + "\"" + nl + "   while closing INI-file:" + nl + "   \"" + f.getPath() + "\"";
                System.out.println(msg);
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                JOptionPane.showMessageDialog(spf, msg, this.pc.progName, 0);
            }
        }
        if (!ok) {
            return ok;
        }
        try {
            int blue;
            int green;
            SpanaFrame.locationFrame.x = Integer.parseInt(propertiesIni.getProperty("Location_left"));
            SpanaFrame.locationFrame.y = Integer.parseInt(propertiesIni.getProperty("Location_top"));
            SpanaFrame.msgFrameSize.width = Integer.parseInt(propertiesIni.getProperty("LogFrame_Width"));
            SpanaFrame.msgFrameSize.height = Integer.parseInt(propertiesIni.getProperty("LogFrame_Height"));
            SpanaFrame.locationMsgFrame.x = Integer.parseInt(propertiesIni.getProperty("LogFrame_left"));
            SpanaFrame.locationMsgFrame.y = Integer.parseInt(propertiesIni.getProperty("LogFrame_top"));
            SpanaFrame.dispSize.width = Integer.parseInt(propertiesIni.getProperty("Disp_Width"));
            SpanaFrame.dispSize.height = Integer.parseInt(propertiesIni.getProperty("Disp_Height"));
            SpanaFrame.dispLocation.x = Integer.parseInt(propertiesIni.getProperty("Disp_left"));
            SpanaFrame.dispLocation.y = Integer.parseInt(propertiesIni.getProperty("Disp_top"));
            this.diagrPaintUtil.keepAspectRatio = Boolean.parseBoolean(propertiesIni.getProperty("Disp_KeepAspectRatio"));
            this.diagrPaintUtil.fixedSize = Boolean.parseBoolean(propertiesIni.getProperty("Disp_FixedSize"));
            this.diagrPaintUtil.fixedSizeWidth = Float.parseFloat(propertiesIni.getProperty("Disp_FixedSizeWidth"));
            this.diagrPaintUtil.fixedSizeHeight = Float.parseFloat(propertiesIni.getProperty("Disp_FixedSizeHeight"));
            this.diagrPaintUtil.fontFamily = Integer.parseInt(propertiesIni.getProperty("Disp_FontFamily"));
            this.diagrPaintUtil.fontStyle = Integer.parseInt(propertiesIni.getProperty("Disp_FontStyle"));
            this.diagrPaintUtil.fontSize = Integer.parseInt(propertiesIni.getProperty("Disp_FontSize"));
            String anti = propertiesIni.getProperty("Disp_AntialiasingText");
            this.diagrPaintUtil.antiAliasingText = anti.toLowerCase().equals("on") ? 1 : (anti.toLowerCase().equals("default") ? 2 : 0);
            anti = propertiesIni.getProperty("Disp_Antialiasing");
            this.diagrPaintUtil.antiAliasing = anti.toLowerCase().equals("on") ? 1 : (anti.toLowerCase().equals("default") ? 2 : 0);
            this.diagrPaintUtil.penThickness = Float.parseFloat(propertiesIni.getProperty("Disp_PenThickness"));
            if (this.pc.pathDef.length() > 0) {
                this.pc.pathDef.delete(0, this.pc.pathDef.length());
            }
            this.pc.pathDef.append(propertiesIni.getProperty("defaultPath"));
            txtEditor = propertiesIni.getProperty("txtEditor");
            pathSedPredom = propertiesIni.getProperty("pathSedPredom");
            createDataFileProg = propertiesIni.getProperty("createDataFileProg");
            this.pd.advancedVersion = Boolean.parseBoolean(propertiesIni.getProperty("advancedVersion"));
            for (int ii = 0; ii < 11; ++ii) {
                String[] colrs = propertiesIni.getProperty("Disp_Colour[" + ii + "]").split(",");
                int red = colrs.length > 0 ? Integer.parseInt(colrs[0]) : 0;
                green = colrs.length > 1 ? Integer.parseInt(colrs[1]) : 0;
                blue = colrs.length > 2 ? Integer.parseInt(colrs[2]) : 0;
                red = Math.max(0, Math.min(255, red));
                green = Math.max(0, Math.min(255, green));
                blue = Math.max(0, Math.min(255, blue));
                this.diagrPaintUtil.colours[ii] = new Color(red, green, blue);
            }
            this.diagrPaintUtil.colourType = Integer.parseInt(propertiesIni.getProperty("Disp_ColourType"));
            this.diagrPaintUtil.printColour = Boolean.parseBoolean(propertiesIni.getProperty("Disp_PrintColour"));
            this.diagrPaintUtil.printHeader = Boolean.parseBoolean(propertiesIni.getProperty("Disp_PrintHeader"));
            this.diagrPaintUtil.textWithFonts = Boolean.parseBoolean(propertiesIni.getProperty("Disp_TextWithFonts"));
            this.diagrPaintUtil.printPenThickness = Float.parseFloat(propertiesIni.getProperty("Disp_PrintPenThickness"));
            this.diagrPaintUtil.useBackgrndColour = Boolean.parseBoolean(propertiesIni.getProperty("Disp_UseBackgrndColour"));
            String[] colrs = propertiesIni.getProperty("Disp_BackgroundColour").split(",");
            int red = colrs.length > 0 ? Integer.parseInt(colrs[0]) : 0;
            green = colrs.length > 1 ? Integer.parseInt(colrs[1]) : 0;
            blue = colrs.length > 2 ? Integer.parseInt(colrs[2]) : 0;
            red = Math.max(0, Math.min(255, red));
            green = Math.max(0, Math.min(255, green));
            blue = Math.max(0, Math.min(255, blue));
            this.diagrPaintUtil.backgrnd = new Color(red, green, blue);
            this.pd.fractionThreshold = Float.parseFloat(propertiesIni.getProperty("Disp_FractionThreshold"));
            this.pd.keepFrame = Boolean.parseBoolean(propertiesIni.getProperty("Calc_keepFrame"));
            this.pd.SED_nbrSteps = Integer.parseInt(propertiesIni.getProperty("Calc_SED_nbrSteps"));
            this.pd.SED_tableOutput = Boolean.parseBoolean(propertiesIni.getProperty("Calc_SED_tableOutput"));
            this.pd.Predom_nbrSteps = Integer.parseInt(propertiesIni.getProperty("Calc_Predom_nbrSteps"));
            this.pd.ionicStrength = Double.parseDouble(propertiesIni.getProperty("Calc_ionicStrength"));
            this.pd.actCoeffsMethod = Integer.parseInt(propertiesIni.getProperty("Calc_activityCoefficientsMethod"));
            this.pd.pathSIT = propertiesIni.getProperty("Calc_pathSIT");
            this.pd.temperature = Double.parseDouble(propertiesIni.getProperty("Calc_temperature"));
            this.pd.aquSpeciesOnly = Boolean.parseBoolean(propertiesIni.getProperty("Calc_Predom_aquSpeciesOnly"));
            this.pd.reversedConcs = Boolean.parseBoolean(propertiesIni.getProperty("Calc_allowReversedConcRanges"));
            this.pd.useEh = Boolean.parseBoolean(propertiesIni.getProperty("Calc_useEh"));
            this.pd.calcDbg = Boolean.parseBoolean(propertiesIni.getProperty("Calc_dbg"));
            this.pd.calcDbgHalta = Integer.parseInt(propertiesIni.getProperty("Calc_dbgHalta"));
            this.pd.tolHalta = Double.parseDouble(propertiesIni.getProperty("Calc_tolerance"));
            this.pd.tblExtension = propertiesIni.getProperty("Calc_tableFileExt");
            String t = propertiesIni.getProperty("Calc_tableFieldSeparatorChar");
            this.pd.tblFieldSeparator = t != null && t.length() >= 2 && t.substring(0, 1).equalsIgnoreCase("\\t") ? (char)9 : (t != null ? t.charAt(0) : (char)59);
            t = propertiesIni.getProperty("Calc_tableCommentLineStart");
            this.pd.tblCommentLineStart = t != null ? t : "\"";
            t = propertiesIni.getProperty("Calc_tableCommentLineEnd");
            this.pd.tblCommentLineEnd = t != null ? t : "\"";
            this.pd.diagrConvertSizeX = Integer.parseInt(propertiesIni.getProperty("Convert_SizeX"));
            this.pd.diagrConvertSizeY = Integer.parseInt(propertiesIni.getProperty("Convert_SizeY"));
            this.pd.diagrConvertMarginB = Float.parseFloat(propertiesIni.getProperty("Convert_MarginBottom"));
            this.pd.diagrConvertMarginL = Float.parseFloat(propertiesIni.getProperty("Convert_MarginLeft"));
            this.pd.diagrConvertPortrait = Boolean.parseBoolean(propertiesIni.getProperty("Convert_Portrait"));
            this.pd.diagrConvertHeader = Boolean.parseBoolean(propertiesIni.getProperty("Convert_Header"));
            this.pd.diagrConvertColors = Boolean.parseBoolean(propertiesIni.getProperty("Convert_Colour"));
            this.pd.diagrConvertFont = Integer.parseInt(propertiesIni.getProperty("Convert_Font"));
            this.pd.diagrConvertEPS = Boolean.parseBoolean(propertiesIni.getProperty("Convert_EPS"));
            this.pd.diagrExportType = propertiesIni.getProperty("Export_To");
            this.pd.diagrExportSize = Integer.parseInt(propertiesIni.getProperty("Export_Size"));
        }
        catch (NumberFormatException e) {
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while reading INI-file:" + nl + "   \"" + f.getPath() + "\"" + nl + nl + "Setting default program parameters.";
            System.out.println(msg);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            JOptionPane.showMessageDialog(spf, msg, this.pc.progName, 0);
            ok = false;
        }
        try {
            this.pd.drawNeutralPHinPourbaix = Boolean.parseBoolean(propertiesIni.getProperty("Calc_draw_pH_line"));
            String s = propertiesIni.getProperty("lookAndFeel").toLowerCase();
            this.laf = s.startsWith("system") ? 1 : (s.startsWith("cross") ? 2 : 0);
        }
        catch (NullPointerException e) {
            this.laf = 0;
            this.pd.drawNeutralPHinPourbaix = false;
        }
        if (this.pc.dbg) {
            System.out.println("Finished reading ini-file");
        }
        System.out.flush();
        this.checkIniValues();
        return ok;
    }

    private void checkIniValues() {
        String sit;
        File currentDir;
        System.out.flush();
        System.out.println(LINE + nl + "Checking ini-values.");
        if (SpanaFrame.locationFrame.x < -1 || SpanaFrame.locationFrame.y < -1) {
            SpanaFrame.locationFrame.x = Math.max(0, (SpanaFrame.screenSize.width - this.getWidth()) / 2);
            SpanaFrame.locationFrame.y = Math.max(0, (SpanaFrame.screenSize.height - this.getHeight()) / 2);
        }
        if (!(currentDir = new File(this.pc.pathDef.toString())).exists()) {
            this.pc.setPathDef();
        }
        if (txtEditor == null || txtEditor.trim().length() <= 0) {
            if (windows) {
                String t = windir;
                if (t != null && t.endsWith(SLASH)) {
                    t = t.substring(0, t.length() - 1);
                }
                t = t != null ? t + SLASH + "Notepad.exe" : "Notepad.exe";
                txtEditor = t;
            } else {
                txtEditor = System.getProperty("os.name").startsWith("Mac OS") ? "/usr/bin/open -t" : "/usr/bin/gedit";
            }
            System.out.println("Note: setting editor = \"" + txtEditor + "\"");
        }
        File f = new File(txtEditor);
        if (!System.getProperty("os.name").startsWith("Mac OS") && !f.exists()) {
            System.out.println("Warning: the text editor \"" + txtEditor + "\"" + nl + "   in the INI-file does not exist.");
        }
        File d = null;
        String dir = this.pc.pathAPP;
        if (dir != null && dir.endsWith(SLASH)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (!(pathSedPredom == null || pathSedPredom.trim().length() <= 0 || (d = new File(pathSedPredom)).exists() && d.isDirectory())) {
            System.out.println("Warning: path \"" + pathSedPredom + "\"" + nl + "   in the INI-file does not exist (or is not a directory).");
            d = null;
        }
        if (d == null || !d.exists() || !d.isDirectory()) {
            pathSedPredom = this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0 ? this.pc.pathAPP : System.getProperty("user.dir");
            d = new File(pathSedPredom);
        }
        String msg = null;
        if (!Div.progSEDexists((File)d)) {
            msg = " SED";
        }
        if (!Div.progPredomExists((File)d)) {
            msg = msg == null ? " Predom" : "s SED and Predom";
        }
        if (msg != null && pathSedPredom != null) {
            System.out.println("Warning: directory \"" + pathSedPredom + "\"" + nl + "   in the INI-file does not contain program" + msg);
            pathSedPredom = this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0 ? this.pc.pathAPP : System.getProperty("user.dir");
        }
        if ((f = createDataFileProg != null && createDataFileProg.trim().length() > 0 ? new File(createDataFileProg) : null) == null || !f.exists()) {
            String s = createDataFileProg;
            if (s == null) {
                s = "null";
            }
            System.out.println("Warning: file \"" + s + "\"" + nl + "  (the program to create input data files)" + nl + "  given in the INI-file does not exist.");
            this.getDatabaseProgr(true);
        }
        d = null;
        if (!(this.pd.pathSIT == null || this.pd.pathSIT.trim().length() <= 0 || (d = new File(this.pd.pathSIT)).exists() && d.isDirectory())) {
            System.out.println("Warning: path \"" + this.pd.pathSIT + "\"" + nl + "   where file \"SIT-coefficients.dta\" should be found" + nl + "   in the INI-file does not exist (or is not a directory).");
            d = null;
        }
        if (d == null || !d.exists() || !d.isDirectory()) {
            this.pd.pathSIT = this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0 ? this.pc.pathAPP : System.getProperty("user.dir");
        }
        if ((sit = this.pd.pathSIT) != null && sit.trim().length() > 0) {
            if (sit.endsWith(SLASH)) {
                sit = sit.substring(0, sit.length() - 1);
            }
            if (!(f = new File(sit = sit + SLASH + "SIT-coefficients.dta")).exists()) {
                System.out.println("Warning: directory \"" + this.pd.pathSIT + "\"" + nl + "   in the INI-file does not contain file: \"SIT-coefficients.dta\".");
            }
        }
        this.diagrPaintUtil.fixedSizeHeight = Math.max(1.0f, Math.min(99.0f, this.diagrPaintUtil.fixedSizeHeight));
        this.diagrPaintUtil.fixedSizeWidth = Math.max(1.0f, Math.min(99.0f, this.diagrPaintUtil.fixedSizeWidth));
        this.diagrPaintUtil.colourType = Math.max(0, Math.min(2, this.diagrPaintUtil.colourType));
        this.diagrPaintUtil.antiAliasing = Math.max(0, Math.min(2, this.diagrPaintUtil.antiAliasing));
        this.diagrPaintUtil.antiAliasingText = Math.max(0, Math.min(2, this.diagrPaintUtil.antiAliasingText));
        this.diagrPaintUtil.penThickness = Math.max(0.2f, Math.min(this.diagrPaintUtil.penThickness, 10.0f));
        this.diagrPaintUtil.printPenThickness = Math.max(1.0f, Math.min(this.diagrPaintUtil.printPenThickness, 5.0f));
        this.diagrPaintUtil.fontFamily = Math.max(0, Math.min(this.diagrPaintUtil.fontFamily, 4));
        this.diagrPaintUtil.fontStyle = Math.max(0, Math.min(this.diagrPaintUtil.fontStyle, 2));
        this.diagrPaintUtil.fontSize = Math.max(1, Math.min(this.diagrPaintUtil.fontSize, 72));
        this.pd.fractionThreshold = Math.max(0.001f, Math.min(this.pd.fractionThreshold, 0.1f));
        boolean backgrndDark = false;
        if (Math.sqrt(Math.pow(this.diagrPaintUtil.backgrnd.getRed(), 2.0) + Math.pow(this.diagrPaintUtil.backgrnd.getGreen(), 2.0) + Math.pow(this.diagrPaintUtil.backgrnd.getBlue(), 2.0)) < 221.0) {
            backgrndDark = true;
        }
        for (int i = 0; i < 11; ++i) {
            if (!SpanaFrame.twoColoursEqual(this.diagrPaintUtil.backgrnd, this.diagrPaintUtil.colours[i])) continue;
            this.diagrPaintUtil.colours[i] = backgrndDark ? new Color(200, 200, 200) : new Color(100, 100, 100);
        }
        this.pd.SED_nbrSteps = Math.max(4, Math.min(1000, this.pd.SED_nbrSteps));
        this.pd.Predom_nbrSteps = Math.max(4, Math.min(1000, this.pd.Predom_nbrSteps));
        this.pd.ionicStrength = Math.max(-100.0, Math.min(1000.0, this.pd.ionicStrength));
        this.pd.temperature = Math.max(-50.0, Math.min(400.0, this.pd.temperature));
        this.pd.actCoeffsMethod = Math.max(0, Math.min(2, this.pd.actCoeffsMethod));
        this.pd.calcDbgHalta = Math.max(0, Math.min(7, this.pd.calcDbgHalta));
        this.pd.tolHalta = Math.max(1.0E-9, Math.min(0.01, this.pd.tolHalta));
        boolean found = false;
        if (this.pd.tblExtension != null && this.pd.tblExtension.length() == 3) {
            for (String tblExtension_type : this.pd.tblExtension_types) {
                if (!this.pd.tblExtension.equalsIgnoreCase(tblExtension_type)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            this.pd.tblExtension = this.pd.tblExtension_types[0];
        }
        for (int i = 0; i < this.pd.tblFieldSeparator_types.length; ++i) {
            if (this.pd.tblFieldSeparator != this.pd.tblFieldSeparator_types[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            this.pd.tblFieldSeparator = this.pd.tblFieldSeparator_types[0];
        }
        this.pd.diagrConvertSizeX = Math.max(20, Math.min(300, this.pd.diagrConvertSizeX));
        this.pd.diagrConvertSizeY = Math.max(20, Math.min(300, this.pd.diagrConvertSizeY));
        this.pd.diagrConvertMarginB = Math.max(-5.0f, Math.min(21.0f, this.pd.diagrConvertMarginB));
        this.pd.diagrConvertMarginL = Math.max(-5.0f, Math.min(21.0f, this.pd.diagrConvertMarginL));
        this.pd.diagrConvertFont = Math.max(0, Math.min(3, this.pd.diagrConvertFont));
        boolean fnd = false;
        for (String t : FORMAT_NAMES) {
            if (!t.equalsIgnoreCase(this.pd.diagrExportType)) continue;
            fnd = true;
            break;
        }
        if (!fnd) {
            this.pd.diagrExportType = FORMAT_NAMES[0];
        }
        this.pd.diagrExportSize = Math.max(2, Math.min(5000, this.pd.diagrExportSize));
        this.laf = Math.min(2, Math.max(0, this.laf));
        System.out.println(LINE);
        System.out.flush();
    }

    public static boolean twoColoursEqual(Color A, Color B) {
        if (Math.abs(A.getRed() - B.getRed()) > 25) {
            return false;
        }
        if (Math.abs(A.getGreen() - B.getGreen()) > 25) {
            return false;
        }
        return Math.abs(A.getBlue() - B.getBlue()) <= 25;
    }

    public void iniDefaults() {
        String dir;
        if (this.pc.dbg) {
            System.out.flush();
            System.out.println("Setting default parameter values (\"ini\"-values).");
        }
        SpanaFrame.locationFrame.x = Math.max(0, (SpanaFrame.screenSize.width - this.getWidth()) / 2);
        SpanaFrame.locationFrame.y = Math.max(0, (SpanaFrame.screenSize.height - this.getHeight()) / 2);
        SpanaFrame.msgFrameSize.width = 500;
        SpanaFrame.msgFrameSize.height = 400;
        SpanaFrame.locationMsgFrame.x = 80;
        SpanaFrame.locationMsgFrame.y = 30;
        SpanaFrame.dispSize.width = 400;
        SpanaFrame.dispSize.height = 350;
        SpanaFrame.dispLocation.x = 60;
        SpanaFrame.dispLocation.y = 30;
        this.pc.setPathDef();
        this.pd.advancedVersion = false;
        txtEditor = null;
        if (windows) {
            dir = windir;
            if (dir != null) {
                File f;
                if (dir.endsWith(SLASH)) {
                    dir = dir.substring(0, dir.length() - 1);
                }
                if (!(f = new File(txtEditor = dir + SLASH + "Notepad.exe")).exists()) {
                    txtEditor = "Notepad.exe";
                }
            } else {
                txtEditor = "Notepad.exe";
            }
        } else if (System.getProperty("os.name").startsWith("Mac OS")) {
            txtEditor = "/usr/bin/open -t";
        } else {
            txtEditor = "/usr/bin/gedit";
            File f = new File(txtEditor);
            if (!f.exists()) {
                txtEditor = null;
            }
        }
        dir = this.pc.pathAPP;
        pathSedPredom = dir != null && dir.trim().length() > 0 ? dir : System.getProperty("user.dir");
        this.getDatabaseProgr(false);
        this.pd.actCoeffsMethod = 2;
        this.pd.advancedVersion = false;
        this.pd.aquSpeciesOnly = false;
        this.pd.calcDbg = false;
        this.pd.calcDbgHalta = 0;
        this.pd.tolHalta = 1.0E-5;
        this.pd.ionicStrength = 0.0;
        this.pd.keepFrame = false;
        this.pd.pathSIT = this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0 ? this.pc.pathAPP : ".";
        this.pd.reversedConcs = false;
        this.pd.drawNeutralPHinPourbaix = false;
        this.pd.temperature = 25.0;
        this.pd.useEh = true;
        this.pd.SED_nbrSteps = 50;
        this.pd.SED_tableOutput = false;
        this.pd.Predom_nbrSteps = 100;
        this.pd.tblExtension = "csv";
        this.pd.tblFieldSeparator = (char)59;
        this.pd.tblCommentLineStart = "\"";
        this.pd.tblCommentLineEnd = "\"";
        this.diagrPaintUtil.keepAspectRatio = false;
        this.diagrPaintUtil.fixedSize = false;
        this.diagrPaintUtil.fixedSizeHeight = 15.0f;
        this.diagrPaintUtil.fixedSizeWidth = 21.0f;
        this.diagrPaintUtil.antiAliasing = 1;
        this.diagrPaintUtil.antiAliasingText = 1;
        this.diagrPaintUtil.colourType = 0;
        this.diagrPaintUtil.printColour = true;
        this.diagrPaintUtil.penThickness = 1.0f;
        this.diagrPaintUtil.printHeader = true;
        this.diagrPaintUtil.printPenThickness = 1.0f;
        this.diagrPaintUtil.fontFamily = 1;
        this.diagrPaintUtil.fontStyle = 0;
        this.diagrPaintUtil.fontSize = 9;
        this.diagrPaintUtil.useBackgrndColour = false;
        this.diagrPaintUtil.backgrnd = Color.white;
        this.diagrPaintUtil.textWithFonts = true;
        this.pd.fractionThreshold = 0.03f;
        this.pd.diagrConvertSizeX = 90;
        this.pd.diagrConvertSizeY = 90;
        this.pd.diagrConvertMarginB = 1.0f;
        this.pd.diagrConvertMarginL = 1.0f;
        this.pd.diagrConvertPortrait = true;
        this.pd.diagrConvertHeader = true;
        this.pd.diagrConvertColors = true;
        this.pd.diagrConvertFont = 2;
        this.pd.diagrConvertEPS = false;
        this.pd.diagrExportType = FORMAT_NAMES[0];
        this.pd.diagrExportSize = 1000;
    }

    private void getDatabaseProgr(boolean print) {
        File f;
        String dir = this.pc.pathAPP;
        if (dir != null && dir.endsWith(SLASH)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (dir == null || dir.trim().length() <= 0) {
            createDataFileProg = "DataBase.jar";
        } else {
            createDataFileProg = dir + SLASH + "DataBase.jar";
            f = new File(createDataFileProg);
            if (!f.exists() && System.getProperty("os.name").startsWith("Mac OS")) {
                createDataFileProg = dir + SLASH + ".." + SLASH + ".." + SLASH + ".." + SLASH + ".." + SLASH + "DataBase.app" + SLASH + "Contents" + SLASH + "Resources" + SLASH + "Java" + SLASH + "DataBase.jar";
                f = new File(createDataFileProg);
                try {
                    createDataFileProg = f.getCanonicalPath();
                }
                catch (IOException ex) {
                    createDataFileProg = f.getAbsolutePath();
                }
            }
        }
        f = new File(createDataFileProg);
        if (!f.exists()) {
            if (print) {
                System.out.println("Warning: could NOT find the database program: " + nl + "    " + createDataFileProg);
            }
            createDataFileProg = null;
        } else if (print) {
            System.out.println("Setting database program = " + nl + "    " + createDataFileProg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveIni(File f) {
        if (f == null) {
            return false;
        }
        boolean ok = true;
        SortedProperties propertiesIni = new SortedProperties();
        if (this != null && this.isVisible() && SpanaFrame.locationFrame.x > -1 && SpanaFrame.locationFrame.y > -1) {
            if (this.getExtendedState() == 1 || this.getExtendedState() == 6) {
                this.setExtendedState(0);
            }
            SpanaFrame.locationFrame.x = this.getLocation().x;
            SpanaFrame.locationFrame.y = this.getLocation().y;
        }
        propertiesIni.setProperty("<program_version>", VERS);
        propertiesIni.setProperty("defaultPath", this.pc.pathDef.toString());
        if (txtEditor != null) {
            propertiesIni.setProperty("txtEditor", txtEditor);
        } else {
            propertiesIni.setProperty("txtEditor", "");
        }
        if (pathSedPredom != null) {
            propertiesIni.setProperty("pathSedPredom", pathSedPredom);
        } else {
            propertiesIni.setProperty("pathSedPredom", "");
        }
        if (createDataFileProg != null) {
            propertiesIni.setProperty("createDataFileProg", createDataFileProg);
        } else {
            propertiesIni.setProperty("createDataFileProg", "");
        }
        if (this.laf == 2) {
            propertiesIni.setProperty("lookAndFeel", "CrossPlatform");
        } else if (this.laf == 1) {
            propertiesIni.setProperty("lookAndFeel", "System");
        } else {
            propertiesIni.setProperty("lookAndFeel", "Default");
        }
        propertiesIni.setProperty("advancedVersion", String.valueOf(this.pd.advancedVersion));
        propertiesIni.setProperty("Calc_keepFrame", String.valueOf(this.pd.keepFrame));
        propertiesIni.setProperty("Calc_SED_nbrSteps", String.valueOf(this.pd.SED_nbrSteps));
        propertiesIni.setProperty("Calc_SED_tableOutput", String.valueOf(this.pd.SED_tableOutput));
        propertiesIni.setProperty("Calc_Predom_nbrSteps", String.valueOf(this.pd.Predom_nbrSteps));
        propertiesIni.setProperty("Calc_Predom_aquSpeciesOnly", String.valueOf(this.pd.aquSpeciesOnly));
        propertiesIni.setProperty("Calc_allowReversedConcRanges", String.valueOf(this.pd.reversedConcs));
        propertiesIni.setProperty("Calc_ionicStrength", String.valueOf(this.pd.ionicStrength));
        propertiesIni.setProperty("Calc_temperature", String.valueOf(this.pd.temperature));
        propertiesIni.setProperty("Calc_activityCoefficientsMethod", String.valueOf(this.pd.actCoeffsMethod));
        propertiesIni.setProperty("Calc_useEh", String.valueOf(this.pd.useEh));
        propertiesIni.setProperty("Calc_draw_pH_line", String.valueOf(this.pd.drawNeutralPHinPourbaix));
        propertiesIni.setProperty("Calc_dbg", String.valueOf(this.pd.calcDbg));
        propertiesIni.setProperty("Calc_dbgHalta", String.valueOf(this.pd.calcDbgHalta));
        propertiesIni.setProperty("Calc_tolerance", String.valueOf(this.pd.tolHalta));
        propertiesIni.setProperty("Calc_pathSIT", this.pd.pathSIT);
        propertiesIni.setProperty("Calc_tableFileExt", this.pd.tblExtension);
        propertiesIni.setProperty("Calc_tableFieldSeparatorChar", Character.toString(this.pd.tblFieldSeparator));
        if (this.pd.tblCommentLineStart != null && this.pd.tblCommentLineStart.length() > 0) {
            propertiesIni.setProperty("Calc_tableCommentLineStart", this.pd.tblCommentLineStart);
        } else {
            propertiesIni.setProperty("Calc_tableCommentLineStart", "");
        }
        if (this.pd.tblCommentLineEnd != null && this.pd.tblCommentLineEnd.length() > 0) {
            propertiesIni.setProperty("Calc_tableCommentLineEnd", this.pd.tblCommentLineEnd);
        } else {
            propertiesIni.setProperty("Calc_tableCommentLineEnd", "");
        }
        propertiesIni.setProperty("Disp_Width", String.valueOf(SpanaFrame.dispSize.width));
        propertiesIni.setProperty("Disp_Height", String.valueOf(SpanaFrame.dispSize.height));
        propertiesIni.setProperty("Disp_left", String.valueOf(SpanaFrame.dispLocation.x));
        propertiesIni.setProperty("Disp_top", String.valueOf(SpanaFrame.dispLocation.y));
        if (msgFrame != null) {
            msgFrameSize = msgFrame.getSize();
            locationMsgFrame = msgFrame.getLocation();
        }
        propertiesIni.setProperty("LogFrame_Width", String.valueOf(SpanaFrame.msgFrameSize.width));
        propertiesIni.setProperty("LogFrame_Height", String.valueOf(SpanaFrame.msgFrameSize.height));
        propertiesIni.setProperty("LogFrame_left", String.valueOf(SpanaFrame.locationMsgFrame.x));
        propertiesIni.setProperty("LogFrame_top", String.valueOf(SpanaFrame.locationMsgFrame.y));
        propertiesIni.setProperty("Location_left", String.valueOf(SpanaFrame.locationFrame.x));
        propertiesIni.setProperty("Location_top", String.valueOf(SpanaFrame.locationFrame.y));
        propertiesIni.setProperty("Disp_KeepAspectRatio", String.valueOf(this.diagrPaintUtil.keepAspectRatio));
        propertiesIni.setProperty("Disp_FixedSize", String.valueOf(this.diagrPaintUtil.fixedSize));
        propertiesIni.setProperty("Disp_FixedSizeWidth", String.valueOf(this.diagrPaintUtil.fixedSizeWidth));
        propertiesIni.setProperty("Disp_FixedSizeHeight", String.valueOf(this.diagrPaintUtil.fixedSizeHeight));
        propertiesIni.setProperty("Disp_FontFamily", String.valueOf(this.diagrPaintUtil.fontFamily));
        propertiesIni.setProperty("Disp_FontStyle", String.valueOf(this.diagrPaintUtil.fontStyle));
        propertiesIni.setProperty("Disp_FontSize", String.valueOf(this.diagrPaintUtil.fontSize));
        propertiesIni.setProperty("Disp_TextWithFonts", String.valueOf(this.diagrPaintUtil.textWithFonts));
        propertiesIni.setProperty("Disp_FractionThreshold", String.valueOf(this.pd.fractionThreshold));
        String anti = this.diagrPaintUtil.antiAliasingText == 1 ? "on" : (this.diagrPaintUtil.antiAliasingText == 2 ? "default" : "off");
        propertiesIni.setProperty("Disp_AntialiasingText", anti);
        anti = this.diagrPaintUtil.antiAliasing == 1 ? "on" : (this.diagrPaintUtil.antiAliasing == 2 ? "default" : "off");
        propertiesIni.setProperty("Disp_Antialiasing", anti);
        propertiesIni.setProperty("Disp_ColourType", String.valueOf(this.diagrPaintUtil.colourType));
        propertiesIni.setProperty("Disp_PrintColour", String.valueOf(this.diagrPaintUtil.printColour));
        propertiesIni.setProperty("Disp_PrintHeader", String.valueOf(this.diagrPaintUtil.printHeader));
        propertiesIni.setProperty("Disp_PrintPenThickness", String.valueOf(this.diagrPaintUtil.printPenThickness));
        propertiesIni.setProperty("Disp_PenThickness", String.valueOf(this.diagrPaintUtil.penThickness));
        propertiesIni.setProperty("Disp_UseBackgrndColour", String.valueOf(this.diagrPaintUtil.useBackgrndColour));
        propertiesIni.setProperty("Disp_BackgroundColour", this.diagrPaintUtil.backgrnd.getRed() + "," + this.diagrPaintUtil.backgrnd.getGreen() + "," + this.diagrPaintUtil.backgrnd.getBlue());
        for (int ii = 0; ii < 11; ++ii) {
            propertiesIni.setProperty("Disp_Colour[" + ii + "]", this.diagrPaintUtil.colours[ii].getRed() + "," + this.diagrPaintUtil.colours[ii].getGreen() + "," + this.diagrPaintUtil.colours[ii].getBlue());
        }
        propertiesIni.setProperty("Convert_SizeX", String.valueOf(this.pd.diagrConvertSizeX));
        propertiesIni.setProperty("Convert_SizeY", String.valueOf(this.pd.diagrConvertSizeY));
        propertiesIni.setProperty("Convert_MarginBottom", String.valueOf(this.pd.diagrConvertMarginB));
        propertiesIni.setProperty("Convert_MarginLeft", String.valueOf(this.pd.diagrConvertMarginL));
        propertiesIni.setProperty("Convert_Portrait", String.valueOf(this.pd.diagrConvertPortrait));
        propertiesIni.setProperty("Convert_Font", String.valueOf(this.pd.diagrConvertFont));
        propertiesIni.setProperty("Convert_Colour", String.valueOf(this.pd.diagrConvertColors));
        propertiesIni.setProperty("Convert_Header", String.valueOf(this.pd.diagrConvertHeader));
        propertiesIni.setProperty("Convert_EPS", String.valueOf(this.pd.diagrConvertEPS));
        propertiesIni.setProperty("Export_To", this.pd.diagrExportType);
        propertiesIni.setProperty("Export_Size", String.valueOf(this.pd.diagrExportSize));
        System.out.println("Saving ini-file: \"" + f.getPath() + "\"");
        FileOutputStream propertiesIniFile = null;
        try {
            propertiesIniFile = new FileOutputStream(f);
            int i = nl.length();
            byte[] b = new byte[7 + i];
            b[0] = 91;
            b[1] = 83;
            b[2] = 112;
            b[3] = 97;
            b[4] = 110;
            b[5] = 97;
            b[6] = 93;
            for (int j = 0; j < i; ++j) {
                b[7 + j] = (byte)nl.codePointAt(j);
            }
            propertiesIniFile.write(b);
            propertiesIni.store(propertiesIniFile, null);
            if (this.pc.dbg) {
                System.out.println("Written: \"" + f.getPath() + "\"");
            }
        }
        catch (IOException e) {
            String msg = "Error: \"" + e.toString() + "\"" + nl + "   while writing INI-file:" + nl + "   \"" + f.getPath() + "\"";
            System.out.println(msg);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            JOptionPane.showMessageDialog(spf, msg, this.pc.progName, 0);
            ok = false;
        }
        finally {
            try {
                if (propertiesIniFile != null) {
                    propertiesIniFile.close();
                }
            }
            catch (IOException e) {
                ok = false;
            }
        }
        return ok;
    }

    public static void printInstructions() {
        System.out.flush();
        String msg = "Possible commands are:" + nl + "  -dbg            (output debugging information to the messages window)" + nl + "  data-file-name  (add data file to list, name must end with \".dat\")" + nl + "  plot-file-name  (display plot file, name must end with \".plt\")" + nl + "  -p=plot-file-name  (print plot file)" + nl + "  -pdf=plot-file-name  (convert plot file to \"pdf\" format)" + nl + "  -ps=plot-file-name  (convert plot file to \"PostScript\")" + nl + "  -eps=plot-file-name  (convert plot file to encapsulated \"PostScript\")" + nl + "  -ext=plot-file-name  (export plot file to \"ext\" format" + nl + "                        where \"ext\" is one of: bmp, jpg or png, and perhaps gif)." + nl + "Plot-file-name must end with \".plt\"." + nl + "Enclose file names with double quotes (\"\") it they contain blank space." + nl + "Example:   java -jar Spana.jar \"plt\\Fe 25.plt\" -p:\"plt\\Fe I=3M\"";
        System.out.println(msg);
        System.out.flush();
        System.err.println(LINE);
        System.err.flush();
    }

    public static void main(final String[] args) {
        File fileNameCfg;
        System.out.println("Starting Spana - version 2015-June-05");
        boolean dbg = false;
        if (args.length > 0) {
            for (String arg : args) {
                if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                    System.out.println("Command-line argument = \"" + arg + "\"");
                    dbg = true;
                }
                if (!arg.equals("-?") && !arg.equals("/?") && !arg.equals("?")) continue;
                System.out.println("Command-line argument = \"" + arg + "\"");
                SpanaFrame.printInstructions();
            }
        }
        if (new OneInstance().findOtherInstance(args, 56055, "Spana", dbg)) {
            System.out.println("---- Already running.");
            return;
        }
        final ProgramConf pc = new ProgramConf("Spana");
        pc.dbg = dbg;
        if (msgFrame == null) {
            msgFrame = new RedirectedFrame(500, 400, pc);
            msgFrame.setVisible(dbg);
            System.out.println("Spana diagram - version 2015-June-05");
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            File f;
            windows = true;
            try {
                windir = System.getenv("windir");
            }
            catch (Exception ex) {
                System.out.println("Warning: could not get environment variable \"windir\"");
                windir = null;
            }
            if (windir != null && windir.trim().length() <= 0) {
                windir = null;
            }
            if (!(windir == null || (f = new File(windir)).exists() && f.isDirectory())) {
                windir = null;
            }
        }
        try {
            if (windows) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(System);");
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(CrossPlatform);");
            }
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        Util.configureOptionPane();
        String dir = pc.pathAPP = Main.getPathApp();
        if (dir != null && dir.trim().length() > 0) {
            if (dir.endsWith(SLASH)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            fileNameCfg = new File(dir + SLASH + pc.progName + ".cfg");
        } else {
            fileNameCfg = new File(pc.progName + ".cfg");
        }
        ProgramConf.read_cfgFile((File)fileNameCfg, (ProgramConf)pc);
        if (!pc.dbg) {
            pc.dbg = dbg;
        }
        msgFrame.setVisible(pc.dbg);
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        Date today = new Date();
        String dateOut = dateFormatter.format(today);
        System.out.println("\"Spana\" started: " + dateOut);
        System.out.println(LINE);
        pc.setPathDef();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                spf = new SpanaFrame(pc, msgFrame);
                spf.start(args);
            }
        });
    }

    public static SpanaFrame getInstance() {
        return spf;
    }

    static {
        nl = System.getProperty("line.separator");
        SLASH = File.separator;
        String[] names = ImageIO.getWriterFormatNames();
        if (names.length > 0) {
            TreeSet<String> set = new TreeSet<String>();
            for (String name : names) {
                set.add(name.toLowerCase());
            }
            FORMAT_NAMES = set.toArray(new String[0]);
        } else {
            FORMAT_NAMES = new String[]{"error"};
        }
        tHandler = new TransferHandler(null){

            @Override
            public boolean importData(JComponent component, Transferable t) {
                if (!this.canImport(component, t.getTransferDataFlavors())) {
                    return false;
                }
                try {
                    List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File f : list) {
                        String fileName;
                        try {
                            fileName = f.getCanonicalPath();
                        }
                        catch (IOException ex) {
                            try {
                                fileName = f.getAbsolutePath();
                            }
                            catch (Exception e) {
                                fileName = f.getPath();
                            }
                        }
                        String fileN = fileName;
                        if (fileName.toLowerCase().endsWith(".plt")) {
                            spf.displayPlotFile(fileN, null);
                        }
                        if (!fileName.toLowerCase().endsWith(".dat")) continue;
                        spf.addDatFile(fileN);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException ex) {
                    return false;
                }
                return true;
            }

            @Override
            public boolean canImport(JComponent component, DataFlavor[] flavors) {
                boolean hasFileFlavor = false;
                for (DataFlavor flavor : flavors) {
                    if (!DataFlavor.javaFileListFlavor.equals(flavor)) continue;
                    hasFileFlavor = true;
                    return true;
                }
                return false;
            }
        };
    }
}

