/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.FrameDBmain;
import java.awt.AWTKeyStroke;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import lib.database.ProgramDataDB;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;

public class SetTempDialog
extends JDialog {
    private ProgramConf pc;
    private final ProgramDataDB pd;
    private final FrameDBmain dbF;
    private final Dimension windowSize;
    private double temperature;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxT;
    private JLabel jLabel1;
    private JLabel jLabelDegrees;

    public SetTempDialog(Frame parent, boolean modal, ProgramConf pc0, ProgramDataDB pd0) {
        super(parent, modal);
        int top;
        int left;
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.dbF = (FrameDBmain)parent;
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetTempDialog.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        AbstractAction altQAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetTempDialog.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ALT_Q", altQAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetTempDialog.this.jButtonOK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetTempDialog.this.setCursor(new Cursor(3));
                String[] a = new String[]{"DB_0_Main_htm"};
                RunProgr.runProgramInProcess(SetTempDialog.this, "Chem_Diagr_Help.jar", a, false, ((SetTempDialog)SetTempDialog.this).pc.dbg, ((SetTempDialog)SetTempDialog.this).pc.pathAPP);
                SetTempDialog.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(39, 0));
        this.setFocusTraversalKeys(0, newKeys);
        keys = this.getFocusTraversalKeys(1);
        newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(37, 0));
        this.setFocusTraversalKeys(1, newKeys);
        this.setTitle("  Temperature:");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (parent != null) {
            left = Math.max(0, parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2);
            top = Math.max(0, parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2);
        } else {
            left = Math.max(0, (screenSize.width - this.getWidth()) / 2);
            top = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        }
        this.setLocation(Math.min(screenSize.width - this.getWidth() - 20, left), Math.min(screenSize.height - this.getHeight() - 20, top));
        this.temperature = this.pd.temperature;
        this.set_temp_inComboBox();
        this.pack();
        this.windowSize = new Dimension(this.getWidth(), this.getHeight());
        this.setVisible(true);
    }

    private void initComponents() {
        this.jComboBoxT = new JComboBox();
        this.jLabelDegrees = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SetTempDialog.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SetTempDialog.this.formComponentResized(evt);
            }
        });
        this.jComboBoxT.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxT.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "50", "60", "70", "75", "80", "90", "100"}));
        this.jComboBoxT.setSelectedIndex(5);
        this.jComboBoxT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetTempDialog.this.jComboBoxTActionPerformed(evt);
            }
        });
        this.jLabelDegrees.setFont(new Font("Dialog", 1, 11));
        this.jLabelDegrees.setText("\u00b0C");
        this.jLabelDegrees.setToolTipText("double-click to set T=25'C");
        this.jLabelDegrees.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SetTempDialog.this.jLabelDegreesMouseClicked(evt);
            }
        });
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('O');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetTempDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('C');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetTempDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/database/images/Termometer.gif")));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxT, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDegrees)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK).addGap(18, 18, 18).addComponent(this.jButtonCancel))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxT, -2, -1, -2).addComponent(this.jLabelDegrees)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK))).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel1))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jComboBoxTActionPerformed(ActionEvent evt) {
        this.temperature = Double.parseDouble(this.jComboBoxT.getSelectedItem().toString());
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.pd.temperature = this.temperature;
        this.closeWindow();
    }

    private void jLabelDegreesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.temperature = 25.0;
            this.jComboBoxT.setSelectedIndex(5);
        }
    }

    private void closeWindow() {
        this.dispose();
        this.dbF.bringToFront();
    }

    private void set_temp_inComboBox() {
        int listItem = 0;
        int listCount = this.jComboBoxT.getItemCount();
        for (int i = 1; i < listCount; ++i) {
            double w0 = Double.parseDouble(this.jComboBoxT.getItemAt(i - 1).toString());
            double w1 = Double.parseDouble(this.jComboBoxT.getItemAt(i).toString());
            if (this.temperature <= w0 && i == 1) {
                listItem = 0;
                break;
            }
            if (this.temperature >= w1 && i == listCount - 1) {
                listItem = listCount - 1;
                break;
            }
            if (!(this.temperature > w0) || !(this.temperature <= w1)) continue;
            if (Math.abs(this.temperature - w0) < Math.abs(this.temperature - w1)) {
                listItem = i - 1;
                break;
            }
            listItem = i;
            break;
        }
        this.jComboBoxT.setSelectedIndex(listItem);
    }
}

