/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.chem;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import lib.common.Util;

public class Chem {
    public ChemSystem chemSystem = null;
    public Diagr diag = null;
    public DiagrConcs diagrConcs = null;
    private static final String nl = System.getProperty("line.separator");

    public Chem(int Na, int Ms, int mSol) throws ChemicalParameterException {
        if (Na < 0 || Ms < 0 || mSol < 0) {
            throw new ChemicalParameterException("Error in \"Chem\"-constructor: Na=" + Na + ", Ms=" + Ms + ", mSol=" + mSol + nl + "   All must be >=0.");
        }
        if (Ms < Na + mSol) {
            throw new ChemicalParameterException("Error in \"Chem\"-constructor: Na=" + Na + ", Ms=" + Ms + ", mSol=" + mSol + nl + "   Ms must be >=(Na+mSol).");
        }
        this.chemSystem = new ChemSystem(Na, Ms, mSol);
        this.diag = new Diagr();
        this.diagrConcs = new DiagrConcs(Na);
    }

    public class DiagrConcs
    implements Cloneable {
        public int[] hur;
        public double[] cLow;
        public double[] cHigh;

        public DiagrConcs(int Na) throws ChemicalParameterException {
            if (Na < 0) {
                throw new ChemicalParameterException("Error in \"DiagrConcs\"-constructor: Na=" + Na + ". Must be >=0.");
            }
            this.hur = new int[Na];
            this.cLow = new double[Na];
            this.cHigh = new double[Na];
            for (int i = 0; i < Na; ++i) {
                this.hur[i] = -1;
                this.cLow[i] = Double.NaN;
                this.cHigh[i] = Double.NaN;
            }
        }

        public Object clone() throws CloneNotSupportedException {
            DiagrConcs dc;
            super.clone();
            int Na = this.hur.length;
            try {
                dc = new DiagrConcs(Na);
            }
            catch (ChemicalParameterException ex) {
                return null;
            }
            System.arraycopy(this.hur, 0, dc.hur, 0, Na);
            System.arraycopy(this.cLow, 0, dc.cLow, 0, Na);
            System.arraycopy(this.cHigh, 0, dc.cHigh, 0, Na);
            return dc;
        }

        public boolean isEqualTo(DiagrConcs another) {
            if (another != null) {
                int i;
                boolean ok = true;
                if (!Arrays.equals(this.hur, another.hur)) {
                    ok = false;
                }
                if (ok && this.cLow.length != another.cLow.length) {
                    ok = false;
                }
                if (ok && this.cHigh.length != another.cHigh.length) {
                    ok = false;
                }
                if (ok && this.cLow.length > 0) {
                    for (i = 0; i < this.cLow.length; ++i) {
                        if (Util.areEqualDoubles(this.cLow[i], another.cLow[i])) continue;
                        ok = false;
                        break;
                    }
                }
                if (ok && this.cHigh.length > 0) {
                    for (i = 0; i < this.cHigh.length; ++i) {
                        if (Util.areEqualDoubles(this.cHigh[i], another.cHigh[i])) continue;
                        ok = false;
                        break;
                    }
                }
                return ok;
            }
            return false;
        }

        public String toString() {
            int Na = Chem.this.chemSystem.Na;
            String txt = "concentrations for components:";
            String[] concTypes = new String[]{" - ", "T", "TV", "LTV", "LA", "LAV"};
            for (int i = 0; i < Na; ++i) {
                String t = this.hur[i] >= 1 && this.hur[i] <= 5 ? concTypes[this.hur[i]] : concTypes[0];
                txt = txt + nl + " i=" + i + " hur = " + this.hur[i] + " (" + t + "), cLow=" + this.cLow[i] + ", cHigh=" + this.cHigh[i];
            }
            return txt;
        }
    }

    public class Diagr
    implements Cloneable {
        public int plotType = -1;
        public int compX = -1;
        public int compY = -1;
        public int compMain = -1;
        public int oneArea = -1;
        public double yLow = Double.NaN;
        public double yHigh = Double.NaN;
        public boolean Eh = true;
        public String title = null;
        public String endLines = null;
        public int databaseSpanaFile = 0;
        public boolean inputYMinMax = false;
        public int pInX = 0;
        public int pInY = 0;
        public int Hplus = -1;
        public int OHmin = -1;
        public boolean aquSystem = false;
        public double temperature = 25.0;
        public double pressure = Double.NaN;
        public double ionicStrength = 0.0;
        public int activityCoeffsModel = -1;
        public float fractionThreshold = 0.03f;

        public Object clone() throws CloneNotSupportedException {
            super.clone();
            Diagr d = new Diagr();
            d.plotType = this.plotType;
            d.compX = this.compX;
            d.compY = this.compY;
            d.compMain = this.compMain;
            d.oneArea = this.oneArea;
            d.yLow = this.yLow;
            d.yHigh = this.yHigh;
            d.Eh = this.Eh;
            d.title = this.title;
            d.endLines = this.endLines;
            d.databaseSpanaFile = this.databaseSpanaFile;
            d.inputYMinMax = this.inputYMinMax;
            d.pInX = this.pInX;
            d.pInY = this.pInY;
            d.Hplus = this.Hplus;
            d.OHmin = this.OHmin;
            d.aquSystem = this.aquSystem;
            d.ionicStrength = this.ionicStrength;
            d.temperature = this.temperature;
            d.pressure = this.pressure;
            d.fractionThreshold = this.fractionThreshold;
            return d;
        }

        public boolean isEqualTo(Diagr another) {
            return another != null && this.plotType == another.plotType && this.compX == another.compX && this.compY == another.compY && this.compMain == another.compMain && this.oneArea == another.oneArea && this.yLow == another.yLow && this.yHigh == another.yHigh && this.Eh == another.Eh && Util.stringsEqual(this.title, another.title) && Util.stringsEqual(this.endLines, another.endLines) && this.databaseSpanaFile == another.databaseSpanaFile && this.inputYMinMax == another.inputYMinMax && this.pInX == another.pInX && this.pInY == another.pInY && this.Hplus == another.Hplus && this.OHmin == another.OHmin && this.aquSystem == another.aquSystem && this.ionicStrength == another.ionicStrength && this.temperature == another.temperature && this.pressure == another.pressure && this.fractionThreshold == another.fractionThreshold;
        }

        public void printPlotType(PrintStream out) {
            if (out == null) {
                out = System.out;
            }
            out.flush();
            int Na = Chem.this.chemSystem.Na;
            out.println("Plot data:");
            String[] plotTypes = new String[]{"Predom", "Fraction", "log solub.", "log conc.", "log (ai/ar)", "calc.pe", "calc.pH", "log act.", "H-aff."};
            String t = this.plotType >= 0 && this.plotType <= 8 ? plotTypes[this.plotType] : " - ";
            out.println("  plot type = " + this.plotType + " (" + t + ");  yLow = " + this.yLow + "  yHigh = " + this.yHigh);
            out.println("  compX = " + this.compX + "  compY = " + this.compY + "  compMain = " + this.compMain);
            out.println("  oneArea = " + this.oneArea + "  fractionThreshold = " + this.fractionThreshold);
            out.flush();
        }
    }

    public class ChemSystem {
        public int Na;
        public int Ms;
        public int mSol;
        public int nx;
        public int solidC = 0;
        public double[][] a;
        public double[] lBeta;
        public boolean[] noll;
        public int jWater = -1;
        public ChemConcs chemConcs;
        public NamesEtc namn = null;

        public ChemSystem(int Na, int Ms, int mSol) throws ChemicalParameterException {
            if (Na <= 0 || Ms <= 0) {
                throw new ChemicalParameterException("Error in \"ChemSystem\"-constructor: Na=" + Na + ", Ms=" + Ms + nl + "   All must be >0.");
            }
            if (mSol < 0) {
                throw new ChemicalParameterException("Error in \"ChemSystem\"-constructor:  mSol=" + mSol + nl + "   must be >=0.");
            }
            if (Ms < Na + mSol) {
                throw new ChemicalParameterException("Error in \"ChemSystem\"-constructor: Na=" + Na + ", Ms=" + Ms + ", mSol=" + mSol + nl + "   Ms must be >=(Na+mSol).");
            }
            this.Na = Na;
            this.Ms = Ms;
            this.mSol = mSol;
            this.nx = Ms - Na - mSol;
            this.a = new double[Ms - Na][Na];
            this.lBeta = new double[Ms - Na];
            this.noll = new boolean[Ms];
            for (int i = 0; i < this.noll.length; ++i) {
                this.noll[i] = false;
            }
            this.chemConcs = new ChemConcs();
            this.namn = new NamesEtc(Na, Ms, mSol);
        }

        public void printChemSystem(PrintStream out) {
            if (out == null) {
                out = System.out;
            }
            out.flush();
            Locale e = Locale.ENGLISH;
            out.println("Chemical System: Na, nx, mSol, solidC = " + this.Na + ", " + this.nx + ", " + this.mSol + ", " + this.solidC + ", Ms=" + this.Ms);
            out.println("components: noll=");
            int n0 = 0;
            int nM = this.Na - 1;
            int iPl = 12;
            int nP = nM - n0;
            if (nP >= 0) {
                block0: for (int ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (int jjj = 0; jjj < iPl; ++jjj) {
                        int kjj = n0 + (ijj * iPl + jjj);
                        out.format(e, " %5b", this.noll[kjj]);
                        if (kjj <= nM - 1) continue;
                        out.println();
                        break block0;
                    }
                    out.println();
                    out.print("    ");
                }
            }
            out.println("reaction products: log beta, noll, a[]=");
            block2: for (int i = 0; i < this.nx + this.mSol; ++i) {
                out.format(e, " %10.5f %5b ", this.lBeta[i], this.noll[i + this.Na]);
                n0 = 0;
                nM = this.Na - 1;
                iPl = 8;
                nP = nM - n0;
                if (nP < 0) continue;
                for (int ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (int jjj = 0; jjj < iPl; ++jjj) {
                        int kjj = n0 + (ijj * iPl + jjj);
                        out.format(e, " %8.3f", this.a[i][kjj]);
                        if (kjj <= nM - 1) continue;
                        out.println();
                        continue block2;
                    }
                    out.println();
                    out.print("    ");
                }
            }
            out.flush();
        }

        public class NamesEtc {
            public String[] identC;
            public String[] ident;
            public int[] nameLength;
            public int[] iel;
            public int[] z;
            public String[] comment;

            public NamesEtc(int na, int ms, int mSol) throws ChemicalParameterException {
                if (na < 0 || ms < 0 || mSol < 0) {
                    throw new ChemicalParameterException("Error in \"NamesEtc\"-constructor: na=" + na + ", ms=" + ms + ", mSol=" + mSol + nl + "   All must be >=0.");
                }
                if (ms < na || ms < mSol) {
                    throw new ChemicalParameterException("Error in \"NamesEtc\"-constructor: na=" + na + ", ms=" + ms + ", mSol=" + mSol + nl + "   ms must be >na and >mSol.");
                }
                this.identC = new String[na];
                this.ident = new String[ms];
                this.comment = new String[ms];
                this.nameLength = new int[ms];
                this.iel = new int[na];
                int nx = ms - na - mSol;
                int nIons = na + nx;
                this.z = new int[nIons + 2];
            }

            public void printNamesEtc(PrintStream out) {
                int kjj;
                int jjj;
                int ijj;
                if (out == null) {
                    out = System.out;
                }
                out.flush();
                Locale e = Locale.ENGLISH;
                int Na = Chem.this.chemSystem.Na;
                int Ms = Chem.this.chemSystem.Ms;
                int mSol = Chem.this.chemSystem.mSol;
                out.println("components: names=");
                out.print("    ");
                int n0 = 0;
                int nM = Na - 1;
                int iPl = 5;
                int nP = nM - n0;
                if (nP >= 0) {
                    block0: for (int ijj2 = 0; ijj2 <= nP / iPl; ++ijj2) {
                        for (int jjj2 = 0; jjj2 < iPl; ++jjj2) {
                            int kjj2 = n0 + (ijj2 * iPl + jjj2);
                            out.format(e, " %15s", this.identC[kjj2]);
                            if (kjj2 <= nM - 1) continue;
                            out.println();
                            break block0;
                        }
                        out.println();
                        out.print("    ");
                    }
                }
                int nx = Ms - Na - mSol;
                out.println("complexes: names=");
                out.print("    ");
                n0 = Na;
                nM = Na + nx + mSol - 1;
                iPl = 5;
                nP = nM - n0;
                if (nP >= 0) {
                    block2: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                        for (jjj = 0; jjj < iPl; ++jjj) {
                            kjj = n0 + (ijj * iPl + jjj);
                            out.format(e, " %15s", this.ident[kjj]);
                            if (kjj <= nM - 1) continue;
                            out.println();
                            break block2;
                        }
                        out.println();
                        out.print("    ");
                    }
                }
                out.println("soluble species: z=");
                out.print("    ");
                n0 = 0;
                nM = Na + nx + 2 - 1;
                iPl = 20;
                nP = nM - n0;
                if (nP >= 0) {
                    block4: for (ijj = 0; ijj <= nP / iPl; ++ijj) {
                        for (jjj = 0; jjj < iPl; ++jjj) {
                            kjj = n0 + (ijj * iPl + jjj);
                            out.format(e, " %3d", this.z[kjj]);
                            if (kjj <= nM - 1) continue;
                            out.println();
                            break block4;
                        }
                        out.println();
                        out.print("    ");
                    }
                }
                out.flush();
            }
        }

        public class ChemConcs {
            public int[] kh;
            public double[] logA;
            public double[] tot;
            public double tol;
            public double[] solub;
            public double[] C;
            public double[] logf;
            public int dbg;
            public boolean cont;
            public int errFlags;
            public boolean actCoefCalc = false;
            public double tolLogF;

            private ChemConcs() throws ChemicalParameterException {
                int na = ChemSystem.this.Na;
                int ms = ChemSystem.this.Ms;
                if (na < 0 || ms < 0) {
                    throw new ChemicalParameterException("Error in \"ChemConcs\"-constructor: na=" + na + ", ms=" + ms + nl + "   All must be >=0.");
                }
                if (na > ms) {
                    throw new ChemicalParameterException("Error in \"ChemConcs\"-constructor: na=" + na + ", ms=" + ms + nl + "   ms must be >= na.");
                }
                this.kh = new int[na];
                this.tot = new double[na];
                this.tol = 1.0E-4;
                this.solub = new double[na];
                this.C = new double[ms];
                this.logA = new double[ms];
                this.logf = new double[ms];
                this.dbg = 0;
                this.cont = false;
                this.errFlags = 0;
                this.actCoefCalc = false;
            }

            public void errFlagsSet(int i) {
                if (i == 1) {
                    this.errFlags |= 1;
                } else if (i == 2) {
                    this.errFlags |= 2;
                } else if (i == 3) {
                    this.errFlags |= 4;
                } else if (i == 4) {
                    this.errFlags |= 8;
                } else if (i == 5) {
                    this.errFlags |= 0x10;
                } else if (i == 6) {
                    this.errFlags |= 0x20;
                } else if (i == 7) {
                    this.errFlags |= 0x40;
                }
            }

            public boolean isErrFlagsSet(int i) {
                boolean b = false;
                if (i == 1) {
                    if ((this.errFlags & 1) == 1) {
                        b = true;
                    }
                } else if (i == 2) {
                    if ((this.errFlags & 2) == 2) {
                        b = true;
                    }
                } else if (i == 3) {
                    if ((this.errFlags & 4) == 4) {
                        b = true;
                    }
                } else if (i == 4) {
                    if ((this.errFlags & 8) == 8) {
                        b = true;
                    }
                } else if (i == 5) {
                    if ((this.errFlags & 0x10) == 16) {
                        b = true;
                    }
                } else if (i == 6) {
                    if ((this.errFlags & 0x20) == 32) {
                        b = true;
                    }
                } else if (i == 7 && (this.errFlags & 0x40) == 64) {
                    b = true;
                }
                return b;
            }

            public void errFlagsClear(int i) {
                if (i == 1) {
                    this.errFlags &= 0xFFFFFFFE;
                } else if (i == 2) {
                    this.errFlags &= 0xFFFFFFFD;
                } else if (i == 3) {
                    this.errFlags &= 0xFFFFFFFB;
                } else if (i == 4) {
                    this.errFlags &= 0xFFFFFFF7;
                } else if (i == 5) {
                    this.errFlags &= 0xFFFFFFEF;
                } else if (i == 6) {
                    this.errFlags &= 0xFFFFFFDF;
                } else if (i == 7) {
                    this.errFlags &= 0xFFFFFFBF;
                }
            }

            public String errFlagsToString() {
                String t = "errFlags (1 to 6): ";
                t = (this.errFlags & 1) == 1 ? t + "1" : t + "0";
                t = (this.errFlags & 2) == 2 ? t + "1" : t + "0";
                t = (this.errFlags & 4) == 4 ? t + "1" : t + "0";
                t = (this.errFlags & 8) == 8 ? t + "1" : t + "0";
                t = (this.errFlags & 0x10) == 16 ? t + "1" : t + "0";
                t = (this.errFlags & 0x20) == 32 ? t + "1" : t + "0";
                t = (this.errFlags & 0x40) == 64 ? t + "1" : t + "0";
                return t;
            }

            public String errFlagsGetMessages() {
                if (this.errFlags <= 0) {
                    return null;
                }
                String t = "";
                if ((this.errFlags & 1) == 1) {
                    t = t + "The numerical solution is uncertain.";
                }
                if ((this.errFlags & 2) == 2) {
                    if (t.length() > 0) {
                        t = t + nl;
                    }
                    t = t + "Too many iterations when solving the mass balance equations.";
                }
                if ((this.errFlags & 4) == 4) {
                    if (t.length() > 0) {
                        t = t + nl;
                    }
                    t = t + "Failed to find a satisfactory combination of solids.";
                }
                if ((this.errFlags & 8) == 8) {
                    if (t.length() > 0) {
                        t = t + nl;
                    }
                    t = t + "Too many iterations trying to find the solids at equilibrium.";
                }
                if ((this.errFlags & 0x10) == 16) {
                    if (t.length() > 0) {
                        t = t + nl;
                    }
                    t = t + "Some aqueous concentration(s) too large (>50): uncertain activity coefficients.";
                }
                if ((this.errFlags & 0x20) == 32) {
                    if (t.length() > 0) {
                        t = t + nl;
                    }
                    t = t + "Activity factors did not converge.";
                }
                if ((this.errFlags & 0x40) == 64) {
                    if (t.length() > 0) {
                        t = t + nl;
                    }
                    t = t + "Calculation interrupted by the user.";
                }
                if (t.trim().length() <= 0) {
                    return null;
                }
                return t;
            }
        }
    }

    public static class ChemicalParameterException
    extends Exception {
        public ChemicalParameterException() {
        }

        public ChemicalParameterException(String txt) {
            super(txt);
        }
    }
}

