/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import lib.common.Util;
import lib.database.CSVparser;
import lib.database.Complex;
import lib.database.LibDB;
import lib.huvud.Div;

public class AddDataElem {
    private static final String nl = System.getProperty("line.separator");

    public static boolean elemFileCheck(boolean dbg, Component parent, String dbName, ArrayList<String[]> elemComp) {
        if (dbName == null || dbName.trim().length() <= 0) {
            if (dbg) {
                System.out.println("--- elemFileCheck(); dbName empty");
            }
            return false;
        }
        if (dbg) {
            System.out.println("--- elemFileCheck(" + dbName + ")");
        }
        File af = new File(dbName);
        String addFileEle = AddDataElem.getElemFileName(dbg, parent, dbName);
        if (addFileEle == null) {
            return false;
        }
        File afE = new File(addFileEle);
        if (!afE.exists()) {
            System.out.println("--- Could not find the \"element\"-file for database: \"" + af.getName() + "\"");
            String msg = "Could not find the \"element\"-file" + nl + "for database: \"" + af.getName() + "\"." + nl + nl + "The file \"" + afE.getName() + "\" will be created.";
            Object[] opt = new Object[]{"OK", "Cancel"};
            int m = JOptionPane.showOptionDialog(parent, msg, "Missing file", 0, 2, null, opt, opt[0]);
            if (m != 0) {
                if (dbg) {
                    System.out.println("Cancelled by the user");
                }
                return false;
            }
            ArrayList<String[]> elemCompNewFile = new ArrayList<String[]>();
            try {
                AddDataElem.elemCompAdd_Update(dbg, parent, dbName, addFileEle, elemComp, elemCompNewFile);
            }
            catch (AddDataException ex) {
                Util.exceptn((String)ex.toString());
                if (parent != null) {
                    if (!parent.isVisible()) {
                        parent.setVisible(true);
                    }
                    JOptionPane.showMessageDialog(parent, ex.getMessage(), "elemCompAdd_Update", 0);
                }
                return false;
            }
        }
        ArrayList<String[]> elemCompNewFile = new ArrayList<String[]>();
        try {
            AddDataElem.elemCompAdd_Update(dbg, parent, dbName, addFileEle, elemComp, elemCompNewFile);
        }
        catch (AddDataException ex) {
            if (parent != null) {
                if (!parent.isVisible()) {
                    parent.setVisible(true);
                }
                JOptionPane.showMessageDialog(parent, ex.getMessage(), "elemCompAdd_Update", 0);
            }
            return false;
        }
        return true;
    }

    public static String getElemFileName(boolean dbg, Component parent, String addFile) {
        String addFileEle;
        if (addFile == null || addFile.trim().length() <= 0) {
            return null;
        }
        if (Div.getFileNameExtension((String)addFile).equalsIgnoreCase("elt") || Div.getFileNameExtension((String)addFile).equalsIgnoreCase("elm") || Div.getFileNameExtension((String)addFile).equalsIgnoreCase("elb")) {
            String msg = "File \"" + addFile + "\":" + nl + "can not have extension \"elb\", \"elt\", nor \"elm\".";
            Util.exceptn((String)msg);
            if (parent != null) {
                if (!parent.isVisible()) {
                    parent.setVisible(true);
                }
                JOptionPane.showMessageDialog(parent, msg, "getElemFileName", 0);
            }
            return null;
        }
        boolean binary = Div.getFileNameExtension((String)addFile).equalsIgnoreCase("db");
        if (binary) {
            addFileEle = Div.getFileNameWithoutExtension((String)addFile) + ".elb";
        } else {
            addFileEle = Div.getFileNameWithoutExtension((String)addFile) + ".elt";
            File elemFile = new File(addFileEle);
            String elN = elemFile.getName();
            if (!elemFile.exists()) {
                addFileEle = Div.getFileNameWithoutExtension((String)addFile) + ".elm";
                elemFile = new File(addFileEle);
                if (!elemFile.exists()) {
                    addFileEle = Div.getFileNameWithoutExtension((String)addFile) + ".elt";
                }
            } else {
                String elN2 = Div.getFileNameWithoutExtension((String)addFile) + ".elm";
                File elemFile2 = new File(elN2);
                if (elemFile2.exists()) {
                    int m;
                    Object[] opt = new Object[]{"OK", "Cancel"};
                    elN2 = elemFile2.getName();
                    if (dbg) {
                        System.out.println("   Warning: both \"" + elN + "\"" + nl + "  and \"" + elN2 + "\"" + nl + "  exist.");
                    }
                    if ((m = JOptionPane.showOptionDialog(parent, "Note:  both  \"" + elN + "\"" + nl + "and  \"" + elN2 + "\"  exist." + nl + nl + "Only file \"" + elN + "\" will be used." + nl + " ", "Warning", 0, 2, null, opt, opt[0])) != 0) {
                        if (dbg) {
                            System.out.println("Cancelled by the user");
                        }
                        return null;
                    }
                }
            }
        }
        return addFileEle;
    }

    public static void addFileEle_Read(boolean dbg, String addFileEle, ArrayList<String[]> elemCompAdd) throws AddDataException {
        if (dbg) {
            System.out.println("-- addFileEle_Read(..)");
        }
        if (addFileEle == null || addFileEle.length() <= 0) {
            throw new AddDataException("Programming error: \"addFileEle\"=null or empty in \"addFileEle_Read\"");
        }
        if (elemCompAdd == null) {
            throw new AddDataException("Programming error: \"elemCompAdd\"=null in \"addFileEle_Read\"");
        }
        elemCompAdd.clear();
        elemCompAdd.add(new String[]{"XX", "H2O", "water"});
        elemCompAdd.add(new String[]{"H", "H+", "hydrogen ion"});
        elemCompAdd.add(new String[]{"e-", "e-", "electron (= redox potential)"});
        File ef = new File(addFileEle);
        if (ef.exists()) {
            if (dbg) {
                System.out.println("Reading file \"" + ef.getName() + "\" in addFileEle_Read");
            }
            try {
                LibDB.readElemFileText(ef, elemCompAdd);
            }
            catch (LibDB.ReadElemException ex) {
                throw new AddDataException(ex.getMessage());
            }
        }
    }

    public static void addFileEle_Write(boolean dbg, String addFileEle, ArrayList<String[]> elemCompAdd) throws AddDataException {
        int i;
        int j;
        int n;
        PrintWriter pw;
        boolean ok;
        File tmpF;
        if (dbg) {
            System.out.println("-- addFileEle_Write(..)");
        }
        if (addFileEle == null || addFileEle.length() <= 0) {
            throw new AddDataException("Error: \"addFileEle\"=null or empty in \"addFileEle_Write\"");
        }
        if (elemCompAdd == null || elemCompAdd.size() <= 0) {
            throw new AddDataException("Error: \"elemCompAdd\"=null or empty in \"addFileEle_Write\"");
        }
        File wf = new File(addFileEle);
        if (wf.exists() && !wf.canWrite()) {
            throw new AddDataException("Error: can not write to file" + nl + "    \"" + addFileEle + "\"");
        }
        boolean replace = wf.exists();
        String addFileEleTmp = Div.getFileNameWithoutExtension((String)addFileEle) + "-" + Div.getFileNameExtension((String)addFileEle) + ".tmp";
        if (replace) {
            tmpF = new File(addFileEleTmp);
            if (tmpF.exists()) {
                try {
                    ok = tmpF.delete();
                }
                catch (Exception ex) {
                    throw new AddDataException(ex.getMessage());
                }
                if (!ok) {
                    throw new AddDataException("Could not delete file:" + nl + "\"" + addFileEleTmp + "\"");
                }
            }
        } else {
            tmpF = wf;
        }
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(tmpF)));
        }
        catch (IOException ex) {
            throw new AddDataException(ex.getMessage());
        }
        for (int i2 = 0; i2 < LibDB.elementName.length; ++i2) {
            int j2;
            n = 0;
            for (j2 = 0; j2 < elemCompAdd.size(); ++j2) {
                if (!elemCompAdd.get(j2)[0].equals(LibDB.elementSymb[i2])) continue;
                ++n;
            }
            if (n == 0) continue;
            pw.format("%-2s,%2d ,", LibDB.elementSymb[i2], n);
            for (j2 = 0; j2 < elemCompAdd.size(); ++j2) {
                if (!elemCompAdd.get(j2)[0].equals(LibDB.elementSymb[i2])) continue;
                pw.print(Complex.encloseInQuotes(elemCompAdd.get(j2)[1]) + ",");
                pw.print(Complex.encloseInQuotes(elemCompAdd.get(j2)[2]) + ",");
            }
            pw.println();
        }
        n = 0;
        for (j = 0; j < elemCompAdd.size(); ++j) {
            ok = false;
            for (i = 0; i < LibDB.elementName.length; ++i) {
                if (!elemCompAdd.get(j)[0].equals(LibDB.elementSymb[i])) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            ++n;
        }
        if (n > 0) {
            pw.format("%-2s,%2d ,", "XX", n);
            for (j = 0; j < elemCompAdd.size(); ++j) {
                ok = false;
                for (i = 0; i < LibDB.elementName.length; ++i) {
                    if (!elemCompAdd.get(j)[0].equals(LibDB.elementSymb[i])) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                pw.print(Complex.encloseInQuotes(elemCompAdd.get(j)[1]) + ",");
                pw.print(Complex.encloseInQuotes(elemCompAdd.get(j)[2]) + ",");
            }
            pw.println();
        }
        pw.close();
        if (replace) {
            String line = null;
            try {
                ok = wf.delete();
            }
            catch (Exception ex) {
                line = ex.getMessage() + nl;
                ok = false;
            }
            if (!ok || line != null) {
                if (line == null) {
                    line = "";
                }
                throw new AddDataException(line + "Could not delete file:" + nl + "\"" + addFileEle + "\"");
            }
            line = null;
            try {
                ok = tmpF.renameTo(wf);
            }
            catch (Exception ex) {
                line = ex.getMessage() + nl;
                ok = false;
            }
            if (!ok || line != null) {
                if (line == null) {
                    line = "";
                }
                throw new AddDataException(line + "Could not rename file:" + nl + "\"" + addFileEleTmp + "\"" + nl + "into: \"" + addFileEle + "\"");
            }
        }
    }

    public static synchronized void elemCompAdd_Update(boolean dbg, Component parent, String addFile, String addFileEle, ArrayList<String[]> elemComp, ArrayList<String[]> elemCompAdd) throws AddDataException {
        if (dbg) {
            System.out.println("-- elemCompAdd_Update(..)");
        }
        if (addFileEle == null || addFileEle.length() <= 0) {
            throw new AddDataException("Programming error: \"addFileEle\"=null or empty in \"elemCompAdd_Update\"");
        }
        if (elemComp == null) {
            throw new AddDataException("Programming error: \"elemComp\"=null in \"elemCompAdd_Update\"");
        }
        if (elemCompAdd == null) {
            elemCompAdd = new ArrayList();
        } else {
            elemCompAdd.clear();
        }
        AddDataElem.addFileEle_Read(dbg, addFileEle, elemCompAdd);
        File afE = new File(addFileEle);
        if (!afE.exists()) {
            try {
                AddDataElem.addFileEle_Write(dbg, addFileEle, elemCompAdd);
            }
            catch (AddDataException ex) {
                throw new AddDataException(ex.getMessage());
            }
        }
        if (addFile == null || addFile.length() <= 0) {
            return;
        }
        File afF = new File(addFile);
        if (!afF.exists()) {
            return;
        }
        if (!afF.canRead()) {
            throw new AddDataException("Error: can not open file" + nl + "    \"" + addFile + "\".");
        }
        if (dbg) {
            System.out.println("  reading file \"" + afF.getName() + "\" to search for missing components");
        }
        ArrayList<String> items = new ArrayList<String>();
        int cmplxNbr = 0;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(afF));
            while ((line = br.readLine()) != null) {
                Complex c;
                ++cmplxNbr;
                if (line.length() <= 0 || line.toUpperCase().startsWith("COMPLEX") || line.startsWith("@")) continue;
                try {
                    c = Complex.fromString(line);
                }
                catch (Complex.ReadComplexException ex) {
                    Util.msg((String)ex.getMessage());
                    break;
                }
                if (c == null) continue;
                for (int i = 0; i < 6; ++i) {
                    int j;
                    if (c.component[i] == null || c.component[i].length() <= 0 || !(Math.abs(c.numcomp[i]) >= 0.001)) continue;
                    boolean fnd = false;
                    for (j = 0; j < elemCompAdd.size(); ++j) {
                        if (!((String[])elemCompAdd.get(j))[1].equals(c.component[i])) continue;
                        fnd = true;
                        break;
                    }
                    if (fnd) continue;
                    for (j = 0; j < elemComp.size(); ++j) {
                        if (!elemComp.get(j)[1].equals(c.component[i])) continue;
                        boolean there = false;
                        for (String t : items) {
                            if (!t.equals(elemComp.get(j)[1])) continue;
                            there = true;
                            break;
                        }
                        if (!there) {
                            items.add(elemComp.get(j)[1]);
                        }
                        String[] s = new String[]{elemComp.get(j)[0], elemComp.get(j)[1], elemComp.get(j)[2]};
                        elemCompAdd.add(s);
                    }
                }
            }
        }
        catch (IOException ex) {
            String msg = ex.getMessage() + nl + "reading line " + cmplxNbr + nl + "in file: \"" + addFile + "\"";
            if (dbg) {
                System.out.println("Error " + msg);
            }
            items.clear();
            throw new AddDataException(msg);
        }
        finally {
            if (dbg) {
                System.out.println("  elemCompAdd_Update() finished reading \"" + afF.getName() + "\"");
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                items.clear();
                String msg = ex.getMessage() + nl + "with file: \"" + addFile + "\"";
                throw new AddDataException(msg);
            }
        }
        if (items.size() <= 0) {
            return;
        }
        DefaultListModel<Object> aModel = new DefaultListModel<Object>();
        Collections.sort(items, String.CASE_INSENSITIVE_ORDER);
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            aModel.addElement(AddDataElem.makeObj((String)iter.next()));
        }
        String msg = "<html>The following reactant";
        if (aModel.size() > 1) {
            msg = msg + "s";
        }
        msg = msg + "<br>will be written to file<br>\"" + afE.getName() + "\".<br>&nbsp;</html>";
        JLabel aLabel = new JLabel(msg);
        JList aList = new JList(aModel);
        aList.setSelectionMode(0);
        aList.setVisibleRowCount(5);
        JScrollPane aScrollPane = new JScrollPane();
        aScrollPane.setViewportView(aList);
        aList.setFocusable(false);
        Object[] o = new Object[]{aLabel, aScrollPane};
        JOptionPane.showMessageDialog(parent, o, "Writing: Elements - Components", 1);
        AddDataElem.addFileEle_Write(dbg, addFileEle, elemCompAdd);
    }

    public static void addFileEle_ComponentDelete(boolean dbg, String compName, String addFileEle, ArrayList<String[]> elemCompAdd) throws AddDataException {
        if (dbg) {
            System.out.println("-- addFileEle_ComponentDelete(" + compName + " ..)");
        }
        if (compName == null || compName.trim().length() <= 0) {
            return;
        }
        String compDel = compName.trim();
        ArrayList<String[]> elemCompAdd0 = new ArrayList<String[]>(elemCompAdd);
        int i = 0;
        while (i < elemCompAdd.size()) {
            if (compDel.equals(elemCompAdd.get(i)[1])) {
                elemCompAdd.remove(i);
                continue;
            }
            ++i;
        }
        try {
            AddDataElem.addFileEle_Write(dbg, addFileEle, elemCompAdd);
        }
        catch (AddDataException ex) {
            elemCompAdd.clear();
            for (i = 0; i < elemCompAdd0.size(); ++i) {
                elemCompAdd.add(elemCompAdd0.get(i));
            }
            throw new AddDataException(ex.getMessage());
        }
    }

    public static boolean addFileEle_ComponentSave(boolean dbg, Component parent, String newComp, String linkedTo, String descr, String addFile, String addFileEle, ArrayList<String[]> elemComp, ArrayList<String[]> elemCompAdd) throws AddDataException {
        ArrayList<String> aL;
        Object[] opt;
        if (dbg) {
            System.out.println("-- addFileEle_ComponentSave()");
        }
        boolean fnd = false;
        String linkedToOld = "";
        for (int i = 0; i < elemCompAdd.size(); ++i) {
            if (!newComp.equals(elemCompAdd.get(i)[1])) continue;
            fnd = true;
            if (linkedToOld.indexOf(elemCompAdd.get(i)[0]) >= 0) continue;
            if (linkedToOld.length() > 0) {
                linkedToOld = linkedToOld + ", ";
            }
            linkedToOld = linkedToOld + elemCompAdd.get(i)[0];
        }
        String msg = fnd ? "Replace:" + nl + "  \"" + newComp + "\" linked to: " + linkedToOld + nl + nl + "with:" + nl + "   \"" + newComp + "\" linked to: " + linkedTo : "Add component \"" + newComp + "\"" + nl + "linked to: " + linkedTo + " ?";
        int m = JOptionPane.showOptionDialog(parent, msg, "Writing: Elements - Components", 0, 2, null, opt = new Object[]{"Yes", "Cancel"}, opt[1]);
        if (m != 0) {
            return false;
        }
        AddDataElem.elemCompAdd_Update(dbg, parent, addFile, addFileEle, elemComp, elemCompAdd);
        ArrayList<String[]> elemCompAdd0 = new ArrayList<String[]>(elemCompAdd);
        if (fnd) {
            int i = 0;
            while (i < elemCompAdd.size()) {
                if (newComp.equals(elemCompAdd.get(i)[1])) {
                    elemCompAdd.remove(i);
                    continue;
                }
                ++i;
            }
        }
        try {
            aL = CSVparser.splitLine(linkedTo);
        }
        catch (CSVparser.CSVdataException ex) {
            elemCompAdd.clear();
            for (int i = 0; i < elemCompAdd0.size(); ++i) {
                elemCompAdd.add(elemCompAdd0.get(i));
            }
            throw new AddDataException(ex.getMessage());
        }
        for (int i = 0; i < aL.size(); ++i) {
            String[] s = new String[]{aL.get(i), newComp, descr};
            elemCompAdd.add(s);
        }
        try {
            AddDataElem.addFileEle_Write(dbg, addFileEle, elemCompAdd);
        }
        catch (AddDataException ex) {
            elemCompAdd.clear();
            for (int i = 0; i < elemCompAdd0.size(); ++i) {
                elemCompAdd.add(elemCompAdd0.get(i));
            }
            throw new AddDataException(ex.getMessage());
        }
        return true;
    }

    private static Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    public static class AddDataException
    extends Exception {
        public AddDataException() {
        }

        public AddDataException(String txt) {
            super(txt);
        }
    }
}

