/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2D;
import org.qenherkhopeshef.graphics.generic.StreamGraphicsConfiguration;
import org.qenherkhopeshef.graphics.svg.SVGLowLevel;
import org.qenherkhopeshef.graphics.utils.DoubleDimensions;

public class SVGGraphics2D
extends BaseGraphics2D {
    SVGLowLevel svgOut;
    private float currentLineWidth;
    private Dimension2D dimensions;
    private double precision = 0.05;
    private boolean closeOnDispose;

    public SVGGraphics2D(File f, Dimension2D dims) throws IOException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"), dims);
    }

    public SVGGraphics2D(String fname, Dimension2D dims) throws IOException {
        this(new File(fname), dims);
    }

    public SVGGraphics2D(Writer writer, Dimension2D dims) throws IOException {
        this.closeOnDispose = true;
        this.dimensions = new DoubleDimensions(dims.getWidth(), dims.getHeight());
        this.svgOut = new SVGLowLevel(writer, this.dimensions);
        this.setFont(new Font("SansSerif", 0, 12));
    }

    private SVGGraphics2D(SVGGraphics2D g) {
        super(g);
        this.dimensions = g.dimensions;
        this.svgOut = g.svgOut;
        this.closeOnDispose = false;
    }

    public void draw(Shape shape) {
        try {
            if (shape instanceof Line2D) {
                Line2D l = (Line2D)shape;
                Point2D a = this.deviceCoords(l.getP1());
                Point2D b = this.deviceCoords(l.getP2());
                this.svgOut.drawLine(a.getX(), a.getY(), b.getX(), b.getY());
            } else {
                this.addPath(shape);
                this.svgOut.setForeground(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue(), this.getColor().getAlpha());
                this.svgOut.setBackground(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue(), this.getBackground().getAlpha());
                this.svgOut.drawPath();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addPath(Shape shape) {
        this.svgOut.startPath();
        PathIterator iter = shape.getPathIterator(null);
        Point2D first = null;
        while (!iter.isDone()) {
            double[] coords = new double[6];
            int type = iter.currentSegment(coords);
            Point2D[] points = this.getPointsInDeviceSpace(coords);
            switch (type) {
                case 4: {
                    this.svgOut.closePath();
                    break;
                }
                case 3: {
                    this.svgOut.cubicTo(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY());
                    break;
                }
                case 1: {
                    this.svgOut.lineTo(points[0].getX(), points[0].getY());
                    break;
                }
                case 0: {
                    first = points[0];
                    this.svgOut.moveTo(first.getX(), first.getY());
                    break;
                }
                case 2: {
                    this.svgOut.quadTo(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY());
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected constant in path iterator");
                }
            }
            iter.next();
        }
    }

    public void fill(Shape shape) {
        this.addPath(shape);
        try {
            this.svgOut.setForeground(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue(), this.getColor().getAlpha());
            this.svgOut.setBackground(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue(), this.getBackground().getAlpha());
            this.svgOut.fillPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public void setStroke(Stroke stroke) {
        super.setStroke(stroke);
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            this.currentLineWidth = bs.getLineWidth();
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Graphics create() {
        return new SVGGraphics2D(this);
    }

    public void dispose() {
        try {
            if (this.closeOnDispose && this.svgOut != null) {
                this.svgOut.close();
                this.svgOut = null;
            } else {
                this.svgOut = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new StreamGraphicsConfiguration(new Rectangle(0, 0, 10000, 10000), new AffineTransform());
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.getTransform(), false, true);
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public void setProperties(Properties properties) {
    }

    private Point2D deviceCoords(Point2D p) {
        Point2D.Double res = new Point2D.Double();
        this.getTransform().transform(p, res);
        return res;
    }

    private Point2D[] getPointsInDeviceSpace(double[] coords) {
        Point2D[] points = new Point2D[coords.length / 2];
        for (int i = 0; i < points.length; ++i) {
            Point2D.Double p = new Point2D.Double(coords[i * 2], coords[i * 2 + 1]);
            points[i] = this.deviceCoords(p);
        }
        return points;
    }
}

